/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.model.XmlModelAttribute;

public class GUIXmlAttributePanel
extends JPanel {
    private GUIFrame appObject;
    private JButton okBtn;
    private JButton cancelBtn;
    private Vector attrList;
    private Vector requiredList;
    private Vector impliedList;
    private GUIGridPanel gridPane;
    private String retString;
    private String elementName;
    private String panelName;

    public GUIXmlAttributePanel(GUIFrame obj, String elementName, Vector attrList) {
        this.appObject = obj;
        this.elementName = elementName;
        this.panelName = "\u57fa\u672c\u5c5e\u6027";
        this.attrList = attrList;
        this.paramInitialize();
        this.setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        this.add((Component)cPan, "Center");
    }

    private void paramInitialize() {
        this.requiredList = new Vector();
        this.impliedList = new Vector();
        for (int i = 0; i < this.attrList.size(); ++i) {
            XmlModelAttribute model = (XmlModelAttribute)this.attrList.get(i);
            if (model.getRequired()) {
                JLabel label = new JLabel(model.getName());
                model.setComponent(label);
                this.requiredList.add(model);
                continue;
            }
            JCheckBox checkBox = new JCheckBox(model.getName());
            model.setComponent(checkBox);
            this.impliedList.add(model);
        }
    }

    private JPanel createContentsPanel() {
        JComponent comp;
        XmlModelAttribute model;
        int y = 0;
        this.gridPane = new GUIGridPanel();
        int i = 0;
        while (i < this.requiredList.size()) {
            model = (XmlModelAttribute)this.requiredList.get(i);
            comp = this.creatAttributeComponent(model);
            this.gridPane.gridLayoutComponent(model.getComponent(), 0, y);
            this.gridPane.gridLayoutComponent(comp, 1, y);
            ++i;
            ++y;
        }
        i = 0;
        while (i < this.impliedList.size()) {
            model = (XmlModelAttribute)this.impliedList.get(i);
            comp = this.creatAttributeComponent(model);
            this.gridPane.gridLayoutComponent(model.getComponent(), 0, y);
            this.gridPane.gridLayoutComponent(comp, 1, y);
            comp.setEnabled(false);
            this.addAction((JCheckBox)model.getComponent());
            ++i;
            ++y;
        }
        return this.gridPane;
    }

    private JComponent creatAttributeComponent(XmlModelAttribute model) {
        JComponent comp = null;
        switch (model.getComboBox()) {
            case 1: {
                JComboBox box = new JComboBox(model.getCaseValue());
                box.setEditable(true);
                comp = box;
                break;
            }
            case 2: {
                JComboBox box2;
                comp = box2 = new JComboBox(model.getCaseValue());
                break;
            }
            default: {
                JTextField field = new JTextField(30);
                String value = model.getValue();
                if (value != null) {
                    field.setText(value);
                }
                comp = field;
            }
        }
        return comp;
    }

    private void addAction(JCheckBox checkBox) {
        checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GUIXmlAttributePanel.this.actionCheckBoxItem((Component)e.getSource());
            }
        });
    }

    private void actionCheckBoxItem(Component comp) {
        int idx = -1;
        for (int i = 0; i < this.gridPane.getComponentCount(); ++i) {
            if (!comp.equals(this.gridPane.getComponent(i))) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return;
        }
        if (((JCheckBox)comp).isSelected()) {
            this.gridPane.getComponent(idx + 1).setEnabled(true);
            this.gridPane.getComponent(idx + 1).requestFocusInWindow();
        } else {
            this.gridPane.getComponent(idx + 1).setEnabled(false);
        }
    }

    private void setString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.gridPane.getComponentCount(); i += 2) {
            Component comp1 = this.gridPane.getComponent(i);
            Component comp2 = this.gridPane.getComponent(i + 1);
            if (comp1.getClass().getName().equals("javax.swing.JLabel")) {
                buff.append(" " + ((JLabel)comp1).getText() + "=");
                if (comp2.getClass().getName().equals("javax.swing.JTextField")) {
                    buff.append("\"" + ((JTextField)comp2).getText() + "\"");
                    continue;
                }
                if (!comp2.getClass().getName().equals("javax.swing.JComboBox")) continue;
                buff.append("\"" + (String)((JComboBox)comp2).getSelectedItem() + "\"");
                continue;
            }
            if (!((JCheckBox)comp1).isSelected()) continue;
            buff.append(" " + ((JCheckBox)comp1).getText() + "=");
            if (comp2.getClass().getName().equals("javax.swing.JTextField")) {
                buff.append("\"" + ((JTextField)comp2).getText() + "\"");
                continue;
            }
            if (!comp2.getClass().getName().equals("javax.swing.JComboBox")) continue;
            buff.append("\"" + (String)((JComboBox)comp2).getSelectedItem() + "\"");
        }
        this.retString = buff.toString();
    }

    public String getString() {
        this.setString();
        return this.retString;
    }

    public String getName() {
        return this.elementName;
    }

    public String getTitle() {
        return this.panelName;
    }

    public void setTitle(String title) {
        this.panelName = title;
    }
}

