/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.util.ResourceUtil;

public class GUIPageDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private JButton okBtn;
    private JButton cancelBtn;
    private JComboBox paperSizeBox;
    private JTextField fontSizeField;
    private JRadioButton paperOperationPortraitBtn;
    private JRadioButton paperOperationLandscapeBtn;
    private JTextField topMarginField;
    private JTextField bottomMarginField;
    private JTextField leftMarginField;
    private JTextField rightMarginField;
    private JCheckBox lineNumberBtn;
    private JCheckBox headerBtn;
    private JCheckBox footerBtn;

    public GUIPageDialog(GUIFrame obj) {
        super((Frame)null, "\u30da\u30fc\u30b8\u8a2d\u5b9a", true);
        this.appObject = obj;
        this.initComponent();
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    private void initComponent() {
        MediaSizeName[] paper = new MediaSizeName[]{MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5};
        this.paperSizeBox = new JComboBox<MediaSizeName>(paper);
        this.paperSizeBox.setSelectedItem(ResourceUtil.getPrintPaperSize());
        this.fontSizeField = new JTextField(String.valueOf(ResourceUtil.getPrintFontSize()), 5);
        this.paperOperationPortraitBtn = new JRadioButton("\u7e31\u7f6e\u304d");
        this.paperOperationLandscapeBtn = new JRadioButton("\u6a2a\u7f6e\u304d");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.paperOperationPortraitBtn);
        bg.add(this.paperOperationLandscapeBtn);
        if (ResourceUtil.getPrintPaperOperation() == 1) {
            this.paperOperationPortraitBtn.setSelected(true);
        } else {
            this.paperOperationLandscapeBtn.setSelected(true);
        }
        this.topMarginField = new JTextField(String.valueOf(ResourceUtil.getPrintTopMargin()), 5);
        this.bottomMarginField = new JTextField(String.valueOf(ResourceUtil.getPrintBottomMargin()), 5);
        this.leftMarginField = new JTextField(String.valueOf(ResourceUtil.getPrintLeftMargin()), 5);
        this.rightMarginField = new JTextField(String.valueOf(ResourceUtil.getPrintRightMargin()), 5);
        this.lineNumberBtn = new JCheckBox("\u884c\u756a\u53f7\u3092\u5370\u5237\u3059\u308b", ResourceUtil.getPrintLineNumber());
        this.headerBtn = new JCheckBox("\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5370\u5237\u3059\u308b", ResourceUtil.getPrintHeader());
        this.footerBtn = new JCheckBox("\u30da\u30fc\u30b8\u756a\u53f7\u3092\u5370\u5237\u3059\u308b", ResourceUtil.getPrintFooter());
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIPageDialog.this.pageSetting();
                GUIPageDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIPageDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private JPanel createContentsPanel() {
        GUIGridPanel pan = new GUIGridPanel();
        pan.gridLayoutComponent(new JLabel("\u7528\u7d19", 4), 0, 0);
        pan.gridLayoutComponent(this.paperSizeBox, 1, 0);
        pan.gridLayoutComponent(new JLabel("\u6587\u5b57\u30b5\u30a4\u30ba", 4), 0, 1);
        pan.gridLayoutComponent(this.fontSizeField, 1, 1);
        pan.gridLayoutComponent(new JLabel("\u7528\u7d19\u65b9\u5411", 4), 0, 2);
        pan.gridLayoutComponent(this.paperOperationPortraitBtn, 1, 2);
        pan.gridLayoutComponent(this.paperOperationLandscapeBtn, 2, 2);
        pan.gridLayoutComponent(new JLabel("\u4e0a\u4f59\u767d", 4), 0, 3);
        pan.gridLayoutComponent(this.topMarginField, 1, 3);
        pan.gridLayoutComponent(new JLabel("\u4e0b\u4f59\u767d", 4), 2, 3);
        pan.gridLayoutComponent(this.bottomMarginField, 3, 3);
        pan.gridLayoutComponent(new JLabel("\u5de6\u4f59\u767d", 4), 0, 4);
        pan.gridLayoutComponent(this.leftMarginField, 1, 4);
        pan.gridLayoutComponent(new JLabel("\u53f3\u4f59\u767d", 4), 2, 4);
        pan.gridLayoutComponent(this.rightMarginField, 3, 4);
        pan.setWidth(2);
        pan.gridLayoutComponent(this.lineNumberBtn, 0, 5);
        pan.gridLayoutComponent(this.headerBtn, 0, 6);
        pan.gridLayoutComponent(this.footerBtn, 0, 7);
        return pan;
    }

    private void pageSetting() {
        ResourceUtil.setPrintPaperSize((MediaSizeName)this.paperSizeBox.getSelectedItem());
        ResourceUtil.setPrintFontSize(this.fontSizeField.getText());
        if (this.paperOperationPortraitBtn.isSelected()) {
            ResourceUtil.setPrintPaperOperation(1);
        } else {
            ResourceUtil.setPrintPaperOperation(0);
        }
        ResourceUtil.setPrintTopMargin(this.topMarginField.getText());
        ResourceUtil.setPrintBottomMargin(this.bottomMarginField.getText());
        ResourceUtil.setPrintLeftMargin(this.leftMarginField.getText());
        ResourceUtil.setPrintRightMargin(this.rightMarginField.getText());
        ResourceUtil.setPrintLineNumber(this.lineNumberBtn.isSelected());
        ResourceUtil.setPrintHeader(this.headerBtn.isSelected());
        ResourceUtil.setPrintFooter(this.footerBtn.isSelected());
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

