/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.gui.GUIView;
import jp.sourceforge.jhime.pectin.util.ResourceUtil;

public class GUIOptionDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private JButton okBtn;
    private JButton cancelBtn;
    private JTextField fontSizeField = new JTextField(3);
    private JTextField tabSizeField = new JTextField(3);
    private JTextField colorField = new JTextField(5);
    private JButton colorBtn = new JButton("\u8272\u306e\u53c2\u7167");
    private JTextField backgroundField = new JTextField(5);
    private JButton backgroundBtn = new JButton("\u8272\u306e\u53c2\u7167");
    private JRadioButton unixBtn = new JRadioButton("Unix(LF)", true);
    private JRadioButton macBtn = new JRadioButton("Machintosh(CR)");
    private JRadioButton winBtn = new JRadioButton("Windows(CR/LF)");
    private JTextField highlightXmlField = new JTextField(5);
    private JButton highlightXmlBtn = new JButton("\u8272\u306e\u53c2\u7167");
    private JTextField highlightEmptyField = new JTextField(5);
    private JButton highlightEmptyBtn = new JButton("\u8272\u306e\u53c2\u7167");
    private JTextField highlightTagField = new JTextField(5);
    private JButton highlightTagBtn = new JButton("\u8272\u306e\u53c2\u7167");
    private JComboBox lookAndFeelBox = new JComboBox();
    private int colorRGB;
    private int backgroundRGB;
    private int highlightXmlRGB;
    private int highlightEmptyRGB;
    private int highlightTagRGB;
    private String lookAndFeel;

    public GUIOptionDialog(GUIFrame obj) {
        super((Frame)null, "\u74b0\u5883\u8a2d\u5b9a", true);
        this.appObject = obj;
        this.paramInitialize();
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIOptionDialog.this.setResource();
                GUIOptionDialog.this.changeText();
                GUIOptionDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIOptionDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.fontSizeField.setText(String.valueOf(ResourceUtil.getFontSize()));
        this.tabSizeField.setText(String.valueOf(ResourceUtil.getTabSize()));
        this.colorRGB = ResourceUtil.getColor();
        this.colorField.setBackground(new Color(this.colorRGB));
        this.backgroundRGB = ResourceUtil.getBackground();
        this.backgroundField.setBackground(new Color(this.backgroundRGB));
        String endOfLine = ResourceUtil.getEndOfLine();
        if (endOfLine.equals("UNIX")) {
            this.unixBtn.setSelected(true);
            this.macBtn.setSelected(false);
            this.winBtn.setSelected(false);
        } else if (endOfLine.equals("MAC")) {
            this.unixBtn.setSelected(false);
            this.macBtn.setSelected(true);
            this.winBtn.setSelected(false);
        } else if (endOfLine.equals("WIN")) {
            this.unixBtn.setSelected(false);
            this.macBtn.setSelected(false);
            this.winBtn.setSelected(true);
        }
        this.highlightXmlRGB = ResourceUtil.getHighlightXml();
        this.highlightXmlField.setText(" <!Sample ");
        this.highlightXmlField.setEditable(false);
        this.setHighlight(this.highlightXmlField, this.highlightXmlRGB);
        this.highlightEmptyRGB = ResourceUtil.getHighlightEmpty();
        this.highlightEmptyField.setText(" <empty/> ");
        this.highlightEmptyField.setEditable(false);
        this.setHighlight(this.highlightEmptyField, this.highlightEmptyRGB);
        this.highlightTagRGB = ResourceUtil.getHighlightTag();
        this.highlightTagField.setText(" <a></a> ");
        this.highlightTagField.setEditable(false);
        this.setHighlight(this.highlightTagField, this.highlightTagRGB);
        this.lookAndFeel = ResourceUtil.getLookAndFeel();
        this.lookAndFeelBox.addItem(this.lookAndFeel);
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < info.length; ++i) {
            String laf = info[i].getClassName();
            if (laf.equals(this.lookAndFeel)) continue;
            this.lookAndFeelBox.addItem(laf);
        }
    }

    private void setHighlight(JTextField field, int color) {
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(new Color(color, true));
        try {
            Highlighter hilite = field.getHighlighter();
            Highlighter.Highlight[] hilites = hilite.getHighlights();
            for (int i = 0; i < hilites.length; ++i) {
                if (!(hilites[i].getPainter() instanceof DefaultHighlighter.DefaultHighlightPainter)) continue;
                hilite.removeHighlight(hilites[i]);
            }
            Document doc = field.getDocument();
            hilite.addHighlight(0, doc.getLength(), painter);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private JPanel createContentsPanel() {
        this.addAction();
        this.colorField.setEditable(false);
        this.backgroundField.setEditable(false);
        GUIGridPanel pan = new GUIGridPanel();
        pan.gridLayoutComponent(new JLabel("\u6587\u5b57\u30b5\u30a4\u30ba"), 0, 0);
        pan.gridLayoutComponent(this.fontSizeField, 1, 0);
        pan.gridLayoutComponent(new JLabel("\u30bf\u30d6\u5e45"), 0, 1);
        pan.gridLayoutComponent(this.tabSizeField, 1, 1);
        pan.gridLayoutComponent(new JLabel("\u6587\u5b57\u8272"), 0, 2);
        pan.gridLayoutComponent(this.colorField, 1, 2);
        pan.gridLayoutComponent(this.colorBtn, 2, 2);
        pan.gridLayoutComponent(new JLabel("\u80cc\u666f\u8272"), 0, 3);
        pan.gridLayoutComponent(this.backgroundField, 1, 3);
        pan.gridLayoutComponent(this.backgroundBtn, 2, 3);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.unixBtn);
        bg.add(this.macBtn);
        bg.add(this.winBtn);
        pan.setWidth(2);
        pan.gridLayoutComponent(new JLabel("\u65b0\u898f\u6587\u66f8\u306e\u884c\u672b\u30b3\u30fc\u30c9"), 0, 4);
        pan.setWidth(1);
        pan.gridLayoutComponent(this.unixBtn, 2, 4);
        pan.gridLayoutComponent(this.macBtn, 3, 4);
        pan.gridLayoutComponent(this.winBtn, 4, 4);
        pan.setWidth(2);
        pan.gridLayoutComponent(new JLabel("XML\u5ba3\u8a00\u306a\u3069\u306e\u30cf\u30a4\u30e9\u30a4\u30c8\u8272"), 0, 5);
        pan.setWidth(1);
        pan.gridLayoutComponent(this.highlightXmlField, 2, 5);
        pan.gridLayoutComponent(this.highlightXmlBtn, 3, 5);
        pan.setWidth(2);
        pan.gridLayoutComponent(new JLabel("\u7a7a\u30bf\u30b0\u306a\u3069\u306e\u30cf\u30a4\u30e9\u30a4\u30c8\u8272"), 0, 6);
        pan.setWidth(1);
        pan.gridLayoutComponent(this.highlightEmptyField, 2, 6);
        pan.gridLayoutComponent(this.highlightEmptyBtn, 3, 6);
        pan.setWidth(2);
        pan.gridLayoutComponent(new JLabel("\u305d\u306e\u4ed6\u306e\u30bf\u30b0\u306e\u30cf\u30a4\u30e9\u30a4\u30c8\u8272"), 0, 7);
        pan.setWidth(1);
        pan.gridLayoutComponent(this.highlightTagField, 2, 7);
        pan.gridLayoutComponent(this.highlightTagBtn, 3, 7);
        pan.setWidth(1);
        pan.gridLayoutComponent(new JLabel("Look & Feel"), 0, 8);
        pan.setWidth(4);
        pan.gridLayoutComponent(this.lookAndFeelBox, 1, 8);
        return pan;
    }

    private void addAction() {
        this.colorField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent().equals(GUIOptionDialog.this.colorBtn)) {
                    GUIOptionDialog.this.tabSizeField.requestFocusInWindow();
                } else {
                    GUIOptionDialog.this.colorBtn.requestFocusInWindow();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.backgroundField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent().equals(GUIOptionDialog.this.backgroundBtn)) {
                    GUIOptionDialog.this.colorBtn.requestFocusInWindow();
                } else {
                    GUIOptionDialog.this.backgroundBtn.requestFocusInWindow();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.highlightXmlField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent().equals(GUIOptionDialog.this.highlightXmlBtn)) {
                    GUIOptionDialog.this.winBtn.requestFocusInWindow();
                } else {
                    GUIOptionDialog.this.highlightXmlBtn.requestFocusInWindow();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.highlightEmptyField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent().equals(GUIOptionDialog.this.highlightEmptyBtn)) {
                    GUIOptionDialog.this.highlightXmlBtn.requestFocusInWindow();
                } else {
                    GUIOptionDialog.this.highlightEmptyBtn.requestFocusInWindow();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.highlightTagField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent().equals(GUIOptionDialog.this.highlightTagBtn)) {
                    GUIOptionDialog.this.highlightEmptyBtn.requestFocusInWindow();
                } else {
                    GUIOptionDialog.this.highlightTagBtn.requestFocusInWindow();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.colorBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(GUIOptionDialog.this, "\u6587\u5b57\u8272\u306e\u8a2d\u5b9a", new Color(GUIOptionDialog.this.colorRGB));
                if (color != null) {
                    GUIOptionDialog.this.colorRGB = color.getRGB();
                    GUIOptionDialog.this.colorField.setBackground(new Color(GUIOptionDialog.this.colorRGB));
                }
            }
        });
        this.backgroundBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(GUIOptionDialog.this, "\u80cc\u666f\u8272\u306e\u8a2d\u5b9a", new Color(GUIOptionDialog.this.backgroundRGB));
                if (color != null) {
                    GUIOptionDialog.this.backgroundRGB = color.getRGB();
                    GUIOptionDialog.this.backgroundField.setBackground(new Color(GUIOptionDialog.this.backgroundRGB));
                }
            }
        });
        this.highlightXmlBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(GUIOptionDialog.this, "<!\u30cf\u30a4\u30e9\u30a4\u30c8\u8272\u306e\u8a2d\u5b9a", new Color(GUIOptionDialog.this.highlightXmlRGB, true));
                if (color != null) {
                    GUIOptionDialog.this.highlightXmlRGB = color.getRGB();
                    GUIOptionDialog.this.setHighlight(GUIOptionDialog.this.highlightXmlField, GUIOptionDialog.this.highlightXmlRGB);
                }
            }
        });
        this.highlightEmptyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(GUIOptionDialog.this, "\u7a7a\u30bf\u30b0\u30cf\u30a4\u30e9\u30a4\u30c8\u8272\u306e\u8a2d\u5b9a", new Color(GUIOptionDialog.this.highlightEmptyRGB, true));
                if (color != null) {
                    GUIOptionDialog.this.highlightEmptyRGB = color.getRGB();
                    GUIOptionDialog.this.setHighlight(GUIOptionDialog.this.highlightEmptyField, GUIOptionDialog.this.highlightEmptyRGB);
                }
            }
        });
        this.highlightTagBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(GUIOptionDialog.this, "\u958b\u59cb\u7d42\u4e86\u30bf\u30b0\u30cf\u30a4\u30e9\u30a4\u30c8\u8272\u306e\u8a2d\u5b9a", new Color(GUIOptionDialog.this.highlightTagRGB, true));
                if (color != null) {
                    GUIOptionDialog.this.highlightTagRGB = color.getRGB();
                    GUIOptionDialog.this.setHighlight(GUIOptionDialog.this.highlightTagField, GUIOptionDialog.this.highlightTagRGB);
                }
            }
        });
        this.lookAndFeelBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GUIOptionDialog.this.lookAndFeel = (String)GUIOptionDialog.this.lookAndFeelBox.getSelectedItem();
            }
        });
    }

    private void setResource() {
        ResourceUtil.setFontSize(this.fontSizeField.getText());
        ResourceUtil.setTabSize(this.tabSizeField.getText());
        ResourceUtil.setColor(this.colorRGB);
        ResourceUtil.setBackground(this.backgroundRGB);
        String endOfLine = "WIN";
        if (this.unixBtn.isSelected()) {
            endOfLine = "UNIX";
        } else if (this.macBtn.isSelected()) {
            endOfLine = "MAC";
        }
        ResourceUtil.setEndOfLine(endOfLine);
        ResourceUtil.setHighlightXml(this.highlightXmlRGB);
        ResourceUtil.setHighlightEmpty(this.highlightEmptyRGB);
        ResourceUtil.setHighlightTag(this.highlightTagRGB);
        ResourceUtil.setLookAndFeel(this.lookAndFeel);
    }

    private void changeText() {
        try {
            String defLaf = UIManager.getLookAndFeel().getClass().getName();
            if (!defLaf.equals(this.lookAndFeel)) {
                UIManager.setLookAndFeel(this.lookAndFeel);
                Frame[] frames = Frame.getFrames();
                for (int i = 0; i < frames.length; ++i) {
                    SwingUtilities.updateComponentTreeUI(frames[i]);
                }
                SwingUtilities.updateComponentTreeUI(this.appObject.getFindDialog());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int n = this.appObject.getViewCount();
        for (int i = 0; i < n; ++i) {
            GUIView view = this.appObject.getView(i);
            view.textAreaSetFormat();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

