/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.jhime.pectin.io.FileIOFilter;

public class GUIFileChooser
extends JFileChooser {
    private static final String[] ENCODING_STR = new String[]{"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
    private JRadioButton[] encodingBtn = new JRadioButton[ENCODING_STR.length];

    public GUIFileChooser() {
        super(System.getProperty("user.dir"));
        this.setAccessory(this.createEncodingPanel());
        FileFilter fl = this.getFileFilter();
        this.addChoosableFileFilter(new FileIOFilter("xml_g"));
        this.addChoosableFileFilter(new FileIOFilter("xsl_g"));
        this.setFileFilter(fl);
    }

    private JPanel createEncodingPanel() {
        JPanel encodingPane = new JPanel(new GridLayout(ENCODING_STR.length, 1));
        encodingPane.setBorder(BorderFactory.createLoweredBevelBorder());
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < ENCODING_STR.length; ++i) {
            this.encodingBtn[i] = i == 0 ? new JRadioButton(ENCODING_STR[i], true) : new JRadioButton(ENCODING_STR[i]);
            encodingPane.add(this.encodingBtn[i]);
            bg.add(this.encodingBtn[i]);
        }
        JPanel pane = new JPanel(new BorderLayout(2, 2));
        pane.add((Component)new JLabel(" "), "West");
        pane.add((Component)new JLabel(" "), "East");
        pane.add((Component)new JLabel("\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0", 0), "North");
        pane.add((Component)encodingPane, "Center");
        return pane;
    }

    public String getEncoding() {
        String encoding = null;
        for (int i = 0; i < ENCODING_STR.length; ++i) {
            if (!this.encodingBtn[i].isSelected()) continue;
            encoding = ENCODING_STR[i];
            break;
        }
        return encoding;
    }

    public void approveSelection() {
        super.approveSelection();
        String dir = this.getCurrentDirectory().getPath();
        System.setProperty("user.dir", dir);
    }
}

