/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sourceforge.jhime.pectin.gui.GUICodeDocumentDialog;
import jp.sourceforge.jhime.pectin.gui.GUICodeGroupDialog;
import jp.sourceforge.jhime.pectin.gui.GUICodeTemplateDialog;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.model.XmlModelCode;
import jp.sourceforge.jhime.pectin.model.XmlModelDocument;
import jp.sourceforge.jhime.pectin.model.XmlModelGroup;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentCode;

public class GUICodeDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private XMLDocument xmlDoc;
    private JButton okBtn;
    private JComboBox documentBox;
    private JList groupList;
    private DefaultListModel groupModel;
    private JList templateList;
    private DefaultListModel templateModel;
    private JTextArea templateArea;
    private JButton docAppendBtn;
    private JButton docRemoveBtn;
    private JButton docUpdateBtn;
    private JButton grpAppendBtn;
    private JButton grpRemoveBtn;
    private JButton grpUpdateBtn;
    private JButton grpUpBtn;
    private JButton grpDownBtn;
    private JButton tempAppendBtn;
    private JButton tempRemoveBtn;
    private JButton tempUpdateBtn;
    private JButton tempUpBtn;
    private JButton tempDownBtn;

    public GUICodeDialog(GUIFrame obj) {
        super((Frame)null, "\u30b3\u30fc\u30c9\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u5b9a\u7fa9", true);
        int h;
        int w;
        this.appObject = obj;
        this.xmlDoc = XMLDocumentCode.newInstance();
        this.paramInitialize();
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        this.getContentPane().add((Component)new JLabel(""), "West");
        this.getContentPane().add((Component)new JLabel(""), "East");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.initStatus();
        this.pack();
        Rectangle rect = this.getGraphicsConfiguration().getBounds();
        if (rect.x < 0) {
            int x = rect.x;
            w = 500;
        } else {
            w = rect.width / 2;
            int x = (rect.width - w) / 2;
        }
        if (rect.y < 0) {
            int y = rect.y;
            h = 400;
        } else {
            h = rect.height / 2;
            boolean y = false;
        }
        this.setSize(w, h);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u9589\u3058\u308b");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.transform();
                GUICodeDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.documentBox = new JComboBox(this.xmlDoc.getDocumentList());
        this.groupModel = new DefaultListModel();
        this.groupList = new JList(this.groupModel);
        this.templateModel = new DefaultListModel();
        this.templateList = new JList(this.templateModel);
        this.templateArea = new JTextArea();
        this.templateArea.setEditable(false);
        ImageIcon iconAdd = new ImageIcon(ClassLoader.getSystemResource("images/add.png"));
        ImageIcon iconDelete = new ImageIcon(ClassLoader.getSystemResource("images/delete.png"));
        ImageIcon iconWrench = new ImageIcon(ClassLoader.getSystemResource("images/wrench.png"));
        ImageIcon iconUp = new ImageIcon(ClassLoader.getSystemResource("images/arrow_up.png"));
        ImageIcon iconDown = new ImageIcon(ClassLoader.getSystemResource("images/arrow_down.png"));
        this.docAppendBtn = new JButton(iconAdd);
        this.docRemoveBtn = new JButton(iconDelete);
        this.docUpdateBtn = new JButton(iconWrench);
        this.grpAppendBtn = new JButton(iconAdd);
        this.grpRemoveBtn = new JButton(iconDelete);
        this.grpUpdateBtn = new JButton(iconWrench);
        this.grpUpBtn = new JButton(iconUp);
        this.grpDownBtn = new JButton(iconDown);
        this.tempAppendBtn = new JButton(iconAdd);
        this.tempRemoveBtn = new JButton(iconDelete);
        this.tempUpdateBtn = new JButton(iconWrench);
        this.tempUpBtn = new JButton(iconUp);
        this.tempDownBtn = new JButton(iconDown);
        this.docAppendBtn.setToolTipText("\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7\u306e\u8ffd\u52a0");
        this.docRemoveBtn.setToolTipText("\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7\u306e\u524a\u9664");
        this.docUpdateBtn.setToolTipText("\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7\u306e\u4fee\u6b63");
        this.grpAppendBtn.setToolTipText("\u30b0\u30eb\u30fc\u30d7\u306e\u8ffd\u52a0");
        this.grpRemoveBtn.setToolTipText("\u30b0\u30eb\u30fc\u30d7\u306e\u524a\u9664");
        this.grpUpdateBtn.setToolTipText("\u30b0\u30eb\u30fc\u30d7\u306e\u4fee\u6b63");
        this.grpUpBtn.setToolTipText("\uff11\u3064\u4e0a\u3078");
        this.grpDownBtn.setToolTipText("\uff11\u3064\u4e0b\u3078");
        this.tempAppendBtn.setToolTipText("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u8ffd\u52a0");
        this.tempRemoveBtn.setToolTipText("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u524a\u9664");
        this.tempUpdateBtn.setToolTipText("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u4fee\u6b63");
        this.tempUpBtn.setToolTipText("\uff11\u3064\u4e0a\u3078");
        this.tempDownBtn.setToolTipText("\uff11\u3064\u4e0b\u3078");
    }

    private JPanel createContentsPanel() {
        this.addAction();
        JScrollPane grpScrPane = new JScrollPane(this.groupList);
        JScrollPane tempScrPane = new JScrollPane(this.templateList);
        JScrollPane textScrPane = new JScrollPane(this.templateArea);
        JPanel grpBtnPane = new JPanel(new GridLayout(1, 5));
        grpBtnPane.add(this.grpAppendBtn);
        grpBtnPane.add(this.grpRemoveBtn);
        grpBtnPane.add(this.grpUpdateBtn);
        grpBtnPane.add(this.grpUpBtn);
        grpBtnPane.add(this.grpDownBtn);
        JPanel tempBtnPane = new JPanel(new GridLayout(1, 5));
        tempBtnPane.add(this.tempAppendBtn);
        tempBtnPane.add(this.tempRemoveBtn);
        tempBtnPane.add(this.tempUpdateBtn);
        tempBtnPane.add(this.tempUpBtn);
        tempBtnPane.add(this.tempDownBtn);
        JPanel grpPan = new JPanel(new BorderLayout());
        grpPan.add((Component)new JLabel("\u30b0\u30eb\u30fc\u30d7\u30ea\u30b9\u30c8"), "North");
        grpPan.add((Component)grpBtnPane, "South");
        grpPan.add((Component)grpScrPane, "Center");
        JPanel tempPan = new JPanel(new BorderLayout());
        tempPan.add((Component)new JLabel("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30ea\u30b9\u30c8"), "North");
        tempPan.add((Component)tempBtnPane, "South");
        tempPan.add((Component)tempScrPane, "Center");
        JPanel textPan = new JPanel(new BorderLayout());
        textPan.add((Component)new JLabel("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8"), "North");
        textPan.add((Component)textScrPane, "Center");
        JPanel pan = new JPanel(new GridLayout(1, 3, 10, 5));
        pan.add(grpPan);
        pan.add(tempPan);
        pan.add(textPan);
        GUIGridPanel gpan = new GUIGridPanel();
        gpan.gridLayoutComponent(new JLabel("\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7"), 0, 0);
        gpan.gridLayoutComponent(this.documentBox, 1, 0);
        gpan.gridLayoutComponent(this.docAppendBtn, 2, 0);
        gpan.gridLayoutComponent(this.docRemoveBtn, 3, 0);
        gpan.gridLayoutComponent(this.docUpdateBtn, 4, 0);
        JPanel docPane = new JPanel(new FlowLayout(0));
        docPane.add(gpan);
        JPanel ppan = new JPanel(new BorderLayout(10, 5));
        ppan.add((Component)docPane, "North");
        ppan.add((Component)pan, "Center");
        return ppan;
    }

    private void addAction() {
        this.documentBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionDocumentList();
            }
        });
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GUICodeDialog.this.actionGroupList();
            }
        });
        this.templateList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GUICodeDialog.this.actionTemplateList();
            }
        });
        this.docAppendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionDocumentAppend();
            }
        });
        this.grpAppendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionGroupAppend();
            }
        });
        this.tempAppendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionTemplateAppend();
            }
        });
        this.docRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionDocumentDelete();
            }
        });
        this.grpRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionGroupDelete();
            }
        });
        this.tempRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionTemplateDelete();
            }
        });
        this.docUpdateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionDocumentUpdate();
            }
        });
        this.grpUpdateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionGroupUpdate();
            }
        });
        this.tempUpdateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionTemplateUpdate();
            }
        });
        this.groupList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUICodeDialog.this.actionGroupUpdate();
                }
            }
        });
        this.templateList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUICodeDialog.this.actionTemplateUpdate();
                }
            }
        });
        this.grpUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionGroupUpDown(true);
            }
        });
        this.tempUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionTemplateUpDown(true);
            }
        });
        this.grpDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionGroupUpDown(false);
            }
        });
        this.tempDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUICodeDialog.this.actionTemplateUpDown(false);
            }
        });
    }

    private void setGroupBtnEnabled(boolean flag) {
        this.grpAppendBtn.setEnabled(flag);
        this.grpUpdateBtn.setEnabled(flag);
        this.grpRemoveBtn.setEnabled(flag);
        this.grpUpBtn.setEnabled(flag);
        this.grpDownBtn.setEnabled(flag);
    }

    private void setTemplateBtnEnabled(boolean flag) {
        this.tempAppendBtn.setEnabled(flag);
        this.tempUpdateBtn.setEnabled(flag);
        this.tempRemoveBtn.setEnabled(flag);
        this.tempUpBtn.setEnabled(flag);
        this.tempDownBtn.setEnabled(flag);
    }

    private void initStatus() {
        this.setGroupBtnEnabled(false);
        this.setTemplateBtnEnabled(false);
        if (this.documentBox.getItemCount() > 0) {
            this.documentBox.setSelectedIndex(0);
        }
    }

    private void actionDocumentList() {
        String documentName = (String)this.documentBox.getSelectedItem();
        if (documentName == null) {
            this.setGroupBtnEnabled(false);
            return;
        }
        this.setGroupBtnEnabled(true);
        this.groupModel.clear();
        this.templateModel.clear();
        this.groupModel = this.xmlDoc.getGroupList(this.groupModel, documentName);
        this.groupList.setSelectedIndex(0);
    }

    private void actionGroupList() {
        String documentName = (String)this.documentBox.getSelectedItem();
        String groupName = (String)this.groupList.getSelectedValue();
        if (null == documentName || null == groupName) {
            this.setTemplateBtnEnabled(false);
            return;
        }
        this.setTemplateBtnEnabled(true);
        this.templateModel.clear();
        this.templateModel = this.xmlDoc.getCodeList(this.templateModel, documentName, groupName);
        this.templateList.setSelectedIndex(0);
    }

    private void actionTemplateList() {
        String documentName = (String)this.documentBox.getSelectedItem();
        String templateName = (String)this.templateList.getSelectedValue();
        if (null == documentName || null == templateName) {
            this.templateArea.setText("");
            return;
        }
        XmlModelCode model = this.xmlDoc.getCodeModel(documentName, templateName);
        if (null == model) {
            this.templateArea.setText("");
            return;
        }
        this.templateArea.setText(model.getString());
    }

    private void actionDocumentAppend() {
        GUICodeDocumentDialog dlg = new GUICodeDocumentDialog(this.appObject);
        if (null == dlg.getModel()) {
            return;
        }
        if (!this.xmlDoc.appendDocument(dlg.getModel())) {
            return;
        }
        this.documentBox.addItem(dlg.getModel().getName());
        this.documentBox.setSelectedIndex(this.documentBox.getItemCount() - 1);
    }

    private void actionDocumentDelete() {
        String documentName = (String)this.documentBox.getSelectedItem();
        if (documentName == null) {
            return;
        }
        Object[] options = new Object[]{"\u524a\u9664\u3059\u308b", "\u524a\u9664\u3057\u306a\u3044"};
        int ret = StaticUtil.warningMessage(documentName + " \u30b3\u30fc\u30c9\u30bf\u30a4\u30d7\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7\u524a\u9664\u78ba\u8a8d", options, 1);
        if (ret != 0) {
            return;
        }
        if (!this.xmlDoc.removeDocument(documentName)) {
            return;
        }
        int idx = this.documentBox.getSelectedIndex();
        this.documentBox.removeItemAt(idx);
        if (idx >= this.documentBox.getItemCount()) {
            idx = this.documentBox.getItemCount() - 1;
        }
        if (idx < 0) {
            this.setGroupBtnEnabled(false);
            this.setTemplateBtnEnabled(false);
            this.groupModel.clear();
            this.templateModel.clear();
            return;
        }
        this.documentBox.setSelectedIndex(idx);
        this.documentBox.requestFocusInWindow();
    }

    private void actionDocumentUpdate() {
        String documentName = (String)this.documentBox.getSelectedItem();
        if (documentName == null) {
            return;
        }
        XmlModelDocument model = new XmlModelDocument(documentName);
        GUICodeDocumentDialog dlg = new GUICodeDocumentDialog(this.appObject, model, true);
        if (dlg.getModel() == null) {
            return;
        }
        if (!this.xmlDoc.updateDocument(documentName, dlg.getModel())) {
            return;
        }
        int idx = this.documentBox.getSelectedIndex();
        this.documentBox.insertItemAt(dlg.getModel().getName(), idx);
        this.documentBox.removeItemAt(idx + 1);
        this.documentBox.setSelectedIndex(idx);
        this.documentBox.requestFocusInWindow();
    }

    private void actionGroupAppend() {
        String documentName = (String)this.documentBox.getSelectedItem();
        GUICodeGroupDialog dlg = new GUICodeGroupDialog(this.appObject, documentName);
        if (null == dlg.getModel()) {
            return;
        }
        if (!this.xmlDoc.appendGroup(documentName, dlg.getModel())) {
            return;
        }
        this.groupModel.addElement(dlg.getModel().getName());
        this.groupList.setSelectedIndex(this.groupModel.size() - 1);
    }

    private void actionGroupDelete() {
        String groupName = (String)this.groupList.getSelectedValue();
        if (null == groupName) {
            return;
        }
        Object[] options = new Object[]{"\u524a\u9664\u3059\u308b", "\u524a\u9664\u3057\u306a\u3044"};
        int ret = StaticUtil.warningMessage(groupName + " \u30b0\u30eb\u30fc\u30d7\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "\u30b0\u30eb\u30fc\u30d7\u524a\u9664\u78ba\u8a8d", options, 1);
        if (ret != 0) {
            return;
        }
        String documentName = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.removeGroup(documentName, groupName)) {
            return;
        }
        int idx = this.groupModel.indexOf(groupName);
        this.groupModel.removeElement(groupName);
        if (idx >= this.groupModel.size()) {
            idx = this.groupModel.size() - 1;
        }
        if (idx < 0) {
            this.setTemplateBtnEnabled(false);
            this.templateModel.clear();
            return;
        }
        this.groupList.setSelectedIndex(idx);
        this.groupList.requestFocusInWindow();
    }

    private void actionGroupUpdate() {
        String documentName = (String)this.documentBox.getSelectedItem();
        String groupName = (String)this.groupList.getSelectedValue();
        if (null == documentName || null == groupName) {
            return;
        }
        XmlModelGroup model = this.xmlDoc.getGroupModel(documentName, groupName);
        if (null == model) {
            return;
        }
        GUICodeGroupDialog dlg = new GUICodeGroupDialog(this.appObject, documentName, model);
        if (null == dlg.getModel()) {
            return;
        }
        if (!this.xmlDoc.updateGroup(documentName, groupName, dlg.getModel())) {
            return;
        }
        int idx = this.groupList.getSelectedIndex();
        this.groupModel.set(idx, dlg.getModel().getName());
        this.groupList.setSelectedIndex(idx);
        this.groupList.requestFocusInWindow();
    }

    private void actionGroupUpDown(boolean upFlag) {
        int eIdx;
        int sIdx;
        int idx = this.groupList.getSelectedIndex();
        if (upFlag) {
            if (idx <= 0) {
                return;
            }
            sIdx = idx - 1;
            eIdx = idx;
        } else {
            if (idx >= this.groupModel.size() - 1) {
                return;
            }
            sIdx = idx;
            eIdx = idx + 1;
        }
        String elm1 = (String)this.groupModel.get(sIdx);
        String elm2 = (String)this.groupModel.get(eIdx);
        String documentName = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.groupUpDown(documentName, elm1, elm2)) {
            return;
        }
        this.groupModel.set(sIdx, elm2);
        this.groupModel.set(eIdx, elm1);
        if (!upFlag) {
            sIdx = eIdx;
        }
        this.groupList.setSelectedIndex(sIdx);
        this.groupList.requestFocusInWindow();
    }

    private void actionTemplateAppend() {
        String documentName = (String)this.documentBox.getSelectedItem();
        GUICodeTemplateDialog dlg = new GUICodeTemplateDialog(this.appObject, documentName);
        if (dlg.getModel() == null) {
            return;
        }
        String groupName = (String)this.groupList.getSelectedValue();
        if (!this.xmlDoc.appendCode(documentName, groupName, dlg.getModel())) {
            return;
        }
        this.templateModel.addElement(dlg.getModel().getName());
        this.templateList.setSelectedIndex(this.templateModel.size() - 1);
    }

    private void actionTemplateDelete() {
        String templateName = (String)this.templateList.getSelectedValue();
        if (null == templateName) {
            return;
        }
        Object[] options = new Object[]{"\u524a\u9664\u3059\u308b", "\u524a\u9664\u3057\u306a\u3044"};
        int ret = StaticUtil.warningMessage(templateName + " \u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u524a\u9664\u78ba\u8a8d", options, 1);
        if (ret != 0) {
            return;
        }
        String documentName = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.removeCode(documentName, templateName)) {
            return;
        }
        int idx = this.templateModel.indexOf(templateName);
        this.templateModel.removeElement(templateName);
        if (idx >= this.templateModel.size()) {
            idx = this.templateModel.size() - 1;
        }
        if (idx < 0) {
            this.templateArea.setText("");
            return;
        }
        this.templateList.setSelectedIndex(idx);
        this.templateList.requestFocusInWindow();
    }

    private void actionTemplateUpdate() {
        String documentName = (String)this.documentBox.getSelectedItem();
        String templateName = (String)this.templateList.getSelectedValue();
        if (null == documentName || null == templateName) {
            return;
        }
        XmlModelCode model = this.xmlDoc.getCodeModel(documentName, templateName);
        if (null == model) {
            return;
        }
        GUICodeTemplateDialog dlg = new GUICodeTemplateDialog(this.appObject, documentName, model);
        if (null == dlg.getModel()) {
            return;
        }
        if (!this.xmlDoc.updateCode(documentName, templateName, dlg.getModel())) {
            return;
        }
        model = this.xmlDoc.getCodeModel(documentName, dlg.getModel().getName());
        this.templateArea.setText(model.getString());
        int idx = this.templateList.getSelectedIndex();
        this.templateModel.set(idx, dlg.getModel().getName());
        this.templateList.setSelectedIndex(idx);
        this.templateList.requestFocusInWindow();
    }

    private void actionTemplateUpDown(boolean upFlag) {
        int eIdx;
        int sIdx;
        int idx = this.templateList.getSelectedIndex();
        if (upFlag) {
            if (idx <= 0) {
                return;
            }
            sIdx = idx - 1;
            eIdx = idx;
        } else {
            if (idx >= this.templateModel.size() - 1) {
                return;
            }
            sIdx = idx;
            eIdx = idx + 1;
        }
        String elm1 = (String)this.templateModel.get(sIdx);
        String elm2 = (String)this.templateModel.get(eIdx);
        String documentName = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.codeUpDown(documentName, elm1, elm2)) {
            return;
        }
        this.templateModel.set(sIdx, elm2);
        this.templateModel.set(eIdx, elm1);
        if (!upFlag) {
            sIdx = eIdx;
        }
        this.templateList.setSelectedIndex(sIdx);
        this.templateList.requestFocusInWindow();
    }

    private void transform() {
        this.xmlDoc.transform();
        this.appObject.getUserCodePanel().update();
    }

    public void windowClosing(WindowEvent e) {
        this.transform();
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

