/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.ftp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.ftp.FtpDocument;
import jp.sourceforge.jhime.pectin.ftp.Host;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public class FtpHostSetupDialog
extends JDialog
implements WindowListener {
    private static final String[] ENCODING = new String[]{"UTF-8", "UTF-16", "EUC-JP", "ISO-2022-JP", "Shift_JIS"};
    private JButton okBtn;
    private JButton cancelBtn;
    private FtpDocument doc;
    private JTextField nameField = new JTextField(20);
    private JTextField serverField = new JTextField(20);
    private JTextField userField = new JTextField(20);
    private JPasswordField passwordField = new JPasswordField(20);
    private JTextField serverInitDirField = new JTextField(30);
    private JComboBox encodingBox = new JComboBox<String>(ENCODING);
    private JCheckBox pasvBtn = new JCheckBox("pasv\u30e2\u30fc\u30c9");
    private JTextField localInitDirField = new JTextField(System.getProperty("user.home"), 30);
    private JButton localBtn = new JButton("\u53c2\u7167");
    private Host host;

    public FtpHostSetupDialog(JFrame frame, FtpDocument doc, Host host) {
        super(frame, "FTP\u30b5\u30fc\u30d0\u30fc\u65b0\u898f\u767b\u9332", true);
        this.encodingBox.setEditable(true);
        this.doc = doc;
        this.host = host;
        if (null != host) {
            this.setTitle("FTP\u30b5\u30fc\u30d0\u30fc\u8a2d\u5b9a\u5909\u66f4");
            this.nameField.setText(this.host.getName());
            this.serverField.setText(this.host.getServer());
            this.userField.setText(this.host.getUser());
            this.passwordField.setText(this.host.getPassword());
            this.localInitDirField.setText(this.host.getLocalDir());
            this.encodingBox.setSelectedItem(this.host.getEncoding());
            this.pasvBtn.setSelected(this.host.getPasv());
            this.serverInitDirField.setText(this.host.getServerDir());
        }
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public FtpHostSetupDialog(JFrame frame, FtpDocument doc) {
        this(frame, doc, null);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!FtpHostSetupDialog.this.append()) {
                    return;
                }
                FtpHostSetupDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpHostSetupDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private JPanel createPanel() {
        this.localInitDirField.setEditable(false);
        this.action();
        GUIGridPanel pane = new GUIGridPanel();
        pane.gridLayoutComponent(new JLabel("\u8a2d\u5b9a\u767b\u9332\u540d"), 0, 0);
        pane.gridLayoutComponent(this.nameField, 1, 0);
        pane.gridLayoutComponent(new JLabel("FTP\u30b5\u30fc\u30d0\u30fc\u540d"), 0, 1);
        pane.gridLayoutComponent(this.serverField, 1, 1);
        pane.gridLayoutComponent(new JLabel("\u30e6\u30fc\u30b6\u30fc\u540d"), 0, 2);
        pane.gridLayoutComponent(this.userField, 1, 2);
        pane.gridLayoutComponent(new JLabel("\u30d1\u30b9\u30ef\u30fc\u30c9"), 0, 3);
        pane.gridLayoutComponent(this.passwordField, 1, 3);
        pane.gridLayoutComponent(new JLabel("\u521d\u671f\u30b5\u30fc\u30d0\u30fc\u30c7\u30a3\u30ec\u30af\u30c8\u30ea"), 0, 4);
        pane.setWidth(2);
        pane.gridLayoutComponent(this.serverInitDirField, 1, 4);
        pane.setWidth(1);
        pane.gridLayoutComponent(new JLabel("\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0"), 0, 5);
        pane.gridLayoutComponent(this.encodingBox, 1, 5);
        pane.gridLayoutComponent(this.pasvBtn, 0, 6);
        pane.gridLayoutComponent(new JLabel("\u521d\u671f\u30ed\u30fc\u30ab\u30eb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea"), 0, 7);
        pane.setWidth(2);
        pane.gridLayoutComponent(this.localInitDirField, 1, 7);
        pane.setWidth(1);
        pane.gridLayoutComponent(this.localBtn, 3, 7);
        return pane;
    }

    private void action() {
        this.localBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpHostSetupDialog.this.setLocalDir();
            }
        });
    }

    private void setLocalDir() {
        JFileChooser fc = new JFileChooser(new File(this.localInitDirField.getText()));
        fc.setDialogTitle("\u521d\u671f\u30ed\u30fc\u30ab\u30eb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u6307\u5b9a");
        fc.setFileSelectionMode(1);
        if (0 != fc.showDialog(this, "\u53c2\u7167")) {
            return;
        }
        this.localInitDirField.setText(fc.getSelectedFile().getPath());
    }

    private boolean append() {
        String password = new String(this.passwordField.getPassword());
        Host host = new Host(this.nameField.getText(), this.serverField.getText(), this.userField.getText(), password, this.localInitDirField.getText(), (String)this.encodingBox.getSelectedItem(), this.pasvBtn.isSelected(), this.serverInitDirField.getText());
        if (host.isError()) {
            StaticUtil.errorMessage("\u672a\u5165\u529b\u306e\u9805\u76ee\u304c\u3042\u308a\u307e\u3059", "\u30a8\u30e9\u30fc");
            return false;
        }
        if (null == this.host) {
            if (this.doc.isFtpNameDuplicate(host.getName())) {
                StaticUtil.errorMessage("\u767b\u9332\u6e08\u307f\u306e\u8a2d\u5b9a\u767b\u9332\u540d\u3067\u3059", "\u30a8\u30e9\u30fc");
                return false;
            }
            if (!this.doc.append(host)) {
                StaticUtil.errorMessage("FTP\u8a2d\u5b9a\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "DOM\u30a8\u30e9\u30fc");
                return false;
            }
        } else {
            if (!this.host.getName().equals(host.getName()) && this.doc.isFtpNameDuplicate(host.getName())) {
                StaticUtil.errorMessage("\u767b\u9332\u6e08\u307f\u306e\u8a2d\u5b9a\u767b\u9332\u540d\u3067\u3059", "\u30a8\u30e9\u30fc");
                return false;
            }
            if (!this.doc.update(this.host.getName(), host)) {
                StaticUtil.errorMessage("FTP\u8a2d\u5b9a\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "DOM\u30a8\u30e9\u30fc");
                return false;
            }
        }
        return true;
    }

    public FtpDocument getDocument() {
        return this.doc;
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

