/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.ftp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import java.util.regex.Pattern;
import jp.sourceforge.jhime.pectin.ftp.FtpDialog;
import jp.sourceforge.jhime.pectin.ftp.Host;

public class FTP
implements Runnable {
    public static final int LOGIN = 1;
    public static final int LOGOUT = 2;
    public static final int LIST = 3;
    public static final int CWD = 4;
    public static final int CDUP = 5;
    public static final int TYPE = 6;
    public static final int MKD = 7;
    public static final int RMD = 8;
    public static final int DELE = 9;
    public static final int REN = 10;
    public static final int DOWNLOAD = 11;
    public static final int NLST = 12;
    public static final int UPLOAD = 13;
    private static FTP selfObj = null;
    private Host host = null;
    private int job;
    private Socket ctrlSocket;
    private BufferedReader ctrlInput;
    private OutputStreamWriter ctrlOutput;
    private FtpDialog dialog = null;
    private String optionString;
    private String optionString2;
    private boolean typeMode;
    private Vector nlstResult;

    private FTP() {
    }

    private boolean connect() {
        boolean flag = false;
        try {
            this.ctrlSocket = new Socket(this.host.getServer(), 21);
            this.ctrlInput = new BufferedReader(new InputStreamReader(this.ctrlSocket.getInputStream(), this.host.getEncoding()));
            this.ctrlOutput = new OutputStreamWriter(this.ctrlSocket.getOutputStream(), this.host.getEncoding());
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (code.equals("220")) {
                this.dialog.setText(msg.getMessage());
                flag = true;
            } else {
                this.dialog.setText("\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            }
        }
        catch (Exception e) {
            this.dialog.setText("\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean userCommand() {
        boolean flag = false;
        try {
            this.ctrlOutput.write("USER " + this.host.getUser() + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("331")) {
                this.dialog.setText("\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            } else {
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean passCommand() {
        boolean flag = false;
        try {
            this.ctrlOutput.write("PASS " + this.host.getPassword() + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("230")) {
                this.dialog.setText("\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            } else {
                this.dialog.setText(this.host.getUser() + " \u306b\u30ed\u30b0\u30a4\u30f3\u3057\u307e\u3057\u305f");
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean systCommand() {
        boolean flag = false;
        try {
            this.ctrlOutput.write("SYST\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("215")) {
                this.dialog.setText("SYST\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            } else {
                this.dialog.setText("\nOS type: " + msg.getMessage());
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("SYST\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean quitCommand() {
        try {
            this.ctrlOutput.write("QUIT\n");
            this.ctrlOutput.flush();
            this.ctrlInput.readLine();
            this.ctrlOutput.flush();
            this.ctrlOutput.close();
            this.ctrlInput.close();
            this.ctrlSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean typeCommand(boolean ascii) {
        boolean flag = false;
        try {
            if (ascii) {
                this.ctrlOutput.write("TYPE A\n");
            } else {
                this.ctrlOutput.write("TYPE I\n");
            }
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("200")) {
                this.dialog.setText("TYPE\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            } else {
                if (ascii) {
                    this.dialog.setText("\n\u8ee2\u9001\u30c7\u30fc\u30bf\u5f62\u5f0f: \u30a2\u30b9\u30ad\u30fc\u30e2\u30fc\u30c9");
                } else {
                    this.dialog.setText("\n\u8ee2\u9001\u30c7\u30fc\u30bf\u5f62\u5f0f: \u30d0\u30a4\u30ca\u30ea\u30e2\u30fc\u30c9");
                }
                this.typeMode = ascii;
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("TYPE\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean cwdCommand(String path) {
        boolean flag = false;
        try {
            String cwdPath = path.trim();
            if (cwdPath.equals("")) {
                return true;
            }
            this.ctrlOutput.write("CWD " + cwdPath + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("250")) {
                this.dialog.setText("\n" + cwdPath + " \u306b\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
            } else {
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("CWD\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean pwdCommand() {
        boolean flag = false;
        try {
            this.ctrlOutput.write("PWD\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("257")) {
                this.dialog.setText("PWD\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            } else {
                this.dialog.setText("\n" + msg.getMessage());
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("PWD\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private ServerSocket portCommand() {
        ServerSocket dataSocket = null;
        try {
            byte[] hostAddress = this.ctrlSocket.getLocalAddress().getAddress();
            dataSocket = new ServerSocket(0, 1);
            String port = "PORT ";
            for (int i = 0; i < 4; ++i) {
                port = port + (hostAddress[i] & 0xFF) + ",";
            }
            port = port + (dataSocket.getLocalPort() / 256 & 0xFF) + ",";
            port = port + (dataSocket.getLocalPort() & 0xFF);
            this.ctrlOutput.write(port + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("200")) {
                this.dialog.setText("PORT\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
                return null;
            }
        }
        catch (Exception e) {
            this.dialog.setText("PORT\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return dataSocket;
    }

    private Socket pasvCommand() {
        Socket dataSocket = null;
        try {
            this.ctrlOutput.write("PASV\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("227")) {
                this.dialog.setText("PASV\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
                return null;
            }
            String retStr = msg.getMessage();
            int sPos = retStr.indexOf("(");
            int ePos = retStr.lastIndexOf(")");
            String ip_port = retStr.substring(sPos + 1, ePos);
            StringBuffer ip = new StringBuffer();
            int pos = 0;
            int cCnt = 0;
            while (cCnt < 4) {
                char c = ip_port.charAt(pos);
                if (',' == c) {
                    ++cCnt;
                    c = '.';
                }
                if (cCnt < 4) {
                    ip.append(c);
                }
                ++pos;
            }
            sPos = ip_port.indexOf(",", pos);
            String port1 = ip_port.substring(pos, sPos);
            String port2 = ip_port.substring(sPos + 1);
            int pasvPort = Integer.parseInt(port1) * 256 + Integer.parseInt(port2);
            InetAddress pasvlp = InetAddress.getByName(ip.toString());
            dataSocket = new Socket(pasvlp, pasvPort);
        }
        catch (Exception e) {
            this.dialog.setText("PASV\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return dataSocket;
    }

    private void listCommand() {
        try {
            String str;
            Socket dataSocket = null;
            dataSocket = this.host.getPasv() ? this.pasvModeCommand("LIST") : this.activeModeCommand("LIST");
            if (null == dataSocket) {
                return;
            }
            InputStream is = dataSocket.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, this.host.getEncoding()));
            while (null != (str = br.readLine())) {
                this.dialog.setText(str);
            }
            br.close();
            is.close();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("226")) {
                this.dialog.setText("\u30c7\u30fc\u30bf\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            }
            dataSocket.close();
        }
        catch (Exception e) {
            this.dialog.setText("LIST\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
    }

    private boolean cdupCommand() {
        boolean flag = false;
        try {
            this.ctrlOutput.write("CDUP\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("250")) {
                this.dialog.setText("\n\u89aa\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f [code=" + code + "]");
            } else {
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("CDUP\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean mkdCommand(String path) {
        boolean flag = false;
        try {
            this.ctrlOutput.write("MKD " + path + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("257")) {
                this.dialog.setText("\u65b0\u898f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea " + path + " \u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f [code=" + code + "]");
            } else {
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("MKD\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean rmdCommand(String path) {
        boolean flag = false;
        try {
            this.ctrlOutput.write("RMD " + path + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("250")) {
                this.dialog.setText("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea " + path + " \u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f [code=" + code + "]");
            } else {
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("RMD\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean deleCommand(String path) {
        boolean flag = false;
        try {
            this.ctrlOutput.write("DELE " + path + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("250")) {
                this.dialog.setText(path + " \u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f [code=" + code + "]");
            } else {
                flag = true;
            }
        }
        catch (Exception e) {
            this.dialog.setText("DELE\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean statCommand(String str) {
        boolean flag = false;
        try {
            this.ctrlOutput.write("STAT " + str + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            this.dialog.setText(code);
            this.dialog.setText(msg.getMessage());
            flag = true;
        }
        catch (Exception e) {
            this.dialog.setText("STAT\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private Vector nlstCommand() {
        Vector<String> listVector = new Vector<String>();
        try {
            String str;
            Socket dataSocket = null;
            dataSocket = this.host.getPasv() ? this.pasvModeCommand("NLST") : this.activeModeCommand("NLST");
            if (null == dataSocket) {
                return null;
            }
            InputStream is = dataSocket.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, this.host.getEncoding()));
            while (null != (str = br.readLine())) {
                listVector.add(str);
            }
            br.close();
            is.close();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("226")) {
                this.dialog.setText("\u30c7\u30fc\u30bf\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            }
            dataSocket.close();
        }
        catch (Exception e) {
            this.dialog.setText("NLST\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
            listVector = null;
        }
        return listVector;
    }

    private boolean renCommand(String oldName, String newName) {
        boolean flag = false;
        try {
            this.ctrlOutput.write("RNFR " + oldName + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("350")) {
                this.dialog.setText(oldName + " \u306e\u540d\u524d\u5909\u66f4\u306f\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f [code=" + code + "]");
            } else {
                this.ctrlOutput.write("RNTO " + newName + "\n");
                this.ctrlOutput.flush();
                msg = new Message(this.ctrlInput.readLine());
                code = msg.getCode();
                if (!code.equals("250")) {
                    this.dialog.setText(newName + " \u306b\u540d\u524d\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f [code=" + code + "]");
                } else {
                    flag = true;
                }
            }
        }
        catch (Exception e) {
            this.dialog.setText("RNFR/RNTO\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean downloadCommand(String path, String fileName) {
        boolean flag = false;
        try {
            int c;
            Socket dataSocket = null;
            dataSocket = this.host.getPasv() ? this.pasvModeCommand("RETR " + fileName + "\n", true) : this.activeModeCommand("RETR " + fileName + "\n", true);
            if (null == dataSocket) {
                return flag;
            }
            InputStream is = dataSocket.getInputStream();
            FileOutputStream fos = new FileOutputStream(path + fileName);
            while ((c = is.read()) != -1) {
                fos.write(c);
            }
            fos.close();
            is.close();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("226")) {
                this.dialog.setText("\u30c7\u30fc\u30bf\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            } else {
                flag = true;
            }
            dataSocket.close();
        }
        catch (Exception e) {
            this.dialog.setText("RETR\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private boolean uploadCommand(String fromName, String toName) {
        boolean flag = false;
        try {
            int c;
            Socket dataSocket = null;
            dataSocket = this.host.getPasv() ? this.pasvModeCommand("STOR " + toName + "\n", true) : this.activeModeCommand("STOR " + toName + "\n", true);
            if (null == dataSocket) {
                return flag;
            }
            OutputStream os = dataSocket.getOutputStream();
            FileInputStream fis = new FileInputStream(fromName);
            while ((c = fis.read()) != -1) {
                os.write(c);
            }
            fis.close();
            os.close();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("226")) {
                this.dialog.setText("\u30c7\u30fc\u30bf\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            } else {
                flag = true;
            }
            dataSocket.close();
        }
        catch (Exception e) {
            this.dialog.setText("STOR\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
        }
        return flag;
    }

    private Socket pasvModeCommand(String command, boolean flag) {
        Socket dataSocket = null;
        try {
            dataSocket = this.pasvCommand();
            if (null == dataSocket) {
                return null;
            }
            this.ctrlOutput.write(command + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("150")) {
                this.dialog.setText("\u30c7\u30fc\u30bf\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u78ba\u7acb\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
                dataSocket.close();
                return null;
            }
            if (flag) {
                this.dialog.setText(msg.getMessage());
            }
        }
        catch (Exception e) {
            this.dialog.setText(command + "\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
            dataSocket = null;
        }
        return dataSocket;
    }

    private Socket pasvModeCommand(String command) {
        return this.pasvModeCommand(command, false);
    }

    private Socket activeModeCommand(String command, boolean flag) {
        ServerSocket ctrlDataSocket = null;
        Socket dataSocket = null;
        try {
            ctrlDataSocket = this.portCommand();
            if (null == ctrlDataSocket) {
                return null;
            }
            this.ctrlOutput.write(command + "\n");
            this.ctrlOutput.flush();
            Message msg = new Message(this.ctrlInput.readLine());
            String code = msg.getCode();
            if (!code.equals("150")) {
                this.dialog.setText("\u30c7\u30fc\u30bf\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306e\u78ba\u7acb\u306b\u5931\u6557\u3057\u307e\u3057\u305f [code=" + code + "]");
            } else {
                dataSocket = ctrlDataSocket.accept();
                if (flag) {
                    this.dialog.setText(msg.getMessage());
                }
            }
            if (ctrlDataSocket != null) {
                ctrlDataSocket.close();
            }
        }
        catch (Exception e) {
            this.dialog.setText(command + "\u30b3\u30de\u30f3\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.dialog.setText(e.getMessage());
            dataSocket = null;
        }
        return dataSocket;
    }

    private Socket activeModeCommand(String command) {
        return this.activeModeCommand(command, false);
    }

    private void login() {
        if (!this.connect()) {
            return;
        }
        if (!this.userCommand()) {
            return;
        }
        if (!this.passCommand()) {
            return;
        }
        if (!this.systCommand()) {
            return;
        }
        if (!this.typeCommand(false)) {
            return;
        }
        this.cwdCommand(this.host.getServerDir());
        this.pwdCommand();
        this.listCommand();
    }

    private void list() {
        this.pwdCommand();
        this.listCommand();
    }

    private void cwd() {
        if (!this.cwdCommand(this.optionString)) {
            return;
        }
        this.list();
    }

    private void cdup() {
        if (!this.cdupCommand()) {
            return;
        }
        this.list();
    }

    private void mkd() {
        if (!this.mkdCommand(this.optionString)) {
            return;
        }
        this.dialog.setText("\n\u30c7\u30a3\u30ec\u30af\u30c8\u30ea " + this.optionString + " \u3092\u4f5c\u6210\u3057\u307e\u3057\u305f");
    }

    private void rmd() {
        if (!this.rmdCommand(this.optionString)) {
            return;
        }
        this.dialog.setText("\n\u30c7\u30a3\u30ec\u30af\u30c8\u30ea " + this.optionString + " \u3092\u524a\u9664\u3057\u307e\u3057\u305f");
    }

    private void dele() {
        Vector dirList = this.nlstCommand();
        if (null == dirList) {
            return;
        }
        String regex = this.optionString.replaceAll("\\.", "\\\\\\.");
        regex = regex.replaceAll("\\*", ".*");
        regex = regex.replaceAll("\\?", ".");
        for (int i = 0; i < dirList.size(); ++i) {
            String str = (String)dirList.get(i);
            if (!Pattern.matches(regex, str) || !this.deleCommand(str)) continue;
            this.dialog.setText("\u30d5\u30a1\u30a4\u30eb " + str + " \u3092\u524a\u9664\u3057\u307e\u3057\u305f");
        }
    }

    private void ren() {
        if (!this.renCommand(this.optionString, this.optionString2)) {
            return;
        }
        this.dialog.setText("\n" + this.optionString + " \u3092 " + this.optionString2 + " \u306b\u5909\u66f4\u3057\u307e\u3057\u305f");
    }

    private void download() {
        this.dialog.setText("\n\u30d5\u30a1\u30a4\u30eb\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u958b\u59cb...");
        for (int i = 0; i < this.nlstResult.size(); ++i) {
            String fileName = (String)this.nlstResult.get(i);
            if (!this.downloadCommand(this.optionString, fileName)) {
                this.dialog.setText(fileName + " :\u5931\u6557");
                continue;
            }
            this.dialog.setText(fileName + " :\u6210\u529f");
        }
        this.dialog.setText("\u30d5\u30a1\u30a4\u30eb\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u7d42\u4e86");
    }

    private void upload() {
        this.dialog.setText("\n\u30d5\u30a1\u30a4\u30eb\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u958b\u59cb...");
        for (int i = 0; i < this.nlstResult.size(); ++i) {
            String toName;
            File file = (File)this.nlstResult.get(i);
            String fromName = file.getPath();
            if (!this.uploadCommand(fromName, toName = file.getName())) {
                this.dialog.setText(toName + " :\u5931\u6557");
                continue;
            }
            this.dialog.setText(toName + " :\u6210\u529f");
        }
        this.dialog.setText("\u30d5\u30a1\u30a4\u30eb\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u7d42\u4e86");
    }

    public static FTP getInstance() {
        if (null == selfObj) {
            selfObj = new FTP();
        }
        return selfObj;
    }

    public void setHost(Host host, FtpDialog dlg) {
        this.host = host;
        this.dialog = dlg;
    }

    public void setJob(int job) {
        this.job = job;
    }

    public void setString(String str) {
        this.optionString = str;
    }

    public void setString(String str1, String str2) {
        this.optionString = str1;
        this.optionString2 = str2;
    }

    public boolean getTypeMode() {
        return this.typeMode;
    }

    public void setTypeMode(boolean ascii) {
        this.typeMode = ascii;
    }

    public Vector getNlstResult() {
        return this.nlstResult;
    }

    public void setNlstResult(Vector vector) {
        this.nlstResult = vector;
    }

    public void run() {
        this.dialog.setEnabledButton(false);
        switch (this.job) {
            case 1: {
                this.login();
                break;
            }
            case 2: {
                this.quitCommand();
                break;
            }
            case 3: {
                this.list();
                break;
            }
            case 4: {
                this.cwd();
                break;
            }
            case 5: {
                this.cdup();
                break;
            }
            case 6: {
                this.typeCommand(this.typeMode);
                break;
            }
            case 7: {
                this.mkd();
                break;
            }
            case 8: {
                this.rmd();
                break;
            }
            case 9: {
                this.dele();
                break;
            }
            case 10: {
                this.ren();
                break;
            }
            case 11: {
                this.download();
                break;
            }
            case 13: {
                this.upload();
                break;
            }
            case 12: {
                this.nlstResult = this.nlstCommand();
                break;
            }
        }
        this.dialog.setEnabledButton(true);
    }

    class Message {
        private String code;
        private String message;

        Message(String str) {
            this.code = str.substring(0, 3);
            this.message = str.substring(4);
        }

        String getCode() {
            return this.code;
        }

        String getMessage() {
            return this.message + "\n";
        }
    }
}

