/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import jp.sourceforge.jhime.pectin.action.ViewMenuAction;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public class ViewMenuActionHandler
implements ActionListener,
ItemListener {
    private GUIFrame appObject;
    private ViewMenuAction menuObject;
    public static final String TOOLBAR = "toolbar";
    public static final String STATUSBAR = "statusbar";
    public static final String XMLPANEL = "xmlpanel";
    public static final String WRAP = "wrap";
    public static final String UNIX = "unix";
    public static final String MAC = "mac";
    public static final String WIN = "win";
    public static final String HIGHLIGHTADD = "hadd";
    public static final String HIGHLIGHTDELETE = "hdelete";

    public ViewMenuActionHandler(GUIFrame obj, ViewMenuAction menu) {
        this.appObject = obj;
        this.menuObject = menu;
    }

    private void actionWrap(JCheckBoxMenuItem item) {
        boolean bool = item.isSelected();
        this.appObject.getView().setWrap(bool);
    }

    private void actionEndOfLine(String command) {
        String endOfLine = command.equals(UNIX) ? StaticUtil.getEndOfLineUnix() : (command.equals(MAC) ? StaticUtil.getEndOfLineMac() : StaticUtil.getEndOfLineWin());
        this.appObject.getView().setEndOfLine(endOfLine);
    }

    private void actionHighlight(boolean bool) {
        if (bool) {
            this.appObject.getView().addHighlight();
        } else {
            this.appObject.getView().deleteHighlight();
        }
    }

    private void actionToolBar(JCheckBoxMenuItem item) {
        boolean bool = item.isSelected();
        this.appObject.setToolBarVisible(bool);
    }

    private void actionStatusBar(JCheckBoxMenuItem item) {
        boolean bool = item.isSelected();
        this.appObject.setStatusBarVisible(bool);
    }

    private void actionXmlPanel(JCheckBoxMenuItem item) {
        boolean bool = item.isSelected();
        this.appObject.setXmlPanelVisible(bool);
    }

    private void actionXmlPanel() {
        if (this.menuObject.getXmlPanel()) {
            this.menuObject.setXmlPanel(false);
        } else {
            this.menuObject.setXmlPanel(true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        AbstractButton item = (AbstractButton)e.getItemSelectable();
        String command = item.getActionCommand();
        if (command.equals(WRAP)) {
            this.actionWrap((JCheckBoxMenuItem)item);
        } else if (command.equals(UNIX) | command.equals(MAC) | command.equals(WIN)) {
            this.actionEndOfLine(command);
        } else if (command.equals(TOOLBAR)) {
            this.actionToolBar((JCheckBoxMenuItem)item);
        } else if (command.equals(STATUSBAR)) {
            this.actionStatusBar((JCheckBoxMenuItem)item);
        } else if (command.equals(XMLPANEL)) {
            this.actionXmlPanel((JCheckBoxMenuItem)item);
        }
        if (this.appObject.getView() != null) {
            this.appObject.getView().setFocus();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(XMLPANEL)) {
            this.actionXmlPanel();
        } else if (command.equals(HIGHLIGHTADD)) {
            this.actionHighlight(true);
        } else if (command.equals(HIGHLIGHTDELETE)) {
            this.actionHighlight(false);
        }
        if (this.appObject.getView() != null) {
            this.appObject.getView().setFocus();
        }
    }
}

