unit peach;
{
 DESCRIPTION     :  Application providing GUI for calling PEA and third parts
                    open source executables, giving graphic tools for composing
                    appropriate command lines, such as file and folder selection,
                    import/export lists, choose parameters from graphic menus etc.
                    Archive theming, cross-platform desktop and script integration
                    features.
 REQUIREMENTS    :  FPC, Lazarus
                    Compiled pea and pealauncher in (peazip)/res/bin path
                    third parts executables in (peazip)/res/bin/executablename/ path

 EXTERNAL DATA   :  ---

 MEMORY USAGE    :  ---

 DISPLAY MODE    :  ---

 REFERENCES      :  ---

 REMARK          :  ---

 Version  Date      Author      Modification
 -------  --------  -------     ------------------------------------------
 PEA-PEACH
 0.10     20060908  G.Tani      Initial version named Pea-Peach 0.10
 0.11     20060920  G.Tani
 0.12     20060927  G.Tani
 0.13     20061103  G.Tani      Changed name of the release to PeaZip 1.0
 0.14     20061201  G.Tani      1.1
 0.15     20070118  G.Tani      1.2
 0.15b    20070122  G.Tani      1.2b
 0.16     20070201  G.Tani      1.3
 0.17     20070305  G.Tani      1.4
 0.18     20070319  G.Tani      1.5
 0.19     20070407  G.Tani      1.6
 0.20     20070512  G.Tani      1.7
 0.21     20070605  G.Tani      1.8
 0.22     20070708  G.Tani      1.8.1
 0.23     20070717  G.Tani      1.8.2
 0.24     20070807  G.Tani      1.9
 0.25     20070904  G.Tani      1.9.1
 0.26     20071003  G.Tani      1.9.2
 0.27     20071101  G.Tani      1.9.3
 0.28     20071206  G.Tani      1.10
 0.29     20080125  G.Tani      1.11
 0.30     20080319  G.Tani      2.0
 0.31     20080517  G.Tani      2.1
 0.32     20080807  G.Tani      2.2
 0.33     20080922  G.Tani      2.3a
 0.34     20081103  G.Tani      2.4
 0.35     20081124  G.Tani      2.4.1
 0.36     20090127  G.Tani      2.5
 0.37     20090224  G.Tani      2.5.1
 0.38     20090403  G.Tani      2.6.beta
 0.39     20090430  G.Tani      2.6
 0.40     20090604  G.Tani      2.6.1
 0.41     20090611  G.Tani      2.6.2
 0.42     20090713  G.Tani      2.6.3
 0.43     20090826  G.Tani      2.7.beta
 0.44     20090914  G.Tani      2.7
 0.45     20091017  G.Tani      2.7.1
 0.46     20091105  G.Tani      2.8.beta
 0.47     20091118  G.Tani      2.8
 0.48     20091202  G.Tani      2.8.1
 0.49     20100104  G.Tani      2.9.beta
 0.50     20100114  G.Tani      2.9
 0.51     20100124  G.Tani      2.9.1
 0.52     20100209  G.Tani      3.0.beta
 0.53     20100216  G.Tani      3.0
 0.54     20100408  G.Tani      3.1.beta
 0.55     20100424  G.Tani      3.1
 0.56     20100613  G.Tani      3.2
 0.57     20100626  G.Tani      3.2.1
 0.58     20100914  G.Tani      3.3
 0.59     20101023  G.Tani      3.4
 0.60     20101123  G.Tani      3.5
 0.61     20101212  G.Tani      3.5.1
 0.62     20101224  G.Tani      3.6
 0.63     20110209  G.Tani      3.6.1
 0.64     20110221  G.Tani      3.6.2
 0.65     20110406  G.Tani      3.7
 0.66     20110611  G.Tani      3.8
 0.67     20110731  G.Tani      3.9
 0.68     20110825  G.Tani      3.9.1
 0.69     20110918  G.Tani      4.0
 0.70     20111016  G.Tani      4.1
 0.71     20111120  G.Tani      4.2
 0.72     20111224  G.Tani      4.3
 0.73     20120128  G.Tani      4.4
 0.74     20120407  G.Tani      4.5
 0.75     20120501  G.Tani      4.5.1
 0.76     20120612  G.Tani      4.6
 0.77     20120702  G.Tani      4.6.1
 0.78     20120807  G.Tani      4.7
 0.79     20120818  G.Tani      4.7.1
 0.80     20120914  G.Tani      4.7.2
 0.81     20121014  G.Tani      4.7.3
 0.82     20121118  G.Tani      4.8
 0.83     20130117  G.Tani      4.8.1
 0.84     20130304  G.Tani      4.9
 0.85     20130323  G.Tani      4.9.1
 0.86     20130421  G.Tani      4.9.2
 0.87     20130617  G.Tani      5.0.0
 0.88     20130718  G.Tani      5.0.1
 0.89     20130830  G.Tani      5.1.0
 0.90     20131002  G.Tani      5.1.1
 0.91     20131122  G.Tani      5.2.0
 0.92     20131225  G.Tani      5.2.1
 0.93     20140221  G.Tani      5.2.2
 0.94     20140410  G.Tani      5.3.0
 0.95     20140502  G.Tani      5.3.1
 0.96     20140707  G.Tani      5.4.0
 0.97     20140810  G.Tani      5.4.1
 0.98     20141015  G.Tani      5.5.0
 0.99     20141201  G.Tani      5.5.1
 1.00     20141220  G.Tani      5.5.2
 1.01     20150117  G.Tani      5.5.3
 1.02     20150425  G.Tani      5.6.0
 1.03     20150613  G.Tani      5.6.1
 1.04     20150718  G.Tani      5.7.0
 1.05     20150811  G.Tani      5.7.1
 1.06     20150824  G.Tani      5.7.2
 1.07     20151003  G.Tani      5.8.0
 1.08     20151018  G.Tani      5.8.1
 1.09     20151125  G.Tani      5.9.0
 1.10     20151227  G.Tani      5.9.1
 1.11     20160221  G.Tani      6.0.0
 1.12     20160424  G.Tani      6.0.1
 1.13     20160512  G.Tani      6.0.2
 1.14     20160618  G.Tani      6.0.3
 1.15     20160721  G.Tani      6.1.0
 1.16     20160909  G.Tani      6.1.1
 1.17     20161101  G.Tani      6.2.0
 1.18     20161226  G.Tani      6.3.0
 1.19     20170205  G.Tani      6.3.1
 1.20     20170323  G.Tani      6.4.0
 1.21     20170429  G.Tani      6.4.1
 1.22     20171014  G.Tani      6.5.0
 1.23     20180208  G.Tani      6.5.1
 1.24     20180503  G.Tani      6.6.0
 1.25     20181024  G.Tani      6.6.1
 1.26     20190205  G.Tani      6.7.0
 1.27     20190309  G.Tani      6.7.1
 1.28     20190413  G.Tani      6.7.2
 1.29     20190501  G.Tani      6.8.0
 1.30     20190613  G.Tani      6.8.1
 1.31     20190815  G.Tani      6.9.0
 1.32     20190825  G.Tani      6.9.1
 1.33     20190831  G.Tani      6.9.2
 1.34     20191125  G.Tani      7.0.0
 1.35     20191228  G.Tani      7.0.1
 1.36     20200201  G.Tani      7.1.0
 1.37     20200307  G.Tani      7.1.1
 1.38     20200406  G.Tani      7.2.0
 1.39     20200424  G.Tani      7.2.1
 1.40     20200505  G.Tani      7.2.2
 1.41     20200514  G.Tani      7.3.0
 1.42     20200531  G.Tani      7.3.1
 1.43     20200618  G.Tani      7.3.2
 1.44     20200820  G.Tani      7.4.0
 1.45     20200905  G.Tani      7.4.1
 1.46     20200929  G.Tani      7.4.2
 1.47     20201110  G.Tani      7.5.0
 1.48     20201212  G.Tani      7.6.0
 1.49     20210105  G.Tani      7.7.0
 1.50     20210210  G.Tani      7.7.1
 1.51     20210315  G.Tani      7.8.0
 1.52     20210417  G.Tani      7.9.0
 1.53     20210609  G.Tani      8.0.0
 1.54     20210720  G.Tani      8.1.0
 1.55     20210909  G.Tani      8.2.0
 1.56     20211111  G.Tani      8.3.0
 1.57     20211212  G.Tani      8.4.0
 1.58     20220219  G.Tani      8.5.0
 1.59     20220406  G.Tani      8.6.0
 1.60     20220622  G.Tani      8.7.0
 1.61     20220814  G.Tani      8.8.0
 1.62     20221008  G.Tani      8.9.0
 1.63     20221215  G.Tani      9.0.0
 1.64     20230221  G.Tani      9.1.0

BACKEND
Improved Backend binaries option group in Options > Settings, Advanced tab
 Added option to dynamically limit 7z syntax to 21.07 release (avoiding switches introduced later), in order to improve portability of the app to platform not having latest 7z build available, or when it is preferred to adhere to an older syntax to maintain compatibility with legacy systems
 Option to use the system's version of 7z backend, rather than the one provided by PeaZip package, is now supported on all non-Windows systems; a binary or a link named 7z in system's paths is required for this feature
Pea 1.12

CODE
Various fixes and code clean-up
Improved support for BSD systems

FILE MANAGER
General usability improved with easiser to spot open in a new tab, open in a new window controls, made easier to open console in current path, and made easier to access to clipboard content
 Improved smart filename sorting
 Improved search in archives, Simple search directive (can be toggled on / off from Organize menu) now applies globally for searches in archives as well as in the filesystem
 Simplified finding duplicate files and calculating files hash/checksumss in the file browser
  In Options > Settings, File manager tab it is now possible to set the file deduplication mode, fast (default) or complete file content parsing
New "Enlarge file browser icons" switch in main menu, Organize to use larger icons in all modes of the file browser
Updated Themes and graphic
 Themes screen layout simplified with less frequently used settings moved in Advanced group
 Zooming option can now both reduce and increase size of graphic elements
 Major restyle of themed and non-themed icons to better match the UI of modern systems
 Updated all Theme packages
Updated layout for options in all screens (archiving, extraction, settings...)

EXTRACTION and ARCHIVING
Adding files in subdirectories of existing archives now displays also the internal (in-archive) destination path in the confirmation dialog
Can now export archive conversion tasks defined in the GUI as CLI scripts
 "Archive conversion scripts allow user's interaction" (default on) in Options > Settings > Archive manager, Archive group, allows to interactively customize conversion tasks saved as scripts when launched, otherwise the task will run as batch requiring no interaction and applying current application's settings
Improved archiving and extraction screens
 "Extract then move to destination" setting moved to main extraction screen for better visibility
  Added link to working folder settings (in Settings, General) on the right of the control
 Set default output path for archiving and extraction moved in archiving and extraction context menus for better visibility
Improved responsivity of Windows context menu items, 15 - 40% faster than 9.0.0 release
Improved auto extraction of compressesd TAR archives
 Added progress bar for the auto-untar step after de-compression
 Auto-untar step is cancelled if the task ends in error or is cancelled
 Fixed auto-untar function when extracting multiple archives at once
Improved support for Brotli and Zstandard
 Can now set option to force overwriting existing files from extraction screen
 Fixed extraction of Zstd files with long distance matching (windowLog > 27)
 Maximize Zstandard compression option now sets --long=31 instead of --long=27
New option to exclude empty directories form archiving and extraction operations (7z / p7zip) in Options > Settings > Archive manager

INSTALLERS
New PeaZip Portable package for BSD systems (GTK2, x86_64)
(Linux) Updated KDE 5 Dolphin sample service menus in (peazip)/res/share/batch/freedesktop_integration directory

230 file extensions supported

Translations updated and replaced in the package

--------------------------------------------------------------------------------
Status of Unicode support (tested on Lazarus 1.6.0)
1 - (cross-platform) Get Unicode paramstrings > natively supported
2 - (cross-platform) Handle Unicode strings and filenames > natively supported
3 - (Windows) Launch processes supporting Unicode > using tprocessutf8 instead
of tprocess works without requiring workarounds used in 5.8/5.9 releases.
(Unix-like) No issues about full Unicode support are known on *x systems.
--------------------------------------------------------------------------------
Zpaq support limitations
1 - Browsing of .zpaq archives is currently possible only in flat mode due to
PeaZip browser frontent limitations
2 - Partial extraction is not implemented in PeaZip extraction frontent as it is
supported only for absolute paths by design of the format/backend
--------------------------------------------------------------------------------
Export Convert tasks as scripts limitations
Exporting GUI task as script, if Convert archive flag is set, calls PeaZip
binary itself rather than backend binaries.
This is needed because archive conversion, as performed by PeaZip, needs extra
steps which backend binaries are not always able to perform, mainly:
- dynamically create a temporary fresh new work folder in which extraction step
will take place (some binaries will not force creation of non existing dirs)
- remove the intermediate dir, if the archive contains a single directory in the
root, to avoid to add an unwanted extra level of directory nesting in the
resulting archive (this would be complicated and not always possible to automate
relying on backend binaries only)
This solution limits the conversion to either run with current PeaZip's default
options (not requiring interaction, better for batch use), or to prompt the full
GUI to let the user customize the task on the fly (requires interaction).
--------------------------------------------------------------------------------
Performances

Due the use of TListView component browser rendering performances, in filesystem
and archives, are limited to few thousands of files - in the same directory or
search filter - to operate in real near time; 10s thousands of files are
rendered in a matter of seconds producing a noticeable delay.
A1) Auto-refresh delay, browsing the filesystem, is increased starting from 4K
items, and disabled at 16K items.
A2) Switching to flat mode listing raises warning message always in filesystem,
and starting from 64K items in archives (number of items is found during
pre-parsing, B1).

PeaZip pre-parse 7z/p7zip supported formats at opening in order to warn users in
advance of possible issues.
B1) check if full actual content of the archive can be listed (list -l option),
regardless of what is declared in TOC table (which may be corrpted or have been
maliciosly modified), which scales reasonably up to 1.5M files.
B2) scan for non explicitly listed dirs, which scales slowly and is maxed at
256K files.
B3) scan for number of files, folders, and uncompressed content size contained
in each folder, which scales slowly and is maxed at 32K files in archive.
B4) treeview representation of the structure of archive directories is limited
to 4K dirs, value set by MAXNDIRTREE constant, due to the poor scalability of
the specific code.

PeaZip lists 7z/p7zip supported formats using the more informative -slt option,
which is slower and uses more memory.
C1) PeaZip browse / search archives is allowed to scale up to 0.5M files to be
display at once
C2) same setting is used to scan archives for encrypted content (if applicable
for current format/operation), and scales as C1 up to 0.5M files.

Browser performances dropdown (Options > Settings, Performances) internally sets
prebrowse variable which controls the behavior of the application.
"Always pre-parse" will not stop pre-parsing B1, B2 nor listing C1 regadless the
number of found items, even if performances can be poor for very large archives
"Do not pre-parse" will skip pre-parsing A1 and otherwise uses same settings as
Fastest mode.
Following table showhs limitations in number of items allowed to be process for
Slow to Fastest modes, and the amount of memory the application is allowed to
use for B1, C1, C2 operations

                      list at once   pre-parse   scan for dirs   dir content
          memory      C1, C2 -slt    B1 -l       B2              B3
Always    unlimited   unlimited      unlimited   unlimited       32K
Slow      192 MB      0.5M           1.5M+	 256K            16K
Medium    64 MB	      160K           0.5M+	 256K            16K
Fast      32 MB	      80K            256K+	 128K            16K
Fastest   16 MB	      40K            128K+	  64K            16K
Never     16 MB       40K            no/128K+      8K             8K

In any case archives that cannot be browsed can still be directly listed, tested
and extracted.

Details
1a - execute_cl reading backend output will start using 8 MB of memory and will
increase to 16, 32, and 64 MB (doubled for listing), the latter approximately
sufficient for pre-parsing 0.5M files or listing 400K files at once, then will
keep increasing as needed (slow)
1b - pre-parsing the full content of the archive at opening will stop as set by
prebrowse variable, and can be omitted with Do not prebrowse (5) setting
1c - searching for encrypted content in archive will stop accordingly to
prebrowse setting (will not be skipped with 5)
2a - list_slt table used for browsing is allocated up to 0.5 M files and will
then increase (slow) as needed, while list_l table used for pre-parsing is
allocated to the needed size, unless pre-parsing was stopped at 1b
2b - scanning for omitted directories, which scales slowly, will stop
accordingly to prebrowse setting, maxed to 256K files

--------------------------------------------------------------------------------

(C) Copyright 2006 Giorgio Tani giorgio.tani.software@gmail.com
Official PeaZip site: se const FIRSTDOM and SECONDDOM
The program is released under GNU LGPL https://www.gnu.org/licenses/lgpl.txt

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 3 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
}

{$mode objfpc}{$H+}
{$IFDEF DARWIN}
{$modeswitch ObjectiveC1}
{$linkframework CoreFoundation}
{$ENDIF}
interface

uses
{$IFDEF MSWINDOWS}
Windows, activex, ShlObj, ComObj, shellapi, windirs,
{$ENDIF}
{$IFDEF DARWIN}MacOSAll, CocoaAll,{$ENDIF}
LResources, Forms, Controls, Graphics, Dialogs, EditBtn,
StdCtrls, Buttons, ExtCtrls, ComCtrls, Grids, Menus, Spin, ShellCtrls, Masks,
hash, adler32, CRC16, CRC24, CRC32, CRC64, ED2K, MD4, MD5, RMD160, SHA1, SHA3_256,
SHA256, SHA3_512, SHA512, Whirl512, Blake2s, Blake2b, mem_util, AES_EAX, FCAES256,
list_utils,pea_utils,ansiutf8_utils,img_utils,
unit_gwrap,unit1,unit2,unit3,unit5,unit6,Unit7,Unit8,Unit9,Unit10,Unit11,Unit12,Unit13,
Classes, SysUtils, Process, UTF8Process, dateutils, fileutil, Types;

type

   { TMyThread }

   TMyThreaddrop = class(TThread)
   private
      vpath:ansistring;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThreadimg = class(TThread)
   private
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThreadexe = class(TThread)
   private
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThread1 = class(TThread)
   private
      fi:integer;
      fs,fread:ansistring;
      fbitmap:Tbitmap;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThread2 = class(TThread)
   private
      fi:integer;
      fs,fread:ansistring;
      fbitmap:Tbitmap;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThread3 = class(TThread)
   private
      fi:integer;
      fs,fread:ansistring;
      fbitmap:Tbitmap;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThread4 = class(TThread)
   private
      fi:integer;
      fs,fread:ansistring;
      fbitmap:Tbitmap;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TClipContent = array of array [0..6] of ansistring;
   Thistarray = array[1..8]of ansistring;

   { TForm_peach }

   TForm_peach = class(TForm)
     baboutfaq: TSpeedButton;
     baboutlocalhelp: TSpeedButton;
     baboutbin: TSpeedButton;
     baboutremoveunace: TSpeedButton;
     baboutremoveunrar: TSpeedButton;
     baboutsupport: TSpeedButton;
     babouttracker: TSpeedButton;
     baboutweb: TSpeedButton;
     baboutplugindir: TSpeedButton;
     Bevel11: TShape;
     Bevel12: TShape;
     Bevel13: TShape;
     Bevel14: TShape;
     Bevel15: TShape;
     Bevel16: TShape;
     Bevel18: TShape;
     Bevel20: TShape;
     BevelTitleOpt1: TPanel;
     BevelTitleOpt2: TPanel;
     BevelTitleOpt3: TPanel;
     BevelTitleOpt4: TPanel;
     BevelTitleOpt5: TPanel;
     BevelTitleOpt6: TPanel;
     BevelTitleOpt7: TPanel;
     BevelTitleOpt8: TPanel;
     BevelTitleOptions2: TPanel;
     BevelTitleOptions6: TPanel;
     BevelTitleOptions7: TPanel;
     BevelTitleOptions8: TPanel;
     BSchedule: TBitBtn;
     BSchedule1: TBitBtn;
     Button1: TBitBtn;
     Button2: TBitBtn;
     ButtonDesk1: TButton;
     ButtonEditName12: TSpeedButton;
     ButtonEditName14: TSpeedButton;
     ButtonEditName3: TButton;
     ButtonEditName4: TSpeedButton;
     ButtonEditName5: TButton;
     ButtonEditName6: TButton;
     ButtonEditName8: TSpeedButton;
     ButtonEditNameCustom: TButton;
     ButtonEditNameCustom1: TButton;
     Buttonfmactions1: TSpeedButton;
     ButtonRefSize: TButton;
     ButtonUn7za10: TSpeedButton;
     ButtonUn7za11: TSpeedButton;
     cbadvf1: TCheckBox;
     cbadvf2: TCheckBox;
     cbdeleteinputmode: TComboBox;
     cbdeleteinputmode1: TComboBox;
     cbencext: TCheckBox;
     cbensmall: TComboBox;
     cbExtEvForHow: TComboBox;
     cbRAR: TCheckBox;
     cbRARBLAKE2: TCheckBox;
     cbRARlastmodtime: TComboBox;
     cbRARlock: TCheckBox;
     cbRARsaveopen: TCheckBox;
     cbRARsavesecurity: TCheckBox;
     cbRARsavestreams: TCheckBox;
     cbRARsfx: TCheckBox;
     cbRARrr: TCheckBox;
     cbRARsolid: TCheckBox;
     cbdefaultaction: TComboBox;
     cbSys7zlin: TCheckBox;
     cbtimecreated: TCheckBox;
     cbType: TComboBox;
     cbUn7zaRecursive: TCheckBox;
     cbUn7zaRecursiveExclude: TCheckBox;
     cbzooming: TComboBox;
     CheckBox1: TCheckBox;
     CheckBox2: TCheckBox;
     CheckBox3: TCheckBox;
     cbautoclosesingleextract: TCheckBox;
     cbEncoding1: TComboBox;
     cbcustext: TCheckBox;
     cbspacing: TComboBox;
     CheckBox7zunrar5: TCheckBox;
     CheckBoxAccentToolBar: TComboBox;
     CheckBoxAltBar: TComboBox;
     CheckBoxAltgridcol: TCheckBox;
     CheckBoxAltTab: TComboBox;
     CheckBoxAlttabcol: TComboBox;
     CheckBoxArchiveOF: TCheckBox;
     CheckBoxAutoExtTar: TCheckBox;
     CheckBoxAutoExtTar1: TCheckBox;
     cbqdup: TCheckBox;
     CheckBoxAutoTest: TCheckBox;
     CheckBoxAutoOpen: TCheckBox;
     CheckBoxClosePeaZip: TCheckBox;
     CheckBoxEditArchives: TCheckBox;
     CheckBoxEnumd: TCheckBox;
     CheckBoxAC: TCheckBox;
     CheckBoxFolder1: TCheckBox;
     CheckBoxForceConvert: TCheckBox;
     CheckBoxExcludeEF: TCheckBox;
     CheckBoxForceLayout: TCheckBox;
     CheckBoxrelative: TCheckBox;
     CheckBoxSkipenc: TCheckBox;
     CheckBoxsnoi: TCheckBox;
     CheckBoxsnh: TCheckBox;
     CheckBoxsnl: TCheckBox;
     CheckBoxsnon: TCheckBox;
     CheckBoxsnz1: TCheckBox;
     CheckBoxCenteredToolbar: TCheckBox;
     CheckBoxSolidAddress: TComboBox;
     CheckBoxssp: TCheckBox;
     CheckBoxstl: TCheckBox;
     CheckBoxzpaqabsolute: TCheckBox;
     CheckBoxzpaqall: TCheckBox;
     CheckBoxzpaqforce: TCheckBox;
     CheckBoxzpaqfull: TCheckBox;
     ComboBoxMaxArg: TComboBox;
     ComboBoxSyntaxLevel: TComboBox;
     ComboBoxmemuse: TComboBox;
     ComboBoxTAR: TComboBox;
     ComboBoxTAR1: TComboBox;
     ComboBoxTheme: TComboBox;
     ConsoleCreate: TPanel;
     ConsoleOpen: TPanel;
     csvsepchar: TLabel;
     CheckBoxSkipDel: TCheckBox;
     ComboBoxLanguage: TComboBox;
     Edit6: TEdit;
     EditCSVsep: TEdit;
     EditOpenOut1: TEdit;
     EditUn7zaFilterExclude: TEdit;
     gbConsoleCreate: TPanel;
     gbConsoleCreate1: TPanel;
     iConsoleCreateImport: TImage;
     iConsoleCreateImport1: TImage;
     Image7zPj: TBitBtn;
     Image7zPj1: TBitBtn;
     Image7zPj3: TBitBtn;
     ImageInfoArchive3: TImage;
     ImageInfoArchive4: TImage;
     ImageUn7zPj: TBitBtn;
     ImOpt1: TImage;
     ImageFlat: TSpeedButton;
     ImageFlatadd: TSpeedButton;
     ImageFlatext: TSpeedButton;
     ImageFlattestmore: TSpeedButton;
     ImagePassword: TSpeedButton;
     ImOpt2: TImage;
     ImOpt3: TImage;
     ImOpt4: TImage;
     ImOpt5: TImage;
     ImOpt6: TImage;
     ImOpt7: TImage;
     ImOpt8: TImage;
     Label11: TLabel;
     Label12: TLabel;
     LabelAddFolder: TLabel;
     Labeladvextzpaq: TLabel;
     Labeladvextzpaq1: TLabel;
     LabelColor4: TLabel;
     LabelColorTabs1: TLabel;
     labelmaxarg: TLabel;
     Labelo1: TLabel;
     Labelo2: TLabel;
     Labelo3: TLabel;
     Labelo4: TLabel;
     Labelo5: TLabel;
     Labelo6: TLabel;
     Labelo7: TLabel;
     Labelo8: TLabel;
     Labeloptsub8: TLabel;
     Labelsmsize: TLabel;
     LabelStatus10: TLabel;
     LabelStatus9: TLabel;
     Labelsyntaxlevel: TLabel;
     Labelmemuse: TLabel;
     labelCheckBoxSolidAddress: TLabel;
     LabelStatus6d: TLabel;
     LabelStatus6c: TLabel;
     LabelStatus6b: TLabel;
     LabelStatus8: TLabel;
     LabelStatus6a: TLabel;
     LabelColorToolbar: TLabel;
     LabelColorAddressbar: TLabel;
     LabelColorTabs: TLabel;
     Labelmoreopt: TLabel;
     LabelForceLayout: TLabel;
     CheckBoxExtrac32: TCheckBox;
     CheckBoxForceBrowse: TCheckBox;
     CheckBoxExtAnd: TCheckBox;
     ComboBoxKiB: TComboBox;
     ComboBoxPriority: TComboBox;
     Editcommonalgo: TEdit;
     editcustext: TEdit;
     editExtEvForWhat: TEdit;
     Labelcb15: TLabel;
     Labelcb16: TLabel;
     LabelColor2d: TLabel;
     LabelColPresets: TLabel;
     Labelmoreopt1: TLabel;
     Labeloafter: TLabel;
     Labeloptsub5: TLabel;
     Labeloptsub6: TLabel;
     Labeloptsub7: TLabel;
     Labelspac5: TLabel;
     LabelAddFiles: TLabel;
     LabelStatusClip: TLabel;
     LabelStatus4: TLabel;
     LabelStatus5: TLabel;
     Labeltaropt: TLabel;
     Labeltaropt1: TLabel;
     LabelTitleOptions1: TLabel;
     LabelTitleOptions2: TLabel;
     LabelTitleOptions3: TLabel;
     LabelTitleOptions4: TLabel;
     LabelTitleOptions5: TLabel;
     LabelTitleOptions6: TLabel;
     LabelTitleOptions7: TLabel;
     LabelTitleOptions8: TLabel;
     Labelspacing: TLabel;
     Labelsetwork: TLabel;
     Labelzooming: TLabel;
     lConsoleCreate_jobcode: TLabel;
     lConsoleCreate_jobcode1: TLabel;
     lConsoleCreate_outname: TLabel;
     lConsoleCreate_outname1: TLabel;
     Lpriority: TLabel;
     CheckBoxNoConf: TCheckBox;
     CheckBoxzipxswitch: TCheckBox;
     CheckBoxZstd: TCheckBox;
     CheckBoxConvert0: TCheckBox;
     CheckBoxDragDrop: TCheckBox;
     CheckBoxEncoding: TCheckBox;
     CheckBoxForceEdit: TCheckBox;
     CheckBoxAutoOpenTar: TCheckBox;
     CheckBoxJobEncoding: TCheckBox;
     CheckBoxForceOpen: TCheckBox;
     CheckBoxPrebrowse: TLabel;
     CheckBoxBrotli: TCheckBox;
     CheckBoxShowVolatile: TCheckBox;
     CheckBoxsni: TCheckBox;
     CheckBox4: TCheckBox;
     CheckBoxsni1: TCheckBox;
     CheckBoxsns: TCheckBox;
     CheckBoxARC1: TCheckBox;
     CheckBoxARC2: TCheckBox;
     CheckBoxARC3: TCheckBox;
     CheckBoxArchive4: TCheckBox;
     CheckBoxArchive6: TCheckBox;
     CheckBoxArchiveHistory: TCheckBox;
     CheckBoxAutoHaltA: TCheckBox;
     CheckBoxAutoHaltE: TCheckBox;
     CheckBoxBrowseNotVerbose: TCheckBox;
     CheckBoxConvert: TCheckBox;
     CheckBoxConvert1: TCheckBox;
     CheckBoxDate: TCheckBox;
     CheckBoxDeleteInput: TCheckBox;
     CheckBoxDeleteInput1: TCheckBox;
     CheckBoxFolder: TCheckBox;
     CheckBoxIgnoreDisp: TCheckBox;
     CheckBoxIgnoreSel: TCheckBox;
     CheckBoxIntDir: TCheckBox;
     CheckBoxMailKeep: TCheckBox;
     CheckBoxMQS: TCheckBox;
     CheckBoxNameAsParentFolder: TCheckBox;
     CheckBoxnetworkinfo: TCheckBox;
     CheckBoxParallelArchiving: TCheckBox;
     CheckBoxQuadMax: TCheckBox;
     CheckBoxSameArc: TCheckBox;
     CheckBoxSameExt: TCheckBox;
     CheckBoxSeparate: TCheckBox;
     CheckBoxShowHints: TCheckBox;
     CheckBoxsns1: TCheckBox;
     CheckBoxTarBefore: TCheckBox;
     CheckBoxUnPeaAttributes: TCheckBox;
     CheckBoxUPX1: TCheckBox;
     CheckBoxUPX2: TCheckBox;
     CheckBoxWindowStatus: TCheckBox;
     CheckBoxzcopy: TCheckBox;
     cbRAR5: TCheckBox;
     CheckGroupM1: TCheckGroup;
     CheckGroupM2: TCheckGroup;
     CheckGroupW: TCheckGroup;
     CheckGroupW1: TCheckGroup;
     ColorButton1: TColorButton;
     ColorButton2: TColorButton;
     ColorButton3: TColorButton;
     ComboBox1: TComboBox;
     ComboBoxDrag: TComboBox;
     comboRARdict: TComboBox;
     ComboBoxWD: TComboBox;
     ComboBoxLibre: TComboBox;
     ComboBoxprivacy: TComboBox;
     ComboBox7zalgo: TComboBox;
     ComboBoxARC: TComboBox;
     ComboBoxARC2: TComboBox;
     ComboBoxARCalgo: TComboBox;
     ComboBoxArchive1: TComboBox;
     ComboBoxArchiveAct: TComboBox;
     ComboBoxArchive2: TComboBox;
     ComboBoxArchive3: TComboBox;
     ComboBoxArchive4: TComboBox;
     ComboBoxArchive5: TComboBox;
     ComboBoxArchive6: TComboBox;
     ComboBoxArchive7: TComboBox;
     ComboBoxArchive8: TComboBox;
     ComboBoxArchive9: TComboBox;
     ComboBoxArchiveAct1: TComboBox;
     ComboBoxArchiveCustom: TComboBox;
     ComboBoxArchiveCustom1: TComboBox;
     ComboBoxArchivePasses: TComboBox;
     ComboBoxArchivePaths: TComboBox;
     ComboBoxArchivePaths1: TComboBox;
     ComboBoxArchiveSolid: TComboBox;
     ComboBoxArchiveSolid1: TComboBox;
     ComboBoxArcSfx: TComboBox;
     ComboBoxArcSolid: TComboBox;
     ComboBoxM2: TComboBox;
     ComboBoxM3: TComboBox;
     ComboBoxOverwrite: TComboBox;
     ComboBoxOverwriteARC: TComboBox;
     ComboBoxPAQ1: TComboBox;
     ComboBoxPasses: TComboBox;
     ComboBoxPEA2: TComboBox;
     ComboBoxPEA3: TComboBox;
     ComboBoxPEA4: TComboBox;
     ComboBoxPEACompression1: TComboBox;
     ComboBoxSD: TComboBox;
     ComboBoxSplit3: TComboBox;
     ComboBoxUPX: TComboBox;
     ComboBoxBrowser: TComboBox;
     CompressionARC: TPanel;
     CompressionCustom: TPanel;
     CompressionCustom1: TPanel;
     ctrlext: TSpeedButton;
     ctrlarc: TSpeedButton;
     DateEdit1: TDateEdit;
     DateEdit2: TDateEdit;
     DateEdit3: TDateEdit;
     DateEdit4: TDateEdit;
     Edit1: TEdit;
     Edit2: TEdit;
     Edit3: TEdit;
     Edit4: TEdit;
     Edit5: TEdit;
     EditEncoding: TEdit;
     Edit7: TEdit;
     EditDesk: TEdit;
     EditExtCustom: TEdit;
     EditName3: TEdit;
     EditNameCustom: TEdit;
     EditNameCustom1: TEdit;
     EditOP: TEdit;
     EditOParc: TEdit;
     EditOPcustom: TEdit;
     EditOPcustom1: TEdit;
     EditOpenOut: TEdit;
     EditSchedulePassword: TEdit;
     EditSchedulePassword1: TEdit;
     EditScheduleUser: TEdit;
     EditScheduleUser1: TEdit;
     EditUn7zaFilter: TEdit;
     EditUn7zaFilter1: TEdit;
     Group7za1: TPanel;
     Group7za2: TPanel;
     GroupBox12: TPanel;
     GroupBox4: TPanel;
     GroupBoxCreateOut: TPanel;
     GroupBoxCreateOut1: TPanel;
     GroupBoxPEAAdvanced1: TPanel;
     iadvextract: TImage;
     il_dtheme_48: TImageList;
     il_dtheme_96: TImageList;
     ImageListDlg: TImageList;
     Imagesp1: TImage;
     ImageInfoDefault1: TImage;
     ImageInfoDefault2: TImage;
     ImagePassword3: TSpeedButton;
     Imagesp: TImage;
     Labelcb18: TLabel;
     Labelcb19: TLabel;
     LabelColor2b: TLabel;
     Labellightpresets: TLabel;
     Labelenc: TLabel;
     LabelAdvThemes: TLabel;
     lsetdefaultout_arc: TLabel;
     Labelextevfor: TLabel;
     LabelConfigurearc: TLabel;
     LabelConfigureext: TLabel;
     Labeloamext1: TLabel;
     Labelrr: TLabel;
     labelRARdict: TLabel;
     Labelconsoleencoding: TLabel;
     Labeladvextace: TLabel;
     LabelColor2: TLabel;
     LabelColor3: TLabel;
     LabelConfigurePw: TLabel;
     Labelcwd: TLabel;
     LabelAppPath: TLabel;
     Labelcb17: TLabel;
     LabelcbSD: TLabel;
     LabelcbSDcustom: TLabel;
     LabelConf: TLabel;
     LabelConf1: TLabel;
     LabelConfigureSendTo: TLabel;
     LabelDefaultColor2: TLabel;
     LabelDefaultColor3: TLabel;
     LabelDefaultOpacity: TLabel;
     LabelInfoGeneral: TLabel;
     Labeloaenc: TLabel;
     Labeloaui: TLabel;
     Labelogpaths: TLabel;
     LabelOpacity: TLabel;
     Labelspac4: TLabel;
     LabelErrors: TLabel;
     LabelStatus7: TLabel;
     lsetdefaultout_ext: TLabel;
     eowrun: TMenuItem;
     lightdim: TMenuItem;
     lightlow: TMenuItem;
     lightmocha: TMenuItem;
     lightsenape: TMenuItem;
     lightgraphite: TMenuItem;
     lightplum: TMenuItem;
     mConsoleCreate: TMemo;
     mConsoleCreate1: TMemo;
     MemoList: TMemo;
     maltbk: TMenuItem;
     maltfw: TMenuItem;
     aabc1: TMenuItem;
     aabc2: TMenuItem;
     aabc3: TMenuItem;
     aabc4: TMenuItem;
     aabc5: TMenuItem;
     aabc6: TMenuItem;
     aabc7: TMenuItem;
     aabc8: TMenuItem;
     apmbcexpand: TMenuItem;
     mdownloadthemes: TMenuItem;
     mdirbeforefiles: TMenuItem;
     mdefaultextract: TMenuItem;
     mdefaultarchive: TMenuItem;
     pmbcnw: TMenuItem;
     pmtabscloseall: TMenuItem;
     pmtabsnewwindow: TMenuItem;
     pmbccp: TMenuItem;
     pmbcps: TMenuItem;
     pmclip: TMenuItem;
     po_clip: TMenuItem;
     po_dedup: TMenuItem;
     po_windowopen: TMenuItem;
     mlargeicons: TMenuItem;
     mfunextract: TMenuItem;
     mfunadd: TMenuItem;
     MenuItemShowColMenu: TMenuItem;
     Panela: TPanel;
     Panele: TPanel;
     PanelExtZPAQ: TPanel;
     pmshowstylemenu: TMenuItem;
     PanelSPaddress: TPanel;
     pmmoretest: TMenuItem;
     MenuItemToggleNav: TMenuItem;
     pmfilebrowser: TMenuItem;
     Separator24: TMenuItem;
     Separator17: TMenuItem;
     pnbce1: TMenuItem;
     pnbce2: TMenuItem;
     pnbce3: TMenuItem;
     pnbce4: TMenuItem;
     pnbce5: TMenuItem;
     pnbce6: TMenuItem;
     pnbce7: TMenuItem;
     pnbce8: TMenuItem;
     pnhe1: TMenuItem;
     pnhe2: TMenuItem;
     pnhe3: TMenuItem;
     pnhe4: TMenuItem;
     pnhe5: TMenuItem;
     pnhe6: TMenuItem;
     pnhe7: TMenuItem;
     pnhe8: TMenuItem;
     pnbce0: TMenuItem;
     Separator23: TMenuItem;
     pnbcf1: TMenuItem;
     pnbcf2: TMenuItem;
     pnbcf3: TMenuItem;
     pnbcf4: TMenuItem;
     pnbcf5: TMenuItem;
     pnbcf6: TMenuItem;
     pnbcf7: TMenuItem;
     pnbcf8: TMenuItem;
     pnbcf0: TMenuItem;
     Separator22: TMenuItem;
     Separator21: TMenuItem;
     pnhe0: TMenuItem;
     pnhf1: TMenuItem;
     pnhf2: TMenuItem;
     pnhf3: TMenuItem;
     pnhf4: TMenuItem;
     pnhf5: TMenuItem;
     pnhf6: TMenuItem;
     pnhf7: TMenuItem;
     pnhf8: TMenuItem;
     pnhf0: TMenuItem;
     Separator20: TMenuItem;
     pmmain: TPopupMenu;
     Separator19: TMenuItem;
     Separator18: TMenuItem;
     po_addsep: TMenuItem;
     Separator25: TMenuItem;
     ShapeThemes: TShape;
     ShapeProgress: TPanel;
     ShapeThemes1: TShape;
     ShapeThemes2: TShape;
     StringGridTB: TStringGrid;
     tabaddress: TMenuItem;
     pmquickdownloads: TMenuItem;
     Separator16: TMenuItem;
     Separator12: TMenuItem;
     mtoggletool: TMenuItem;
     mhbook: TMenuItem;
     mhhist: TMenuItem;
     mhaltup: TMenuItem;
     mhpwf9: TMenuItem;
     mhsearchf3: TMenuItem;
     mhmenunavf4: TMenuItem;
     mhrenamef2: TMenuItem;
     mhiddennav: TMenuItem;
     Separator15: TMenuItem;
     pmsstatus: TMenuItem;
     pmsno: TMenuItem;
     menupw: TMenuItem;
     MenuItemInfomenu: TMenuItem;
     MenuItemInfo: TMenuItem;
     MenuItemToggleStatus: TMenuItem;
     Separator14: TMenuItem;
     Separator13: TMenuItem;
     pmtoollarge: TMenuItem;
     pmtoolmedium: TMenuItem;
     MenuItemTB: TMenuItem;
     PanelTitleAppsTabAlign: TPanel;
     Separator10: TMenuItem;
     mshowstatusbar: TMenuItem;
     mshownavbar: TMenuItem;
     mshowtoolbar: TMenuItem;
     pmstatusnone: TMenuItem;
     pmtoolnone: TMenuItem;
     msettings: TMenuItem;
     pmsbookmarks: TMenuItem;
     pmshistory: TMenuItem;
     pmssession: TMenuItem;
     pmsclipboard: TMenuItem;
     pmshowmenu: TMenuItem;
     pmstatus: TPopupMenu;
     Separator11: TMenuItem;
     pmtoolsmall: TMenuItem;
     PanelTitleExtractTabAlign: TPanel;
     PanelTitleAddTabAlign: TPanel;
     Separator9: TMenuItem;
     po_showquicknavmenu: TMenuItem;
     Separator8: TMenuItem;
     pmshowmainmenu: TMenuItem;
     Separator7: TMenuItem;
     mverifyself: TMenuItem;
     pmshowsearch: TMenuItem;
     PopupLightPresets: TPopupMenu;
     Separator6: TMenuItem;
     pmhnewtab: TMenuItem;
     MenuItemOpen_saveascsv: TMenuItem;
     pmsaveascsv: TMenuItem;
     MenuItemContextRefresh: TMenuItem;
     Separator5: TMenuItem;
     Panelnav4: TSpeedButton;
     Separator4: TMenuItem;
     mprofileimmediate: TMenuItem;
     pmnavbc0: TMenuItem;
     pmnavhistory0: TMenuItem;
     pmnavhistory8: TMenuItem;
     pmnavbc1: TMenuItem;
     pmnavbc2: TMenuItem;
     pmnavbc3: TMenuItem;
     pmnavbc4: TMenuItem;
     pmnavbc5: TMenuItem;
     pmnavbc6: TMenuItem;
     pmnavbc7: TMenuItem;
     pmnavbc8: TMenuItem;
     pmnavhistory1: TMenuItem;
     pmnavhistory2: TMenuItem;
     pmnavhistory3: TMenuItem;
     pmnavhistory4: TMenuItem;
     pmnavhistory5: TMenuItem;
     pmnavhistory6: TMenuItem;
     pmnavhistory7: TMenuItem;
     pmr_files: TMenuItem;
     pmnavhistory: TPopupMenu;
     pmnavbc: TPopupMenu;
     Separator2: TMenuItem;
     pmr_ren: TMenuItem;
     Separator3: TMenuItem;
     powRun: TMenuItem;
     pmapp8: TMenuItem;
     MenuItem102: TMenuItem;
     pmapp9: TMenuItem;
     MenuItem111: TMenuItem;
     MenuItem114: TMenuItem;
     MenuItem115: TMenuItem;
     MenuItem116: TMenuItem;
     MenuItem117: TMenuItem;
     MenuItem119: TMenuItem;
     MenuItem120: TMenuItem;
     MenuItem121: TMenuItem;
     marcopt: TMenuItem;
     mdefarcset: TMenuItem;
     mdefextset: TMenuItem;
     MenuItem124: TMenuItem;
     MenuItem128: TMenuItem;
     MenuItem129: TMenuItem;
     mcmethod: TMenuItem;
     mcaccessed: TMenuItem;
     mccreated: TMenuItem;
     MenuItem130: TMenuItem;
     mbrowsercaccessed: TMenuItem;
     mbrowsercmethod: TMenuItem;
     mbrowserccreated: TMenuItem;
     mautoadjust: TMenuItem;
     mBenchpea: TMenuItem;
     pmapp10: TMenuItem;
     pmapp11: TMenuItem;
     pmapp12: TMenuItem;
     pmapp13: TMenuItem;
     pmapp14: TMenuItem;
     pmapp15: TMenuItem;
     pmapp16: TMenuItem;
     pmappadv1: TMenuItem;
     pmappadv2: TMenuItem;
     pmappadv3: TMenuItem;
     pmappadv4: TMenuItem;
     pmappadv5: TMenuItem;
     pmappadv6: TMenuItem;
     pmappadv7: TMenuItem;
     pmappadv8: TMenuItem;
     pmapp1: TMenuItem;
     pmapp2: TMenuItem;
     pmapp3: TMenuItem;
     pmapp4: TMenuItem;
     pmapp5: TMenuItem;
     pmapp6: TMenuItem;
     pmapp7: TMenuItem;
     pmapp: TMenuItem;
     pmapprun: TMenuItem;
     owrun: TMenuItem;
     msamplescripts: TMenuItem;
     mloadlayout: TMenuItem;
     mfilterbrowser: TMenuItem;
     msavelayout: TMenuItem;
     Separator1: TMenuItem;
     menuitemopendocuments: TMenuItem;
     menuitemopendownloads: TMenuItem;
     po_maclaunch: TMenuItem;
     po_macdisk: TMenuItem;
     po_macact: TMenuItem;
     po_macsys: TMenuItem;
     po_browsercaccessed: TMenuItem;
     po_browsercmethod: TMenuItem;
     po_browserccreated: TMenuItem;
     MenuItemColMint: TMenuItem;
     MenuItemColUbuntu: TMenuItem;
     MenuItemColBeos: TMenuItem;
     MenuItemColWindows: TMenuItem;
     PopupColPresets: TPopupMenu;
     po_gnomesw: TMenuItem;
     po_cinnamonsett: TMenuItem;
     po_synaptic: TMenuItem;
     po_xfcesm: TMenuItem;
     po_kdesyssett: TMenuItem;
     MenuItem131: TMenuItem;
     po_gnomecc: TMenuItem;
     po_lintop: TMenuItem;
     po_linpsef: TMenuItem;
     po_linnetstat: TMenuItem;
     po_linipaddress: TMenuItem;
     po_linid: TMenuItem;
     po_linhistory: TMenuItem;
     po_lindush: TMenuItem;
     po_lindfh: TMenuItem;
     MenuItem8: TMenuItem;
     po_openunitasarchivelin: TMenuItem;
     po_dispenvstrlin: TMenuItem;
     po_linsystemtools: TMenuItem;
     MenuItemOpen_run: TMenuItem;
     po_openfiles: TMenuItem;
     pmcmethod: TMenuItem;
     pmcaccessed: TMenuItem;
     pmccreated: TMenuItem;
     po_whoami: TMenuItem;
     po_ver: TMenuItem;
     po_systeminfo: TMenuItem;
     po_ftp: TMenuItem;
     po_qwinsta: TMenuItem;
     po_quser: TMenuItem;
     po_hostname: TMenuItem;
     po_ipconfig: TMenuItem;
     po_getmac: TMenuItem;
     po_sysinfo: TMenuItem;
     pmqeselected: TMenuItem;
     pmqedisplayed: TMenuItem;
     pmqeall: TMenuItem;
     mtab: TMenuItem;
     pmtestcontext: TPopupMenu;
     pmtestcontextall: TMenuItem;
     pmtestcontextdisplayed: TMenuItem;
     pmtestcontextselected: TMenuItem;
     pmthemes: TMenuItem;
     MenuItem83: TMenuItem;
     pmrow: TMenuItem;
     MenuItem127: TMenuItem;
     pmtab: TMenuItem;
     MenuItem126: TMenuItem;
     pmsnav: TMenuItem;
     pmstree: TMenuItem;
     pmsnone: TMenuItem;
     pmtool1: TMenuItem;
     pmtool2: TMenuItem;
     pmtool3: TMenuItem;
     pcustmakecab: TMenuItem;
     pcustmakecabsep: TMenuItem;
     mtenc: TMenuItem;
     MenuItem123: TMenuItem;
     pmtextenc: TMenuItem;
     MenuItemTextEncoding: TMenuItem;
     pmr_cut: TMenuItem;
     pmr_appendts: TMenuItem;
     pmr_appenddirname: TMenuItem;
     pmr_prependdirname: TMenuItem;
     pmr_123: TMenuItem;
     pmr_ascii: TMenuItem;
     po_rename_ascii: TMenuItem;
     po_rename_cutlen: TMenuItem;
     mtogglesidebar: TMenuItem;
     mtoggletabbar: TMenuItem;
     mtoggletoolbar: TMenuItem;
     mextopt: TMenuItem;
     PanelLCA1: TShape;
     PanelLCA2: TShape;
     PanelLCA3: TShape;
     PanelLCA4: TShape;
     PanelLCA5: TShape;
     PanelLCA6: TShape;
     PanelLCA7: TShape;
     PanelLCA8: TShape;
     PanelLCAa1: TShape;
     PanelLCAa2: TShape;
     PanelLCAa3: TShape;
     PanelLCAa4: TShape;
     PanelTabBar: TPanel;
     po_lock: TMenuItem;
     po_rr: TMenuItem;
     po_recover: TMenuItem;
     po_comment: TMenuItem;
     pmmorecomment: TMenuItem;
     pmmorerecover: TMenuItem;
     pmmorerr: TMenuItem;
     pmmorelock: TMenuItem;
     mprofilerar: TMenuItem;
     PanelRar: TPanel;
     pob_blake2b: TMenuItem;
     pob_blake2s: TMenuItem;
     mprofile7zfast: TMenuItem;
     mprofile7zfastest: TMenuItem;
     PanelBrotli: TPanel;
     PanelZstd: TPanel;
     po_smart: TMenuItem;
     mprofilebetterzpaq: TMenuItem;
     mprofilesave: TMenuItem;
     mprofileload: TMenuItem;
     mprofilebrotli: TMenuItem;
     mprofilezstd: TMenuItem;
     mprofilealtarc: TMenuItem;
     mprofileextremezpaq: TMenuItem;
     mloadcompsettings: TMenuItem;
     msavecompsettings: TMenuItem;
     mForceSynceditsClear: TMenuItem;
     mForceClear: TMenuItem;
     mextallheresmart: TMenuItem;
     mextallherenew: TMenuItem;
     MenuItemExtAllHereSmart: TMenuItem;
     MenuItemExtAllHereNew: TMenuItem;
     pmqeheresmart: TMenuItem;
     pmqeherenew: TMenuItem;
     po_rename_filesonly: TMenuItem;
     mprofilezipbz2: TMenuItem;
     po_rename_123: TMenuItem;
     pmpanalyzefolders: TMenuItem;
     po_analyzefolders: TMenuItem;
     mForceSyncedits: TMenuItem;
     Panel10: TPanel;
     pms2a_ext: TMenuItem;
     MenuItem118: TMenuItem;
     po_rename_separator: TMenuItem;
     po_more: TMenuItem;
     po_pdup: TMenuItem;
     PageOpt2: TScrollBox;
     PanelLine1: TPanel;
     PanelLine2: TPanel;
     PanelLine4: TPanel;
     PanelLine3: TPanel;
     PanelLine5: TPanel;
     PanelLine6: TPanel;
     PanelLine7: TPanel;
     PanelLine8: TPanel;
     pmhcopypath: TMenuItem;
     pmsaveastxt: TMenuItem;
     MenuItem71: TMenuItem;
     pmcname: TMenuItem;
     pmctype: TMenuItem;
     pmcsize: TMenuItem;
     pmcpacked: TMenuItem;
     pmcdate: TMenuItem;
     pmcatt: TMenuItem;
     pmccrc: TMenuItem;
     pmcfree: TMenuItem;
     pmcfs: TMenuItem;
     MenuItem145: TMenuItem;
     pmstyle1: TMenuItem;
     pmstyle2: TMenuItem;
     pmstyle3: TMenuItem;
     pmstyle4: TMenuItem;
     pmstyle5: TMenuItem;
     pmstyle6: TMenuItem;
     pmtabsm: TMenuItem;
     pmhtabs: TMenuItem;
     pmtabsbook: TMenuItem;
     pmstyle: TPopupMenu;
     PopupHeader: TPopupMenu;
     po_tabsopen: TMenuItem;
     pmtabsbookmarkorg: TMenuItem;
     pmtabsbookmarkadd: TMenuItem;
     mtabs: TMenuItem;
     pmtabscloseright: TMenuItem;
     pmtabscollapse: TMenuItem;
     pmtabsexpand: TMenuItem;
     MenuItem64: TMenuItem;
     MenuItem72: TMenuItem;
     pmtabscloseother: TMenuItem;
     ProgressBar2: TShape;
     cbExtEvForWhen: TComboBox;
     cbtree: TComboBox;
     RadioGroup3: TComboBox;
     RadioGroup4: TComboBox;
     RadioGroup6: TComboBox;
     RadioGroupAction1: TComboBox;
     ShapeTitleAddb1: TShape;
     ShapeTitleAddb2: TShape;
     ShapeTitleAddb3: TShape;
     ShapeTitleAddb4: TShape;
     ShapeTitleAppsb1: TShape;
     ShapeTitleAppsb2: TShape;
     ShapeTitleExtractb1: TShape;
     ShapeTitleExtractb2: TShape;
     ShapeTitleExtractb3: TShape;
     ShapeTitleExtractb4: TShape;
     SpinEdit1: TSpinEdit;
     seRARrr: TSpinEdit;
     splitsearch: TSplitter;
     StringGridAddress3: TStringGrid;
     StringGridArchive: TStringGrid;
     StringGridTabs: TStringGrid;
     Subtitleschopt: TLabel;
     Subtitleschopt1: TLabel;
     ImageAdArchive3: TImage;
     ImageAddress0: TImage;
     ImageAddress1: TImage;
     ImageAddress2: TImage;
     ImageAddress3: TImage;
     ImageAddress4: TImage;
     ImageAddress5: TImage;
     ImageAddress6: TImage;
     ImageAddress7: TImage;
     ImageAdArchive0: TImage;
     ImageAdArchive1: TImage;
     ImageAdArchive2: TImage;
     ImageDefaults2: TBitBtn;
     ImageInfoArchive5: TImage;
     ImageInfoArchive6: TImage;
     ImageListSearch1: TImage;
     Imageopenadvf: TImage;
     Imageopenadvf1: TImage;
     Imageopenadvf2: TImage;
     ImagePassword1: TSpeedButton;
     ImagePassword2: TSpeedButton;
     ImageSplit: TImage;
     Label10: TLabel;
     Label7za14: TLabel;
     Label7za18: TLabel;
     Label7za8: TLabel;
     Labeladvext7z: TLabel;
     Labeladvextfreearc: TLabel;
     LabelArcSub3: TLabel;
     Labelogperf: TLabel;
     Label7: TLabel;
     Label7za1: TLabel;
     Label7za10: TLabel;
     Label7za11: TLabel;
     Label7za12: TLabel;
     Label7za2: TLabel;
     Label7za3: TLabel;
     Label7za4: TLabel;
     Label7za5: TLabel;
     Label7za6: TLabel;
     Label7za7: TLabel;
     Label7za9: TLabel;
     Label7zaPasses: TLabel;
     Label7zsolidblock: TLabel;
     LabelAbout1: TLabel;
     LabelAbout2: TLabel;
     LabelArchiveOther: TLabel;
     LabelArchiveOther1: TLabel;
     LabelArchiveOther2: TLabel;
     LabelArchiveOther3: TLabel;
     LabelArchiveOther4: TLabel;
     LabelArchiveOther5: TLabel;
     LabelArchiveOther6: TLabel;
     LabelArchiveOther7: TLabel;
     LabelArchiveOther8: TLabel;
     LabelARCsolidblock: TLabel;
     LabelArcSub1: TLabel;
     LabelArcSub2: TLabel;
     Labelbcmblock: TLabel;
     Labelcb14: TLabel;
     Labeloamext: TLabel;
     Labelogreset: TLabel;
     Labelcb7: TLabel;
     Labelcbadvanced: TLabel;
     Labelcbbasic: TLabel;
     Labelcbsample: TLabel;
     Labelcbsampleadvanced: TLabel;
     LabelClipInfo: TLabel;
     LabelClickAdArchive1: TLabel;
     LabelClickAdArchive2: TLabel;
     LabelClickAdArchive3: TLabel;
     LabelClickAdArchive4: TLabel;
     LabelColor1: TLabel;
     LabelConfigurePeaZip: TLabel;
     LabelCustom: TLabel;
     LabelDefaultColor1: TLabel;
     LabelEvery: TLabel;
     LabelEvery1: TLabel;
     LabelEveryUnit: TLabel;
     LabelEveryUnit1: TLabel;
     LabelLang2: TLabel;
     Labeloptsub1: TLabel;
     Labeloptsub2: TLabel;
     Labeloptsub3: TLabel;
     Labeloptsub4: TLabel;
     LabelPanelHintAdd: TLabel;
     LabelPanelHintExtract: TLabel;
     LabelPEA6: TLabel;
     LabelPEA7: TLabel;
     LabelPEA8: TLabel;
     LabelResetApp1: TLabel;
     LabelResetBookmarks: TLabel;
     LabelResetHistory: TLabel;
     LabelResetPM: TLabel;
     LabelResetPtmp: TLabel;
     LabelSplit: TLabel;
     LabelStatus2: TLabel;
     LabelStatus6: TLabel;
     LabelTheme: TLabel;
     LabelTheme1: TLabel;
     LabelTheme2: TLabel;
     LabelTheme3: TLabel;
     LabelThemeLoaded: TLabel;
     LabelTitleApps1: TLabel;
     LabelTitleApps2: TLabel;
     LabelUpdates: TLabel;
     LabelTitleExtract2: TLabel;
     LabelTitleExtract3: TLabel;
     LabelTitleExtract4: TLabel;
     LabelTitleExtract1: TLabel;
     LabelDonations: TLabel;
     ListAddress: TListView;
     Lmanageschedule1: TLabel;
     Lmanageschedule2: TLabel;
     Lmanageschedule3: TLabel;
     Lmanageschedule4: TLabel;
     lsa1: TLabel;
     lsa2: TLabel;
     lsa3: TLabel;
     lsa4: TLabel;
     lsa5: TLabel;
     lsa6: TLabel;
     lsaday: TLabel;
     lsaday1: TLabel;
     lsp: TLabel;
     lsp1: TLabel;
     lsspc: TLabel;
     lsspc1: TLabel;
     MemoAbout: TMemo;
     MenuItem104: TMenuItem;
     mCharCase: TMenuItem;
     mChar: TMenuItem;
     MenuItem105: TMenuItem;
     mDateYear: TMenuItem;
     mDateMonth: TMenuItem;
     mDateDay: TMenuItem;
     mDateHour: TMenuItem;
     mDateWeek: TMenuItem;
     MenuItem109: TMenuItem;
     maddexisting: TMenuItem;
     maddconvert: TMenuItem;
     MenuItem110: TMenuItem;
     abc4: TMenuItem;
     abc3: TMenuItem;
     abc2: TMenuItem;
     abc1: TMenuItem;
     abc8: TMenuItem;
     abc7: TMenuItem;
     abc6: TMenuItem;
     abc5: TMenuItem;
     abc0: TMenuItem;
     pmtabsnew: TMenuItem;
     pmtabsclose: TMenuItem;
     pmtabs: TPopupMenu;
     po_rename_appenddir: TMenuItem;
     po_rename_prependdir: TMenuItem;
     org_autoadjust: TMenuItem;
     MenuItemOpen_saveastxt: TMenuItem;
     mfun0: TMenuItem;
     metn: TMenuItem;
     morghistory: TMenuItem;
     morgsessionhistory: TMenuItem;
     morgbookmarks: TMenuItem;
     PanelActDefaults: TPanel;
     panelspaceradd2: TPanel;
     RadioGroupActionArc: TComboBox;
     panelspacerextract2: TPanel;
     pob_crc24: TMenuItem;
     pob_crc64: TMenuItem;
     pob_edonkey: TMenuItem;
     pob_md4: TMenuItem;
     pob_md5: TMenuItem;
     pob_ripemd: TMenuItem;
     pob_sha1: TMenuItem;
     pob_sha256: TMenuItem;
     pob_sha3256: TMenuItem;
     pob_sha512: TMenuItem;
     pob_sha3512: TMenuItem;
     pob_whirlpool: TMenuItem;
     pob_crc32: TMenuItem;
     pob_adler: TMenuItem;
     pob_crc16: TMenuItem;
     Options: TScrollBox;
     OptionsAdv: TScrollBox;
     OptionsARC: TPanel;
     OptionsOpen: TScrollBox;
     PageExtAdv: TScrollBox;
     PageOpt1: TScrollBox;
     PageOpt3: TScrollBox;
     PageOpt4: TScrollBox;
     PageOpt5: TScrollBox;
     PageOpt6: TScrollBox;
     PageOpt7: TScrollBox;
     PageOpt8: TScrollBox;
     Panel7za: TPanel;
     PanelApps1: TPanel;
     PanelApps2: TPanel;
     PanelARC: TPanel;
     PanelArchive2: TPanel;
     PanelCustom: TPanel;
     PanelHDW: TPanel;
     PanelHDW1: TPanel;
     PanelHintAdd: TPanel;
     PanelHintExtract: TPanel;
     PanelMonthly: TPanel;
     PanelMonthly1: TPanel;
     PanelPAQ: TPanel;
     PanelPEA: TPanel;
     PanelQuad: TPanel;
     PanelScheduleAdd: TPanel;
     PanelScheduleAdd1: TPanel;
     PanelSplitFile: TPanel;
     PanelTitleApps: TPanel;
     PanelUPX: TPanel;
     PanelWeekly: TPanel;
     PanelWeekly1: TPanel;
     PEA: TGroupBox;
     pmbce: TMenuItem;
     pmbcexpand: TMenuItem;
     pmamr2: TMenuItem;
     pmamr3: TMenuItem;
     pmamr4: TMenuItem;
     pmamr5: TMenuItem;
     pmamr6: TMenuItem;
     pmamr7: TMenuItem;
     pmamr8: TMenuItem;
     pmamr1: TMenuItem;
     pmquickdesk: TMenuItem;
     pmquickhome: TMenuItem;
     pmquickop: TMenuItem;
     pmquickoa: TMenuItem;
     pmquicksd: TMenuItem;
     MenuItem48: TMenuItem;
     MenuItem50: TMenuItem;
     MenuItem61: TMenuItem;
     pmbcspacer: TMenuItem;
     pmtypeswap: TMenuItem;
     pmttitle: TMenuItem;
     Panel9: TPanel;
     pmflat: TMenuItem;
     po_preview: TMenuItem;
     po_analyze: TMenuItem;
     pmmorepreview: TMenuItem;
     pmmorehex: TMenuItem;
     pmqnointdir: TMenuItem;
     pmmoreanalysis: TMenuItem;
     po_rename_timestamp: TMenuItem;
     PanelSearch: TPanel;
     mextract: TMenuItem;
     MenuItem47: TMenuItem;
     mtoggletbrib: TMenuItem;
     mf4: TMenuItem;
     OpenDialogApps1: TOpenDialog;
     PanelAdArchive0: TPanel;
     PanelAdArchive3: TPanel;
     PanelAdArchive1: TPanel;
     PanelAdArchive2: TPanel;
     pmCustEditAdd: TMenuItem;
     pmCustEditAdd1: TMenuItem;
     pmCustEditApps: TPopupMenu;
     pmCustEditApps1: TPopupMenu;
     pmCustEditDesc: TMenuItem;
     pmCustEditDesc1: TMenuItem;
     pmCustEditEdit: TMenuItem;
     pmCustEditEdit1: TMenuItem;
     pmCustEditEdit1after: TMenuItem;
     pmCustEditRemove: TMenuItem;
     pmCustEditRemove1: TMenuItem;
     RadioGroup0: TComboBox;
     RadioGroup1: TComboBox;
     RadioGroup2: TComboBox;
     RadioGroupAction: TComboBox;
     RadioGroupArchive: TRadioGroup;
     RadioGroupBrowser: TComboBox;
     RadioGroupPaq: TRadioGroup;
     RadioGrouppwrequest: TComboBox;
     RadioGroupQuad: TRadioGroup;
     RadioGroupTS: TComboBox;
     schedaddname: TEdit;
     schedaddname1: TEdit;
     schedaddschedule: TComboBox;
     schedaddschedule1: TComboBox;
     ScheduleAdd: TScrollBox;
     scheduleend: TCheckBox;
     scheduleend1: TCheckBox;
     ScheduleExtract: TScrollBox;
     schedulehh: TSpinEdit;
     schedulehh1: TSpinEdit;
     schedulemm: TSpinEdit;
     schedulemm1: TSpinEdit;
     scheduleNN: TSpinEdit;
     scheduleNN1: TSpinEdit;
     schedulepassword: TLabel;
     schedulepassword1: TLabel;
     schedulestart: TCheckBox;
     schedulestart1: TCheckBox;
     scheduleuser: TCheckBox;
     scheduleuser1: TCheckBox;
     ShapeAddress: TPanel;
     SpinEditArchive1: TSpinEdit;
     Splitter3: TSplitter;
     StringGrid1: TStringGrid;
     StringGrid2: TStringGrid;
     StringGridAddress1: TStringGrid;
     StringGridAddress2: TStringGrid;
     StringGridCustEdit: TStringGrid;
     StringGridCustEdit1: TStringGrid;
     StringGridList: TStringGrid;
     StringGridAddress: TStringGrid;
     Subtitle7zaopt: TLabel;
     Subtitle7zaopt1: TLabel;
     Subtitle7zaopt2: TLabel;
     TabBar: THeaderControl;
     themesave_label: TLabel;
     themes_download: TLabel;
     theme_label1: TImage;
     Timer4: TTimer;
     Timerrename: TTimer;
     tmupdate: TMenuItem;
     tmconvert: TMenuItem;
     tmextract: TMenuItem;
     munpeaextract: TMenuItem;
     mlayouts: TMenuItem;
     OpenDialogLayout: TOpenDialog;
     pmbcd17: TMenuItem;
     pmbcd18: TMenuItem;
     pmbcd19: TMenuItem;
     PanelAddress2: TPanel;
     PanelAddress3: TPanel;
     PanelAddress4: TPanel;
     PanelAddress5: TPanel;
     PanelAddress6: TPanel;
     PanelAddress7: TPanel;
     PanelAddress1: TPanel;
     PanelAddress0: TPanel;
     pmbcd0: TMenuItem;
     pmbcd16: TMenuItem;
     pmbcd5: TMenuItem;
     pmbcd6: TMenuItem;
     pmbcd7: TMenuItem;
     pmbcd8: TMenuItem;
     pmbcd9: TMenuItem;
     pmbcd10: TMenuItem;
     pmbcd11: TMenuItem;
     pmbcd12: TMenuItem;
     pmbcd13: TMenuItem;
     pmbcd14: TMenuItem;
     pmbcd15: TMenuItem;
     pmbcd1: TMenuItem;
     pmbcd2: TMenuItem;
     pmbcd3: TMenuItem;
     pmbcd4: TMenuItem;
     pmbcdir: TPopupMenu;
     po_renmenu: TMenuItem;
     pmbreadfs: TMenuItem;
     pmbreadfun: TMenuItem;
     mPeaFB: TMenuItem;
     mPeaTW: TMenuItem;
     MenuItem112: TMenuItem;
     mselectadv: TMenuItem;
     pmselectadv: TMenuItem;
     po_selectadv: TMenuItem;
     pmrselect: TMenuItem;
     pmcpypath: TMenuItem;
     pmCopyPath: TMenuItem;
     po_copypath: TMenuItem;
     msamemonth: TMenuItem;
     msameweek: TMenuItem;
     msameday: TMenuItem;
     msamehour: TMenuItem;
     MenuItem113: TMenuItem;
     msameyear: TMenuItem;
     mpackedsimilar50: TMenuItem;
     MenuItem107: TMenuItem;
     msizesimilar50: TMenuItem;
     MenuItem86: TMenuItem;
     mpackedsimilar: TMenuItem;
     msizesimilar: TMenuItem;
     mpacked100m: TMenuItem;
     mpacked10m: TMenuItem;
     mpacked100k: TMenuItem;
     mpackedempty: TMenuItem;
     MenuItem69: TMenuItem;
     mpackedover: TMenuItem;
     msize10m: TMenuItem;
     MenuItem106: TMenuItem;
     msize100m: TMenuItem;
     msizeover: TMenuItem;
     msize100k: TMenuItem;
     msize0: TMenuItem;
     pmcut: TMenuItem;
     pmr_add: TMenuItem;
     pmr_delete: TMenuItem;
     pmr_replace: TMenuItem;
     pmr_replacecase: TMenuItem;
     pmr_ext: TMenuItem;
     pmr_lowercase: TMenuItem;
     pmr_uppercase: TMenuItem;
     PopupMenuRename: TPopupMenu;
     po_im_TIFF: TMenuItem;
     pmisJPEG75: TMenuItem;
     pmisJPEG50: TMenuItem;
     po_im_JPEG75: TMenuItem;
     po_im_JPEG50: TMenuItem;
     po_im_4ktv: TMenuItem;
     po_im_4kcinema: TMenuItem;
     pmif8: TMenuItem;
     pmif6: TMenuItem;
     pmif7: TMenuItem;
     po_im_BMP: TMenuItem;
     po_im_75: TMenuItem;
     po_im_1024: TMenuItem;
     po_im_hd: TMenuItem;
     po_im_wuxga: TMenuItem;
     MenuItem108: TMenuItem;
     po_im_JPEG: TMenuItem;
     po_im_PNG: TMenuItem;
     MenuItem54: TMenuItem;
     po_im_50: TMenuItem;
     po_im_200: TMenuItem;
     mplugins: TMenuItem;
     po_rename_replace_case: TMenuItem;
     po_rename_uppercase: TMenuItem;
     po_rename_replace: TMenuItem;
     MenuItem26: TMenuItem;
     po_rename_ext: TMenuItem;
     po_rename_delete: TMenuItem;
     po_rename_add: TMenuItem;
     po_rename_lowercase: TMenuItem;
     pmmorecheck: TMenuItem;
     MenuItem36: TMenuItem;
     pmmore3: TMenuItem;
     pmmore4: TMenuItem;
     pmmore5: TMenuItem;
     pmmore6: TMenuItem;
     pmmore7: TMenuItem;
     pmmore8: TMenuItem;
     pmmoreseparator: TMenuItem;
     pmmore1: TMenuItem;
     pmmore2: TMenuItem;
     pmAdvanced: TMenuItem;
     pmrefreshlayout: TMenuItem;
     pmemr5: TMenuItem;
     pmemr6: TMenuItem;
     pmemr7: TMenuItem;
     pmemr8: TMenuItem;
     pmemr2: TMenuItem;
     pmemr3: TMenuItem;
     pmemr4: TMenuItem;
     pmemr0: TMenuItem;
     MenuItem6: TMenuItem;
     pmemr1: TMenuItem;
     pmemb6: TMenuItem;
     pmemb7: TMenuItem;
     pmemb8: TMenuItem;
     pmemb0: TMenuItem;
     pmemb3: TMenuItem;
     pmemb2: TMenuItem;
     pmemb4: TMenuItem;
     pmemb5: TMenuItem;
     pmemb1: TMenuItem;
     pmFoldersmenu: TMenuItem;
     pmemrf5: TMenuItem;
     pmemrf6: TMenuItem;
     pmemrf7: TMenuItem;
     pmemrf8: TMenuItem;
     pmemrf2: TMenuItem;
     pmemrf3: TMenuItem;
     pmemrf4: TMenuItem;
     pmemrf0: TMenuItem;
     MenuItemsepfold: TMenuItem;
     pmemrf1: TMenuItem;
     pmembf6: TMenuItem;
     pmembf7: TMenuItem;
     pmembf8: TMenuItem;
     pmembf0: TMenuItem;
     pmembf3: TMenuItem;
     pmembf2: TMenuItem;
     pmembf4: TMenuItem;
     pmembf5: TMenuItem;
     pmembf1: TMenuItem;
     pmExploremenu: TMenuItem;
     PanelTitleExtract: TPanel;
     BevelTitleOptions1: TPanel;
     BevelTitleOptions3: TPanel;
     BevelTitleOptions4: TPanel;
     BevelTitleOptions5: TPanel;
     ButtonArchive: TBitBtn;
     ButtonArchive1: TBitBtn;
     ButtonDelete: TSpeedButton;
     ButtonDup: TSpeedButton;
     ButtonDup1: TSpeedButton;
     ButtonNF: TSpeedButton;
     Buttonfmactions: TSpeedButton;
     ButtonEditName13: TSpeedButton;
     ButtonExtCancel: TBitBtn;
     ButtonExtOk: TBitBtn;
     ButtonImgRes: TSpeedButton;
     ButtonImgR: TSpeedButton;
     ButtonImgCrop: TSpeedButton;
     Buttonopenactions: TSpeedButton;
     ButtonOpenWith: TSpeedButton;
     ButtonProperties: TSpeedButton;
     ButtonRename1: TSpeedButton;
     ButtonUn7za1: TSpeedButton;
     ButtonCopy: TSpeedButton;
     Buttoncmto: TSpeedButton;
     ButtonRename: TSpeedButton;
     ButtonImgResize: TSpeedButton;
     ButtonUn7za4: TSpeedButton;
     ButtonUn7za5: TSpeedButton;
     ButtonUn7za6: TSpeedButton;
     ButtonUn7za7: TSpeedButton;
     ButtonCut: TSpeedButton;
     ButtonImg6: TSpeedButton;
     ButtonUn7za8: TSpeedButton;
     ButtonUn7za9: TSpeedButton;
     ButtonUn7zaTo: TSpeedButton;
     ButtonPaste: TSpeedButton;
     ButtonImgRL: TSpeedButton;
     ButtonImgRR: TSpeedButton;
     LabelTitleAdd1: TLabel;
     LabelTitleAdd2: TLabel;
     LabelTitleAdd3: TLabel;
     LabelTitleAdd4: TLabel;
     pmrsh: TMenuItem;
     PanelTitleAdd: TPanel;
     pmmorefun_properties: TMenuItem;
     pmfun17: TMenuItem;
     pmfun18: TMenuItem;
     pmbcorganizebookmarks: TMenuItem;
     pmbcaddbookmark: TMenuItem;
     pmfunaz: TMenuItem;
     pmsearchdrag: TMenuItem;
     pmsearchweb: TMenuItem;
     Shape3: TPanel;
     Shape4: TPanel;
     ShellTreeView2: TShellTreeView;
     MenuItem100: TMenuItem;
     mprofileultra7z: TMenuItem;
     mprofilenormal7z: TMenuItem;
     mprofilenormalzip: TMenuItem;
     mprofilefastzip: TMenuItem;
     mprofileencrypt7z: TMenuItem;
     mprofilesplitzip: TMenuItem;
     mprofileauto: TMenuItem;
     NotebookAdd: TPanel;
     PanelTitleOptions: TPanel;
     po_details: TMenuItem;
     pmmorefun_details: TMenuItem;
     pmmstatus_r: TMenuItem;
     pmfun6: TMenuItem;
     pmfun7: TMenuItem;
     pmfun8: TMenuItem;
     pmfun9: TMenuItem;
     pmfun10: TMenuItem;
     pmfun11: TMenuItem;
     pmfun12: TMenuItem;
     pmfun13: TMenuItem;
     pmfun14: TMenuItem;
     pmfun15: TMenuItem;
     pmfun16: TMenuItem;
     MenuItem20: TMenuItem;
     MenuItem93: TMenuItem;
     MenuItem94: TMenuItem;
     pmfun1: TMenuItem;
     pmfun2: TMenuItem;
     pmfun3: TMenuItem;
     pmfun4: TMenuItem;
     pmfun5: TMenuItem;
     tbtemperature: TTrackBar;
     w7contextlang: TMenuItem;
     mpeautils: TMenuItem;
     MenuItem5: TMenuItem;
     MenuItem92: TMenuItem;
     mPeaFAQ: TMenuItem;
     mPeaSupport: TMenuItem;
     mPeaSiteMirror: TMenuItem;
     pmsecuredeletefree: TMenuItem;
     pmzerofree: TMenuItem;
     MenuItem91: TMenuItem;
     pmzerofile: TMenuItem;
     po_securedeletefree: TMenuItem;
     po_zerofree: TMenuItem;
     MenuItem56: TMenuItem;
     po_zerofile: TMenuItem;
     pmqjmyboxfiles: TMenuItem;
     MenuItemArchive_myboxfiles: TMenuItem;
     MenuItemOpen_myboxfiles: TMenuItem;
     mtaskscheduler: TMenuItem;
     mscheduledscripts: TMenuItem;
     CheckBoxClip: TCheckBox;
     ctrlback: TSpeedButton;
     ImageListRoot: TImage;
     Labelbsize: TLabel;
     LabelStatusAr: TLabel;
     LabelStatusEx: TLabel;
     pmrename: TMenuItem;
     MenuItemEnumerate: TMenuItem;
     pmjumppictures: TMenuItem;
     pmjumpvideos: TMenuItem;
     MenuItem12: TMenuItem;
     MenuItem17: TMenuItem;
     MenuItemOpen_music: TMenuItem;
     MenuItemOpen_pictures: TMenuItem;
     MenuItemOpen_videos: TMenuItem;
     MenuItemArchive_music: TMenuItem;
     MenuItemArchive_pictures: TMenuItem;
     MenuItemArchive_videos: TMenuItem;
     pmjumpmusic: TMenuItem;
     MenuItem4: TMenuItem;
     mbc0: TMenuItem;
     mbc1: TMenuItem;
     mbc2: TMenuItem;
     mbc3: TMenuItem;
     mbc4: TMenuItem;
     mbc5: TMenuItem;
     mbc6: TMenuItem;
     mbc7: TMenuItem;
     mbc8: TMenuItem;
     MenuItem85: TMenuItem;
     MenuItem87: TMenuItem;
     MenuItem90: TMenuItem;
     pmhbc0: TMenuItem;
     pnabc1: TMenuItem;
     pnabc2: TMenuItem;
     pnabc3: TMenuItem;
     pnabc4: TMenuItem;
     pnabc5: TMenuItem;
     pnabc6: TMenuItem;
     pnabc7: TMenuItem;
     pnabc8: TMenuItem;
     pnabc0: TMenuItem;
     pnbc2: TMenuItem;
     pnbc3: TMenuItem;
     pnbc4: TMenuItem;
     pnbc5: TMenuItem;
     pnbc6: TMenuItem;
     pnbc7: TMenuItem;
     pnbc8: TMenuItem;
     pnbc0: TMenuItem;
     pnbc1: TMenuItem;
     pmbc: TMenuItem;
     po_task: TMenuItem;
     pnra0: TMenuItem;
     pnha0s: TMenuItem;
     pnr0: TMenuItem;
     pnh0s: TMenuItem;
     pmhr0: TMenuItem;
     pmh0s: TMenuItem;
     mrecent0: TMenuItem;
     MenuItem32: TMenuItem;
     mback: TMenuItem;
     MenuItem37: TMenuItem;
     mbackalias: TMenuItem;
     mhistory0s: TMenuItem;
     MenuItem75: TMenuItem;
     MenuItem76: TMenuItem;
     mb0: TMenuItem;
     MenuItem84: TMenuItem;
     po_sysmore: TMenuItem;
     po_msinfo32: TMenuItem;
     po_msconfig: TMenuItem;
     po_regedit: TMenuItem;
     po_mrt: TMenuItem;
     pmpowershell: TMenuItem;
     MenuItemPowerShell: TMenuItem;
     MenuItemOpen_powershell: TMenuItem;
     pmbcweb: TMenuItem;
     pmbcproperties: TMenuItem;
     pmbcexplore: TMenuItem;
     pmhr1f: TMenuItem;
     pmhr2f: TMenuItem;
     pmhr3f: TMenuItem;
     pmhr4f: TMenuItem;
     pmhr5f: TMenuItem;
     pmhr6f: TMenuItem;
     pmhr7f: TMenuItem;
     pmhr8f: TMenuItem;
     mRecent1f: TMenuItem;
     mRecent2f: TMenuItem;
     mRecent3f: TMenuItem;
     mRecent4f: TMenuItem;
     mRecent5f: TMenuItem;
     mRecent6f: TMenuItem;
     mRecent7f: TMenuItem;
     mRecent8f: TMenuItem;
     po_im_rl: TMenuItem;
     po_im_rr: TMenuItem;
     MenuItem82: TMenuItem;
     po_im_crop: TMenuItem;
     po_im_modify: TMenuItem;
     po_im: TMenuItem;
     menuitemopenhome: TMenuItem;
     mfwd: TMenuItem;
     mtstyle_shadow: TMenuItem;
     mtstyle_frame: TMenuItem;
     mtstyle_none: TMenuItem;
     mtstyle: TMenuItem;
     mprelist: TMenuItem;
     Panel11: TPanel;
     pmhrefresh: TMenuItem;
     MenuItemOpen_dropbox: TMenuItem;
     MenuItemOpen_googledrive: TMenuItem;
     MenuItemOpen_onedrive: TMenuItem;
     MenuItemOpen_skydrive: TMenuItem;
     MenuItemOpen_ubuntuone: TMenuItem;
     MenuItemArchive_dropbox: TMenuItem;
     MenuItemArchive_googledrive: TMenuItem;
     MenuItemArchive_onedrive: TMenuItem;
     MenuItemArchive_skydrive: TMenuItem;
     MenuItemArchive_ubuntuone: TMenuItem;
     MenuItem73: TMenuItem;
     pmorganizebookmarks: TMenuItem;
     pmrsearch: TMenuItem;
     MenuItemOpen_organizebookmarks: TMenuItem;
     Panelnav5: TPanel;
     pmqjmore: TMenuItem;
     MenuItem81: TMenuItem;
     pmqjgoogledrive: TMenuItem;
     pmqjonedrive: TMenuItem;
     pmqjskydrive: TMenuItem;
     pmqjubuntuone: TMenuItem;
     pmisTIFF: TMenuItem;
     pmif1: TMenuItem;
     pmif2: TMenuItem;
     pmif3: TMenuItem;
     pmif4: TMenuItem;
     pmif5: TMenuItem;
     MenuItem88: TMenuItem;
     MenuItem89: TMenuItem;
     pmisBMP: TMenuItem;
     pmisJPEG: TMenuItem;
     pmisPNG: TMenuItem;
     pmiresize25: TMenuItem;
     pmiresize33: TMenuItem;
     pmiresize50: TMenuItem;
     pmiresize75: TMenuItem;
     pmiresize125: TMenuItem;
     pmiresize150: TMenuItem;
     pmiresize200: TMenuItem;
     pmiresize300: TMenuItem;
     pmiresize400: TMenuItem;
     pmir180: TMenuItem;
     pmirflip: TMenuItem;
     pmirmirror: TMenuItem;
     mpretoggle: TMenuItem;
     mprelightlist: TMenuItem;
     mprelight: TMenuItem;
     mpredetails: TMenuItem;
     mpreaverage: TMenuItem;
     mprelarge: TMenuItem;
     mopresets: TMenuItem;
     pmImageRotate: TPopupMenu;
     pmImageResize: TPopupMenu;
     po_alltasks: TMenuItem;
     pmpdup: TMenuItem;
     PanelBarOpen3: TPanel;
     po_recycle: TMenuItem;
     pmrecycle: TMenuItem;
     po_open_asarchivet: TMenuItem;
     MenuItem77: TMenuItem;
     pmmstatus_clipboard: TMenuItem;
     pmmstatus_ra: TMenuItem;
     pmmstatus_bookmarks: TMenuItem;
     pmmstatus_status: TMenuItem;
     pmws: TMenuItem;
     MenuItem47t: TMenuItem;
     MenuItem9t: TMenuItem;
     pmcheck: TMenuItem;
     pmnewfolder: TMenuItem;
     MenuItem79: TMenuItem;
     pmproperties: TMenuItem;
     mupdate: TMenuItem;
     MenuItem78: TMenuItem;
     mscripts: TMenuItem;
     modock: TMenuItem;
     mot: TMenuItem;
     mor: TMenuItem;
     mob: TMenuItem;
     mol: TMenuItem;
     modefault: TMenuItem;
     motr: TMenuItem;
     mobr: TMenuItem;
     mobl: TMenuItem;
     motl: TMenuItem;
     PanelBarOpen2: TPanel;
     pmtopen: TPopupMenu;
     pmtestinfolist: TPopupMenu;
     po_flat: TMenuItem;
     MenuItemOrganizeStatusbar: TMenuItem;
     MenuItemOrganizeNavbar: TMenuItem;
     MenuItemOrganizeToolbar: TMenuItem;
     mpw2: TMenuItem;
     mmore: TMenuItem;
     mjob2: TMenuItem;
     mJob: TMenuItem;
     mProperties: TMenuItem;
     PopupMenu2: TPopupMenu;
     ctrlfwd: TSpeedButton;
     ctrlhistory: TSpeedButton;
     ctrlup: TSpeedButton;
     EditOpenIn: TEdit;
     EditOpenIn1: TEdit;
     il_dtheme_16: TImageList;
     il_dtheme_tool32: TImageList;
     ImageAddress: TImage;
     ImageListSearch: TImage;
     il_nonthemed: TImageList;
     ImageTheme: TImage;
     LabelClickAddress1: TLabel;
     LabelClickAddress2: TLabel;
     LabelClickAddress3: TLabel;
     LabelClickAddress4: TLabel;
     LabelClickAddress5: TLabel;
     LabelClickAddress6: TLabel;
     LabelClickAddress7: TLabel;
     LabelClickAddress8: TLabel;
     LabelStatus: TLabel;
     LabelStatusEx2: TLabel;
     LabelStatusdisplayed: TLabel;
     fextallto: TMenuItem;
     fextallfav1: TMenuItem;
     mwebs: TMenuItem;
     po_fm: TMenuItem;
     MenuItem34: TMenuItem;
     fextallfav2: TMenuItem;
     fextallfav3: TMenuItem;
     fextallfav4: TMenuItem;
     fextallfav5: TMenuItem;
     fextallfav6: TMenuItem;
     fextallfav7: TMenuItem;
     fextallfav8: TMenuItem;
     extalllast: TMenuItem;
     mbrowsersort: TMenuItem;
     mbrowsersizes: TMenuItem;
     mbrowsersizem: TMenuItem;
     mbrowsersizel: TMenuItem;
     MenuItem65: TMenuItem;
     MenuItem67: TMenuItem;
     MenuItem68: TMenuItem;
     MenuItem70: TMenuItem;
     mAdmin: TMenuItem;
     aowcustom_9: TMenuItem;
     aowcustom_10: TMenuItem;
     aowcustom_11: TMenuItem;
     aowcustom_12: TMenuItem;
     aowcustom_13: TMenuItem;
     aowcustom_14: TMenuItem;
     aowcustom_15: TMenuItem;
     aowcustom_16: TMenuItem;
     eowcustom_9: TMenuItem;
     eowcustom_10: TMenuItem;
     eowcustom_11: TMenuItem;
     eowcustom_12: TMenuItem;
     eowcustom_13: TMenuItem;
     eowcustom_14: TMenuItem;
     eowcustom_15: TMenuItem;
     eowcustom_16: TMenuItem;
     pmqjdropbox: TMenuItem;
     MenuItemProperties: TMenuItem;
     PanelBarOpen1: TPanel;
     mpm: TMenuItem;
     PanelBottom: TPanel;
     pmjumpbreadcrumb: TMenuItem;
     mrecsearch: TMenuItem;
     pmsrec: TMenuItem;
     powcustom_9: TMenuItem;
     powcustom_10: TMenuItem;
     powcustom_11: TMenuItem;
     powcustom_12: TMenuItem;
     powcustom_13: TMenuItem;
     powcustom_14: TMenuItem;
     powcustom_15: TMenuItem;
     powcustom_16: TMenuItem;
     owcustom_9: TMenuItem;
     owcustom_10: TMenuItem;
     owcustom_11: TMenuItem;
     owcustom_12: TMenuItem;
     owcustom_13: TMenuItem;
     owcustom_14: TMenuItem;
     owcustom_15: TMenuItem;
     owcustom_16: TMenuItem;
     mimmersive: TMenuItem;
     msimplesearch: TMenuItem;
     MenuItemopendesktop: TMenuItem;
     mfullscreen: TMenuItem;
     po_checksum: TMenuItem;
     mthumbimages: TMenuItem;
     pmshist3: TMenuItem;
     pmshist4: TMenuItem;
     pmshist5: TMenuItem;
     pmshist6: TMenuItem;
     pmshist7: TMenuItem;
     pmshist8: TMenuItem;
     pmshist1: TMenuItem;
     pmshist2: TMenuItem;
     mtoggleop: TMenuItem;
     mtogglestatusbar: TMenuItem;
     msorttoggle: TMenuItem;
     mtogglenavbar: TMenuItem;
     MenuItem51: TMenuItem;
     MenuItem62: TMenuItem;
     mttoggletoolbar: TMenuItem;
     pma2s_extnew1: TMenuItem;
     pma2s_extallnew1: TMenuItem;
     pma2s_extnew: TMenuItem;
     pma2s_cancel1: TMenuItem;
     pma2s_extract1: TMenuItem;
     pmapptosys1: TPopupMenu;
     mPeaTracker: TMenuItem;
     pmireset: TMenuItem;
     pmextcontext: TPopupMenu;
     pmextcontextall: TMenuItem;
     pmextcontextdisplayed: TMenuItem;
     pmextcontextselected: TMenuItem;
     pmresetsearch: TPopupMenu;
     po_sortby: TMenuItem;
     pmbc1: TMenuItem;
     pmbc2: TMenuItem;
     pmbc3: TMenuItem;
     pmbc4: TMenuItem;
     pmbc5: TMenuItem;
     pmbc6: TMenuItem;
     pmbc7: TMenuItem;
     pmbc8: TMenuItem;
     mswapbars: TMenuItem;
     PanelClickAddress: TPanel;
     Panel8: TPanel;
     PanelListBar: TPanel;
     pmqelast: TMenuItem;
     pmqe2fav: TMenuItem;
     pmqe3fav: TMenuItem;
     mextalldocuments: TMenuItem;
     pmqedocuments: TMenuItem;
     pmqesetpw: TMenuItem;
     mcolumns: TMenuItem;
     mcname: TMenuItem;
     mctype: TMenuItem;
     mcsize: TMenuItem;
     mcpacked: TMenuItem;
     mcdate: TMenuItem;
     mcatt: TMenuItem;
     mccrc: TMenuItem;
     mcfree: TMenuItem;
     mcfs: TMenuItem;
     mbrowsercname: TMenuItem;
     mbrowserctype: TMenuItem;
     mbrowsercsize: TMenuItem;
     mbrowsercpacked: TMenuItem;
     mbrowsercdate: TMenuItem;
     mbrowsercatt: TMenuItem;
     mbrowserccrc: TMenuItem;
     po_browsercname: TMenuItem;
     po_browserctype: TMenuItem;
     po_browsercsize: TMenuItem;
     po_browsercpacked: TMenuItem;
     po_browsercdate: TMenuItem;
     po_browsercatt: TMenuItem;
     po_browserccrc: TMenuItem;
     MenuItem44: TMenuItem;
     MenuItem52: TMenuItem;
     mbreset: TMenuItem;
     MenuItem63: TMenuItem;
     fextalldefault: TMenuItem;
     pmopenout: TMenuItem;
     pmqenopath: TMenuItem;
     mextalldesktop: TMenuItem;
     pmqen1: TMenuItem;
     pmqen2: TMenuItem;
     pmqen3: TMenuItem;
     pmqen4: TMenuItem;
     pmqen5: TMenuItem;
     mextallhere: TMenuItem;
     mextallto: TMenuItem;
     MenuItemExtAllHere: TMenuItem;
     MenuItemExtAllTo: TMenuItem;
     pmusedefault: TMenuItem;
     pmqedefault: TMenuItem;
     pmqe1fav: TMenuItem;
     MenuItem66: TMenuItem;
     pmqenewfolder: TMenuItem;
     pmqedesk: TMenuItem;
     pmqeto: TMenuItem;
     pmqehere: TMenuItem;
     mSystemIntegration: TMenuItem;
     pma2s_extractall1: TMenuItem;
     msmallicon: TMenuItem;
     mwebsearch: TMenuItem;
     PanelIntro: TPanel;
     MenuItemDonations: TMenuItem;
     MenuItemOpen_downloads1: TMenuItem;
     MenuItemArchive_downloads: TMenuItem;
     pmjumpdownloads: TMenuItem;
     pmquickextract: TPopupMenu;
     pmbreadcrumb: TPopupMenu;
     po_open_asarchive: TMenuItem;
     pmjumprecent: TMenuItem;
     pmjumpsearches: TMenuItem;
     pmjumplibraries: TMenuItem;
     MenuItemOrganizeMbar: TMenuItem;
     MenuItemArchive_pubhome: TMenuItem;
     MenuItemOpen_pubhome: TMenuItem;
     mbrowser: TMenuItem;
     MenuItem53: TMenuItem;
     MenuItem55: TMenuItem;
     MenuItem57: TMenuItem;
     MenuItem58: TMenuItem;
     MenuItem59: TMenuItem;
     morganize: TMenuItem;
     pmhr1: TMenuItem;
     pmhr2: TMenuItem;
     pmhr3: TMenuItem;
     pmhr4: TMenuItem;
     pmhr5: TMenuItem;
     pmhr6: TMenuItem;
     pmhr7: TMenuItem;
     pmhr8: TMenuItem;
     pmhr9: TMenuItem;
     pmjumppubhome: TMenuItem;
     pma2s_extract: TMenuItem;
     pms2a_open: TMenuItem;
     MenuItem9: TMenuItem;
     mshowmenu: TMenuItem;
     mthl: TMenuItem;
     MenuItem46: TMenuItem;
     pms2a_add: TMenuItem;
     pma2s_cancel: TMenuItem;
     pms2a_copy: TMenuItem;
     pma2s_copy: TMenuItem;
     pms2a_move: TMenuItem;
     MenuItem45: TMenuItem;
     pms2a_cancel: TMenuItem;
     MenuItemOpen_search: TMenuItem;
     munsearch: TMenuItem;
     pmjumpsearch: TMenuItem;
     pma2s_move: TMenuItem;
     pmsystoapp: TPopupMenu;
     pmapptosys: TPopupMenu;
     Panelnav: TPanel;
     LabelStatusAr2: TLabel;
     ListView1: TListView;
     mctrlf3: TMenuItem;
     mcancel: TMenuItem;
     mbcl: TMenuItem;
     MenuItem10: TMenuItem;
     MenuItem13: TMenuItem;
     MenuItem14: TMenuItem;
     mbpea: TMenuItem;
     mbexplore: TMenuItem;
     MenuItem23: TMenuItem;
     mr9: TMenuItem;
     mhpea: TMenuItem;
     mhexplore: TMenuItem;
     mhcl: TMenuItem;
     MenuItem39: TMenuItem;
     MenuItemOpen_pubdoc: TMenuItem;
     MenuItemArchive_pubdoc: TMenuItem;
     pmjumppubdoc: TMenuItem;
     pnh1: TMenuItem;
     pnh2: TMenuItem;
     pnh3: TMenuItem;
     pnh4: TMenuItem;
     pnh5: TMenuItem;
     pnh6: TMenuItem;
     pnh7: TMenuItem;
     pnh8: TMenuItem;
     SelectDirectoryDialog2: TSelectDirectoryDialog;
     ShellTreeView1: TShellTreeView;
     smHistory1: TMenuItem;
     pnha2: TMenuItem;
     pnha3: TMenuItem;
     pnha4: TMenuItem;
     pnha5: TMenuItem;
     pnha6: TMenuItem;
     pnha7: TMenuItem;
     pnha8: TMenuItem;
     smHistorya1: TMenuItem;
     pnha1: TMenuItem;
     mNav: TMenuItem;
     mhistory2: TMenuItem;
     mhistory3: TMenuItem;
     mhistory4: TMenuItem;
     mhistory5: TMenuItem;
     mhistory6: TMenuItem;
     mhistory7: TMenuItem;
     mhistory8: TMenuItem;
     mHistory: TMenuItem;
     mhistory1: TMenuItem;
     pmh9: TMenuItem;
     mshiftf3: TMenuItem;
     MenuItem41: TMenuItem;
     po_hidden: TMenuItem;
     mopenasarchive: TMenuItem;
     pmbookmarks: TMenuItem;
     po_convertarchive: TMenuItem;
     mrowselect: TMenuItem;
     po_selectall: TMenuItem;
     mlist: TMenuItem;
     mdetails: TMenuItem;
     mgotypegz: TMenuItem;
     mgotype7zsfx: TMenuItem;
     mgotypetar: TMenuItem;
     mgotypezip: TMenuItem;
     mgotypebz2: TMenuItem;
     mgotype7z: TMenuItem;
     mgotype: TMenuItem;
     mgobrowser: TMenuItem;
     mextractarchive: TMenuItem;
     mtogglenew: TMenuItem;
     mLayout: TMenuItem;
     pmsecuredelete: TMenuItem;
     pmquickdelete: TMenuItem;
     pmcpyto: TMenuItem;
     pmmvto: TMenuItem;
     pmexplore: TMenuItem;
     pmcommand: TMenuItem;
     pmh2: TMenuItem;
     pmh3: TMenuItem;
     pmh4: TMenuItem;
     pmh5: TMenuItem;
     pmh7: TMenuItem;
     pmh6: TMenuItem;
     pmh8: TMenuItem;
     pmh1: TMenuItem;
     mLang: TMenuItem;
     MenuItemOpen_Last: TMenuItem;
     MenuItem2: TMenuItem;
     madvfilters: TMenuItem;
     MenuItem33: TMenuItem;
     mkeyfile: TMenuItem;
     msetpw: TMenuItem;
     mOptions: TMenuItem;
     mgoextlayout: TMenuItem;
     MenuItem28: TMenuItem;
     MenuItem31: TMenuItem;
     MenuItemextexplore: TMenuItem;
     MenuItemArchive_documents1: TMenuItem;
     NotebookOpen: TPanel;
     PanelActAdd: TPanel;
     PanelActExt: TPanel;
     PanelExtract: TPanel;
     PanelFileBrowserOptions: TPanel;
     PopupMenuType: TPopupMenu;
     pmBrowser: TMenuItem;
     mpathself1: TMenuItem;
     MenuItemArchive_home1: TMenuItem;
     MenuItemArchive_pc: TMenuItem;
     mpathdesk1: TMenuItem;
     mpathexplore1: TMenuItem;
     mpathreset1: TMenuItem;
     mf8: TMenuItem;
     mctrlf8: TMenuItem;
     mshiftf8: TMenuItem;
     mf2: TMenuItem;
     mf4up: TMenuItem;
     mfun: TMenuItem;
     PanelBack1: TPanel;
     PopupMenupath1: TPopupMenu;
     smBookmarksa1: TMenuItem;
     smfs1: TMenuItem;
     mf3: TMenuItem;
     MenuItemHistoryBook: TMenuItem;
     PopupMenuHistory: TPopupMenu;
     smfsa1: TMenuItem;
     pnr1: TMenuItem;
     pnr2: TMenuItem;
     pnr3: TMenuItem;
     pnr4: TMenuItem;
     pnr5: TMenuItem;
     pnr6: TMenuItem;
     pnr7: TMenuItem;
     pnr8: TMenuItem;
     pnra1: TMenuItem;
     pnra2: TMenuItem;
     pnra3: TMenuItem;
     pnra4: TMenuItem;
     pnra5: TMenuItem;
     pnra6: TMenuItem;
     pnra7: TMenuItem;
     pnra8: TMenuItem;
     MenuItemOpen_here: TMenuItem;
     mRecent9: TMenuItem;
     pmjb2: TMenuItem;
     pmjb3: TMenuItem;
     pmjb4: TMenuItem;
     pmjb5: TMenuItem;
     pmjb6: TMenuItem;
     pmjb7: TMenuItem;
     pmjb8: TMenuItem;
     pmjb9: TMenuItem;
     pmjb10: TMenuItem;
     pmjb11: TMenuItem;
     pmjb12: TMenuItem;
     pmjb13: TMenuItem;
     pmjb14: TMenuItem;
     pmjb15: TMenuItem;
     pmjb16: TMenuItem;
     pmjb17: TMenuItem;
     pmjb18: TMenuItem;
     pmjb19: TMenuItem;
     pmjb20: TMenuItem;
     pmjb21: TMenuItem;
     pmjb22: TMenuItem;
     pmjb23: TMenuItem;
     pmjb24: TMenuItem;
     pmjumpsbook: TMenuItem;
     MenuItem29: TMenuItem;
     MenuItemOpen_pc: TMenuItem;
     pmjb1: TMenuItem;
     MenuItemOpen_desktop1: TMenuItem;
     MenuItemOpen_documents1: TMenuItem;
     MenuItemOpen_home1: TMenuItem;
     pcustompathexplore: TMenuItem;
     pojdn1: TMenuItem;
     pojdn2: TMenuItem;
     pojdn3: TMenuItem;
     pojdn4: TMenuItem;
     pojdn5: TMenuItem;
     pojdn6: TMenuItem;
     pojdn7: TMenuItem;
     pojdn8: TMenuItem;
     pojdn9: TMenuItem;
     pojdn10: TMenuItem;
     pojdn11: TMenuItem;
     pojdn12: TMenuItem;
     pojdn13: TMenuItem;
     pojdn14: TMenuItem;
     pojdn15: TMenuItem;
     pojdn16: TMenuItem;
     pojdn17: TMenuItem;
     pojdn18: TMenuItem;
     pojdn19: TMenuItem;
     pojdn20: TMenuItem;
     pojdn21: TMenuItem;
     pojdn22: TMenuItem;
     pojdn23: TMenuItem;
     pojdn24: TMenuItem;
     pojdn25: TMenuItem;
     pojdn26: TMenuItem;
     pajdn1: TMenuItem;
     pajdn2: TMenuItem;
     pajdn3: TMenuItem;
     pajdn4: TMenuItem;
     pajdn5: TMenuItem;
     pajdn6: TMenuItem;
     pajdn7: TMenuItem;
     pajdn8: TMenuItem;
     pajdn9: TMenuItem;
     pajdn10: TMenuItem;
     pajdn11: TMenuItem;
     pajdn12: TMenuItem;
     pajdn13: TMenuItem;
     pajdn14: TMenuItem;
     pajdn15: TMenuItem;
     pajdn16: TMenuItem;
     pajdn17: TMenuItem;
     pajdn18: TMenuItem;
     pajdn19: TMenuItem;
     pajdn20: TMenuItem;
     pajdn21: TMenuItem;
     pajdn22: TMenuItem;
     pajdn23: TMenuItem;
     pajdn24: TMenuItem;
     pajdn25: TMenuItem;
     pajdn26: TMenuItem;
     pnb1: TMenuItem;
     pnb2: TMenuItem;
     pnb3: TMenuItem;
     pnb4: TMenuItem;
     pnb5: TMenuItem;
     pnb6: TMenuItem;
     pnb7: TMenuItem;
     pnb8: TMenuItem;
     pnb9: TMenuItem;
     pnb10: TMenuItem;
     pnb11: TMenuItem;
     pnb12: TMenuItem;
     pnb13: TMenuItem;
     pnb14: TMenuItem;
     pnb15: TMenuItem;
     pnb16: TMenuItem;
     pnb17: TMenuItem;
     pnb18: TMenuItem;
     pnb19: TMenuItem;
     pnb20: TMenuItem;
     pnb21: TMenuItem;
     pnb22: TMenuItem;
     pnb23: TMenuItem;
     pnba1: TMenuItem;
     pnba2: TMenuItem;
     pnba3: TMenuItem;
     pnba4: TMenuItem;
     pnba5: TMenuItem;
     pnba6: TMenuItem;
     pnba7: TMenuItem;
     pnba8: TMenuItem;
     pnba9: TMenuItem;
     pnba10: TMenuItem;
     pnba11: TMenuItem;
     pnba12: TMenuItem;
     pnba13: TMenuItem;
     pnba14: TMenuItem;
     pnba15: TMenuItem;
     pnba16: TMenuItem;
     pnba17: TMenuItem;
     pnba18: TMenuItem;
     pnba19: TMenuItem;
     pnba20: TMenuItem;
     pnba21: TMenuItem;
     pnba22: TMenuItem;
     pnba23: TMenuItem;
     PopupOpen1: TPopupMenu;
     pmmorefun_info: TMenuItem;
     pmmorefun_list: TMenuItem;
     aowseparator2: TMenuItem;
     PanelFilters: TPanel;
     MenuItemPW: TMenuItem;
     MenuItem27: TMenuItem;
     MenuItemNavigate: TMenuItem;
     OpenDialogTheme: TOpenDialog;
     pmjd1: TMenuItem;
     pmjd2: TMenuItem;
     pmjd3: TMenuItem;
     pmjd4: TMenuItem;
     pmjd5: TMenuItem;
     pmjd6: TMenuItem;
     pmjd7: TMenuItem;
     pmjd8: TMenuItem;
     pmjd9: TMenuItem;
     pmjd10: TMenuItem;
     pmjd11: TMenuItem;
     pmjd12: TMenuItem;
     pmjd13: TMenuItem;
     pmjd14: TMenuItem;
     pmjd15: TMenuItem;
     pmjd16: TMenuItem;
     pmjd17: TMenuItem;
     pmjd18: TMenuItem;
     pmjd19: TMenuItem;
     pmjd20: TMenuItem;
     pmjd21: TMenuItem;
     pmjd22: TMenuItem;
     pmjd23: TMenuItem;
     pmjd24: TMenuItem;
     pmjd25: TMenuItem;
     pmjd26: TMenuItem;
     pmmorefun: TPopupMenu;
     munpeabrowse: TMenuItem;
     munpea: TMenuItem;
     smBookmarks1: TMenuItem;
     MenuItemOpen_addtobookmarks: TMenuItem;
     po_delete: TMenuItem;
     po_securedelete: TMenuItem;
     sbBrowse: TMenuItem;
     MenuItemOpen_Up: TMenuItem;
     MenuItemOpen_back: TMenuItem;
     MenuItemOpen_fwd: TMenuItem;
     MenuItemOpen_root: TMenuItem;
     MenuItemOpen_jump: TMenuItem;
     MenuItemOpen_Flat: TMenuItem;
     MenuItemOpen_refresh: TMenuItem;
     po_spacer: TMenuItem;
     po_setpw: TMenuItem;
     mpeahelpoffline: TMenuItem;
     mTutorial: TMenuItem;
     eowseparator1: TMenuItem;
     eowcustom1: TMenuItem;
     eowcustom2: TMenuItem;
     eowcustom3: TMenuItem;
     eowcustom4: TMenuItem;
     eowcustom5: TMenuItem;
     eowcustom6: TMenuItem;
     eowcustom7: TMenuItem;
     eowcustom8: TMenuItem;
     powseparator1: TMenuItem;
     aowseparator1: TMenuItem;
     aowcustom1: TMenuItem;
     aowcustom2: TMenuItem;
     aowcustom3: TMenuItem;
     aowcustom4: TMenuItem;
     aowcustom6: TMenuItem;
     aowcustom5: TMenuItem;
     aowcustom7: TMenuItem;
     aowcustom8: TMenuItem;
     eowcustom9: TMenuItem;
     eowcustom10: TMenuItem;
     eowcustom11: TMenuItem;
     eowcustom12: TMenuItem;
     eowcustom13: TMenuItem;
     eowcustom14: TMenuItem;
     eowcustom15: TMenuItem;
     eowcustom16: TMenuItem;
     aowcustom9: TMenuItem;
     aowcustom10: TMenuItem;
     aowcustom11: TMenuItem;
     aowcustom12: TMenuItem;
     aowcustom13: TMenuItem;
     aowcustom14: TMenuItem;
     aowcustom15: TMenuItem;
     aowcustom16: TMenuItem;
     powcustom9: TMenuItem;
     powcustom10: TMenuItem;
     powcustom11: TMenuItem;
     powcustom12: TMenuItem;
     powcustom13: TMenuItem;
     powcustom14: TMenuItem;
     powcustom15: TMenuItem;
     powcustom16: TMenuItem;
     owcustom10: TMenuItem;
     owcustom11: TMenuItem;
     owcustom12: TMenuItem;
     owcustom13: TMenuItem;
     owcustom14: TMenuItem;
     owcustom15: TMenuItem;
     owcustom16: TMenuItem;
     owcustom9: TMenuItem;
     powcustom1: TMenuItem;
     powcustom2: TMenuItem;
     powcustom3: TMenuItem;
     powcustom4: TMenuItem;
     powcustom5: TMenuItem;
     powcustom6: TMenuItem;
     powcustom7: TMenuItem;
     powcustom8: TMenuItem;
     owcustom1: TMenuItem;
     owcustom2: TMenuItem;
     owcustom3: TMenuItem;
     owcustom4: TMenuItem;
     owcustom5: TMenuItem;
     owcustom6: TMenuItem;
     owcustom7: TMenuItem;
     owcustom8: TMenuItem;
     po_open_peazipt: TMenuItem;
     po_open_associatedt: TMenuItem;
     po_open_customt: TMenuItem;
     po_setappst: TMenuItem;
     owcustom1t: TMenuItem;
     owcustom2t: TMenuItem;
     owcustom3t: TMenuItem;
     owcustom4t: TMenuItem;
     owcustom5t: TMenuItem;
     owcustom6t: TMenuItem;
     owcustom7t: TMenuItem;
     owcustom8t: TMenuItem;
     owcustom9t: TMenuItem;
     owcustom10t: TMenuItem;
     owcustom11t: TMenuItem;
     owcustom12t: TMenuItem;
     owcustom13t: TMenuItem;
     owcustom14t: TMenuItem;
     owcustom15t: TMenuItem;
     owcustom16t: TMenuItem;
     owcustom_9t: TMenuItem;
     owcustom_10t: TMenuItem;
     owcustom_11t: TMenuItem;
     owcustom_12t: TMenuItem;
     owcustom_13t: TMenuItem;
     owcustom_14t: TMenuItem;
     owcustom_15t: TMenuItem;
     owcustom_16t: TMenuItem;
     Splitter1: TSplitter;
     Splitter2: TSplitter;
     StringGridBookmarks: TStringGrid;
     StringGridClipboard: TStringGrid;
     StringGridSessionHistory: TStringGrid;
     StringGridRecent: TStringGrid;
     Timer2: TTimer;
     Timer3: TTimer;
     Timerdrag: TTimer;
     TimerHintStart: TTimer;
     tmpeazip: TMenuItem;
     MenuItem22: TMenuItem;
     tmcreate: TMenuItem;
     MenuItem21: TMenuItem;
     tmopenpath: TMenuItem;
     tmopenarchive: TMenuItem;
     MenuItem24: TMenuItem;
     tmquit: TMenuItem;
     mTray: TMenuItem;
     PopupMenuTray: TPopupMenu;
     TrayIcon1: TTrayIcon;
     TreeView1: TTreeView;
     po_hexp: TMenuItem;
     MenuItemToolhexp: TMenuItem;
     pmJumpDocuments: TMenuItem;
     pclip_removeitem: TMenuItem;
     pclip_clearclip: TMenuItem;
     pmJump3: TMenuItem;
     PopupMenuClipboard: TPopupMenu;
      mAttributes: TMenuItem;
      mDate: TMenuItem;
      mDateRecent: TMenuItem;
      mDateEqual: TMenuItem;
      mDateOlder: TMenuItem;
      mDateERecent: TMenuItem;
      mDateEOlder: TMenuItem;
      MenuItem11: TMenuItem;
      mbAddArchive: TMenuItem;
      mbAddPath: TMenuItem;
      mbDelete: TMenuItem;
      mBookmarks: TMenuItem;
      mb12: TMenuItem;
      mb1: TMenuItem;
      mb11: TMenuItem;
      mb10: TMenuItem;
      mb9: TMenuItem;
      mb8: TMenuItem;
      mb7: TMenuItem;
      mb6: TMenuItem;
      mb5: TMenuItem;
      mb4: TMenuItem;
      mb3: TMenuItem;
      mb2: TMenuItem;
      mb13: TMenuItem;
      mb14: TMenuItem;
      mb15: TMenuItem;
      mb24: TMenuItem;
      mb16: TMenuItem;
      mb17: TMenuItem;
      mb18: TMenuItem;
      mb19: TMenuItem;
      mb20: TMenuItem;
      mb21: TMenuItem;
      mb22: TMenuItem;
      mb23: TMenuItem;
      MenuItem15: TMenuItem;
      mbNotes: TMenuItem;
      MenuItem16: TMenuItem;
      mAbout: TMenuItem;
      po_envstr: TMenuItem;
      po_convert: TMenuItem;
      MenuItemBookmarks: TMenuItem;
      pmExplorepath: TMenuItem;
      mcp: TMenuItem;
      mMisc: TMenuItem;
      po_copyto: TMenuItem;
      po_moveto: TMenuItem;
      MenuItemOpen_explore: TMenuItem;
      MenuItemOpen_commandprompt: TMenuItem;
      PopupMenuBookmarks: TPopupMenu;
      MenuItemRefresh: TMenuItem;
      mUser: TMenuItem;
      po_computer: TMenuItem;
      po_manage: TMenuItem;
      po_removeunits: TMenuItem;
      po_cpl: TMenuItem;
      po_taskman: TMenuItem;
      po_diskclean: TMenuItem;
      po_defrag: TMenuItem;
      po_systemtools: TMenuItem;
      mgolayout: TMenuItem;
      MenuItemOpen_path: TMenuItem;
      MenuItemOpen_archive: TMenuItem;
      po_join: TMenuItem;
      po_compare: TMenuItem;
      po_check: TMenuItem;
      po_paste: TMenuItem;
      po_split: TMenuItem;
      po_newfolder: TMenuItem;
      po_rename: TMenuItem;
      MenuItem7: TMenuItem;
      po_copy: TMenuItem;
      po_cut: TMenuItem;
      po_filetools: TMenuItem;
      po_open_peazip: TMenuItem;
      po_open_associated: TMenuItem;
      po_open_custom: TMenuItem;
      po_open: TMenuItem;
      MenuItemOpen_list_all: TMenuItem;
      MenuItemOpen_list_selected: TMenuItem;
      MenuItemOpen_list_displayed: TMenuItem;
      MenuItemOpen_list: TMenuItem;
      po_list: TMenuItem;
      po_test: TMenuItem;
      po_info: TMenuItem;
      po_exthere: TMenuItem;
      po_addtoarchive: TMenuItem;
      mRefresh: TMenuItem;
      pmJumpArchive: TMenuItem;
      pmJumpPath: TMenuItem;
      pmJump2: TMenuItem;
      pmJump1: TMenuItem;
      pcustom3: TMenuItem;
      pcustom2: TMenuItem;
      pcustom1: TMenuItem;
      pcustom8: TMenuItem;
      pcustom7: TMenuItem;
      pcustom6: TMenuItem;
      pcustom5: TMenuItem;
      pcustom4: TMenuItem;
      mSpacer2_1: TMenuItem;
      mSortBySelection: TMenuItem;
      pmSearchAdd: TMenuItem;
      mSpacer0: TMenuItem;
      MenuItemToolCheck: TMenuItem;
      MenuItemToolCompare: TMenuItem;
      MenuItemOpen_ext_all: TMenuItem;
      MenuItemOpen_ext_selected: TMenuItem;
      MenuItemOpen_ext_displayed: TMenuItem;
      MenuItemOpen_ExtractHere: TMenuItem;
      mQuit: TMenuItem;
      mSpacer0_1: TMenuItem;
      mSizeESmaller: TMenuItem;
      mSizeELarger: TMenuItem;
      mPSLarger: TMenuItem;
      mPSELarger: TMenuItem;
      mPSEqual: TMenuItem;
      mPSESmaller: TMenuItem;
      mPackedSize: TMenuItem;
      mPSSmaller: TMenuItem;
      mSizeEqual: TMenuItem;
      mSizeLarger: TMenuItem;
      mSizeSmaller: TMenuItem;
      mSize: TMenuItem;
      mSpacer2_0: TMenuItem;
      mType: TMenuItem;
      pCustom: TPopupMenu;
      MainMenu1: TMainMenu;
      mDefaults: TMenuItem;
      MenuItem1: TMenuItem;
      mBench: TMenuItem;
      mEdit: TMenuItem;
      mBrowse: TMenuItem;
      MenuItemTools: TMenuItem;
      MenuItemOpen_info_selected: TMenuItem;
      MenuItemOpen_info_all: TMenuItem;
      MenuItemOpen_info_displayed: TMenuItem;
      mFlat: TMenuItem;
      mSpacer3: TMenuItem;
      openwithpeazip: TMenuItem;
      openwithassociated: TMenuItem;
      openwithcustom: TMenuItem;
      MenuItemERCustom: TMenuItem;
      MenuItemPrePeaZip: TMenuItem;
      MenuItemPreAssociated: TMenuItem;
      MenuItemPreCustom: TMenuItem;
      MenuItemERPeaZip: TMenuItem;
      MenuItemERAssociated: TMenuItem;
      mRecent4: TMenuItem;
      mRecent3: TMenuItem;
      mRecent2: TMenuItem;
      mRecent1: TMenuItem;
      mRecent8: TMenuItem;
      mRecent7: TMenuItem;
      mRecent6: TMenuItem;
      mRecent5: TMenuItem;
      mInvertSelection: TMenuItem;
      mSelectAll: TMenuItem;
      MenuItemOpen_preview: TMenuItem;
      MenuItemOpenWeb: TMenuItem;
      MenuItemOpen_test_all: TMenuItem;
      MenuItemOpen_test_selected: TMenuItem;
      MenuItemOpen_test_displayed: TMenuItem;
      MenuItemOpen_test: TMenuItem;
      MenuItemOpen_info: TMenuItem;
      MenuItemOpen_spacer5: TMenuItem;
      pmOpenPJdisplayed: TMenuItem;
      pmOpenPJselected: TMenuItem;
      pmOpenPJall: TMenuItem;
      pmOpenPJ: TPopupMenu;
      MenuItem5b: TMenuItem;
      MenuItemOpen_extandopenwith: TMenuItem;
      Notebook1: TPanel;
      PanelArchiveMain: TPanel;
      PanelBarOpen: TPanel;
      PanelDefaults: TPanel;
      PanelOpen: TPanel;
      pmSaveList: TMenuItem;
      pmLoadList: TMenuItem;
      pmAddFolder: TMenuItem;
      pmAddFile: TMenuItem;
      MenuItem3: TMenuItem;
      mPEA: TMenuItem;
      mFeatures: TMenuItem;
      mHelp: TMenuItem;
      mOptionsMenu: TMenuItem;
      OpenDialogLang: TOpenDialog;
      OpenDialogList: TOpenDialog;
      OpenDialogArchive: TOpenDialog;
      PopupMenu1: TPopupMenu;
      PopupOpen: TPopupMenu;
      SaveDialog2: TSaveDialog;
      SaveDialogPJ: TSaveDialog;
      SelectDirectoryDialog1: TSelectDirectoryDialog;
      StringGridTmp: TStringGrid;
      Timer1: TTimer;
      TreeView2: TTreeView;
      procedure abc0Click(Sender: TObject);
      procedure abc1Click(Sender: TObject);
      procedure abc2Click(Sender: TObject);
      procedure abc3Click(Sender: TObject);
      procedure abc4Click(Sender: TObject);
      procedure abc5Click(Sender: TObject);
      procedure abc6Click(Sender: TObject);
      procedure abc7Click(Sender: TObject);
      procedure abc8Click(Sender: TObject);
      procedure aowcustom10Click(Sender: TObject);
      procedure aowcustom11Click(Sender: TObject);
      procedure aowcustom12Click(Sender: TObject);
      procedure aowcustom13Click(Sender: TObject);
      procedure aowcustom14Click(Sender: TObject);
      procedure aowcustom15Click(Sender: TObject);
      procedure aowcustom16Click(Sender: TObject);
      procedure aowcustom1Click(Sender: TObject);
      procedure aowcustom2Click(Sender: TObject);
      procedure aowcustom3Click(Sender: TObject);
      procedure aowcustom4Click(Sender: TObject);
      procedure aowcustom5Click(Sender: TObject);
      procedure aowcustom6Click(Sender: TObject);
      procedure aowcustom7Click(Sender: TObject);
      procedure aowcustom8Click(Sender: TObject);
      procedure aowcustom9Click(Sender: TObject);
      procedure aowcustom_10Click(Sender: TObject);
      procedure aowcustom_11Click(Sender: TObject);
      procedure aowcustom_12Click(Sender: TObject);
      procedure aowcustom_13Click(Sender: TObject);
      procedure aowcustom_14Click(Sender: TObject);
      procedure aowcustom_15Click(Sender: TObject);
      procedure aowcustom_16Click(Sender: TObject);
      procedure aowcustom_9Click(Sender: TObject);
      procedure baboutbinClick(Sender: TObject);
      procedure baboutfaqClick(Sender: TObject);
      procedure baboutlocalhelpClick(Sender: TObject);
      procedure baboutplugindirClick(Sender: TObject);
      procedure baboutremoveunaceClick(Sender: TObject);
      procedure baboutremoveunrarClick(Sender: TObject);
      procedure baboutsupportClick(Sender: TObject);
      procedure babouttrackerClick(Sender: TObject);
      procedure baboutwebClick(Sender: TObject);
      procedure BSchedule1Click(Sender: TObject);
      procedure BScheduleClick(Sender: TObject);
      procedure Button2Click(Sender: TObject);
      procedure ButtonArchive1Click(Sender: TObject);
      procedure ButtoncmtoClick(Sender: TObject);
      procedure ButtonCopyClick(Sender: TObject);
      procedure ButtonCutClick(Sender: TObject);
      procedure ButtonDesk1Click(Sender: TObject);
      procedure ButtonDupClick(Sender: TObject);
      procedure ButtonEditName12Click(Sender: TObject);
      procedure ButtonEditName13Click(Sender: TObject);
      procedure ButtonEditName3Click(Sender: TObject);
      procedure ButtonEditName4Click(Sender: TObject);
      procedure ButtonEditName5Click(Sender: TObject);
      procedure ButtonEditName8Click(Sender: TObject);
      procedure ButtonEditNameCustom1Click(Sender: TObject);
      procedure ButtonExtCancelClick(Sender: TObject);
      procedure ButtonExtOkClick(Sender: TObject);
      procedure Buttonfmactions1Click(Sender: TObject);
      procedure ButtonfmactionsClick(Sender: TObject);
      procedure ButtonImgRClick(Sender: TObject);
      procedure ButtonImgResClick(Sender: TObject);
      procedure ButtonImgResizeClick(Sender: TObject);
      procedure ButtonImgCropClick(Sender: TObject);
      procedure ButtonImgRLClick(Sender: TObject);
      procedure ButtonImgRRClick(Sender: TObject);
      procedure ButtonImg6Click(Sender: TObject);
      procedure ButtonNFClick(Sender: TObject);
      procedure ButtonopenactionsClick(Sender: TObject);
      procedure ButtonOpenWithClick(Sender: TObject);
      procedure ButtonPasteClick(Sender: TObject);
      procedure ButtonPropertiesClick(Sender: TObject);
      procedure ButtonDeleteClick(Sender: TObject);
      procedure ButtonRenameClick(Sender: TObject);
      procedure ButtonUn7za10Click(Sender: TObject);
      procedure ButtonUn7za11Click(Sender: TObject);
      procedure ButtonUn7za11MouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ButtonUn7za4MouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ButtonUn7za5Click(Sender: TObject);
      procedure ButtonUn7za5MouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ButtonUn7za6Click(Sender: TObject);
      procedure ButtonUn7za7Click(Sender: TObject);
      procedure ButtonUn7za8Click(Sender: TObject);
      procedure ButtonUn7za8MouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ButtonUn7za9Click(Sender: TObject);
      procedure cbadvf1Click(Sender: TObject);
      procedure cbadvf2Click(Sender: TObject);
      procedure cbautoclosesingleextractClick(Sender: TObject);
      procedure cbcustextClick(Sender: TObject);
      procedure cbdefaultactionChange(Sender: TObject);
      procedure cbdeleteinputmode1Change(Sender: TObject);
      procedure cbdeleteinputmodeChange(Sender: TObject);
      procedure cbencextClick(Sender: TObject);
      procedure cbEncoding1Change(Sender: TObject);
      procedure cbensmallChange(Sender: TObject);
      procedure cbExtEvForHowChange(Sender: TObject);
      procedure cbExtEvForWhenChange(Sender: TObject);
      procedure cbRAR5Click(Sender: TObject);
      procedure cbRARBLAKE2Click(Sender: TObject);
      procedure cbRARClick(Sender: TObject);
      procedure cbRARlastmodtimeChange(Sender: TObject);
      procedure cbRARlockClick(Sender: TObject);
      procedure cbRARrrClick(Sender: TObject);
      procedure cbRARsaveopenClick(Sender: TObject);
      procedure cbRARsavesecurityClick(Sender: TObject);
      procedure cbRARsavestreamsClick(Sender: TObject);
      procedure cbRARsfxClick(Sender: TObject);
      procedure cbRARsolidClick(Sender: TObject);
      procedure cbSys7zlinChange(Sender: TObject);
      procedure cbtimecreatedClick(Sender: TObject);
      procedure cbtreeChange(Sender: TObject);
      procedure cbspacingChange(Sender: TObject);
      procedure cbzoomingChange(Sender: TObject);
      procedure CheckBox1Click(Sender: TObject);
      procedure CheckBox2Click(Sender: TObject);
      procedure CheckBox3Click(Sender: TObject);
      procedure CheckBox7zunrar5Click(Sender: TObject);
      procedure CheckBoxAccentToolBarChange(Sender: TObject);
      procedure CheckBoxACClick(Sender: TObject);
      procedure CheckBoxAltBarChange(Sender: TObject);
      procedure CheckBoxAltTabChange(Sender: TObject);
      procedure CheckBoxAlttabcolChange(Sender: TObject);
      procedure CheckBoxARC3Click(Sender: TObject);
      procedure CheckBoxArchive4Click(Sender: TObject);
      procedure CheckBoxAutoExtTar1Click(Sender: TObject);
      procedure CheckBoxAutoExtTarClick(Sender: TObject);
      procedure CheckBoxAutoOpenTarClick(Sender: TObject);
      procedure CheckBoxAutoTestClick(Sender: TObject);
      procedure CheckBoxBrotliClick(Sender: TObject);
      procedure CheckBoxBrowseNotVerboseClick(Sender: TObject);
      procedure CheckBoxCenteredToolbarClick(Sender: TObject);
      procedure CheckBoxClosePeaZipClick(Sender: TObject);
      procedure CheckBoxConvert0Change(Sender: TObject);
      procedure CheckBoxConvert1Change(Sender: TObject);
      procedure CheckBoxConvertChange(Sender: TObject);
      procedure CheckBoxDateClick(Sender: TObject);
      procedure CheckBoxDeleteInput1Click(Sender: TObject);
      procedure CheckBoxDeleteInputClick(Sender: TObject);
      procedure CheckBoxDragDropClick(Sender: TObject);
      procedure CheckBoxEditArchivesChange(Sender: TObject);
      procedure CheckBoxEnumdClick(Sender: TObject);
      procedure CheckBoxExcludeEFClick(Sender: TObject);
      procedure CheckBoxExtAndClick(Sender: TObject);
      procedure CheckBoxExtrac32Click(Sender: TObject);
      procedure CheckBoxFolder1Click(Sender: TObject);
      procedure CheckBoxForceBrowseClick(Sender: TObject);
      procedure CheckBoxForceConvertClick(Sender: TObject);
      procedure CheckBoxForceEditClick(Sender: TObject);
      procedure CheckBoxForceLayoutClick(Sender: TObject);
      procedure CheckBoxForceOpenClick(Sender: TObject);
      procedure CheckBoxIntDirClick(Sender: TObject);
      procedure CheckBoxMailKeepClick(Sender: TObject);
      procedure CheckBoxMQSClick(Sender: TObject);
      procedure CheckBoxNameAsParentFolderClick(Sender: TObject);
      procedure CheckBoxnetworkinfoClick(Sender: TObject);
      procedure CheckBoxNoConfClick(Sender: TObject);
      procedure CheckBoxrelativeClick(Sender: TObject);
      procedure CheckBoxSameArcClick(Sender: TObject);
      procedure CheckBoxSameExtClick(Sender: TObject);
      procedure CheckBoxShowVolatileClick(Sender: TObject);
      procedure CheckBoxSkipDelClick(Sender: TObject);
      procedure CheckBoxSkipencClick(Sender: TObject);
      procedure CheckBoxsnhClick(Sender: TObject);
      procedure CheckBoxsni1Click(Sender: TObject);
      procedure CheckBoxsniClick(Sender: TObject);
      procedure CheckBoxsnlClick(Sender: TObject);
      procedure CheckBoxsnoiClick(Sender: TObject);
      procedure CheckBoxsnonClick(Sender: TObject);
      procedure CheckBoxsns1Click(Sender: TObject);
      procedure CheckBoxsnsClick(Sender: TObject);
      procedure CheckBoxsnz1Click(Sender: TObject);
      procedure CheckBoxSolidAddressChange(Sender: TObject);
      procedure CheckBoxsspClick(Sender: TObject);
      procedure CheckBoxstlClick(Sender: TObject);
      procedure CheckBoxARC2Click(Sender: TObject);
      procedure CheckBoxAutoOpenClick(Sender: TObject);
      procedure CheckBoxClipClick(Sender: TObject);
      procedure CheckBoxEncodingClick(Sender: TObject);
      procedure CheckBoxFolderClick(Sender: TObject);
      procedure CheckBoxJobEncodingClick(Sender: TObject);
      procedure CheckBoxParallelArchivingClick(Sender: TObject);
      procedure CheckBoxSeparateClick(Sender: TObject);
      procedure CheckBoxAltgridcolClick(Sender: TObject);
      procedure CheckBoxzcopyClick(Sender: TObject);
      procedure CheckBoxzipxswitchClick(Sender: TObject);
      procedure CheckBoxzpaqabsoluteClick(Sender: TObject);
      procedure CheckBoxzpaqallClick(Sender: TObject);
      procedure CheckBoxzpaqforceClick(Sender: TObject);
      procedure CheckBoxzpaqfullClick(Sender: TObject);
      procedure CheckBoxZstdClick(Sender: TObject);
      procedure CheckGroupM1ItemClick(Sender: TObject; Index: integer);
      procedure CheckGroupM2ItemClick(Sender: TObject; Index: integer);
      procedure CheckGroupW1ItemClick(Sender: TObject; Index: integer);
      procedure CheckGroupWItemClick(Sender: TObject; Index: integer);
      procedure ColorButton2ColorChanged(Sender: TObject);
      procedure ColorButton3ColorChanged(Sender: TObject);
      procedure ComboBox1Change(Sender: TObject);
      procedure ComboBoxArchive2Change(Sender: TObject);
      procedure ComboBoxArchive3CloseUp(Sender: TObject);
      procedure ComboBoxArchive4CloseUp(Sender: TObject);
      procedure ComboBoxArchive9CloseUp(Sender: TObject);
      procedure ComboBoxBrowserChange(Sender: TObject);
      procedure ComboBoxDragChange(Sender: TObject);
      procedure ComboBoxKiBChange(Sender: TObject);
      procedure ComboBoxLanguageCloseUp(Sender: TObject);
      procedure ComboBoxMaxArgChange(Sender: TObject);
      procedure ComboBoxmemuseChange(Sender: TObject);
      procedure ComboBoxPriorityChange(Sender: TObject);
      procedure ComboBoxSyntaxLevelChange(Sender: TObject);
      procedure ComboBoxTAR1Change(Sender: TObject);
      procedure ComboBoxTARChange(Sender: TObject);
      procedure ComboBoxWDChange(Sender: TObject);
      procedure ComboBoxARC2Change(Sender: TObject);
      procedure ComboBoxArchive7Change(Sender: TObject);
      procedure ComboBoxArchive8Change(Sender: TObject);
      procedure ComboBoxArchiveAct1Change(Sender: TObject);
      procedure ComboBoxArchiveActChange(Sender: TObject);
      procedure ComboBoxLibreChange(Sender: TObject);
      procedure ComboBoxprivacyChange(Sender: TObject);
      procedure ComboBoxSDChange(Sender: TObject);
      procedure comboRARdictChange(Sender: TObject);
      procedure ctrlarcClick(Sender: TObject);
      procedure ctrlextClick(Sender: TObject);
      procedure ctrlhistoryClick(Sender: TObject);
      procedure DateEdit1Change(Sender: TObject);
      procedure DateEdit2Change(Sender: TObject);
      procedure DateEdit3Change(Sender: TObject);
      procedure DateEdit4Change(Sender: TObject);
      procedure Edit5Change(Sender: TObject);
      procedure EditOpenIn1Exit(Sender: TObject);
      procedure EditOpenIn1KeyPress(Sender: TObject; var Key: char);
      procedure EditOpenIn1KeyUp(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure EditOpenInChange(Sender: TObject);
      procedure EditOpenOutChange(Sender: TObject);
      procedure EditUn7zaFilter1KeyPress(Sender: TObject; var Key: char);
      procedure EditUn7zaFilterChange(Sender: TObject);
      procedure eowcustom10Click(Sender: TObject);
      procedure eowcustom11Click(Sender: TObject);
      procedure eowcustom12Click(Sender: TObject);
      procedure eowcustom13Click(Sender: TObject);
      procedure eowcustom14Click(Sender: TObject);
      procedure eowcustom15Click(Sender: TObject);
      procedure eowcustom16Click(Sender: TObject);
      procedure eowcustom1Click(Sender: TObject);
      procedure eowcustom2Click(Sender: TObject);
      procedure eowcustom3Click(Sender: TObject);
      procedure eowcustom4Click(Sender: TObject);
      procedure eowcustom5Click(Sender: TObject);
      procedure eowcustom6Click(Sender: TObject);
      procedure eowcustom7Click(Sender: TObject);
      procedure eowcustom8Click(Sender: TObject);
      procedure eowcustom9Click(Sender: TObject);
      procedure eowcustom_10Click(Sender: TObject);
      procedure eowcustom_11Click(Sender: TObject);
      procedure eowcustom_12Click(Sender: TObject);
      procedure eowcustom_13Click(Sender: TObject);
      procedure eowcustom_14Click(Sender: TObject);
      procedure eowcustom_15Click(Sender: TObject);
      procedure eowcustom_16Click(Sender: TObject);
      procedure eowcustom_9Click(Sender: TObject);
      procedure eowrunClick(Sender: TObject);
      procedure extalllastClick(Sender: TObject);
      procedure fextallfav2Click(Sender: TObject);
      procedure fextallfav3Click(Sender: TObject);
      procedure fextallfav4Click(Sender: TObject);
      procedure fextallfav5Click(Sender: TObject);
      procedure fextallfav6Click(Sender: TObject);
      procedure fextallfav7Click(Sender: TObject);
      procedure fextallfav8Click(Sender: TObject);
      procedure fextallfav1Click(Sender: TObject);
      procedure fextalldefaultClick(Sender: TObject);
      procedure fextalltoClick(Sender: TObject);
      procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
      procedure FormResize(Sender: TObject);
      procedure FormShow(Sender: TObject);
      procedure ImageFlattestmoreClick(Sender: TObject);
      procedure Imagesp1Click(Sender: TObject);
      procedure ImagespClick(Sender: TObject);
      procedure Label7Click(Sender: TObject);
      procedure LabelAddFilesClick(Sender: TObject);
      procedure LabelAddFolderClick(Sender: TObject);
      procedure Labelcb19Click(Sender: TObject);
      procedure LabelColPresetsClick(Sender: TObject);
      procedure LabelConfigurePwClick(Sender: TObject);
      procedure LabelDefaultColor3Click(Sender: TObject);
      procedure LabellightpresetsClick(Sender: TObject);
      procedure LabelErrorsClick(Sender: TObject);
      procedure LabelmoreoptClick(Sender: TObject);
      procedure cbqdupClick(Sender: TObject);
      procedure LabelsetworkClick(Sender: TObject);
      procedure LabelStatusArClick(Sender: TObject);
      procedure LabelStatusArMouseEnter(Sender: TObject);
      procedure LabelStatusClick(Sender: TObject);
      procedure LabelStatusdisplayedClick(Sender: TObject);
      procedure LabelStatusdisplayedMouseEnter(Sender: TObject);
      procedure LabelStatusExClick(Sender: TObject);
      procedure LabelStatusExMouseEnter(Sender: TObject);
      procedure LabelStatusMouseEnter(Sender: TObject);
      procedure LabelThemeClick(Sender: TObject);
      procedure LabelTitleOptions2Click(Sender: TObject);
      procedure LabelTitleOptions2MouseEnter(Sender: TObject);
      procedure LabelTitleOptions2MouseLeave(Sender: TObject);
      procedure lightdimClick(Sender: TObject);
      procedure lightgraphiteClick(Sender: TObject);
      procedure lightmochaClick(Sender: TObject);
      procedure lightplumClick(Sender: TObject);
      procedure lightsenapeClick(Sender: TObject);
      procedure ListView1ContextPopup(Sender: TObject; MousePos: TPoint;
        var Handled: Boolean);
      procedure ListView1MouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure lsetdefaultout_arcClick(Sender: TObject);
      procedure lsetdefaultout_extClick(Sender: TObject);
      procedure mautoadjustClick(Sender: TObject);
      procedure mBenchpeaClick(Sender: TObject);
      procedure mbrowsercaccessedClick(Sender: TObject);
      procedure mbrowserccreatedClick(Sender: TObject);
      procedure mbrowsercmethodClick(Sender: TObject);
      procedure mcaccessedClick(Sender: TObject);
      procedure marcoptClick(Sender: TObject);
      procedure mccreatedClick(Sender: TObject);
      procedure mdefarcsetClick(Sender: TObject);
      procedure mdefextsetClick(Sender: TObject);
      procedure mcmethodClick(Sender: TObject);
      procedure lightlowClick(Sender: TObject);
      procedure mdirbeforefilesClick(Sender: TObject);
      procedure mdownloadthemesClick(Sender: TObject);
      procedure mfunaddClick(Sender: TObject);
      procedure MenuItemShowColMenuClick(Sender: TObject);
      procedure MenuItemToggleNavClick(Sender: TObject);
      procedure mfunextractClick(Sender: TObject);
      procedure mlargeiconsClick(Sender: TObject);
      procedure Panelnav4Click(Sender: TObject);
      procedure Panelnav4MouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure pmbccpClick(Sender: TObject);
      procedure pmbcnwClick(Sender: TObject);
      procedure pmbcpsClick(Sender: TObject);
      procedure pmclipClick(Sender: TObject);
      procedure pmembf1Click(Sender: TObject);
      procedure pmembf2Click(Sender: TObject);
      procedure pmembf3Click(Sender: TObject);
      procedure pmembf4Click(Sender: TObject);
      procedure pmembf5Click(Sender: TObject);
      procedure pmembf6Click(Sender: TObject);
      procedure pmembf7Click(Sender: TObject);
      procedure pmembf8Click(Sender: TObject);
      procedure pmemrf1Click(Sender: TObject);
      procedure pmemrf2Click(Sender: TObject);
      procedure pmemrf3Click(Sender: TObject);
      procedure pmemrf4Click(Sender: TObject);
      procedure pmemrf5Click(Sender: TObject);
      procedure pmemrf6Click(Sender: TObject);
      procedure pmemrf7Click(Sender: TObject);
      procedure pmemrf8Click(Sender: TObject);
      procedure pmmoretestClick(Sender: TObject);
      procedure mdefaultextractClick(Sender: TObject);
      procedure pmshowstylemenuClick(Sender: TObject);
      procedure pmtabscloseallClick(Sender: TObject);
      procedure pmtabsnewwindowClick(Sender: TObject);
      procedure pnbce1Click(Sender: TObject);
      procedure pnbce2Click(Sender: TObject);
      procedure pnbce3Click(Sender: TObject);
      procedure pnbce4Click(Sender: TObject);
      procedure pnbce5Click(Sender: TObject);
      procedure pnbce6Click(Sender: TObject);
      procedure pnbce7Click(Sender: TObject);
      procedure pnbce8Click(Sender: TObject);
      procedure pnbcf1Click(Sender: TObject);
      procedure pnbcf2Click(Sender: TObject);
      procedure pnbcf3Click(Sender: TObject);
      procedure pnbcf4Click(Sender: TObject);
      procedure pnbcf5Click(Sender: TObject);
      procedure pnbcf6Click(Sender: TObject);
      procedure pnbcf7Click(Sender: TObject);
      procedure pnbcf8Click(Sender: TObject);
      procedure pnhe1Click(Sender: TObject);
      procedure pnhe2Click(Sender: TObject);
      procedure pnhe3Click(Sender: TObject);
      procedure pnhe4Click(Sender: TObject);
      procedure pnhe5Click(Sender: TObject);
      procedure pnhe6Click(Sender: TObject);
      procedure pnhe7Click(Sender: TObject);
      procedure pnhe8Click(Sender: TObject);
      procedure pnhf1Click(Sender: TObject);
      procedure pnhf2Click(Sender: TObject);
      procedure pnhf3Click(Sender: TObject);
      procedure pnhf4Click(Sender: TObject);
      procedure pnhf5Click(Sender: TObject);
      procedure pnhf6Click(Sender: TObject);
      procedure pnhf7Click(Sender: TObject);
      procedure pnhf8Click(Sender: TObject);
      procedure po_addsepClick(Sender: TObject);
      procedure MenuItemInfoClick(Sender: TObject);
      procedure MenuItemInfomenuClick(Sender: TObject);
      procedure MenuItemToggleStatusClick(Sender: TObject);
      procedure menupwClick(Sender: TObject);
      procedure msettingsClick(Sender: TObject);
      procedure mshownavbarClick(Sender: TObject);
      procedure mshowstatusbarClick(Sender: TObject);
      procedure mshowtoolbarClick(Sender: TObject);
      procedure pmquickdownloadsClick(Sender: TObject);
      procedure pmsnoClick(Sender: TObject);
      procedure pmsstatusClick(Sender: TObject);
      procedure pmstatusnoneClick(Sender: TObject);
      procedure pmtoollargeClick(Sender: TObject);
      procedure pmtoolmediumClick(Sender: TObject);
      procedure pmtoolnoneClick(Sender: TObject);
      procedure pmtoolsmallClick(Sender: TObject);
      procedure pmshowmainmenuClick(Sender: TObject);
      procedure mverifyselfClick(Sender: TObject);
      procedure pmhnewtabClick(Sender: TObject);
      procedure MenuItemOpen_saveascsvClick(Sender: TObject);
      procedure mfilterbrowserClick(Sender: TObject);
      procedure MenuItemColBeosClick(Sender: TObject);
      procedure MenuItemColMintClick(Sender: TObject);
      procedure MenuItemColUbuntuClick(Sender: TObject);
      procedure MenuItemColWindowsClick(Sender: TObject);
      procedure menuitemopendocumentsClick(Sender: TObject);
      procedure menuitemopendownloadsClick(Sender: TObject);
      procedure mloadlayoutClick(Sender: TObject);
      procedure mprofileimmediateClick(Sender: TObject);
      procedure msamplescriptsClick(Sender: TObject);
      procedure msavelayoutClick(Sender: TObject);
      procedure mTypeClick(Sender: TObject);
      procedure owrunClick(Sender: TObject);
      procedure pmr_filesClick(Sender: TObject);
      procedure pmr_renClick(Sender: TObject);
      procedure pmsaveascsvClick(Sender: TObject);
      procedure pmshowsearchClick(Sender: TObject);
      procedure powRunClick(Sender: TObject);
      procedure po_cinnamonsettClick(Sender: TObject);
      procedure po_clipClick(Sender: TObject);
      procedure po_dedupClick(Sender: TObject);
      procedure po_gnomeccClick(Sender: TObject);
      procedure po_gnomeswClick(Sender: TObject);
      procedure po_kdesyssettClick(Sender: TObject);
      procedure po_lindfhClick(Sender: TObject);
      procedure po_lindushClick(Sender: TObject);
      procedure po_linhistoryClick(Sender: TObject);
      procedure po_linidClick(Sender: TObject);
      procedure po_linipaddressClick(Sender: TObject);
      procedure po_linnetstatClick(Sender: TObject);
      procedure po_linpsefClick(Sender: TObject);
      procedure po_lintopClick(Sender: TObject);
      procedure po_macactClick(Sender: TObject);
      procedure po_macdiskClick(Sender: TObject);
      procedure po_maclaunchClick(Sender: TObject);
      procedure po_macsysClick(Sender: TObject);
      procedure po_openunitasarchivelinClick(Sender: TObject);
      procedure po_dispenvstrlinClick(Sender: TObject);
      procedure MenuItemOpen_runClick(Sender: TObject);
      procedure pmcaccessedClick(Sender: TObject);
      procedure pmccreatedClick(Sender: TObject);
      procedure pmcmethodClick(Sender: TObject);
      procedure po_ftpClick(Sender: TObject);
      procedure po_getmacClick(Sender: TObject);
      procedure mtabClick(Sender: TObject);
      procedure pmqeallClick(Sender: TObject);
      procedure pmqedisplayedClick(Sender: TObject);
      procedure pmqeselectedClick(Sender: TObject);
      procedure pmrowClick(Sender: TObject);
      procedure pmsnavClick(Sender: TObject);
      procedure pmstreeClick(Sender: TObject);
      procedure pmsnoneClick(Sender: TObject);
      procedure mtencClick(Sender: TObject);
      procedure MenuItemExtAllHereNewClick(Sender: TObject);
      procedure MenuItemExtAllHereSmartClick(Sender: TObject);
      procedure MenuItemTextEncodingClick(Sender: TObject);
      procedure mextallherenewClick(Sender: TObject);
      procedure mextallheresmartClick(Sender: TObject);
      procedure mextoptClick(Sender: TObject);
      procedure mForceClearClick(Sender: TObject);
      procedure mForceSynceditsClearClick(Sender: TObject);
      procedure mForceSynceditsClick(Sender: TObject);
      procedure mloadcompsettingsClick(Sender: TObject);
      procedure mprofile7zfastClick(Sender: TObject);
      procedure mprofilealtarcClick(Sender: TObject);
      procedure mprofilebetterzpaqClick(Sender: TObject);
      procedure mprofilebrotliClick(Sender: TObject);
      procedure mprofileextremezpaqClick(Sender: TObject);
      procedure mprofile7zfastestClick(Sender: TObject);
      procedure mprofileloadClick(Sender: TObject);
      procedure mprofilerarClick(Sender: TObject);
      procedure mprofilesaveClick(Sender: TObject);
      procedure mprofilezipbz2Click(Sender: TObject);
      procedure mprofilezstdClick(Sender: TObject);
      procedure msavecompsettingsClick(Sender: TObject);
      procedure mtabsClick(Sender: TObject);
      procedure mtogglesidebarClick(Sender: TObject);
      procedure mtoggletabbarClick(Sender: TObject);
      procedure mtoggletoolbarClick(Sender: TObject);
      procedure PanelClickAddressMouseEnter(Sender: TObject);
      procedure pcustmakecabClick(Sender: TObject);
      procedure pmhtabsClick(Sender: TObject);
      procedure pmmorecommentClick(Sender: TObject);
      procedure pmmorelockClick(Sender: TObject);
      procedure pmmorerecoverClick(Sender: TObject);
      procedure pmmorerrClick(Sender: TObject);
      procedure pmpanalyzefoldersClick(Sender: TObject);
      procedure pmqeherenewClick(Sender: TObject);
      procedure pmqeheresmartClick(Sender: TObject);
      procedure pmrshClick(Sender: TObject);
      procedure pmr_123Click(Sender: TObject);
      procedure pmr_appenddirnameClick(Sender: TObject);
      procedure pmr_appendtsClick(Sender: TObject);
      procedure pmr_asciiClick(Sender: TObject);
      procedure pmr_cutClick(Sender: TObject);
      procedure pmr_prependdirnameClick(Sender: TObject);
      procedure pms2a_extClick(Sender: TObject);
      procedure pmstyle1Click(Sender: TObject);
      procedure pmstyle2Click(Sender: TObject);
      procedure pmstyle3Click(Sender: TObject);
      procedure pmstyle4Click(Sender: TObject);
      procedure pmstyle5Click(Sender: TObject);
      procedure pmstyle6Click(Sender: TObject);
      procedure pmtabClick(Sender: TObject);
      procedure pmtabsbookmarkaddClick(Sender: TObject);
      procedure pmtabsbookmarkorgClick(Sender: TObject);
      procedure pmtabscloseotherClick(Sender: TObject);
      procedure pmtabscloserightClick(Sender: TObject);
      procedure pmtabscollapseClick(Sender: TObject);
      procedure pmtabsexpandClick(Sender: TObject);
      procedure pmtabsmClick(Sender: TObject);
      procedure pmtestcontextallClick(Sender: TObject);
      procedure pmtestcontextdisplayedClick(Sender: TObject);
      procedure pmtestcontextselectedClick(Sender: TObject);
      procedure pmtextencClick(Sender: TObject);
      procedure pmthemesClick(Sender: TObject);
      procedure pmtool1Click(Sender: TObject);
      procedure pmtool2Click(Sender: TObject);
      procedure pmtool3Click(Sender: TObject);
      procedure pob_blake2bClick(Sender: TObject);
      procedure pob_blake2sClick(Sender: TObject);
      procedure po_analyzefoldersClick(Sender: TObject);
      procedure po_commentClick(Sender: TObject);
      procedure po_hostnameClick(Sender: TObject);
      procedure po_ipconfigClick(Sender: TObject);
      procedure po_lockClick(Sender: TObject);
      procedure po_openfilesClick(Sender: TObject);
      procedure po_pdupClick(Sender: TObject);
      procedure po_quserClick(Sender: TObject);
      procedure po_qwinstaClick(Sender: TObject);
      procedure po_recoverClick(Sender: TObject);
      procedure po_rename_123Click(Sender: TObject);
      procedure po_rename_asciiClick(Sender: TObject);
      procedure po_rename_cutlenClick(Sender: TObject);
      procedure po_rename_filesonlyClick(Sender: TObject);
      procedure po_rrClick(Sender: TObject);
      procedure po_setappstClick(Sender: TObject);
      procedure po_showquicknavmenuClick(Sender: TObject);
      procedure po_smartClick(Sender: TObject);
      procedure po_synapticClick(Sender: TObject);
      procedure po_systeminfoClick(Sender: TObject);
      procedure po_tabsopenClick(Sender: TObject);
      procedure po_verClick(Sender: TObject);
      procedure po_whoamiClick(Sender: TObject);
      procedure po_windowopenClick(Sender: TObject);
      procedure po_xfcesmClick(Sender: TObject);
      procedure RadioGroup3Change(Sender: TObject);
      procedure seRARrrChange(Sender: TObject);
      procedure ShellTreeView1MouseEnter(Sender: TObject);
      procedure SpinEditArchive1Change(Sender: TObject);
      procedure splitsearchMoved(Sender: TObject);
      procedure StringGridSessionHistoryDblClick(Sender: TObject);
      procedure TabBarContextPopup(Sender: TObject; MousePos: TPoint;
        var Handled: Boolean);
      procedure TabBarMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure TabBarMouseEnter(Sender: TObject);
      procedure TabBarSectionClick(HeaderControl: TCustomHeaderControl;
        Section: THeaderSection);
      procedure TabBarSectionEndDrag(Sender: TObject);
      procedure iadvextractClick(Sender: TObject);
      procedure ImageAdArchive0Click(Sender: TObject);
      procedure ImageAdArchive0MouseEnter(Sender: TObject);
      procedure ImageAdArchive0MouseLeave(Sender: TObject);
      procedure ImageAdArchive1Click(Sender: TObject);
      procedure ImageAdArchive1MouseEnter(Sender: TObject);
      procedure ImageAdArchive1MouseLeave(Sender: TObject);
      procedure ImageAdArchive2Click(Sender: TObject);
      procedure ImageAdArchive2MouseEnter(Sender: TObject);
      procedure ImageAdArchive2MouseLeave(Sender: TObject);
      procedure ImageAdArchive3Click(Sender: TObject);
      procedure ImageAdArchive3MouseEnter(Sender: TObject);
      procedure ImageAdArchive3MouseLeave(Sender: TObject);
      procedure ImageAddress0Click(Sender: TObject);
      procedure ImageAddress0MouseEnter(Sender: TObject);
      procedure ImageAddress0MouseLeave(Sender: TObject);
      procedure ImageAddress1Click(Sender: TObject);
      procedure ImageAddress1MouseEnter(Sender: TObject);
      procedure ImageAddress1MouseLeave(Sender: TObject);
      procedure ImageAddress2Click(Sender: TObject);
      procedure ImageAddress2MouseEnter(Sender: TObject);
      procedure ImageAddress2MouseLeave(Sender: TObject);
      procedure ImageAddress3Click(Sender: TObject);
      procedure ImageAddress3MouseEnter(Sender: TObject);
      procedure ImageAddress3MouseLeave(Sender: TObject);
      procedure ImageAddress4Click(Sender: TObject);
      procedure ImageAddress4MouseEnter(Sender: TObject);
      procedure ImageAddress4MouseLeave(Sender: TObject);
      procedure ImageAddress5Click(Sender: TObject);
      procedure ImageAddress5MouseEnter(Sender: TObject);
      procedure ImageAddress5MouseLeave(Sender: TObject);
      procedure ImageAddress6Click(Sender: TObject);
      procedure ImageAddress6MouseEnter(Sender: TObject);
      procedure ImageAddress6MouseLeave(Sender: TObject);
      procedure ImageAddress7Click(Sender: TObject);
      procedure ImageAddress7MouseEnter(Sender: TObject);
      procedure ImageAddress7MouseLeave(Sender: TObject);
      procedure ImageAddressClick(Sender: TObject);
      procedure ImageFlatClick(Sender: TObject);
      procedure ImageInfoArchive3Click(Sender: TObject);
      procedure ImageInfoArchive4Click(Sender: TObject);
      procedure ImageInfoArchive5Click(Sender: TObject);
      procedure ImageInfoArchive6Click(Sender: TObject);
      procedure ImageInfoDefault1Click(Sender: TObject);
      procedure ImageInfoDefault2Click(Sender: TObject);
      procedure ImageListRootMouseEnter(Sender: TObject);
      procedure ImageListRootMouseLeave(Sender: TObject);
      procedure ImageListSearch1Click(Sender: TObject);
      procedure ImageListSearch1MouseEnter(Sender: TObject);
      procedure ImageListSearch1MouseLeave(Sender: TObject);
      procedure ImageListSearchDblClick(Sender: TObject);
      procedure ImageListSearchMouseEnter(Sender: TObject);
      procedure ImageListSearchMouseLeave(Sender: TObject);
      procedure Imageopenadvf1Click(Sender: TObject);
      procedure Imageopenadvf2Click(Sender: TObject);
      procedure ImageopenadvfClick(Sender: TObject);
      procedure ImagePassword1Click(Sender: TObject);
      procedure Button1Click(Sender: TObject);
      procedure ButtonArchiveClick(Sender: TObject);
      procedure ButtonEditNameCustomClick(Sender: TObject);
      procedure ButtonUn7za1Click(Sender: TObject);
      procedure ButtonUn7za4Click(Sender: TObject);
      procedure ButtonUn7zaToClick(Sender: TObject);
      procedure cbTypeChange(Sender: TObject);
      procedure ComboBox7zalgoChange(Sender: TObject);
      procedure ComboBoxArchiveCustom1Change(Sender: TObject);
      procedure ComboBoxArchiveCustomChange(Sender: TObject);
      procedure ComboBoxOverwriteARCChange(Sender: TObject);
      procedure ComboBoxOverwriteChange(Sender: TObject);
      procedure ComboBoxPassesChange(Sender: TObject);
      procedure ImagePassword2Click(Sender: TObject);
      procedure LabelAbout2Click(Sender: TObject);
      procedure LabelAppPathClick(Sender: TObject);
      procedure Labelcb17Click(Sender: TObject);
      procedure Labelcb7Click(Sender: TObject);
      procedure LabelClickAdArchive1Click(Sender: TObject);
      procedure LabelClickAdArchive1MouseEnter(Sender: TObject);
      procedure LabelClickAdArchive1MouseLeave(Sender: TObject);
      procedure LabelClickAdArchive2Click(Sender: TObject);
      procedure LabelClickAdArchive2MouseEnter(Sender: TObject);
      procedure LabelClickAdArchive2MouseLeave(Sender: TObject);
      procedure LabelClickAdArchive3Click(Sender: TObject);
      procedure LabelClickAdArchive3MouseEnter(Sender: TObject);
      procedure LabelClickAdArchive3MouseLeave(Sender: TObject);
      procedure LabelClickAdArchive4Click(Sender: TObject);
      procedure LabelClickAdArchive4MouseEnter(Sender: TObject);
      procedure LabelClickAdArchive4MouseLeave(Sender: TObject);
      procedure LabelClickAddress1Click(Sender: TObject);
      procedure LabelClickAddress1MouseEnter(Sender: TObject);
      procedure LabelClickAddress1MouseLeave(Sender: TObject);
      procedure LabelClickAddress2Click(Sender: TObject);
      procedure LabelClickAddress2MouseEnter(Sender: TObject);
      procedure LabelClickAddress2MouseLeave(Sender: TObject);
      procedure LabelClickAddress3Click(Sender: TObject);
      procedure LabelClickAddress3MouseEnter(Sender: TObject);
      procedure LabelClickAddress3MouseLeave(Sender: TObject);
      procedure LabelClickAddress4Click(Sender: TObject);
      procedure LabelClickAddress4MouseEnter(Sender: TObject);
      procedure LabelClickAddress4MouseLeave(Sender: TObject);
      procedure LabelClickAddress5Click(Sender: TObject);
      procedure LabelClickAddress5MouseEnter(Sender: TObject);
      procedure LabelClickAddress5MouseLeave(Sender: TObject);
      procedure LabelClickAddress6Click(Sender: TObject);
      procedure LabelClickAddress6MouseEnter(Sender: TObject);
      procedure LabelClickAddress6MouseLeave(Sender: TObject);
      procedure LabelClickAddress7Click(Sender: TObject);
      procedure LabelClickAddress7MouseEnter(Sender: TObject);
      procedure LabelClickAddress7MouseLeave(Sender: TObject);
      procedure LabelClickAddress8Click(Sender: TObject);
      procedure LabelClickAddress8MouseEnter(Sender: TObject);
      procedure LabelClickAddress8MouseLeave(Sender: TObject);
      procedure LabelConf1Click(Sender: TObject);
      procedure LabelConfigurePeaZipClick(Sender: TObject);
      procedure LabelConfigureSendToClick(Sender: TObject);
      procedure LabelDonationsClick(Sender: TObject);
      procedure LabelLang2Click(Sender: TObject);
      procedure LabelLang4Click(Sender: TObject);
      procedure LabelPanelHintAddMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure LabelPanelHintExtractMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure LabelResetAppClick(Sender: TObject);
      procedure LabelResetBookmarksClick(Sender: TObject);
      procedure LabelResetHistoryClick(Sender: TObject);
      procedure LabelResetPMClick(Sender: TObject);
      procedure LabelResetPtmpClick(Sender: TObject);
      procedure LabelStatus5Click(Sender: TObject);
      procedure LabelTitleAdd1Click(Sender: TObject);
      procedure LabelTitleAdd1MouseEnter(Sender: TObject);
      procedure LabelTitleAdd1MouseLeave(Sender: TObject);
      procedure LabelTitleAdd2Click(Sender: TObject);
      procedure LabelTitleAdd2MouseEnter(Sender: TObject);
      procedure LabelTitleAdd2MouseLeave(Sender: TObject);
      procedure LabelTitleAdd3Click(Sender: TObject);
      procedure LabelTitleAdd3MouseEnter(Sender: TObject);
      procedure LabelTitleAdd3MouseLeave(Sender: TObject);
      procedure LabelTitleAdd4Click(Sender: TObject);
      procedure LabelTitleAdd4MouseEnter(Sender: TObject);
      procedure LabelTitleAdd4MouseLeave(Sender: TObject);
      procedure LabelTitleApps1Click(Sender: TObject);
      procedure LabelTitleApps1MouseEnter(Sender: TObject);
      procedure LabelTitleApps1MouseLeave(Sender: TObject);
      procedure LabelTitleApps2Click(Sender: TObject);
      procedure LabelTitleApps2MouseEnter(Sender: TObject);
      procedure LabelTitleApps2MouseLeave(Sender: TObject);
      procedure LabelTitleExtract1Click(Sender: TObject);
      procedure LabelTitleExtract1MouseEnter(Sender: TObject);
      procedure LabelTitleExtract1MouseLeave(Sender: TObject);
      procedure LabelTitleExtract2Click(Sender: TObject);
      procedure LabelTitleExtract2MouseEnter(Sender: TObject);
      procedure LabelTitleExtract2MouseLeave(Sender: TObject);
      procedure LabelTitleExtract3Click(Sender: TObject);
      procedure LabelTitleExtract3MouseEnter(Sender: TObject);
      procedure LabelTitleExtract3MouseLeave(Sender: TObject);
      procedure LabelTitleExtract4Click(Sender: TObject);
      procedure LabelTitleExtract4MouseEnter(Sender: TObject);
      procedure LabelTitleExtract4MouseLeave(Sender: TObject);
      procedure LabelTitleOptions1Click(Sender: TObject);
      procedure LabelTitleOptions1MouseEnter(Sender: TObject);
      procedure LabelTitleOptions1MouseLeave(Sender: TObject);
      procedure LabelTitleOptions3Click(Sender: TObject);
      procedure LabelTitleOptions3MouseEnter(Sender: TObject);
      procedure LabelTitleOptions3MouseLeave(Sender: TObject);
      procedure LabelTitleOptions4Click(Sender: TObject);
      procedure LabelTitleOptions4MouseEnter(Sender: TObject);
      procedure LabelTitleOptions4MouseLeave(Sender: TObject);
      procedure LabelTitleOptions5Click(Sender: TObject);
      procedure LabelTitleOptions5MouseEnter(Sender: TObject);
      procedure LabelTitleOptions5MouseLeave(Sender: TObject);
      procedure LabelTitleOptions6Click(Sender: TObject);
      procedure LabelTitleOptions6MouseEnter(Sender: TObject);
      procedure LabelTitleOptions6MouseLeave(Sender: TObject);
      procedure LabelTitleOptions7Click(Sender: TObject);
      procedure LabelTitleOptions7MouseEnter(Sender: TObject);
      procedure LabelTitleOptions7MouseLeave(Sender: TObject);
      procedure LabelTitleOptions8Click(Sender: TObject);
      procedure LabelTitleOptions8MouseEnter(Sender: TObject);
      procedure LabelTitleOptions8MouseLeave(Sender: TObject);
      procedure LabelUpdatesClick(Sender: TObject);
      procedure ListView1Click(Sender: TObject);
      procedure ListView1ColumnClick(Sender: TObject; Column: TListColumn);
      procedure ListView1DblClick(Sender: TObject);
      procedure ListView1DragOver(Sender, Source: TObject; X, Y: Integer;
        State: TDragState; var Accept: Boolean);
      procedure ListView1KeyDown(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure ListView1KeyPress(Sender: TObject; var Key: char);
      procedure ListView1KeyUp(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure ListView1MouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ListView1MouseEnter(Sender: TObject);
      procedure ListView1MouseLeave(Sender: TObject);
      procedure ListView1MouseMove(Sender: TObject; Shift: TShiftState; X,
        Y: Integer);
      procedure ListView1SelectItem(Sender: TObject; Item: TListItem;
        Selected: Boolean);
      procedure ListView1StartDrag(Sender: TObject; var DragObject: TDragObject
        );
      procedure Lmanageschedule1Click(Sender: TObject);
      procedure Lmanageschedule2Click(Sender: TObject);
      procedure mAboutClick(Sender: TObject);
      procedure pmtabsnewClick(Sender: TObject);
      procedure pmtabscloseClick(Sender: TObject);
      procedure MenuItemOpen_saveastxtClick(Sender: TObject);
      procedure mextractClick(Sender: TObject);
      procedure maddconvertClick(Sender: TObject);
      procedure maddexistingClick(Sender: TObject);
      procedure mf4Click(Sender: TObject);
      procedure mlayoutsClick(Sender: TObject);
      procedure morgbookmarksClick(Sender: TObject);
      procedure morghistoryClick(Sender: TObject);
      procedure morgsessionhistoryClick(Sender: TObject);
      procedure mPeaFBClick(Sender: TObject);
      procedure mPeaTWClick(Sender: TObject);
      procedure msamehourClick(Sender: TObject);
      procedure mCharCaseClick(Sender: TObject);
      procedure mCharClick(Sender: TObject);
      procedure mDateDayClick(Sender: TObject);
      procedure mDateHourClick(Sender: TObject);
      procedure mDateWeekClick(Sender: TObject);
      procedure mDateYearClick(Sender: TObject);
      procedure mpacked100kClick(Sender: TObject);
      procedure mpacked100mClick(Sender: TObject);
      procedure mpacked10mClick(Sender: TObject);
      procedure mpackedemptyClick(Sender: TObject);
      procedure mpackedoverClick(Sender: TObject);
      procedure mpackedsimilar50Click(Sender: TObject);
      procedure mpackedsimilarClick(Sender: TObject);
      procedure mpluginsClick(Sender: TObject);
      procedure mAdminClick(Sender: TObject);
      procedure madvfiltersClick(Sender: TObject);
      procedure mb0Click(Sender: TObject);
      procedure mb10Click(Sender: TObject);
      procedure mb11Click(Sender: TObject);
      procedure mb12Click(Sender: TObject);
      procedure mb13Click(Sender: TObject);
      procedure mb14Click(Sender: TObject);
      procedure mb15Click(Sender: TObject);
      procedure mb16Click(Sender: TObject);
      procedure mb17Click(Sender: TObject);
      procedure mb18Click(Sender: TObject);
      procedure mb19Click(Sender: TObject);
      procedure mb1Click(Sender: TObject);
      procedure mb20Click(Sender: TObject);
      procedure mb21Click(Sender: TObject);
      procedure mb22Click(Sender: TObject);
      procedure mb23Click(Sender: TObject);
      procedure mb24Click(Sender: TObject);
      procedure mb2Click(Sender: TObject);
      procedure mb3Click(Sender: TObject);
      procedure mb4Click(Sender: TObject);
      procedure mb5Click(Sender: TObject);
      procedure mb6Click(Sender: TObject);
      procedure mb7Click(Sender: TObject);
      procedure mb8Click(Sender: TObject);
      procedure mb9Click(Sender: TObject);
      procedure mbackaliasClick(Sender: TObject);
      procedure mbackClick(Sender: TObject);
      procedure mbAddArchiveClick(Sender: TObject);
      procedure mbAddPathClick(Sender: TObject);
      procedure mbc1Click(Sender: TObject);
      procedure mbc2Click(Sender: TObject);
      procedure mbc3Click(Sender: TObject);
      procedure mbc4Click(Sender: TObject);
      procedure mbc5Click(Sender: TObject);
      procedure mbc6Click(Sender: TObject);
      procedure mbc7Click(Sender: TObject);
      procedure mbc8Click(Sender: TObject);
      procedure mbclClick(Sender: TObject);
      procedure mbDeleteClick(Sender: TObject);
      procedure mbexploreClick(Sender: TObject);
      procedure mbNotesClick(Sender: TObject);
      procedure mbpeaClick(Sender: TObject);
      procedure mbresetClick(Sender: TObject);
      procedure mbrowsercattClick(Sender: TObject);
      procedure mbrowserccrcClick(Sender: TObject);
      procedure mbrowsercdateClick(Sender: TObject);
      procedure mbrowsercnameClick(Sender: TObject);
      procedure mbrowsercpackedClick(Sender: TObject);
      procedure mbrowsercsizeClick(Sender: TObject);
      procedure mbrowserctypeClick(Sender: TObject);
      procedure mbrowsersizelClick(Sender: TObject);
      procedure mbrowsersizemClick(Sender: TObject);
      procedure mbrowsersizesClick(Sender: TObject);
      procedure mcancelClick(Sender: TObject);
      procedure mcattClick(Sender: TObject);
      procedure mccrcClick(Sender: TObject);
      procedure mcdateClick(Sender: TObject);
      procedure mcfreeClick(Sender: TObject);
      procedure mcfsClick(Sender: TObject);
      procedure mcpackedClick(Sender: TObject);
      procedure mcpClick(Sender: TObject);
      procedure mcsizeClick(Sender: TObject);
      procedure mctrlf3Click(Sender: TObject);
      procedure mctrlf8Click(Sender: TObject);
      procedure mdefaultarchiveClick(Sender: TObject);
      procedure mdetailsClick(Sender: TObject);
      procedure mctypeClick(Sender: TObject);
      procedure mPeaFAQClick(Sender: TObject);
      procedure mPeaSiteMirrorClick(Sender: TObject);
      procedure MenuItemArchive_dropboxClick(Sender: TObject);
      procedure MenuItemArchive_googledriveClick(Sender: TObject);
      procedure MenuItemArchive_musicClick(Sender: TObject);
      procedure MenuItemArchive_myboxfilesClick(Sender: TObject);
      procedure MenuItemArchive_picturesClick(Sender: TObject);
      procedure MenuItemArchive_onedriveClick(Sender: TObject);
      procedure MenuItemArchive_skydriveClick(Sender: TObject);
      procedure MenuItemArchive_ubuntuoneClick(Sender: TObject);
      procedure MenuItemArchive_videosClick(Sender: TObject);
      procedure MenuItemEnumerateClick(Sender: TObject);
      procedure menuitemopenhomeClick(Sender: TObject);
      procedure MenuItemOpen_dropboxClick(Sender: TObject);
      procedure MenuItemOpen_googledriveClick(Sender: TObject);
      procedure MenuItemOpen_musicClick(Sender: TObject);
      procedure MenuItemOpen_myboxfilesClick(Sender: TObject);
      procedure MenuItemOpen_organizebookmarksClick(Sender: TObject);
      procedure MenuItemOpen_picturesClick(Sender: TObject);
      procedure MenuItemOpen_powershellClick(Sender: TObject);
      procedure MenuItemOpen_onedriveClick(Sender: TObject);
      procedure MenuItemOpen_skydriveClick(Sender: TObject);
      procedure MenuItemOpen_ubuntuoneClick(Sender: TObject);
      procedure MenuItemOpen_videosClick(Sender: TObject);
      procedure MenuItemPowerShellClick(Sender: TObject);
      procedure mfwdClick(Sender: TObject);
      procedure mPeaSupportClick(Sender: TObject);
      procedure mpeautilsClick(Sender: TObject);
      procedure mprelistClick(Sender: TObject);
      procedure mprofileautoClick(Sender: TObject);
      procedure mprofileencrypt7zClick(Sender: TObject);
      procedure mprofilefastzipClick(Sender: TObject);
      procedure mprofilenormal7zClick(Sender: TObject);
      procedure mprofilenormalzipClick(Sender: TObject);
      procedure mprofilesplitzipClick(Sender: TObject);
      procedure mprofileultra7zClick(Sender: TObject);
      procedure mRecent1fClick(Sender: TObject);
      procedure mRecent2fClick(Sender: TObject);
      procedure mRecent3fClick(Sender: TObject);
      procedure mRecent4fClick(Sender: TObject);
      procedure mRecent5fClick(Sender: TObject);
      procedure mRecent6fClick(Sender: TObject);
      procedure mRecent7fClick(Sender: TObject);
      procedure mRecent8fClick(Sender: TObject);
      procedure msamedayClick(Sender: TObject);
      procedure msamemonthClick(Sender: TObject);
      procedure msameweekClick(Sender: TObject);
      procedure msameyearClick(Sender: TObject);
      procedure mscheduledscriptsClick(Sender: TObject);
      procedure mselectadvClick(Sender: TObject);
      procedure msize0Click(Sender: TObject);
      procedure msize100kClick(Sender: TObject);
      procedure msize100mClick(Sender: TObject);
      procedure msize10mClick(Sender: TObject);
      procedure msizeoverClick(Sender: TObject);
      procedure msizesimilar50Click(Sender: TObject);
      procedure msizesimilarClick(Sender: TObject);
      procedure mtaskschedulerClick(Sender: TObject);
      procedure mtoggletbribClick(Sender: TObject);
      procedure mtstyle_frameClick(Sender: TObject);
      procedure mtstyle_noneClick(Sender: TObject);
      procedure mtstyle_shadowClick(Sender: TObject);
      procedure munpeaextractClick(Sender: TObject);
      procedure mwebsClick(Sender: TObject);
      procedure mDateMonthClick(Sender: TObject);
      procedure PanelHintAddMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure PanelHintExtractMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure Panelnav5Click(Sender: TObject);
      procedure pmamr1Click(Sender: TObject);
      procedure pmamr2Click(Sender: TObject);
      procedure pmamr3Click(Sender: TObject);
      procedure pmamr4Click(Sender: TObject);
      procedure pmamr5Click(Sender: TObject);
      procedure pmamr6Click(Sender: TObject);
      procedure pmamr7Click(Sender: TObject);
      procedure pmamr8Click(Sender: TObject);
      procedure pmabc0Click(Sender: TObject);
      procedure pmbcaddbookmarkClick(Sender: TObject);
      procedure pmbcd0Click(Sender: TObject);
      procedure pmbcd10Click(Sender: TObject);
      procedure pmbcd11Click(Sender: TObject);
      procedure pmbcd12Click(Sender: TObject);
      procedure pmbcd13Click(Sender: TObject);
      procedure pmbcd14Click(Sender: TObject);
      procedure pmbcd15Click(Sender: TObject);
      procedure pmbcd16Click(Sender: TObject);
      procedure pmbcd17Click(Sender: TObject);
      procedure pmbcd18Click(Sender: TObject);
      procedure pmbcd19Click(Sender: TObject);
      procedure pmbcd1Click(Sender: TObject);
      procedure pmbcd2Click(Sender: TObject);
      procedure pmbcd3Click(Sender: TObject);
      procedure pmbcd4Click(Sender: TObject);
      procedure pmbcd5Click(Sender: TObject);
      procedure pmbcd6Click(Sender: TObject);
      procedure pmbcd7Click(Sender: TObject);
      procedure pmbcd8Click(Sender: TObject);
      procedure pmbcd9Click(Sender: TObject);
      procedure pmbcexpandClick(Sender: TObject);
      procedure pmbcexploreClick(Sender: TObject);
      procedure pmbcorganizebookmarksClick(Sender: TObject);
      procedure pmbcpropertiesClick(Sender: TObject);
      procedure pmbcwebClick(Sender: TObject);
      procedure pmCopyPathClick(Sender: TObject);
      procedure pmcpypathClick(Sender: TObject);
      procedure pmCustEditAdd1Click(Sender: TObject);
      procedure pmCustEditAddClick(Sender: TObject);
      procedure pmCustEditDesc1Click(Sender: TObject);
      procedure pmCustEditDescClick(Sender: TObject);
      procedure pmCustEditEdit1afterClick(Sender: TObject);
      procedure pmCustEditEdit1Click(Sender: TObject);
      procedure pmCustEditEditClick(Sender: TObject);
      procedure pmCustEditRemove1Click(Sender: TObject);
      procedure pmCustEditRemoveClick(Sender: TObject);
      procedure pmcutClick(Sender: TObject);
      procedure pmemb1Click(Sender: TObject);
      procedure pmemb2Click(Sender: TObject);
      procedure pmemb3Click(Sender: TObject);
      procedure pmemb4Click(Sender: TObject);
      procedure pmemb5Click(Sender: TObject);
      procedure pmemb6Click(Sender: TObject);
      procedure pmemb7Click(Sender: TObject);
      procedure pmemb8Click(Sender: TObject);
      procedure pmemr1Click(Sender: TObject);
      procedure pmemr2Click(Sender: TObject);
      procedure pmemr3Click(Sender: TObject);
      procedure pmemr4Click(Sender: TObject);
      procedure pmemr5Click(Sender: TObject);
      procedure pmemr6Click(Sender: TObject);
      procedure pmemr7Click(Sender: TObject);
      procedure pmemr8Click(Sender: TObject);
      procedure pmflatClick(Sender: TObject);
      procedure pmfun10Click(Sender: TObject);
      procedure pmfun11Click(Sender: TObject);
      procedure pmfun12Click(Sender: TObject);
      procedure pmfun13Click(Sender: TObject);
      procedure pmfun14Click(Sender: TObject);
      procedure pmfun15Click(Sender: TObject);
      procedure pmfun16Click(Sender: TObject);
      procedure pmfun17Click(Sender: TObject);
      procedure pmfun18Click(Sender: TObject);
      procedure pmfun1Click(Sender: TObject);
      procedure pmfun2Click(Sender: TObject);
      procedure pmfun3Click(Sender: TObject);
      procedure pmfun4Click(Sender: TObject);
      procedure pmfun5Click(Sender: TObject);
      procedure pmfun6Click(Sender: TObject);
      procedure pmfun7Click(Sender: TObject);
      procedure pmfun8Click(Sender: TObject);
      procedure pmfun9Click(Sender: TObject);
      procedure pmhr1fClick(Sender: TObject);
      procedure pmhr2fClick(Sender: TObject);
      procedure pmhr3fClick(Sender: TObject);
      procedure pmhr4fClick(Sender: TObject);
      procedure pmhr5fClick(Sender: TObject);
      procedure pmhr6fClick(Sender: TObject);
      procedure pmhr7fClick(Sender: TObject);
      procedure pmhr8fClick(Sender: TObject);
      procedure pmif1Click(Sender: TObject);
      procedure pmif2Click(Sender: TObject);
      procedure pmif3Click(Sender: TObject);
      procedure pmif4Click(Sender: TObject);
      procedure pmif5Click(Sender: TObject);
      procedure pmif6Click(Sender: TObject);
      procedure pmif7Click(Sender: TObject);
      procedure pmif8Click(Sender: TObject);
      procedure pmir180Click(Sender: TObject);
      procedure pmiresize125Click(Sender: TObject);
      procedure pmiresize150Click(Sender: TObject);
      procedure pmiresize200Click(Sender: TObject);
      procedure pmiresize25Click(Sender: TObject);
      procedure pmiresize300Click(Sender: TObject);
      procedure pmiresize33Click(Sender: TObject);
      procedure pmiresize400Click(Sender: TObject);
      procedure pmiresize50Click(Sender: TObject);
      procedure pmiresize75Click(Sender: TObject);
      procedure pmirflipClick(Sender: TObject);
      procedure mpreaverageClick(Sender: TObject);
      procedure mpredetailsClick(Sender: TObject);
      procedure mprelargeClick(Sender: TObject);
      procedure mprelightClick(Sender: TObject);
      procedure mprelightlistClick(Sender: TObject);
      procedure mpretoggleClick(Sender: TObject);
      procedure pmpdupClick(Sender: TObject);
      procedure pmirmirrorClick(Sender: TObject);
      procedure pmisBMPClick(Sender: TObject);
      procedure pmisJPEG50Click(Sender: TObject);
      procedure pmisJPEG75Click(Sender: TObject);
      procedure pmisJPEGClick(Sender: TObject);
      procedure pmisPNGClick(Sender: TObject);
      procedure pmisTIFFClick(Sender: TObject);
      procedure pmjd10Click(Sender: TObject);
      procedure pmjd11Click(Sender: TObject);
      procedure pmjd12Click(Sender: TObject);
      procedure pmjd13Click(Sender: TObject);
      procedure pmjd14Click(Sender: TObject);
      procedure pmjd15Click(Sender: TObject);
      procedure pmjd16Click(Sender: TObject);
      procedure pmjd17Click(Sender: TObject);
      procedure pmjd18Click(Sender: TObject);
      procedure pmjd19Click(Sender: TObject);
      procedure pmjd1Click(Sender: TObject);
      procedure pmjd20Click(Sender: TObject);
      procedure pmjd21Click(Sender: TObject);
      procedure pmjd22Click(Sender: TObject);
      procedure pmjd23Click(Sender: TObject);
      procedure pmjd24Click(Sender: TObject);
      procedure pmjd25Click(Sender: TObject);
      procedure pmjd26Click(Sender: TObject);
      procedure pmjd2Click(Sender: TObject);
      procedure pmjd3Click(Sender: TObject);
      procedure pmjd4Click(Sender: TObject);
      procedure pmjd5Click(Sender: TObject);
      procedure pmjd6Click(Sender: TObject);
      procedure pmjd7Click(Sender: TObject);
      procedure pmjd8Click(Sender: TObject);
      procedure pmjd9Click(Sender: TObject);
      procedure pmjumpmusicClick(Sender: TObject);
      procedure pmjumppicturesClick(Sender: TObject);
      procedure pmjumpusersClick(Sender: TObject);
      procedure pmjumpvideosClick(Sender: TObject);
      procedure pmmore1Click(Sender: TObject);
      procedure pmmore2Click(Sender: TObject);
      procedure pmmore3Click(Sender: TObject);
      procedure pmmore4Click(Sender: TObject);
      procedure pmmore5Click(Sender: TObject);
      procedure pmmore6Click(Sender: TObject);
      procedure pmmore7Click(Sender: TObject);
      procedure pmmore8Click(Sender: TObject);
      procedure pmmoreanalysisClick(Sender: TObject);
      procedure pmmorefun_detailsClick(Sender: TObject);
      procedure pmmorefun_propertiesClick(Sender: TObject);
      procedure pmmorecheckClick(Sender: TObject);
      procedure pmmorehexClick(Sender: TObject);
      procedure pmmorepreviewClick(Sender: TObject);
      procedure pmmstatus_bookmarksClick(Sender: TObject);
      procedure pmmstatus_clipboardClick(Sender: TObject);
      procedure pmmstatus_raClick(Sender: TObject);
      procedure pmmstatus_rClick(Sender: TObject);
      procedure pmmstatus_statusClick(Sender: TObject);
      procedure pmorganizebookmarksClick(Sender: TObject);
      procedure pmpowershellClick(Sender: TObject);
      procedure pmqjdropboxClick(Sender: TObject);
      procedure pmqjgoogledriveClick(Sender: TObject);
      procedure pmqjmyboxfilesClick(Sender: TObject);
      procedure pmqjonedriveClick(Sender: TObject);
      procedure pmqjskydriveClick(Sender: TObject);
      procedure pmqjubuntuoneClick(Sender: TObject);
      procedure pmqnointdirClick(Sender: TObject);
      procedure pmquickdeskClick(Sender: TObject);
      procedure pmquickhomeClick(Sender: TObject);
      procedure pmquickoaClick(Sender: TObject);
      procedure pmquickopClick(Sender: TObject);
      procedure pmquicksdClick(Sender: TObject);
      procedure pmrecycleClick(Sender: TObject);
      procedure pmrenameClick(Sender: TObject);
      procedure pmrsearchClick(Sender: TObject);
      procedure pmrselectClick(Sender: TObject);
      procedure pmr_addClick(Sender: TObject);
      procedure pmr_deleteClick(Sender: TObject);
      procedure pmr_extClick(Sender: TObject);
      procedure pmr_lowercaseClick(Sender: TObject);
      procedure pmr_replacecaseClick(Sender: TObject);
      procedure pmr_replaceClick(Sender: TObject);
      procedure pmr_uppercaseClick(Sender: TObject);
      procedure pmsearchdragClick(Sender: TObject);
      procedure pmsearchwebClick(Sender: TObject);
      procedure pmsecuredeletefreeClick(Sender: TObject);
      procedure pmselectadvClick(Sender: TObject);
      procedure pmtypeswapClick(Sender: TObject);
      procedure pmwsClick(Sender: TObject);
      procedure MenuItemopendesktopClick(Sender: TObject);
      procedure MenuItemOrganizeNavbarClick(Sender: TObject);
      procedure MenuItemOrganizeStatusbarClick(Sender: TObject);
      procedure MenuItemOrganizeToolbarClick(Sender: TObject);
      procedure MenuItemPropertiesClick(Sender: TObject);
      procedure mfullscreenClick(Sender: TObject);
      procedure mimmersiveClick(Sender: TObject);
      procedure mjob2Click(Sender: TObject);
      procedure mJobClick(Sender: TObject);
      procedure mobClick(Sender: TObject);
      procedure moblClick(Sender: TObject);
      procedure mobrClick(Sender: TObject);
      procedure modefaultClick(Sender: TObject);
      procedure molClick(Sender: TObject);
      procedure morClick(Sender: TObject);
      procedure motClick(Sender: TObject);
      procedure motlClick(Sender: TObject);
      procedure motrClick(Sender: TObject);
      procedure mpmClick(Sender: TObject);
      procedure mPropertiesClick(Sender: TObject);
      procedure mpw2Click(Sender: TObject);
      procedure mrecsearchClick(Sender: TObject);
      procedure mscriptsClick(Sender: TObject);
      procedure msimplesearchClick(Sender: TObject);
      procedure mupdateClick(Sender: TObject);
      procedure owcustom10tClick(Sender: TObject);
      procedure owcustom11tClick(Sender: TObject);
      procedure owcustom12tClick(Sender: TObject);
      procedure owcustom13tClick(Sender: TObject);
      procedure owcustom14tClick(Sender: TObject);
      procedure owcustom15tClick(Sender: TObject);
      procedure owcustom16tClick(Sender: TObject);
      procedure owcustom1tClick(Sender: TObject);
      procedure owcustom2tClick(Sender: TObject);
      procedure owcustom3tClick(Sender: TObject);
      procedure owcustom4tClick(Sender: TObject);
      procedure owcustom5tClick(Sender: TObject);
      procedure owcustom6tClick(Sender: TObject);
      procedure owcustom7tClick(Sender: TObject);
      procedure owcustom8tClick(Sender: TObject);
      procedure owcustom9tClick(Sender: TObject);
      procedure owcustom_10Click(Sender: TObject);
      procedure owcustom_10tClick(Sender: TObject);
      procedure owcustom_11Click(Sender: TObject);
      procedure owcustom_11tClick(Sender: TObject);
      procedure owcustom_12Click(Sender: TObject);
      procedure owcustom_12tClick(Sender: TObject);
      procedure owcustom_13Click(Sender: TObject);
      procedure owcustom_13tClick(Sender: TObject);
      procedure owcustom_14Click(Sender: TObject);
      procedure owcustom_14tClick(Sender: TObject);
      procedure owcustom_15Click(Sender: TObject);
      procedure owcustom_15tClick(Sender: TObject);
      procedure owcustom_16Click(Sender: TObject);
      procedure owcustom_16tClick(Sender: TObject);
      procedure owcustom_9Click(Sender: TObject);
      procedure owcustom_9tClick(Sender: TObject);

      procedure pmcheckClick(Sender: TObject);
      procedure pmjumpbreadcrumbClick(Sender: TObject);
      procedure pmnewfolderClick(Sender: TObject);
      procedure pmpropertiesClick(Sender: TObject);
      procedure pmsrecClick(Sender: TObject);
      procedure pmzerofileClick(Sender: TObject);
      procedure pmzerofreeClick(Sender: TObject);
      procedure pnabc1Click(Sender: TObject);
      procedure pnabc2Click(Sender: TObject);
      procedure pnabc3Click(Sender: TObject);
      procedure pnabc4Click(Sender: TObject);
      procedure pnabc5Click(Sender: TObject);
      procedure pnabc6Click(Sender: TObject);
      procedure pnabc7Click(Sender: TObject);
      procedure pnabc8Click(Sender: TObject);
      procedure pnbc1Click(Sender: TObject);
      procedure pnbc2Click(Sender: TObject);
      procedure pnbc3Click(Sender: TObject);
      procedure pnbc4Click(Sender: TObject);
      procedure pnbc5Click(Sender: TObject);
      procedure pnbc6Click(Sender: TObject);
      procedure pnbc7Click(Sender: TObject);
      procedure pnbc8Click(Sender: TObject);
      procedure pob_adlerClick(Sender: TObject);
      procedure pob_crc16Click(Sender: TObject);
      procedure pob_crc24Click(Sender: TObject);
      procedure pob_crc32Click(Sender: TObject);
      procedure pob_crc64Click(Sender: TObject);
      procedure pob_edonkeyClick(Sender: TObject);
      procedure pob_md4Click(Sender: TObject);
      procedure pob_md5Click(Sender: TObject);
      procedure pob_ripemdClick(Sender: TObject);
      procedure pob_sha1Click(Sender: TObject);
      procedure pob_sha256Click(Sender: TObject);
      procedure pob_sha3256Click(Sender: TObject);
      procedure pob_sha3512Click(Sender: TObject);
      procedure pob_sha512Click(Sender: TObject);
      procedure pob_whirlpoolClick(Sender: TObject);
      procedure powcustom_10Click(Sender: TObject);
      procedure powcustom_11Click(Sender: TObject);
      procedure powcustom_12Click(Sender: TObject);
      procedure powcustom_13Click(Sender: TObject);
      procedure powcustom_14Click(Sender: TObject);
      procedure powcustom_15Click(Sender: TObject);
      procedure powcustom_16Click(Sender: TObject);
      procedure powcustom_9Click(Sender: TObject);
      procedure po_alltasksClick(Sender: TObject);
      procedure po_analyzeClick(Sender: TObject);
      procedure po_checksumClick(Sender: TObject);
      procedure po_copypathClick(Sender: TObject);
      procedure msorttoggleClick(Sender: TObject);
      procedure mthumbimagesClick(Sender: TObject);
      procedure mtogglenavbarClick(Sender: TObject);
      procedure mtoggleopClick(Sender: TObject);
      procedure mtogglestatusbarClick(Sender: TObject);
      procedure mttoggletoolbarClick(Sender: TObject);
      procedure MenuItemDonationsClick(Sender: TObject);
      procedure MenuItemArchive_downloadsClick(Sender: TObject);
      procedure MenuItemExtAllHereClick(Sender: TObject);
      procedure MenuItemExtAllToClick(Sender: TObject);
      procedure MenuItemOpenWebClick(Sender: TObject);
      procedure MenuItemOpen_downloads1Click(Sender: TObject);
      procedure MenuItemOrganizeMbarClick(Sender: TObject);
      procedure MenuItemArchive_pubdocClick(Sender: TObject);
      procedure MenuItemArchive_pubhomeClick(Sender: TObject);
      procedure MenuItemOpen_pubdocClick(Sender: TObject);
      procedure MenuItemOpen_pubhomeClick(Sender: TObject);
      procedure MenuItemOpen_searchClick(Sender: TObject);
      procedure mextalldesktopClick(Sender: TObject);
      procedure mextalldocumentsClick(Sender: TObject);
      procedure mextallhereClick(Sender: TObject);
      procedure mextalltoClick(Sender: TObject);
      procedure mhclClick(Sender: TObject);
      procedure mhexploreClick(Sender: TObject);
      procedure mhistory1Click(Sender: TObject);
      procedure mhistory2Click(Sender: TObject);
      procedure mhistory3Click(Sender: TObject);
      procedure mhistory4Click(Sender: TObject);
      procedure mhistory5Click(Sender: TObject);
      procedure mhistory6Click(Sender: TObject);
      procedure mhistory7Click(Sender: TObject);
      procedure mhistory8Click(Sender: TObject);
      procedure mhpeaClick(Sender: TObject);
      procedure mopenasarchiveClick(Sender: TObject);
      procedure mgobrowserClick(Sender: TObject);
      procedure mextractarchiveClick(Sender: TObject);
      procedure MenuItemArchive_documents1Click(Sender: TObject);
      procedure MenuItemArchive_home1Click(Sender: TObject);
      procedure MenuItemextexploreClick(Sender: TObject);
      procedure MenuItemOpen_LastClick(Sender: TObject);
      procedure mf8Click(Sender: TObject);
      procedure mgoextlayoutClick(Sender: TObject);
      procedure mgotype7zClick(Sender: TObject);
      procedure mgotype7zsfxClick(Sender: TObject);
      procedure mgotypebz2Click(Sender: TObject);
      procedure mgotypegzClick(Sender: TObject);
      procedure mgotypetarClick(Sender: TObject);
      procedure mgotypezipClick(Sender: TObject);
      procedure mLangClick(Sender: TObject);
      procedure mlistClick(Sender: TObject);
      procedure mpathdesk1Click(Sender: TObject);
      procedure mpathexplore1Click(Sender: TObject);
      procedure mpathreset1Click(Sender: TObject);
      procedure mpathself1Click(Sender: TObject);
      procedure mPeaTrackerClick(Sender: TObject);
      procedure mr9Click(Sender: TObject);
      procedure mrowselectClick(Sender: TObject);
      procedure msetpwClick(Sender: TObject);
      procedure mshiftf3Click(Sender: TObject);
      procedure MenuItemHistoryBookClick(Sender: TObject);
      procedure MenuItemNavigateClick(Sender: TObject);
      procedure MenuItemOpen_desktop1Click(Sender: TObject);
      procedure MenuItemOpen_documents1Click(Sender: TObject);
      procedure MenuItemOpen_hereClick(Sender: TObject);
      procedure MenuItemOpen_home1Click(Sender: TObject);
      procedure MenuItemPWClick(Sender: TObject);
      procedure MenuItemToolhexpClick(Sender: TObject);
      procedure mEnvstrClick(Sender: TObject);
      procedure MenuItemBookmarksClick(Sender: TObject);
      procedure MenuItemOpen_addtobookmarksClick(Sender: TObject);
      procedure MenuItemOpen_commandpromptClick(Sender: TObject);
      procedure MenuItemRefreshClick(Sender: TObject);
      procedure mf2Click(Sender: TObject);
      procedure mf3Click(Sender: TObject);
      procedure mf4upClick(Sender: TObject);
      procedure mpeahelpofflineClick(Sender: TObject);
      procedure mRecent9Click(Sender: TObject);
      procedure mshiftf8Click(Sender: TObject);
      procedure mshowmenuClick(Sender: TObject);
      procedure msmalliconClick(Sender: TObject);
      procedure mswapbarsClick(Sender: TObject);
      procedure mSystemIntegrationClick(Sender: TObject);
      procedure mthlClick(Sender: TObject);
      procedure mtogglenewClick(Sender: TObject);
      procedure mTrayClick(Sender: TObject);
      procedure mTutorialClick(Sender: TObject);
      procedure munsearchClick(Sender: TObject);
      procedure mUserClick(Sender: TObject);
      procedure mwebsearchClick(Sender: TObject);
      procedure owcustom10Click(Sender: TObject);
      procedure owcustom11Click(Sender: TObject);
      procedure owcustom12Click(Sender: TObject);
      procedure owcustom13Click(Sender: TObject);
      procedure owcustom14Click(Sender: TObject);
      procedure owcustom15Click(Sender: TObject);
      procedure owcustom16Click(Sender: TObject);
      procedure owcustom1Click(Sender: TObject);
      procedure owcustom2Click(Sender: TObject);
      procedure owcustom3Click(Sender: TObject);
      procedure owcustom4Click(Sender: TObject);
      procedure owcustom5Click(Sender: TObject);
      procedure owcustom6Click(Sender: TObject);
      procedure owcustom7Click(Sender: TObject);
      procedure owcustom8Click(Sender: TObject);
      procedure owcustom9Click(Sender: TObject);
      procedure pajdn10Click(Sender: TObject);
      procedure pajdn11Click(Sender: TObject);
      procedure pajdn12Click(Sender: TObject);
      procedure pajdn13Click(Sender: TObject);
      procedure pajdn14Click(Sender: TObject);
      procedure pajdn15Click(Sender: TObject);
      procedure pajdn16Click(Sender: TObject);
      procedure pajdn17Click(Sender: TObject);
      procedure pajdn18Click(Sender: TObject);
      procedure pajdn19Click(Sender: TObject);
      procedure pajdn1Click(Sender: TObject);
      procedure pajdn20Click(Sender: TObject);
      procedure pajdn21Click(Sender: TObject);
      procedure pajdn22Click(Sender: TObject);
      procedure pajdn23Click(Sender: TObject);
      procedure pajdn24Click(Sender: TObject);
      procedure pajdn25Click(Sender: TObject);
      procedure pajdn26Click(Sender: TObject);
      procedure pajdn2Click(Sender: TObject);
      procedure pajdn3Click(Sender: TObject);
      procedure pajdn4Click(Sender: TObject);
      procedure pajdn5Click(Sender: TObject);
      procedure pajdn6Click(Sender: TObject);
      procedure pajdn7Click(Sender: TObject);
      procedure pajdn8Click(Sender: TObject);
      procedure pajdn9Click(Sender: TObject);
      procedure PanelClickAddressClick(Sender: TObject);
      procedure pclip_clearclipClick(Sender: TObject);
      procedure pclip_removeitemClick(Sender: TObject);
      procedure pcustompathexploreClick(Sender: TObject);
      procedure pma2s_copyClick(Sender: TObject);
      procedure pma2s_extallnew1Click(Sender: TObject);
      procedure pma2s_extnew1Click(Sender: TObject);
      procedure pma2s_extnewClick(Sender: TObject);
      procedure pma2s_extract1Click(Sender: TObject);
      procedure pma2s_extractall1Click(Sender: TObject);
      procedure pma2s_extractClick(Sender: TObject);
      procedure pma2s_moveClick(Sender: TObject);
      procedure pmbc1Click(Sender: TObject);
      procedure pmbc2Click(Sender: TObject);
      procedure pmbc3Click(Sender: TObject);
      procedure pmbc4Click(Sender: TObject);
      procedure pmbc5Click(Sender: TObject);
      procedure pmbc6Click(Sender: TObject);
      procedure pmbc7Click(Sender: TObject);
      procedure pmbc8Click(Sender: TObject);
      procedure pmbookmarksClick(Sender: TObject);
      procedure pmBrowserClick(Sender: TObject);
      procedure pmcommandClick(Sender: TObject);
      procedure pmcpytoClick(Sender: TObject);
      procedure pmexploreClick(Sender: TObject);
      procedure pmextcontextallClick(Sender: TObject);
      procedure pmextcontextdisplayedClick(Sender: TObject);
      procedure pmextcontextselectedClick(Sender: TObject);
      procedure pmh1Click(Sender: TObject);
      procedure pmh2Click(Sender: TObject);
      procedure pmh3Click(Sender: TObject);
      procedure pmh4Click(Sender: TObject);
      procedure pmh5Click(Sender: TObject);
      procedure pmh6Click(Sender: TObject);
      procedure pmh7Click(Sender: TObject);
      procedure pmh8Click(Sender: TObject);
      procedure pmh9Click(Sender: TObject);
      procedure pmhr1Click(Sender: TObject);
      procedure pmhr2Click(Sender: TObject);
      procedure pmhr3Click(Sender: TObject);
      procedure pmhr4Click(Sender: TObject);
      procedure pmhr5Click(Sender: TObject);
      procedure pmhr6Click(Sender: TObject);
      procedure pmhr7Click(Sender: TObject);
      procedure pmhr8Click(Sender: TObject);
      procedure pmhr9Click(Sender: TObject);
      procedure pmiresetClick(Sender: TObject);
      procedure pmjb10Click(Sender: TObject);
      procedure pmjb11Click(Sender: TObject);
      procedure pmjb12Click(Sender: TObject);
      procedure pmjb13Click(Sender: TObject);
      procedure pmjb14Click(Sender: TObject);
      procedure pmjb15Click(Sender: TObject);
      procedure pmjb16Click(Sender: TObject);
      procedure pmjb17Click(Sender: TObject);
      procedure pmjb18Click(Sender: TObject);
      procedure pmjb19Click(Sender: TObject);
      procedure pmjb1Click(Sender: TObject);
      procedure pmjb20Click(Sender: TObject);
      procedure pmjb21Click(Sender: TObject);
      procedure pmjb22Click(Sender: TObject);
      procedure pmjb23Click(Sender: TObject);
      procedure pmjb24Click(Sender: TObject);
      procedure pmjb2Click(Sender: TObject);
      procedure pmjb3Click(Sender: TObject);
      procedure pmjb4Click(Sender: TObject);
      procedure pmjb5Click(Sender: TObject);
      procedure pmjb6Click(Sender: TObject);
      procedure pmjb7Click(Sender: TObject);
      procedure pmjb8Click(Sender: TObject);
      procedure pmjb9Click(Sender: TObject);
      procedure pmJump3Click(Sender: TObject);
      procedure pmJumpDocumentsClick(Sender: TObject);
      procedure pmjumpdownloadsClick(Sender: TObject);
      procedure pmjumplibrariesClick(Sender: TObject);
      procedure pmjumppubdocClick(Sender: TObject);
      procedure pmjumppubhomeClick(Sender: TObject);
      procedure pmjumprecentClick(Sender: TObject);
      procedure pmjumpsearchClick(Sender: TObject);
      procedure pmjumpsearchesClick(Sender: TObject);
      procedure pmmorefun_infoClick(Sender: TObject);
      procedure pmmorefun_listClick(Sender: TObject);
      procedure pmmvtoClick(Sender: TObject);
      procedure pmopenoutClick(Sender: TObject);
      procedure pmqe1favClick(Sender: TObject);
      procedure pmqe2favClick(Sender: TObject);
      procedure pmqe3favClick(Sender: TObject);
      procedure pmqedefaultClick(Sender: TObject);
      procedure pmqedeskClick(Sender: TObject);
      procedure pmqedocumentsClick(Sender: TObject);
      procedure pmqehereClick(Sender: TObject);
      procedure pmqelastClick(Sender: TObject);
      procedure pmqen1Click(Sender: TObject);
      procedure pmqen2Click(Sender: TObject);
      procedure pmqen3Click(Sender: TObject);
      procedure pmqen4Click(Sender: TObject);
      procedure pmqen5Click(Sender: TObject);
      procedure pmqenewfolderClick(Sender: TObject);
      procedure pmqenopathClick(Sender: TObject);
      procedure pmqesetpwClick(Sender: TObject);
      procedure pmqetoClick(Sender: TObject);
      procedure pmquickdeleteClick(Sender: TObject);
      procedure pms2a_addClick(Sender: TObject);
      procedure pms2a_copyClick(Sender: TObject);
      procedure pms2a_moveClick(Sender: TObject);
      procedure pms2a_openClick(Sender: TObject);
      procedure pmsecuredeleteClick(Sender: TObject);
      procedure pmshist1Click(Sender: TObject);
      procedure pmshist2Click(Sender: TObject);
      procedure pmshist3Click(Sender: TObject);
      procedure pmshist4Click(Sender: TObject);
      procedure pmshist5Click(Sender: TObject);
      procedure pmshist6Click(Sender: TObject);
      procedure pmshist7Click(Sender: TObject);
      procedure pmshist8Click(Sender: TObject);
      procedure pmusedefaultClick(Sender: TObject);
      procedure pnb10Click(Sender: TObject);
      procedure pnb11Click(Sender: TObject);
      procedure pnb12Click(Sender: TObject);
      procedure pnb13Click(Sender: TObject);
      procedure pnb14Click(Sender: TObject);
      procedure pnb15Click(Sender: TObject);
      procedure pnb16Click(Sender: TObject);
      procedure pnb17Click(Sender: TObject);
      procedure pnb18Click(Sender: TObject);
      procedure pnb19Click(Sender: TObject);
      procedure pnb1Click(Sender: TObject);
      procedure pnb20Click(Sender: TObject);
      procedure pnb21Click(Sender: TObject);
      procedure pnb22Click(Sender: TObject);
      procedure pnb23Click(Sender: TObject);
      procedure pnb2Click(Sender: TObject);
      procedure pnb3Click(Sender: TObject);
      procedure pnb4Click(Sender: TObject);
      procedure pnb5Click(Sender: TObject);
      procedure pnb6Click(Sender: TObject);
      procedure pnb7Click(Sender: TObject);
      procedure pnb8Click(Sender: TObject);
      procedure pnb9Click(Sender: TObject);
      procedure pnba10Click(Sender: TObject);
      procedure pnba11Click(Sender: TObject);
      procedure pnba12Click(Sender: TObject);
      procedure pnba13Click(Sender: TObject);
      procedure pnba14Click(Sender: TObject);
      procedure pnba15Click(Sender: TObject);
      procedure pnba16Click(Sender: TObject);
      procedure pnba17Click(Sender: TObject);
      procedure pnba18Click(Sender: TObject);
      procedure pnba19Click(Sender: TObject);
      procedure pnba1Click(Sender: TObject);
      procedure pnba20Click(Sender: TObject);
      procedure pnba21Click(Sender: TObject);
      procedure pnba22Click(Sender: TObject);
      procedure pnba23Click(Sender: TObject);
      procedure pnba2Click(Sender: TObject);
      procedure pnba3Click(Sender: TObject);
      procedure pnba4Click(Sender: TObject);
      procedure pnba5Click(Sender: TObject);
      procedure pnba6Click(Sender: TObject);
      procedure pnba7Click(Sender: TObject);
      procedure pnba8Click(Sender: TObject);
      procedure pnba9Click(Sender: TObject);
      procedure pnh1Click(Sender: TObject);
      procedure pnh2Click(Sender: TObject);
      procedure pnh3Click(Sender: TObject);
      procedure pnh4Click(Sender: TObject);
      procedure pnh5Click(Sender: TObject);
      procedure pnh6Click(Sender: TObject);
      procedure pnh7Click(Sender: TObject);
      procedure pnh8Click(Sender: TObject);
      procedure pnha1Click(Sender: TObject);
      procedure pnha2Click(Sender: TObject);
      procedure pnha3Click(Sender: TObject);
      procedure pnha4Click(Sender: TObject);
      procedure pnha5Click(Sender: TObject);
      procedure pnha6Click(Sender: TObject);
      procedure pnha7Click(Sender: TObject);
      procedure pnha8Click(Sender: TObject);
      procedure pnr1Click(Sender: TObject);
      procedure pnr2Click(Sender: TObject);
      procedure pnr3Click(Sender: TObject);
      procedure pnr4Click(Sender: TObject);
      procedure pnr5Click(Sender: TObject);
      procedure pnr6Click(Sender: TObject);
      procedure pnr7Click(Sender: TObject);
      procedure pnr8Click(Sender: TObject);
      procedure pnra1Click(Sender: TObject);
      procedure pnra2Click(Sender: TObject);
      procedure pnra3Click(Sender: TObject);
      procedure pnra4Click(Sender: TObject);
      procedure pnra5Click(Sender: TObject);
      procedure pnra6Click(Sender: TObject);
      procedure pnra7Click(Sender: TObject);
      procedure pnra8Click(Sender: TObject);
      procedure pojdn10Click(Sender: TObject);
      procedure pojdn11Click(Sender: TObject);
      procedure pojdn12Click(Sender: TObject);
      procedure pojdn13Click(Sender: TObject);
      procedure pojdn14Click(Sender: TObject);
      procedure pojdn15Click(Sender: TObject);
      procedure pojdn16Click(Sender: TObject);
      procedure pojdn17Click(Sender: TObject);
      procedure pojdn18Click(Sender: TObject);
      procedure pojdn19Click(Sender: TObject);
      procedure pojdn1Click(Sender: TObject);
      procedure pojdn20Click(Sender: TObject);
      procedure pojdn21Click(Sender: TObject);
      procedure pojdn22Click(Sender: TObject);
      procedure pojdn23Click(Sender: TObject);
      procedure pojdn24Click(Sender: TObject);
      procedure pojdn25Click(Sender: TObject);
      procedure pojdn26Click(Sender: TObject);
      procedure pojdn2Click(Sender: TObject);
      procedure pojdn3Click(Sender: TObject);
      procedure pojdn4Click(Sender: TObject);
      procedure pojdn5Click(Sender: TObject);
      procedure pojdn6Click(Sender: TObject);
      procedure pojdn7Click(Sender: TObject);
      procedure pojdn8Click(Sender: TObject);
      procedure pojdn9Click(Sender: TObject);
      procedure PopupOpenPopup(Sender: TObject);
      procedure powcustom10Click(Sender: TObject);
      procedure powcustom11Click(Sender: TObject);
      procedure powcustom12Click(Sender: TObject);
      procedure powcustom13Click(Sender: TObject);
      procedure powcustom14Click(Sender: TObject);
      procedure powcustom15Click(Sender: TObject);
      procedure powcustom16Click(Sender: TObject);
      procedure powcustom1Click(Sender: TObject);
      procedure powcustom2Click(Sender: TObject);
      procedure powcustom3Click(Sender: TObject);
      procedure powcustom4Click(Sender: TObject);
      procedure powcustom5Click(Sender: TObject);
      procedure powcustom6Click(Sender: TObject);
      procedure powcustom7Click(Sender: TObject);
      procedure powcustom8Click(Sender: TObject);
      procedure powcustom9Click(Sender: TObject);
      procedure po_computerClick(Sender: TObject);
      procedure po_convertarchiveClick(Sender: TObject);
      procedure po_convertClick(Sender: TObject);
      procedure po_copytoClick(Sender: TObject);
      procedure po_cplClick(Sender: TObject);
      procedure po_detailsClick(Sender: TObject);
      procedure po_envstrClick(Sender: TObject);
      procedure po_flatClick(Sender: TObject);
      procedure po_hexpClick(Sender: TObject);
      procedure po_im_1024Click(Sender: TObject);
      procedure po_im_200Click(Sender: TObject);
      procedure po_im_4kcinemaClick(Sender: TObject);
      procedure po_im_4ktvClick(Sender: TObject);
      procedure po_im_50Click(Sender: TObject);
      procedure po_im_75Click(Sender: TObject);
      procedure po_im_BMPClick(Sender: TObject);
      procedure po_im_cropClick(Sender: TObject);
      procedure po_im_hdClick(Sender: TObject);
      procedure po_im_JPEG50Click(Sender: TObject);
      procedure po_im_JPEG75Click(Sender: TObject);
      procedure po_im_JPEGClick(Sender: TObject);
      procedure po_im_modifyClick(Sender: TObject);
      procedure po_im_PNGClick(Sender: TObject);
      procedure po_im_rlClick(Sender: TObject);
      procedure po_im_rrClick(Sender: TObject);
      procedure po_im_TIFFClick(Sender: TObject);
      procedure po_im_wuxgaClick(Sender: TObject);
      procedure po_manageClick(Sender: TObject);
      procedure po_movetoClick(Sender: TObject);
      procedure po_mrtClick(Sender: TObject);
      procedure po_msconfigClick(Sender: TObject);
      procedure po_msinfo32Click(Sender: TObject);
      procedure po_open_asarchiveClick(Sender: TObject);
      procedure po_open_asarchivetClick(Sender: TObject);
      procedure po_open_associatedtClick(Sender: TObject);
      procedure po_open_peaziptClick(Sender: TObject);
      procedure po_previewClick(Sender: TObject);
      procedure po_recycleClick(Sender: TObject);
      procedure po_regeditClick(Sender: TObject);
      procedure po_removeunitsClick(Sender: TObject);
      procedure po_rename_addClick(Sender: TObject);
      procedure po_rename_appenddirClick(Sender: TObject);
      procedure po_rename_extClick(Sender: TObject);
      procedure po_rename_lowercaseClick(Sender: TObject);
      procedure po_rename_deleteClick(Sender: TObject);
      procedure po_rename_prependdirClick(Sender: TObject);
      procedure po_rename_replaceClick(Sender: TObject);
      procedure po_rename_replace_caseClick(Sender: TObject);
      procedure po_rename_timestampClick(Sender: TObject);
      procedure po_rename_uppercaseClick(Sender: TObject);
      procedure po_securedeletefreeClick(Sender: TObject);
      procedure po_selectadvClick(Sender: TObject);
      procedure po_selectallClick(Sender: TObject);
      procedure po_setpwClick(Sender: TObject);
      procedure po_taskClick(Sender: TObject);
      procedure po_taskmanClick(Sender: TObject);
      procedure MenuItemOpen_archiveClick(Sender: TObject);
      procedure MenuItemOpen_exploreClick(Sender: TObject);
      procedure MenuItemOpen_pathClick(Sender: TObject);
      procedure MenuItemOpen_refreshClick(Sender: TObject);
      procedure mgolayoutClick(Sender: TObject);
      procedure mRefreshClick(Sender: TObject);
      procedure CheckBox4Click(Sender: TObject);
      procedure CheckBoxARC1Click(Sender: TObject);
      procedure CheckBoxArchiveHistoryClick(Sender: TObject);
      procedure CheckBoxArchiveOFClick(Sender: TObject);
      procedure CheckBoxIgnoreDispClick(Sender: TObject);
      procedure CheckBoxIgnoreSelClick(Sender: TObject);
      procedure CheckBoxQuadMaxClick(Sender: TObject);
      procedure CheckBoxShowHintsClick(Sender: TObject);
      procedure CheckBoxTarBeforeClick(Sender: TObject);
      procedure CheckBoxWindowStatusClick(Sender: TObject);
      procedure ColorButton1ColorChanged(Sender: TObject);
      procedure ComboBoxARCalgoChange(Sender: TObject);
      procedure ComboBoxARCChange(Sender: TObject);
      procedure ComboBoxArchive1Change(Sender: TObject);
      procedure ComboBoxArcSolidChange(Sender: TObject);
      procedure ComboBoxPAQ1Change(Sender: TObject);
      procedure ComboBoxPEA2Change(Sender: TObject);
      procedure ComboBoxPEA3Change(Sender: TObject);
      procedure ComboBoxPEA4Change(Sender: TObject);
      procedure ComboBoxPEACompression1Change(Sender: TObject);
      procedure ComboBoxSplit3Change(Sender: TObject);
      procedure ComboBoxThemeChange(Sender: TObject);
      procedure ComboBoxUPXChange(Sender: TObject);
      procedure ctrlbackClick(Sender: TObject);
      procedure ctrlfwdClick(Sender: TObject);
      procedure ctrlupClick(Sender: TObject);
      procedure EditUn7zaFilterKeyPress(Sender: TObject; var Key: char);
      procedure FormCreate(Sender: TObject);
      procedure FormDropFiles(Sender: TObject; const FileNames: array of String
        );
      procedure iConsoleCreateImport1Click(Sender: TObject);
      procedure iConsoleCreateImportClick(Sender: TObject);
      procedure Image7zPj1Click(Sender: TObject);
      procedure Image7zPj3Click(Sender: TObject);
      procedure Image7zPjClick(Sender: TObject);
      procedure ImageDefaults2Click(Sender: TObject);
      procedure ImageListRootClick(Sender: TObject);
      procedure ImageListSearchClick(Sender: TObject);
      procedure ImagePasswordClick(Sender: TObject);
      procedure ImageUn7zPjClick(Sender: TObject);
      procedure LabelDefaultColor1Click(Sender: TObject);
      procedure LabelDefaultColor2Click(Sender: TObject);
      procedure LabelDefaultOpacityClick(Sender: TObject);
      procedure mAttributesClick(Sender: TObject);
      procedure mBenchClick(Sender: TObject);
      procedure mDateEOlderClick(Sender: TObject);
      procedure mDateEqualClick(Sender: TObject);
      procedure mDateERecentClick(Sender: TObject);
      procedure mDateOlderClick(Sender: TObject);
      procedure mDateRecentClick(Sender: TObject);
      procedure mDefaultsClick(Sender: TObject);
      procedure MenuItem1Click(Sender: TObject);
      procedure MenuItem3Click(Sender: TObject);
      procedure pmExplorepathClick(Sender: TObject);
      procedure MenuItemERAssociatedClick(Sender: TObject);
      procedure MenuItemERCustomClick(Sender: TObject);
      procedure MenuItemERPeaZipClick(Sender: TObject);
      procedure MenuItemOpen_backClick(Sender: TObject);
      procedure MenuItemOpen_ext_allClick(Sender: TObject);
      procedure MenuItemOpen_ext_displayedClick(Sender: TObject);
      procedure MenuItemOpen_ext_selectedClick(Sender: TObject);
      procedure MenuItemOpen_FlatClick(Sender: TObject);
      procedure MenuItemOpen_fwdClick(Sender: TObject);
      procedure MenuItemOpen_info_allClick(Sender: TObject);
      procedure MenuItemOpen_info_displayedClick(Sender: TObject);
      procedure MenuItemOpen_info_selectedClick(Sender: TObject);
      procedure MenuItemOpen_jumpClick(Sender: TObject);
      procedure MenuItemOpen_list_allClick(Sender: TObject);
      procedure MenuItemOpen_list_displayedClick(Sender: TObject);
      procedure MenuItemOpen_list_selectedClick(Sender: TObject);
      procedure MenuItemOpen_rootClick(Sender: TObject);
      procedure MenuItemOpen_test_allClick(Sender: TObject);
      procedure MenuItemOpen_test_displayedClick(Sender: TObject);
      procedure MenuItemOpen_test_selectedClick(Sender: TObject);
      procedure MenuItemOpen_upClick(Sender: TObject);
      procedure MenuItemPreAssociatedClick(Sender: TObject);
      procedure MenuItemPreCustomClick(Sender: TObject);
      procedure MenuItemPrePeaZipClick(Sender: TObject);
      procedure MenuItemToolCheckClick(Sender: TObject);
      procedure MenuItemToolCompareClick(Sender: TObject);
      procedure mFlatClick(Sender: TObject);
      procedure mInvertSelectionClick(Sender: TObject);
      procedure mKeyFileClick(Sender: TObject);
      procedure mOptionsClick(Sender: TObject);
      procedure mPEAClick(Sender: TObject);
      procedure mPSELargerClick(Sender: TObject);
      procedure mPSEqualClick(Sender: TObject);
      procedure mPSESmallerClick(Sender: TObject);
      procedure mPSLargerClick(Sender: TObject);
      procedure mPSSmallerClick(Sender: TObject);
      procedure mQuitClick(Sender: TObject);
      procedure mRecent1Click(Sender: TObject);
      procedure mRecent2Click(Sender: TObject);
      procedure mRecent3Click(Sender: TObject);
      procedure mRecent4Click(Sender: TObject);
      procedure mRecent5Click(Sender: TObject);
      procedure mRecent6Click(Sender: TObject);
      procedure mRecent7Click(Sender: TObject);
      procedure mRecent8Click(Sender: TObject);
      procedure mSelectAllClick(Sender: TObject);
      procedure mSizeELargerClick(Sender: TObject);
      procedure mSizeEqualClick(Sender: TObject);
      procedure mSizeESmallerClick(Sender: TObject);
      procedure mSizeLargerClick(Sender: TObject);
      procedure mSizeSmallerClick(Sender: TObject);
      procedure mSortBySelectionClick(Sender: TObject);
      procedure mUnPEAbrowseClick(Sender: TObject);
      procedure mUnPEAClick(Sender: TObject);
      procedure openwithassociatedClick(Sender: TObject);
      procedure openwithcustomClick(Sender: TObject);
      procedure openwithpeazipClick(Sender: TObject);
      procedure pcustom1Click(Sender: TObject);
      procedure pcustom2Click(Sender: TObject);
      procedure pcustom3Click(Sender: TObject);
      procedure pcustom4Click(Sender: TObject);
      procedure pcustom5Click(Sender: TObject);
      procedure pcustom6Click(Sender: TObject);
      procedure pcustom7Click(Sender: TObject);
      procedure pcustom8Click(Sender: TObject);
      procedure pmAddFileClick(Sender: TObject);
      procedure pmAddFolderClick(Sender: TObject);
      procedure pmJump2Click(Sender: TObject);
      procedure pmJumpArchiveClick(Sender: TObject);
      procedure pmJumpPathClick(Sender: TObject);
      procedure pmLoadListClick(Sender: TObject);
      procedure pmOpenPJallClick(Sender: TObject);
      procedure pmOpenPJdisplayedClick(Sender: TObject);
      procedure pmOpenPJselectedClick(Sender: TObject);
      procedure pmSaveListClick(Sender: TObject);
      procedure pmSearchAddClick(Sender: TObject);
      procedure po_addtoarchiveClick(Sender: TObject);
      procedure po_checkClick(Sender: TObject);
      procedure po_compareClick(Sender: TObject);
      procedure po_copyClick(Sender: TObject);
      procedure po_cutClick(Sender: TObject);
      procedure po_defragClick(Sender: TObject);
      procedure po_deleteClick(Sender: TObject);
      procedure po_diskcleanClick(Sender: TObject);
      procedure po_exthereClick(Sender: TObject);
      procedure po_infoClick(Sender: TObject);
      procedure po_joinClick(Sender: TObject);
      procedure po_listClick(Sender: TObject);
      procedure po_newfolderClick(Sender: TObject);
      procedure po_open_associatedClick(Sender: TObject);
      procedure po_open_customClick(Sender: TObject);
      procedure po_open_peazipClick(Sender: TObject);
      procedure po_pasteClick(Sender: TObject);
      procedure po_renameClick(Sender: TObject);
      procedure po_securedeleteClick(Sender: TObject);
      procedure po_splitClick(Sender: TObject);
      procedure po_testClick(Sender: TObject);
      procedure po_zerofileClick(Sender: TObject);
      procedure po_zerofreeClick(Sender: TObject);
      procedure RadioGroup0Change(Sender: TObject);
      procedure RadioGroup1Change(Sender: TObject);
      procedure RadioGroup2Change(Sender: TObject);
      procedure RadioGroup4Change(Sender: TObject);
      procedure RadioGroup6Change(Sender: TObject);
      procedure RadioGroupAction1Change(Sender: TObject);
      procedure RadioGroupActionArcChange(Sender: TObject);
      procedure RadioGroupActionChange(Sender: TObject);
      procedure RadioGroupBrowserChange(Sender: TObject);
      procedure RadioGroupPaqClick(Sender: TObject);
      procedure RadioGrouppwrequestChange(Sender: TObject);
      procedure RadioGroupQuadClick(Sender: TObject);
      procedure RadioGroupTSChange(Sender: TObject);
      procedure schedaddschedule1Change(Sender: TObject);
      procedure schedaddscheduleChange(Sender: TObject);
      procedure scheduleend1Change(Sender: TObject);
      procedure scheduleendChange(Sender: TObject);
      procedure schedulestart1Change(Sender: TObject);
      procedure schedulestartChange(Sender: TObject);
      procedure scheduleuser1Change(Sender: TObject);
      procedure scheduleuserChange(Sender: TObject);
      procedure ShellTreeView1CustomDraw(Sender: TCustomTreeView;
        const ARect: TRect; var DefaultDraw: Boolean);
      procedure ShellTreeView1KeyDown(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure ShellTreeView1MouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ShellTreeView1MouseMove(Sender: TObject; Shift: TShiftState; X,
        Y: Integer);
      procedure ShellTreeView1MouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure SpinEdit1Change(Sender: TObject);
      procedure Splitter1Moved(Sender: TObject);
      procedure Splitter2Moved(Sender: TObject);
      procedure Splitter3Moved(Sender: TObject);
      procedure StringGrid1DblClick(Sender: TObject);
      procedure StringGrid1DrawCell(Sender: TObject; aCol, aRow: Integer;
        aRect: TRect; aState: TGridDrawState);
      procedure StringGrid1HeaderClick(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure StringGrid1HeaderSized(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure StringGrid1KeyDown(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure StringGrid1KeyPress(Sender: TObject; var Key: char);
      procedure StringGrid1KeyUp(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure StringGrid1MouseDown(Sender: TOBject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure StringGrid1MouseUp(Sender: TOBject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure StringGrid2DblClick(Sender: TObject);
      procedure StringGrid2DrawCell(Sender: TObject; aCol, aRow: Integer;
        aRect: TRect; aState: TGridDrawState);
      procedure StringGrid2HeaderClick(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure StringGrid2HeaderSized(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure StringGrid2KeyDown(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure StringGrid2KeyPress(Sender: TObject; var Key: char);
      procedure StringGrid2KeyUp(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure StringGrid2MouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure StringGrid2MouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure StringGridBookmarksColRowMoved(Sender: TObject;
        IsColumn: Boolean; sIndex, tIndex: Integer);
      procedure StringGridBookmarksDblClick(Sender: TObject);
      procedure StringGridBookmarksDrawCell(Sender: TObject; aCol,
        aRow: Integer; aRect: TRect; aState: TGridDrawState);
      procedure StringGridBookmarksHeaderClick(Sender: TObject;
        IsColumn: Boolean; Index: Integer);
      procedure StringGridBookmarksHeaderSized(Sender: TObject;
        IsColumn: Boolean; Index: Integer);
      procedure StringGridBookmarksKeyPress(Sender: TObject; var Key: char);
      procedure StringGridBookmarksMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure StringGridClipboardDblClick(Sender: TObject);
      procedure StringGridClipboardKeyPress(Sender: TObject; var Key: char);
      procedure StringGridCustEdit1ColRowMoved(Sender: TObject;
        IsColumn: Boolean; sIndex, tIndex: Integer);
      procedure StringGridCustEdit1DblClick(Sender: TObject);
      procedure StringGridCustEdit1MouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure StringGridCustEdit1SelectCell(Sender: TObject; aCol,
        aRow: Integer; var CanSelect: Boolean);
      procedure StringGridCustEditColRowMoved(Sender: TObject;
        IsColumn: Boolean; sIndex, tIndex: Integer);
      procedure StringGridCustEditDblClick(Sender: TObject);
      procedure StringGridCustEditMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure StringGridSessionHistoryDrawCell(Sender: TObject; aCol, aRow: Integer;
        aRect: TRect; aState: TGridDrawState);
      procedure StringGridSessionHistoryHeaderSized(Sender: TObject;
        IsColumn: Boolean; Index: Integer);
      procedure StringGridRecentDblClick(Sender: TObject);
      procedure StringGridRecentDrawCell(Sender: TObject; aCol, aRow: Integer;
        aRect: TRect; aState: TGridDrawState);
      procedure StringGridRecentHeaderSized(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure themes_downloadClick(Sender: TObject);
      procedure theme_label1Click(Sender: TObject);
      procedure themesave_labelClick(Sender: TObject);
      procedure Timer1Timer(Sender: TObject);
      procedure Timer2Timer(Sender: TObject);
      procedure Timer3StartTimer(Sender: TObject);
      procedure Timer3Timer(Sender: TObject);
      procedure Timer4Timer(Sender: TObject);
      procedure TimerdragTimer(Sender: TObject);
      procedure TimerHintStartTimer(Sender: TObject);
      procedure TimerrenameTimer(Sender: TObject);
      procedure tmconvertClick(Sender: TObject);
      procedure tmcreateClick(Sender: TObject);
      procedure tmextractClick(Sender: TObject);
      procedure tmopenarchiveClick(Sender: TObject);
      procedure tmopenpathClick(Sender: TObject);
      procedure tmpeazipClick(Sender: TObject);
      procedure tmquitClick(Sender: TObject);
      procedure tmupdateClick(Sender: TObject);
      procedure tbtemperatureChange(Sender: TObject);
      procedure TrayIcon1Click(Sender: TObject);
      procedure TrayIcon1DblClick(Sender: TObject);
      procedure TreeView1ContextPopup(Sender: TObject; MousePos: TPoint;
        var Handled: Boolean);
      procedure TreeView1MouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure TreeView1MouseEnter(Sender: TObject);
      procedure TreeView1MouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure w7contextlangClick(Sender: TObject);
   private
      { private declarations }
   public
      { public declarations }
   end;

{$IFDEF MSWINDOWS}
type //used for file properties
   TSHMultiFileProperties = function(pDataObj: IDataObject; Flag: DWORD): HRESULT;
   stdcall;

type //used for custom drag and drop
  TControlDragObject = class(TDragObject)
  private
    FDragImages: TDragImageList;
    FX, FY: Integer;
  protected
    procedure EndDrag(Target: TObject; X, Y: Integer); override;
    function GetDragCursor(Accepted: Boolean; X, Y: Integer): TCursor; override;
    //function GetDragImages: TDragImageList; override;
  public
    constructor CreateWithHotSpot(AControl: TWinControl; X, Y: Integer);
    destructor Destroy; override;
  end;

procedure FixControlStyles(Parent: TControl);

//used for system drag and drop
procedure dodropfiles(winc:TWinControl; sarr:array of ansistring; dropmode:integer); external 'dragdropfilesdll.dll';
procedure dodropvfiles(winc:TWinControl; vpath:ansistring; dropmode:integer); external 'dragdropfilesdll.dll';
procedure changevpath(vpath2: ansistring);  external 'dragdropfilesdll.dll';
procedure readvstatus(var vstat: ansistring);  external 'dragdropfilesdll.dll';
procedure setvstatus(vstat: ansistring);  external 'dragdropfilesdll.dll';
{$ENDIF}

function dragtowin(var dragdest:ansistring):integer;
function cleardir(var s:ansistring; cleardirname,force_skip_ptmpcode:boolean):integer;
function ask_pwkeyfile:integer;
procedure hideconfirmation;
procedure showconfirmation;
function launch_cl(cl,jobcode,outname:ansistring):integer;
function compose_un7z_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unace_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unarc_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unzpaq_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unlpaq_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode:ansistring):integer;
function compose_unpaq_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode:ansistring):integer;
function compose_unquad_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode:ansistring):integer;
function compose_unbrotli_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unzstd_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unpea_cl(var cl,jobcode,outname:ansistring):integer;
function compose_uncustom_cl(var cl,jobcode,outname:ansistring; real_extract:boolean):integer;
function setoutname(var s:ansistring; i:integer):integer;
function control_outpath(var out_param:ansistring):integer;
function testencrypted:integer;
function testencrypted_open:integer;
function checklistsel:integer;
function checklistanysel:integer;
function checklisttotsel(var nsel:integer; var strsel:ansistring):integer;
function gettreeicon(sg:TStringGrid; arow:integer):integer;
function getpcmenuicon(b:TBitmap):integer;
function setpcmenuicon(i:integer):TBitmap;
procedure calcseltsize;
procedure browsehistoryn(n:integer);
procedure jumpto(jumpdest:ansistring);
procedure launch_rsearch;
procedure launch_nrsearch;
procedure launch_rrsearch;
procedure listdir(s:ansistring; recmode,treemode:boolean);
procedure list_toextractor(act,modeofuse:ansistring);
procedure navrefresh;
procedure navgoup;
procedure rsearch;
procedure setquickextractmenu;
procedure update_listview;
procedure ComboBoxArchive4_onchange;
procedure run_websearch(s:ansistring);
procedure quickextract(dest:ansistring);
procedure toggle_view;
procedure peazipreset;
procedure peaziptotalreset;
procedure enter_busy_status;
procedure exit_busy_status;
procedure eraseselected_list(erasemode:integer);
procedure loadpm;
procedure setpm;
procedure on_checkboxseparateclick;
procedure ComboBoxArchive1_onchange;
procedure openappn(n:integer);
procedure openadvappn(n:integer);
procedure websearch_sel;
procedure settoolbar;
procedure populatefunmenu;
procedure do_forcerefresh;
procedure do_organizebookmarks;
procedure settonewfolder(i:integer);
procedure on_buttonarchiveclick;
procedure on_buttonextokclick;
procedure navgoback;
procedure navgofwd;
procedure setrecenticons_extract_archive;
procedure browser_explorepath(iscontext:integer);
procedure openwith_peazipnew(iscontext:integer; s:ansistring);
procedure browser_commandprompt(iscontext,isps:integer; s_in:ansistring);
procedure browser_fileproperties(s_in:ansistring);
procedure get_statuss(s:ansistring);
procedure updatecontent_ext;
procedure archivemenu_name(pathpart:ansistring);
procedure load_bookmarks;
function importjobcl(var cl,jobcode,outname:ansistring):integer;
function importjobcl_extract(var cl,jobcode,outname:ansistring):integer;
procedure on_checkboxsamearcclick;
procedure on_checkboxsameextclick;
procedure restartpeaapp;
procedure restartclosepeaapp;
procedure saverestartclosepeaapp;
procedure imgshelltree;
procedure do_pmfun(capt:ansistring);
procedure settpreset(i:integer);
procedure getscheduledtaskname(stype:integer);
procedure ComboBoxTheme_onchange;
procedure setwindowsopacity;
procedure setpanel_extract(ipanel:integer);
procedure populatetree2;
procedure setpanel_add(ipanel:integer);
procedure rename_files(mode:ansistring);
procedure extraction_checkintermediatedir(var outname:ansistring; optype:ansistring);
procedure advancedselect;
procedure select_all(allnone:ansistring);
procedure kp_EditUn7zaFilter1;
procedure kp_EditUn7zaFilter1_nr;
procedure exit_withsave;
procedure exit_nosave;
function wingetdesk:integer;
procedure set_listview_col;
procedure do_resetsearch;
procedure erase_fromname_list(erasemode:integer; s_in:ansistring);
procedure peazip_browse;
procedure setbrowserch(i:integer);
function gettabname(nrow:integer):ansistring;
function drawtabicon(arow:integer):integer;
procedure setupdatecontrols(encnt:boolean);
procedure get_unique_name(var out_param:ansistring);
procedure browsehistory;
procedure syncedit_archive;
procedure renamefileinarchive(nameold,namenew:ansistring;cleardestname:boolean);
procedure peaziplanguage(s: ansistring);
procedure finishlistview;
procedure erase_fromname(ptype:ansistring; var in_param:ansistring);
procedure grid_obj_open;
procedure newextclick;
procedure smartextclick;
procedure load_presetsnames;
procedure update_info;
procedure testrarlocked;
function geticon(fullname,fulltype:ansistring; pc:boolean):integer;
function checkaltdest(outname:ansistring):ansistring;
procedure moveafterextract(var outname:ansistring);
procedure erase_fromarchiving(erasemode:integer; executemode:integer; var cl:ansistring);
{$IFDEF MSWINDOWS}function fileop_fromnamelist(fnames: array of ansistring; fto:ansistring; fileopfun:integer; fileopflags:integer):integer;{$ENDIF}
procedure openwith_base(act,target:ansistring);
procedure openwith_cust(act,custmode:ansistring; j:integer);
procedure browsefiledir(s:ansistring);
procedure browse_special_cases;
procedure populatepcmenu;
procedure cancelbuttonextract;
procedure loadlist(sg:TStringGrid; listfilename:AnsiString);
procedure applypreset(presetname: ansistring);
procedure applycompsettings(settingsname: ansistring);
procedure do_calcstatus;
procedure do_calcstatusar;
procedure do_calcstatusex;
procedure updatelayout(enumdir:ansistring);
procedure untarafter(outname, inname:ansistring; var cl:ansistring; realuntar:boolean; optype:ansistring);
procedure set_dirbeforefiles(dmode:integer);

const
  WS_EX_LAYERED = $80000;
  LWA_ALPHA     = $2;
  INTVERSION    = '1.64';
  PEAZIPVERSION = '9.1';
  PEAZIPREVISION= '.0';
  PEAZIPSINTVER = 900;
  SPECEXTCONST  = '001 bat exe htm html msi r01 z01';
  PREFALGOCONST = 'CRC32 CRC64 MD5 RIPEMD160 SHA1 BLAKE2S SHA256 SHA3_256';
  FIRSTDOM      = 'https://peazip.github.io/';
  SECONDDOM     = 'https://peazip.sourceforge.io/';
  HLIBRE_DIR    = 0; //hardcode "libre directive" 0 not hardcode, read from configuration; 1 hardcoded to allow only using Free Software components 2 hardcoded to allow only using Free Software components and open archive formats (not encumbered by patents for read nor write)
  HPRIVACY_MODE = 0; //hardcode privacy_mode directive 0 not hardcode, read from configuration 1,2 hardcoded skippable or non skippable password request at startup, overriding configuration
  HBINPATH      = '';
  HCONFPATH     = '';
  HSHAREPATH    = '';
  MAXNDIRTREE   = 4096;
  DEFAULT_THEME = 'main-embedded';
  DLEFT         = 64;
  DTOP          = 64;
  DWIDTH        = 1024;
  DHEIGTH       = 600;
  DGWLEFT       = 92;
  DGWTOP        = 92;
  DGWWIDTH      = 640;
  DGWHEIGTH     = 320;
  NAMEVARSTR    = ' - ';
  ZCHAR         = '+';
  ZSTRING       = '----------';
  ZSTRINGS      = '--';
  ZSTRINGL      = '------------------- ----- ------------ ------------  ------------------------';
  {$IFDEF MSWINDOWS}
  NDLINES       = 3;//15.x+
  {$ELSE}
  NDLINES       = 3;//15.x+
  {$ENDIF}
  RAR5STRING    = 'Details: RAR 5'; //check first 14 characters
  READE_LIST    = '7Z, ACE, ARC/WRC, ARJ, BR, BZ/TBZ, CAB, CHM/CHW/HXS, COMPOUND (MSI, DOC, XLS, PPT), CPIO, GZ/TGZ, ISO, Java (JAR, EAR, WAR), LZH/LHA, Linux (DEB, PET/PUP, RPM, SLP), NSIS, OOo, PAK/PK3/PK4, PAQ/LPAQ/ZPAQ, PEA, QUAD/BALZ/BCM, RAR, TAR, WIM/SWM, XPI, Z/TZ, ZIP, ZST...';
  WRITEE_LIST   = '7Z, 7Z-sfx, ARC, ARC-sfx, BR, BZ2, GZ, *PAQ, PEA, QUAD/BALZ/BCM, split, TAR, UPX, WIM, XZ, ZIP, ZST';
  APPMAIN       = 'PeaZip';
  APPLICATION1  = 'Pea 1.12 (LGPLv3, Giorgio Tani)';
  STR_7Z        = '7Z';
  STR_ARC       = 'ARC';
  STR_BROTLI    = 'Brotli';
  STR_BZIP2     = 'BZip2';
  STR_GZIP      = 'GZip';
  STR_LPAQ      = 'LPAQ';
  STR_PAQ       = 'PAQ';
  STR_PEA       = 'PEA';
  STR_QUAD      = 'QUAD/BALZ/BCM';
  STR_TAR       = 'TAR';
  STR_UPX       = 'UPX';
  STR_ZIP       = 'ZIP';
  STR_ZPAQ      = '*PAQ';
  STR_WIM       = 'WIM';
  STR_XZ        = 'XZ';
  STR_ZSTD      = 'Zstd';
  //PeaZip's folder in working directory, containing all temporary work files unless 1) set to be created in output 2) archive conversion, always run in output
  STR_PZWORKTMP = 'peazip-tmp';
  //temp app subfolder, where different peazip instances can exchange messages and data
  STR_PEAZIPTMP = '.pztmp';
  //temp subdirs, deleted as soon as possible by each instance during use
  STR_TMP       = '.ptmp';
  STR_STMP      = '.pstmp';//special preview
  STR_TMPEXT    = '.petmp';//interactive extraction
  STR_TMPDD     = '.pdtmp';//drag and drop extraction
  //temp files
  STR_TESTOUT   = '.ptestouttmp';
  STR_STOPALL   = '.pstopalltmp';
  STR_TMPDROPE  = '.pdropetmp';
  STR_TMPERRI   = '.perritmp';
  {$IFDEF MSWINDOWS}
  EXEEXT        = '.exe';
  UNRARNAME     = 'unrar';
  APPLICATION2  = '7z 22.01 (LGPL, Igor Pavlov), and Tino Reichardt codecs v1.5.0r1 (LGPL)';
  APPLICATION3  = 'PAQ8F/JD/L/O, LPAQ1/5/8, ZPAQ 7.15 [Matt Mahoney et al. (GPL)]';
  APPLICATION4  = 'Strip (GPL, GNU binutils), UPX 3.95 (GPL, Markus F.X.J. Oberhumer, Laszlo Molnar and John F. Reiser)';
  APPLICATION5  = 'QUAD 1.12 (LGPL) / BALZ 1.15 (Public Domain), BCM 1.0 (Public Domain) (Ilia Muraviev)';
  APPLICATION6  = 'UNACEV2.DLL 2.6.0.0 (royalty-free UNACEV2.DLL license, ACE Compression Software)';
  APPLICATION7  = 'FreeArc 0.67 alpha (GPL, Bulat Ziganshin)';
  APPLICATION8  = 'UNRAR 5.21 (freeware, royalty-free, source available with unrar restriction, Alexander Roshal)';
  APPLICATION9  = 'Brotli 1.0.7 (MIT License, Jyrki Alakuijala, Eugene Kliuchnikov, Robert Obryk, Zoltán Szabadka, Lode Vandevenne)';
  APPLICATION10 = 'Zstd 1.5.2 (Dual license BSD / GPLv2, Yann Collet, Przemysław Skibiński)';
  {$ENDIF}
  {$IFDEF LINUX}
  EXEEXT        = '';
  UNRARNAME     = 'unrar-nonfree';
  APPLICATION2  = 'Linux 7z 22.01 (LGPL, Igor Pavlov)';
  APPLICATION3  = 'PAQ8F/JD/L/O, LPAQ1/5/8, ZPAQ 7.05 [Matt Mahoney et al. (GPL)]';
  APPLICATION4  = 'Strip (GPL, GNU binutils), UPX 3.96 (GPL, Markus F.X.J. Oberhumer, Laszlo Molnar and John F. Reiser)';
  APPLICATION5  = 'QUAD 1.12 (LGPL) / BALZ 1.15(Public Domain), BCM 1.0 (Public Domain) (Ilia Muraviev)';
  APPLICATION6  = 'UNACE (royalty-free UNACE for Linux license, Marcel Lemke, ACE Compression Software)';
  APPLICATION7  = 'FreeArc 0.60 (GPL, Bulat Ziganshin)';
  APPLICATION8  = 'UNRAR 5.21 beta 2 (freeware, royalty-free, source available with unrar restriction, Alexander Roshal, Petr Cech)';
  APPLICATION9  = 'Brotli 1.0.9 (MIT License, Jyrki Alakuijala, Eugene Kliuchnikov, Robert Obryk, Zoltán Szabadka, Lode Vandevenne)';
  APPLICATION10 = 'Zstd 1.5.2 (Dual license BSD / GPLv2, Yann Collet, Przemysław Skibiński)';
  {$ENDIF}
  {$IFDEF FREEBSD}
  EXEEXT        = '';
  UNRARNAME     = '';
  APPLICATION2  = 'BSD 7z 21.07 (LGPL, Igor Pavlov)';
  APPLICATION3  = '';
  APPLICATION4  = '';
  APPLICATION5  = '';
  APPLICATION6  = '';
  APPLICATION7  = '';
  APPLICATION8  = '';
  APPLICATION9  = 'Brotli 1.0.9 (MIT License, Jyrki Alakuijala, Eugene Kliuchnikov, Robert Obryk, Zoltán Szabadka, Lode Vandevenne)';
  APPLICATION10 = 'Zstd 1.4.8 (Dual license BSD / GPLv2, Yann Collet, Przemysław Skibiński)';
  {$ENDIF}
  {$IFDEF NETBSD}
  EXEEXT        = '';
  UNRARNAME     = '';
  APPLICATION2  = 'BSD 7z 21.07 (LGPL, Igor Pavlov)';
  APPLICATION3  = '';
  APPLICATION4  = '';
  APPLICATION5  = '';
  APPLICATION6  = '';
  APPLICATION7  = '';
  APPLICATION8  = '';
  APPLICATION9  = 'Brotli 1.0.9 (MIT License, Jyrki Alakuijala, Eugene Kliuchnikov, Robert Obryk, Zoltán Szabadka, Lode Vandevenne)';
  APPLICATION10 = 'Zstd 1.4.8 (Dual license BSD / GPLv2, Yann Collet, Przemysław Skibiński)';
  {$ENDIF}
  {$IFDEF OPENBSD}
  EXEEXT        = '';
  UNRARNAME     = '';
  APPLICATION2  = 'BSD 7z 21.07 (LGPL, Igor Pavlov)';
  APPLICATION3  = '';
  APPLICATION4  = '';
  APPLICATION5  = '';
  APPLICATION6  = '';
  APPLICATION7  = '';
  APPLICATION8  = '';
  APPLICATION9  = 'Brotli 1.0.9 (MIT License, Jyrki Alakuijala, Eugene Kliuchnikov, Robert Obryk, Zoltán Szabadka, Lode Vandevenne)';
  APPLICATION10 = 'Zstd 1.4.8 (Dual license BSD / GPLv2, Yann Collet, Przemysław Skibiński)';
  {$ENDIF}
  {$IFDEF DARWIN}
  EXEEXT        = '';
  UNRARNAME     = '';
  APPLICATION2  = 'macOS 7z 21.07 (LGPL, Igor Pavlov)';
  APPLICATION3  = 'ZPAQ 7.15 [Matt Mahoney et al. (GPL)]';
  APPLICATION4  = 'Strip (GPL, GNU binutils)';
  APPLICATION5  = '';
  APPLICATION6  = '';
  APPLICATION7  = '';
  APPLICATION8  = '';
  APPLICATION9  = 'Brotli 1.0.9 (MIT License, Jyrki Alakuijala, Eugene Kliuchnikov, Robert Obryk, Zoltán Szabadka, Lode Vandevenne)';
  APPLICATION10 = 'Zstd 1.5.2 (Dual license BSD / GPLv2, Yann Collet, Przemysław Skibiński)';
  {$ENDIF}

var
   Form_peach: TForm_peach;
   patheditor:TEdit;
   TargetNode,TargetNode2:TTreeNode;
   TS:TTimeStamp;
   clipcontent,clipcontent1:TClipcontent;
   aconf,conf,book,cedit,t:text;
   pmfileb:file of byte;
   imod,inbcnode,rowsize,selnode:integer;
   abcrs: array [1..4] of ansistring;
   specextensions: array of ansistring;

   //scaling
   il16,ilsmall,il48,il96,il192: TImageList;
   qscale,qscaleimages,pspacing,pzooming,pspacingd,pzoomingd,ensmall,ensmalld,
   icon_sizeplus,reficonsize,baseiconsize,
   COL1D,COL2D,COL3D,COL4D,COL5D,COL6D,COL7D:integer;

   //address bar colors
   abactivecol,abarchivecol,tabpencol,tabbrushcol,tabbrushhighcol:tcolor;

   //Listview hints
   h:THintWindow;
   r:TRect;
   shint,prevshint:ansistring;

   //status extractor
   epfolder,epfolder1,epdefault,epextract,epskip,epdelete,epfilters,eparcextract,eparcskip,epaceextract,epsupp,epunsupp,vexcustom3,epunsupp1:integer;
   epdefaultextractpath,vexcustom1,vexcustom2,vexc1,vexc2,vexc3,vexc4,vexc5,vexc6,vexc7,vexc8:ansistring;
   epdopt,vexpaths,epsni,epsns,epsnz,epzall,epzfull,epzabs,epzfor:integer;

   //status archiver
   apdefault,apformat,apfilters,apenum,apencext,apappend,apcustext,apsplit,apspin,apsize,apdelete,apverbose,appw,apdopt,aprar,aprar5,aprardict,aprarblake2,
   aprarsfx,aprarsolid,apprarrr,aprarrr,aprarsaveopen,aprarsavesecurity,aprarsavestreams,aprarlastmodtime,aprarlock:integer;
   apdefaultarchivepath,apextcapt:ansistring;
   v7z1,v7z2,v7z3,v7z4,v7z5,v7z6,v7z7,v7snoi,v7snon,v7z7b,v7z8,v7z9,v7z10,v7z11,v7z11b,v7z13,v7z13b,v7z14,v7z15,v7z16,v7z16a,v7z16b,v7z17,v7z18,v7z17c,vtartype,vtartime,v7zpaths,vlevel_7z,vlevel_bzip2,vlevel_gz,vlevel_zip,vlevel_xz,v9b,v9z,v9r,vbr1,vzst1:integer;
   v7z12,vmethod_7z,vmethod_zip,varc7,vcustom1,vcustom2,vcustom3:ansistring;
   vquad1,vquad2,vpaq1,vpaq2,vupx1,vupx2,vupx3,varc1,varc2,varc3,varc3b,varc4,varc5,varc6,varc8,vsplit1,vpea1,vpea2,vpea3,vpea4,vcustom4:integer;

   //status options
   vopt1,vopt1b,vopt7c,vopt12t,vopt19e,vopt19f,vopt5d3t,vopt5csv:ansistring;
   vopt2,vopt3,vopt4,vopt4b,vopt4c,vopt4d,vopt4e,vopt4f,vopt4g,vopt4h,vopt5,vopt5b,vopt5c,vopt5d,vopt5d4,vopt5d1,vopt5d2,vopt5d3,vopt5e,
   vopt5f,vopt5f1,vopt5g,vopt5dup,vopt5gtar,vopt5gtar1,vopt5h,vopt5sw,vopt5ca,vopt6,vopt7,vopt7b,vopt8,vopt9,vopt10,vopt11,vopt12,voptlibre,
   voptprivacy,vopt13,voptts,vopt14,vopt15c,vopt15d,vopt15e,vopt15e2,vopt15f,vopt15g,vopt15h,vopt15i,vopt16,vopt17,vopt18,vopt18b,
   vopt19,vopt19b,vopt19c,vopt19d,vopt20,vopt20b,vopt21,vopt22,vopt22b,vopt23,vopt23b,vopt24,vopt24b,vopt25,valg1,valg2,valg3,valg4,valg5,
   valg6,valg7,valg8,valg9,valg10,valg11,valg12,valg13,valg14,valg15:integer;

   //image editing options
   simgfun, simgw, simgh, simgper, simgasp, simgconv, simgj, simgt, simgb, simgl, simgr, simgpercent, deco_style:integer;

   devicon:array [1..26] of TBitmap;
   Bplaceshistory,Barchive_bigger2,Barchive_big,Barchive,BArchiveSupported,
   BFileSupported,BExesupported,Bunsupported,Bback,Bbookmark,Bbookmarkadd,Bclearlayout,
   Bdefaults,Bdelete,Bdvd_supported,Bexpand,Bextractall,Bextractall_big,Bfd_supported,
   BFolder,Bgo,Bgopath,Bgoup,Bhd_supported,Binfo,Bkeyfile,Bloadlayout,Blocker,Blocker2,
   Bmail,Bnav,Bp0,Bpreview,Bram_supported,Brefresh,Bremote_supported,Bremovable_supported,
   Bresetpath,Broot,Brun,Bsavelayout,Bsearch,Bdesk,Bsystemtools,Btestall,Btestall_big,
   Bstop,Bweb,Bwipe,Blink,Bconvert,Bconvert_big,Btxt,Bspreadsheet,Bvideo,Baudio,Bimage,
   Bpresentation,Bpdf,Bsupported,Bbat,Bdll,Bdb,Bgif,Bico,Bvector,
   Bdetailsfs,Bjpeg,Bapps,Bextractalln_big,Bextractalln,
   Barc7z,Barcrar,Barczip,Barcblock,Barcdisk,Barcinstaller,
   Bdvd_supported48,Bfd_supported48,BFolder48,Bhd_supported48,Bram_supported48,
   Bremote_supported48,Bremovable_supported48,Btxt48,Bspreadsheet48,Bvideo48,Baudio48,Bimage48,
   Bpresentation48,Bpdf48,Bsupported48,Bbat48,Bdll48,Bdb48,Bgif48,Bico48,Bvector48,Bjpeg48,BArchiveSupported48,
   BFileSupported48,BExesupported48,Bunsupported48,Blink48,Bweb48,Bmail48,
   Barc7z48,Barcrar48,Barczip48,Barcblock48,Barcdisk48,Barcinstaller48,
   Btool_cut,Btool_copy,Btool_paste,Btool_openw,Btool_properties,Btool_rename,
   Btool_delete,Btool_dup,BTool_cut_small,BTool_copy_small,BTool_dup_small,
   Btool_properties_small,Btool_rename_small,BTool_resize,BTool_crop,
   BTool_rl,BTool_rr,BTool_resize_small,BTool_crop_small,
   BTool_rl_small,BTool_rr_small,Bbrowserdetails,Bbrowserlist,Bbrowsericons,Bbrowserdetailslarge,Bbrowserlistlarge,Bdownloadfolder,Bcloudfolder,Bhomefolder,Bbrowsericonslarge,
   Bdvd_supported96,Bfd_supported96,BFolder96,Bhd_supported96,Bram_supported96,
   Bremote_supported96,Bremovable_supported96,Btxt96,Bspreadsheet96,Bvideo96,Baudio96,Bimage96,
   Bpresentation96,Bpdf96,Bsupported96,Bbat96,Bdll96,Bdb96,Bgif96,Bico96,Bvector96,Bjpeg96,BArchiveSupported96,
   BFileSupported96,BExesupported96,Bunsupported96,Blink96,Bweb96,Bmail96,
   Barc7z96,Barcrar96,Barczip96,Barcblock96,Barcdisk96,Barcinstaller96,
   Bfm,Bnonthemed0,Bnonthemed1,Bnonthemed3,Bnonthemed4,Bnonthemed5,Bnonthemed6,
   Bnonthemed7,Bnonthemed8,Bnonthemed9,Bnonthemed10,Bnonthemed11,
   Bp1,Bp2,Bp3,Bp4,Bp5,Bp6,Bp7,Bp8,
   binfodlg,bwarningdlg,berrordlg: TBitmap;

   dfilenames:array of string;

   devname:array [1..26] of ansistring;
   patchclip:array of array [0..15] of ansistring;
   israr5,browse_option,caption_release,caption_build,tempstring,alt_tempstring,archive_type,archive_t,
   compression_method,compression_level,parameters,kdir,in_name,in_file,in_folder,
   output_name,out_qualified_name,size_u,cks,data_compression,save_cks,bcomp,
   keyfname,themedir,theme_name,theme_author,theme_license,theme_path,wrk_path,executable_path,resource_path,binpath,sharepath,
   persistent_source,fun,subfun,btfun,tools_path,color1,color2,color3,color4,color5,color1d,
   color2d,color3d,color4d,color5d,prev_type,
   prev_method,prev_level,method_7z,dmethod_7z,method_zip,dmethod_zip,ptmpcode,ptmpdir,pstmpdir,graphicsfolder,graphicsfolderd,
   archive_content,wincomspec,delimiter,desktop_path,prevpanel,winver,majmin,indir,destdir,
   prev_destdir,local_desktop,home_path,confpath,currentcomp,currentfs,usr_documents,usr_music,usr_videos,usr_pictures,users_root,
   public_documents,public_home,usr_recent,usr_searches,usr_libraries,usr_downloads,usr_sendto,
   shared_dropbox,shared_googledrive,shared_onedrive,shared_skydrive,shared_ubuntuone,shared_myboxfiles,
   usr_name,lastobj,lastobjarch,custedit1,custedit2,custedit3,custedit4,custedit5,
   custedit6,custedit7,custedit8,custedit9,custedit10,custedit11,custedit12,custedit13,
   custedit14,custedit15,custedit16,prevcaption,advedit1before,advedit2before,advedit3before,
   advedit4before,advedit5before,advedit6before,advedit7before,advedit8before,advedit1after,
   advedit2after,advedit3after,advedit4after,advedit5after,advedit6after,advedit7after,
   advedit8after,advedit1alt,advedit2alt,advedit3alt,advedit4alt,advedit5alt,advedit6alt,
   advedit7alt,advedit8alt,
   winpfolder,winpfolder32,winsysfolder,winappdatafolder,fun_status,lastoutpath,lastextractionpath,
   status0,status1,status_curfilesystem,status_curarchive,statuss,statust,statusr,
   checkver,extsel,defaultextractpath,defaultarchivepath,dn,
   prevrun,titlestring,sortstatusstring,updateid,prevupdateid,prevarchive,inputfile,
   peaziptmpdir,peaziptmpdirroot,peaziptmpdir_tmp,basedragtitle,unacepluginstatus,unrar5pluginstatus,addformatspluginstatus,
   prevlistfilter,browsersdir,custom_work_path,tempaddinarchive,beingpreviewed,moverelpath,
   move_out_param,lcmethod,langstrhint,plistfile,statushint,infocpu,inforam,infomem,
   statushintar,statushintex,typehint,csvsep,origout,origoutnf,origouttf,origoutmf,
   prefixd,prefixf,prefixdaz,prefixdza,prefixfaz:ansistring;

   tvolumes,tdirs,tfiles,psize,tvol,tsize:qword;

   devtype:array [1..26] of integer;
   appdb:array [1..16] of integer;
   appdb2:array [1..8] of integer;
   imlistindex,imtodo,exelistindex,exetodo:array of integer;
   listrow,listsortcol,listsortcol1,listsortcol2,listsortbook,title_lines_7z,
   currow1,browsingmode7z,splittersize,splitter2size,lastbar,lasttoolbar,prevbar,splitter3size,splitsearchsize,
   barheight,mbarheight,mmbarheight,intcellhw,expandfs,expandroot,expandbook,expandhistory,expandmore,expandrun,expandapps,expandfun,
   secgroupheight,listcol,ares,esna,euns,col1size,col2size,col3size,col4size,col5size,col6size,col7size,colmethodsize,
   toolsize,ptoolsize,navbar,addressbar,ptabbar,work_dir,prebrowse_dirs,prebrowse_records,rootdirrecord,mappeddrivesinfo,session_mappeddrivesinfo,
   appentries1,pcount,refreshstatus,usealtcolor,altaddressstyle,solidaddressstyle,toolcentered,alttabstyle,accenttoolbar,highlighttabs,altaddressstyled,toolcenteredd,solidaddressstyled,alttabstyled,accenttoolbard,usealtcolord,highlighttabsd,ws_top,ws_left,ws_height,ws_width,ws_gw_top,ws_gw_left,ws_gw_height,ws_gw_width,
   archive_type_selected,prebrowsesize,smalliconsize,mediconsize,largeiconsize,browsersize,browsertype,
   sync,imindex,exeindex,showthumbnails,simplesearch,recsearch,issearching,browserch,arcabspath,keeppw,usebreadcrumb,
   pmnotdecrypted,pimmersive,hnum,tpcomp,tpreset,prevdrbutton,bctemp,listmode,favdelete,convertverbose,convertpw,
   libre_directive,tsstyle,updatingcontent,wasselected,wasselectedp,ptabid,atabid,
   doptadd,doptext,privacy_mode,showvolatile,tryopenwerrors,forcecanbechanged,excludeef,euns1,
   autosync,sys7zlin,i16res,i32res,i48res,i96res,tabheight,tablabelheight,tabheightl,pbarh,autoopentar,spansize,advopdictionary,
   advopword,advoppasses,advopblocksize,noconfdel,specialmoderar,pforceconsole,closeonsingleextract,movetorelativepath,
   forcebrowse,forceconvert,forcelayout,nitems,storecreated,max_cl,temperature,temperatured,lsize,ntoolstyle,pperc,dirbeforefiles:integer;

   ltime,stime:longint;

   ent_buffer: array [0..63] of byte;
   opacity,opacityd,df,pf,pobj,pcompr,pvol,pstream,salgo,zaout,zaout1,ws,ws_status,
   ignorepathextand,level_7z,dlevel_7z,level_xz,level_brotli,level_zstd,level_rar,
   level_bzip2,level_arc,solid_arc,rr_arc,algo_arc,algo_zipenc,level_gz,level_paq,paqver,
   level_quad,level_upx,level_zip,dlevel_zip,snoi7z,snon7z,openw_all7z,showpwfield,setencfn,intpw,hidepwconf,
   autoclosegwrap,mailkeep,autoopen,autotest,autoclosepeazip,skipenctest,tartype,tartime,
   browserstyle,desk_env,prebrowse,maxargsize,ignorepathdisp,enc7zscc,sni7z,sns7z,snh7z,snl7z,ssp7z,stl7z,snz7z,maxbrotli,maxzstd,
   ignorepathsel,removeintdir,ignorepathdd,savehistory,fav7z,favARC,favbz,favcustom,favgz,favpea,favquad,favsfx,
   favsfxarc,favsplit,favtar,favupx,favzip,favzpaq,favwim,favxz,favbrotli,favzstandard,enableextand,
   extpw,algodisp,algoall,algoadler,algocrc16,
   algocrc24,algocrc32,algocrc64,algoed2k,algomd4,algomd5,algoripemd160,algosha1,
   algosha3_256,algosha256,algosha3_512,algosha512,algowhirl,showguihints,customsyntax,
   customsyntax1,erasepasses,filesizebase,extopt7z,extoptarc,extaction7z,extactionarc,extactionace,
   clipmode,jobdefenc,
   archivenameenc,tonewfolder,parallelarchive,zcopy,mcuzip,nameaspartent,spchar,enumd,addencext,repcustext,addtstext,swzipx,
   defaulttabsmenu,multi_option,memuse_option,nonverboselog,skipdel,disableintscript,use7zunrar5,useextrac32,sort7zbytype,browsersd,userar,userar5,userarblake2,
   userardict,userarsfx,userarsolid,userarrr,puserarrr,userarsaveopen,userarsavesecurity,userarsavestreams,userarlastmodtime,
   userarlock,tmpremoveintdir,renselonly,renfilesonly,defaultspanning,spanunit,zpaqall,zpaqfull,zpaqabsolute,zpaqforce,
   dragtargetprotect,whenspecialopen,howspecialopen,ptsync,taskpriority,defaultactionst,displayfoldercontent,filterbrowser,
   immediate_execution,defaultarchiveaction,showsearchbar,tar_atomic,tar_atomic_convert,syntaxlevel7z,convint,
   qdup:byte;

   call_validated,keyf_opened,no_more_files,
   using_tarbefore,tarbeforenameexception,seemencrypted,az,az1,az2,azbook,imgloaded,imgloading,
   settingvalues,archiveopened,browsinghistory,filecopying,openstarted,dragcancelled,
   listingdir,control_listingdir,done_listingexe,waitdrawok,needwaitupdating,updatingarchive_inarchive,goarchiving,updatingarchive_sync,
   stayopen,completeshowpea,savetype,pcmenupopulated,updatinglistview,updatingsel,rowselect,showmenu,enlargeicons,
   thighlight,ccreated,caccessed,cmethod,ctype,csize,cpacked,cdate,catt,ccrc,cfree,cfs,multiaddupdating,dontsavecustom7z,
   dontsavecustomzip,forceopenasarchive,skipapstatus,browserbusy,fromtree,spinchanged,
   swapbars,treeonbutton,rightdropbutton,popupclosed,done_quickfunctions,contextconvert_switch,
   funflag,endflag,setbs,launchwithsemaphore,disable_twofactor,extselall,tmpenumd,uacneeded,
   cancellingarchive,nffromdrag,unrar5shown,unaceshown,restartingapp,needsave,is_searching,
   h_folders,nomatch,set_archivetree,aisexpanded,setsequenceerror,tmpextnf,settmpextnf,
   keeppreview,loadadvdefaults,havewinrar,singleextract,specialopen,pclicked,
   willbemoved,forcewillbemoved,forcenotwillbemoved,pdrop,prebrowsing,imported_tarbeforejob:boolean;

   activelabel_options,activelabel_add,activelabel_extract,activelabel_apps:TLabel;

   //system drag and drop
   disdrag,threadextracting,imdel:boolean;
   nativedrag:integer;
   {$IFDEF MSWINDOWS}
   vpatha,vpathb,vpath2,vpathname:ansistring;
   //used for transparence
   hUser32prop: HMODULE;
   SHMultiFileProperties: TSHMultiFileProperties;
   //drag and drop
   FDragObject:TDragObject;
   //semaphore
   psem,psemwait: THandle;
   {$ENDIF}

   lang_file:ansistring;
   //text strings
   txt_9_1_7zs,txt_9_1_ac,txt_9_1_ef,txt_9_1_enlargeicons,txt_9_1_nw,txt_9_1_qdup,txt_9_1_closeall,
   txt_9_0_tnav,txt_9_0_showmainmenu,txt_9_0_navmenu,txt_9_0_accesstime,txt_9_0_hl,txt_9_0_sl,txt_9_0_mem,txt_9_0_autoexttar,txt_9_0_plugind,txt_9_0_df,
   txt_8_9_empty,txt_8_9_ttb,txt_8_9_stoptest,txt_8_9_disp,txt_8_9_parsing,
   txt_8_8_snz,txt_8_8_snoi,txt_8_8_snon,txt_8_8_altt,txt_8_8_light,txt_8_8_autotest,txt_8_8_ca,txt_8_8_cb,txt_8_8_centered,txt_8_8_cw,txt_8_8_btn,txt_8_8_lnk,txt_8_8_tab,txt_8_8_sm,txt_8_8_solcol,txt_8_8_intnote,
   txt_8_7_csvhelp,txt_8_7_csv,txt_8_7_showsearchbar,txt_8_7_verifybin,txt_8_7_hok,txt_8_7_hnotok,txt_8_7_after,txt_8_7_mo,txt_8_7_bintest,txt_8_7_showhm,txt_8_7_showsm,
   txt_8_6_clear,txt_8_6_noclear,txt_8_6_nosimple,txt_8_6_immediate,txt_8_6_yessimple,
   txt_8_5_detailslarge,txt_8_5_listlarge,txt_8_5_intext,txt_8_5_advbrowser,txt_8_5_loadlayout,txt_8_5_samplescripts,
   txt_8_4_keepopenerrorslist,
   txt_8_3_prefalgo,txt_8_3_mbubin,txt_8_3_mbudec,txt_8_3_mbu,txt_8_3_maxarg,txt_8_3_skipdel,txt_8_3_cw,txt_8_3_lw,txt_8_3_temperature,txt_8_3_htab,txt_8_3_noupx,
   txt_8_2_slower,txt_8_2_df,txt_8_2_vreport,txt_8_2_alltimes,txt_8_2_supportedby,txt_8_2_keep,txt_8_2_skipet,txt_8_2_ta,txt_8_2_tc,txt_8_2_tm,
   txt_8_1_volumes,txt_8_1_ed,txt_8_1_slow,txt_8_1_preparse,txt_8_1_nopreparse,txt_8_1_preparsehint,txt_8_1_bo,txt_8_1_bop,txt_8_1_togglearc,txt_8_1_vslow,
   txt_8_0_altcol,txt_8_0_commonalgo,txt_8_0_forcebrowse,txt_8_0_forceconvert,txt_8_0_forcetyping,txt_8_0_forcetypinghelp,txt_8_0_setpwopt,txt_8_0_defaultaction,txt_8_0_defaultactionhint,txt_8_0_enableextand,
   txt_7_9_spacing,txt_7_9_zooming,
   txt_7_8_dd,txt_7_8_custext,txt_7_8_rel,txt_7_8_priorityhigh,txt_7_8_priorityidle,txt_7_8_prioritynormal,txt_7_8_priorityrealtime,txt_7_8_tpriority,txt_7_8_requirerestart,txt_7_8_changelocalization,
   txt_7_7_sys7zreq,txt_7_7_sys7z,txt_7_7_nonetemp,txt_7_7_outtemp,txt_7_7_tw,txt_7_7_noneall,
   txt_7_6_zipenc,txt_7_6_custenc,txt_7_6_forcelocalenc,txt_7_6_forceutf8enc,txt_7_6_defaultenc,txt_7_6_setcurdef,txt_7_6_setdef,txt_7_6_cpnote,txt_7_6_tacolor,txt_7_6_color,txt_7_6_dim,txt_7_6_dark,txt_7_6_tno,txt_7_6_tadvanced,txt_7_6_tsimple,txt_7_8_destexistfile,txt_7_8_update,
   txt_7_5_autoclosesingle,txt_7_5_dragnone,txt_7_5_draglock,txt_7_5_draghide,txt_7_5_draglh,txt_7_5_specialbrowse,txt_7_5_ee,txt_7_5_always,txt_7_5_ask,txt_7_5_never,txt_7_5_cutlen,txt_7_5_cutlenw,txt_7_5_repnascii,
   txt_7_4_tcurr,txt_7_4_tkeep,txt_7_4_7zfbrotlicomp,txt_7_4_7zfzstandardcomp,txt_7_4_lock,txt_7_4_locked,txt_7_4_presetrar,txt_7_4_comment,txt_7_4_recover,txt_7_4_lockconfirm,txt_7_4_setarc,txt_7_4_setext,txt_7_4_swzipx,
   txt_7_3_profile7zfastest,txt_7_3_profile7zfast,txt_7_3_maxbr,txt_7_3_maxzstd,txt_7_3_stl,txt_7_3_archiveerrors,txt_7_3_archiveerrorshint,txt_7_3_noconfdel,txt_7_3_clickextall,
   txt_7_2_altcomp,txt_7_2_clearnoupdate,txt_7_2_autoclosepeazip,txt_7_2_zpaqall,txt_7_2_extcomp,txt_7_2_extcompultra,txt_7_2_fbrotlicomp,txt_7_2_fzstandardcomp,txt_7_2_loadcompsettings,txt_7_2_savecompsettings,txt_7_2_source,txt_7_2_updateclear,
   txt_7_1_type_description_brotli,txt_7_1_typetosearch,txt_7_1_type_description_zstd,txt_7_1_profileintermediate,txt_7_1_renfilesonly,txt_7_1_smart,txt_7_1_new,
   txt_7_0_autoopentar,txt_7_0_exttmppath,txt_7_0_af,
   txt_6_9_autou,txt_6_9_uconf,txt_6_9_opuns,txt_6_9_forceu,txt_6_9_overarch,
   txt_6_8_ndrop,txt_6_7_nop,txt_6_6_pdupfound,txt_6_6_rsh,txt_6_6_pdupfind,txt_6_6_forcemodify,
   txt_6_5_sni,txt_6_5_sns,txt_6_5_mandatory,txt_6_5_askp,txt_6_5_privacy,txt_6_5_nop,
   txt_6_5_chp,txt_6_5_np,txt_6_5_def,txt_6_5_abort,txt_6_5_error,txt_6_5_yesall,
   txt_6_5_yes,txt_6_5_warning,txt_6_5_seqerr,txt_6_5_showvolatile,txt_6_5_force,
   txt_6_4_tabbar,txt_6_4_new,txt_6_4_closeallother,txt_6_4_closeright,
   txt_6_4_collapse,txt_6_4_expand,txt_6_4_openintab,
   txt_6_4_paths,txt_6_4_relative,txt_6_4_full,txt_6_4_absolute,txt_6_4_appdirn,txt_6_4_prepdirn,
   txt_6_3_uar,txt_6_3_syn,txt_6_3_autoadjust,txt_6_3_cinfo,
   txt_6_2_encext,txt_6_2_archive,txt_6_2_container,txt_6_1_ec,txt_6_0_msq,
   txt_5_9_lff,txt_5_9_pff,txt_5_9_start,
   txt_5_8_ascii,txt_5_8_cp,txt_5_8_utf,txt_5_8_l0,txt_5_8_l1,txt_5_8_l2,txt_5_8_fs,txt_5_8_fsr,
   txt_5_7_pinstalled,txt_5_7_pmissing,txt_5_7_plugin,
   txt_5_6_exarc,txt_5_6_upexisting,txt_5_6_layouts,txt_5_6_rc,txt_5_6_basic,txt_5_6_verbose,
   txt_5_6_tab,
   txt_5_5_case,txt_5_5_add,txt_5_5_ext,txt_5_5_halt,txt_5_5_replaceneww,txt_5_5_plugin,
   txt_5_5_lower,txt_5_5_newext,txt_5_5_new,txt_5_5_old,txt_5_5_delete,txt_5_5_replacestr,
   txt_5_5_replaceoldw,txt_5_5_upper,txt_5_5_extw,txt_5_5_intdir,txt_5_5_string,
   txt_5_5_n,txt_5_5_position,txt_5_5_positionw,txt_5_5_positionwd,txt_5_5_starting,
   txt_5_5_similar,txt_5_5_select,txt_5_5_addsel,txt_5_5_subtractsel,txt_5_5_copypath,
   txt_5_5_datesameday,txt_5_5_datesamehour,txt_5_5_datesamemonth,txt_5_5_datesameweek,txt_5_5_datesameyear,
   txt_5_5_datehour,txt_5_5_datemonth,txt_5_5_dateweek,txt_5_5_dateyear,txt_5_5_dateday,
   txt_5_5_scan,
   txt_5_4_da,txt_5_4_lv,txt_5_4_used,txt_5_4_deletearchives,txt_5_4_deleteoriginal,
   txt_5_4_deletearchivesconfirm,txt_5_4_deletefiles,txt_5_4_deletefilesconfirm,
   txt_5_3_cml,txt_5_3_cmlmessage,txt_5_3_resetsi,txt_5_3_ia,txt_5_3_io,txt_5_3_rec,txt_5_3_exc,
   txt_5_2_oadd,txt_5_2_oext,txt_5_2_zerofiles,txt_5_2_zerofree,txt_5_2_securedeletefree,txt_5_2_zerodelete,
   txt_5_2_zfree,txt_5_2_sdfree,txt_5_2_free,txt_5_3_profilebest, txt_5_3_profileadvanced,
   txt_5_3_profilenormal, txt_5_3_profileveryfast, txt_5_3_profilepassword, txt_5_3_profile10mb,
   txt_5_3_profilesfx,
   txt_5_1_schedexplain,txt_5_1_schedname,txt_5_1_schedule,txt_5_1_hourly,txt_5_1_daily,txt_5_1_weekly,
   txt_5_1_monthly,txt_5_1_once,txt_5_1_onstart,txt_5_1_onlogin,txt_5_1_every,txt_5_1_hours,txt_5_1_day,txt_5_1_days,
   txt_5_1_weeks,txt_5_1_months,txt_5_1_w1,txt_5_1_w2,txt_5_1_w3,txt_5_1_w4,txt_5_1_w5,txt_5_1_w6,txt_5_1_w7,
   txt_5_1_last,txt_5_1_starttime,txt_5_1_startdate,txt_5_1_enddate,txt_5_1_schedmanage,txt_5_1_schedadd,
   txt_5_1_schederr,txt_5_1_schedok,txt_5_1_scriptmanage,txt_5_1_schedscripts,txt_5_1_ts,
   txt_5_0_bc,txt_5_0_resetpm,txt_5_0_enum,txt_5_0_ps,txt_5_0_sh,txt_5_0_skip,txt_5_0_perf,txt_5_0_music,txt_5_0_pictures,txt_5_0_removeall,txt_5_0_resetbookmarks,txt_5_0_videos,
   txt_4_9_frame,txt_4_9_listth,txt_4_9_shadow,txt_4_9_style,
   txt_4_8_presets,txt_4_8_listno,txt_4_8_detailsno,txt_4_8_details,txt_4_8_iconm,txt_4_8_iconl,
   txt_4_8_crop,txt_4_8_fullscreen,txt_4_8_fun,txt_4_8_immersive,txt_4_8_resize,txt_4_8_rr,txt_4_8_rl,
   txt_4_8_imagemanager,txt_4_8_flip,txt_4_8_mirror,txt_4_8_replace,txt_4_8_fit,txt_4_8_fitl,
   txt_4_8_h,txt_4_8_noresize,txt_4_8_aspect,txt_4_8_w,txt_4_8_stop,txt_4_8_t,txt_4_8_attach25,
   txt_4_8_keeparchive,
   txt_4_7_pcomp,txt_4_7_pk,txt_4_7_spchar,txt_4_7_recycle,txt_4_7_recycleask,
   txt_4_6_am,txt_4_6_fm,txt_4_6_users,
   txt_4_5_dock,txt_4_5_l,txt_4_5_t,txt_4_5_r,txt_4_5_b,txt_4_5_pj,txt_4_5_update,txt_4_5_noupdate,txt_4_5_goupdate,txt_4_5_koupdate,
   txt_4_5_upxpj, txt_4_5_properties, txt_4_5_shaddress, txt_4_5_shnav, txt_4_5_shstatus, txt_4_5_shtool,
   txt_4_4_confremove, txt_4_4_confremoveall,
   txt_4_3_keeppw, txt_4_3_recsrc, txt_4_3_breadcrumb, txt_4_3_pwman,
   txt_4_3_pwmanhint,txt_4_3_pwmanpwhint,txt_4_3_pwmanmaster, txt_4_3_pwmanlist,
   txt_4_3_exppl, txt_4_3_expple, txt_4_3_expplp, txt_4_3_pwmancorr, txt_4_3_resetpm,
   txt_4_2_arcabspath,
   txt_4_1_duplicateshint, txt_4_1_selected, txt_4_1_duplicatesfound, txt_4_1_duplicatesfind,
   txt_4_1_simplesearch,txt_4_1_runasadmin,txt_4_1_adminhint,
   txt_4_0_thim,
   txt_3_8_type_description_wim,txt_3_8_type_description_xz,
   txt_3_7_donations,txt_3_7_sort,txt_3_7_swapbars,txt_3_7_themedbars,txt_3_7_nameasparent,
   txt_3_7_tracker,
   txt_3_6_close,txt_3_6_resetapps,txt_3_6_ignoredd,txt_3_6_ethemes,
   txt_3_5_td,txt_3_5_managecustomthemes,
   txt_3_4_smallicons,txt_3_4_nopaths,
   txt_3_3_run,txt_3_3_runexp,txt_3_3_skipunits,txt_3_3_apppath,txt_3_3_apps,txt_3_3_stralt,
   txt_3_3_multi,
   txt_3_2_conf,txt_3_2_7zutf8nonascii,txt_3_2_donations,txt_3_2_alltasks,
   txt_3_1_sccenc,txt_3_1_languagetools,txt_3_1_lib,txt_3_1_recent,txt_3_1_src,txt_3_1_more,
   txt_3_1_sendto,txt_3_1_openasarchive,txt_3_1_downloads,txt_3_1_pathexc,txt_3_1_plsmartmin,
   txt_3_1_workingdir,txt_3_1_systmp,
   txt_3_0_nonreadableorpw,txt_3_0_readablepw,txt_3_0_resettmp,txt_3_0_configure,
   txt_2_9_address,txt_2_9_selected,txt_2_9_public,txt_2_9_organize,txt_2_9_lt,txt_2_9_mt,txt_2_9_st,
   txt_2_9_copyhere,txt_2_9_movehere,txt_2_9_columns,
   txt_2_9_noscan,txt_2_9_vst,txt_2_9_thl,txt_2_9_toolbar,txt_2_9_test_pw2G,txt_2_9_adv,
   txt_2_9_extconsole,txt_2_9_rec,txt_2_9_views,txt_2_9_none,txt_2_9_showmenu,txt_2_9_setapps,
   txt_2_9_nav,txt_2_9_navbar,txt_2_9_showtool,txt_2_9_tree,txt_2_9_home,
   txt_2_8_experimental,txt_2_8_zcopy,txt_2_8_addvol,txt_2_8_uniterror,txt_2_8_cannotconvert,
   txt_2_8_convertbegin,txt_2_8_convert,txt_2_8_convertexisting,txt_2_8_details,
   txt_2_8_convertdelete,txt_2_8_parallel,txt_2_8_convertnote,txt_2_8_unitrecommend,
   txt_2_8_viewasarchive,txt_2_8_nounit,txt_2_8_rowselect,
   txt_2_8_typeunit,txt_2_8_usedefaultoutpath,txt_2_8_statusbar,txt_2_8_custom,
   txt_2_7_encfn,txt_2_7_validatecl,txt_2_7_validatefn,txt_2_7_cancel,txt_2_7_ok,
   txt_2_7_separate,txt_2_7_output,txt_2_7_archivehint,txt_2_7_optional,txt_2_7_pwnotset,
   txt_2_7_pwarcset,txt_2_7_pwextset,txt_2_7_setpw,txt_2_7_pwsupported,
   txt_2_7_extfrom,txt_2_7_ext,txt_2_7_updating,txt_2_7_goarclayout,txt_2_7_goextlayout,
   txt_2_7_setadvf,txt_2_7_selpath,txt_2_7_dirsize,txt_2_7_exthint,
   txt_2_7_clipboard,txt_2_7_noinput,txt_2_7_es,txt_2_7_eu,txt_2_7_separateerror,
   txt_2_7_drag_archive,txt_2_7_list_tryflatorpw,txt_2_7_un7z_browse_flat,txt_2_7_oop,
   txt_2_7_experimental,
   txt_2_6_folders,txt_2_6_plalways,
   txt_2_6_plsmart,txt_2_6_advanced,
   txt_2_5_sessionio,txt_2_5_advanced,txt_2_5_basic,txt_2_5_cannotrun,txt_2_5_custeditors,
   txt_2_5_delete,txt_2_5_delete_fromarchive,txt_2_5_langflag,txt_2_5_encpj,
   txt_2_5_execommand,txt_2_5_help,txt_2_5_langhint,
   txt_2_5_mini_help,txt_2_5_offline_help,txt_2_5_tray,txt_2_5_remove,txt_2_5_hintpaths,
   txt_2_5_selectapp,txt_2_5_strafter,txt_2_5_strbefore,txt_2_5_encoding,
   txt_2_5_nopw,
   txt_2_4_itemsheight,txt_2_4_tb,txt_2_4_deletebookmarks,txt_2_4_totalmem,txt_2_4_operation,
   txt_2_4_advclip,txt_2_4_stdclip,txt_2_4_copyfrom,txt_2_4_extractfrom,
   txt_2_4_draghint,txt_2_4_clearclipboard,txt_2_4_removefromclipboard,txt_2_4_path,
   txt_2_4_adding,txt_2_4_documents,txt_2_4_hexp,txt_2_4_gvideo,txt_2_4_wenc,txt_2_4_yanswers,
   txt_2_4_wdict,txt_2_4_wbook,txt_2_4_wsrc,txt_2_4_wcommons,txt_2_4_wnews,
   txt_2_3_pw_errorchar,txt_2_3_envstr,txt_2_3_never_pw,txt_2_3_home,txt_2_3_on_pw,txt_2_3_test_pw100,txt_2_3_test_pw,
   txt_list_isfolder,txt_action_extopen,txt_error_passwordnotmatch,txt_action_preview,
   txt_preview_hint,txt_removeselected,txt_savelayout,txt_better,txt_default2,txt_faster,
   txt_fastermem,txt_tempdir,txt_stream,txt_slowermem,txt_store,txt_newfolder,
   txt_7z_exitcodeunknown,
   txt_none,txt_fd,txt_7z_exitcode1,txt_attach10,txt_7z_exitcode2,
   txt_7z_exitcode255,txt_fat32,txt_dvd,txt_attach5,txt_cd650,txt_7z_exitcode7,txt_cd700,
   txt_type_description_7z,txt_dvddl,txt_7z_exitcode8,txt_abort,txt_about,txt_action,
   txt_action_hint,txt_add,txt_add_existing_archive,txt_add_archive,
   txt_add_files,txt_add_folder,txt_add_path,txt_add_tolayout,txt_add_toarchive,txt_add_tobookmarks,
   txt_address_hint,txt_adv_filters,txt_algo,txt_all,txt_all_default,txt_all_type,
   txt_all_date,txt_all_psize,txt_all_attributes,txt_all_size,txt_error_input_upx,
   txt_always_pw,txt_ignore_ext,txt_ignore_disp,txt_ignore_sel,txt_key_hint,
   txt_timestamp,txt_appoptions,txt_type_description_arc,txt_archive,txt_un7z_browse_ok,
   txt_interface,txt_archivecreation,txt_tarbefore_hint,
   txt_archive_hint,txt_compressionratio_hint,txt_archiving,txt_cl_long,txt_overwrite_askbefore,
   txt_associated,txt_attributes,txt_author,txt_ren_existing,txt_ren_extracted,txt_autofolder,
   txt_back,txt_backend,txt_backupexe,txt_bettercompression,txt_blogs,txt_blowfish,
   txt_bookmarks,txt_browse,txt_browser,txt_aborted_error,txt_list_browsing,
   txt_archive_root,txt_type_description_bzip2,txt_pw_empty,txt_add_error,txt_un7z_browse_failure,
   txt_list_error,txt_conf_cannotsave,txt_check_hint,txt_check,txt_check_select,txt_clear,
   txt_clearlayout,txt_pj_hint,txt_autoclose,txt_cl,txt_compare,txt_compress,
   txt_compress_executable,txt_compress_openforwriting,txt_compression,txt_compmanagement,
   txt_pw_confirm,txt_console,txt_console_interface,txt_content,
   txt_controlpanel,txt_copy,txt_copyto,txt_create,txt_create_archive,txt_title_create,
   txt_create_keyfile,txt_create_folder,txt_create_theme,txt_rr,txt_create_sfx,txt_cr_current,
   txt_custom,txt_type_description_custom,txt_customapp,txt_custom_parameters,txt_customsize,
   txt_cut,txt_datetime,txt_default,txt_default_compression,
   txt_default_format,txt_theme_default,
   txt_hard_reset_hint,txt_desktop,txt_dictionary,txt_dirs,txt_dis,txt_disk_cleanup,
   txt_disk_defrag,txt_disk_management,txt_dispaly,txt_displayedmnu_obj,txt_displayedobjects,
   txt_nocompress,txt_delete,txt_wipe,txt_done,txt_edit,txt_elapsed,
   txt_error_emptycl,txt_encrypt,txt_encrypted,txt_encryption,txt_note,
   txt_random_keys,txt_random_keys_hint,txt_ent,txt_ent_tools,txt_eqorlarger,
   txt_eqorrecent,txt_eqorolder,txt_eqorsmaller,txt_equal,txt_erase_hint,txt_extraction_error,
   txt_exclude_hint,txt_exclude_recourse,txt_exclusion_recourse,txt_exclusion,txt_exe,
   txt_overwrite_qry,txt_confirm_overwrite,txt_explore_outpath,txt_explore_path,txt_ext,
   txt_caption_extract,txt_ext_nopath,txt_ext_all,txt_ext_allhere,txt_ext_allto,txt_extopen_custom,
   txt_extopen_with,txt_ext_disp_here,txt_ext_disp,txt_ext_disp_to,txt_ext_here,txt_ext_sel_here,
   txt_ext_sel,txt_ext_sel_to,txt_extobj,txt_newfoldermenu,txt_extto,txt_level_fast,
   txt_fastcompr,txt_fastopen,txt_level_fastest,txt_favformats,txt_file,txt_filebrowser,
   txt_filelist_savedas,txt_filetools,txt_files,txt_nfiles,txt_fs,
   txt_filters_recourse,txt_filters,txt_flat,txt_list_flat,txt_unit_floppy,txt_foldername,
   txt_nfolders,txt_error_input_multi,txt_fwd,txt_list_found,txt_free,
   txt_free2,txt_name_full,txt_function,txt_general,txt_multithreading,
   txt_go_browser,txt_go_path,txt_guicl,txt_guipealauncher,txt_graphic,
   txt_gridaltcolor,txt_gridrowheight,txt_gui,txt_type_description_gzip,txt_hardreset,
   txt_here,txt_list_history,txt_homeroot,txt_quickbrowse_hint,
   txt_backupexe_hint,txt_attach,txt_images,txt_include_hint,txt_filters_hint,txt_inclusion_recourse,
   txt_inclusion,txt_error_function,txt_info,txt_infoall,txt_infodisp,txt_infosel,
   txt_inputinfo,txt_input_list,txt_iop,txt_ipo,txt_input,txt_integrity,txt_chunk_size,
   txt_invertsel,txt_type_exe,txt_return_to_archive,txt_not_accessible,txt_type_unsupported,
   txt_checkname_failed,txt_not_accessible_list,txt_theme_create_error,txt_theme_exists,
   txt_job_code,txt_job_definition_saved,txt_job_success,txt_join,txt_joinfiles,
   txt_keyfile,txt_keyfile_not_found,txt_keyfile_notcreated,txt_larger,
   txt_lastused,txt_launch,txt_layout,txt_level,txt_license,txt_caption_list,txt_list_details,
   txt_list_all,txt_list_disp,txt_list_sel,txt_toggle_warning,txt_loadfile,txt_loadlayout,
   txt_unit_hd,txt_localization,txt_lpaqver,txt_type_description_lpaq,txt_maininterface,
   txt_maxcomp,txt_level_maximum,txt_restartrequired,txt_required_memory,
   txt_method,txt_misc,txt_modify,txt_morecontrols,txt_morerecent,
   txt_ent_hint,txt_moveto,txt_mypc,txt_list_na,txt_name,txt_naming,txt_unit_remote,
   txt_newarchive,txt_news,txt_no,txt_noinput,txt_nocompress_hint,
   txt_split_noinput,txt_open_noinput,txt_list_nomatch,txt_singlethread,txt_none2,
   txt_nonsolid,txt_level_normal,txt_copy_error,txt_description,txt_compare_second,
   txt_peaobj,txt_displayed_obj,txt_olderthan,txt_ondblclick,
   txt_opacity,txt_open,txt_openarchive,txt_title_open,txt_open_bookmark,txt_cphere,
   txt_open_file,txt_open_files,txt_open_path,txt_opensource,txt_openwith,
   txt_aborted,txt_unit_cd,txt_options,txt_other,txt_otherparams,
   txt_oip,txt_opi,txt_output,txt_overwrite,txt_compressed_size,txt_paqver,
   txt_type_description_paq,txt_pio,txt_poi,txt_parameters,txt_error_partial,
   txt_passes,txt_pw,txt_pwlength,txt_un7z_browse_pw,txt_un7z_browse_pw_other,txt_paste,
   txt_path,txt_pea_appcolor,txt_pea_textcolor,txt_type_description_pea,txt_peazip_new,
   txt_peazip_help,txt_peazip_web,txt_performall,txt_upxorstrip,
   txt_not_removable_file,txt_not_removable,txt_custom_executable_missing,
   txt_type_unsupported_select,txt_no_theme_name,txt_please_wait,txt_copy_wait,txt_previewwith,
   txt_projectadmin,txt_type_description_quad,txt_quickdelete,txt_quit,txt_unit_ram,
   txt_read,txt_recentarchives,txt_rr_hint,txt_search_refine,txt_fefreshf5,
   txt_release,txt_unit_removable,txt_remove_bookmark,txt_remove_external_unit,
   txt_rename,txt_caption_repair,txt_restartrequired2,txt_reset,txt_reset_archivename,
   txt_reset_theme,
   txt_restore_att,txt_run_as,txt_run_as2,txt_sample,
   txt_saveas,txt_savehistory,txt_save_infolder,txt_savejob,txt_savejobdefinition,
   txt_savejobdefinition_hint,txt_save_winstate,
   txt_search,txt_searchanddrag,txt_nrsearch,txt_search_hint,txt_search_web,txt_list_searching,
   txt_securedelete,txt_default_description,txt_selectall,txt_selectdir,
   txt_selected_obj,txt_selected_objects,txt_sfx,txt_sendbymail,txt_set_defaults,
   txt_settings,txt_sfx_interface,txt_showhints,
   txt_show_messages,txt_showpw,txt_singlevol,txt_size,txt_sizeb,txt_skip_existing,
   txt_slowercomp,txt_smaller,txt_solid,txt_solid_block,txt_solid_auto,txt_solid_extension,
   txt_listtest,txt_sortbysel,txt_list_sorting,
   txt_speed,txt_split,txt_type_description_split,txt_split_file,txt_list_nostats,
   txt_status,txt_level_store,txt_stream_control,txt_strip,txt_keyfile_created,txt_suggestpw,
   txt_noupx,txt_syntax,txt_sysbenchmark,txt_benchmark,txt_systools,txt_tarbefore,
   txt_type_description_tar,txt_taskman,txt_caption_test,txt_testall,txt_testdisp,
   txt_testpw,txt_testsel,txt_col_hint,txt_bookmarks_hint,txt_archive_noinput_tolist,
   txt_theme,txt_icons_found,txt_themename,txt_icons_not_found,txt_theme_create_success,
   txt_theming,txt_extand_error,txt_threads,txt_titlescolor,
   txt_to,txt_toggle_browseflat,txt_toggle_historybookmarks,txt_toolbarscolor,txt_tools,
   txt_best,txt_type,txt_level_ultra,txt_error_openfile,txt_cl_hint,
   txt_ace_missing,txt_units,txt_unit_unknown,txt_un7z_pw_untested,txt_up,txt_update,
   txt_type_description_upx,txt_advfilters,txt_openfiles_hint,txt_usenet,txt_user_name,
   txt_using,txt_volumepea,txt_volume_size,txt_type_ext_uns,txt_websites,
   txt_word,txt_write,txt_ramdompw_hint,txt_exe_hint,
   txt_pj_hint2,txt_type_description_zip,txt_zipcrypto_hint,txt_name_provide,txt_cnewfolder,
   txt_searchfor,txt_websearch,txt_on,txt_convert:ansistring;

implementation

{ TForm_peach }

function CloneMenuItem(Src: TMenuItem): TMenuItem;//generic cloning method modified for PeaZip's main menu as source
var
  i: Integer;
begin
  if Src=nil then Exit;
  Result:=TMenuItem.Create(Src.Owner);
  case Src.Name of
     'mfun0', 'mfun', 'mtoggletool', 'mbrowser', 'mLayout', 'mtogglesidebar', 'mtoggletoolbar', 'mtoggletabbar':
     begin
     Result.Visible:=false;
     Result.Enabled:=false;
     end;
  end;
  {$IFNDEF MSWINDOWS}
  case Src.Name of
     'mthumbimages', 'mscheduledscripts', 'mtaskscheduler', 'MenuItem11', 'mAdmin', 'mUser', 'MenuItem33', 'w7contextlang', 'mSystemIntegration':
     begin
     Result.Visible:=false;
     Result.Enabled:=false;
     end;
  end;
  {$ENDIF}
  Result.Caption:=Src.Caption;
  if Result.Caption='' then Result.Visible:=False;
  Result.OnClick:=Src.OnClick;
  Result.Tag:=Src.Tag;
  Result.Checked:=Src.Checked;
  Result.RadioItem:=Src.RadioItem;
  //Result.Visible:=Src.Visible;
  //Result.Enabled:=Src.Enabled;
  Result.Bitmap:=Src.Bitmap;
  for i:=0 to Src.Count-1 do
     Result.Add(CloneMenuItem(Src[i]));
end;

procedure CopyMenu(Src, Dst: TMenu);
var
  i: Integer;
begin
  Dst.Items.Clear;
  Dst.Items.Add(CloneMenuItem(Form_peach.pmshowstylemenu));
  Dst.Items.Add(CloneMenuItem(Form_peach.Separator7));
  for i:=0 to Src.Items.Count-1 do
    Dst.Items.Add(CloneMenuItem(Src.Items[i]));
end;

{///////////////////////////////////////////////////////////////////////////////

custom tabs

///////////////////////////////////////////////////////////////////////////////}

//general tabs
procedure exitlabel(var a: TLabel; var b:TShape);
begin
b.Brush.Color:=tabbrushcol;
b.Pen.Color:=tabpencol;
b.Pen.Style:=psSolid;
if (highlighttabs=1) or (highlighttabs=4) or (highlighttabs=5) then a.Font.Color:=clDefault else a.Font.Color:=pGray;
if alttabstyle=1 then a.Font.Style:=[];
end;

procedure clicklabel(var a: TLabel; var b:TShape);
begin
if (alttabstyle=1) and ((highlighttabs=1) or (highlighttabs=4) or (highlighttabs=5)) then a.Font.Color:=ptextaccent else a.Font.Color:=clDefault;
if alttabstyle=1 then a.Font.Style:=[fsUnderline];
b.Brush.Color:=StringToColor(color2);
b.Pen.Color:=tabpencol;
b.Pen.Style:=psSolid;
end;

procedure enterlabel(var a: TLabel; var b:TShape);
begin
b.Brush.Color:=tabbrushhighcol;
b.Pen.Color:=tabpencol;
b.Pen.Style:=psSolid;
if alttabstyle=1 then a.Font.Style:=[fsUnderline] else a.Font.Color:=clDefault;
end;

///add
procedure exitlabel_add(var a: TLabel; var b:TShape);
begin
if activelabel_add=a then exit;
exitlabel(a,b);
end;

procedure deselectlabels_add;
begin
with Form_peach do
begin
exitlabel_add(LabelTitleAdd1,ShapeTitleAddb1);
exitlabel_add(LabelTitleAdd2,ShapeTitleAddb2);
exitlabel_add(LabelTitleAdd3,ShapeTitleAddb3);
exitlabel_add(LabelTitleAdd4,ShapeTitleAddb4);
end;
end;

procedure setlabelpanel_add(var a: Tlabel);
begin
with Form_peach do
begin
if a = LabelTitleAdd1 then setpanel_add(1);
if a = LabelTitleAdd2 then setpanel_add(2);
if a = LabelTitleAdd3 then setpanel_add(3);
if a = LabelTitleAdd4 then setpanel_add(4);
end;
end;

procedure clicklabel_add(var a: TLabel; var b:TShape);
begin
activelabel_add:=a;
deselectlabels_add;
clicklabel(a,b);
setlabelpanel_add(a);
end;

procedure enterlabel_add(var a: TLabel; var b:TShape);
begin
if activelabel_add=a then exit;
enterlabel(a,b);
end;

///extract
procedure exitlabel_extract(var a: TLabel; var b:TShape);
begin
if activelabel_extract=a then exit;
exitlabel(a,b);
end;

procedure deselectlabels_extract;
begin
with Form_peach do
begin
exitlabel_extract(LabelTitleextract1,ShapeTitleextractb1);
exitlabel_extract(LabelTitleextract2,ShapeTitleextractb2);
exitlabel_extract(LabelTitleextract3,ShapeTitleextractb3);
exitlabel_extract(LabelTitleextract4,ShapeTitleextractb4);
end;
end;

procedure setlabelpanel_extract(var a: Tlabel);
begin
with Form_peach do
begin
if a = LabelTitleextract1 then setpanel_extract(1);
if a = LabelTitleextract2 then setpanel_extract(2);
if a = LabelTitleextract3 then setpanel_extract(3);
if a = LabelTitleextract4 then setpanel_extract(4);
end;
end;

procedure clicklabel_extract(var a: TLabel; var b:TShape);
begin
activelabel_extract:=a;
deselectlabels_extract;
clicklabel(a,b);
setlabelpanel_extract(a);
end;

procedure enterlabel_extract(var a: TLabel; var b:TShape);
begin
if activelabel_extract=a then exit;
enterlabel(a,b);
end;

///apps subpage
procedure exitlabel_apps(var a: TLabel; var b:TShape);
begin
if activelabel_apps=a then exit;
exitlabel(a,b);
end;

procedure deselectlabels_apps;
begin
with Form_peach do
begin
exitlabel_apps(LabelTitleapps1,ShapeTitleAppsb1);
exitlabel_apps(LabelTitleapps2,ShapeTitleAppsb2);
end;
end;

procedure setpanel_apps(i:integer);
begin
case i of
   1: begin
   Form_peach.PanelApps1.Visible:=true;
   Form_peach.PanelApps2.Visible:=false;
   end;
   2: begin
   Form_peach.PanelApps1.Visible:=false;
   Form_peach.PanelApps2.Visible:=true;
   end;
end;
end;

procedure setlabelpanel_apps(var a: Tlabel);
begin
with Form_peach do
begin
if a = LabelTitleapps1 then setpanel_apps(1);
if a = LabelTitleapps2 then setpanel_apps(2);
end;
end;

procedure clicklabel_apps(var a: TLabel; var b:TShape);
begin
activelabel_apps:=a;
deselectlabels_apps;
clicklabel(a,b);
setlabelpanel_apps(a);
end;

procedure enterlabel_apps(var a: TLabel; var b:TShape);
begin
if activelabel_apps=a then exit;
enterlabel(a,b);
end;

///options
procedure exitlabel_options(var a: TLabel; var b: TPanel);
begin
if activelabel_options=a then exit;
if ((highlighttabs=4) or (highlighttabs=5)) then a.Font.Color:=clDefault else a.Font.Color:=pGray;
b.Color:=Form_peach.PanelTitleOptions.Color;
end;

procedure deselectlabels_options;
begin
with Form_peach do
begin
exitlabel_options(LabelTitleoptions1,BevelTitleoptions1);
exitlabel_options(LabelTitleoptions2,BevelTitleoptions2);
exitlabel_options(LabelTitleoptions3,BevelTitleoptions3);
exitlabel_options(LabelTitleoptions4,BevelTitleoptions4);
exitlabel_options(LabelTitleoptions5,BevelTitleoptions5);
exitlabel_options(LabelTitleoptions6,BevelTitleoptions6);
exitlabel_options(LabelTitleoptions7,BevelTitleoptions7);
exitlabel_options(LabelTitleoptions8,BevelTitleoptions8);
end;
end;

procedure updatepluginstatus;
begin
if fileexists(binpath+'unrar'+DirectorySeparator+UNRARNAME+EXEEXT) then
   begin
   unrar5pluginstatus:=txt_5_7_pinstalled;
   Form_peach.baboutremoveunrar.Visible:=true;
   end
else
   begin
   unrar5pluginstatus:=txt_5_7_pmissing;
   Form_peach.baboutremoveunrar.Visible:=false;
   end;
if fileexists(binpath+'unace'+DirectorySeparator+'unace'+EXEEXT) then
   begin
   unacepluginstatus:=txt_5_7_pinstalled;
   Form_peach.baboutremoveunace.Visible:=true;
   end
else
   begin
   unacepluginstatus:=txt_5_7_pmissing;
   Form_peach.baboutremoveunace.Visible:=false;
   end;
if fileexists(binpath+'lpaq'+DirectorySeparator+'lpaq1'+EXEEXT) then
addformatspluginstatus:=txt_5_7_pinstalled
else
addformatspluginstatus:=txt_5_7_pmissing;
Form_peach.Labelabout1.caption:='PeaZip '+txt_release+' '+PEAZIPVERSION+PEAZIPREVISION+' - '+caption_build+char($0d)+char($0a)
        +txt_license+' LGPLv3, '+txt_projectadmin+' Giorgio Tani'+char($0d)+char($0a)
        +char($0d)+char($0a)
        +langstrhint+char($0d)+char($0a)
        +char($0d)+char($0a)
        +txt_using+char($0d)+char($0a)
        +APPLICATION1+char($0d)+char($0a)
        +APPLICATION2+char($0d)+char($0a)
        +APPLICATION3+char($0d)+char($0a)
        +APPLICATION4+char($0d)+char($0a)
        +APPLICATION5+char($0d)+char($0a)
        +APPLICATION7+char($0d)+char($0a)
        +APPLICATION9+char($0d)+char($0a)
        +APPLICATION10+char($0d)+char($0a)
        +char($0d)+char($0a)
        +'Plugin:'+char($0d)+char($0a)
        +'PeaZip Additional Formats Plugin (LGPLv3) - '+addformatspluginstatus+char($0d)+char($0a)
        +APPLICATION6+' - '+unacepluginstatus+char($0d)+char($0a)
        +APPLICATION8+' - '+unrar5pluginstatus+char($0d)+char($0a);
end;

procedure setlabelpanel_options(var a: Tlabel);
begin
with Form_peach do
begin
if a = LabelTitleoptions1 then PageOpt1.Visible:=true else PageOpt1.Visible:=false;
if a = LabelTitleoptions2 then PageOpt2.Visible:=true else PageOpt2.Visible:=false;
if a = LabelTitleoptions3 then PageOpt3.Visible:=true else PageOpt3.Visible:=false;
if a = LabelTitleoptions4 then PageOpt4.Visible:=true else PageOpt4.Visible:=false;
if a = LabelTitleoptions5 then PageOpt5.Visible:=true else PageOpt5.Visible:=false;
if a = LabelTitleoptions6 then PageOpt6.Visible:=true else PageOpt6.Visible:=false;
if a = LabelTitleoptions7 then PageOpt7.Visible:=true else PageOpt7.Visible:=false;
if a = LabelTitleoptions8 then begin PageOpt8.Visible:=true; updatepluginstatus; end else PageOpt8.Visible:=false;
end;
end;

procedure clicklabel_options(var a: TLabel; var b: TPanel);
begin
activelabel_options:=a;
deselectlabels_options;
a.Font.Color:=clDefault;
b.Color:=tabbrushcol;//pvlblue;
setlabelpanel_options(a);
end;

procedure enterlabel_options(var a: TLabel; var b: TPanel);
begin
if activelabel_options=a then exit;
a.Font.Color:=clDefault;
b.Color:=tabbrushhighcol;//pvvlblue;
end;

{///////////////////////////////////////////////////////////////////////////////

text and translation

///////////////////////////////////////////////////////////////////////////////}

function valorize_text:integer;
var
   s:ansistring;
begin
valorize_text:=-1;
try
readln(t,s);
readln(t,s); txt_9_1_7zs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_ac:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_closeall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_enlargeicons:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_ef:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_nw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_qdup:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_autoexttar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_accesstime:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_mem:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_showmainmenu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_navmenu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_plugind:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_df:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_hl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_sl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_tnav:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_empty:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_disp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_parsing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_stoptest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_ttb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_ca:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_btn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_cb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_centered:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_light:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_lnk:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_intnote:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_snz:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_sm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_solcol:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_snoi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_snon:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_tab:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_altt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_autotest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_cw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_csvhelp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_after:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_bintest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_csv:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_hok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_mo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_showhm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_showsearchbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_showsm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_hnotok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_verifybin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_clear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_noclear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_nosimple:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_immediate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_yessimple:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_advbrowser:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_detailslarge:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_intext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_listlarge:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_loadlayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_samplescripts:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_4_keepopenerrorslist:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_mbubin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_cw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_temperature:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_mbudec:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_htab:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_maxarg:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_mbu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_prefalgo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_skipdel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_lw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_noupx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_slower:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_df:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_vreport:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_ta:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_tc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_keep:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_tm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_skipet:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_alltimes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_supportedby:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_preparse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_bo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_bop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_nopreparse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_ed:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_togglearc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_preparsehint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_slow:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_vslow:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_volumes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_altcol:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_forcebrowse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_commonalgo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_forceconvert:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_defaultactionhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_defaultaction:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_enableextand:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_forcetyping:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_setpwopt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_forcetypinghelp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_9_spacing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_9_zooming:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_changelocalization:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_custext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_destexistfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_dd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_priorityhigh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_priorityidle:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_rel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_prioritynormal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_priorityrealtime:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_requirerestart:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_tpriority:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_update:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_noneall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_nonetemp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_outtemp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_sys7zreq:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_tw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_sys7z:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_zipenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_color:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_custenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_dark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_tno:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_forcelocalenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_forceutf8enc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_cpnote:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_defaultenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_dim:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_setcurdef:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_setdef:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_tadvanced:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_tsimple:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_tacolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_always:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_ask:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_autoclosesingle:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_cutlen:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_cutlenw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_dragnone:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_specialbrowse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_ee:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_draghide:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_draglh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_draglock:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_never:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_repnascii:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_comment:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_7zfbrotlicomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_7zfzstandardcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_presetrar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_tkeep:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_lock:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_locked:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_lockconfirm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_recover:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_tcurr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_setarc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_setext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_swzipx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_archiveerrors:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_archiveerrorshint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_clickextall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_noconfdel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_profile7zfastest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_maxbr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_maxzstd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_profile7zfast:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_stl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_altcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_clearnoupdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_autoclosepeazip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_zpaqall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_extcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_extcompultra:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_fbrotlicomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_fzstandardcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_loadcompsettings:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_savecompsettings:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_source:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_updateclear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_type_description_brotli:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_new:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_smart:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_profileintermediate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_renfilesonly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_typetosearch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_type_description_zstd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_0_af:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_0_autoopentar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_0_exttmppath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_autou:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_forceu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_opuns:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_overarch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_uconf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_8_ndrop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_7_nop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_6_pdupfound:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_6_rsh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_6_pdupfind:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_6_forcemodify:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_mandatory:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_abort:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_askp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_chp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_def:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_nop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_seqerr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_sni:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_sns:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_privacy:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_showvolatile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_force:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_warning:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_yes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_yesall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_np:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_absolute:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_appdirn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_closeallother:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_closeright:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_collapse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_expand:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_full:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_new:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_openintab:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_paths:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_prepdirn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_relative:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_tabbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_3_autoadjust:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_3_cinfo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_3_syn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_3_uar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_2_encext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_2_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_2_container:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_1_ec:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_0_msq:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_9_lff:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_9_pff:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_9_start:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_l0:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_l1:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_l2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_ascii:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_cp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_fs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_utf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_fsr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_7_pinstalled:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_7_pmissing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_7_plugin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_basic:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_exarc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_tab:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_rc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_layouts:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_upexisting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_verbose:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_case:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_add:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_addsel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_ext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_plugin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_copypath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_delete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_halt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_positionw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_positionwd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_replaceneww:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_lower:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_replaceoldw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_newext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_new:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_n:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_old:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_position:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_intdir:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_replacestr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesameday:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesamehour:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesamemonth:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesameweek:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesameyear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_scan:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_select:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_similar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_starting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_string:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_subtractsel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datehour:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datemonth:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_dateweek:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_dateyear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_dateday:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_upper:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_extw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_da:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deletearchives:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deletefiles:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deleteoriginal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_lv:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deletearchivesconfirm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deletefilesconfirm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_used:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profilebest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profileadvanced:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profilenormal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profileveryfast:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profilepassword:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profile10mb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profilesfx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_cml:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_cmlmessage:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_exc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_ia:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_io:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_rec:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_resetsi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_oadd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_zerodelete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_zfree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_sdfree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_oext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_securedeletefree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_free:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_zerofiles:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_zerofree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedadd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schederr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_daily:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_day:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_days:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_enddate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_every:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w6:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_hourly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_hours:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_last:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedmanage:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_scriptmanage:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_monthly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_months:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_onlogin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_onstart:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_once:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w7:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedule:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedexplain:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedscripts:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_startdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_starttime:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w1:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedname:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_ts:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w5:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w3:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w4:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_weekly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_weeks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_bc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_resetpm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_enum:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_music:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_ps:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_perf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_pictures:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_removeall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_resetbookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_sh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_skip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_videos:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_9_frame:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_9_listth:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_9_shadow:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_9_style:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_attach25:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_crop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_detailsno:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_details:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_fit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_fitl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_flip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_fullscreen:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_fun:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_h:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_keeparchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_noresize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_iconl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_iconm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_imagemanager:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_immersive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_listno:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_aspect:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_mirror:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_presets:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_replace:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_resize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_rl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_rr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_stop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_t:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_w:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_pk:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_spchar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_recycleask:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_recycle:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_pcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_6_am:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_6_fm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_6_users:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_goupdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_b:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_koupdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_update:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_dock:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_l:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_noupdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_properties:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_r:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_pj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_shaddress:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_shnav:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_shstatus:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_shtool:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_upxpj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_t:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_4_confremoveall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_4_confremove:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmanhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_exppl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_expple:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_keeppw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmanpwhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmanmaster:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmanlist:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwman:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmancorr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_expplp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_recsrc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_resetpm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_breadcrumb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_2_arcabspath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_duplicateshint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_adminhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_selected:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_duplicatesfound:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_duplicatesfind:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_runasadmin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_simplesearch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_0_thim:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_8_type_description_wim:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_8_type_description_xz:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_donations:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_nameasparent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_tracker:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_sort:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_swapbars:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_themedbars:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_6_ignoredd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_6_close:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_6_resetapps:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_6_ethemes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_5_td:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_5_managecustomthemes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_4_nopaths:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_4_smallicons:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_skipunits:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_stralt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_apps:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_multi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_runexp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_apppath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_run:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_2_7zutf8nonascii:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_2_alltasks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_2_conf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_2_donations:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_sccenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_downloads:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_lib:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_more:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_openasarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_sendto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_pathexc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_recent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_plsmartmin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_src:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_systmp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_languagetools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_workingdir:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_0_nonreadableorpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_0_readablepw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_0_configure:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_0_resettmp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_address:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_adv:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_columns:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_copyhere:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_noscan:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_extconsole:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_thl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_home:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_lt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_mt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_movehere:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_nav:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_navbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_none:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_organize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_public:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_rec:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_selected:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_setapps:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_showmenu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_st:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_test_pw2G:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_vst:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_toolbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_tree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_views:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_experimental:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_zcopy:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_addvol:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_uniterror:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_cannotconvert:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convertbegin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convert:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convertexisting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convertdelete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_details:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_parallel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convertnote:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_custom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_unitrecommend:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_viewasarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_nounit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_rowselect:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_statusbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_typeunit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_usedefaultoutpath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_experimental:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_optional:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_list_tryflatorpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_separate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_pwsupported:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_cancel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_encfn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_setpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_ext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_extfrom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_es:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_eu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_clipboard:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_goarclayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_goextlayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_ok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_drag_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_oop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_validatefn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_validatecl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_output:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_pwnotset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_pwarcset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_pwextset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_archivehint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_exthint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_setadvf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_selpath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_separateerror:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_noinput:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_dirsize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_un7z_browse_flat:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_updating:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_6_folders:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_6_advanced:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_6_plalways:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_6_plsmart:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_sessionio:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_advanced:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_basic:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_cannotrun:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_custeditors:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_delete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_delete_fromarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_langflag:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_encpj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_execommand:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_help:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_langhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_mini_help:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_offline_help:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_tray:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_remove:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_hintpaths:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_selectapp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_strafter:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_strbefore:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_encoding:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_nopw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_draghint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_tb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_adding:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_advclip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_yanswers:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_itemsheight:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_clearclipboard:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wcommons:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_copyfrom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_deletebookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_documents:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_extractfrom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_hexp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_operation:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_removefromclipboard:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_stdclip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_totalmem:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_gvideo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wbook:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wnews:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wsrc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wdict:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_pw_errorchar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_envstr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_never_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_home:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_on_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_test_pw100:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_test_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exclude_recourse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_action_extopen:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_passwordnotmatch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_action_preview:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_preview_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_better:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_faster:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fastermem:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_tempdir:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_stream:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_slowermem:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_store:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_newfolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcodeunknown:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_isfolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s)); if txt_list_isfolder[1]<>' ' then txt_list_isfolder:=' '+txt_list_isfolder;
readln(t,s); txt_none:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode1:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_attach10:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode255:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fat32:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dvd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_attach5:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cd650:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode7:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cd700:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_7z:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dvddl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode8:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_abort:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_about:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_action:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_action_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_existing_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_files:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_folder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_tolayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_toarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_tobookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_address_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_adv_filters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_algo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_default:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_type:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_date:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_psize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_attributes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_input_upx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_always_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ignore_ext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ignore_disp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ignore_sel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_key_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_timestamp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_appoptions:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_arc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_browse_ok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_interface:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archivecreation:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_tarbefore_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archive_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compressionratio_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archiving:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cl_long:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_overwrite_askbefore:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_associated:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_attributes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_author:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ren_existing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ren_extracted:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_autofolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_back:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_backend:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_backupexe:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_bettercompression:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_blogs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_blowfish:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_bookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_browse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_browser:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_aborted_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_browsing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archive_root:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_bzip2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pw_empty:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_browse_failure:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_conf_cannotsave:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_check_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_check:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_check_select:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_clear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_clearlayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pj_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_autoclose:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compare:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compress:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compress_executable:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compress_openforwriting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compression:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compmanagement:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pw_confirm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_console:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_console_interface:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_content:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_controlpanel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_convert:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_copy:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_copyto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_title_create:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_keyfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_folder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_theme:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_rr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_sfx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cr_current:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_custom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_custom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_customapp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_custom_parameters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_customsize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cut:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_datetime:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default_compression:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default_format:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme_default:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_hard_reset_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_desktop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dictionary:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dirs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dis:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_disk_cleanup:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_disk_defrag:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_disk_management:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dispaly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_displayedmnu_obj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_displayedobjects:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nocompress:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_delete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_wipe:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_done:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_edit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_elapsed:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_emptycl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_encrypt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_encrypted:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_encryption:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_note:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_random_keys:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_random_keys_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ent_tools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_eqorlarger:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_eqorrecent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_eqorolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_eqorsmaller:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_equal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_erase_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extraction_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exclude_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exclusion_recourse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exclusion:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exe:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_overwrite_qry:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_confirm_overwrite:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_explore_outpath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_explore_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_caption_extract:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_nopath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_all:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_allhere:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_allto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extopen_custom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extopen_with:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_disp_here:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_disp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_disp_to:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_here:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_sel_here:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_sel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_sel_to:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extobj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_newfoldermenu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_fast:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fastcompr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fastopen:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_fastest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_favformats:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_file:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filebrowser:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filetools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_files:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nfiles:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filters_recourse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_flat:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_flat:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_floppy:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_foldername:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nfolders:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_input_multi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fwd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_found:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_free:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_free2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_name_full:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_function:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_general:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_multithreading:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_go_browser:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_go_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_guicl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_guipealauncher:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_graphic:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_gridaltcolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_gridrowheight:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_gui:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_gzip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_here:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_history:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_homeroot:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_quickbrowse_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_backupexe_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_attach:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_images:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_include_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filters_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_inclusion_recourse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_inclusion:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_function:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_info:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_infoall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_infodisp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_infosel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_inputinfo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_input_list:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_iop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ipo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_input:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_integrity:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_chunk_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_invertsel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_exe:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_return_to_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_not_accessible:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_unsupported:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_checkname_failed:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_not_accessible_list:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme_create_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme_exists:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_job_code:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_job_definition_saved:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_job_success:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_join:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_joinfiles:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_keyfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_keyfile_not_found:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_keyfile_notcreated:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_larger:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_lastused:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_launch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_layout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filelist_savedas:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_license:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_caption_list:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_details:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_all:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_disp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_sel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_toggle_warning:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_loadfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_loadlayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_hd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_localization:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_lpaqver:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_lpaq:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_maininterface:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_maxcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_maximum:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_restartrequired:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_required_memory:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_method:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_misc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_modify:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_morecontrols:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_morerecent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ent_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_moveto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_mypc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_na:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_name:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_naming:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_remote:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_newarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cnewfolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_news:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_no:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_noinput:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nocompress_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_split_noinput:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_noinput:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_nomatch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_singlethread:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_none2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nonsolid:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_normal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_copy_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_description:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compare_second:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_peaobj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_displayed_obj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_olderthan:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_on:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ondblclick:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_opacity:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_openarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_title_open:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_bookmark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cphere:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_file:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_files:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_opensource:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_openwith:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_aborted:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_cd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_options:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_other:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_otherparams:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_oip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_opi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_output:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_overwrite:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compressed_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_paqver:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_paq:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pio:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_poi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_parameters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_partial:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_passes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pwlength:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_browse_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_browse_pw_other:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_paste:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pea_appcolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pea_textcolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_pea:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_peazip_new:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_peazip_help:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_peazip_web:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_performall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_name_provide:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_upxorstrip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_not_removable_file:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_not_removable:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_custom_executable_missing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_unsupported_select:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_no_theme_name:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_please_wait:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_copy_wait:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_previewwith:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_projectadmin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_quad:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_quickdelete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_quit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_ram:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_read:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_recentarchives:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_rr_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_search_refine:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fefreshf5:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_release:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_removable:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_remove_bookmark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_remove_external_unit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_removeselected:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_rename:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_caption_repair:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_restartrequired2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_reset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_reset_archivename:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_hardreset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_reset_theme:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_restore_att:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_run_as:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_run_as2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sample:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_saveas:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savehistory:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_save_infolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savejob:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savejobdefinition:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savejobdefinition_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savelayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_save_winstate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_search:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_searchanddrag:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_searchfor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nrsearch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_search_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_search_web:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_searching:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_securedelete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default_description:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_selectall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_selectdir:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_selected_obj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_selected_objects:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sfx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sendbymail:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_set_defaults:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_settings:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sfx_interface:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_showhints:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_show_messages:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_showpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_singlevol:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sizeb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_skip_existing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_slowercomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_smaller:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_solid:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_solid_block:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_solid_auto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_solid_extension:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_listtest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sortbysel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_sorting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_speed:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_split:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_split:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_split_file:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_nostats:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_status:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_store:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_stream_control:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_strip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_keyfile_created:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_suggestpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_noupx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_syntax:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sysbenchmark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_benchmark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_systools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_tarbefore:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_tar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_taskman:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_caption_test:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_testall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_testdisp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_testpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_testsel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_col_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_bookmarks_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archive_noinput_tolist:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_icons_found:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_themename:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_icons_not_found:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme_create_success:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theming:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extand_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_threads:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_titlescolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_to:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_toggle_browseflat:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_toggle_historybookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_toolbarscolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_tools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_best:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_ultra:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_openfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cl_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ace_missing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_units:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_unknown:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_pw_untested:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_up:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_update:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_upx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_advfilters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_openfiles_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_usenet:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_user_name:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_using:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_volumepea:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_volume_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_ext_uns:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_websearch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_websites:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_word:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_write:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ramdompw_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exe_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pj_hint2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_zip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_zipcrypto_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s);
readln(t,s); if s<>'=== end PeaZip text group ===' then exit;
valorize_text:=0;
except
valorize_text:=-1;
end;
end;

procedure psetbuttonwidth(var btt:TSpeedButton; rsize:integer; ontheleft:boolean);
var w,h:integer;
begin
Form_peach.labelbsize.Caption:=btt.Caption;
Form_peach.labelbsize.GetPreferredSize(w,h,false,true);
Form_peach.labelbsize.Caption:='';
if ontheleft=true then w:=w+rsize*2+6
else w:=w+rsize+6;
if w<rsize*3 then w:=rsize*3;
btt.Width:=w;
end;

procedure settoolglyphtop;
begin
with Form_peach do
begin
ButtonUn7za1.Layout:=blGlyphTop;
ButtonUn7za4.Layout:=blGlyphTop;
ButtonUn7zaTo.Layout:=blGlyphTop;
ButtonUn7za5.Layout:=blGlyphTop;
ButtonCut.Layout:=blGlyphTop;
ButtonCopy.Layout:=blGlyphTop;
ButtonPaste.Layout:=blGlyphTop;
ButtonOpenWith.Layout:=blGlyphTop;
ButtonProperties.Layout:=blGlyphTop;
ButtonRename.Layout:=blGlyphTop;
ButtonRename1.Layout:=blGlyphTop;
ButtonDelete.Layout:=blGlyphTop;
ButtonDup.Layout:=blGlyphTop;
ButtonNF.Layout:=blGlyphTop;
ButtonDup1.Layout:=blGlyphTop;
ButtonImgResize.Layout:=blGlyphTop;
ButtonImgCrop.Layout:=blGlyphTop;
ButtonImgRL.Layout:=blGlyphTop;
ButtonImgRR.Layout:=blGlyphTop;
end;
end;

procedure settoolglyphleft;
begin
with Form_peach do
begin
ButtonUn7za1.Layout:=blGlyphLeft;
ButtonUn7za4.Layout:=blGlyphLeft;
ButtonUn7zaTo.Layout:=blGlyphLeft;
ButtonUn7za5.Layout:=blGlyphLeft;
ButtonCut.Layout:=blGlyphLeft;
ButtonCopy.Layout:=blGlyphLeft;
ButtonPaste.Layout:=blGlyphLeft;
ButtonOpenWith.Layout:=blGlyphLeft;
ButtonProperties.Layout:=blGlyphLeft;
ButtonRename.Layout:=blGlyphLeft;
ButtonRename1.Layout:=blGlyphLeft;
ButtonDelete.Layout:=blGlyphLeft;
ButtonDup.Layout:=blGlyphLeft;
ButtonNF.Layout:=blGlyphLeft;
ButtonDup1.Layout:=blGlyphLeft;
ButtonImgResize.Layout:=blGlyphLeft;
ButtonImgCrop.Layout:=blGlyphLeft;
ButtonImgRL.Layout:=blGlyphLeft;
ButtonImgRR.Layout:=blGlyphLeft;
end;
end;

procedure settoolmargin;
begin
with Form_peach do
begin
ButtonUn7za1.Margin:=-1;
ButtonUn7za4.Margin:=-1;
ButtonUn7zaTo.Margin:=-1;
ButtonUn7za5.Margin:=-1;
ButtonCut.Margin:=-1;
ButtonCopy.Margin:=-1;
ButtonPaste.Margin:=-1;
ButtonOpenWith.Margin:=-1;
ButtonProperties.Margin:=-1;
ButtonRename.Margin:=-1;
ButtonRename1.Margin:=-1;
ButtonDelete.Margin:=-1;
ButtonDup.Margin:=-1;
ButtonNF.Margin:=-1;
ButtonDup1.Margin:=-1;
ButtonImgResize.Margin:=-1;
ButtonImgCrop.Margin:=-1;
ButtonImgRL.Margin:=-1;
ButtonImgRR.Margin:=-1;
end;
end;

procedure settoolspacing(n:integer);
begin
with Form_peach do
begin
ButtonUn7za1.Spacing:=n;
ButtonUn7za4.Spacing:=n;
ButtonUn7zaTo.Spacing:=n;
ButtonUn7za5.Spacing:=n;
ButtonCut.Spacing:=n;
ButtonCopy.Spacing:=n;
ButtonPaste.Spacing:=n;
ButtonOpenWith.Spacing:=n;
ButtonProperties.Spacing:=n;
ButtonRename.Spacing:=n;
ButtonRename1.Spacing:=n;
ButtonDelete.Spacing:=n;
ButtonDup.Spacing:=n;
ButtonNF.Spacing:=n;
ButtonDup1.Spacing:=n;
ButtonImgResize.Spacing:=n;
ButtonImgCrop.Spacing:=n;
ButtonImgRL.Spacing:=n;
ButtonImgRR.Spacing:=n;
end;
end;

procedure settoolbigicon;
begin
with Form_peach do
begin
ButtonUn7za1.Glyph:=Btestall_big;
ButtonUn7za4.Glyph:=Barchive_big;
ButtonUn7zaTo.Glyph:=Bextractall_big;
ButtonUn7za5.Glyph:=Bconvert_big;
ButtonCut.Glyph:=BTool_cut;
ButtonCopy.Glyph:=BTool_copy;
ButtonPaste.Glyph:=BTool_paste;
ButtonOpenWith.Glyph:=BTool_openw;
ButtonProperties.Glyph:=BTool_properties;
ButtonRename.Glyph:=BTool_rename;
ButtonRename1.Glyph:=BTool_rename;
ButtonDelete.Glyph:=BTool_delete;
ButtonDup.Glyph:=BTool_dup;
ButtonNF.Glyph:=Bdetailsfs;
ButtonDup1.Glyph:=BTool_dup;
ButtonImgResize.Glyph:=BTool_resize;
ButtonImgCrop.Glyph:=BTool_crop;
ButtonImgRL.Glyph:=BTool_rl;
ButtonImgRR.Glyph:=BTool_rr;
end;
end;

procedure settoolsmallicon;
begin
with Form_peach do
begin
ButtonUn7za1.Glyph:=Btestall;
ButtonUn7za4.Glyph:=Barchive;
ButtonUn7zaTo.Glyph:=Bextractall;
ButtonUn7za5.Glyph:=Bconvert;
ButtonCut.Glyph:=BTool_cut_small;
ButtonCopy.Glyph:=BTool_copy_small;
ButtonPaste.Glyph:=Bloadlayout;
ButtonOpenWith.Glyph:=Bapps;
ButtonProperties.Glyph:=BTool_properties_small;
ButtonRename.Glyph:=BTool_rename_small;
ButtonRename1.Glyph:=BTool_rename_small;
ButtonDelete.Glyph:=Bstop;
ButtonDup.Glyph:=BTool_dup_small;
ButtonNF.Glyph:=BFolder;
ButtonDup1.Glyph:=BTool_dup_small;
ButtonImgResize.Glyph:=BTool_resize_small;
ButtonImgCrop.Glyph:=BTool_crop_small;
ButtonImgRL.Glyph:=BTool_rl_small;
ButtonImgRR.Glyph:=BTool_rr_small;
end;
end;

procedure settooltext;
begin
with Form_peach do
begin
ButtonUn7zaTo.Caption:=txt_caption_extract;
ButtonUn7za1.Caption:=txt_caption_test;
ButtonUn7za4.Caption:=txt_add;
pmttitle.Caption:=txt_add;
pmtypeswap.Caption:=txt_add+' <> '+txt_2_8_convert;
ButtonUn7za5.Caption:=txt_2_8_convert;
ButtonCut.Caption:=txt_cut;
ButtonCopy.Caption:=txt_copy;
ButtonPaste.Caption:=txt_paste;
ButtonProperties.Caption:=txt_4_5_properties;
ButtonRename.Caption:=txt_rename;
ButtonRename1.Caption:=txt_rename;
ButtonDup.Caption:=txt_4_1_duplicatesfind;
ButtonNF.Caption:=txt_cnewfolder;
ButtonDup1.Caption:=txt_4_1_duplicatesfind;
ButtonImgResize.Caption:=txt_4_8_t;
ButtonImgCrop.Caption:=txt_4_8_crop;
ButtonImgRL.Caption:=txt_4_8_rl;
ButtonImgRR.Caption:=txt_4_8_rr;
ButtonCut.Hint:='';
ButtonCopy.Hint:='';
ButtonPaste.Hint:='';
ButtonOpenWith.Hint:='';
ButtonProperties.Hint:='';
ButtonRename.Hint:='';
ButtonRename1.Hint:='';
ButtonDelete.Hint:='';
ButtonDup.Hint:='';
ButtonNF.Hint:='';
ButtonDup1.Hint:='';
ButtonImgResize.Hint:='';
ButtonImgCrop.Hint:='';
ButtonImgRL.Hint:='';
ButtonImgRR.Hint:='';
end;
end;

procedure settoolbtnw(refw:integer; glyph_on_side:boolean);
begin
with Form_peach do
begin
psetbuttonwidth(ButtonUn7zato,refw,glyph_on_side);
psetbuttonwidth(ButtonUn7za1,refw,glyph_on_side);
psetbuttonwidth(ButtonUn7za4,refw,glyph_on_side);
psetbuttonwidth(ButtonUn7za5,refw,glyph_on_side);
ButtonUn7za6.Width:=imagelistroot.width;
ButtonUn7za7.Width:=imagelistroot.width;
ButtonUn7za8.Width:=imagelistroot.width;
ButtonUn7za11.Width:=imagelistroot.width;
ButtonUn7za9.Width:=imagelistroot.width;
//filemanager
psetbuttonwidth(ButtonCut,refw,glyph_on_side);
psetbuttonwidth(ButtonCopy,refw,glyph_on_side);
psetbuttonwidth(ButtonPaste,refw,glyph_on_side);
psetbuttonwidth(ButtonOpenWith,refw,glyph_on_side);
psetbuttonwidth(ButtonProperties,refw,glyph_on_side);
psetbuttonwidth(ButtonRename,refw,glyph_on_side);
psetbuttonwidth(ButtonDelete,refw,glyph_on_side);
psetbuttonwidth(ButtonDup,refw,glyph_on_side);
psetbuttonwidth(ButtonNF,refw,glyph_on_side);
Buttoncmto.Width:=imagelistroot.width;
Buttonopenactions.Width:=imagelistroot.width;
Buttonfmactions.Width:=imagelistroot.width;
Buttonfmactions1.Width:=imagelistroot.width;
//imageviewer
psetbuttonwidth(ButtonDup1,refw,glyph_on_side);
psetbuttonwidth(ButtonRename1,refw,glyph_on_side);
psetbuttonwidth(ButtonImgResize,refw,glyph_on_side);
psetbuttonwidth(ButtonImgCrop,refw,glyph_on_side);
psetbuttonwidth(ButtonImgRL,refw,glyph_on_side);
psetbuttonwidth(ButtonImgRR,refw,glyph_on_side);
ButtonImg6.Width:=imagelistroot.width;
ButtonImgR.Width:=imagelistroot.width;
ButtonImgRes.Width:=imagelistroot.width;
end;
end;

procedure settoolbtnwfixed;
begin
with Form_peach do
begin
ButtonUn7zaTo.Width:=ctrlback.width;
ButtonUn7za1.Width:=ctrlback.width;
ButtonUn7za4.Width:=ctrlback.width;
ButtonUn7za5.Width:=ctrlback.width;
ButtonUn7za6.Width:=imagelistroot.width;
ButtonUn7za7.Width:=imagelistroot.width;
ButtonUn7za8.Width:=imagelistroot.width;
ButtonUn7za11.Width:=imagelistroot.width;
ButtonUn7za9.Width:=imagelistroot.width;
//filemanager
ButtonCut.Width:=ctrlback.width;
ButtonCopy.Width:=ctrlback.width;
ButtonPaste.Width:=ctrlback.width;
ButtonOpenWith.Width:=ctrlback.width;
ButtonProperties.Width:=ctrlback.width;
ButtonRename.Width:=ctrlback.width;
ButtonDelete.Width:=ctrlback.width;
ButtonDup.Width:=ctrlback.width;
ButtonNF.Width:=ctrlback.width;
Buttoncmto.Width:=imagelistroot.width;
Buttonopenactions.Width:=imagelistroot.width;
Buttonfmactions.Width:=imagelistroot.width;
Buttonfmactions1.Width:=imagelistroot.width;
//imageviewer
ButtonDup1.Width:=ctrlback.width;
ButtonRename1.Width:=ctrlback.width;
ButtonImgResize.Width:=ctrlback.width;
ButtonImgCrop.Width:=ctrlback.width;
ButtonImgRL.Width:=ctrlback.width;
ButtonImgRR.Width:=ctrlback.width;
ButtonImg6.Width:=imagelistroot.width;
ButtonImgR.Width:=imagelistroot.width;
ButtonImgRes.Width:=imagelistroot.width;
end;
end;

{procedure setlargetoolbar1;
var bheight:longint;
begin
with Form_peach do
begin
bheight:=lbarheight;
PanelBarOpen.Height:=bheight;
PanelBarOpen2.Height:=bheight;
PanelBarOpen3.Height:=bheight;
settoolglyphtop;
settoolmargin;
settoolspacing(1);
settoolbigicon;
settooltext;
settoolbtnw((20*qscaleimages) div 100,false);
end;
toolsize:=1;
ptoolsize:=toolsize;
end;}

procedure setlargetoolbar2;
var bheight:longint;
begin
with Form_peach do
begin
if lsize=1 then bheight:=mbarheight
else bheight:=mmbarheight;
PanelBarOpen.Height:=bheight;
PanelBarOpen2.Height:=bheight;
PanelBarOpen3.Height:=bheight;
settoolglyphleft;
settoolmargin;
settoolspacing((6*qscaleimages) div 100);
settoolbigicon;
settooltext;
settoolbtnw((24*qscaleimages) div 100,true);
end;
toolsize:=0;
ptoolsize:=toolsize;
end;

{procedure setlargetoolbar3;
var bheight:longint;
begin
with Form_peach do
begin
bheight:=mbarheight;
PanelBarOpen.Height:=bheight;
PanelBarOpen2.Height:=bheight;
PanelBarOpen3.Height:=bheight;
settoolglyphtop;
settoolmargin;
settoolspacing(1);
settoolbigicon;
settooltextnil;
settoolbtnw((16*qscaleimages) div 100,false);
end;
toolsize:=2;
ptoolsize:=toolsize;
end;}

{procedure setsmalltoolbar1;
begin
with Form_peach do
begin
PanelBarOpen.Height:=mbarheight;
PanelBarOpen2.Height:=mbarheight;
PanelBarOpen3.Height:=mbarheight;
settoolglyphtop;
settoolmargin;
settoolspacing(1);
settoolsmallicon;
settooltext;
settoolbtnw((12*qscaleimages) div 100,false);
end;
toolsize:=3;
ptoolsize:=toolsize;
end;}

procedure setsmalltoolbar2;
var
   smallheight:integer;
begin
with Form_peach do
begin
//smallheight:=PanelListBar.Height;
//if smallheight=0 then smallheight:=barheight;
smallheight:=barheight;
PanelBarOpen.Height:=smallheight;
PanelBarOpen2.Height:=smallheight;
PanelBarOpen3.Height:=smallheight;
settoolglyphleft;
settoolmargin;
settoolspacing((6*qscaleimages) div 100);
settoolsmallicon;
settooltext;
settoolbtnw((24*qscaleimages) div 100,true);
end;
toolsize:=4;
ptoolsize:=toolsize;
end;

{procedure setsmalltoolbar3;
var
   smallheight:integer;
begin
with Form_peach do
begin
smallheight:=PanelListBar.Height;
if smallheight=0 then smallheight:=barheight;
PanelBarOpen.Height:=smallheight;
PanelBarOpen2.Height:=smallheight;
PanelBarOpen3.Height:=smallheight;
ButtonUn7za4.Height:=ctrlback.height;
settoolglyphtop;
settoolmargin;
settoolspacing(1);
settoolsmallicon;
settooltextnil;
settoolbtnwfixed;
end;
toolsize:=5;
ptoolsize:=toolsize;
end;}

{procedure settexttoolbar;
var
   smallheight:integer;
begin
with Form_peach do
begin
smallheight:=PanelListBar.Height;
if smallheight=0 then smallheight:=barheight;
PanelBarOpen.Height:=smallheight;
PanelBarOpen2.Height:=smallheight;
PanelBarOpen3.Height:=smallheight;
ButtonUn7za4.Height:=ctrlback.height;
settoolglyphleft;
settoolmargin;
settoolspacing((4*qscaleimages) div 100);
settoolnilicon;
settooltext;
settoolbtnw(16,false);
end;
toolsize:=6;
ptoolsize:=toolsize;
end;}

procedure set_adveditcl(i:integer);
begin
case i of
   1: Form_peach.Labelcbsampleadvanced.caption:=advedit1before+stringdelim('%f')+advedit1after;
   2: Form_peach.Labelcbsampleadvanced.caption:=advedit2before+stringdelim('%f')+advedit2after;
   3: Form_peach.Labelcbsampleadvanced.caption:=advedit3before+stringdelim('%f')+advedit3after;
   4: Form_peach.Labelcbsampleadvanced.caption:=advedit4before+stringdelim('%f')+advedit4after;
   5: Form_peach.Labelcbsampleadvanced.caption:=advedit5before+stringdelim('%f')+advedit5after;
   6: Form_peach.Labelcbsampleadvanced.caption:=advedit6before+stringdelim('%f')+advedit6after;
   7: Form_peach.Labelcbsampleadvanced.caption:=advedit7before+stringdelim('%f')+advedit7after;
   8: Form_peach.Labelcbsampleadvanced.caption:=advedit8before+stringdelim('%f')+advedit8after;
   end;
end;

procedure setdescription_advcustedit;
var
   s:ansistring;
   sg:TStringGrid;
begin
sg:=Form_peach.StringGridCustedit1;
s:=sg.Cells[1,sg.Row];
if InputQuery(txt_description, '', s) then
   begin
   sg.Cells[1,sg.Row]:=s;
   sg.AutoSizeColumns;
   end;
set_adveditcl(sg.Row);
end;

procedure setdescription_custedit;
var
   s:ansistring;
begin
s:=Form_peach.StringGridCustedit.Cells[1,Form_peach.StringGridCustedit.Row];
if InputQuery(txt_description, '', s) then
   begin
   Form_peach.StringGridCustedit.Cells[1,Form_peach.StringGridCustedit.Row]:=s;
   Form_peach.StringGridCustedit.AutoSizeColumns;
   end;
end;

procedure editstring1_advcustedit;
var
   s:ansistring;
begin
s:=Form_peach.StringGridCustedit1.Cells[2,Form_peach.StringGridCustedit1.Row];
if InputQuery(txt_2_5_strbefore, '', s) then
   begin
   Form_peach.StringGridCustedit1.Cells[2,Form_peach.StringGridCustedit1.Row]:=s;
   Form_peach.StringGridCustedit1.AutoSizeColumns;
   end;
set_adveditcl(Form_peach.StringGridCustedit1.Row);
end;

procedure editstring2_advcustedit;
var
   s:ansistring;
begin
s:=Form_peach.StringGridCustedit1.Cells[3,Form_peach.StringGridCustedit1.Row];
if InputQuery(txt_2_5_strafter, '', s) then
   begin
   Form_peach.StringGridCustedit1.Cells[3,Form_peach.StringGridCustedit1.Row]:=s;
   Form_peach.StringGridCustedit1.AutoSizeColumns;
   end;
set_adveditcl(Form_peach.StringGridCustedit1.Row);
end;

procedure editstring3_advcustedit;
var
   s:ansistring;
begin
s:=Form_peach.StringGridCustedit1.Cells[4,Form_peach.StringGridCustedit1.Row];
if InputQuery(txt_3_3_stralt, '', s) then
   begin
   Form_peach.StringGridCustedit1.Cells[4,Form_peach.StringGridCustedit1.Row]:=s;
   Form_peach.StringGridCustedit1.AutoSizeColumns;
   end;
set_adveditcl(Form_peach.StringGridCustedit1.Row);
end;

procedure editapp_custedit;
var
   s:ansistring;
begin
s:=Form_peach.StringGridCustedit.Cells[2,Form_peach.StringGridCustedit.Row];
if InputQuery(txt_edit, '', s) then
   begin
   Form_peach.StringGridCustedit.Cells[2,Form_peach.StringGridCustedit.Row]:=s;
   Form_peach.StringGridCustedit.AutoSizeColumns;
   end;
end;

procedure getfullnodepath(TargetNode:ttreenode; var s:ansistring; const s1:ansistring);
var
   rfound:boolean;
begin
rfound:=false;
s:='';
repeat
if (TargetNode.parent<>nil) and (TargetNode.parent.text<>txt_mypc) then
   begin
   if TargetNode.parent.text[length(TargetNode.parent.text)]<>directoryseparator then
      s:=TargetNode.parent.text+directoryseparator+s
   else
      s:=TargetNode.parent.text+s;
   TargetNode:=TargetNode.parent;
   end
else rfound:=true;
until rfound=true;
if s<>'' then
   if s[length(s)]<>directoryseparator then
      s:=s+s1+directoryseparator
   else
      s:=s+s1
else
   s:=s+s1;
s:=s+directoryseparator;
{$IFNDEF MSWINDOWS}s:=directoryseparator+s;{$ENDIF}
end;

function translatespecialfolders(var s: ansistring):boolean;
begin
result:=false;
if s = 'Computer''s root' then begin s:=txt_mypc; result:=true; end;
if s = desktop_path then begin s:=txt_desktop; result:=true; end;
if s = home_path then begin s:=txt_2_9_home; result:=true; end;
if s = usr_documents then begin s:=txt_2_4_documents; result:=true; end;
if s = usr_downloads then begin s:=txt_3_1_downloads; result:=true; end;
if s = usr_music then begin s:=txt_5_0_music; result:=true; end;
if s = usr_pictures then begin s:=txt_5_0_pictures; result:=true; end;
if s = usr_videos then begin s:=txt_5_0_videos; result:=true; end;
end;

function dirExtractFilePath(const FileName: ansistring): ansistring;
var
  i : longint;
  EndSep : Set of Char;
begin
  i := Length(FileName);
  EndSep:=AllowDirectorySeparators;
  while (i > 0) and not CharInSet(FileName[i],EndSep) do
    Dec(i);
  If I>0 then
    Result := Copy(FileName, 1, i)
  else
    Result:='';
end;

function dirExtractFileName(const FileName: ansistring): ansistring;
var
  i : longint;
  EndSep : Set of Char;
begin
  I := Length(FileName);
  EndSep:=AllowDirectorySeparators;
  while (I > 0) and not CharInSet(FileName[I],EndSep) do
    Dec(I);
  Result := Copy(FileName, I + 1, MaxInt);
end;

procedure populatetree;
var
   s:ansistring;

   {procedure populate_folders; //possible implementation: clone the shelltree in the treeview (some problems in displaying the standard expected behaviour for shelltree events, and in displaying the expected part of the tree)
   var
      n:integer;
      bottompath, selectedpath:ansistring;
      lnode,l1node :TTreeNode;
   begin
   with Form_peach do
   begin
   with treeview1.Items.Add(nil,txt_mypc) do
      begin
      Selected:=true;
      ImageIndex:=32;
      SelectedIndex:=32;
      end;
      for n:=0 to shelltreeview1.Items.TopLvlCount-1 do
        CopySubtree(shelltreeview1.Items.TopLvlItems[n], treeview1, treeview1.selected);
   if expandroot=1 then
      begin
      TreeView1.Selected.Expand(true);//(false);
      TreeViewSetTextPath(treeview1,treeview1.selected.GetFirstChild,editopenin1.caption);
      TreeView1.TopItem:=TreeView1.Selected.Parent;//set parent of selected item as top node to give room to siblings of selected item
      getfullnodepath(TreeView1.BottomItem,bottompath,TreeView1.BottomItem.Text);
      getfullnodepath(TreeView1.Selected,selectedpath,TreeView1.Selected.Text);
      if pos(selectedpath,bottompath)<>0 then TreeView1.TopItem:=TreeView1.Selected
      //if bottom node is a child of selected item, set selected item instead of its parent as top node in order to give more room to selected item's children
      else
         if ansicomparestr(selectedpath,bottompath)>0 then TreeView1.TopItem:=TreeView1.Selected;
         //if bottom node is sibling of the selected item and its name is before the name of the selected item, set selected item as top node in order to make it visible to the user
      end
   else
      treeview1.selected:=nil;
   end;}

procedure populate_fs_windows;
begin
with Form_peach do
begin
with treeview1.Items.AddChild(treeview1.selected,txt_mypc) do
   begin
   Selected:=true;
   ImageIndex:=32;
   SelectedIndex:=32;
   end;
if pmjd1.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[1]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[1]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd2.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[2]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[2]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd3.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[3]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[3]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd4.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[4]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[4]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd5.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[5]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[5]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd6.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[6]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[6]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd7.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[7]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[7]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd8.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[8]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[8]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd9.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[9]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[9]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd10.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[10]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[10]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd11.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[11]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[11]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd12.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[12]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[12]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd13.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[13]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[13]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd14.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[14]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[14]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd15.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[15]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[15]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd16.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[16]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[16]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd17.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[17]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[17]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd18.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[18]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[18]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd19.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[19]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[19]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd20.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[20]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[20]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd21.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[21]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[21]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd22.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[22]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[22]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd23.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[23]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[23]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd24.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[24]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[24]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd25.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[25]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[25]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if pmjd26.visible=true then
   begin
   with treeview1.Items.AddChild(treeview1.selected,devname[26]) do
      begin
      ImageIndex:=getpcmenuicon(setpcmenuicon(devtype[26]));
      SelectedIndex:=ImageIndex;
      end;
   end;
if expandroot=1 then TreeView1.Selected.Expand(false);
with treeview1.Items.Add(treeview1.selected,txt_2_9_home) do
   begin
   ImageIndex:=42;
   SelectedIndex:=42;
   end;
with treeview1.Items.Add(treeview1.selected,txt_desktop) do
   begin
   ImageIndex:=36;
   SelectedIndex:=36;
   end;
if usr_downloads<>'' then
   with treeview1.Items.Add(treeview1.selected,txt_3_1_downloads) do
      begin
      ImageIndex:=43;
      SelectedIndex:=43;
      end;
with treeview1.Items.Add(treeview1.selected,txt_2_4_documents) do
   begin
   ImageIndex:=2;
   SelectedIndex:=2;
   end;
if usr_music<>'' then
   with treeview1.Items.Add(treeview1.selected,txt_5_0_music) do
      begin
      ImageIndex:=12;
      SelectedIndex:=12;
      end;
if usr_pictures<>'' then
   with treeview1.Items.Add(treeview1.selected,txt_5_0_pictures) do
      begin
      ImageIndex:=17;
      SelectedIndex:=17;
      end;
if usr_videos<>'' then
   with treeview1.Items.Add(treeview1.selected,txt_5_0_videos) do
      begin
      ImageIndex:=15;
      SelectedIndex:=15;
      end;
if shared_dropbox<>'' then
   with treeview1.Items.Add(treeview1.selected,'Dropbox') do
      begin
      ImageIndex:=44;
      SelectedIndex:=44;
      end;
if shared_myboxfiles<>'' then
   with treeview1.Items.Add(treeview1.selected,'My Box Files') do
      begin
      ImageIndex:=44;
      SelectedIndex:=44;
      end;
if shared_googledrive<>'' then
   with treeview1.Items.Add(treeview1.selected,'Google Drive') do
      begin
      ImageIndex:=44;
      SelectedIndex:=44;
      end;
if shared_onedrive<>'' then
   with treeview1.Items.Add(treeview1.selected,'OneDrive') do
      begin
      ImageIndex:=44;
      SelectedIndex:=44;
      end;
if shared_skydrive<>'' then
   with treeview1.Items.Add(treeview1.selected,'Sharepoint Workspaces') do
      begin
      ImageIndex:=44;
      SelectedIndex:=44;
      end;
if shared_ubuntuone<>'' then
   with treeview1.Items.Add(treeview1.selected,'Yandex Disk') do
      begin
      ImageIndex:=44;
      SelectedIndex:=44;
      end;
with treeview1.Items.Add(treeview1.selected,'...') do
   begin
   Selected:=true;
   ImageIndex:=3;
   SelectedIndex:=3;
   end;
if users_root<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_4_6_users) do
      begin
      ImageIndex:=3;
      SelectedIndex:=3;
      end;
if public_home<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_2_9_home+' - '+txt_2_9_public) do
      begin
      ImageIndex:=3;
      SelectedIndex:=3;
      end;
if public_documents<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_2_4_documents+' - '+txt_2_9_public) do
      begin
      ImageIndex:=3;
      SelectedIndex:=3;
      end;
with treeview1.Items.AddChild(treeview1.selected,txt_list_history) do
   begin
   ImageIndex:=3;
   SelectedIndex:=3;
   end;
if usr_searches<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_3_1_src) do
      begin
      ImageIndex:=3;
      SelectedIndex:=3;
      end;
if usr_libraries<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_3_1_lib) do
      begin
      ImageIndex:=3;
      SelectedIndex:=3;
      end;
if expandmore=1 then TreeView1.Selected.Expand(false);
TreeView1.Selected:=TreeView1.Selected.Parent;
if expandfs=1 then TreeView1.Selected.Expand(false) else TreeView1.Selected.Collapse(true);
end;
end;

procedure populate_fs_nonwindows;
begin
with Form_peach do
begin
with treeview1.Items.AddChild(treeview1.selected,txt_mypc) do
   begin
   ImageIndex:=32;
   SelectedIndex:=32;
   end;
with treeview1.Items.AddChild(treeview1.selected,txt_2_9_home) do
   begin
   ImageIndex:=42;
   SelectedIndex:=42;
   end;
with treeview1.Items.AddChild(treeview1.selected,txt_desktop) do
   begin
   ImageIndex:=36;
   SelectedIndex:=36;
   end;
if usr_downloads<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_3_1_downloads) do
      begin
      ImageIndex:=43;
      SelectedIndex:=43;
      end;
if usr_documents<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_2_4_documents) do
      begin
      ImageIndex:=2;
      SelectedIndex:=2;
      end;
if usr_music<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_5_0_music) do
      begin
      ImageIndex:=12;
      SelectedIndex:=12;
      end;
if usr_pictures<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_5_0_pictures) do
      begin
      ImageIndex:=17;
      SelectedIndex:=17;
      end;
if usr_videos<>'' then
   with treeview1.Items.AddChild(treeview1.selected,txt_5_0_videos) do
      begin
      ImageIndex:=15;
      SelectedIndex:=15;
      end;
{$IFNDEF DARWIN}
if checkempty_dir('/media/') = false then
   with treeview1.Items.AddChild(treeview1.selected,'media') do
      begin
      ImageIndex:=11;
      SelectedIndex:=11;
      end;
if checkempty_dir('/mnt/') = false then
   with treeview1.Items.AddChild(treeview1.selected,'mnt') do
      begin
      ImageIndex:=11;
      SelectedIndex:=11;
      end;
if (checkempty_dir('/run/media/') = false) and (checkempty_dir('/media/') = true) then
   with treeview1.Items.AddChild(treeview1.selected,'run/media') do
      begin
      ImageIndex:=11;
      SelectedIndex:=11;
      end;
if (checkempty_dir('/var/run/media/') = false) and (checkempty_dir('/run/media/') = true) and (checkempty_dir('/media/') = true) then
   with treeview1.Items.AddChild(treeview1.selected,'var/run/media') do
      begin
      ImageIndex:=11;
      SelectedIndex:=11;
      end;
{$ELSE}
with treeview1.Items.AddChild(treeview1.selected,'Volumes') do
   begin
   ImageIndex:=11;
   SelectedIndex:=11;
   end;
with treeview1.Items.AddChild(treeview1.selected,'Applications') do
   begin
   ImageIndex:=3;
   SelectedIndex:=3;
   end;
with treeview1.Items.AddChild(treeview1.selected,'System Applications') do
   begin
   ImageIndex:=3;
   SelectedIndex:=3;
   end;
if checkempty_dir(home_path+'Library/Mobile Documents/') = false then
   with treeview1.Items.AddChild(treeview1.selected,'Mobile Documents') do
      begin
      ImageIndex:=3;
      SelectedIndex:=3;
      end;
{$ENDIF}
if expandfs=1 then TreeView1.Selected.Expand(false) else TreeView1.Selected.Collapse(true);
end;
end;

procedure populate_bookmarks;
begin
with Form_peach do
begin
with treeview1.Items.Add(nil,txt_bookmarks) do
   begin
   Selected:=true;
   ImageIndex:=30;
   SelectedIndex:=30;
   end;
if mb1.visible=true then
   begin
   s:=mb1.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,1);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb2.visible=true then
   begin
   s:=mb2.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,2);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb3.visible=true then
   begin
   s:=mb3.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,3);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb4.visible=true then
   begin
   s:=mb4.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,4);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb5.visible=true then
   begin
   s:=mb5.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,5);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb6.visible=true then
   begin
   s:=mb6.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,6);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb7.visible=true then
   begin
   s:=mb7.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,7);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb8.visible=true then
   begin
   s:=mb8.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,8);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb9.visible=true then
   begin
   s:=mb9.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,9);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb10.visible=true then
   begin
   s:=mb10.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,10);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb11.visible=true then
   begin
   s:=mb11.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,11);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb12.visible=true then
   begin
   s:=mb12.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,12);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb13.visible=true then
   begin
   s:=mb13.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,13);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb14.visible=true then
   begin
   s:=mb14.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,14);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb15.visible=true then
   begin
   s:=mb15.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,15);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb16.visible=true then
   begin
   s:=mb16.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,16);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb17.visible=true then
   begin
   s:=mb17.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,17);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb18.visible=true then
   begin
   s:=mb18.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,18);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb19.visible=true then
   begin
   s:=mb19.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,19);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb20.visible=true then
   begin
   s:=mb20.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,20);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb21.visible=true then
   begin
   s:=mb21.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,21);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb22.visible=true then
   begin
   s:=mb22.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,22);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mb23.visible=true then
   begin
   s:=mb23.caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      ImageIndex:=gettreeicon(StringGridBookmarks,23);
      SelectedIndex:=ImageIndex;
      end;
   end;
if expandbook=1 then TreeView1.Selected.Expand(true);
end;
end;

procedure populate_history;
var
   j:integer;
begin
with Form_peach do
begin
j:=0;
with treeview1.Items.Add(nil,txt_list_history) do
   begin
   Selected:=true;
   ImageIndex:=37;
   SelectedIndex:=37;
   end;

if mRecent1f.visible=true then
   begin
   s:=mRecent1f.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent2f.visible=true then
   begin
   s:=mRecent2f.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent3f.visible=true then
   begin
   s:=mRecent3f.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent4f.visible=true then
   begin
   s:=mRecent4f.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent5f.visible=true then
   begin
   s:=mRecent5f.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent6f.visible=true then
   begin
   s:=mRecent6f.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent7f.visible=true then
   begin
   s:=mRecent7f.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent8f.visible=true then
   begin
   s:=mRecent8f.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;

if mRecent1.visible=true then
   begin
   s:=mRecent1.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent2.visible=true then
   begin
   s:=mRecent2.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent3.visible=true then
   begin
   s:=mRecent3.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent4.visible=true then
   begin
   s:=mRecent4.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent5.visible=true then
   begin
   s:=mRecent5.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent6.visible=true then
   begin
   s:=mRecent6.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent7.visible=true then
   begin
   s:=mRecent7.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if mRecent8.visible=true then
   begin
   s:=mRecent8.Caption;
   if length(s)>1 then
      if s[length(s)]=directoryseparator then setlength(s,length(s)-1);
   if extractfilename(s)<>'' then s:=extractfilename(s);
   with treeview1.Items.AddChild(treeview1.selected,s) do
      begin
      j:=j+1;
      ImageIndex:=gettreeicon(StringGridRecent,j);
      SelectedIndex:=ImageIndex;
      end;
   end;
if expandhistory=1 then TreeView1.Selected.Expand(true);
end;
end;

procedure populate_open;
var
    i:integer;
begin
with Form_peach do
begin
with treeview1.Items.Add(nil,txt_open) do
   begin
   Selected:=true;
   ImageIndex:=39;
   SelectedIndex:=39;
   end;

   with treeview1.Items.AddChild(treeview1.selected,txt_add) do
      begin
      ImageIndex:=51;
      SelectedIndex:=51;
      end;
   with treeview1.Items.AddChild(treeview1.selected,txt_caption_extract) do
      begin
      if tonewfolder=0 then ImageIndex:=52 else ImageIndex:=53;
      SelectedIndex:=ImageIndex;
      end;

   with treeview1.Items.AddChild(treeview1.selected,txt_open_path) do
      begin
      ImageIndex:=39;//3;
      SelectedIndex:=39;
      end;
   with treeview1.Items.AddChild(treeview1.selected,txt_openarchive) do
      begin
      ImageIndex:=39;//0;
      SelectedIndex:=39;
      end;
   with treeview1.Items.AddChild(treeview1.selected,txt_searchanddrag) do
      begin
      ImageIndex:=39;//29;
      SelectedIndex:=39;
      end;
   with treeview1.Items.AddChild(treeview1.selected,txt_search_web) do
      begin
      ImageIndex:=39;
      SelectedIndex:=39;
      end;

   with treeview1.Items.AddChild(treeview1.selected,txt_explore_path) do
      begin
      ImageIndex:=39;
      SelectedIndex:=39;
      end;
   with treeview1.Items.AddChild(treeview1.selected,txt_cphere) do
      begin
      ImageIndex:=39;
      SelectedIndex:=39;
      end;
   {$IFDEF MSWINDOWS}
   with treeview1.Items.AddChild(treeview1.selected,txt_5_0_ps) do
      begin
      ImageIndex:=39;
      SelectedIndex:=39;
      end;
   with treeview1.Items.AddChild(treeview1.selected,txt_4_5_properties) do
      begin
      ImageIndex:=39;
      SelectedIndex:=39;
      end;
   {$ENDIF}

   populatetree2;
   with treeview1.Items.AddChild(treeview1.selected,txt_4_8_fun) do //functions
      begin
      Selected:=true;
      ImageIndex:=39;
      SelectedIndex:=39;
      end;
   for i:=0 to treeview2.Items.Count-1 do
     with treeview1.Items.AddChild(treeview1.selected,treeview2.Items.Item[i].Text) do begin ImageIndex:=39; SelectedIndex:=39; end;

   if expandfun=1 then TreeView1.Selected.Expand(false);
   TreeView1.Selected:=TreeView1.Selected.Parent;

   with treeview1.Items.AddChild(treeview1.selected,txt_3_3_apps) do //apps
      begin
      Selected:=true;
      ImageIndex:=41;
      SelectedIndex:=41;
      end;

      with treeview1.Items.AddChild(treeview1.selected,txt_3_3_run) do begin ImageIndex:=41; SelectedIndex:=41; end;
      i:=1;
      if owcustom1.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom1.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=1; i:=i+1; end;
      if owcustom2.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom2.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=2; i:=i+1; end;
      if owcustom3.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom3.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=3; i:=i+1; end;
      if owcustom4.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom4.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=4; i:=i+1; end;
      if owcustom5.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom5.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=5; i:=i+1; end;
      if owcustom6.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom6.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=6; i:=i+1; end;
      if owcustom7.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom7.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=7; i:=i+1; end;
      if owcustom8.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom8.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=8; i:=i+1; end;
      if owcustom_9.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom_9.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=9; i:=i+1; end;
      if owcustom_10.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom_10.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=10; i:=i+1; end;
      if owcustom_11.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom_11.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=11; i:=i+1; end;
      if owcustom_12.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom_12.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=12; i:=i+1; end;
      if owcustom_13.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom_13.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=13; i:=i+1; end;
      if owcustom_14.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom_14.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=14; i:=i+1; end;
      if owcustom_15.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom_15.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=15; i:=i+1; end;
      if owcustom_16.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom_16.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb[i]:=16; i:=i+1; end;
      appentries1:=i-1;
      i:=1;
      if owcustom9.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom9.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb2[i]:=1; i:=i+1; end;
      if owcustom10.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom10.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb2[i]:=2; i:=i+1; end;
      if owcustom11.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom11.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb2[i]:=3; i:=i+1; end;
      if owcustom12.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom12.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb2[i]:=4; i:=i+1; end;
      if owcustom13.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom13.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb2[i]:=5; i:=i+1; end;
      if owcustom14.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom14.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb2[i]:=6; i:=i+1; end;
      if owcustom15.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom15.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb2[i]:=7; i:=i+1; end;
      if owcustom16.visible=true then begin with treeview1.Items.AddChild(treeview1.selected,owcustom16.caption) do begin ImageIndex:=41; SelectedIndex:=41; end; appdb2[i]:=8; i:=i+1; end;
   if expandapps=1 then TreeView1.Selected.Expand(false);
   TreeView1.Selected:=TreeView1.Selected.Parent;

if expandrun=1 then TreeView1.Selected.Expand(false) else TreeView1.Selected.Collapse(true);
end;
end;

procedure populate_archive;
var
   i,j,k:integer;
   nodefound,nodenotfinalized:boolean;
begin
//tree view archive rapresentation maxed to 4K dirs for performances
Form_peach.treeview1.Items.Beginupdate;

if (Form_Peach.StringGridAddress1.RowCount=1) and (Form_Peach.StringGridAddress2.RowCount=1) then
   begin
   Form_peach.treeview1.Items.Clear;
   exit;
   end;

if fun='UN7Z' then
   if (status1=txt_list_nomatch+txt_2_7_list_tryflatorpw) or (browse_option='l') then
      begin
      Form_peach.treeview1.Items.Clear;
      exit;
      end
   else
else
   begin
   Form_peach.treeview1.Items.Clear;
   exit;
   end;

if set_archivetree=false then
   begin
   if extractfilename(Form_Peach.EditOpenIn.Text)='' then
      begin
      Form_peach.treeview1.Items.Clear;
      end
   else
      begin
      if Form_Peach.StringGridAddress1.rowcount>MAXNDIRTREE then
         for i:=Form_peach.TreeView1.Items.Count-1 downto 2 do Form_peach.TreeView1.Items[i].Delete
      else
         for i:=Form_peach.TreeView1.Items.Count-1 downto Form_Peach.StringGridAddress1.RowCount+1 do Form_peach.TreeView1.Items[i].Delete;
      end;
   exit;
   end
else set_archivetree:=false;

Form_peach.treeview1.Items.Clear;
if extractfilename(form_peach.EditOpenIn1.Text)='' then exit;

with Form_peach.treeview1.Items.Add(nil,extractfilename(form_peach.EditOpenIn1.Text)) do
   begin
   Selected:=true;
   ImageIndex:=geticon(form_peach.EditOpenIn1.Text,ExtractFileExt(form_peach.EditOpenIn1.Text),false);
   SelectedIndex:=ImageIndex;
   end;

if (Form_Peach.StringGridAddress1.rowcount<2) or (Form_Peach.StringGridAddress1.rowcount>MAXNDIRTREE) then
   begin
   Form_peach.treeview1.Items.Add(nil,'');
   exit;
   end;

if Form_Peach.StringGridAddress1.Cells[11,1]='' then
   begin
   Form_peach.treeview1.Items.Add(nil,'');
   exit;
   end;

Form_Peach.StringGridAddress1.Beginupdate;
Form_Peach.StringGridAddress1.SortColRow(true,11);
with Form_peach.TreeView1.Items.AddChild(Form_peach.treeview1.selected,Form_Peach.StringGridAddress1.Cells[11,1]) do
   begin
   Form_Peach.StringGridAddress1.Cells[12,1]:='1';
   Selected:=true;
   ImageIndex:=3;
   SelectedIndex:=3;
   end;
Form_Peach.TreeView1.BeginUpdate;
Form_Peach.TreeView1.visible:=false;
for i:=2 to Form_Peach.StringGridAddress1.RowCount-1 do
   begin
   nodefound:=false;
   for j:=1 to Form_Peach.treeview1.Items.Count-1 do
      begin
      if pos(Form_peach.treeview1.Items[j].Text+directoryseparator,Form_Peach.StringGridAddress1.Cells[11,i]+directoryseparator)=1 then//<>0 then
         begin
         nodenotfinalized:=false;
         for k:=j+1 to Form_Peach.treeview1.Items.Count-1 do
             begin
             if pos(Form_peach.treeview1.Items[k].Text+directoryseparator,Form_Peach.StringGridAddress1.Cells[11,i]+directoryseparator)<>0 then
                begin
                nodenotfinalized:=true;
                break;
                end;
             end;
         if nodenotfinalized=false then
         with Form_peach.TreeView1.Items.AddChild(Form_peach.treeview1.Items[j],Form_Peach.StringGridAddress1.Cells[11,i]) do
            begin
            Selected:=true;
            ImageIndex:=3;
            SelectedIndex:=3;
            nodefound:=true;
            break;
            end;
         end;
      end;
   if nodefound=false then
      with Form_peach.TreeView1.Items.AddChild(Form_peach.treeview1.Items[0],Form_Peach.StringGridAddress1.Cells[11,i]) do
         begin
         Selected:=true;
         ImageIndex:=3;
         SelectedIndex:=3;
         end;
   end;
Form_Peach.TreeView1.EndUpdate;
Form_Peach.TreeView1.visible:=true;
Form_Peach.StringGridAddress1.clear;
Form_Peach.StringGridAddress1.rowcount:=Form_Peach.treeview1.Items.Count;
for i:=1 to Form_Peach.treeview1.Items.Count-1 do
   Form_Peach.StringGridAddress1.Cells[11,i]:=Form_peach.treeview1.Items[i].text;
for j:=1 to Form_Peach.treeview1.Items.Count-1 do
   Form_peach.treeview1.Items[j].Text:=dirextractfilename(Form_peach.treeview1.Items[j].Text);
Form_Peach.StringGridAddress1.EndUpdate;

Form_Peach.TreeView1.Selected:=Form_Peach.TreeView1.Items[0];
Form_Peach.TreeView1.Selected.collapse(true);
aisexpanded:=false;

Form_peach.treeview1.Items.Add(nil,'');

end;

begin
with Form_peach do
begin

populate_archive;

populate_bookmarks;

treeview1.Items.Add(nil,'');
with treeview1.Items.Add(nil,txt_fs) do
   begin
   Selected:=true;
   ImageIndex:=31;
   SelectedIndex:=31;
   end;
{$IFDEF MSWINDOWS}
populate_fs_windows;
{$ELSE}
populate_fs_nonwindows;
{$ENDIF}

treeview1.Items.Add(nil,'');
populate_history;

treeview1.Items.Add(nil,'');
populate_open;

treeview1.Items.Add(nil,'');

Form_peach.TreeView1.TopItem:=Form_peach.TreeView1.Items[0];
if (fun='UN7Z') and (selnode>0) and (selnode<Form_peach.TreeView1.Items.Count) then
   if Form_peach.TreeView1.Items[selnode].IsVisible=false then Form_peach.TreeView1.Items[selnode].MakeVisible;

treeview1.selected:=nil;

treeview1.Items.Endupdate;
end;
end;

procedure testwinrar;
begin
{$IFDEF MSWINDOWS}
if libre_directive=2 then
   begin
   havewinrar:=false;
   exit;
   end;
havewinrar:=true;
if fileexists(GetEnvironmentVariable('ProgramFiles')+'\WinRAR\Rar.exe') then Form_peach.EditNameCustom.Caption:=GetEnvironmentVariable('ProgramFiles')+'\WinRAR\Rar.exe'
else
   if fileexists(GetEnvironmentVariable('ProgramW6432')+'\WinRAR\Rar.exe') then Form_peach.EditNameCustom.Caption:=GetEnvironmentVariable('ProgramW6432')+'\WinRAR\Rar.exe'
   else
      if fileexists(executable_path+'Rar.exe') then Form_peach.EditNameCustom.Caption:=executable_path+'Rar.exe'
      else
         if fileexists(binpath+'Rar.exe') then Form_peach.EditNameCustom.Caption:=binpath+'Rar.exe'
         else
            if fileexists(binpath+'rar\Rar.exe') then Form_peach.EditNameCustom.Caption:=binpath+'rar\Rar.exe'
            else
               if fileexists(binpath+'unrar\Rar.exe') then Form_peach.EditNameCustom.Caption:=binpath+'unrar\Rar.exe'
               else
                  havewinrar:=false;
if havewinrar=true then Form_peach.EditExtCustom.Caption:='rar';
//syntax is fixed so it is not needed to change it
{$ELSE}
havewinrar:=false;
{$ENDIF}
end;

procedure assign_guitext; //set text
var
   i:integer;
begin
Form_peach.Caption:=APPMAIN;
with Form_peach do
begin
try
Labelsetwork.caption:=txt_settings+' > '+txt_3_1_workingdir;
pmtoolsmall.Caption:=txt_2_9_st;
labelCheckBoxSolidAddress.Caption:=txt_2_9_address;
CheckBoxSolidAddress.Items.Clear;
CheckBoxSolidAddress.Items.Add(txt_8_8_cw);
CheckBoxSolidAddress.Items.Add(txt_8_8_cb+' / '+txt_8_8_light);
CheckBoxSolidAddress.Items.Add(txt_8_8_cb);
CheckBoxSolidAddress.Items.Add(txt_8_8_cb+' / '+txt_7_6_dim);
CheckBoxSolidAddress.Items.Add(txt_8_8_cb+' / '+txt_7_6_dark);
CheckBoxSolidAddress.Items.Add(txt_8_8_ca+' / '+txt_8_8_light);
CheckBoxSolidAddress.Items.Add(txt_8_8_ca);
CheckBoxSolidAddress.Items.Add(txt_8_8_ca+' / '+txt_7_6_dim);
CheckBoxSolidAddress.Items.Add(txt_8_8_ca+' / '+txt_7_6_dark);
CheckBoxCenteredToolbar.Caption:=txt_8_8_centered;
CheckBoxsnz1.Caption:=txt_8_8_snz;
CheckBoxsnoi.Caption:=txt_8_8_snoi;
CheckBoxsnon.Caption:=txt_8_8_snon;
LabelColorAddressbar.Caption:=txt_8_8_solcol;
LabelColorTabs1.Caption:=txt_8_8_altt;
CheckBoxAltTab.Items.Clear;
CheckBoxAltTab.Items.Add(txt_8_8_btn);
CheckBoxAltTab.Items.Add(txt_8_8_lnk);
CheckBoxAltTab.Items.Add(txt_8_8_tab);
LabelColorToolBar.Caption:=txt_2_9_toolbar;
CheckBoxAlttabcol.Items.Clear;
CheckBoxAlttabcol.Items.Add(txt_8_8_cw+' + '+txt_8_8_cb);
CheckBoxAlttabcol.Items.Add(txt_8_8_cw+' + '+txt_8_8_ca);
CheckBoxAlttabcol.Items.Add(txt_8_8_cb);
CheckBoxAlttabcol.Items.Add(txt_8_8_cb+' / '+txt_7_6_dim);
CheckBoxAlttabcol.Items.Add(txt_8_8_ca);
CheckBoxAlttabcol.Items.Add(txt_8_8_ca+' / '+txt_7_6_dim);
CheckBoxAccentToolBar.Items.Clear;
CheckBoxAccentToolBar.Items.Add(txt_8_8_cw);
CheckBoxAccentToolBar.Items.Add(txt_8_8_cb+' / '+txt_8_8_light);
CheckBoxAccentToolBar.Items.Add(txt_8_8_cb);
CheckBoxAccentToolBar.Items.Add(txt_8_8_cb+' / '+txt_7_6_dim);
CheckBoxAccentToolBar.Items.Add(txt_8_8_cb+' / '+txt_7_6_dark);
CheckBoxAccentToolBar.Items.Add(txt_8_8_ca+' / '+txt_8_8_light);
CheckBoxAccentToolBar.Items.Add(txt_8_8_ca);
CheckBoxAccentToolBar.Items.Add(txt_8_8_ca+' / '+txt_7_6_dim);
CheckBoxAccentToolBar.Items.Add(txt_8_8_ca+' / '+txt_7_6_dark);
CheckBoxAltBar.Items.Clear;
CheckBoxAltBar.Items.Add(txt_8_8_cw);
CheckBoxAltBar.Items.Add(txt_8_8_cb);
CheckBoxAltBar.Items.Add(txt_8_8_ca);
Labelmoreopt.Caption:=txt_8_7_mo;
Labelmoreopt1.Caption:=txt_8_7_mo;
Labeloptsub7.Caption:=txt_all_size;
MenuItemOpen_run.Caption:=txt_3_3_run;
owrun.Caption:=txt_3_3_run;
eowrun.Caption:=txt_3_3_run;
powrun.Caption:=txt_3_3_run;
pmmorelock.Caption:=txt_7_4_lock;
pmmorerr.Caption:=txt_rr;
if (havewinrar=false) or (userar<>1) then pmmorerecover.Caption:=txt_7_4_recover+' (ARC)'
else pmmorerecover.Caption:=txt_7_4_recover+' (ARC, RAR)';
pmmorecomment.Caption:=txt_7_4_comment;
po_lock.Caption:=txt_7_4_lock;
po_rr.Caption:=txt_rr;
if (havewinrar=false) or (userar<>1) then po_recover.Caption:=txt_7_4_recover+' (ARC)'
else po_recover.Caption:=txt_7_4_recover+' (ARC, RAR)';
po_comment.Caption:=txt_7_4_comment;
cbRARlock.Caption:=txt_7_4_lock;
CheckBoxNoConf.Caption:=txt_7_3_noconfdel;
CheckBoxzipxswitch.Caption:=txt_7_4_swzipx;
CheckBoxAC.Caption:=txt_9_1_ac;
CheckBoxBrotli.Caption:=txt_7_3_maxbr;
CheckBoxZstd.Caption:=txt_7_3_maxzstd;
CheckBoxstl.Caption:=txt_7_3_stl;
mdirbeforefiles.Caption:=txt_9_0_df;
CheckBoxssp.Caption:=txt_9_0_accesstime;
Labelmemuse.Caption:=txt_9_0_mem;
CheckBoxsnh.Caption:=txt_9_0_hl+' (WIM, TAR)';
CheckBoxsnl.Caption:=txt_9_0_sl+' (WIM, TAR)';
cbtimecreated.Caption:=txt_8_2_alltimes;
cbtimecreated.Hint:=txt_8_2_supportedby+' 7Z, RAR, TAR/pax, ZIP';
CheckBoxsni.Caption:=txt_6_5_sni+' (WIM)';
CheckBoxsni1.Caption:=txt_6_5_sni+' (WIM)';
CheckBoxsns.Caption:=txt_6_5_sns+' (WIM)';
CheckBoxsns1.Caption:=txt_6_5_sns+' (WIM)';
ComboBoxprivacy.Items.Clear;
ComboBoxprivacy.Items.Add(txt_6_5_nop);
ComboBoxprivacy.Items.Add(txt_6_5_askp);
ComboBoxprivacy.Items.Add(txt_6_5_askp+' '+txt_6_5_mandatory);
mtabs.Caption:=txt_6_4_tabbar;
pmhtabs.Caption:=txt_6_4_tabbar;
pmhnewtab.Caption:=txt_6_4_openintab;
pmbcnw.Caption:=txt_9_1_nw;
MenuItemInfo.Caption:=txt_info;
MenuItemInfomenu.Caption:=txt_info;
MenuItemToggleNav.Caption:=txt_9_0_tnav+' (Alt+4)';
MenuItemToggleStatus.Caption:=txt_toggle_historybookmarks+' (Alt+8)';
pmtabsm.Caption:=txt_6_4_tabbar;
pmtabsnew.Caption:=txt_6_4_openintab;
pmtabsclose.Caption:=txt_3_6_close;
pmtabscloseother.Caption:=txt_6_4_closeallother;
pmtabscloseright.Caption:=txt_6_4_closeright;
pmtabscloseall.Caption:=txt_9_1_closeall;
pmtabscollapse.Caption:=txt_6_4_collapse;
pmtabsexpand.Caption:=txt_6_4_expand;
po_tabsopen.Caption:=txt_6_4_openintab;
po_windowopen.Caption:=txt_9_1_nw;
pmtabsnewwindow.Caption:=txt_9_1_nw;
pmtabsbook.Caption:=txt_bookmarks;
pmtabsbookmarkadd.Caption:=txt_add_tobookmarks;
pmtabsbookmarkorg.Caption:=txt_2_9_organize;
MenuItemOpen_saveastxt.Caption:=txt_saveas+' TXT';
pmsaveastxt.Caption:=txt_saveas+' TXT';
MenuItemOpen_saveascsv.Caption:=txt_saveas+' CSV';
pmsaveascsv.Caption:=txt_saveas+' CSV';
po_preview.Caption:=txt_5_9_pff;
po_analyze.Caption:=txt_5_9_lff;
pmmorepreview.Caption:=txt_5_9_pff;
pmmoreanalysis.Caption:=txt_5_9_lff;
pmfilebrowser.caption:=txt_filebrowser;
ComboBoxLibre.Items.Clear;
ComboBoxLibre.Items.Add(txt_5_8_l0);
ComboBoxLibre.Items.Add(txt_5_8_l1);
ComboBoxLibre.Items.Add(txt_5_8_l2);
po_selectadv.Caption:=txt_5_5_select+'...';
pmrselect.Caption:=txt_5_5_select+'...';
pmselectadv.Caption:=txt_5_5_select+'...';
mselectadv.Caption:=txt_5_5_select+'...';
po_copypath.Caption:=txt_5_5_copypath;
pmhcopypath.Caption:=txt_5_5_copypath;
org_autoadjust.Caption:=txt_6_3_autoadjust+' (Ctrl+Alt+A)';
mautoadjust.Caption:=txt_6_3_autoadjust;
pmcname.Caption:=txt_name;
pmctype.Caption:=txt_type;
pmcsize.Caption:=txt_size;
pmcpacked.Caption:=txt_compressed_size;
pmcdate.Caption:=txt_8_2_tm;
pmcatt.Caption:=txt_attributes;
pmccrc.Caption:='CRC32';
pmcfree.Caption:=txt_free;
pmcpypath.caption:=txt_5_5_copypath;
pmcopypath.caption:=txt_5_5_copypath;
mDateYear.Caption:=txt_5_5_dateyear;
mDateMonth.Caption:=txt_5_5_datemonth;
mDateWeek.Caption:=txt_5_5_dateweek;
mDateDay.Caption:=txt_5_5_dateday;
mDateHour.Caption:=txt_5_5_datehour;
msameyear.Caption:=txt_5_5_datesameyear;
msamemonth.Caption:=txt_5_5_datesamemonth;
msameweek.Caption:=txt_5_5_datesameweek;
msameday.Caption:=txt_5_5_datesameday;
msamehour.Caption:=txt_5_5_datesamehour;
po_rename_delete.Caption:=txt_5_5_delete;
po_rename_add.Caption:=txt_5_5_add;
po_rename_cutlen.Caption:=txt_7_5_cutlen;
po_rename_ascii.Caption:=txt_7_5_repnascii;
po_rename_lowercase.Caption:=txt_5_5_lower;
po_rename_filesonly.Caption:=txt_7_1_renfilesonly;
pmr_files.Caption:=txt_7_1_renfilesonly;
po_rename_uppercase.Caption:=txt_5_5_upper;
po_rename_timestamp.Caption:=txt_timestamp;
po_rename_appenddir.Caption:=txt_6_4_appdirn;
po_rename_prependdir.Caption:=txt_6_4_prepdirn;
po_rename_replace.Caption:=txt_5_5_replacestr;
po_rename_replace_case.Caption:=txt_5_5_replacestr+' '+txt_5_5_case;
po_rename_ext.Caption:=txt_5_5_ext;
pmr_delete.Caption:=txt_5_5_delete;
pmr_add.Caption:=txt_5_5_add;
pmr_lowercase.Caption:=txt_5_5_lower;
pmr_uppercase.Caption:=txt_5_5_upper;
pmr_replace.Caption:=txt_5_5_replacestr;
pmr_replacecase.Caption:=txt_5_5_replacestr+' '+txt_5_5_case;
pmr_ext.Caption:=txt_5_5_ext;
pmr_appendts.Caption:=txt_timestamp;
pmr_appenddirname.Caption:=txt_6_4_appdirn;
pmr_prependdirname.Caption:=txt_6_4_prepdirn;
pmr_cut.Caption:=txt_7_5_cutlen;
pmr_ascii.Caption:=txt_7_5_repnascii;
CheckBoxAutoHaltA.Caption:=txt_5_5_halt;
CheckBoxAutoHaltE.Caption:=txt_5_5_halt;
po_zerofile.Caption:=txt_5_2_zerofiles+' (Alt+Del)';
pmzerofile.Caption:=txt_5_2_zerofiles+' (Alt+Del)';
po_zerofree.Caption:=txt_5_2_zerofree;
pmzerofree.Caption:=txt_5_2_zerofree;
po_securedeletefree.Caption:=txt_5_2_securedeletefree;
pmsecuredeletefree.Caption:=txt_5_2_securedeletefree;
mscheduledscripts.Caption:=txt_5_1_schedscripts;
mtaskscheduler.Caption:=txt_5_1_ts;
po_task.Caption:=txt_5_1_ts;
schedulepassword1.Caption:=txt_pw;
scheduleuser1.Caption:=txt_run_as2;
Bschedule1.Caption:=txt_5_1_schedadd;
scheduleend1.Caption:=txt_5_1_enddate;
labelevery1.Caption:=txt_5_1_every;
Lmanageschedule4.Caption:=txt_5_1_schedmanage;
Lmanageschedule3.Caption:=txt_5_1_scriptmanage;
CheckGroupM2.Caption:=txt_5_1_months;
lsa5.Caption:=txt_5_1_schedule;
lsa6.Caption:=txt_5_1_starttime;
PanelClickAddress.Hint:=txt_7_1_typetosearch;
ImageInfoArchive6.Hint:=txt_5_1_schedexplain;
schedulestart1.Caption:=txt_5_1_startdate;
lsa4.Caption:=txt_5_1_schedname;
CheckGroupM2.Checked[0]:=true;
CheckGroupM2.Checked[1]:=true;
CheckGroupM2.Checked[2]:=true;
CheckGroupM2.Checked[3]:=true;
CheckGroupM2.Checked[4]:=true;
CheckGroupM2.Checked[5]:=true;
CheckGroupM2.Checked[6]:=true;
CheckGroupM2.Checked[7]:=true;
CheckGroupM2.Checked[8]:=true;
CheckGroupM2.Checked[9]:=true;
CheckGroupM2.Checked[10]:=true;
CheckGroupM2.Checked[11]:=true;
lsaday1.Caption:=txt_5_1_day;
ComboBoxM3.Items.Clear;
for i:=1 to 31 do ComboBoxM3.Items.Add(inttostr(i));
ComboBoxM3.Items.Add(txt_5_1_last);
CheckGroupW1.Caption:=txt_5_1_days;
CheckGroupW1.Items.Clear;
CheckGroupW1.Items.Add(txt_5_1_w1);
CheckGroupW1.Items.Add(txt_5_1_w2);
CheckGroupW1.Items.Add(txt_5_1_w3);
CheckGroupW1.Items.Add(txt_5_1_w4);
CheckGroupW1.Items.Add(txt_5_1_w5);
CheckGroupW1.Items.Add(txt_5_1_w6);
CheckGroupW1.Items.Add(txt_5_1_w7);
CheckGroupW1.Checked[1]:=true;
CheckGroupW1.Checked[2]:=true;
CheckGroupW1.Checked[3]:=true;
CheckGroupW1.Checked[4]:=true;
CheckGroupW1.Checked[5]:=true;
schedaddschedule1.Items.Clear;
schedaddschedule1.Items.Add(txt_5_1_hourly);
schedaddschedule1.Items.Add(txt_5_1_daily);
schedaddschedule1.Items.Add(txt_5_1_weekly);
schedaddschedule1.Items.Add(txt_5_1_monthly);
schedaddschedule1.Items.Add(txt_5_1_once);
{schedaddschedule.Items.Add(txt_5_1_onstart);
schedaddschedule.Items.Add(txt_5_1_onlogin);}//works only as admin
schedulepassword.Caption:=txt_pw;
scheduleuser.Caption:=txt_run_as2;
Bschedule.Caption:=txt_5_1_schedadd;
scheduleend.Caption:=txt_5_1_enddate;
labelevery.Caption:=txt_5_1_every;
Lmanageschedule2.Caption:=txt_5_1_schedmanage;
Lmanageschedule1.Caption:=txt_5_1_scriptmanage;
CheckGroupM1.Caption:=txt_5_1_months;
lsa2.Caption:=txt_5_1_schedule;
lsa3.Caption:=txt_5_1_starttime;
ImageInfoArchive5.Hint:=txt_5_1_schedexplain;
schedulestart.Caption:=txt_5_1_startdate;
lsa1.Caption:=txt_5_1_schedname;
CheckGroupM1.Checked[0]:=true;
CheckGroupM1.Checked[1]:=true;
CheckGroupM1.Checked[2]:=true;
CheckGroupM1.Checked[3]:=true;
CheckGroupM1.Checked[4]:=true;
CheckGroupM1.Checked[5]:=true;
CheckGroupM1.Checked[6]:=true;
CheckGroupM1.Checked[7]:=true;
CheckGroupM1.Checked[8]:=true;
CheckGroupM1.Checked[9]:=true;
CheckGroupM1.Checked[10]:=true;
CheckGroupM1.Checked[11]:=true;
lsaday.Caption:=txt_5_1_day;
ComboBoxM2.Items.Clear;
for i:=1 to 31 do ComboBoxM2.Items.Add(inttostr(i));
ComboBoxM2.Items.Add(txt_5_1_last);
CheckGroupW.Caption:=txt_5_1_days;
CheckGroupW.Items.Clear;
CheckGroupW.Items.Add(txt_5_1_w1);
CheckGroupW.Items.Add(txt_5_1_w2);
CheckGroupW.Items.Add(txt_5_1_w3);
CheckGroupW.Items.Add(txt_5_1_w4);
CheckGroupW.Items.Add(txt_5_1_w5);
CheckGroupW.Items.Add(txt_5_1_w6);
CheckGroupW.Items.Add(txt_5_1_w7);
CheckGroupW.Checked[1]:=true;
CheckGroupW.Checked[2]:=true;
CheckGroupW.Checked[3]:=true;
CheckGroupW.Checked[4]:=true;
CheckGroupW.Checked[5]:=true;
schedaddschedule.Items.Clear;
schedaddschedule.Items.Add(txt_5_1_hourly);
schedaddschedule.Items.Add(txt_5_1_daily);
schedaddschedule.Items.Add(txt_5_1_weekly);
schedaddschedule.Items.Add(txt_5_1_monthly);
schedaddschedule.Items.Add(txt_5_1_once);
{schedaddschedule.Items.Add(txt_5_1_onstart);
schedaddschedule.Items.Add(txt_5_1_onlogin);}//works only as admin
ButtonUn7zaTo.Hint:=txt_ext_sel;
ButtonUn7za1.Hint:=txt_caption_test;
ButtonUn7za5.Hint:=txt_2_8_convert;
pmjumpmusic.caption:=txt_5_0_music;
pmjumppictures.caption:=txt_5_0_pictures;
pmjumpvideos.caption:=txt_5_0_videos;
MenuItemArchive_music.caption:=txt_5_0_music;
MenuItemArchive_pictures.caption:=txt_5_0_pictures;
MenuItemArchive_videos.caption:=txt_5_0_videos;
MenuItemOpen_music.caption:=txt_5_0_music;
MenuItemOpen_pictures.caption:=txt_5_0_pictures;
MenuItemOpen_videos.caption:=txt_5_0_videos;
pmbc.caption:=txt_list_history;
pmhbc0.caption:=txt_5_0_bc;
pmnavbc0.caption:=txt_5_0_bc;
mbc0.caption:=txt_5_0_bc;
pnbc0.caption:=txt_5_0_bc;
pnabc0.caption:=txt_5_0_bc;
mhistory0s.Caption:=txt_5_0_sh;
pmh0s.Caption:=txt_5_0_sh;
pmnavhistory0.Caption:=txt_5_0_sh;
pnh0s.Caption:=txt_5_0_sh;
pnha0s.Caption:=txt_5_0_sh;
mrecent0.Caption:=txt_list_history;
pmhr0.Caption:=txt_list_history;
pnr0.Caption:=txt_list_history;
pnra0.Caption:=txt_list_history;
mrecent0.visible:=false;
pmhr0.visible:=false;
pnr0.visible:=false;
pnra0.visible:=false;
po_more.Caption:=txt_algo;
po_sysmore.Caption:=txt_3_1_more;
menuitemopen_powershell.Caption:=txt_5_0_ps;
MenuItemPowerShell.Caption:=txt_5_0_ps;
pmpowershell.Caption:=txt_5_0_ps;
mb0.Caption:=txt_add_tobookmarks;
mb24.Caption:=txt_2_9_organize;
mwebs.Caption:=txt_search_web;
pmbcweb.Caption:=txt_search_web;
pmbcproperties.Caption:=txt_4_5_properties;
pmbcexplore.Caption:=txt_explore_path;
po_im.Caption:=txt_4_8_imagemanager;
po_im_rl.Caption:=txt_4_8_rl;
po_im_rr.Caption:=txt_4_8_rr;
po_im_crop.Caption:=txt_4_8_crop;
po_im_modify.Caption:=txt_4_8_t;
mtstyle.Caption:=txt_4_9_style;
mtstyle_none.Caption:=txt_2_9_none;
mtstyle_shadow.Caption:=txt_4_9_shadow;
mtstyle_frame.Caption:=txt_4_9_frame;
msamplescripts.Caption:=txt_8_5_samplescripts;
mprelist.Caption:=txt_8_5_listlarge;
imagesp.Hint:=txt_2_9_navbar;
mbrowsersizes.Caption:=txt_2_9_st;
mbrowsersizem.Caption:=txt_2_9_mt;
mbrowsersizel.Caption:=txt_2_9_lt;
pmif1.Caption:=txt_4_8_fit+' 1024 x 768 (4:3) XGA, iPad';
po_im_1024.Caption:=txt_4_8_fit+' 1024 x 768 (4:3) XGA, iPad';
pmif2.Caption:=txt_4_8_fit+' 1280 x 800 (16:10) WXGA, Nexus';
pmif3.Caption:=txt_4_8_fit+' 1920 x 1080 (16:9) FullHD';
po_im_hd.Caption:=txt_4_8_fit+' 1920 x 1080 (16:9) FullHD';
pmif4.Caption:=txt_4_8_fit+' 1920 x 1200 (16:10) WUXGA';
po_im_wuxga.Caption:=txt_4_8_fit+' 1920 x 1200 (16:10) WUXGA';
pmif5.Caption:=txt_4_8_fit+' 2048 x 1536 (4:3) iPad Retina';
pmif6.Caption:=txt_4_8_fit+' 4K UHD 3840 x 2160 (16:9) 8.3MP';
po_im_4ktv.Caption:=txt_4_8_fit+' 4K UHD 3840 x 2160 (16:9) 8.3MP';
pmif7.Caption:=txt_4_8_fit+' 4K DCI 4096 x 2160 (19:10) 8.8MP';
po_im_4kcinema.Caption:=txt_4_8_fit+' 4K DCI 4096 x 2160 (19:10) 8.8MP';
pmif8.Caption:=txt_4_8_fit+' 8K FUHD 7680 x 4320 (16:9) 33.2MP';
pmirflip.Caption:=txt_4_8_flip;
pmirmirror.Caption:=txt_4_8_mirror;
modock.Caption:=txt_4_5_dock;
mopresets.Caption:=txt_4_8_presets+' (Alt+6)';
mprelightlist.Caption:=txt_4_8_listno;
mprelight.Caption:=txt_4_8_detailsno;
mpredetails.Caption:=txt_8_5_detailslarge;
mpreaverage.Caption:=txt_4_8_iconm;
mprelarge.Caption:=txt_4_8_iconl;
pmstyle1.Caption:=txt_4_8_detailsno;
pmstyle2.Caption:=txt_8_5_detailslarge;
pmstyle3.Caption:=txt_4_8_listno;
pmstyle4.Caption:=txt_8_5_listlarge;
pmstyle5.Caption:=txt_4_8_iconm;
pmstyle6.Caption:=txt_4_8_iconl;
pmshowmainmenu.Caption:=txt_9_0_showmainmenu;
pmshowstylemenu.Caption:=txt_8_7_showsm;
po_showquicknavmenu.Caption:=txt_9_0_navmenu;
MenuItemShowColMenu.Caption:=txt_8_7_showhm;
pmtool1.Caption:=txt_4_6_am;
pmtool2.Caption:=txt_4_6_fm;
pmtool3.Caption:=txt_4_8_imagemanager;
pmsnav.Caption:=txt_2_9_nav;
pmstree.Caption:=txt_2_9_tree;
MenuItemTB.Caption:=txt_2_9_toolbar;
pmtoollarge.Caption:=txt_2_9_lt;
pmtoolmedium.Caption:=txt_2_9_mt;
pmtoolnone.Caption:=txt_2_9_none;
pmsnone.Caption:=txt_2_9_none;
pmstatusnone.Caption:=txt_2_9_none;
pmsno.Caption:=txt_2_9_none;
pmtab.Caption:=txt_6_4_tabbar;
mtab.Caption:=txt_6_4_tabbar;
pmrow.Caption:=txt_2_8_rowselect;
pmthemes.Caption:=txt_settings;
motl.Caption:=txt_4_5_t+'-'+txt_4_5_l;
mot.Caption:=txt_4_5_t;
motr.Caption:=txt_4_5_t+'-'+txt_4_5_r;
mor.Caption:=txt_4_5_r;
mobr.Caption:=txt_4_5_b+'-'+txt_4_5_r;
mob.Caption:=txt_4_5_b;
mobl.Caption:=txt_4_5_b+'-'+txt_4_5_l;
mol.Caption:=txt_4_5_l;
modefault.Caption:=txt_level_normal;
mfullscreen.Caption:=txt_4_8_fullscreen;
mimmersive.Caption:=txt_4_8_immersive;
po_flat.caption:=txt_toggle_browseflat;
themes_download.caption:=txt_3_5_td;
mdownloadthemes.caption:=txt_3_5_td;
pmopenout.caption:=txt_2_7_oop;
mtoggleop.caption:=txt_2_7_oop;
pmqenopath.caption:=txt_3_4_nopaths;
pmqen1.caption:=txt_skip_existing;
pmqen2.caption:=txt_ren_extracted;
pmqen3.caption:=txt_ren_existing;
pmqen4.caption:=txt_overwrite;
pmqen5.caption:=txt_overwrite_askbefore;
pmqenewfolder.caption:=txt_newfoldermenu+' (Ctrl+N)';
pmqnointdir.caption:=txt_5_5_intdir;
CheckBoxFolder1.caption:=txt_5_5_intdir;
MenuItemExtAllTo.caption:=txt_ext_allto+'... (Ctrl+Alt+E / F12)';
MenuItemExtAllHere.caption:=txt_ext_allhere;
MenuItemExtAllHereSmart.caption:=txt_7_1_smart;
MenuItemExtAllHereNew.caption:=txt_7_1_new;
po_addsep.caption:=txt_2_7_separate;
mmore.Caption:=txt_3_1_more;
pmqeto.caption:=txt_ext_allto+'... (Ctrl+Alt+E / F12)';
pmqehere.caption:=txt_ext_allhere+' (Ctrl+Shift+Alt+E)';
pmqeheresmart.caption:=txt_7_1_smart+' (Ctrl+Shift+Alt+S)';
pmqeherenew.caption:=txt_7_1_new+' (Ctrl+Shift+Alt+N)';
pmqedesk.caption:=txt_ext_allto+' '+txt_desktop+' (Ctrl+Alt+D)';
pmqedocuments.caption:=txt_ext_allto+' '+txt_2_4_documents+' (Ctrl+Shift+Alt+D)';
mSystemIntegration.caption:=txt_3_0_configure;
msmallicon.caption:=txt_3_4_smallicons;
mbreset.caption:=txt_5_0_removeall;
LabelTitleOptions5.Caption:=txt_3_3_apps+'   ';
LabelTitleOptions6.Caption:=txt_theme+'   ';
panelnav4.hint:=txt_4_9_style;
imageflat.hint:=txt_4_9_style;
morganize.Caption:=txt_2_9_organize;
mlayout.Caption:=txt_layout;
pmmstatus_status.Caption:=txt_2_8_statusbar;
pmsstatus.Caption:=txt_2_8_statusbar;
pmmstatus_bookmarks.Caption:=txt_bookmarks;
pmmstatus_ra.Caption:=txt_list_history;
pmmstatus_r.Caption:=txt_5_0_sh;
pmmstatus_clipboard.Caption:=txt_2_7_clipboard;
pmclip.Caption:=txt_2_7_clipboard;
po_clip.Caption:=txt_2_7_clipboard;
pmsbookmarks.Caption:=txt_bookmarks;
pmshistory.Caption:=txt_list_history;
pmssession.Caption:=txt_5_0_sh;
pmsclipboard.Caption:=txt_2_7_clipboard;
pms2a_add.Caption:=txt_add_toarchive;
pms2a_ext.Caption:=txt_caption_extract;
pms2a_copy.Caption:=txt_2_9_copyhere;
pms2a_move.Caption:=txt_2_9_movehere;
pms2a_open.Caption:=txt_openarchive;
pms2a_cancel.Caption:=txt_2_7_cancel;
pma2s_copy.Caption:=txt_2_9_copyhere;
pma2s_move.Caption:=txt_2_9_movehere;
pma2s_extract.Caption:=txt_ext_here;
pma2s_extnew.Caption:=txt_ext_here+' '+txt_newfolder;
pma2s_cancel.Caption:=txt_2_7_cancel;
pma2s_extract1.Caption:=txt_ext_sel_here;
pma2s_extractall1.Caption:=txt_ext_allhere;
pma2s_extnew1.Caption:=txt_ext_sel_here+' '+txt_newfolder;
pma2s_extallnew1.Caption:=txt_ext_allhere+' '+txt_newfolder;
pma2s_cancel1.Caption:=txt_2_7_cancel;
mopenasarchive.Caption:=txt_2_8_viewasarchive+' '+txt_2_8_experimental;
po_openunitasarchivelin.Caption:=txt_2_8_viewasarchive+' '+txt_2_8_experimental;
mbrowser.Caption:=txt_browser;
mswapbars.Caption:=txt_3_7_swapbars;
mDetails.Caption:=txt_2_8_details;
mrowselect.Caption:=txt_2_8_rowselect;
mlargeicons.Caption:=txt_9_1_enlargeicons;
mlargeicons.hint:=txt_7_8_requirerestart;
mthl.Caption:=txt_2_9_thl;
mList.Caption:=txt_caption_list;
MenuItemPW.Caption:=txt_2_7_setpw;
mpw2.Caption:=txt_2_7_setpw;
mjob.Caption:=txt_savejob;
mjob2.Caption:=txt_savejob;
CheckBox1.Caption:=txt_2_7_es;
CheckBox2.Caption:=txt_2_7_eu;
pmjb24.Caption:=txt_bookmarks+'...';
mr9.Caption:=txt_list_history+'...';
pmhr9.Caption:=txt_list_history+'...';
smbookmarks1.Caption:=txt_bookmarks;
smbookmarksa1.Caption:=txt_bookmarks;
smHistory1.Caption:=txt_list_history;
pmExploremenu.Caption:=txt_open_path;
pmFoldersmenu.Caption:=txt_nfiles+' / '+txt_nfolders;
pmAdvanced.Caption:=txt_2_6_advanced;
pmemb0.Caption:=txt_bookmarks;
pmemr0.Caption:=txt_list_history;
pmembf0.Caption:=txt_bookmarks;
pmemrf0.Caption:=txt_list_history;
pnhf0.Caption:=txt_5_0_sh;
pnbcf0.Caption:=txt_5_0_bc;
pnhe0.Caption:=txt_5_0_sh;
pnbce0.Caption:=txt_5_0_bc;
smHistorya1.Caption:=txt_list_history;
smfs1.Caption:=txt_fs;
smfsa1.Caption:=txt_fs;
MenuItemOpen_Last.Caption:=txt_lastused;
mpathreset1.Caption:=txt_lastused;
MenuItemArchive_home1.Caption:=txt_2_9_home;
mpathdesk1.Caption:=txt_desktop;
MenuItemArchive_documents1.Caption:=txt_2_4_documents;
mpathexplore1.Caption:=txt_explore_path;
menuitemextexplore.Caption:=txt_explore_path;
mdefarcset.Caption:=txt_7_6_setcurdef;
mdefextset.Caption:=txt_7_6_setcurdef;
MenuItemOpen_here.Caption:=txt_2_7_selpath;
mpathself1.Caption:=txt_2_7_selpath;
pmjumpsbook.Caption:=txt_bookmarks;
pmbreadfs.Caption:=txt_fs;
pmbreadfun.Caption:=txt_open;
mrecent9.Caption:=txt_list_history+'...';
pmh9.Caption:=txt_list_history+'...';
mhistory.Caption:=txt_list_history;
mtray.Caption:=txt_2_5_tray;
tmquit.Caption:=txt_quit;
tmcreate.Caption:=txt_create_archive;
tmopenpath.Caption:=txt_open_path;
tmopenarchive.Caption:=txt_openarchive;
pmmorehex.Caption:=txt_2_4_hexp;
po_hexp.Caption:=txt_2_4_hexp;
pmmorecheck.Caption:=txt_check;
MenuItemToolhexp.Caption:=txt_2_4_hexp;
MenuItemOpen_documents1.Caption:=txt_2_4_documents;
pmJumpDocuments.Caption:=txt_2_4_documents;
pmquickhome.Caption:=txt_2_9_home;
pmquickdesk.Caption:=txt_desktop;
pmquickdownloads.Caption:=txt_3_1_downloads;
pmquickop.Caption:=txt_open_path;
pmquickoa.Caption:=txt_openarchive;
pmquicksd.Caption:=txt_searchanddrag;
pmJumppubhome.Caption:=txt_2_9_home+' - '+txt_2_9_public;
MenuItemArchive_pubhome.Caption:=txt_2_9_home+' - '+txt_2_9_public;
MenuItemOpen_pubhome.Caption:=txt_2_9_home+' - '+txt_2_9_public;
pmJumppubdoc.Caption:=txt_2_4_documents+' - '+txt_2_9_public;
pmjumprecent.Caption:=txt_list_history;
pmjumpdownloads.Caption:=txt_3_1_downloads;
pmjumpsearches.Caption:=txt_3_1_src;
pmjumplibraries.Caption:=txt_3_1_lib;
MenuItemOpen_downloads1.Caption:=txt_3_1_downloads;
MenuItemArchive_downloads.Caption:=txt_3_1_downloads;
MenuItemArchive_pubdoc.Caption:=txt_2_4_documents+' - '+txt_2_9_public;
MenuItemOpen_pubdoc.Caption:=txt_2_4_documents+' - '+txt_2_9_public;
pclip_removeitem.Caption:=txt_2_4_removefromclipboard;
pclip_clearclip.Caption:=txt_2_4_clearclipboard;
CheckBoxAltgridcol.Caption:=txt_8_0_altcol;
LabelColorTabs.Caption:=txt_8_3_htab;
po_sysinfo.Caption:=txt_info;
po_Envstr.Caption:=txt_2_3_envstr;
po_dispenvstrlin.Caption:=txt_2_3_envstr;
cbType.Items[0]:=STR_7Z;
cbType.Items[1]:=STR_ARC;
cbType.Items[2]:=STR_BROTLI;
cbType.Items[3]:=STR_BZIP2;
testwinrar;
if havewinrar=false then
   begin
   cbType.Items[4]:=txt_custom;
   mprofilerar.visible:=false;
   end
else
   begin
   cbType.Items[4]:=txt_custom+'/RAR';
   mprofilerar.visible:=true;
   end;
cbType.Items[5]:=STR_GZIP;
cbType.Items[6]:=STR_PEA;
cbType.Items[7]:=STR_QUAD;
cbType.Items[8]:=txt_sfx+' '+STR_7Z;
cbType.Items[9]:=txt_sfx+' '+STR_ARC;
cbType.Items[10]:=txt_split;
cbType.Items[11]:=STR_TAR;
cbType.Items[12]:=STR_UPX;
cbType.Items[13]:=STR_WIM;
cbType.Items[14]:=STR_XZ;
cbType.Items[15]:=STR_ZIP;
cbType.Items[16]:=STR_ZSTD;
cbType.Items[17]:=STR_ZPAQ;
RadioGroup0.Items[0]:=STR_7Z;
RadioGroup0.Items[1]:=STR_ARC;
RadioGroup0.Items[2]:=STR_BROTLI;
RadioGroup0.Items[3]:=STR_BZIP2;
RadioGroup0.Items[4]:=txt_custom;
RadioGroup0.Items[5]:=STR_GZIP;
RadioGroup0.Items[6]:=STR_PEA;
RadioGroup0.Items[7]:=STR_QUAD;
RadioGroup0.Items[8]:=txt_sfx+' '+STR_7Z;
RadioGroup0.Items[9]:=txt_sfx+' '+STR_ARC;
RadioGroup0.Items[10]:=txt_split;
RadioGroup0.Items[11]:=STR_TAR;
RadioGroup0.Items[12]:=STR_UPX;
RadioGroup0.Items[13]:=STR_WIM;
RadioGroup0.Items[14]:=STR_XZ;
RadioGroup0.Items[15]:=STR_ZIP;
RadioGroup0.Items[16]:=STR_ZSTD;
RadioGroup0.Items[17]:=STR_ZPAQ;
RadioGroup0.Items[18]:=txt_lastused;
status0:=APPMAIN+' '+PEAZIPVERSION+PEAZIPREVISION;
ComboBoxArchive1.Items.Strings[0]:=txt_singlevol;
ComboBoxArchive1.Items.Strings[1]:=txt_customsize;
ComboBoxArchive1.Items.Strings[2]:=txt_fd;
ComboBoxArchive1.Items.Strings[3]:=txt_attach10;
ComboBoxArchive1.Items.Strings[4]:=txt_4_8_attach25;
ComboBoxArchive1.Items.Strings[5]:=txt_cd650;
ComboBoxArchive1.Items.Strings[6]:=txt_cd700;
ComboBoxArchive1.Items.Strings[7]:=txt_fat32;
ComboBoxArchive1.Items.Strings[8]:=txt_dvd;
ComboBoxArchive1.Items.Strings[9]:=txt_dvddl;
ComboBoxArchive1.Items.Strings[10]:='25 GB Blu-Ray';
CheckBoxTarBefore.Caption:=txt_tarbefore;
CheckBoxTarBefore.Hint:=txt_tarbefore_hint;
cbadvf1.Caption:=txt_advfilters;
LabelPanelHintAdd.caption:=txt_2_7_archivehint;
LabelPanelHintExtract.caption:=txt_2_7_exthint;
CheckBoxSeparate.Caption:=txt_2_7_separate;
CheckBoxConvert.Caption:=txt_2_8_convertexisting;
CheckBoxConvert0.Caption:=txt_6_5_chp;
CheckBoxConvert1.Caption:=txt_5_6_verbose;
po_convertarchive.Caption:=txt_2_8_convert;
EditOParc.Hint:=txt_otherparams;
EditOP.Hint:=txt_otherparams;
EditOPcustom.Hint:=txt_otherparams;
Label7za9.Caption:=txt_level;
RadioGroupPaq.Caption:=txt_paqver;
Label7za7.Caption:=txt_level;
CheckBoxUPX1.Caption:=txt_strip;
CheckBoxUPX2.Caption:=txt_backupexe;
CheckBoxUPX2.Hint:=txt_backupexe_hint;
RadioGroupQuad.Caption:=txt_exe;
CheckBoxQuadMax.Caption:=txt_maxcomp;
CheckBoxQuadMax.Hint:=txt_slowercomp;
Label7za10.Caption:=txt_level;
LabelPEA6.Caption:=txt_encryption;
LabelPEA7.Caption:=txt_peaobj;
LabelPEA8.Caption:=txt_volumepea;
LabelSplit.Caption:=txt_integrity;
LabelSplit.Hint:=txt_check_hint;
Subtitle7zaopt1.Caption:=txt_options;
Label7za1.Caption:=txt_function;
Label7za8.Caption:=txt_6_4_paths;
ComboBoxArchivePaths.Items.Strings[0]:=txt_6_4_relative;
ComboBoxArchivePaths.Items.Strings[1]:=txt_6_4_full;
ComboBoxArchivePaths.Items.Strings[2]:=txt_6_4_absolute;
ComboBoxArchivePaths1.Items.Strings[0]:=txt_6_4_relative;
ComboBoxArchivePaths1.Items.Strings[1]:=txt_6_4_full;
ComboBoxArchivePaths1.Items.Strings[2]:=txt_6_4_absolute;
Label7za2.Caption:=txt_threads;
LabelArchiveOther.Caption:=txt_other;
CheckBoxArchive4.Caption:=txt_sendbymail;
CheckBoxArchive4.Hint:=txt_attach;
CheckBoxMailKeep.Caption:=txt_4_8_keeparchive;
Subtitle7zaopt2.Caption:=txt_encryption;
Label7za18.Caption:=txt_algo;
Subtitle7zaopt.Caption:=txt_compression;
Label7za4.Caption:=txt_method;
Label7za3.Caption:=txt_level;
Label7za5.Caption:=txt_dictionary;
Label7za6.Caption:=txt_word;
Label7zaPasses.Caption:=txt_passes;
Label7zsolidblock.Caption:=txt_solid_block;
Labelbcmblock.Caption:=txt_solid_block;
CheckBoxArchive6.Caption:=txt_create_sfx;
RadioGroupArchive.Caption:=txt_sfx_interface;
CheckBoxArchiveOF.Caption:=txt_compress_openforwriting;
CheckBoxMQS.Caption:=txt_6_0_msq;
pmbcexpand.Caption:=txt_6_1_ec;
apmbcexpand.Caption:=txt_6_1_ec;
cbencext.Caption:=txt_6_2_encext;
CheckBoxArchiveOF.Hint:=txt_openfiles_hint;
LabelArchiveOther2.Caption:=txt_parameters;
LabelCustom.Caption:=txt_exe_hint;
LabelArchiveOther3.Caption:=txt_syntax;
LabelArchiveOther8.Caption:=txt_exe;
LabelArchiveOther4.Caption:=txt_ext;
LabelArcSub1.Caption:=txt_compression;
Label7za11.Caption:=txt_level;
LabelARCsolidblock.Caption:=txt_solid;
CheckBoxARC1.Caption:=txt_rr;
CheckBoxARC1.Hint:=txt_rr_hint;
CheckBoxARC3.Caption:=txt_4_2_arcabspath;
CheckBoxARC2.Caption:=txt_create_sfx;
LabelArcSub2.Caption:=txt_options;
Subtitleschopt.Caption:=txt_6_5_def;
Subtitleschopt1.Caption:=txt_6_5_def;
Label7za12.Caption:=txt_function;
LabelArchiveOther1.Caption:=txt_other;
LabelArcSub3.Caption:=txt_encryption;
Label7za14.Caption:=txt_algo;
CheckBoxDate.Caption:=txt_timestamp;
cbcustext.Caption:=txt_7_8_custext;
iConsoleCreateImport.Hint:=txt_pj_hint;
ImageInfoArchive3.hint:=txt_pj_hint2;
lConsoleCreate_jobcode.Caption:=txt_job_code;
lConsoleCreate_outname.Caption:='outname'; //overwritten, don't need to be translated
Image7zPj.Caption:=txt_savejob;
Image7zPj.Hint:=txt_savejobdefinition_hint;
Image7zPj1.Caption:=txt_launch;
ButtonArchive.Caption:=txt_2_7_ok;
ButtonArchive.Hint:='Ctrl+Alt+Enter';
ButtonExtOk.Caption:=txt_2_7_ok;
ButtonExtOk.Hint:='Ctrl+Alt+Enter';
ButtonArchive1.Caption:=txt_2_7_cancel;
ButtonExtCancel.Caption:=txt_2_7_cancel;
mkeyfile.Caption:=txt_4_7_pk;
mpm.caption:=txt_4_3_pwman;
mscripts.caption:=txt_4_5_pj;
TrayIcon1.hint:='PeaZip | '+txt_5_6_rc;
mlayouts.caption:=txt_5_6_layouts;
ButtonUn7zaTo.Caption:=txt_caption_extract;
ButtonUn7za1.Caption:=txt_caption_test;
ButtonUn7za4.Caption:=txt_add;
ButtonUn7za5.Caption:=txt_2_8_convert;
cbUn7zaRecursive.Caption:=txt_filters_recourse;
cbUn7zaRecursiveExclude.Caption:=txt_exclude_recourse;
MenuItemHistoryBook.Caption:=txt_add_tobookmarks;
ButtonUn7za4.Hint:=txt_add_tolayout;
EditUn7zaFilter1.Hint:=txt_address_hint;
Imagelistsearch.Hint:=txt_searchfor;
Imagelistsearch1.Hint:=txt_reset;
pmireset.Caption:=txt_reset;
pmrsearch.Caption:=txt_searchfor+'...';
pmsrec.Caption:=txt_2_9_rec;
ctrlhistory.Hint:=txt_list_history;
ctrlup.Hint:=txt_up;
ButtonEditName12.Hint:=txt_browse;
ButtonEditName14.Hint:=txt_browse;
ButtonUn7za10.Hint:=txt_browse;
RadioGroupAction.Caption:=txt_action;
CheckBoxUnPeaAttributes.Caption:=txt_restore_att;
LabelArchiveOther5.Caption:=txt_parameters;
iadvextract.hint:=txt_exe_hint;
LabelArchiveOther6.Caption:=txt_syntax;
LabelArchiveOther7.Caption:=txt_exe;
pcustompathexplore.Caption:=txt_explore_path;
Label10.Caption:=txt_2_7_output;
Label11.Caption:=txt_function;
Label12.Caption:=txt_naming;
Labelstatus4.Caption:='';
Labelstatus6.Caption:=txt_2_7_output;
Labelstatus6a.Caption:=txt_type;
Labelstatus6b.Caption:=txt_level;
Labelstatus6c.Caption:=txt_function;
Labelstatus6d.Caption:=txt_split;
Labelstatus7.Caption:=txt_2_7_output;
Labelstatus10.Caption:=txt_path;
Labelstatus8.Caption:=txt_function;
cbadvf2.Caption:=txt_advfilters;
labelstatus5.Caption:='['+txt_ext_all+']';
CheckBoxFolder.Caption:=txt_newfoldermenu;
CheckBoxDeleteInput.Caption:=txt_5_4_deletearchives;
CheckBoxDeleteInput1.Caption:=txt_5_4_deletefiles;
cbdeleteinputmode.Clear;
{$IFDEF MSWINDOWS}
cbdeleteinputmode.DropDownCount:=4;
cbdeleteinputmode.Items.Append(txt_4_7_recycle);
cbdeleteinputmode.Items.Append(txt_quickdelete);
cbdeleteinputmode.Items.Append(txt_5_2_zerofiles);
cbdeleteinputmode.Items.Append(txt_securedelete);
{$ELSE}
{$IFDEF DARWIN}
cbdeleteinputmode.DropDownCount:=4;
cbdeleteinputmode.Items.Append(txt_4_7_recycle);
cbdeleteinputmode.Items.Append(txt_quickdelete);
cbdeleteinputmode.Items.Append(txt_5_2_zerofiles);
cbdeleteinputmode.Items.Append(txt_securedelete);
{$ELSE}
cbdeleteinputmode.DropDownCount:=3;
cbdeleteinputmode.Items.Append(txt_quickdelete);
cbdeleteinputmode.Items.Append(txt_5_2_zerofiles);
cbdeleteinputmode.Items.Append(txt_securedelete);
{$ENDIF}
{$ENDIF}
cbdeleteinputmode.ItemIndex:=0;
cbdeleteinputmode1.Clear;
{$IFDEF MSWINDOWS}
cbdeleteinputmode1.DropDownCount:=4;
cbdeleteinputmode1.Items.Append(txt_4_7_recycle);
cbdeleteinputmode1.Items.Append(txt_quickdelete);
cbdeleteinputmode1.Items.Append(txt_5_2_zerofiles);
cbdeleteinputmode1.Items.Append(txt_securedelete);
{$ELSE}
{$IFDEF DARWIN}
cbdeleteinputmode1.DropDownCount:=4;
cbdeleteinputmode1.Items.Append(txt_4_7_recycle);
cbdeleteinputmode1.Items.Append(txt_quickdelete);
cbdeleteinputmode1.Items.Append(txt_5_2_zerofiles);
cbdeleteinputmode1.Items.Append(txt_securedelete);
{$ELSE}
cbdeleteinputmode1.DropDownCount:=3;
cbdeleteinputmode1.Items.Append(txt_quickdelete);
cbdeleteinputmode1.Items.Append(txt_5_2_zerofiles);
cbdeleteinputmode1.Items.Append(txt_securedelete);
{$ENDIF}
{$ENDIF}
cbdeleteinputmode1.ItemIndex:=0;
LabelTitleAdd1.Caption:='      '+txt_archive+'      ';
LabelTitleAdd2.Caption:='      '+txt_2_6_advanced+'      ';
LabelTitleAdd3.Caption:='      '+txt_console+'      ';
LabelTitleAdd4.Caption:='      '+txt_5_1_schedule+'      ';
labeltitleextract1.Caption:='      '+txt_caption_extract+'      ';
labeltitleextract2.Caption:='      '+txt_2_6_advanced+'      ';
labeltitleextract3.Caption:='      '+txt_console+'      ';
labeltitleextract4.Caption:='      '+txt_5_1_schedule+'      ';
CheckBoxClip.Caption:=txt_2_4_advclip;
ImageUn7zPj.Caption:=txt_savejob;
ImageUn7zPj.Hint:=txt_savejobdefinition_hint;
iConsoleCreateImport1.Hint:=txt_pj_hint;
ImageInfoArchive4.Hint:=txt_pj_hint2+char($0D)+char($0A)+char($0D)+char($0A)+txt_8_8_intnote;
lConsoleCreate_jobcode1.Caption:=txt_job_code;
lConsoleCreate_outname1.Caption:='outname'; //overwritten, doesn't need translation
Image7zPj3.Caption:=txt_launch;
ImageInfoDefault1.Hint:=txt_cl_hint;
ImageInfoDefault2.Hint:=txt_2_5_langhint;
Labeloaui.Caption:=txt_backend;
Labelcb17.Caption:=txt_desktop;
Labelcb19.Caption:=txt_custom;
LabelcbSD.Caption:=txt_5_9_start;
ComboBoxSD.Items[0]:=txt_5_4_lv;
ComboBoxSD.Items[1]:=txt_mypc;
ComboBoxSD.Items[2]:=txt_desktop;
ComboBoxSD.Items[3]:=txt_2_9_home;
ComboBoxSD.Items[4]:=txt_custom;
Labeltitleoptions7.Caption:=txt_2_5_help;
Labeltitleoptions8.Caption:=txt_about;
Labelo8.Caption:=txt_about;
CheckBoxrelative.Caption:=txt_7_8_rel;
CheckBoxrelative.Hint:='(7z / p7zip) '+txt_8_5_intext;
CheckBoxAutoOpen.Caption:=txt_2_7_oop;
CheckBoxAutoTest.Caption:=txt_8_8_autotest;
CheckBoxSameArc.Caption:=txt_5_2_oadd;
CheckBoxSameExt.Caption:=txt_5_2_oext;
CheckBoxnameasparentfolder.Caption:=txt_3_7_nameasparent;
CheckBoxzpaqall.Caption:=txt_7_2_zpaqall;
CheckBoxzpaqfull.Caption:=txt_6_4_full;
CheckBoxzpaqabsolute.Caption:=txt_6_4_absolute;
CheckBoxzpaqforce.Caption:=txt_overwrite;
pmapp.Caption:=txt_3_3_apps;
pmapprun.Caption:=txt_3_3_run;
Labelo1.Caption:=txt_general;
Labelo2.Caption:=txt_2_6_advanced;
Labelo3.Caption:=txt_4_6_am;
Labelo4.Caption:=txt_4_6_fm;
Labelo5.Caption:=txt_3_3_apps;
Labelo6.Caption:=txt_theme;
Labelo7.Caption:=txt_2_5_help;
Labelogperf.Caption:=txt_5_0_perf;
Labelcb7.Caption:=txt_reset+' '+txt_3_3_apps;
LabelTitleOptions1.Caption:=txt_general+'   ';
labelmaxarg.Caption:=txt_8_3_maxarg;
CheckBoxSkipDel.Caption:=txt_8_3_skipdel;
LabelTitleOptions2.Caption:=txt_2_6_advanced+'   ';
Labeloaenc.Caption:=txt_2_5_encoding;
Labelconsoleencoding.Caption:=txt_3_1_sccenc;
cbEncoding1.Caption:=txt_3_2_7zutf8nonascii;
CheckBoxJobEncoding.Caption:=txt_2_5_encpj;
CheckBoxDragDrop.Caption:=txt_6_8_ndrop;
CheckBoxEditArchives.Caption:=txt_6_9_autou;
cbSys7zlin.Caption:=txt_7_7_sys7z;
cbSys7zlin.Hint:=txt_7_7_sys7zreq;
mForceSyncedits.Caption:=txt_6_9_forceu;
mForceSynceditsClear.Caption:=txt_7_2_updateclear;
mForceClear.Caption:=txt_7_2_clearnoupdate;
CheckBoxClosePeaZip.Caption:=txt_7_2_autoclosepeazip;
CheckBoxSkipenc.Caption:=txt_8_2_skipet;
{$IFDEF MSWINDOWS}
cbSys7zlin.visible:=false;
labelmaxarg.visible:=false;
ComboBoxMaxArg.visible:=false;
{$ELSE}
CheckBoxDragDrop.visible:=false;
ComboBoxDrag.visible:=false;
CheckBoxzcopy.visible:=false;
CheckBoxnetworkinfo.visible:=false;
{$ENDIF}
mverifyself.Caption:=txt_8_7_verifybin;
pmshowsearch.Caption:=txt_8_7_showsearchbar;
csvsepchar.Caption:=txt_8_7_csv;
csvsepchar.Hint:=txt_8_7_csvhelp;
EditCSVsep.Hint:=txt_8_7_csvhelp;
mprofileimmediate.caption:=txt_8_6_immediate;
CheckBoxShowVolatile.Caption:=txt_6_5_showvolatile;
CheckBoxAutoOpenTar.Caption:=txt_7_0_autoopentar;
CheckBoxAutoExtTar.Caption:=txt_9_0_autoexttar+' / '+upcase(txt_caption_extract);
CheckBoxAutoExtTar1.Caption:=txt_9_0_autoexttar+' / '+upcase(txt_2_8_convert);
CheckBoxForceOpen.Caption:=txt_6_5_force;
CheckBoxForceLayout.Caption:=txt_8_5_loadlayout;
CheckBoxForceEdit.Caption:=txt_6_6_forcemodify;
CheckBoxExcludeEF.Caption:=txt_9_1_ef;
CheckBoxForceBrowse.Caption:=txt_8_0_forcebrowse;
CheckBoxForceConvert.Caption:=txt_8_0_forceconvert;
pmrsh.Caption:=txt_6_6_rsh;
CheckBoxEncoding.Caption:=txt_2_5_langflag;
CheckBoxWindowStatus.Caption:=txt_save_winstate;
CheckBoxArchiveHistory.Caption:=txt_savehistory;
CheckBoxShowHints.Caption:=txt_showhints;
LabelTitleOptions3.Caption:=txt_4_6_am+'   ';
MenuItemEnumerate.Caption:=txt_5_0_enum;
CheckboxEnumd.Caption:=txt_5_0_enum;
labelRARdict.Caption:=txt_dictionary+' (MB)';
cbRARsfx.Caption:=txt_sfx;
cbRARsolid.Caption:=txt_solid;
cbRARrr.Caption:=txt_rr;
cbRARsaveopen.Caption:=txt_compress_openforwriting;
cbRARsavesecurity.Caption:=txt_6_5_sni;
cbRARsavestreams.Caption:=txt_6_5_sns;
cbRARlastmodtime.Items[0]:=txt_7_4_tcurr;
cbRARlastmodtime.Items[1]:=txt_7_4_tkeep;
cbRARlastmodtime.Items[2]:=txt_7_3_stl;
Labelogreset.Caption:=txt_6_5_privacy;
Labelogpaths.Caption:=txt_path;
Labelcb14.Caption:=txt_default_format;
RadioGroupBrowser.Items.Strings[0]:=txt_browser;
RadioGroupBrowser.Items.Strings[1]:=txt_flat;
RadioGroupBrowser.Items.Strings[2]:=txt_lastused;
CheckBox4.Caption:=txt_ignore_ext;
cbautoclosesingleextract.Caption:=txt_7_5_autoclosesingle;
Labelextevfor.Caption:=txt_7_5_ee;
cbExtEvForWhen.Items.Strings[0]:=txt_7_5_never;
cbExtEvForWhen.Items.Strings[1]:=txt_7_5_ask;
cbExtEvForWhen.Items.Strings[2]:=txt_7_5_always;
cbExtEvForHow.Items.Strings[0]:=txt_all_default;
cbExtEvForHow.Items.Strings[1]:=txt_displayedobjects;
CheckBoxIgnoreSel.Caption:=txt_ignore_sel;
CheckBoxExtAnd.Caption:=txt_8_0_enableextand;
CheckBoxIgnoreDisp.Caption:=txt_ignore_disp;
CheckBoxIntDir.Caption:=txt_5_5_intdir;
CheckBoxPrebrowse.Caption:=txt_browser;
Lpriority.Caption:=txt_7_8_tpriority;
ComboBoxPriority.Items[0]:=txt_7_8_priorityrealtime;
ComboBoxPriority.Items[1]:=txt_7_8_priorityhigh;
ComboBoxPriority.Items[2]:=txt_7_8_prioritynormal;
ComboBoxPriority.Items[3]:=txt_7_8_priorityidle;
CheckBoxBrowseNotVerbose.Caption:=txt_8_2_vreport+' '+txt_faster;
CheckBoxPrebrowse.Hint:=txt_quickbrowse_hint;
Labeloamext.Caption:=txt_caption_extract;
Labeloamext1.Caption:=txt_archive;
Labeloafter.Caption:=txt_8_7_after;
RadioGrouppwrequest.Items[0]:=txt_2_3_never_pw;
RadioGrouppwrequest.Items[1]:=txt_2_3_test_pw100;
RadioGrouppwrequest.Items[2]:=txt_2_9_test_pw2G;
RadioGrouppwrequest.Items[3]:=txt_2_3_test_pw;
RadioGrouppwrequest.Items[4]:=txt_always_pw;
LabelTitleOptions4.Caption:=txt_4_6_fm+'   ';
Labeloptsub6.Caption:=txt_browser;
cbqdup.caption:=txt_9_1_qdup;
LabelOptsub1.Caption:=txt_filetools;
Labeloptsub3.Caption:=txt_dispaly;
Labeloptsub4.Caption:=txt_check_select;
Labeloptsub5.Caption:=txt_check_select;
Labeloptsub6.Caption:=txt_8_3_prefalgo;
RadioGroup3.Items.Strings[0]:=txt_8_3_prefalgo;
RadioGroup3.Items.Strings[1]:=txt_performall;
LabelOptsub2.Caption:=txt_8_3_mbu;
ComboBoxKiB.Items[0]:=txt_8_3_mbubin;
ComboBoxKiB.Items[1]:=txt_8_3_mbudec;
ComboBoxKiB.Items[2]:=txt_2_9_none;
LabelOptsub2.Caption:=txt_securedelete;
ComboBoxPasses.Items[0]:=txt_level_fastest;
ComboBoxPasses.Items[1]:=txt_level_fast;
ComboBoxPasses.Items[2]:=txt_level_normal;
ComboBoxPasses.Items[3]:=txt_8_1_slow;
ComboBoxPasses.Items[4]:=txt_8_1_vslow;
theme_label1.Hint:=txt_reset_theme;
LabelAdvThemes.Caption:=txt_2_6_advanced;
LabelConfigurePeaZip.Caption:=txt_3_0_configure;
LabelConfigurePeaZip.Hint:=txt_3_0_configure+' '+txt_7_8_requirerestart;
LabelConfigurePw.Caption:=txt_8_0_setpwopt;
LabelConf1.Caption:=txt_3_2_conf;
LabelConfigureSendTo.Caption:=txt_3_1_sendto;
LabelAppPath.Caption:=txt_3_3_apppath;
LabelLang2.Caption:=txt_localization;
LabelLang2.Hint:=txt_7_8_changelocalization+' '+txt_7_8_requirerestart;
ComboBoxLanguage.Hint:=txt_7_8_changelocalization+' '+txt_7_8_requirerestart;
LabelOpacity.Hint:=txt_restartrequired;
LabelDefaultOpacity.Hint:=txt_restartrequired2;
CheckBoxParallelarchiving.Caption:=txt_2_8_parallel;
CheckBoxzcopy.Caption:=txt_2_8_zcopy;
CheckBoxnetworkinfo.Caption:=txt_3_3_skipunits;
Label7.Caption:=txt_3_1_workingdir;
ComboBoxBrowser.Items.Strings[0]:=txt_8_1_preparse;
ComboBoxBrowser.Items.Strings[1]:=txt_8_1_slow;
ComboBoxBrowser.Items.Strings[2]:=txt_level_normal;
ComboBoxBrowser.Items.Strings[3]:=txt_level_fast;
ComboBoxBrowser.Items.Strings[4]:=txt_level_fastest;
ComboBoxBrowser.Items.Strings[5]:=txt_8_1_nopreparse;
ComboBoxBrowser.Hint:=txt_8_1_preparsehint;
CheckBoxPrebrowse.Caption:=txt_8_1_bo;
CheckBoxPrebrowse.Hint:=txt_8_1_preparsehint;
ComboBoxDrag.Items.Strings[0]:=txt_7_5_dragnone;
ComboBoxDrag.Items.Strings[1]:=txt_7_5_draglock;
ComboBoxDrag.Items.Strings[2]:=txt_7_5_draghide;
ComboBoxDrag.Items.Strings[3]:=txt_7_5_draglh;
ComboBoxWD.Items.Strings[0]:=txt_2_7_output;
ComboBoxWD.Items.Strings[1]:=txt_7_7_outtemp;
ComboBoxWD.Items.Strings[2]:=txt_3_1_systmp;
ComboBoxWD.Items.Strings[3]:=txt_custom;
ComboBoxWD.Items.Strings[4]:=txt_7_7_nonetemp;
ComboBoxWD.Items.Strings[5]:=txt_7_7_noneall;
ComboBoxWD.Hint:=txt_7_7_tw+' '+txt_7_8_requirerestart;
RadioGroup4.Items.Strings[0]:=txt_console_interface;
RadioGroup4.Items.Strings[1]:=txt_guicl;
RadioGroup4.Items.Strings[2]:=txt_guipealauncher;
RadioGroup6.Items.Strings[0]:=txt_2_6_plalways;
RadioGroup6.Items.Strings[1]:=txt_8_9_stoptest;
RadioGroup6.Items.Strings[2]:=txt_2_6_plsmart;
RadioGroup6.Items.Strings[3]:=txt_8_4_keepopenerrorslist;
RadioGroup6.Items.Strings[4]:=txt_autoclose;
cbEncoding1.Items.Strings[0]:=txt_7_6_defaultenc;
cbEncoding1.Items.Strings[1]:=txt_7_6_forceutf8enc;
cbEncoding1.Items.Strings[2]:=txt_7_6_forcelocalenc;
cbEncoding1.Items.Strings[3]:=txt_7_6_custenc;
ComboBoxSyntaxLevel.Items.Strings[0]:=txt_5_1_last;
cbtree.Items.Strings[0]:=txt_7_6_tno;
cbtree.Items.Strings[1]:=txt_7_6_tsimple;
cbtree.Items.Strings[2]:=txt_7_6_tadvanced;
Labelcb15.Caption:=txt_2_9_tree;
Labelcb16.Caption:=txt_8_0_defaultaction;
Labelcb16.Hint:=txt_8_0_defaultactionhint;
cbdefaultaction.Items.Strings[0]:=txt_open;
cbdefaultaction.Items.Strings[1]:=txt_3_1_openasarchive;
cbdefaultaction.Items.Strings[2]:=txt_caption_extract+'...';
cbdefaultaction.Items.Strings[3]:=txt_ext_allhere;
cbdefaultaction.Items.Strings[4]:=txt_7_1_smart;
cbdefaultaction.Items.Strings[5]:=txt_7_1_new;
cbEncoding1.Hint:=txt_7_6_cpnote;
Labelenc.Caption:=txt_7_6_zipenc;
LabelResetBookmarks.Hint:=txt_7_8_requirerestart;
LabelResetPM.Hint:=txt_7_8_requirerestart;
LabelTheme1.Caption:=txt_themename;
LabelTheme2.Caption:=txt_author;
LabelTheme3.Caption:=txt_license;
themesave_label.Caption:=txt_create_theme;
labelcolor4.Caption:=txt_8_3_temperature;
LabelColor1.Caption:=txt_pea_appcolor;
LabelColor2.Caption:=txt_7_6_color;
tbtemperature.hint:=txt_8_3_temperature;
LabelColor3.Caption:=txt_7_6_tacolor;
Labelspacing.Caption:=txt_7_9_spacing;
Labelsmsize.Caption:=txt_8_8_sm;
Labelzooming.Caption:=txt_7_9_zooming;
cbspacing.Items.Strings[0]:=txt_2_9_st;
cbspacing.Items.Strings[1]:=txt_2_9_mt;
cbspacing.Items.Strings[2]:=txt_2_9_lt;
cbspacing.Items.Strings[3]:=txt_level_maximum;
cbspacing.Hint:=txt_7_9_spacing+' '+txt_7_8_requirerestart;
cbzooming.Hint:=txt_7_9_zooming+' '+txt_7_8_requirerestart;
Labellightpresets.Caption:=txt_4_8_presets;
Labellightpresets.Hint:=txt_7_6_dim+', '+txt_7_6_dark+',... '+txt_7_8_requirerestart;
lightdim.Caption:=txt_7_6_dim;
lightlow.Caption:=txt_7_6_dark;
LabelDefaultColor1.Caption:=txt_reset;
LabelDefaultColor2.Caption:=txt_reset;
LabelDefaultColor2.Hint:=txt_reset+' '+txt_7_8_requirerestart;
LabelDefaultColor3.Caption:=txt_reset;
LabelDefaultColor1.Caption:=txt_reset;
LabelColPresets.Caption:=txt_4_8_presets;
LabelTheme.Caption:=txt_theme;
LabelOpacity.Caption:=txt_opacity;
LabelDefaultOpacity.Caption:=txt_reset;
Button1.Caption:=txt_2_7_cancel;
Button2.Caption:=txt_2_7_ok;
ImageDefaults2.Caption:=txt_reset;
LabelResetBookmarks.Caption:=txt_reset+' '+txt_bookmarks;
LabelResetPtmp.Caption:=txt_3_0_resettmp;
LabelResetPM.Caption:=txt_reset+' '+txt_4_3_pwman;
LabelResetHistory.Caption:=txt_reset+' '+txt_list_history;
pmBrowser.Caption:=txt_go_browser;
mgobrowser.Caption:=txt_go_browser;
pmAddFile.Caption:=txt_add_files;
pmAddFolder.Caption:=txt_add_folder;
pmSearchAdd.Caption:=txt_searchanddrag;
pmjumpsearch.Caption:=txt_searchanddrag;
munsearch.Caption:=txt_searchanddrag;
MenuItemOpen_search.Caption:=txt_searchanddrag;
pmLoadList.Caption:=txt_loadlayout;
pmSaveList.Caption:=txt_savelayout;
mLoadLayout.Caption:=txt_loadlayout;
mSaveLayout.Caption:=txt_savelayout;
MenuItem3.Caption:=txt_clearlayout;
MenuItem1.Caption:=txt_removeselected;
MenuItemNavigate.Caption:=txt_go_path;
MenuItem5b.Caption:=txt_openwith;
openwithpeazip.Caption:=txt_peazip_new;
openwithassociated.Caption:=txt_associated;
openwithcustom.Caption:=txt_customapp;
mMisc.Caption:=txt_misc;
MenuItemBookmarks.Caption:=txt_add_tobookmarks;
pmExplorepath.Caption:=txt_explore_path;
mcp.Caption:=txt_cphere;
MenuItemTools.Caption:=txt_filetools;
MenuItemToolCompare.Caption:=txt_compare;
MenuItemToolCheck.Caption:=txt_check;
MenuItemRefresh.Caption:=txt_fefreshf5;
MenuItemContextRefresh.Caption:=txt_fefreshf5;
pmhrefresh.Caption:=txt_fefreshf5+' (F5)';
mf3.caption:=txt_searchfor;
mf4up.caption:=txt_up;
mback.caption:=txt_back;
mFeatures.Caption:=txt_file;
mextract.Caption:=txt_caption_extract;
mPEA.Caption:=txt_create_archive;
maddexisting.Caption:=txt_5_6_upexisting;
maddconvert.Caption:=txt_2_8_convert;
mUnPEAextract.Caption:=txt_5_6_exarc;
tmupdate.Caption:=txt_5_6_upexisting;
tmconvert.Caption:=txt_2_8_convert;
tmextract.Caption:=txt_5_6_exarc;
mUnPEAbrowse.Caption:=txt_open_path;
mUnPEA.Caption:=txt_openarchive;
mBookmarks.Caption:=txt_bookmarks;
mQuit.Caption:=txt_quit;
mEdit.Caption:=txt_edit;
mSelectAll.Caption:=txt_selectall;
po_SelectAll.Caption:=txt_selectall+' (Ctrl+A)';
mInvertSelection.Caption:=txt_invertsel;
mType.Caption:=txt_all_type;
mChar.Caption:=txt_5_5_starting;
mCharCase.Caption:=txt_5_5_starting+' '+txt_5_5_case;
msizesimilar.Caption:=txt_5_5_similar+' (10%)';
msizesimilar50.Caption:=txt_5_5_similar+' (50%)';
mpackedsimilar.Caption:=txt_5_5_similar+' (10%)';
mpackedsimilar50.Caption:=txt_5_5_similar+' (50%)';
mAttributes.Caption:=txt_all_attributes;
mDate.Caption:=txt_all_date;
mDateRecent.Caption:=txt_morerecent;
mDateERecent.Caption:=txt_eqorrecent;
mDateEqual.Caption:=txt_equal;
mDateEOlder.Caption:=txt_eqorolder;
mDateOlder.Caption:=txt_olderthan;
mPackedSize.Caption:=txt_all_psize;
mPSSmaller.Caption:=txt_smaller;
mPSESmaller.Caption:=txt_eqorsmaller;
mPSEqual.Caption:=txt_equal;
mPSELarger.Caption:=txt_eqorlarger;
mPSLarger.Caption:=txt_larger;
mSize.Caption:=txt_all_size;
mSizeSmaller.Caption:=txt_smaller;
mSizeESmaller.Caption:=txt_eqorsmaller;
mSizeEqual.Caption:=txt_equal;
mSizeELarger.Caption:=txt_eqorlarger;
mSizeLarger.Caption:=txt_larger;
mSortBySelection.Caption:=txt_sortbysel;
mBrowse.Caption:=txt_browser;
mcolumns.Caption:=txt_2_9_columns;
mcname.Caption:=txt_name;
mctype.Caption:=txt_type;
mcsize.Caption:=txt_size;
mcpacked.Caption:=txt_compressed_size;
mcdate.Caption:=txt_8_2_tm;
mcatt.Caption:=txt_attributes;
mccrc.Caption:=txt_check_select;
mcfree.Caption:=txt_free;
mcfs.Caption:=txt_fs;
mccreated.Caption:=txt_8_2_tc;
mcaccessed.Caption:=txt_8_2_ta;
mcmethod.Caption:=txt_method;
pmccreated.Caption:=txt_8_2_tc;
pmcaccessed.Caption:=txt_8_2_ta;
pmcmethod.Caption:=txt_method;
mbrowsersort.Caption:=txt_3_7_sort+' (Alt+5)';
mthumbimages.Caption:=txt_4_0_thim;
msimplesearch.Caption:=txt_4_1_simplesearch;
mrecsearch.Caption:=txt_4_3_recsrc;
pmjumpbreadcrumb.Caption:=txt_4_3_breadcrumb;
po_sortby.Caption:=txt_3_7_sort;
mbrowserccreated.Caption:=txt_8_2_tc;
mbrowsercaccessed.Caption:=txt_8_2_ta;
mbrowsercmethod.Caption:=txt_8_2_tm;
po_browserccreated.Caption:=txt_8_2_tc;
po_browsercaccessed.Caption:=txt_8_2_ta;
po_browsercmethod.Caption:=txt_8_2_tm;
mbrowsercname.Caption:=txt_name;
mbrowserctype.Caption:=txt_type;
mbrowsercsize.Caption:=txt_size;
mbrowsercpacked.Caption:=txt_compressed_size;
mbrowsercdate.Caption:=txt_datetime;
mbrowsercatt.Caption:=txt_attributes;
mbrowserccrc.Caption:=txt_check_select;
po_browsercname.Caption:=txt_name;
po_browserctype.Caption:=txt_type;
po_browsercsize.Caption:=txt_size;
po_browsercpacked.Caption:=txt_compressed_size;
po_browsercdate.Caption:=txt_datetime;
po_browsercatt.Caption:=txt_attributes;
po_browserccrc.Caption:=txt_check_select;
mshowmenu.Caption:=txt_2_9_showmenu;
pmshowmenu.Caption:=txt_2_9_showmenu;
MenuItemOrganizeMbar.Caption:=txt_2_9_showmenu;
MenuItemOrganizeToolbar.Caption:=txt_4_5_shtool;
mshowtoolbar.Caption:=txt_4_5_shtool;
mtoggletool.Caption:=txt_8_9_ttb;
MenuItemOrganizeNavbar.Caption:=txt_4_5_shnav;
mshownavbar.Caption:=txt_4_5_shnav;
MenuItemOrganizeStatusbar.Caption:=txt_4_5_shstatus;
mshowstatusbar.Caption:=txt_4_5_shstatus;
MenuItemProperties.Caption:=txt_4_5_properties;
pmproperties.Caption:=txt_4_5_properties;
mproperties.Caption:=txt_4_5_properties;
pmmorefun_properties.Caption:=txt_4_5_properties;
mgolayout.Caption:=txt_2_7_goarclayout;
mgoextlayout.Caption:=txt_2_7_goextlayout;
mFlat.Caption:=txt_toggle_browseflat;
pmFlat.Caption:=txt_toggle_browseflat;
mRefresh.Caption:=txt_fefreshf5;
mOptionsMenu.Caption:=txt_tools;
mAdmin.Caption:=txt_4_1_runasadmin;
mUser.Caption:=txt_run_as2;
po_alltasks.Caption:=txt_3_2_alltasks;
mBenchpea.Caption:=txt_sysbenchmark+' (pea)';
mBench.Caption:=txt_sysbenchmark+' (7z/p7zip)';
mLang.Caption:=txt_localization;
w7contextlang.Caption:=txt_5_3_cml;
mprofileultra7z.Caption:=txt_5_3_profilebest;
mprofilenormal7z.Caption:=txt_5_3_profileadvanced;
mprofilezipbz2.Caption:=txt_7_1_profileintermediate;
mprofilenormalzip.Caption:=txt_5_3_profilenormal;
mprofilefastzip.Caption:=txt_5_3_profileveryfast;
mprofile7zfast.Caption:=txt_7_3_profile7zfast;
mprofile7zfastest.Caption:=txt_7_3_profile7zfastest;
mprofileencrypt7z.Caption:=txt_5_3_profilepassword;
mprofilesplitzip.Caption:=txt_5_3_profile10mb;
mprofileauto.Caption:=txt_5_3_profilesfx;
mprofileextremezpaq.Caption:=txt_7_2_extcompultra;
mprofilebetterzpaq.Caption:=txt_7_2_extcomp;
mprofilealtarc.Caption:=txt_7_2_altcomp;
mprofilerar.Caption:=txt_7_4_presetrar;
mprofilebrotli.Caption:={$IFDEF MSWINDOWS}txt_7_4_7zfbrotlicomp{$ELSE}txt_7_2_fbrotlicomp{$ENDIF};
mprofilezstd.Caption:={$IFDEF MSWINDOWS}txt_7_4_7zfzstandardcomp{$ELSE}txt_7_2_fzstandardcomp{$ENDIF};
mprofilesave.Caption:=txt_7_2_savecompsettings;
mprofileload.Caption:=txt_7_2_loadcompsettings;
msavecompsettings.Caption:=txt_7_2_savecompsettings;
mloadcompsettings.Caption:=txt_7_2_loadcompsettings;
mDefaults.Caption:=txt_settings;
msettings.Caption:=txt_settings;
marcopt.Caption:=txt_7_4_setarc;
mextopt.Caption:=txt_7_4_setext;
LabelConfigurearc.Caption:=txt_7_4_setarc;
LabelConfigureext.Caption:=txt_7_4_setext;
mHelp.Caption:=txt_2_5_help;
mAbout.Caption:=txt_about+'...';
mupdate.caption:=txt_4_5_update;
mplugins.caption:=txt_5_5_plugin;
labelabout2.caption:=txt_5_5_plugin;
mPeaSiteMirror.Caption:=txt_peazip_web;
mPeaSupport.Caption:=txt_peazip_help;
mPeaFAQ.Caption:='FAQ';
mPeaTracker.Caption:=txt_3_7_tracker;
MenuItemDonations.Caption:=txt_3_7_donations;
mpeahelpoffline.Caption:=txt_2_5_offline_help+' (EN, .pdf)';
LabelUpdates.Caption:=txt_4_5_update;
LabelDonations.Caption:=txt_3_7_donations;
mtutorial.Caption:=txt_2_5_offline_help;
po_addtoarchive.Caption:=txt_add;
MenuItemTextEncoding.Caption:=txt_2_5_encoding;
pmtextenc.Caption:=txt_2_5_encoding;
mtenc.Caption:=txt_2_5_encoding;
MenuItemOpen_ExtractHere.Caption:=txt_caption_extract;
MenuItemOpen_ext_all.Caption:=txt_ext_all;
MenuItemOpen_ext_displayed.Caption:=txt_ext_disp;
MenuItemOpen_ext_selected.Caption:=txt_ext_sel;
po_exthere.Caption:=txt_caption_extract;
MenuItemOpen_test.Caption:=txt_caption_test;
MenuItemOpen_test_all.Caption:=txt_testall;
MenuItemOpen_test_displayed.Caption:=txt_testdisp;
MenuItemOpen_test_selected.Caption:=txt_testsel;
po_test.Caption:=txt_caption_test;
MenuItemOpen_info.Caption:=txt_list_details;
MenuItemOpen_info_all.Caption:=txt_list_all;
MenuItemOpen_info_displayed.Caption:=txt_list_disp;
MenuItemOpen_info_selected.Caption:=txt_list_sel;
po_info.Caption:=txt_list_details;
pmmorefun_info.Caption:=txt_list_details;
pmmorefun_details.Caption:=txt_6_3_cinfo;
pmmoretest.Caption:=txt_caption_test;
po_details.Caption:=txt_6_3_cinfo;
pmcpyto.Caption:=txt_copyto;
pmmvto.Caption:=txt_moveto;
pmexplore.Caption:=txt_explore_path;
pmbookmarks.Caption:=txt_add_tobookmarks;
pmbcaddbookmark.Caption:=txt_add_tobookmarks+' (F7)';
pmbcorganizebookmarks.Caption:=txt_2_9_organize;
MenuItemOpen_organizebookmarks.Caption:=txt_2_9_organize;
pmorganizebookmarks.Caption:=txt_2_9_organize;
pmws.Caption:=txt_search_web;
pmcommand.Caption:=txt_cphere;
pmbccp.Caption:=txt_cphere;
pmbcps.Caption:=txt_5_0_ps;
pmrecycle.Caption:=txt_4_7_recycle;
pmfunaz.Caption:=txt_4_8_fun;
pmcut.Caption:=txt_cut;
{$IFDEF MSWINDOWS}pmquickdelete.Caption:=txt_quickdelete+' (Shift+Del)';{$ELSE}pmquickdelete.Caption:=txt_quickdelete;{$ENDIF}
pmsecuredelete.Caption:=txt_securedelete+' (Ctrl+Del)';
MenuItemOpen_list.Caption:=txt_caption_list;
MenuItemOpen_list_all.Caption:=txt_list_all;
MenuItemOpen_list_displayed.Caption:=txt_list_disp;
MenuItemOpen_list_selected.Caption:=txt_list_sel;
po_list.Caption:=txt_caption_list;
pmmorefun_list.Caption:=txt_caption_list;
ImageFlatadd.Hint:=txt_add;
ImageFlatext.Hint:=txt_caption_extract;
ImageFlattestmore.Hint:=txt_caption_test+', '+txt_caption_list+'...';
MenuItemOpen_preview.Caption:=txt_previewwith;
MenuItemPrePeaZip.Caption:=txt_peazip_new;
MenuItemPreAssociated.Caption:=txt_associated;
MenuItemPreCustom.Caption:=txt_customapp;
MenuItemOpen_extandopenwith.Caption:=txt_extopen_with;
MenuItemERPeaZip.Caption:=txt_peazip_new;
MenuItemERAssociated.Caption:=txt_associated;
MenuItemERCustom.Caption:=txt_customapp;
po_open.Caption:=txt_openwith;
po_open_asarchive.Caption:=txt_3_1_openasarchive;
po_open_asarchivet.Caption:=txt_3_1_openasarchive;
po_open_peazip.Caption:=txt_peazip_new;
po_open_associated.Caption:=txt_associated;
po_open_custom.Caption:=txt_customapp;
MenuItemOpen_addtobookmarks.Caption:=txt_add_tobookmarks;
MenuItemOpen_explore.Caption:=txt_explore_path;
MenuItemOpen_commandprompt.Caption:=txt_cphere;
mbpea.Caption:=txt_go_path;
mbexplore.Caption:=txt_explore_path;
mbcl.Caption:=txt_cphere;
po_filetools.Caption:=txt_filetools;
po_split.Caption:=txt_split_file;
po_join.Caption:=txt_joinfiles;
po_compare.Caption:=txt_compare;
po_check.Caption:=txt_check;
po_checksum.Caption:=txt_check_select+' (CRC32)';
pmcheck.Caption:=txt_check_select+' (CRC32)';
po_pdup.Caption:=txt_4_1_duplicatesfind;
pmpdup.Caption:=txt_4_1_duplicatesfind;
po_dedup.Caption:=txt_4_1_duplicatesfind;
po_analyzefolders.Caption:=txt_7_0_af;
pmpanalyzefolders.Caption:=txt_7_0_af;
po_systemtools.Caption:=txt_systools;
po_linsystemtools.Caption:=txt_systools;
po_fm.Caption:=txt_4_6_fm;
po_diskclean.Caption:=txt_disk_cleanup;
po_defrag.Caption:=txt_disk_defrag;
po_manage.Caption:=txt_disk_management;
po_removeunits.Caption:=txt_remove_external_unit;
po_cpl.Caption:=txt_controlpanel;
po_computer.Caption:=txt_compmanagement;
po_taskman.Caption:=txt_taskman;
po_recycle.Caption:=txt_4_7_recycle;
{$IFDEF MSWINDOWS}po_delete.Caption:=txt_quickdelete+' (Shift+Del)';{$ELSE}po_delete.Caption:=txt_quickdelete;{$ENDIF}
po_securedelete.Caption:=txt_securedelete+' (Ctrl+Del)';
po_newfolder.Caption:=txt_cnewfolder;
pmnewfolder.Caption:=txt_cnewfolder;
po_rename.Caption:=txt_rename+' (F2)';
pmr_ren.Caption:=txt_rename+' (F2)';
po_renmenu.Caption:=txt_rename;
pmrename.Caption:=txt_rename+' (F2)';
po_copyto.Caption:=txt_copyto;
po_moveto.Caption:=txt_moveto;
po_copy.Caption:=txt_copy+' (Ctrl+C)';
po_cut.Caption:=txt_cut+' (Ctrl+X)';;
po_paste.Caption:=txt_paste+' (Ctrl+V)';
mfunadd.Caption:=txt_add;
mfunextract.Caption:=txt_caption_extract;
po_setpw.Caption:=txt_2_7_setpw;
menupw.Caption:=txt_2_7_setpw;
msetpw.Caption:=txt_2_7_setpw;
pmqesetpw.Caption:=txt_2_7_setpw;
madvfilters.caption:=txt_advfilters;
mfilterbrowser.caption:=txt_8_5_advbrowser;
mOptions.Caption:=txt_options;
sbBrowse.Caption:=txt_browse;
MenuItemOpen_up.Caption:=txt_up;
MenuItemOpen_back.Caption:=txt_back;
MenuItemOpen_fwd.Caption:=txt_fwd;
MenuItemOpen_root.Caption:=txt_mypc;
MenuItemopendesktop.Caption:=txt_desktop;
MenuItemopendownloads.Caption:=txt_3_1_downloads;
MenuItemopendocuments.Caption:=txt_2_4_documents;
MenuItemOpen_jump.Caption:=txt_go_path;
MenuItemOpen_Flat.Caption:=txt_toggle_browseflat;
MenuItemOpen_refresh.Caption:=txt_fefreshf5;
mnav.Caption:=txt_2_9_nav;
pmsearchdrag.Caption:=txt_searchanddrag;
pmsearchweb.Caption:=txt_search_web;
MenuItemOpenhome.Caption:=txt_2_9_home;
MenuItemOpen_home1.Caption:=txt_2_9_home;
MenuItemOpen_desktop1.Caption:=txt_desktop;
MenuItemOpen_path.Caption:=txt_open_path;
MenuItemOpen_archive.Caption:=txt_openarchive;
MenuItemOpenWeb.Caption:=txt_search_web;
mwebsearch.Caption:=txt_search_web;
pmOpenPJall.Caption:=txt_all;
pmOpenPJdisplayed.Caption:=txt_displayedobjects;
pmOpenPJselected.Caption:=txt_selected_objects;
pmextcontextall.Caption:=txt_ext_all;
pmextcontextdisplayed.Caption:=txt_ext_disp;
pmextcontextselected.Caption:=txt_ext_sel;
pmtestcontextall.Caption:=txt_testall;
pmtestcontextdisplayed.Caption:=txt_testdisp;
pmtestcontextselected.Caption:=txt_testsel;
pmqeall.Caption:=txt_ext_all;
pmqedisplayed.Caption:=txt_ext_disp;
pmqeselected.Caption:=txt_ext_sel;
pmJump1.Caption:=txt_mypc;
MenuItemOpen_pc.Caption:=txt_mypc;
MenuItemArchive_pc.Caption:=txt_mypc;
pmJump3.Caption:=txt_2_9_home;
pmJump2.Caption:=txt_desktop;
pmJumpPath.Caption:=txt_open_path;
pmJumpArchive.Caption:=txt_openarchive;
mbNotes.Caption:=txt_note;
mbDelete.Caption:=txt_remove_bookmark;
mbAddPath.Caption:=txt_add_path;
mbAddArchive.Caption:=txt_add_archive;
cbUn7zaRecursive.Hint:=txt_search_hint;
cbUn7zaRecursiveExclude.Hint:=txt_search_hint;
ComboBoxOverwrite.Hint:=txt_naming;
ComboBoxOverwriteARC.Hint:=txt_naming;
EditOPcustom1.Hint:=txt_otherparams;
OpenDialogLang.Title:=txt_open_file;
OpenDialogList.Title:=txt_open_files;
OpenDialogArchive.Title:=txt_open_file;
OpenDialogTheme.Title:=txt_open_file;
SelectDirectoryDialog1.Title:=txt_selectdir;
SelectDirectoryDialog2.Title:=txt_selectdir;
SaveDialogPJ.Title:=txt_savejobdefinition;
SaveDialog2.Title:=txt_saveas;
po_convert.Caption:=txt_convert;
mextractarchive.caption:=txt_archive;
mtogglenew.caption:=txt_newfoldermenu+' (Shift+Ctrl+N)';
mcancel.caption:=txt_2_7_cancel;
mgotype.caption:=txt_type;
ComboBoxTheme.Items.Strings[6]:=txt_custom;
ComboBoxPAQ1.Items.Strings[0]:=txt_level_fast;
ComboBoxPAQ1.Items.Strings[1]:=txt_level_normal;
ComboBoxPAQ1.Items.Strings[2]:=txt_level_maximum;
ComboBoxPAQ1.Items.Strings[3]:=txt_level_ultra;
RadioGroupPaq.Items.Strings[2]:='ZPAQ';
ComboBoxUPX.Items.Strings[0]:=txt_nocompress;
ComboBoxUPX.Items.Strings[1]:='1 '+txt_faster;
ComboBoxUPX.Items.Strings[9]:='9 '+txt_better;
ComboBoxUPX.Items.Strings[10]:=txt_best;
ComboBoxPEACompression1.Items.Strings[0]:=txt_bettercompression;
ComboBoxPEACompression1.Items.Strings[1]:=txt_default_compression;
ComboBoxPEACompression1.Items.Strings[2]:=txt_fastcompr;
ComboBoxPEACompression1.Items.Strings[3]:=txt_nocompress_hint;
ComboBoxPEA3.Items.Strings[13]:=txt_none2;
ComboBoxPEA4.Items.Strings[13]:=txt_none2;
ComboBoxSplit3.Items.Strings[13]:=txt_none2;
ComboBoxArchive7.Items.Strings[0]:=txt_newarchive;
ComboBoxArchive7.Items.Strings[1]:=txt_add_existing_archive;
ComboBoxArchive7.Items.Strings[2]:=txt_update;
ComboBoxArchive7.Items.Strings[3]:=txt_6_3_uar;
ComboBoxArchive7.Items.Strings[4]:=txt_6_3_syn;
ComboBoxArchiveAct.Items.Strings[0]:=txt_newarchive;
ComboBoxArchiveAct.Items.Strings[1]:=txt_add_existing_archive;
ComboBoxArchiveAct.Items.Strings[2]:=txt_update;
ComboBoxArchiveAct.Items.Strings[3]:=txt_6_3_uar;
ComboBoxArchiveAct.Items.Strings[4]:=txt_6_3_syn;
ComboBoxArchiveAct1.Items.Strings[0]:=txt_newarchive;
ComboBoxArchiveAct1.Items.Strings[1]:=txt_add_existing_archive;
ComboBoxArchiveAct1.Items.Strings[2]:=txt_update;
ComboBoxArchiveAct1.Items.Strings[3]:=txt_6_3_uar;
ComboBoxArchiveAct1.Items.Strings[4]:=txt_6_3_syn;
ComboBoxArchive8.Items.Strings[0]:=txt_singlethread;
ComboBoxArchive8.Items.Strings[1]:=txt_multithreading;
ComboBoxmemuse.Items.Strings[0]:=txt_default;
ComboBoxArchive4.Items.Strings[0]:=txt_level_store;
ComboBoxArchive4.Items.Strings[1]:=txt_level_fastest;
ComboBoxArchive4.Items.Strings[2]:=txt_level_fast;
ComboBoxArchive4.Items.Strings[3]:=txt_level_normal;
ComboBoxArchive4.Items.Strings[4]:=txt_level_maximum;
ComboBoxArchive4.Items.Strings[5]:=txt_level_ultra;
ComboBoxArchiveSolid.Items.Strings[0]:=txt_nonsolid;
ComboBoxArchiveSolid.Items.Strings[18]:=txt_solid;
ComboBoxArchiveSolid.Items.Strings[19]:=txt_solid_extension;
RadioGroupArchive.Items.Strings[0]:=txt_console;
RadioGroupArchive.Items.Strings[1]:=txt_gui;
ComboBoxArchiveCustom.Items.Strings[0]:=txt_pio;
ComboBoxArchiveCustom.Items.Strings[1]:=txt_poi;
ComboBoxArchiveCustom.Items.Strings[2]:=txt_ipo;
ComboBoxArchiveCustom.Items.Strings[3]:=txt_iop;
ComboBoxArchiveCustom.Items.Strings[4]:=txt_opi;
ComboBoxArchiveCustom.Items.Strings[5]:=txt_oip;
ComboBoxARC.Items.Strings[0]:='0 '+txt_store;
ComboBoxARC.Items.Strings[1]:='1 '+txt_fastermem;
ComboBoxARC.Items.Strings[4]:='4 '+txt_default2;
ComboBoxARC.Items.Strings[9]:='9 '+txt_slowermem;
ComboBoxArcSolid.Items.Strings[0]:=txt_nonsolid;
ComboBoxArcSolid.Items.Strings[1]:=txt_solid_auto;
ComboBoxArcSolid.Items.Strings[2]:=txt_solid_extension;
ComboBoxARC2.Items.Strings[0]:=txt_newarchive;
ComboBoxARC2.Items.Strings[1]:=txt_add_existing_archive;
ComboBoxARC2.Items.Strings[2]:=txt_update;
ComboBoxARCalgo.Items.Strings[3]:=txt_blowfish;
cbType.Items.Strings[8]:=txt_sfx+' '+STR_7Z;
cbType.Items.Strings[9]:=txt_sfx+' '+STR_ARC;
cbType.Items.Strings[10]:=txt_split;
ComboBoxOverwrite.Items.Strings[0]:=txt_skip_existing;
ComboBoxOverwrite.Items.Strings[1]:=txt_ren_extracted;
ComboBoxOverwrite.Items.Strings[2]:=txt_ren_existing;
ComboBoxOverwrite.Items.Strings[3]:=txt_overwrite;
ComboBoxOverwrite.Items.Strings[4]:=txt_overwrite_askbefore;
RadioGroupAction.Items.Strings[0]:=txt_caption_extract;
RadioGroupAction.Items.Strings[1]:=txt_ext_nopath;
RadioGroupAction.Items.Strings[2]:=txt_caption_list;
RadioGroupAction.Items.Strings[3]:=txt_list_details;
RadioGroupAction.Items.Strings[4]:=txt_caption_test;
RadioGroupAction.ItemIndex:=0;
RadioGroupAction1.Items.Strings[0]:=txt_caption_extract;
RadioGroupAction1.Items.Strings[1]:=txt_ext_nopath;
RadioGroupAction1.Items.Strings[2]:=txt_caption_list;
RadioGroupAction1.Items.Strings[3]:=txt_caption_test;
RadioGroupAction1.ItemIndex:=0;
ComboBoxOverwriteARC.Items.Strings[0]:=txt_overwrite_askbefore;
ComboBoxOverwriteARC.Items.Strings[1]:=txt_overwrite;
ComboBoxOverwriteARC.Items.Strings[2]:=txt_skip_existing;
RadioGroupActionARC.Items.Strings[0]:=txt_caption_extract;
RadioGroupActionARC.Items.Strings[1]:=txt_ext_nopath;
RadioGroupActionARC.Items.Strings[2]:=txt_caption_list;
RadioGroupActionARC.Items.Strings[3]:=txt_list_details;
RadioGroupActionARC.Items.Strings[4]:=txt_caption_test;
RadioGroupActionARC.Items.Strings[5]:=txt_caption_repair;
RadioGroupActionARC.ItemIndex:=0;
ComboBoxArchiveCustom1.Items.Strings[0]:=txt_pio;
ComboBoxArchiveCustom1.Items.Strings[1]:=txt_poi;
ComboBoxArchiveCustom1.Items.Strings[2]:=txt_ipo;
ComboBoxArchiveCustom1.Items.Strings[3]:=txt_iop;
ComboBoxArchiveCustom1.Items.Strings[4]:=txt_opi;
ComboBoxArchiveCustom1.Items.Strings[5]:=txt_oip;
RadioGroup0.Items.Strings[4]:=txt_custom;
RadioGroup0.Items[8]:=txt_sfx+' '+STR_7Z;
RadioGroup0.Items[9]:=txt_sfx+' '+STR_ARC;
RadioGroup0.Items.Strings[10]:=txt_split;
RadioGroup0.Items.Strings[18]:=txt_lastused;
ComboBoxPEACompression1.Text:=txt_default_compression;
ComboBoxUPX.Text:=txt_best;
ComboBoxArchive8.Text:=txt_multithreading;
ComboBoxArchiveCustom.Text:=txt_pio;
ComboBoxArcSolid.Text:=txt_solid_auto;
ComboBoxARC2.Text:=txt_newarchive;
EditOpenIn.Text:=txt_none;
ComboBoxOverwrite.Text:=txt_ren_extracted;
ComboBoxArchiveCustom1.Text:=txt_pio;
ComboBoxArchive7.Text:=txt_newarchive;
except end;
end;
end;

function valorize_headers:integer;
var
   s:ansistring;
begin
valorize_headers:=-1;
readln(t,s);//translator(s)
langstrhint:=langstrhint+' - '+s;
readln(t,s);//last revision's translator(s)
langstrhint:=langstrhint+' - '+s;
readln(t,s);//last revision date
langstrhint:=langstrhint+' - '+s;
readln(t,s);
readln(t,s);//peazip text group
if s<>'=== PeaZip text group ===' then exit
else valorize_headers:=0;
end;

function load_texts(lang:ansistring):integer; //valorize localized text strings
var
   s:ansistring;
   i:integer;
begin
load_texts:=-1;
try
   assignfile(t,(sharepath+'lang'+directoryseparator+lang));
   filemode:=0;
   reset(t);
   read_header(t);
   readln(t,s); //declaration
   if s<>'=== PeaZip language file ===' then
      begin
      closefile(t);
      exit;
      end;
   readln(t,s);//language
   langstrhint:=s;
   readln(t,s); //version; PEAZIPREVISION is ignored since revisions are meant to share the same text
   langstrhint:=langstrhint+' - '+s;
   i:=-1;
      if valorize_headers=0 then i:=valorize_text;
   if i=0 then assign_guitext
   else
      begin
      closefile(t);
      exit;
      end;
   repeat //skip until about text group
      readln(t,s);
   until (eof(t)) or (s='=== about text group ===');
   if not eof(t) then
      begin
      readln(t,s);
      form_peach.MemoAbout.Lines.Clear;
      form_peach.MemoAbout.Lines.Append(APPMAIN+' '+PEAZIPVERSION+PEAZIPREVISION+' - '+caption_build);
      form_peach.MemoAbout.Lines.Append('');
      form_peach.MemoAbout.Lines.Append(txt_read+' '+READE_LIST);
      form_peach.MemoAbout.Lines.Append('');
      form_peach.MemoAbout.Lines.Append(txt_write+' '+WRITEE_LIST);
      form_peach.MemoAbout.Lines.Append('');
      repeat
         readln(t,s);
         form_peach.MemoAbout.Lines.Append(s);
      until eof(t);
      end;
   closefile(t);
   load_texts:=0;
except
   try
      closefile(t);
   except
   end;
   load_texts:=-1;
end;
end;

procedure load_default_texts;
begin
txt_9_1_7zs:='7z / p7zip syntax level';
txt_9_1_ac:='Archive conversion scripts allow user''s interaction';
txt_9_1_closeall:='Close all';
txt_9_1_enlargeicons:='Enlarge file browser icons';
txt_9_1_ef:='Exclude empty folders form archiving and extraction operations (7z / p7zip)';
txt_9_1_nw:='Open in a new window';
txt_9_1_qdup:='Use quick deduplication routine';
txt_9_0_autoexttar:='Auto extract TAR archive from compressed TAR.* files';
txt_9_0_accesstime:='Do not change last access time';
txt_9_0_mem:='Maximum memory usage';
txt_9_0_showmainmenu:='Open Main menu';
txt_9_0_navmenu:='Open Navigation menu';
txt_9_0_plugind:='Open plugin directory';
txt_9_0_df:='Sort dirs before files';
txt_9_0_hl:='Store hard links as links';
txt_9_0_sl:='Store symbolic links as links';
txt_9_0_tnav:='Toggle side bar, treeview, none';
txt_8_9_empty:='Archive seems empty';
txt_8_9_disp:='Displaying archive content';
txt_8_9_parsing:='Parsing archive content';
txt_8_9_stoptest:='Stop to inspect report for error, list, test, auto-test';
txt_8_9_ttb:='Toggle tool bar';
txt_8_8_ca:='Accent color';
txt_8_8_btn:='Button';
txt_8_8_cb:='Button color';
txt_8_8_centered:='Centered buttons';
txt_8_8_light:='Light';
txt_8_8_lnk:='Link';
txt_8_8_intnote:='Please note that "Extract then move" option (in Options > Settings > Archive manager) is ignored for composing the command line in Console tab.';
txt_8_8_snz:='Propagate Zone.Identifier stream (Windows)';
txt_8_8_sm:='Small icons size';
txt_8_8_solcol:='Address field';
txt_8_8_snoi:='Store owner/group ids (TAR, Linux)';
txt_8_8_snon:='Store owner/group names (TAR, Linux)';
txt_8_8_tab:='Tab';
txt_8_8_altt:='Tabs style';
txt_8_8_autotest:='Test archives after creation, if supported by the format';
txt_8_8_cw:='Window color';
txt_8_7_csvhelp:='"," international standard, ";" common in Latin locales';
txt_8_7_after:='After archiving / extraction';
txt_8_7_bintest:='binaries tested.';
txt_8_7_csv:='CSV separator';
txt_8_7_hok:='Hash of binaries used by PeaZip match with expected ones';
txt_8_7_mo:='Set archive manager options';
txt_8_7_showhm:='Open Browser header menu';
txt_8_7_showsearchbar:='Show search bar';
txt_8_7_showsm:='Open Style menu';
txt_8_7_hnotok:='Some hash of binaries used by PeaZip do not match with expected ones:';
txt_8_7_verifybin:='Verify hash of binaries';
txt_8_6_clear:='"Clear" option removes temp edited files, otherwise available for further editing.';
txt_8_6_noclear:='Discard all changes without updating the archive';
txt_8_6_nosimple:='Do not update archive, keep temp edited files for further editing';
txt_8_6_immediate:='Immediate execution';
txt_8_6_yessimple:='Update archive, keep temp edited files for further editing';
txt_8_5_advbrowser:='Apply filters to archive browser';
txt_8_5_detailslarge:='Details, large';
txt_8_5_intext:='Extract to temporary working directory then move to output destination, interactively ask before overwriting';
txt_8_5_listlarge:='List, large';
txt_8_5_loadlayout:='Load layout at startup';
txt_8_5_samplescripts:='Sample scripts';
txt_8_4_keepopenerrorslist:='Stop to inspect report for error, list';
txt_8_3_mbubin:='Binary';
txt_8_3_cw:='Change working directory? This will reset temporary work files and restart the application.';
txt_8_3_temperature:='Color temperature';
txt_8_3_mbudec:='Decimal';
txt_8_3_htab:='Highlight tabs';
txt_8_3_maxarg:='Maximum length of arguments';
txt_8_3_mbu:='Multiple-byte unit';
txt_8_3_prefalgo:='Preferred algorithms';
txt_8_3_skipdel:='Skip deletion of locked temp files (use reset to delete on demand)';
txt_8_3_lw:='Some files in working directory are locked and cannot be removed automatically';
txt_8_3_noupx:='This binary cannot be compressed (may be already compressed)';
txt_8_2_slower:='(slower)';
txt_8_2_df:='7z / p7zip display content of folders';
txt_8_2_vreport:='7z / p7zip non-verbose report';
txt_8_2_ta:='Accessed';
txt_8_2_tc:='Created';
txt_8_2_keep:='Keep files';
txt_8_2_tm:='Modified';
txt_8_2_skipet:='Skip testing for encryption';
txt_8_2_alltimes:='Store all timestamps';
txt_8_2_supportedby:='Supported by';
txt_8_1_preparse:='Always pre-parse archives';
txt_8_1_bo:='Browser optimization';
txt_8_1_bop:='Browser optimization options can be set from Options > Settings, General tab';
txt_8_1_nopreparse:='Do not pre-parse archives';
txt_8_1_ed:='error(s) detected.';
txt_8_1_togglearc:='Listing flat view of archive content may take long time, continue anyway?';
txt_8_1_preparsehint:='Optimize performances limiting pre-parsing of large archives. Pre-parsing is meant to detect in advance possible issues in archive content.';
txt_8_1_slow:='Slow';
txt_8_1_vslow:='Very slow';
txt_8_1_volumes:='volumes';
txt_8_0_altcol:='Alternate grid color';
txt_8_0_forcebrowse:='Browse non-canonical archive types (containers, disk images, installers,...)';
txt_8_0_commonalgo:='Common algorithms';
txt_8_0_forceconvert:='Convert non-canonical archive types';
txt_8_0_defaultactionhint:='Default action double-clicking a file associated with PeaZip from the system';
txt_8_0_defaultaction:='Default action on input';
txt_8_0_enableextand:='Enable "Extract and open with" submenu';
txt_8_0_forcetyping:='Force typing passwords interactively';
txt_8_0_setpwopt:='Set password / keyfile options';
txt_8_0_forcetypinghelp:='Will run backend binaries in console, cannot browse archives with encrypted filenames. Allows to create scripts that will not run unattended but rather ask user interactively for password.';
txt_7_9_spacing:='Spacing';
txt_7_9_zooming:='Zooming';
txt_7_8_changelocalization:='Change PeaZip language';
txt_7_8_custext:='Custom extension';
txt_7_8_destexistfile:='Destination already contains processed files. Replace files with same name?';
txt_7_8_dd:='Drag and Drop';
txt_7_8_priorityhigh:='High';
txt_7_8_priorityidle:='Idle';
txt_7_8_rel:='Extract then move to destination';
txt_7_8_prioritynormal:='Normal';
txt_7_8_priorityrealtime:='Real time';
txt_7_8_requirerestart:='[REQUIRES RESTARTING PEAZIP]';
txt_7_8_tpriority:='Tasks priority';
txt_7_8_update:='Update';
txt_7_7_noneall:='None (no preview, no Drag And Drop extraction)';
txt_7_7_nonetemp:='None, preview in User''s temp';
txt_7_7_outtemp:='Output, preview in User''s temp';
txt_7_7_sys7zreq:='Requires 7z, 7-Zip, or p7zip, or equivalent package to be installed';
txt_7_7_tw:='Temporary work folder for archive creation, editing, preview and drag and drop extraction.';
txt_7_7_sys7z:='Use system 7z if available';
txt_7_6_zipenc:='7z/p7zip ZIP filenames encoding';
txt_7_6_color:='Color';
txt_7_6_custenc:='Custom code page';
txt_7_6_dark:='Darker';
txt_7_6_tno:='Do not sync archive tree';
txt_7_6_forcelocalenc:='Force local';
txt_7_6_forceutf8enc:='Force UTF-8';
txt_7_6_cpnote:='If the chosen custom code page is unsupported, tasks will always end in error (most likely memory allocation error). In case that happens, change code page or reset the application.';
txt_7_6_defaultenc:='Local, UTF-8 for extra symbols';
txt_7_6_dim:='Dark';
txt_7_6_setcurdef:='Set current path as default output path';
txt_7_6_setdef:='Set default output path';
txt_7_6_tadvanced:='Sync archive tree, keep visited nodes';
txt_7_6_tsimple:='Sync archive tree, simple';
txt_7_6_tacolor:='Text accent color';
txt_7_5_always:='Always';
txt_7_5_ask:='Ask';
txt_7_5_autoclosesingle:='Auto close after extraction if no browsing actions took place';
txt_7_5_cutlen:='Cut name at specified length';
txt_7_5_cutlenw:='Cut name at specified length (4..255) naming conflicts can be fixed manually later';
txt_7_5_dragnone:='Do not lock target';
txt_7_5_specialbrowse:='Do you want to extract everything in order to provide the file with the extra data it may need?';
txt_7_5_ee:='Extract everything for special file types';
txt_7_5_draghide:='Hide drop target';
txt_7_5_repnascii:='Replace/remove non-ASCII characters';
txt_7_5_draglh:='Lock and hide target';
txt_7_5_draglock:='Lock drop target';
txt_7_5_never:='Never';
txt_7_4_comment:='Comment';
txt_7_4_7zfbrotlicomp:='Fastest compression, 7Z Brotli';
txt_7_4_7zfzstandardcomp:='Fastest compression, 7Z Zstandard';
txt_7_4_presetrar:='High compression, RAR';
txt_7_4_tkeep:='Keep original archive timestamp';
txt_7_4_lock:='Lock archive';
txt_7_4_locked:='locked';
txt_7_4_lockconfirm:='Locked archives cannot be further modified, proceed locking this archive?';
txt_7_4_comment:='Recover archive';
txt_7_4_tcurr:='Set archive timestamp from current system time';
txt_7_4_setarc:='Set advanced archiving options';
txt_7_4_setext:='Set advanced extraction options';
txt_7_4_swzipx:='Switch to zipx extension for non-Deflate zip archives';
txt_7_3_archiveerrors:='[archive may contain errors]';
txt_7_3_archiveerrorshint:='Archive may not be valid (due missing, corrupted, or out of standard data), it is possible to run Test for detailed information. If archive''s table of content is encrypted, password is needed before browsing it.';
txt_7_3_clickextall:='Click "Extract all" to enable';
txt_7_3_noconfdel:='Do not ask confirmation for delete after archiving / extraction';
txt_7_3_profile7zfastest:='Fast compression, 7Z fastest';
txt_7_3_maxbr:='Maximize Brotli compression using more memory (may be incompatible with some other Brotli extractors)';
txt_7_3_maxzstd:='Maximize Zstandard compression using more memory';
txt_7_3_profile7zfast:='Medium compression, 7Z fast';
txt_7_3_stl:='Set archive timestamp from most recent file';
txt_7_2_altcomp:='High compression, ARC';
txt_7_2_clearnoupdate:='Clear edited files';
txt_7_2_autoclosepeazip:='Close PeaZip when task completes';
txt_7_2_zpaqall:='Extract all revisions';
txt_7_2_extcomp:='Extreme compression, ZPAQ';
txt_7_2_extcompultra:='Extreme compression, ZPAQ ultra';
txt_7_2_fbrotlicomp:='Fastest compression, Brotli';
txt_7_2_fzstandardcomp:='Fastest compression, Zstandard';
txt_7_2_loadcompsettings:='Load compression settings';
txt_7_2_savecompsettings:='Save compression settings';
txt_7_2_source:='Source';
txt_7_2_updateclear:='Update archive, clear edited files';
txt_7_1_type_description_brotli:='Brotli: fast compressor from Google, very fast decompression';
txt_7_1_new:='Extract all here (in new folder)';
txt_7_1_smart:='Extract all here (smart new folder)';
txt_7_1_profileintermediate:='Medium compression, ZIP/BZip2 fast';
txt_7_1_renfilesonly:='Rename only files';
txt_7_1_typetosearch:='Type to search in current path';
txt_7_1_type_description_zstd:='Zstandard: fast compressor from Facebook, very fast decompression';
txt_7_0_af:='Analyze content of folders';
txt_7_0_autoopentar:='Auto open single tar archive inside tar.* files';
txt_7_0_exttmppath:='Content will be extracted outside the temporary work path, in ';
txt_6_9_autou:='Auto update modified files in archives';
txt_6_9_forceu:='Update edited files in archive';
txt_6_9_opuns:='Operation not supported for current archive type';
txt_6_9_overarch:='Overwrite file(s) with same name already existing inside the archive?';
txt_6_9_uconf:='Previewed file has been modified. Update the current archive?';
txt_6_8_ndrop:='Use native Drag and Drop on Windows';
txt_6_7_nop:='(no preview)';
txt_6_6_pdupfound:='possible duplicates found (quick approximate test)';
txt_6_6_rsh:='Reset search history';
txt_6_6_pdupfind:='Suggest duplicates';
txt_6_6_forcemodify:='Edit non-canonical archive types';
txt_6_5_mandatory:='(mandatory)';
txt_6_5_abort:='Abort';
txt_6_5_askp:='Ask to set password at startup';
txt_6_5_chp:='Change password';
txt_6_5_def:='Definition';
txt_6_5_nop:='Don''t ask to set password at startup';
txt_6_5_error:='Error';
txt_6_5_seqerr:='Error(s) detected, original files will not be deleted';
txt_6_5_sni:='Include NT security information';
txt_6_5_sns:='Include NTFS Alternate Data Stream';
txt_6_5_privacy:='Privacy';
txt_6_5_showvolatile:='Show which options are volative / context depentent';
txt_6_5_force:='Try to open archives containing errors';
txt_6_5_warning:='Warning';
txt_6_5_yes:='Yes';
txt_6_5_yesall:='Yes to all';
txt_6_5_np:='You can now change password of converted archive(s) to a new one, or blank the password to skip encryption';
txt_6_4_absolute:='Absolute paths';
txt_6_4_appdirn:='Append directory name';
txt_6_4_closeallother:='Close all other tabs';
txt_6_4_closeright:='Close tabs on the right';
txt_6_4_collapse:='Collapse tabs';
txt_6_4_expand:='Expand tabs';
txt_6_4_full:='Full paths';
txt_6_4_new:='New';
txt_6_4_openintab:='Open in a new tab';
txt_6_4_paths:='Paths';
txt_6_4_prepdirn:='Prepend directory name';
txt_6_4_relative:='Relative paths';
txt_6_4_tabbar:='Tab bar';
txt_6_3_autoadjust:='Auto adjust columns';
txt_6_3_cinfo:='Info and comments';
txt_6_3_syn:='Synchronize archive with disk';
txt_6_3_uar:='Update only files already in archive';
txt_6_2_encext:='Add ".enc" suffix to encrypted archives';
txt_6_2_archive:='Archive file type';
txt_6_2_container:='Container file type';
txt_6_1_ec:='Expand / collapse archive tree';
txt_6_0_msq:='Sort by file type for solid compression';
txt_5_9_lff:='Analyze files and folders';
txt_5_9_pff:='Analyze, show files header/EOF';
txt_5_9_start:='Start from';
txt_5_8_l0:='Allow any supported component/format';
txt_5_8_l1:='Allow only Free Software components';
txt_5_8_l2:='Allow only open archive formats';
txt_5_8_ascii:='ASCII safe, scripts are safe on legacy environments';
txt_5_8_cp:='Code Page safe, scripts may trigger problems on legacy environments with different Code Pages';
txt_5_8_fs:='Free Software compliance';
txt_5_8_utf:='Scripts need full UTF-8 / Unicode environment';
txt_5_8_fsr:='This format is not supported due Free Software compliance restrictions (Options > Advanced)';
txt_5_7_pinstalled:='INSTALLED';
txt_5_7_pmissing:='MISSING';
txt_5_7_plugin:='Plugin missing, can be installed from Help > Check for plugin and addon';
txt_5_6_basic:='Basic';
txt_5_6_exarc:='Extract archive';
txt_5_6_tab:='Open in new tab';
txt_5_6_rc:='Right click for options';
txt_5_6_layouts:='Saved layouts';
txt_5_6_upexisting:='Update existing archive';
txt_5_6_verbose:='Verbose';
txt_5_5_case:='(case sensitive)';
txt_5_5_add:='Add string at specified position';
txt_5_5_addsel:='Add to current selection';
txt_5_5_ext:='Change files extension';
txt_5_5_plugin:='Check for plugin and addon';
txt_5_5_copypath:='Copy path';
txt_5_5_delete:='Delete characters at specified position';
txt_5_5_halt:='Halt system when task completes';
txt_5_5_positionw:='Hint: 1 add before first char, 2 second, etc... "z" for end of file name';
txt_5_5_positionwd:='Hint: 1 delete from first char included, 2 second, ... "z" for end of file name';
txt_5_5_replaceneww:='Hint: provide an empty new string to simply remove the old string';
txt_5_5_lower:='Lowercase';
txt_5_5_replaceoldw:='Modify all occurrences of this string or character in the file name';
txt_5_5_newext:='New extension';
txt_5_5_new:='New string';
txt_5_5_n:='Number of characters to delete';
txt_5_5_old:='Old string';
txt_5_5_position:='Position (number or "z" for end)';
txt_5_5_intdir:='Remove redundant directory on extraction in new folder';
txt_5_5_replacestr:='Replace/remove string';
txt_5_5_datesameday:='Same day of selected object';
txt_5_5_datesamehour:='Same hour of selected object';
txt_5_5_datesamemonth:='Same month of selected object';
txt_5_5_datesameweek:='Same week of selected object';
txt_5_5_datesameyear:='Same year of selected object';
txt_5_5_scan:='Scan';
txt_5_5_select:='Select';
txt_5_5_similar:='Similar to selected object';
txt_5_5_starting:='Starting with same character';
txt_5_5_string:='String to add';
txt_5_5_subtractsel:='Subtract from current selection';
txt_5_5_datehour:='This hour';
txt_5_5_datemonth:='This month';
txt_5_5_dateweek:='This week';
txt_5_5_dateyear:='This year';
txt_5_5_dateday:='Today';
txt_5_5_upper:='Uppercase';
txt_5_5_extw:='Warning: changing file extension the file may become unusable';
txt_5_4_da:='Date added';
txt_5_4_deletearchives:='Delete archives after extraction';
txt_5_4_deletefiles:='Delete files after archiving';
txt_5_4_deleteoriginal:='Deletion procedure, as set in main screen, will be appended to the script.';
txt_5_4_lv:='Last visited';
txt_5_4_deletearchivesconfirm:='Confirm deletion of original archives?';
txt_5_4_deletefilesconfirm:='Confirm deletion of original files?';
txt_5_4_used:='Used';
txt_5_3_profilebest:='Extreme compression, 7Z ultra';
txt_5_3_profileadvanced:='High compression, 7Z';
txt_5_3_profilenormal:='Medium compression, ZIP (compatible with most extractors)';
txt_5_3_profileveryfast:='Fast compression, ZIP fast (compatible with most extractors)';
txt_5_3_profilepassword:='Protect with password, 7Z format';
txt_5_3_profile10mb:='Keep output under 10 MB, for mail attachment limitations';
txt_5_3_profilesfx:='Auto extracting, recipient will not need an extraction software';
txt_5_3_cml:='System context menu language';
txt_5_3_cmlmessage:='Double click on desired context menu language and confirm registry merging. This setting needs to be re-applied when the application is installed/updated or after System integration wizard is used.';
txt_5_3_exc:='Exclusion filters prevail on inclusion filters';
txt_5_3_ia:='Include also';
txt_5_3_io:='Include only';
txt_5_3_rec:='Recurse subdirs';
txt_5_3_resetsi:='Re-configure system integration (context menu, SendTo, file associations)?';
txt_5_2_oadd:='Archive to original path';
txt_5_2_zerodelete:='Do you want to delete and overwrite with all 0 selected file(s)? The operation can''t be undone and files will be not recoverable';
txt_5_2_zfree:='Do you want to overwrite with all 0 free space on this drive?';
txt_5_2_sdfree:='Do you want to securely delete free space on this drive?';
txt_5_2_oext:='Extract to original path';
txt_5_2_securedeletefree:='Secure delete free space';
txt_5_2_free:='This operation can take some minutes and, if performed often, it can quickly wear flash-based disks';
txt_5_2_zerofiles:='Zero delete';
txt_5_2_zerofree:='Zero delete free space';
txt_5_1_schedadd:='Add schedule';
txt_5_1_schederr:='Cannot create schedule';
txt_5_1_daily:='Daily';
txt_5_1_day:='Day';
txt_5_1_days:='Days';
txt_5_1_enddate:='End date';
txt_5_1_every:='Every';
txt_5_1_w6:='Friday';
txt_5_1_hourly:='Hourly';
txt_5_1_hours:='Hours';
txt_5_1_last:='Last';
txt_5_1_schedmanage:='Task Scheduler, manage tasks saved in PeaZip branch';
txt_5_1_scriptmanage:='Manage saved scheduled scripts';
txt_5_1_w2:='Monday';
txt_5_1_monthly:='Monthly';
txt_5_1_months:='Months';
txt_5_1_onlogin:='On login';
txt_5_1_onstart:='On start';
txt_5_1_once:='Once';
txt_5_1_w7:='Saturday';
txt_5_1_schedule:='Schedule';
txt_5_1_schedexplain:='Creates a plain text script from GUI task definition and schedule it. Scheduled tasks'' scripts are saved in "Scheduled scripts" folder. To edit or delete scheduled tasks you can use system''s Task Scheduler, all scheduled tasks created by PeaZip are collected in "PeaZip" branch of the tasks library.';
txt_5_1_schedok:='Schedule created successfully';
txt_5_1_schedscripts:='Saved scheduled scripts';
txt_5_1_startdate:='Start date';
txt_5_1_starttime:='Start time';
txt_5_1_w1:='Sunday';
txt_5_1_schedname:='Task name, identify both the saved scheduled script and the system''s scheduled task';
txt_5_1_ts:='Task Scheduler';
txt_5_1_w5:='Thursday';
txt_5_1_w3:='Tuesday';
txt_5_1_w4:='Wednesday';
txt_5_1_weekly:='Weekly';
txt_5_1_weeks:='Weeks';
txt_5_0_bc:='Breadcrumb';
txt_5_0_resetpm:='Do you confirm resetting Password Manager? All passwords stored in PeaZip''s Password Manager will be lost if confirmed.';
txt_5_0_enum:='Enumerate folder content';
txt_5_0_music:='Music';
txt_5_0_ps:='Open PowerShell here';
txt_5_0_perf:='Performance';
txt_5_0_pictures:='Pictures';
txt_5_0_removeall:='Remove all';
txt_5_0_resetbookmarks:='Reset Bookmarks to default? (Bookmarks can then be customized with Bookmarks > Organize)';
txt_5_0_sh:='Session history';
txt_5_0_skip:='Skip enumerating directories'' content in layout';
txt_5_0_videos:='Videos';
txt_4_9_frame:='Frame';
txt_4_9_listth:='List and thumbnails';
txt_4_9_shadow:='Shadow';
txt_4_9_style:='Style';
txt_4_8_attach25:='25 MB attachment';
txt_4_8_crop:='Crop';
txt_4_8_detailsno:='Details';
txt_4_8_details:='Details and thumbnails';
txt_4_8_fit:='Fit to';
txt_4_8_fitl:='Fit to largest';
txt_4_8_flip:='Flip';
txt_4_8_fullscreen:='Full screen';
txt_4_8_fun:='Functions';
txt_4_8_h:='Height';
txt_4_8_keeparchive:='Keep archive';
txt_4_8_noresize:='Keep original size';
txt_4_8_iconl:='Large images';
txt_4_8_iconm:='Icons and images';
txt_4_8_imagemanager:='Image manager';
txt_4_8_immersive:='Immersive';
txt_4_8_listno:='List';
txt_4_8_aspect:='Maintain aspect ratio';
txt_4_8_mirror:='Mirror';
txt_4_8_presets:='Presets';
txt_4_8_replace:='Replace original image(s)? "No" apply the transformation in new file(s).';
txt_4_8_resize:='Resize';
txt_4_8_rl:='Rotate left';
txt_4_8_rr:='Rotate right';
txt_4_8_stop:='Stop';
txt_4_8_t:='Transform';
txt_4_8_w:='Width';
txt_4_7_pk:='Create random password / keyfile';
txt_4_7_spchar:='Limit characters to letters and numbers';
txt_4_7_recycleask:='Move selected file(s) to Recycle Bin?';
txt_4_7_recycle:='Move to Recycle Bin';
txt_4_7_pcomp:='Potential compression';
txt_4_6_am:='Archive manager';
txt_4_6_fm:='File manager';
txt_4_6_users:='Users';
txt_4_5_goupdate:='A new version is available. Open PeaZip''s official website to download the update?';
txt_4_5_b:='Bottom';
txt_4_5_koupdate:='Cannot check for updates, no connection with update server';
txt_4_5_update:='Check for updates';
txt_4_5_dock:='Dock';
txt_4_5_l:='Left';
txt_4_5_noupdate:='PeaZip is up to date';
txt_4_5_properties:='Properties';
txt_4_5_r:='Right';
txt_4_5_pj:='Saved scripts';
txt_4_5_shaddress:='Show Address bar';
txt_4_5_shnav:='Show Navigation bar';
txt_4_5_shstatus:='Show Status bar';
txt_4_5_shtool:='Show Tool bar';
txt_4_5_upxpj:='Sorry, cannot export task definition since this action or option requires performing multiple distinct commands';
txt_4_5_t:='Top';
txt_4_4_confremoveall:='Remove all PeaZip customization files (Applications, Bookmarks)?';
txt_4_4_confremove:='Remove PeaZip configuration?';
txt_4_3_pwmanhint:='Double click to edit items in password list, rightclick for options, Ctrl+C to copy passwords';
txt_4_3_exppl:='Export password list';
txt_4_3_expple:='Encrypted (backup Password Manager)';
txt_4_3_keeppw:='Keep password/keyfile for current session';
txt_4_3_pwmanpwhint:='Setting a password/keyfile (optional) to encrypt password list is recommended, in this way authentication will be required to access to the Password Manager. Password/keyfile can be changed at any time from this form.';
txt_4_3_pwmanmaster:='Set/change master password';
txt_4_3_pwmanlist:='Password list';
txt_4_3_pwman:='Password Manager';
txt_4_3_pwmancorr:='Password Manager seems tampered or corrupted. Keep Password Manager anyway and try to recover current password list, if you trust it? (No will reset Password Manager, recommended)';
txt_4_3_expplp:='Plain text (all uses)';
txt_4_3_recsrc:='Recursive search by default';
txt_4_3_resetpm:='Reset Password Manager? All saved passwords will be deleted';
txt_4_3_breadcrumb:='Show Address as breadcrumb';
txt_4_2_arcabspath:='Use absolute paths';
txt_4_1_duplicateshint:='"size"/"checksum" string is reported in CRC column for all duplicate candidates found in current directory or search filter';
txt_4_1_adminhint:='(HINT: alternatively, you can request UAC elevation to work in protected paths, Alt+F10 or Options > Run as administrator)';
txt_4_1_selected:='(selected)';
txt_4_1_duplicatesfound:='duplicates found';
txt_4_1_duplicatesfind:='Find duplicates';
txt_4_1_runasadmin:='Run as administrator';
txt_4_1_simplesearch:='Simple search';
txt_4_0_thim:='Show picture thumbnails';
txt_3_8_type_description_wim:='WIM: Microsoft''s disk image format';
txt_3_8_type_description_xz:='XZ: powerful file compression based on LZMA2';
txt_3_7_donations:='Donations';
txt_3_7_nameasparent:='Name archive as selected item''s parent folder, if multiple items are added';
txt_3_7_tracker:='Issue Tracker';
txt_3_7_sort:='Sort by';
txt_3_7_swapbars:='Swap Tool bar / Address bar';
txt_3_7_themedbars:='Themed bars';
txt_3_6_ignoredd:='Always ignore paths for drag and drop extraction';
txt_3_6_close:='Close';
txt_3_6_resetapps:='Do you want to reset Applications (customizable group of programs and scripts to open files with, overriding file associations)?';
txt_3_6_ethemes:='Existing Themes';
txt_3_5_td:='Download Themes';
txt_3_5_managecustomthemes:='Manage Themes';
txt_3_4_nopaths:='No paths';
txt_3_4_smallicons:='Icons';
txt_3_3_skipunits:='(Windows) Get volume information for network units, slower startup';
txt_3_3_stralt:='Alternative command, when no parameter is passed';
txt_3_3_apps:='Applications';
txt_3_3_multi:='Multiple selection';
txt_3_3_runexp:='Open a program, file, folder or website';
txt_3_3_apppath:='PeaZip''s folder';
txt_3_3_run:='Run';
txt_3_2_7zutf8nonascii:='7z / p7zip -mcu use UTF8 for file names containing non-ASCII symbols inside .zip files';
txt_3_2_alltasks:='All tasks';
txt_3_2_conf:='Configuration';
txt_3_2_donations:='Donate to charitable organizations';
txt_3_1_sccenc:='7z / p7zip -scc console character encoding';
txt_3_1_downloads:='Downloads';
txt_3_1_lib:='Libraries';
txt_3_1_more:='More';
txt_3_1_openasarchive:='Open as archive';
txt_3_1_sendto:='User''s SendTo menu folder';
txt_3_1_pathexc:='Path exceeding maximum allowed size';
txt_3_1_recent:='Recent';
txt_3_1_plsmartmin:='Run minimized, show/keep open only if needed';
txt_3_1_src:='Searches';
txt_3_1_systmp:='User''s temp';
txt_3_1_languagetools:='Translate';
txt_3_1_workingdir:='Working directory';
txt_3_0_nonreadableorpw:='Archive is not readable. The archive may not be valid, or its table of content could be encrypted. Would you like to try a password?';
txt_3_0_readablepw:='Archive seems password protected';
txt_3_0_configure:='File associations and system menu integration';
txt_3_0_resettmp:='Reset temporary work files';
txt_2_9_address:='Address bar';
txt_2_9_adv:='Advanced filters are applied when managing any file supported through 7z or FreeArc backends, see documentation, and overrides basic filters (that are used for search functions and are displayed in Bookmarks and History panels)';
txt_2_9_columns:='Columns';
txt_2_9_copyhere:='Copy here';
txt_2_9_noscan:='Don''t scan files being added to layout';
txt_2_9_extconsole:='Extraction console is available only while browsing archives';
txt_2_9_thl:='Highlight buttons';
txt_2_9_home:='Home';
txt_2_9_lt:='Large';
txt_2_9_mt:='Medium';
txt_2_9_movehere:='Move here';
txt_2_9_nav:='Navigation';
txt_2_9_navbar:='Navigation bar';
txt_2_9_none:='None';
txt_2_9_organize:='Organize';
txt_2_9_public:='Public';
txt_2_9_rec:='Recursive: search in subdirectories, may take some time';
txt_2_9_selected:='Selected';
txt_2_9_setapps:='Organize Applications';
txt_2_9_showmenu:='Show Menu bar';
txt_2_9_st:='Small';
txt_2_9_test_pw2G:='Test for encryption <2GB archives';
txt_2_9_vst:='Text only';
txt_2_9_toolbar:='Tool bar';
txt_2_9_tree:='Tree';
txt_2_9_views:='Views';
txt_2_8_experimental:='(experimental)';
txt_2_8_zcopy:='(Windows) Copy files in restartable mode, slower copy';
txt_2_8_addvol:='Adding entire volume(s) to archive may take long time, continue anyway?';
txt_2_8_uniterror:='Cannot access the unit';
txt_2_8_cannotconvert:='Cannot convert selected archives';
txt_2_8_convertbegin:='Continue with compression stage to finalize the conversion?';
txt_2_8_convert:='Convert';
txt_2_8_convertexisting:='Convert existing archives';
txt_2_8_convertdelete:='Delete files and folders created temporarily for conversion?';
txt_2_8_details:='Details';
txt_2_8_parallel:='Execute tasks in parallel when possible';
txt_2_8_convertnote:='In any case original archives were not modified, to let the user in control about keeping or removing them';
txt_2_8_custom:='is not directly supported by PeaZip, but in extraction stage you can set PeaZip to handle custom file types in "Advanced" tab. Proceed opening this file?';
txt_2_8_unitrecommend:='It is recommended either to extract (rightclick > extract selected) or to open filesystems from computer''s root (system tools > Open unit as archive)';
txt_2_8_viewasarchive:='Open unit as archive';
txt_2_8_nounit:='No unit selected';
txt_2_8_rowselect:='Row select';
txt_2_8_statusbar:='Status bar';
txt_2_8_typeunit:='Type logical or physical unit name';
txt_2_8_usedefaultoutpath:='Always use default output path';
txt_2_7_experimental:='(experimental, see documentation)';
txt_2_7_optional:='(optional)';
txt_2_7_list_tryflatorpw:=', possible solutions: try flat view (F6), provide password (F9), get a fresh copy of the archive';
txt_2_7_separate:='Add to separate archives';
txt_2_7_pwsupported:='archiving with password';
txt_2_7_cancel:='Cancel';
txt_2_7_encfn:='Encrypt also file names (if supported by the format)';
txt_2_7_setpw:='Set password / keyfile';
txt_2_7_ext:='Extracting:';
txt_2_7_extfrom:='Extracting from archive:';
txt_2_7_es:='Extract supported non-archive file types, i.e. executables, MS Office and OOo files';
txt_2_7_eu:='Extract unsupported file types, specifying custom extraction utility';
txt_2_7_clipboard:='Clipboard';
txt_2_7_goarclayout:='Go to archiving layout';
txt_2_7_goextlayout:='Go to extraction layout';
txt_2_7_ok:='OK';
txt_2_7_drag_archive:='open file as new archive? ("No" to add file to current archiving layout)';
txt_2_7_oop:='Open output path when task completes';
txt_2_7_validatefn:='Operation stopped, invalid file name detected:';
txt_2_7_validatecl:='Operation stopped, potentially dangerous command detected (i.e. command concatenation not allowed within the program):';
txt_2_7_output:='Output';
txt_2_7_pwnotset:='Password is not set ';
txt_2_7_pwarcset:='Password is set';
txt_2_7_pwextset:='Password is set, it is possible to extract/list/test encrypted archives';
txt_2_7_archivehint:='Drag here files and folders to archive, or right-click for more options';
txt_2_7_exthint:='Drag here archives to extract, or right-click for more options';
txt_2_7_setadvf:='Set advanced filters';
txt_2_7_selpath:='Selected item''s path';
txt_2_7_separateerror:='Sorry, cannot import task definition''s command line while using "Add each object to a separate archive" switch, since the task is performed as multiple distinct commands';
txt_2_7_noinput:='The layout is empty: please use Add file(s) or Load Layout to populate the list of archives to be extracted';
txt_2_7_dirsize:='The size of the content of folders is not checked for calculating the total size';
txt_2_7_un7z_browse_flat:='try flat view (F6)';
txt_2_7_updating:='[Updating existing archive]';
txt_2_6_folders:='(folders)';
txt_2_6_advanced:='Advanced';
txt_2_6_plalways:='Always stop to inspect task report';
txt_2_6_plsmart:='Stop to inspect report for error, list, test';
txt_2_5_sessionio:='(this session)';
txt_2_5_advanced:='Advanced edit: place spaces between parameter strings and filename if needed';
txt_2_5_basic:='Basic edit: application and parameters before input name';
txt_2_5_cannotrun:='Cannot run';
txt_2_5_custeditors:='Custom editors, players, antivirus scanners etc... (override system''s file associations)';
txt_2_5_delete:='Delete';
txt_2_5_delete_fromarchive:='Delete from archive';
txt_2_5_langflag:='Display archived object''s name as UTF-8 text; uncheck to replace extended characters with "?"';
txt_2_5_encpj:='Encode task definition as UTF-8 text';
txt_2_5_execommand:='Executable or command';
txt_2_5_help:='Help';
txt_2_5_langhint:='Hint: replacing extended characters with "?" jolly character can improve syntax if archive''s character set cannot be successfully converted on the current machine';
txt_2_5_mini_help:='Localized Tutorial';
txt_2_5_offline_help:='PeaZip help';
txt_2_5_tray:='Reduce to tray';
txt_2_5_remove:='Remove';
txt_2_5_hintpaths:='Rightclick to open system''s and user''s paths';
txt_2_5_selectapp:='Select application';
txt_2_5_strafter:='String after input name';
txt_2_5_strbefore:='String before input name';
txt_2_5_encoding:='Text encoding';
txt_2_5_nopw:='this type of archives does not support encryption';
txt_2_4_draghint:='[drag to Explorer with enabled Address bar]';
txt_2_4_tb:='Adapt toolbar buttons (restarts PeaZip)';
txt_2_4_adding:='Adding';
txt_2_4_advclip:='Clipboard keeps multiple selections';
txt_2_4_yanswers:='Answers';
txt_2_4_itemsheight:='Auto-size items height';
txt_2_4_clearclipboard:='Clear clipboard (Esc)';
txt_2_4_wcommons:='Commons';
txt_2_4_copyfrom:='Copy from';
txt_2_4_deletebookmarks:='Do you want to delete the list of bookmarked files and folders?';
txt_2_4_documents:='Documents';
txt_2_4_wenc:='Encyclopedia';
txt_2_4_extractfrom:='Extract from';
txt_2_4_hexp:='Hex preview';
txt_2_4_operation:='Operation';
txt_2_4_path:='path is not writeable (i.e. read-only). Do you want to select a writeable output path?';
txt_2_4_removefromclipboard:='Remove from clipboard';
txt_2_4_stdclip:='Standard: keep a single selection in clipboard, clear cut operations on paste';
txt_2_4_totalmem:='total memory';
txt_2_4_gvideo:='Video';
txt_2_4_wbook:='Wikibook';
txt_2_4_wnews:='Wikinews';
txt_2_4_wsrc:='Wikisource';
txt_2_4_wdict:='Wiktionary';
txt_2_3_pw_errorchar:='quote character is not recommended to be used in passwords (for PeaZip and scripts). If you need to create or extract an archive with this password you can dismiss the message and you will be asked to enter the password interactively in console.';
txt_2_3_envstr:='Display environment variables';
txt_2_3_never_pw:='Don''t ask for password';
txt_2_3_home:='User''s home';
txt_2_3_on_pw:='On extract/list/test operations from system''s menus:';
txt_2_3_test_pw100:='Test for encryption <100MB archives';
txt_2_3_test_pw:='Test for encryption (may be slow)';
txt_exclude_recourse:='"exclude" recurse subdirs';
txt_action_extopen:='"Extract and open with associated application" action';
txt_error_passwordnotmatch:='"Password" and "Confirm" fields doesn''t match, please correct them';
txt_action_preview:='"Preview with associated application" action';
txt_preview_hint:='"Preview" action perform the same task as "Extract and open" but to a temporary path in output directory, automathically removed when the archive is closed.';
txt_better:='(better)';
txt_default2:='(default)';
txt_faster:='(faster)';
txt_fastermem:='(faster, less memory)';
txt_tempdir:='(PeaZip''s temporary work folder)';
txt_stream:='(set by "Stream control")';
txt_slowermem:='(slower, more memory)';
txt_store:='(store, fastest)';
txt_newfolder:='(in new folder)';
txt_7z_exitcodeunknown:=': Unknown error in task';
txt_list_isfolder:=' [folder]';
txt_none:='<none>';
txt_fd:='1.44 MB Floppy Disk';
txt_7z_exitcode1:='1: Warning: non fatal error(s); i.e. some files missing or locked';
txt_attach10:='10 MB attachment';
txt_7z_exitcode2:='2: Fatal error occurred';
txt_7z_exitcode255:='255: Task halted by the user';
txt_fat32:='4 GB FAT32 file';
txt_dvd:='4.7 GB DVD';
txt_attach5:='5 MB attachment';
txt_cd650:='650 MB CD';
txt_7z_exitcode7:='7: Error: got incorrect command line';
txt_cd700:='700 MB CD';
txt_type_description_7z:='7Z: feature rich archive format with high compression ratio';
txt_dvddl:='8.5 GB DVD DL';
txt_7z_exitcode8:='8: Error: not enough memory for requested operation';
txt_abort:='Abort scheduled file copy/move operations?';
txt_about:='About';
txt_action:='Action';
txt_action_hint:='Action on open or preview with associated application';
txt_add:='Add';
txt_add_existing_archive:='add (if archive exists)';
txt_add_archive:='Add archive';
txt_add_files:='Add files';
txt_add_folder:='Add folder';
txt_add_path:='Add path';
txt_add_tolayout:='Add selected files and folders to archive''s layout';
txt_add_toarchive:='Add to archive';
txt_add_tobookmarks:='Add to bookmarks';
txt_address_hint:='Filter: accepts * and ? wildcards';
txt_adv_filters:='Advanced filters';
txt_algo:='Algorithm';
txt_all:='all';
txt_all_default:='All (default)';
txt_all_type:='Same type';
txt_all_date:='Date';
txt_all_psize:='Packed file size';
txt_all_attributes:='Same attributes';
txt_all_size:='File size';
txt_error_input_upx:='allows a single executable file as input';
txt_always_pw:='Always ask for password';
txt_ignore_ext:='Always ignore paths for "Extract and..."';
txt_ignore_disp:='Always ignore paths for "Extract displayed..."';
txt_ignore_sel:='Always ignore paths for "Extract selected..."';
txt_key_hint:='Append keyfile''s hash to password; the archive can be decrypted by PeaZip and other applications following the same standard, or entering the hash as part of the password';
txt_timestamp:='Append timestamp to name';
txt_appoptions:='Application options';
txt_type_description_arc:='ARC: experimental archiver, powerful, efficient and feature-rich';
txt_archive:='Archive';
txt_un7z_browse_ok:='archive browsed successfully';
txt_interface:='Archive browser interface';
txt_archivecreation:='Archive creation';
txt_tarbefore_hint:='Archive data in TAR format before than in specified type.';
txt_archive_hint:='Archive, compress, split and keep private files, folders and volumes';
txt_compressionratio_hint:='Archive''s compression ratio';
txt_archiving:='Archiving:';
txt_cl_long:='Arguments seem exceeding the maximum size that can be passed by PeaZip frontend, please select less input files (i.e. select dirs instead of single files)';
txt_overwrite_askbefore:='Ask before overwriting (in console)';
txt_associated:='Associated application';
txt_attributes:='Attributes';
txt_author:='Author';
txt_ren_existing:='Auto rename existing files';
txt_ren_extracted:='Auto rename extracted files';
txt_autofolder:='Automatically create new folder to extract the archive in?';
txt_back:='Back';
txt_backend:='Backend binaries';
txt_backupexe:='Backup executable (recommended)';
txt_bettercompression:='better compression';
txt_blogs:='Blogs';
txt_blowfish:='Blowfish448 (64 bit blocks)';
txt_bookmarks:='Bookmarks';
txt_browse:='Browse';
txt_browser:='Browser';
txt_aborted_error:='Browsing archive stopped, it would take too much time. You can narrow the selection using search (F3) or exiting Flat view mode (F6); extract/list/test operations are not affected by this issue.';
txt_list_browsing:='Browsing';
txt_archive_root:='Browsing: archive''s root';
txt_type_description_bzip2:='BZip2: quite powerful compression, average speed';
txt_pw_empty:='Please provide a password (or a keyfile)';
txt_add_error:='Cannot add/update or delete object(s); probably the archive type has browse/extract only support, or cannot support that particular operation (i.e. it''s multi-volume or solid), or PeaZip cannot fully handle the archive name';
txt_un7z_browse_failure:='cannot browse archive';
txt_list_error:='Cannot list archive''s content, please check if the archive is password protected or corrupted.';
txt_conf_cannotsave:='Cannot save configuration file, check if the path is writeable and with some free space';
txt_check_hint:='Check for casual data corruption; hash algorithms are suitable to detect even malicious data tampering (see the documentation)';
txt_check:='Checksum/hash file(s)';
txt_check_select:='Checksum/hash';
txt_clear:='Clear';
txt_clearlayout:='Clear layout';
txt_pj_hint:='Click to import task, reset changes and load up to date task definition from GUI';
txt_autoclose:='Never stop to inspect task report';
txt_cl:='command line:';
txt_compare:='Compare files';
txt_compress:='Compress';
txt_compress_executable:='Compress executable';
txt_compress_openforwriting:='Compress files open for writing';
txt_compression:='Compression';
txt_compmanagement:='Computer management';
txt_pw_confirm:='Confirm';
txt_console:='Console';
txt_console_interface:='Console: native interface';
txt_content:='Content';
txt_controlpanel:='Control panel';
txt_convert:='Convert disk to NTFS';
txt_copy:='Copy';
txt_copyto:='Copy to...';
txt_create:='Create';
txt_create_archive:='Create new archive';
txt_title_create:='Create archive, compress, encrypt, split...';
txt_create_keyfile:='Create keyfile';
txt_create_folder:='Create new folder';
txt_create_theme:='Create Theme from current settings';
txt_rr:='Create recovery records';
txt_create_sfx:='Create self-extracting archive';
txt_cr_current:='Current path or filter compression ratio';
txt_custom:='Custom';
txt_type_description_custom:='Custom (advanced users): enter executable name and parameters';
txt_customapp:='Custom application';
txt_custom_parameters:='Custom parameters';
txt_customsize:='Custom size';
txt_cut:='Cut';
txt_datetime:='Date/time';
txt_default:='default';
txt_default_compression:='default compression';
txt_default_format:='Default format';
txt_theme_default:='Default theme';
txt_hard_reset_hint:='Delete bookmarks file';
txt_desktop:='Desktop';
txt_dictionary:='Dictionary';
txt_dirs:='dir(s),';
txt_dis:='Disambiguation:';
txt_disk_cleanup:='Disk cleanup';
txt_disk_defrag:='Disk defrag';
txt_disk_management:='Disk management';
txt_dispaly:='Display results as';
txt_displayedmnu_obj:='displayed';
txt_displayedobjects:='Displayed items';
txt_nocompress:='do not compress';
txt_delete:='Do you want to delete selected file(s)? The operation can''t be undone and files will be not recoverable from recycle bin';
txt_wipe:='Do you want to securely delete selected file(s)? The operation can''t be undone and files will be not recoverable';
txt_done:='Done';
txt_edit:='Edit';
txt_elapsed:='elapsed:';
txt_error_emptycl:='Empty command line!';
txt_encrypt:='Encrypt';
txt_encrypted:='encrypted';
txt_encryption:='Encryption';
txt_note:='Enter note / description';
txt_random_keys:='Enter random keys';
txt_random_keys_hint:='Enter random keys (you not have to remember)';
txt_ent:='Entropy evaluation';
txt_ent_tools:='Move the mouse or use additional entropy sampling tools';
txt_eqorlarger:='Same or larger than selected object';
txt_eqorrecent:='Same or more recent than selected object';
txt_eqorolder:='Same or older than selected object';
txt_eqorsmaller:='Same or smaller than selected object';
txt_equal:='Same of selected object';
txt_erase_hint:='Secure delete: overwrite with random data, mask size, rename, finally delete';
txt_extraction_error:='Error extracting the selected object. If the archive is password protected please provide it';
txt_exclude_hint:='Exclude file(s), one per line; use * and ? wildcards; " and '' delimiters are not needed';
txt_exclusion_recourse:='Exclusion filters recurse subdirs';
txt_exclusion:='Exclude';
txt_exe:='Executable';
txt_overwrite_qry:='exists in destination path; overwrite with file(s) with same name from source path? (Cancel: skip copying this objecy)';
txt_confirm_overwrite:='exists; overwrite it? (no to skip)';
txt_explore_outpath:='Explore output path';
txt_explore_path:='Explore path';
txt_ext:='Ext:';
txt_caption_extract:='Extract';
txt_ext_nopath:='Extract (without path)';
txt_ext_all:='Extract all';
txt_ext_allhere:='Extract all here';
txt_ext_allto:='Extract all to';
txt_extopen_custom:='Extract and open with custom application';
txt_extopen_with:='Extract and open with...';
txt_ext_disp_here:='Extract displayed here';
txt_ext_disp:='Extract displayed object(s)';
txt_ext_disp_to:='Extract displayed object(s) to...';
txt_ext_here:='Extract here';
txt_ext_sel_here:='Extract selected here';
txt_ext_sel:='Extract selected object(s)';
txt_ext_sel_to:='Extract selected object(s) to...';
txt_extobj:='Extract the object';
txt_newfoldermenu:='Extract in new folder';
txt_extto:='Extract to...';
txt_level_fast:='Fast';
txt_fastcompr:='fast compression';
txt_fastopen:='Fast open routine, stop browsing extremely large archives, use filters instead';
txt_level_fastest:='Fastest';
txt_favformats:='Favorite formats';
txt_file:='File';
txt_filebrowser:='File browser';
txt_filetools:='File tools';
txt_files:='file(s),';
txt_nfiles:='Files';
txt_fs:='Filesystem';
txt_filters_recourse:='filter(s) recurse subdirs';
txt_filters:='Filters';
txt_flat:='Flat (show all)';
txt_list_flat:='Flat view';
txt_unit_floppy:='Floppy disk';
txt_foldername:='Folder name';
txt_nfolders:='Folders';
txt_error_input_multi:='format allows a single file as input; you can use "TAR before" switch to save input in a .TAR archive before, otherwise you can chose another format. HINT: chose archive format after had selected input data: "TAR before" switch will be automatically set';
txt_fwd:='Forward';
txt_list_found:='Found';
txt_free:='Free';
txt_free2:='free';
txt_name_full:='Full name';
txt_function:='Function';
txt_general:='General';
txt_multithreading:='Generic multithreading';
txt_go_browser:='Go to file browser';
txt_go_path:='Explore path (PeaZip)';
txt_guicl:='Graphic + console';
txt_guipealauncher:='Graphic: wrapped by PeaLauncher';
txt_graphic:='Graphic''s folder';
txt_gridaltcolor:='Grids alternate color';
txt_gridrowheight:='Grids row height';
txt_gui:='GUI';
txt_type_description_gzip:='GZip: fast compression';
txt_here:='here';
txt_list_history:='History';
txt_homeroot:='Computer/archive''s root level';
txt_quickbrowse_hint:='If browsing is stopped the user can narrow the selection using search or filter functions; extract/list/test functions are not affected in any way.';
txt_backupexe_hint:='If something goes wrong and lead to a non functional result, you may recover the original executable from the authomatic backup copy';
txt_attach:='If the mail client supports that command, the archive will be attached to a new mail';
txt_images:='Images';
txt_include_hint:='Include file(s), one per line; use * and ? wildcards; " and '' delimiters are not needed';
txt_filters_hint:='Inclusion and exclusion filters for 7z binary, please carefully read 7-Zip documentation to understand how those filters works';
txt_inclusion_recourse:='Inclusion filters recurse subdirs';
txt_inclusion:='Include';
txt_error_function:='Incorrect function requested';
txt_info:='Info';
txt_infoall:='Info on all';
txt_infodisp:='Info on displayed object(s)';
txt_infosel:='Info on selected object(s)';
txt_inputinfo:='Input information';
txt_input_list:='Input list:';
txt_iop:='input, output, parameters';
txt_ipo:='input, parameters, output';
txt_input:='Input';
txt_integrity:='Integrity check';
txt_chunk_size:='Invalid custom size, please correct it in a numerical value';
txt_invertsel:='Invert selection';
txt_type_exe:='is a Windows executable, do you want to run it? ("No" to try open it as archive) HINT: some executables may not properly run unless the whole archive is extracted before';
txt_return_to_archive:='is currently open; do you want to browse it?';
txt_not_accessible:='is no longer accessible';
txt_type_unsupported:='is not a supported archive type';
txt_checkname_failed:='is not a valid name.';
txt_not_accessible_list:='is not accessible, please check if the file list provided is correct and up to date';
txt_theme_create_error:='It was not possible to create the theme, try to use a name valid for a folder as theme name and to chose a writeable path';
txt_theme_exists:='yet exists, please provide a different path';
txt_job_code:='task code:';
txt_job_definition_saved:='Task definition successfully saved in';
txt_job_success:='Task successfully completed!';
txt_join:='Join';
txt_joinfiles:='Join files';
txt_keyfile:='Keyfile';
txt_keyfile_not_found:='Keyfile cannot be found or read. Please chose a different Keyfile.';
txt_keyfile_notcreated:='KeyFile not created';
txt_larger:='Larger than selected object';
txt_lastused:='Last used';
txt_launch:='Launch task';
txt_layout:='Layout';
txt_filelist_savedas:='Layout saved as';
txt_level:='Level';
txt_license:='License';
txt_caption_list:='List';
txt_list_details:='List (with details)';
txt_list_all:='List all';
txt_list_disp:='List displayed object(s)';
txt_list_sel:='List selected object(s)';
txt_toggle_warning:='Listing flat view of path''s content may take long time, continue anyway?';
txt_loadfile:='Load file';
txt_loadlayout:='Load layout';
txt_unit_hd:='Local disk';
txt_localization:='Localization';
txt_lpaqver:='LPAQ version';
txt_type_description_lpaq:='LPAQ: faster version of PAQ, very good compression';
txt_maininterface:='Main interface';
txt_maxcomp:='Max compression mode';
txt_level_maximum:='Maximum';
txt_restartrequired:='May require restarting the application to be applied';
txt_required_memory:='MB of memory required';
txt_method:='Method';
txt_misc:='Misc';
txt_modify:='Modify';
txt_morecontrols:='More controls (history, bookmarks, ...)';
txt_morerecent:='More recent than selected object';
txt_ent_hint:='Move the mouse, enter keys in the edit field, load files to collect entropy from the system...';
txt_moveto:='Move to...';
txt_mypc:='Computer''s root';
txt_list_na:='n/a';
txt_name:='Name';
txt_naming:='Naming';
txt_unit_remote:='Network drive';
txt_newarchive:='new archive';
txt_cnewfolder:='New folder';
txt_news:='News';
txt_no:='No';
txt_noinput:='No accessible input received';
txt_nocompress_hint:='no compression (faster)';
txt_split_noinput:='No input selected; please select a file to split';
txt_open_noinput:='No input selected; please select an archive (first archive''s volume for multi-volume archives)';
txt_list_nomatch:='no match';
txt_singlethread:='No multithreading';
txt_none2:='none';
txt_nonsolid:='Non-solid';
txt_level_normal:='Normal';
txt_copy_error:='not successfully copied or moved, error code:';
txt_description:='Notes';
txt_compare_second:='Now select file to be compared with';
txt_peaobj:='Object control';
txt_displayed_obj:='object(s)';
txt_olderthan:='Older than selected object';
txt_on:='on';
txt_ondblclick:='On doubleclick';
txt_opacity:='Opacity';
txt_open:='Open';
txt_openarchive:='Open archive';
txt_title_open:='Open archive, decrypt, join...';
txt_open_bookmark:='Open bookmark';
txt_cphere:='Open command prompt here';
txt_open_file:='Open file';
txt_open_files:='Open file(s)';
txt_open_path:='Open path';
txt_opensource:='Open source portable archiver';
txt_openwith:='Open with...';
txt_aborted:='Operation aborted';
txt_unit_cd:='Optical drive';
txt_options:='Options';
txt_other:='Other';
txt_otherparams:='Other parameters (free editing)';
txt_oip:='output, input, parameters';
txt_opi:='output, parameters, input';
txt_output:='output:';
txt_overwrite:='Overwrite existing files';
txt_compressed_size:='Packed';
txt_paqver:='PAQ version';
txt_type_description_paq:='PAQ: slow but extremely powerful compressor';
txt_pio:='parameters, input, output';
txt_poi:='parameters, output, input';
txt_parameters:='Parameters:';
txt_error_partial:='Partial extraction not implemented for current archive type';
txt_passes:='Passes';
txt_pw:='Password';
txt_pwlength:='Password length in characters (4..64)';
txt_un7z_browse_pw:='password may be required';
txt_un7z_browse_pw_other:='password may be wrong';
txt_paste:='Paste';
txt_path:='Path';
txt_pea_appcolor:='Application accent color';
txt_pea_textcolor:='Pea text color';
txt_type_description_pea:='PEA: security oriented archive format with fast compression';
txt_peazip_new:='PeaZip (new instance)';
txt_peazip_help:='Online support';
txt_peazip_web:='PeaZip Website';
txt_performall:='Perform all supported algorithms';
txt_name_provide:='\ / : * ? '' " < > | characters are not allowed in file names';
txt_upxorstrip:='Please chose Strip and/or UPX on the binary';
txt_not_removable_file:='Please close file in use, in order to allow PeaZip to remove it:';
txt_not_removable:='Please close files in use, in order to allow PeaZip to remove the folder:';
txt_custom_executable_missing:='Please provide the custom executable''s name';
txt_type_unsupported_select:='Please select a supported archive type:';
txt_no_theme_name:='Please specify a theme name';
txt_please_wait:='Please wait';
txt_copy_wait:='Please wait currently scheduled file copy/move operations to complete before scheduling other operations of the same type';
txt_previewwith:='Preview with...';
txt_projectadmin:='Project administrator:';
txt_type_description_quad:='BALZ/QUAD: high-performance ROLZ-based file compressors';
txt_quickdelete:='Quick delete';
txt_quit:='Quit';
txt_unit_ram:='RAM disk';
txt_read:='Read:';
txt_recentarchives:='Recent archives';
txt_rr_hint:='Recovery records allows to try to correct archives in case of data corruption';
txt_search_refine:='Refine search filter, accepts ? and * wildcards';
txt_fefreshf5:='Refresh';
txt_release:='release:';
txt_unit_removable:='Removable unit';
txt_remove_bookmark:='Remove bookmark';
txt_remove_external_unit:='Remove external device(s)';
txt_removeselected:='Remove selected object(s)';
txt_rename:='Rename';
txt_caption_repair:='Repair';
txt_restartrequired2:='requires restarting the application to apply';
txt_reset:='Reset';
txt_reset_archivename:='Reset archive name';
txt_hardreset:='Reset bookmarks';
txt_reset_theme:='Reset to embedded theme';
txt_restore_att:='restore original attributes';
txt_run_as:='Run as (cannot switch to users with blank password)';
txt_run_as2:='Run as different user';
txt_sample:='Sample: ';
txt_saveas:='Save as';
txt_savehistory:='Save history data';
txt_save_infolder:='Save in folder (auto)';
txt_savejob:='Save task definition as script';
txt_savejobdefinition:='Save task definition as script';
txt_savejobdefinition_hint:='Save task definition as plain text; you can use it from your scripts';
txt_savelayout:='Save layout';
txt_save_winstate:='Save main window state';
txt_search:='Search (recursive, may take some time)';
txt_searchanddrag:='Search and drag here';
txt_searchfor:='Search';
txt_nrsearch:='Search here (non recursive)';
txt_search_hint:='Search in archive''s subdirectories for matches with filter(s)';
txt_search_web:='Web search';
txt_list_searching:='Searching...';
txt_securedelete:='Secure delete';
txt_default_description:='Select a function or drag files here';
txt_selectall:='Select all';
txt_selectdir:='Select directory';
txt_selected_obj:='selected';
txt_selected_objects:='Selected items';
txt_sfx:='Self-extracting';
txt_sendbymail:='Send by mail';
txt_set_defaults:='Set application''s default parameters';
txt_settings:='Settings';
txt_sfx_interface:='sfx interface';
txt_showhints:='Show hints';
txt_show_messages:='Show information messages';
txt_showpw:='Show password field content';
txt_singlevol:='Single volume, do not split';
txt_size:='Size';
txt_sizeb:='Size (B)';
txt_skip_existing:='Skip existing files';
txt_slowercomp:='slower compression but equally fast decompression';
txt_smaller:='Smaller than selected object';
txt_solid:='Solid';
txt_solid_block:='Block size';
txt_solid_auto:='Solid, auto-adjust';
txt_solid_extension:='Solid, group by extension';
txt_listtest:='sorry, list/test operation is not yet implemented for this format';
txt_sortbysel:='Sort by selection status';
txt_list_sorting:='Sorting...';
txt_speed:='speed';
txt_split:='Split';
txt_type_description_split:='Split a file with optional integrity check';
txt_split_file:='Split file';
txt_list_nostats:='stats not available';
txt_status:='Status';
txt_level_store:='Store';
txt_stream_control:='Stream control';
txt_strip:='Strip before UPX (recommended)';
txt_keyfile_created:='Successfully created KeyFile as:';
txt_suggestpw:='Create random password';
txt_noupx:='Symbols stripped, UPX compression omitted';
txt_syntax:='Syntax:';
txt_sysbenchmark:='System benchmark';
txt_benchmark:='System benchmark will take some minutes and will use all available CPU and memory resource. The system may not respond during the benchmark; run it anyway?';
txt_systools:='System tools';
txt_tarbefore:='TAR before';
txt_type_description_tar:='TAR: archiving format mainstream on UNIX systems';
txt_taskman:='Task Manager';
txt_caption_test:='Test';
txt_testall:='Test all';
txt_testdisp:='Test displayed object(s)';
txt_testpw:='Test password / keyfile';
txt_testsel:='Test selected object(s)';
txt_col_hint:='The color should be chosen in order to integrate well with icon colors and to other GUI''s elements';
txt_bookmarks_hint:='The complete and editable list of bookmarks is available in the file browser interface, clicking on the "More controls" icon and on "Toggle history/bookmarks"';
txt_archive_noinput_tolist:='The layout is empty: please use Add file(s), Add folder(s) or Load Layout to populate the archive''s layout';
txt_theme:='Theme';
txt_icons_found:='Theme loaded successfully.';
txt_themename:='Theme name';
txt_icons_not_found:='Theme not loaded correctly. Try to switch to the default theme, or to a known working one.';
txt_theme_create_success:='theme successfully created in';
txt_theming:='Theming';
txt_extand_error:='This function can be performed on a single object at time';
txt_threads:='Threads';
txt_titlescolor:='Titles color';
txt_to:='to';
txt_toggle_browseflat:='Toggle browse / flat view (show all)';
txt_toggle_historybookmarks:='Toggle status bar, bookmarks, history, clipboard';
txt_toolbarscolor:='Bars color';
txt_tools:='Tools';
txt_best:='try best settings (slow)';
txt_type:='Type';
txt_level_ultra:='Ultra';
txt_error_openfile:='Unable to open the specified file';
txt_cl_hint:='UNACE and UPX always run using console mode; list, test and benchmark tasks always run using GUI mode';
txt_ace_missing:='UNACE plugin is missing; for handling ACE archives you can download the plugin form PeaZip''s website (being UNACE closed source, the plugin is not featured in base package)';
txt_units:='units';
txt_unit_unknown:='Unknown drive type';
txt_un7z_pw_untested:='Untested';
txt_up:='Up';
txt_update:='update (if archive exists)';
txt_type_description_upx:='UPX: compress executable files only';
txt_advfilters:='Use advanced filters';
txt_openfiles_hint:='Use this option to include in the archive files open for writing by other applications (useful in backup tasks)';
txt_usenet:='Usenet';
txt_user_name:='User name; use user@DOMAIN or DOMAIN\user form if needed.';
txt_using:='Using:';
txt_volumepea:='Volume control';
txt_volume_size:='Volume size';
txt_type_ext_uns:='was successfully extracted';
txt_websearch:='Web search';
txt_websites:='Websites';
txt_word:='Word';
txt_write:='Write:';
txt_ramdompw_hint:='You can copy the random generated password from here';
txt_exe_hint:='You can freely enter executable name and parameters for custom compression, and chose syntax''s construction. Please note that you can also manually change command''s syntax in "Console" tab.';
txt_pj_hint2:='You can import the task''s definition from the GUI frontend in the memo field above. Then, you can edit, launch or save it without changing or losing the task defined for the GUI frontend.';
txt_type_description_zip:='ZIP: fast archiving/compression format, mainstream on Windows systems';
txt_zipcrypto_hint:='ZipCrypto (legacy)';
end;

function texts(lang:ansistring):integer;
begin
load_default_texts;
if lang='volatile' then begin assign_guitext; texts:=0; exit; end;
if load_texts(lang)<>0 then //try to load language file sequentially; fallback to a slower recoursive procedure to valorize each known variable from lang file strings if the language file version doesn't match with PeaZip's version
   begin
   load_default_texts;
   assign_guitext;
   texts:=0;
   end
else texts:=0;
end;

procedure msg_not_accessible(i:integer);
begin

end;

procedure msg_not_accessible_s(s:ansistring);
begin

end;

procedure msg_not_accessible_list(s:ansistring);
begin

end;

procedure msg_no_input;
begin

end;

procedure msg_pw_errorchar(s:ansistring);
begin
pMessageWarningOK(correctdelimiter(s)+' '+txt_2_3_pw_errorchar);
end;

{///////////////////////////////////////////////////////////////////////////////

configuration and theming

///////////////////////////////////////////////////////////////////////////////}

procedure getthemepath(var thpath:ansistring);
var
   s:ansistring;
begin
if theme_name='' then
   begin
   s:=extractfilepath(theme_path);
   if s<>'' then setlength(s,length(s)-1);
   theme_name:=extractfilename(s);
   end;
//default and no graphic themes are in application's path, custom themes are in configuration path (application's path for portable versions, user's home/application data for installable versions)
if (upcase(theme_name)<>upcase(DEFAULT_THEME)) and (upcase(theme_name)<>'NOGRAPHIC-EMBEDDED') then thpath:=confpath
else thpath:=sharepath;
end;

procedure clearimagelist(var aimagelist:TImageList);
begin
repeat
aimagelist.Delete(aimagelist.Count-1);
until aimagelist.Count<=0;
end;

procedure setexticonsize(icon_size:integer; var icon_sizep:integer);
begin
{$IFDEF DARWIN}
icon_sizep:=((icon_size)*qscaleimages) div 100; //currently only supports small icons, and size is fixed
{$ELSE}
icon_sizep:=((icon_size+((pspacing*icon_size) div 16))*qscaleimages) div 100;
{$ENDIF}
reficonsize:=icon_sizep;
baseiconsize:=icon_size;
end;

procedure loadlargeicons(icon_size:integer);
var
   abitmap:TBitmap;
   icon_sizep:integer;
begin
with form_peach do
   begin
   setexticonsize(icon_size,icon_sizep);
   case icon_size of
   48: begin
   clearimagelist(il48);
   abitmap:=Tbitmap.Create;
   loadlargeicon(Barchivesupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bexesupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bfilesupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(BFolder48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Blink48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bunsupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdvd_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bfd_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bhd_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bram_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bremote_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bremovable_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Baudio48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bspreadsheet48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Btxt48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bvideo48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bweb48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bimage48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bpresentation48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bpdf48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bbat48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bsupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdll48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bmail48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdb48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bgif48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bico48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bvector48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Binfo,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bsearch,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bbookmark,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Broot,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bsystemtools,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bexpand,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bgopath,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bjpeg48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdesk,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bplaceshistory,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bbookmarkadd,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Brun,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bpreview,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bapps,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bhomefolder,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdownloadfolder,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bcloudfolder,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barc7z48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barcrar48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barczip48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barcblock48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barcdisk48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barcinstaller48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   ListView1.LargeImages:=il48;
   end;
   96: begin
   clearimagelist(il96);
   abitmap:=Tbitmap.Create;
   loadlargeicon(Barchivesupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bexesupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bfilesupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(BFolder96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Blink96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bunsupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdvd_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bfd_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bhd_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bram_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bremote_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bremovable_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Baudio96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bspreadsheet96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Btxt96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bvideo96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bweb96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bimage96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bpresentation96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bpdf96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bbat96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bsupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdll96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bmail96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdb96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bgif96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bico96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bvector96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Binfo,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bsearch,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bbookmark,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Broot,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bsystemtools,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bexpand,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bgopath,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bjpeg96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdesk,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bplaceshistory,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bbookmarkadd,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Brun,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bpreview,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bapps,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bhomefolder,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdownloadfolder,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bcloudfolder,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barc7z96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barcrar96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barczip96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barcblock96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barcdisk96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barcinstaller96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   ListView1.LargeImages:=il96;
   end;
   192: begin
   clearimagelist(il192);
   abitmap:=Tbitmap.Create;
   setpbitmap_tobitmap(Barchivesupported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bexesupported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bfilesupported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(BFolder96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Blink96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bunsupported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bdvd_supported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bfd_supported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bhd_supported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bram_supported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bremote_supported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bremovable_supported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Baudio96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bspreadsheet96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Btxt96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bvideo96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bweb96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bimage96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bpresentation96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bpdf96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bbat96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bsupported96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bdll96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bmail96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bdb96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bgif96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bico96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bvector96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Binfo,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bsearch,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bbookmark,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Broot,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bsystemtools,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bexpand,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bgopath,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bjpeg96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bdesk,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bplaceshistory,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bbookmarkadd,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Brun,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bpreview,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bapps,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bhomefolder,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bdownloadfolder,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Bcloudfolder,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Barc7z96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Barcrar96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Barczip96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Barcblock96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Barcdisk96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   setpbitmap_tobitmap(Barcinstaller96,abitmap,baseiconsize);
   setsize_bitmap(abitmap, reficonsize, DECO_NONE);
   il192.Add(abitmap,nil);
   ListView1.LargeImages:=il192;
   end;
   end;
   end;
end;

procedure loadsmallicons(icon_size:integer);
var
   abitmap:TBitmap;
   icon_sizep,pspacing_p:integer;
begin
with form_peach do
   begin
   setexticonsize(icon_size,icon_sizep);
   case icon_size of
   16: begin
   clearimagelist(il16);
   abitmap:=Tbitmap.Create;
   loadlargeicon(Barchivesupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bexesupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bfilesupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(BFolder,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Blink,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bunsupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdvd_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bfd_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bhd_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bram_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bremote_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bremovable_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Baudio,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bspreadsheet,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Btxt,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bvideo,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bweb,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bimage,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bpresentation,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bpdf,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bbat,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bsupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdll,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bmail,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdb,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bgif,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bico,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bvector,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Binfo,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bsearch,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bbookmark,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Broot,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bsystemtools,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bexpand,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bgopath,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bjpeg,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdesk,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bplaceshistory,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bbookmarkadd,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Brun,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bpreview,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bapps,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bhomefolder,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdownloadfolder,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bcloudfolder,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barc7z,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barcrar,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barczip,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barcblock,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barcdisk,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barcinstaller,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   ListView1.SmallImages:=il16;
   end;
   48: begin
   clearimagelist(il48);
   abitmap:=Tbitmap.Create;
   loadlargeicon(Barchivesupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bexesupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bfilesupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(BFolder48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Blink48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bunsupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdvd_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bfd_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bhd_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bram_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bremote_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bremovable_supported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Baudio48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bspreadsheet48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Btxt48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bvideo48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bweb48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bimage48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bpresentation48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bpdf48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bbat48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bsupported48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdll48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bmail48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdb48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bgif48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bico48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bvector48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Binfo,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bsearch,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bbookmark,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Broot,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bsystemtools,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bexpand,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bgopath,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bjpeg48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdesk,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bplaceshistory,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bbookmarkadd,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Brun,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bpreview,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bapps,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bhomefolder,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bdownloadfolder,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Bcloudfolder,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barc7z48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barcrar48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barczip48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barcblock48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barcdisk48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   loadlargeicon(Barcinstaller48,abitmap,icon_sizep);
   il48.Add(abitmap,nil);
   ListView1.SmallImages:=il48;
   end;
   96: begin
   clearimagelist(il96);
   abitmap:=Tbitmap.Create;
   loadlargeicon(Barchivesupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bexesupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bfilesupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(BFolder96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Blink96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bunsupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdvd_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bfd_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bhd_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bram_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bremote_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bremovable_supported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Baudio96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bspreadsheet96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Btxt96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bvideo96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bweb96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bimage96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bpresentation96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bpdf96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bbat96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bsupported96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdll96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bmail96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdb96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bgif96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bico96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bvector96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Binfo,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bsearch,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bbookmark,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Broot,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bsystemtools,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bexpand,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bgopath,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bjpeg96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdesk,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bplaceshistory,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bbookmarkadd,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Brun,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bpreview,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bapps,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bhomefolder,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bdownloadfolder,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Bcloudfolder,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barc7z96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barcrar96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barczip96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barcblock96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barcdisk96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   loadlargeicon(Barcinstaller96,abitmap,icon_sizep);
   il96.Add(abitmap,nil);
   ListView1.SmallImages:=il96;
   end;
   end;
   end;
end;

procedure loadimglist1icons;
var
   abitmap:TBitmap;
begin
with Form_peach do
begin
abitmap:=Tbitmap.Create;
ilsmall.Clear;
loadlargeicon(Barchivesupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bexesupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bfilesupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(BFolder,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Blink,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bunsupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdvd_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bfd_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bhd_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bram_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bremote_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bremovable_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Baudio,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bspreadsheet,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Btxt,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bvideo,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bweb,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bimage,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bpresentation,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bpdf,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bbat,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bsupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdll,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bmail,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdb,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bgif,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bico,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bvector,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Binfo,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bsearch,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bbookmark,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Broot,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bsystemtools,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bexpand,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bgopath,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bjpeg,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdesk,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bplaceshistory,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bbookmarkadd,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Brun,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bpreview,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bapps,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bhomefolder,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdownloadfolder,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bcloudfolder,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barc7z,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barcrar,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barczip,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barcblock,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barcdisk,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barcinstaller,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barchive,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bextractall,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bextractalln,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
end;
end;

procedure load_icons; //load icons from bitmaps
var
   i:integer;
   thpath:ansistring;
begin
if imgloaded=true then exit;
if imgloading=true then exit;
imgloading:=true;
case ensmall of
   0: i16res:=(16*qscaleimages) div 100;
   1: i16res:=(18*qscaleimages) div 100;
   2: i16res:=(20*qscaleimages) div 100;
   3: i16res:=(24*qscaleimages) div 100;
   4: i16res:=(28*qscaleimages) div 100;
   5: i16res:=(32*qscaleimages) div 100;
   end;
if lsize=0 then
   i32res:=(24*qscaleimages) div 100
else
   i32res:=(32*qscaleimages) div 100;
i48res:=(48*qscaleimages) div 100;
i96res:=(96*qscaleimages) div 100;
with Form_peach do
   begin
   try
   //set non-themed graphic
   Bnonthemed0:=TBitmap.Create;
   Bnonthemed1:=TBitmap.Create;
   Bnonthemed3:=TBitmap.Create;
   Bnonthemed4:=TBitmap.Create;
   Bnonthemed5:=TBitmap.Create;
   Bnonthemed6:=TBitmap.Create;
   Bnonthemed7:=TBitmap.Create;
   Bnonthemed8:=TBitmap.Create;
   Bnonthemed9:=TBitmap.Create;
   Bnonthemed10:=TBitmap.Create;
   Bnonthemed11:=TBitmap.Create;
   Bp1:=TBitmap.Create;
   Bp2:=TBitmap.Create;
   Bp3:=TBitmap.Create;
   Bp4:=TBitmap.Create;
   Bp5:=TBitmap.Create;
   Bp6:=TBitmap.Create;
   Bp7:=TBitmap.Create;
   Bp8:=TBitmap.Create;
   binfodlg:=TBitmap.Create;
   bwarningdlg:=TBitmap.Create;
   berrordlg:=TBitmap.Create;
   il_nonthemed.getbitmap(0,Bnonthemed0);
   il_nonthemed.getbitmap(1,Bnonthemed1);
   il_nonthemed.getbitmap(2,Bnonthemed3);
   il_nonthemed.getbitmap(3,Bnonthemed4);
   il_nonthemed.getbitmap(4,Bnonthemed5);
   il_nonthemed.getbitmap(5,Bnonthemed6);
   il_nonthemed.getbitmap(6,Bnonthemed7);
   il_nonthemed.getbitmap(7,Bnonthemed8);
   il_nonthemed.getbitmap(8,Bnonthemed9);
   il_nonthemed.getbitmap(9,Bnonthemed10);
   il_nonthemed.getbitmap(10,Bnonthemed11);
   il_nonthemed.getbitmap(11,Bp1);
   il_nonthemed.getbitmap(12,Bp2);
   il_nonthemed.getbitmap(13,Bp3);
   il_nonthemed.getbitmap(14,Bp4);
   il_nonthemed.getbitmap(15,Bp5);
   il_nonthemed.getbitmap(16,Bp6);
   il_nonthemed.getbitmap(17,Bp7);
   il_nonthemed.getbitmap(18,Bp8);
   ImageListDlg.getbitmap(0,binfodlg);
   ImageListDlg.getbitmap(1,bwarningdlg);
   ImageListDlg.getbitmap(2,berrordlg);
   setpbitmap(Bnonthemed0,i16res);
   setpbitmap(Bnonthemed1,i16res);
   setpbitmap(Bnonthemed3,i16res);
   setpbitmap(Bnonthemed4,i16res);
   setpbitmap(Bnonthemed5,i16res);
   setpbitmap(Bnonthemed6,i16res);
   setpbitmap(Bnonthemed7,i16res);
   setpbitmap(Bnonthemed8,i16res);
   setpbitmap(Bnonthemed9,i16res);
   setpbitmap(Bnonthemed10,i16res);
   setpbitmap(Bnonthemed11,i16res);
   setpbitmap(Bp1,i16res);
   setpbitmap(Bp2,i16res);
   setpbitmap(Bp3,i16res);
   setpbitmap(Bp4,i16res);
   setpbitmap(Bp5,i16res);
   setpbitmap(Bp6,i16res);
   setpbitmap(Bp7,i16res);
   setpbitmap(Bp8,i16res);
   setpbitmap(binfodlg,i32res);
   setpbitmap(bwarningdlg,i32res);
   setpbitmap(berrordlg,i32res);
   ButtonUn7za6.Glyph:=Bnonthemed0;
   ButtonUn7za7.Glyph:=Bnonthemed0;
   ButtonUn7za8.Glyph:=Bnonthemed0;
   ButtonUn7za11.Glyph:=Bnonthemed0;
   ButtonUn7za9.Glyph:=Bnonthemed0;
   Buttoncmto.Glyph:=Bnonthemed0;
   Buttonopenactions.Glyph:=Bnonthemed0;
   Buttonfmactions.Glyph:=Bnonthemed0;
   Buttonfmactions1.Glyph:=Bnonthemed0;
   ButtonImg6.Glyph:=Bnonthemed0;
   ButtonImgR.Glyph:=Bnonthemed0;
   ButtonImgRes.Glyph:=Bnonthemed0;
   Imagelistroot.Picture.Bitmap:=Bnonthemed0;
   ButtonEditname12.Glyph:=Bnonthemed0;
   ButtonEditname14.Glyph:=Bnonthemed0;
   ButtonEditname8.Glyph:=Bnonthemed0;
   ButtonEditname13.Glyph:=Bnonthemed0;
   ButtonUn7za10.Glyph:=Bnonthemed0;
   ButtonEditname4.Glyph:=Bnonthemed0;
   ImageAddress0.Picture.Bitmap:=Bnonthemed5;
   ImageAddress1.Picture.Bitmap:=Bnonthemed5;
   ImageAddress2.Picture.Bitmap:=Bnonthemed5;
   ImageAddress3.Picture.Bitmap:=Bnonthemed5;
   ImageAddress4.Picture.Bitmap:=Bnonthemed5;
   ImageAddress5.Picture.Bitmap:=Bnonthemed5;
   ImageAddress6.Picture.Bitmap:=Bnonthemed5;
   ImageAddress7.Picture.Bitmap:=Bnonthemed5;
   ImageAdArchive0.Picture.Bitmap:=Bnonthemed5;
   ImageAdArchive1.Picture.Bitmap:=Bnonthemed5;
   ImageAdArchive2.Picture.Bitmap:=Bnonthemed5;
   ImageAdArchive3.Picture.Bitmap:=Bnonthemed5;
   mAdmin.Bitmap:=Bnonthemed7;
   ctrlext.Glyph:=Bnonthemed10;
   ctrlarc.Glyph:=Bnonthemed10;
   panelnav4.Glyph:=Bnonthemed8;
   Imageopenadvf.Width:=i16res;
   Imageopenadvf.Height:=i16res;
   Imageopenadvf.Picture.Bitmap:=Bnonthemed9;
   Imageopenadvf1.Width:=i16res;
   Imageopenadvf1.Height:=i16res;
   Imageopenadvf1.Picture.Bitmap:=Bnonthemed9;
   Imageopenadvf2.Width:=i16res;
   Imageopenadvf2.Height:=i16res;
   Imageopenadvf2.Picture.Bitmap:=Bnonthemed9;
   imagesp.Width:=i16res;
   imagesp.Height:=i16res;
   imagesp.Picture.Bitmap:=Bnonthemed11;
   imagesp1.Width:=i16res;
   imagesp1.Height:=i16res;
   imagesp1.Picture.Bitmap:=Bnonthemed11;
   //set themed graphic
   Bbrowserdetails:=TBitmap.Create;
   Bbrowserlist:=TBitmap.Create;
   Bbrowsericons:=TBitmap.Create;
   Bbrowserdetailslarge:=TBitmap.Create;
   Bbrowserlistlarge:=TBitmap.Create;
   Bbrowsericonslarge:=TBitmap.Create;
   Bapps:=TBitmap.Create;
   Barchive_bigger2:=TBitmap.Create;
   Bplaceshistory:=TBitmap.Create;
   Bdb:=TBitmap.Create;
   Bgif:=TBitmap.Create;
   Bico:=TBitmap.Create;
   Bvector:=TBitmap.Create;
   Bsupported:=TBitmap.Create;
   Bbat:=TBitmap.Create;
   Bdll:=TBitmap.Create;
   Bimage:=TBitmap.Create;
   Bjpeg:=TBitmap.Create;
   Bpresentation:=TBitmap.Create;
   Bpdf:=TBitmap.Create;
   Btxt:=TBitmap.Create;
   Bspreadsheet:=TBitmap.Create;
   Bvideo:=TBitmap.Create;
   Baudio:=TBitmap.Create;
   Bconvert:=TBitmap.Create;
   Bconvert_big:=TBitmap.Create;
   BArchive_big:=TBitmap.Create;
   BArchive:=TBitmap.Create;
   BArchiveSupported:=TBitmap.Create;
   BFileSupported:=TBitmap.Create;
   BExesupported:=TBitmap.Create;
   BUnsupported:=TBitmap.Create;
   Bback:=TBitmap.Create;
   Bbookmark:=TBitmap.Create;
   Bbookmarkadd:=TBitmap.Create;
   Bclearlayout:=TBitmap.Create;
   BDefaults:=TBitmap.Create;
   Bdelete:=TBitmap.Create;
   Bdvd_supported:=TBitmap.Create;
   Bexpand:=TBitmap.Create;
   Bextractall:=TBitmap.Create;
   Bextractalln:=TBitmap.Create;
   Bextractall_big:=TBitmap.Create;
   Bextractalln_big:=TBitmap.Create;
   Bfd_supported:=TBitmap.Create;
   BFolder:=TBitmap.Create;
   Bgo:=TBitmap.Create;
   Bgopath:=TBitmap.Create;
   Bgoup:=TBitmap.Create;
   Bhd_supported:=TBitmap.Create;
   Binfo:=TBitmap.Create;
   Bkeyfile:=TBitmap.Create;
   Bloadlayout:=TBitmap.Create;
   Blocker:=TBitmap.Create;
   Blocker2:=TBitmap.Create;
   Bmail:=TBitmap.Create;
   Bnav:=TBitmap.Create;
   Bp0:=TBitmap.Create;
   Bpreview:=TBitmap.Create;
   Bram_supported:=TBitmap.Create;
   Brefresh:=TBitmap.Create;
   Bremote_supported:=TBitmap.Create;
   Bremovable_supported:=TBitmap.Create;
   Bresetpath:=TBitmap.Create;
   Broot:=TBitmap.Create;
   Brun:=TBitmap.Create;
   Bsavelayout:=TBitmap.Create;
   Bsearch:=TBitmap.Create;
   Bdesk:=TBitmap.Create;
   Bsystemtools:=TBitmap.Create;
   Btestall:=TBitmap.Create;
   Bstop:=TBitmap.Create;
   Bweb:=TBitmap.Create;
   Bwipe:=TBitmap.Create;
   Btestall_big:=TBitmap.Create;
   Blink:=TBitmap.Create;
   Bdetailsfs:=TBitmap.Create;
   BTool_cut_small:=TBitmap.Create;
   BTool_copy_small:=TBitmap.Create;
   BTool_dup_small:=TBitmap.Create;
   Btool_properties_small:=TBitmap.Create;
   Btool_rename_small:=TBitmap.Create;
   Btool_cut:=TBitmap.Create;
   Btool_copy:=TBitmap.Create;
   Btool_paste:=TBitmap.Create;
   Btool_openw:=TBitmap.Create;
   Btool_properties:=TBitmap.Create;
   Btool_rename:=TBitmap.Create;
   Btool_delete:=TBitmap.Create;
   Btool_dup:=TBitmap.Create;
   BTool_resize:=TBitmap.Create;
   BTool_crop:=TBitmap.Create;
   BTool_rl:=TBitmap.Create;
   BTool_rr:=TBitmap.Create;
   BTool_resize_small:=TBitmap.Create;
   BTool_crop_small:=TBitmap.Create;
   BTool_rl_small:=TBitmap.Create;
   BTool_rr_small:=TBitmap.Create;
   Bdvd_supported48:=TBitmap.Create;
   Bfd_supported48:=TBitmap.Create;
   BFolder48:=TBitmap.Create;
   Bhd_supported48:=TBitmap.Create;
   Bram_supported48:=TBitmap.Create;
   Bremote_supported48:=TBitmap.Create;
   Bremovable_supported48:=TBitmap.Create;
   Btxt48:=TBitmap.Create;
   Bspreadsheet48:=TBitmap.Create;
   Bvideo48:=TBitmap.Create;
   Baudio48:=TBitmap.Create;
   Bimage48:=TBitmap.Create;
   Bpresentation48:=TBitmap.Create;
   Bpdf48:=TBitmap.Create;
   Bsupported48:=TBitmap.Create;
   Bbat48:=TBitmap.Create;
   Bdll48:=TBitmap.Create;
   Bdb48:=TBitmap.Create;
   Bgif48:=TBitmap.Create;
   Bico48:=TBitmap.Create;
   Bvector48:=TBitmap.Create;
   Bjpeg48:=TBitmap.Create;
   BArchiveSupported48:=TBitmap.Create;
   BFileSupported48:=TBitmap.Create;
   BExesupported48:=TBitmap.Create;
   Bunsupported48:=TBitmap.Create;
   Blink48:=TBitmap.Create;
   Bweb48:=TBitmap.Create;
   Bmail48:=TBitmap.Create;
   Bdvd_supported96:=TBitmap.Create;
   Bfd_supported96:=TBitmap.Create;
   BFolder96:=TBitmap.Create;
   Bhd_supported96:=TBitmap.Create;
   Bram_supported96:=TBitmap.Create;
   Bremote_supported96:=TBitmap.Create;
   Bremovable_supported96:=TBitmap.Create;
   Btxt96:=TBitmap.Create;
   Bspreadsheet96:=TBitmap.Create;
   Bvideo96:=TBitmap.Create;
   Baudio96:=TBitmap.Create;
   Bimage96:=TBitmap.Create;
   Bpresentation96:=TBitmap.Create;
   Bpdf96:=TBitmap.Create;
   Bsupported96:=TBitmap.Create;
   Bbat96:=TBitmap.Create;
   Bdll96:=TBitmap.Create;
   Bdb96:=TBitmap.Create;
   Bgif96:=TBitmap.Create;
   Bico96:=TBitmap.Create;
   Bvector96:=TBitmap.Create;
   Bjpeg96:=TBitmap.Create;
   BArchiveSupported96:=TBitmap.Create;
   BFileSupported96:=TBitmap.Create;
   BExesupported96:=TBitmap.Create;
   Bunsupported96:=TBitmap.Create;
   Blink96:=TBitmap.Create;
   Bweb96:=TBitmap.Create;
   Bmail96:=TBitmap.Create;
   Bhomefolder:=TBitmap.Create;
   Bdownloadfolder:=TBitmap.Create;
   Bcloudfolder:=TBitmap.Create;
   Barc7z:=TBitmap.Create;
   Barcrar:=TBitmap.Create;
   Barczip:=TBitmap.Create;
   Barcblock:=TBitmap.Create;
   Barcdisk:=TBitmap.Create;
   Barcinstaller:=TBitmap.Create;
   Barc7z48:=TBitmap.Create;
   Barcrar48:=TBitmap.Create;
   Barczip48:=TBitmap.Create;
   Barcblock48:=TBitmap.Create;
   Barcdisk48:=TBitmap.Create;
   Barcinstaller48:=TBitmap.Create;
   Barc7z96:=TBitmap.Create;
   Barcrar96:=TBitmap.Create;
   Barczip96:=TBitmap.Create;
   Barcblock96:=TBitmap.Create;
   Barcdisk96:=TBitmap.Create;
   Barcinstaller96:=TBitmap.Create;
   getthemepath(thpath);
   Bfm:=TBitmap.Create;
   try Bfm.LoadFromFile(thpath+graphicsfolder+'fm-theme.bmp'); except end;
   Bfm.Transparent:=True;
   ImageTheme.Picture.Bitmap:=Bfm;
   if upcase(theme_name)<>'NOGRAPHIC-EMBEDDED' then
   begin
   il_dtheme_16.getbitmap(0,Bbookmarkadd);
   il_dtheme_16.getbitmap(1,Bapps);
   il_dtheme_16.getbitmap(2,BArchive);
   il_dtheme_16.getbitmap(3,Bclearlayout);
   il_dtheme_16.getbitmap(4,Bconvert);
   il_dtheme_16.getbitmap(5,Bdelete);
   il_dtheme_16.getbitmap(6,Bextractall);
   il_dtheme_16.getbitmap(7,Bextractalln);
   il_dtheme_16.getbitmap(8,Bloadlayout);
   il_dtheme_16.getbitmap(9,Bpreview);
   il_dtheme_16.getbitmap(10,Brun);
   il_dtheme_16.getbitmap(11,Bsavelayout);
   il_dtheme_16.getbitmap(12,Bwipe);
   il_dtheme_16.getbitmap(13,Btestall);
   il_dtheme_16.getbitmap(14,Bdvd_supported);
   il_dtheme_16.getbitmap(15,Bfd_supported);
   il_dtheme_16.getbitmap(16,Bhd_supported);
   il_dtheme_16.getbitmap(17,Bram_supported);
   il_dtheme_16.getbitmap(18,Bremote_supported);
   il_dtheme_16.getbitmap(19,Bremovable_supported);
   il_dtheme_16.getbitmap(20,BArchiveSupported);
   il_dtheme_16.getbitmap(21,Baudio);
   il_dtheme_16.getbitmap(22,Bdll);
   il_dtheme_16.getbitmap(23,Bdb);
   il_dtheme_16.getbitmap(24,BFileSupported);
   il_dtheme_16.getbitmap(25,BExeSupported);
   il_dtheme_16.getbitmap(26,Bimage);
   il_dtheme_16.getbitmap(27,Bico);
   il_dtheme_16.getbitmap(28,Bjpeg);
   il_dtheme_16.getbitmap(29,Bgif);
   il_dtheme_16.getbitmap(30,Bvector);
   il_dtheme_16.getbitmap(31,Blink);
   il_dtheme_16.getbitmap(32,Bmail);
   il_dtheme_16.getbitmap(33,Bpdf);
   il_dtheme_16.getbitmap(34,Bpresentation);
   il_dtheme_16.getbitmap(35,Bbat);
   il_dtheme_16.getbitmap(36,Bspreadsheet);
   il_dtheme_16.getbitmap(37,Bsupported);
   il_dtheme_16.getbitmap(38,Btxt);
   il_dtheme_16.getbitmap(39,BUnsupported);
   il_dtheme_16.getbitmap(40,Bvideo);
   il_dtheme_16.getbitmap(41,Bweb);
   il_dtheme_16.getbitmap(42,BFolder);
   il_dtheme_16.getbitmap(43,Binfo);
   il_dtheme_16.getbitmap(44,Bnav);
   il_dtheme_16.getbitmap(45,Bkeyfile);
   il_dtheme_16.getbitmap(46,Blocker);
   il_dtheme_16.getbitmap(47,Blocker2);
   il_dtheme_16.getbitmap(48,Bback);
   il_dtheme_16.getbitmap(49,Bexpand);
   il_dtheme_16.getbitmap(50,Bgo);
   il_dtheme_16.getbitmap(51,Brefresh);
   il_dtheme_16.getbitmap(52,Bsearch);
   il_dtheme_16.getbitmap(53,Bgopath);
   il_dtheme_16.getbitmap(54,Bresetpath);
   il_dtheme_16.getbitmap(55,Bgoup);
   il_dtheme_16.getbitmap(56,Bp0);
   il_dtheme_16.getbitmap(57,Bbookmark);
   il_dtheme_16.getbitmap(58,Bdesk);
   il_dtheme_16.getbitmap(59,Bplaceshistory);
   il_dtheme_16.getbitmap(60,Broot);
   il_dtheme_16.getbitmap(61,Bsystemtools);
   il_dtheme_16.getbitmap(62,BDefaults);
   il_dtheme_16.getbitmap(63,Bstop);
   il_dtheme_16.getbitmap(64,BTool_cut_small);
   il_dtheme_16.getbitmap(65,BTool_copy_small);
   il_dtheme_16.getbitmap(66,BTool_dup_small);
   il_dtheme_16.getbitmap(67,Btool_properties_small);
   il_dtheme_16.getbitmap(68,Btool_rename_small);
   il_dtheme_16.getbitmap(69,Btool_resize_small);
   il_dtheme_16.getbitmap(70,Btool_crop_small);
   il_dtheme_16.getbitmap(71,BTool_rl_small);
   il_dtheme_16.getbitmap(72,BTool_rr_small);
   il_dtheme_16.getbitmap(73,Bbrowserdetails);
   il_dtheme_16.getbitmap(74,Bbrowserlist);
   il_dtheme_16.getbitmap(75,Bbrowsericons);
   il_dtheme_16.getbitmap(76,Bbrowserdetailslarge);
   il_dtheme_16.getbitmap(77,Bbrowserlistlarge);
   il_dtheme_16.getbitmap(78,Bbrowsericonslarge);
   il_dtheme_16.getbitmap(79,Bhomefolder);
   il_dtheme_16.getbitmap(80,Bdownloadfolder);
   il_dtheme_16.getbitmap(81,Bcloudfolder);
   il_dtheme_16.getbitmap(82,Barc7z);
   il_dtheme_16.getbitmap(83,Barcrar);
   il_dtheme_16.getbitmap(84,Barczip);
   il_dtheme_16.getbitmap(85,Barcblock);
   il_dtheme_16.getbitmap(86,Barcdisk);
   il_dtheme_16.getbitmap(87,Barcinstaller);
   il_dtheme_48.getbitmap(0,Bdvd_supported48);
   il_dtheme_48.getbitmap(1,Bfd_supported48);
   il_dtheme_48.getbitmap(2,Bhd_supported48);
   il_dtheme_48.getbitmap(3,Bram_supported48);
   il_dtheme_48.getbitmap(4,Bremote_supported48);
   il_dtheme_48.getbitmap(5,Bremovable_supported48);
   il_dtheme_48.getbitmap(6,BArchiveSupported48);
   il_dtheme_48.getbitmap(7,Baudio48);
   il_dtheme_48.getbitmap(8,Bdll48);
   il_dtheme_48.getbitmap(9,Bdb48);
   il_dtheme_48.getbitmap(10,BFileSupported48);
   il_dtheme_48.getbitmap(11,BExeSupported48);
   il_dtheme_48.getbitmap(12,Bimage48);
   il_dtheme_48.getbitmap(13,Bico48);
   il_dtheme_48.getbitmap(14,Bjpeg48);
   il_dtheme_48.getbitmap(15,Bgif48);
   il_dtheme_48.getbitmap(16,Bvector48);
   il_dtheme_48.getbitmap(17,Blink48);
   il_dtheme_48.getbitmap(18,Bmail48);
   il_dtheme_48.getbitmap(19,Bpdf48);
   il_dtheme_48.getbitmap(20,Bpresentation48);
   il_dtheme_48.getbitmap(21,Bbat48);
   il_dtheme_48.getbitmap(22,Bspreadsheet48);
   il_dtheme_48.getbitmap(23,Bsupported48);
   il_dtheme_48.getbitmap(24,Btxt48);
   il_dtheme_48.getbitmap(25,BUnsupported48);
   il_dtheme_48.getbitmap(26,Bvideo48);
   il_dtheme_48.getbitmap(27,Bweb48);
   il_dtheme_48.getbitmap(28,BFolder48);
   il_dtheme_48.getbitmap(29,Barc7z48);
   il_dtheme_48.getbitmap(30,Barcrar48);
   il_dtheme_48.getbitmap(31,Barczip48);
   il_dtheme_48.getbitmap(32,Barcblock48);
   il_dtheme_48.getbitmap(33,Barcdisk48);
   il_dtheme_48.getbitmap(34,Barcinstaller48);
   il_dtheme_96.getbitmap(0,Bdvd_supported96);
   il_dtheme_96.getbitmap(1,Bfd_supported96);
   il_dtheme_96.getbitmap(2,Bhd_supported96);
   il_dtheme_96.getbitmap(3,Bram_supported96);
   il_dtheme_96.getbitmap(4,Bremote_supported96);
   il_dtheme_96.getbitmap(5,Bremovable_supported96);
   il_dtheme_96.getbitmap(6,BArchiveSupported96);
   il_dtheme_96.getbitmap(7,Baudio96);
   il_dtheme_96.getbitmap(8,Bdll96);
   il_dtheme_96.getbitmap(9,Bdb96);
   il_dtheme_96.getbitmap(10,BFileSupported96);
   il_dtheme_96.getbitmap(11,BExeSupported96);
   il_dtheme_96.getbitmap(12,Bimage96);
   il_dtheme_96.getbitmap(13,Bico96);
   il_dtheme_96.getbitmap(14,Bjpeg96);
   il_dtheme_96.getbitmap(15,Bgif96);
   il_dtheme_96.getbitmap(16,Bvector96);
   il_dtheme_96.getbitmap(17,Blink96);
   il_dtheme_96.getbitmap(18,Bmail96);
   il_dtheme_96.getbitmap(19,Bpdf96);
   il_dtheme_96.getbitmap(20,Bpresentation96);
   il_dtheme_96.getbitmap(21,Bbat96);
   il_dtheme_96.getbitmap(22,Bspreadsheet96);
   il_dtheme_96.getbitmap(23,Bsupported96);
   il_dtheme_96.getbitmap(24,Btxt96);
   il_dtheme_96.getbitmap(25,BUnsupported96);
   il_dtheme_96.getbitmap(26,Bvideo96);
   il_dtheme_96.getbitmap(27,Bweb96);
   il_dtheme_96.getbitmap(28,BFolder96);
   il_dtheme_96.getbitmap(29,Barc7z96);
   il_dtheme_96.getbitmap(30,Barcrar96);
   il_dtheme_96.getbitmap(31,Barczip96);
   il_dtheme_96.getbitmap(32,Barcblock96);
   il_dtheme_96.getbitmap(33,Barcdisk96);
   il_dtheme_96.getbitmap(34,Barcinstaller96);
   il_dtheme_tool32.getbitmap(0,Bdetailsfs);
   il_dtheme_tool32.getbitmap(1,BArchive_big);
   il_dtheme_tool32.getbitmap(2,Bconvert_big);
   il_dtheme_tool32.getbitmap(3,Bextractall_big);
   il_dtheme_tool32.getbitmap(4,Bextractalln_big);
   il_dtheme_tool32.getbitmap(5,Btestall_big);
   il_dtheme_tool32.getbitmap(6,Btool_cut);
   il_dtheme_tool32.getbitmap(7,Btool_copy);
   il_dtheme_tool32.getbitmap(8,Btool_paste);
   il_dtheme_tool32.getbitmap(9,Btool_openw);
   il_dtheme_tool32.getbitmap(10,Btool_properties);
   il_dtheme_tool32.getbitmap(11,Btool_rename);
   il_dtheme_tool32.getbitmap(12,Btool_delete);
   il_dtheme_tool32.getbitmap(13,Btool_dup);
   il_dtheme_tool32.getbitmap(14,Btool_resize);
   il_dtheme_tool32.getbitmap(15,Btool_crop);
   il_dtheme_tool32.getbitmap(16,BTool_rl);
   il_dtheme_tool32.getbitmap(17,BTool_rr);
   end;
   if upcase(theme_name)='NOGRAPHIC-EMBEDDED' then
   begin
   il_nonthemed.getbitmap(6,Bbookmarkadd);
   il_nonthemed.getbitmap(6,Bapps);
   il_nonthemed.getbitmap(6,BArchive);
   il_nonthemed.getbitmap(6,Bclearlayout);
   il_nonthemed.getbitmap(6,Bconvert);
   il_nonthemed.getbitmap(6,Bdelete);
   il_nonthemed.getbitmap(6,Bextractall);
   il_nonthemed.getbitmap(6,Bextractalln);
   il_nonthemed.getbitmap(6,Bloadlayout);
   il_nonthemed.getbitmap(6,Bpreview);
   il_nonthemed.getbitmap(6,Brun);
   il_nonthemed.getbitmap(6,Bsavelayout);
   il_nonthemed.getbitmap(6,Bwipe);
   il_nonthemed.getbitmap(6,Btestall);
   il_nonthemed.getbitmap(6,Bdvd_supported);
   il_nonthemed.getbitmap(6,Bfd_supported);
   il_nonthemed.getbitmap(6,Bhd_supported);
   il_nonthemed.getbitmap(6,Bram_supported);
   il_nonthemed.getbitmap(6,Bremote_supported);
   il_nonthemed.getbitmap(6,Bremovable_supported);
   il_nonthemed.getbitmap(6,BArchiveSupported);
   il_nonthemed.getbitmap(6,Baudio);
   il_nonthemed.getbitmap(6,Bdll);
   il_nonthemed.getbitmap(6,Bdb);
   il_nonthemed.getbitmap(6,BFileSupported);
   il_nonthemed.getbitmap(6,BExeSupported);
   il_nonthemed.getbitmap(6,Bimage);
   il_nonthemed.getbitmap(6,Bico);
   il_nonthemed.getbitmap(6,Bjpeg);
   il_nonthemed.getbitmap(6,Bgif);
   il_nonthemed.getbitmap(6,Bvector);
   il_nonthemed.getbitmap(6,Blink);
   il_nonthemed.getbitmap(6,Bmail);
   il_nonthemed.getbitmap(6,Bpdf);
   il_nonthemed.getbitmap(6,Bpresentation);
   il_nonthemed.getbitmap(6,Bbat);
   il_nonthemed.getbitmap(6,Bspreadsheet);
   il_nonthemed.getbitmap(6,Bsupported);
   il_nonthemed.getbitmap(6,Btxt);
   il_nonthemed.getbitmap(6,BUnsupported);
   il_nonthemed.getbitmap(6,Bvideo);
   il_nonthemed.getbitmap(6,Bweb);
   il_nonthemed.getbitmap(6,BFolder);
   il_nonthemed.getbitmap(6,Binfo);
   il_nonthemed.getbitmap(6,Bnav);
   il_nonthemed.getbitmap(6,Bkeyfile);
   il_nonthemed.getbitmap(6,Blocker);
   il_nonthemed.getbitmap(6,Blocker2);
   il_nonthemed.getbitmap(6,Bback);
   il_nonthemed.getbitmap(6,Bexpand);
   il_nonthemed.getbitmap(6,Bgo);
   il_nonthemed.getbitmap(6,Brefresh);
   il_nonthemed.getbitmap(6,Bsearch);
   il_nonthemed.getbitmap(6,Bgopath);
   il_nonthemed.getbitmap(6,Bresetpath);
   il_nonthemed.getbitmap(6,Bgoup);
   il_nonthemed.getbitmap(6,Bp0);
   il_nonthemed.getbitmap(6,Bbookmark);
   il_nonthemed.getbitmap(6,Bdesk);
   il_nonthemed.getbitmap(6,Bplaceshistory);
   il_nonthemed.getbitmap(6,Broot);
   il_nonthemed.getbitmap(6,Bsystemtools);
   il_nonthemed.getbitmap(6,BDefaults);
   il_nonthemed.getbitmap(6,Bstop);
   il_nonthemed.getbitmap(6,BTool_cut_small);
   il_nonthemed.getbitmap(6,BTool_copy_small);
   il_nonthemed.getbitmap(6,BTool_dup_small);
   il_nonthemed.getbitmap(6,Btool_properties_small);
   il_nonthemed.getbitmap(6,Btool_rename_small);
   il_nonthemed.getbitmap(6,Btool_resize_small);
   il_nonthemed.getbitmap(6,Btool_crop_small);
   il_nonthemed.getbitmap(6,BTool_rl_small);
   il_nonthemed.getbitmap(6,BTool_rr_small);
   il_nonthemed.getbitmap(6,Bbrowserdetails);
   il_nonthemed.getbitmap(6,Bbrowserlist);
   il_nonthemed.getbitmap(6,Bbrowsericons);
   il_nonthemed.getbitmap(6,Bbrowserdetailslarge);
   il_nonthemed.getbitmap(6,Bbrowserlistlarge);
   il_nonthemed.getbitmap(6,Bbrowsericonslarge);
   il_nonthemed.getbitmap(6,Bhomefolder);
   il_nonthemed.getbitmap(6,Bdownloadfolder);
   il_nonthemed.getbitmap(6,Bcloudfolder);
   il_nonthemed.getbitmap(6,Barc7z);
   il_nonthemed.getbitmap(6,Barcrar);
   il_nonthemed.getbitmap(6,Barczip);
   il_nonthemed.getbitmap(6,Barcblock);
   il_nonthemed.getbitmap(6,Barcdisk);
   il_nonthemed.getbitmap(6,Barcinstaller);
   il_nonthemed.getbitmap(6,Bdvd_supported48);
   il_nonthemed.getbitmap(6,Bfd_supported48);
   il_nonthemed.getbitmap(6,Bhd_supported48);
   il_nonthemed.getbitmap(6,Bram_supported48);
   il_nonthemed.getbitmap(6,Bremote_supported48);
   il_nonthemed.getbitmap(6,Bremovable_supported48);
   il_nonthemed.getbitmap(6,BArchiveSupported48);
   il_nonthemed.getbitmap(6,Baudio48);
   il_nonthemed.getbitmap(6,Bdll48);
   il_nonthemed.getbitmap(6,Bdb48);
   il_nonthemed.getbitmap(6,BFileSupported48);
   il_nonthemed.getbitmap(6,BExeSupported48);
   il_nonthemed.getbitmap(6,Bimage48);
   il_nonthemed.getbitmap(6,Bico48);
   il_nonthemed.getbitmap(6,Bjpeg48);
   il_nonthemed.getbitmap(6,Bgif48);
   il_nonthemed.getbitmap(6,Bvector48);
   il_nonthemed.getbitmap(6,Blink48);
   il_nonthemed.getbitmap(6,Bmail48);
   il_nonthemed.getbitmap(6,Bpdf48);
   il_nonthemed.getbitmap(6,Bpresentation48);
   il_nonthemed.getbitmap(6,Bbat48);
   il_nonthemed.getbitmap(6,Bspreadsheet48);
   il_nonthemed.getbitmap(6,Bsupported48);
   il_nonthemed.getbitmap(6,Btxt48);
   il_nonthemed.getbitmap(6,BUnsupported48);
   il_nonthemed.getbitmap(6,Bvideo48);
   il_nonthemed.getbitmap(6,Bweb48);
   il_nonthemed.getbitmap(6,BFolder48);
   il_nonthemed.getbitmap(6,Barc7z48);
   il_nonthemed.getbitmap(6,Barcrar48);
   il_nonthemed.getbitmap(6,Barczip48);
   il_nonthemed.getbitmap(6,Barcblock48);
   il_nonthemed.getbitmap(6,Barcdisk48);
   il_nonthemed.getbitmap(6,Barcinstaller48);
   il_nonthemed.getbitmap(6,Bdvd_supported96);
   il_nonthemed.getbitmap(6,Bfd_supported96);
   il_nonthemed.getbitmap(6,Bhd_supported96);
   il_nonthemed.getbitmap(6,Bram_supported96);
   il_nonthemed.getbitmap(6,Bremote_supported96);
   il_nonthemed.getbitmap(6,Bremovable_supported96);
   il_nonthemed.getbitmap(6,BArchiveSupported96);
   il_nonthemed.getbitmap(6,Baudio96);
   il_nonthemed.getbitmap(6,Bdll96);
   il_nonthemed.getbitmap(6,Bdb96);
   il_nonthemed.getbitmap(6,BFileSupported96);
   il_nonthemed.getbitmap(6,BExeSupported96);
   il_nonthemed.getbitmap(6,Bimage96);
   il_nonthemed.getbitmap(6,Bico96);
   il_nonthemed.getbitmap(6,Bjpeg96);
   il_nonthemed.getbitmap(6,Bgif96);
   il_nonthemed.getbitmap(6,Bvector96);
   il_nonthemed.getbitmap(6,Blink96);
   il_nonthemed.getbitmap(6,Bmail96);
   il_nonthemed.getbitmap(6,Bpdf96);
   il_nonthemed.getbitmap(6,Bpresentation96);
   il_nonthemed.getbitmap(6,Bbat96);
   il_nonthemed.getbitmap(6,Bspreadsheet96);
   il_nonthemed.getbitmap(6,Bsupported96);
   il_nonthemed.getbitmap(6,Btxt96);
   il_nonthemed.getbitmap(6,BUnsupported96);
   il_nonthemed.getbitmap(6,Bvideo96);
   il_nonthemed.getbitmap(6,Bweb96);
   il_nonthemed.getbitmap(6,BFolder96);
   il_nonthemed.getbitmap(6,Barc7z96);
   il_nonthemed.getbitmap(6,Barcrar96);
   il_nonthemed.getbitmap(6,Barczip96);
   il_nonthemed.getbitmap(6,Barcblock96);
   il_nonthemed.getbitmap(6,Barcdisk96);
   il_nonthemed.getbitmap(6,Barcinstaller96);
   il_nonthemed.getbitmap(6,Bdetailsfs);
   il_nonthemed.getbitmap(6,BArchive_big);
   il_nonthemed.getbitmap(6,Bconvert_big);
   il_nonthemed.getbitmap(6,Bextractall_big);
   il_nonthemed.getbitmap(6,Bextractalln_big);
   il_nonthemed.getbitmap(6,Btestall_big);
   il_nonthemed.getbitmap(6,Btool_cut);
   il_nonthemed.getbitmap(6,Btool_copy);
   il_nonthemed.getbitmap(6,Btool_paste);
   il_nonthemed.getbitmap(6,Btool_openw);
   il_nonthemed.getbitmap(6,Btool_properties);
   il_nonthemed.getbitmap(6,Btool_rename);
   il_nonthemed.getbitmap(6,Btool_delete);
   il_nonthemed.getbitmap(6,Btool_dup);
   il_nonthemed.getbitmap(6,Btool_resize);
   il_nonthemed.getbitmap(6,Btool_crop);
   il_nonthemed.getbitmap(6,BTool_rl);
   il_nonthemed.getbitmap(6,BTool_rr);
   end;
   if (upcase(theme_name)<>'NOGRAPHIC-EMBEDDED') and (upcase(theme_name)<>'MAIN-EMBEDDED') then
   begin
   getthemedbitmap(Bhomefolder,thpath+graphicsfolder+'16'+directoryseparator+'16-home.png');
   getthemedbitmap(Bdownloadfolder,thpath+graphicsfolder+'16'+directoryseparator+'16-downloads.png');
   getthemedbitmap(Bcloudfolder,thpath+graphicsfolder+'16'+directoryseparator+'16-cloud.png');
   getthemedbitmap(Bbookmarkadd,thpath+graphicsfolder+'16'+directoryseparator+'16-bookmarks-add.png');
   getthemedbitmap(Bapps,thpath+graphicsfolder+'16'+directoryseparator+'16-run-with.png');
   getthemedbitmap(BArchive,thpath+graphicsfolder+'16'+directoryseparator+'16-archive-add.png');
   getthemedbitmap(Bclearlayout,thpath+graphicsfolder+'16'+directoryseparator+'16-delete-clear.png');
   getthemedbitmap(Bconvert,thpath+graphicsfolder+'16'+directoryseparator+'16-archive-convert.png');
   getthemedbitmap(Bdelete,thpath+graphicsfolder+'16'+directoryseparator+'16-delete.png');
   getthemedbitmap(Bextractall,thpath+graphicsfolder+'16'+directoryseparator+'16-archive-extract.png');
   getthemedbitmap(Bextractalln,thpath+graphicsfolder+'16'+directoryseparator+'16-archive-extract-tonew.png');
   getthemedbitmap(Bloadlayout,thpath+graphicsfolder+'16'+directoryseparator+'16-paste.png');
   getthemedbitmap(Bpreview,thpath+graphicsfolder+'16'+directoryseparator+'16-run-preview.png');
   getthemedbitmap(Brun,thpath+graphicsfolder+'16'+directoryseparator+'16-run.png');
   getthemedbitmap(Bsavelayout,thpath+graphicsfolder+'16'+directoryseparator+'16-save.png');
   getthemedbitmap(Bwipe,thpath+graphicsfolder+'16'+directoryseparator+'16-delete-secure.png');
   getthemedbitmap(Btestall,thpath+graphicsfolder+'16'+directoryseparator+'16-test.png');
   getthemedbitmap(BFolder,thpath+graphicsfolder+'16'+directoryseparator+'16-folder.png');
   getthemedbitmap(Binfo,thpath+graphicsfolder+'16'+directoryseparator+'16-info.png');
   getthemedbitmap(Bnav,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation.png');
   getthemedbitmap(Bkeyfile,thpath+graphicsfolder+'16'+directoryseparator+'16-keyfile.png');
   getthemedbitmap(Blocker,thpath+graphicsfolder+'16'+directoryseparator+'16-password-set.png');
   getthemedbitmap(Blocker2,thpath+graphicsfolder+'16'+directoryseparator+'16-password-notset.png');
   getthemedbitmap(Bback,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-back.png');
   getthemedbitmap(Bexpand,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-flat.png');
   getthemedbitmap(Bgo,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-forward.png');
   getthemedbitmap(Brefresh,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-refresh.png');
   getthemedbitmap(Bsearch,thpath+graphicsfolder+'16'+directoryseparator+'16-search.png');
   getthemedbitmap(Bgopath,thpath+graphicsfolder+'16'+directoryseparator+'16-search-here.png');
   getthemedbitmap(Bresetpath,thpath+graphicsfolder+'16'+directoryseparator+'16-undo.png');
   getthemedbitmap(Bgoup,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-up.png');
   getthemedbitmap(Bp0,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-refreshing.png');
   getthemedbitmap(Bbookmark,thpath+graphicsfolder+'16'+directoryseparator+'16-bookmarks.png');
   getthemedbitmap(Bdesk,thpath+graphicsfolder+'16'+directoryseparator+'16-desktop.png');
   getthemedbitmap(Bplaceshistory,thpath+graphicsfolder+'16'+directoryseparator+'16-history.png');
   getthemedbitmap(Broot,thpath+graphicsfolder+'16'+directoryseparator+'16-folder-special.png');
   getthemedbitmap(Bsystemtools,thpath+graphicsfolder+'16'+directoryseparator+'16-computer.png');
   getthemedbitmap(BDefaults,thpath+graphicsfolder+'16'+directoryseparator+'16-options.png');
   getthemedbitmap(Bstop,thpath+graphicsfolder+'16'+directoryseparator+'16-stop.png');
   getthemedbitmap(BTool_cut_small,thpath+graphicsfolder+'16'+directoryseparator+'16-cut.png');
   getthemedbitmap(BTool_copy_small,thpath+graphicsfolder+'16'+directoryseparator+'16-copy.png');
   getthemedbitmap(BTool_dup_small,thpath+graphicsfolder+'16'+directoryseparator+'16-find-duplicates.png');
   getthemedbitmap(Btool_properties_small,thpath+graphicsfolder+'16'+directoryseparator+'16-properties.png');
   getthemedbitmap(Btool_rename_small,thpath+graphicsfolder+'16'+directoryseparator+'16-rename.png');
   getthemedbitmap(Btool_resize_small,thpath+graphicsfolder+'16'+directoryseparator+'16-picture-modify.png');
   getthemedbitmap(Btool_crop_small,thpath+graphicsfolder+'16'+directoryseparator+'16-picture-crop.png');
   getthemedbitmap(BTool_rl_small,thpath+graphicsfolder+'16'+directoryseparator+'16-picture-rl.png');
   getthemedbitmap(BTool_rr_small,thpath+graphicsfolder+'16'+directoryseparator+'16-picture-rr.png');
   getthemedbitmap(Bdll,thpath+graphicsfolder+'16'+directoryseparator+'16-file-library.png');
   getthemedbitmap(BExeSupported,thpath+graphicsfolder+'16'+directoryseparator+'16-file-executable.png');
   getthemedbitmap(Bbat,thpath+graphicsfolder+'16'+directoryseparator+'16-file-script.png');
   getthemedbitmap(Bdetailsfs,thpath+graphicsfolder+'32'+directoryseparator+'32-folder.png');
   getthemedbitmap(BArchive_big,thpath+graphicsfolder+'32'+directoryseparator+'32-archive-add.png');
   getthemedbitmap(Bconvert_big,thpath+graphicsfolder+'32'+directoryseparator+'32-archive-convert.png');
   getthemedbitmap(Bextractall_big,thpath+graphicsfolder+'32'+directoryseparator+'32-archive-extract.png');
   getthemedbitmap(Bextractalln_big,thpath+graphicsfolder+'32'+directoryseparator+'32-archive-extract-tonew.png');
   getthemedbitmap(Btestall_big,thpath+graphicsfolder+'32'+directoryseparator+'32-test.png');
   getthemedbitmap(Btool_cut,thpath+graphicsfolder+'32'+directoryseparator+'32-cut.png');
   getthemedbitmap(Btool_copy,thpath+graphicsfolder+'32'+directoryseparator+'32-copy.png');
   getthemedbitmap(Btool_paste,thpath+graphicsfolder+'32'+directoryseparator+'32-paste.png');
   getthemedbitmap(Btool_openw,thpath+graphicsfolder+'32'+directoryseparator+'32-run-with.png');
   getthemedbitmap(Btool_properties,thpath+graphicsfolder+'32'+directoryseparator+'32-properties.png');
   getthemedbitmap(Btool_rename,thpath+graphicsfolder+'32'+directoryseparator+'32-rename.png');
   getthemedbitmap(Btool_delete,thpath+graphicsfolder+'32'+directoryseparator+'32-delete-secure.png');
   getthemedbitmap(Btool_dup,thpath+graphicsfolder+'32'+directoryseparator+'32-find-duplicates.png');
   getthemedbitmap(Btool_resize,thpath+graphicsfolder+'32'+directoryseparator+'32-picture-modify.png');
   getthemedbitmap(Btool_crop,thpath+graphicsfolder+'32'+directoryseparator+'32-picture-crop.png');
   getthemedbitmap(BTool_rl,thpath+graphicsfolder+'32'+directoryseparator+'32-picture-rl.png');
   getthemedbitmap(BTool_rr,thpath+graphicsfolder+'32'+directoryseparator+'32-picture-rr.png');
   getthemedbitmap(BFolder48,thpath+graphicsfolder+'48'+directoryseparator+'48-folder.png');
   getthemedbitmap(Bdll48,thpath+graphicsfolder+'48'+directoryseparator+'48-file-library.png');
   getthemedbitmap(BExeSupported48,thpath+graphicsfolder+'48'+directoryseparator+'48-file-executable.png');
   getthemedbitmap(Bbat48,thpath+graphicsfolder+'48'+directoryseparator+'48-file-script.png');
   getthemedbitmap(BFolder96,thpath+graphicsfolder+'96'+directoryseparator+'96-folder.png');
   getthemedbitmap(Bdll96,thpath+graphicsfolder+'96'+directoryseparator+'96-file-library.png');
   getthemedbitmap(BExeSupported96,thpath+graphicsfolder+'96'+directoryseparator+'96-file-executable.png');
   getthemedbitmap(Bbat96,thpath+graphicsfolder+'96'+directoryseparator+'96-file-script.png');
   end;

   setpbitmap(Bbookmarkadd,i16res);
   setpbitmap(Bapps,i16res);
   setpbitmap(BArchive,i16res);
   setpbitmap(Bclearlayout,i16res);
   setpbitmap(Bconvert,i16res);
   setpbitmap(Bdelete,i16res);
   setpbitmap(Bextractall,i16res);
   setpbitmap(Bextractalln,i16res);
   setpbitmap(Bloadlayout,i16res);
   setpbitmap(Bpreview,i16res);
   setpbitmap(Brun,i16res);
   setpbitmap(Bsavelayout,i16res);
   setpbitmap(Bwipe,i16res);
   setpbitmap(Btestall,i16res);
   setpbitmap(Bdvd_supported,i16res);
   setpbitmap(Bfd_supported,i16res);
   setpbitmap(Bhd_supported,i16res);
   setpbitmap(Bram_supported,i16res);
   setpbitmap(Bremote_supported,i16res);
   setpbitmap(Bremovable_supported,i16res);
   setpbitmap(BArchiveSupported,i16res);
   setpbitmap(Baudio,i16res);
   setpbitmap(Bdll,i16res);
   setpbitmap(Bdb,i16res);
   setpbitmap(BFileSupported,i16res);
   setpbitmap(BExeSupported,i16res);
   setpbitmap(Bimage,i16res);
   setpbitmap(Bico,i16res);
   setpbitmap(Bjpeg,i16res);
   setpbitmap(Bgif,i16res);
   setpbitmap(Bvector,i16res);
   setpbitmap(Blink,i16res);
   setpbitmap(Bmail,i16res);
   setpbitmap(Bpdf,i16res);
   setpbitmap(Bpresentation,i16res);
   setpbitmap(Bbat,i16res);
   setpbitmap(Bspreadsheet,i16res);
   setpbitmap(Bsupported,i16res);
   setpbitmap(Btxt,i16res);
   setpbitmap(BUnsupported,i16res);
   setpbitmap(Bvideo,i16res);
   setpbitmap(Bweb,i16res);
   setpbitmap(BFolder,i16res);
   setpbitmap(Binfo,i16res);
   setpbitmap(Bnav,i16res);
   setpbitmap(Bkeyfile,i16res);
   setpbitmap(Blocker,i16res);
   setpbitmap(Blocker2,i16res);
   setpbitmap(Bback,i16res);
   setpbitmap(Bexpand,i16res);
   setpbitmap(Bgo,i16res);
   setpbitmap(Brefresh,i16res);
   setpbitmap(Bsearch,i16res);
   setpbitmap(Bgopath,i16res);
   setpbitmap(Bresetpath,i16res);
   setpbitmap(Bgoup,i16res);
   setpbitmap(Bp0,i16res);
   setpbitmap(Bbookmark,i16res);
   setpbitmap(Bdesk,i16res);
   setpbitmap(Bplaceshistory,i16res);
   setpbitmap(Broot,i16res);
   setpbitmap(Bsystemtools,i16res);
   setpbitmap(BDefaults,i16res);
   setpbitmap(Bstop,i16res);
   setpbitmap(BTool_cut_small,i16res);
   setpbitmap(BTool_copy_small,i16res);
   setpbitmap(BTool_dup_small,i16res);
   setpbitmap(Btool_properties_small,i16res);
   setpbitmap(Btool_rename_small,i16res);
   setpbitmap(Btool_resize_small,i16res);
   setpbitmap(Btool_crop_small,i16res);
   setpbitmap(BTool_rl_small,i16res);
   setpbitmap(BTool_rr_small,i16res);
   setpbitmap(Bbrowserdetails,i16res);
   setpbitmap(Bbrowserlist,i16res);
   setpbitmap(Bbrowsericons,i16res);
   setpbitmap(Bbrowserdetailslarge,i16res);
   setpbitmap(Bbrowserlistlarge,i16res);
   setpbitmap(Bbrowsericonslarge,i16res);
   setpbitmap(Bhomefolder,i16res);
   setpbitmap(Bdownloadfolder,i16res);
   setpbitmap(Bcloudfolder,i16res);
   setpbitmap(Barc7z,i16res);
   setpbitmap(Barcrar,i16res);
   setpbitmap(Barczip,i16res);
   setpbitmap(Barcblock,i16res);
   setpbitmap(Barcdisk,i16res);
   setpbitmap(Barcinstaller,i16res);
   setpbitmap(Bdvd_supported48,i48res);
   setpbitmap(Bfd_supported48,i48res);
   setpbitmap(Bhd_supported48,i48res);
   setpbitmap(Bram_supported48,i48res);
   setpbitmap(Bremote_supported48,i48res);
   setpbitmap(Bremovable_supported48,i48res);
   setpbitmap(BArchiveSupported48,i48res);
   setpbitmap(Baudio48,i48res);
   setpbitmap(Bdll48,i48res);
   setpbitmap(Bdb48,i48res);
   setpbitmap(BFileSupported48,i48res);
   setpbitmap(BExeSupported48,i48res);
   setpbitmap(Bimage48,i48res);
   setpbitmap(Bico48,i48res);
   setpbitmap(Bjpeg48,i48res);
   setpbitmap(Bgif48,i48res);
   setpbitmap(Bvector48,i48res);
   setpbitmap(Blink48,i48res);
   setpbitmap(Bmail48,i48res);
   setpbitmap(Bpdf48,i48res);
   setpbitmap(Bpresentation48,i48res);
   setpbitmap(Bbat48,i48res);
   setpbitmap(Bspreadsheet48,i48res);
   setpbitmap(Bsupported48,i48res);
   setpbitmap(Btxt48,i48res);
   setpbitmap(BUnsupported48,i48res);
   setpbitmap(Bvideo48,i48res);
   setpbitmap(Bweb48,i48res);
   setpbitmap(BFolder48,i48res);
   setpbitmap(Barc7z48,i48res);
   setpbitmap(Barcrar48,i48res);
   setpbitmap(Barczip48,i48res);
   setpbitmap(Barcblock48,i48res);
   setpbitmap(Barcdisk48,i48res);
   setpbitmap(Barcinstaller48,i48res);
   setpbitmap(Bdvd_supported96,i96res);
   setpbitmap(Bfd_supported96,i96res);
   setpbitmap(Bhd_supported96,i96res);
   setpbitmap(Bram_supported96,i96res);
   setpbitmap(Bremote_supported96,i96res);
   setpbitmap(Bremovable_supported96,i96res);
   setpbitmap(BArchiveSupported96,i96res);
   setpbitmap(Baudio96,i96res);
   setpbitmap(Bdll96,i96res);
   setpbitmap(Bdb96,i96res);
   setpbitmap(BFileSupported96,i96res);
   setpbitmap(BExeSupported96,i96res);
   setpbitmap(Bimage96,i96res);
   setpbitmap(Bico96,i96res);
   setpbitmap(Bjpeg96,i96res);
   setpbitmap(Bgif96,i96res);
   setpbitmap(Bvector96,i96res);
   setpbitmap(Blink96,i96res);
   setpbitmap(Bmail96,i96res);
   setpbitmap(Bpdf96,i96res);
   setpbitmap(Bpresentation96,i96res);
   setpbitmap(Bbat96,i96res);
   setpbitmap(Bspreadsheet96,i96res);
   setpbitmap(Bsupported96,i96res);
   setpbitmap(Btxt96,i96res);
   setpbitmap(BUnsupported96,i96res);
   setpbitmap(Bvideo96,i96res);
   setpbitmap(Bweb96,i96res);
   setpbitmap(BFolder96,i96res);
   setpbitmap(Barc7z96,i96res);
   setpbitmap(Barcrar96,i96res);
   setpbitmap(Barczip96,i96res);
   setpbitmap(Barcblock96,i96res);
   setpbitmap(Barcdisk96,i96res);
   setpbitmap(Barcinstaller96,i96res);
   setpbitmap(Bdetailsfs,i32res);
   setpbitmap(BArchive_big,i32res);
   setpbitmap(Bconvert_big,i32res);
   setpbitmap(Bextractall_big,i32res);
   setpbitmap(Bextractalln_big,i32res);
   setpbitmap(Btestall_big,i32res);
   setpbitmap(Btool_cut,i32res);
   setpbitmap(Btool_copy,i32res);
   setpbitmap(Btool_paste,i32res);
   setpbitmap(Btool_openw,i32res);
   setpbitmap(Btool_properties,i32res);
   setpbitmap(Btool_rename,i32res);
   setpbitmap(Btool_delete,i32res);
   setpbitmap(Btool_dup,i32res);
   setpbitmap(Btool_resize,i32res);
   setpbitmap(Btool_crop,i32res);
   setpbitmap(BTool_rl,i32res);
   setpbitmap(BTool_rr,i32res);

   for i:=1 to 26 do devicon[i]:=Bunsupported;//show "unsupported" icon if the bookmarked unit is not mounted
   mprelight.Bitmap:=Bbrowserdetails;
   mpredetails.Bitmap:=Bbrowserdetailslarge;
   mprelightlist.Bitmap:=Bbrowserlist;
   mprelist.Bitmap:=Bbrowserlistlarge;
   mpreaverage.Bitmap:=Bbrowsericons;
   mprelarge.Bitmap:=Bbrowsericonslarge;
   pmstyle1.Bitmap:=Bbrowserdetails;
   pmstyle2.Bitmap:=Bbrowserdetailslarge;
   pmstyle3.Bitmap:=Bbrowserlist;
   pmstyle4.Bitmap:=Bbrowserlistlarge;
   pmstyle5.Bitmap:=Bbrowsericons;
   pmstyle6.Bitmap:=Bbrowsericonslarge;
   mlang.Bitmap:=Binfo;
   mDefaults.Bitmap:=BDefaults;
   msettings.Bitmap:=BDefaults;
   pmthemes.Bitmap:=BDefaults;
   ImageAddress.Width:=i16res;
   ImageAddress.Height:=i16res;
   ImageAddress.Picture.Bitmap:=Bsystemtools;
   ImOpt1.Width:=i16res;
   ImOpt1.Height:=i16res;
   ImOpt1.Transparent:=true;
   ImOpt1.Picture.Bitmap:=BDefaults;
   ImOpt2.Width:=i16res;
   ImOpt2.Height:=i16res;
   ImOpt2.Transparent:=true;
   ImOpt2.Picture.Bitmap:=Bexpand;
   ImOpt3.Width:=i16res;
   ImOpt3.Height:=i16res;
   ImOpt3.Transparent:=true;
   ImOpt3.Picture.Bitmap:=BArchiveSupported;
   ImOpt4.Width:=i16res;
   ImOpt4.Height:=i16res;
   ImOpt4.Transparent:=true;
   ImOpt4.Picture.Bitmap:=BFolder;
   ImOpt5.Width:=i16res;
   ImOpt5.Height:=i16res;
   ImOpt5.Transparent:=true;
   ImOpt5.Picture.Bitmap:=Bapps;
   ImOpt6.Width:=i16res;
   ImOpt6.Height:=i16res;
   ImOpt6.Transparent:=true;
   ImOpt6.Picture.Bitmap:=Bimage;
   ImOpt7.Width:=i16res;
   ImOpt7.Height:=i16res;
   ImOpt7.Transparent:=true;
   ImOpt7.Picture.Bitmap:=Bsearch;
   ImOpt8.Width:=i16res;
   ImOpt8.Height:=i16res;
   ImOpt8.Transparent:=true;
   ImOpt8.Picture.Bitmap:=Binfo;
   MenuItemOpen_root.Bitmap:=Bsystemtools;
   po_systemtools.Bitmap:=Bsystemtools;
   po_linsystemtools.Bitmap:=Bsystemtools;
   po_filetools.Bitmap:=Bunsupported;
   //pmcbroot.Bitmap:=Bsystemtools;
   MenuItemopendesktop.Bitmap:=Bdesk;
   MenuItemopendownloads.Bitmap:=Bdownloadfolder;
   MenuItemopendocuments.Bitmap:=BFileSupported;
   ButtonArchive.Glyph:=Btestall;
   ButtonExtOk.Glyph:=Btestall;
   Button2.Glyph:=Btestall;
   ButtonArchive1.Glyph:=Bstop;
   ButtonExtCancel.Glyph:=Bstop;
   Button1.Glyph:=Bstop;
   po_convertarchive.Bitmap:=Bconvert;
   ctrlback.Glyph:=Bback;
   ctrlfwd.Glyph:=Bgo;
   ctrlup.Glyph:=Bgoup;
   ctrlhistory.Glyph:=Bplaceshistory;
   refreshstatus:=0;
   ImageListSearch.Picture.Bitmap:=Bsearch;
   ImageListSearch1.Picture.Bitmap:=Bdelete;
   pmireset.Bitmap:=Bdelete;
   msetpw.Bitmap:=Blocker2;
   mpm.Bitmap:=Bsavelayout;
   mscripts.Bitmap:=bbat;
   ImagePassword.Glyph:=Blocker2;
   ImagePassword1.Glyph:=Blocker2;
   ImagePassword2.Glyph:=Blocker2;
   mkeyfile.Bitmap:=Bkeyfile;
   mverifyself.Bitmap:=BExesupported;
   iConsoleCreateImport.Width:=i16res;
   iConsoleCreateImport.Height:=i16res;
   iConsoleCreateImport.Picture.Bitmap:=Bresetpath;
   iConsoleCreateImport1.Width:=i16res;
   iConsoleCreateImport1.Height:=i16res;
   iConsoleCreateImport1.Picture.Bitmap:=Bresetpath;
   iadvextract.Width:=i16res;
   iadvextract.Height:=i16res;
   iadvextract.Picture.Bitmap:=Binfo;
   iadvextract.Transparent:=true;
   ImageInfoArchive3.Width:=i16res;
   ImageInfoArchive3.Height:=i16res;
   ImageInfoArchive3.Picture.Bitmap:=Binfo;
   ImageInfoArchive3.Transparent:=true;
   ImageInfoArchive4.Width:=i16res;
   ImageInfoArchive4.Height:=i16res;
   ImageInfoArchive4.Picture.Bitmap:=Binfo;
   ImageInfoArchive4.Transparent:=true;
   ImageInfoArchive5.Width:=i16res;
   ImageInfoArchive5.Height:=i16res;
   ImageInfoArchive5.Picture.Bitmap:=Binfo;
   ImageInfoArchive5.Transparent:=true;
   ImageInfoArchive6.Width:=i16res;
   ImageInfoArchive6.Height:=i16res;
   ImageInfoArchive6.Picture.Bitmap:=Binfo;
   ImageInfoArchive6.Transparent:=true;
   ImageInfoDefault1.Width:=i16res;
   ImageInfoDefault1.Height:=i16res;
   ImageInfoDefault1.Picture.Bitmap:=Binfo;
   ImageInfoDefault1.Transparent:=true;
   ImageInfoDefault2.Width:=i16res;
   ImageInfoDefault2.Height:=i16res;
   ImageInfoDefault2.Picture.Bitmap:=Binfo;
   ImageInfoDefault2.Transparent:=true;
   ImageSplit.Width:=i16res;
   ImageSplit.Height:=i16res;
   ImageSplit.Transparent:=true;
   mBookmarks.Bitmap:=BBookmark;
   smBookmarks1.Bitmap:=BBookmark;
   smBookmarksa1.Bitmap:=BBookmark;
   MenuItemOpen_pc.Bitmap:=Bsystemtools;
   MenuItemArchive_pc.Bitmap:=Bsystemtools;
   smfs1.Bitmap:=Broot;
   smfsa1.Bitmap:=Broot;
   pmJumppubhome.Bitmap:=bfolder;
   MenuItemArchive_pubhome.Bitmap:=bfolder;
   MenuItemOpen_pubhome.Bitmap:=bfolder;
   MenuItemArchive_home1.Bitmap:=bhomefolder;
   MenuItemArchive_documents1.Bitmap:=bfilesupported;
   MenuItemArchive_downloads.Bitmap:=Bdownloadfolder;
   MenuItemArchive_music.Bitmap:=baudio;
   MenuItemArchive_pictures.Bitmap:=bimage;
   MenuItemArchive_videos.Bitmap:=bvideo;
   MenuItemArchive_pubdoc.Bitmap:=bfolder;
   MenuItemOpenhome.Bitmap:=Bhomefolder;
   MenuItemOpen_home1.Bitmap:=bhomefolder;
   pmquickhome.Bitmap:=Bhomefolder;
   pmquickdesk.Bitmap:=Bdesk;
   pmquickdownloads.Bitmap:=Bdownloadfolder;
   MenuItemOpen_documents1.Bitmap:=bfilesupported;
   MenuItemOpen_downloads1.Bitmap:=Bdownloadfolder;
   MenuItemOpen_music.Bitmap:=baudio;
   MenuItemOpen_pictures.Bitmap:=bimage;
   MenuItemOpen_videos.Bitmap:=bvideo;
   MenuItemOpen_pubdoc.Bitmap:=bfolder;
   pmjump3.Bitmap:=Bhomefolder;
   pmjumpdocuments.Bitmap:=BFileSupported;
   pmjumppubdoc.Bitmap:=bfolder;
   pmjumprecent.Bitmap:=bfolder;
   pmjumpsearches.Bitmap:=bfolder;
   pmjumplibraries.Bitmap:=bfolder;
   pmjumpdownloads.Bitmap:=Bdownloadfolder;
   pmjumpmusic.Bitmap:=baudio;
   pmjumppictures.Bitmap:=bimage;
   pmjumpvideos.Bitmap:=bvideo;
   pmrecycle.Bitmap:=Bclearlayout;
   po_recycle.Bitmap:=Bclearlayout;
   pmbookmarks.Bitmap:=BBookmarkadd;
   mb0.Bitmap:=BBookmarkadd;
   mb24.Bitmap:=BBookmark;
   pmbcaddbookmark.Bitmap:=BBookmarkadd;
   pmbcorganizebookmarks.Bitmap:=BBookmark;
   MenuItemOpen_organizebookmarks.Bitmap:=BBookmark;
   pmorganizebookmarks.Bitmap:=BBookmark;
   MenuItemBookmarks.Bitmap:=BBookmarkadd;
   MenuItemOpen_addtobookmarks.Bitmap:=BBookmarkadd;
   MenuItemHistoryBook.Bitmap:=Bbookmarkadd;
   MenuItemOpen_back.Bitmap:=Bback;
   MenuItemOpen_ExtractHere.Bitmap:=Bextractall;
   MenuItemPW.Bitmap:=Blocker2;
   mpw2.Bitmap:=Blocker2;
   mjob.Bitmap:=bbat;
   mjob2.Bitmap:=bbat;
   mfunadd.Bitmap:=Barchive;
   mfunextract.Bitmap:=Bextractall;
   po_setpw.Bitmap:=Blocker2;
   menupw.Bitmap:=Blocker2;
   pmqesetpw.Bitmap:=Blocker2;
   imageflat.Glyph:=Bnonthemed8;
   imageflatadd.Glyph:=Barchive;
   imageflatext.Glyph:=Bextractall;
   ImageFlattestmore.Glyph:=Bnonthemed0;
   MenuItemOpen_Flat.Bitmap:=Bexpand;
   MenuItemOpen_fwd.Bitmap:=Bgo;
   MenuItemOpen_refresh.Bitmap:=Brefresh;
   MenuItemOpen_test.Bitmap:=Btestall;
   MenuItemOpen_up.Bitmap:=Bgoup;
   mf3.Bitmap:=Bsearch;
   mf4up.Bitmap:=Bgoup;
   mback.Bitmap:=Bback;
   mFlat.Bitmap:=Bexpand;
   pmFlat.Bitmap:=Bexpand;
   po_flat.Bitmap:=Bexpand;
   mPeaSiteMirror.Bitmap:=BWeb;
   mPeaSupport.Bitmap:=BWeb;
   mPeafaq.Bitmap:=BWeb;
   mPeaTracker.Bitmap:=BWeb;
   mpeahelpoffline.Bitmap:=BPdf;
   mRefresh.Bitmap:=Brefresh;
   MenuItemContextRefresh.Bitmap:=Brefresh;
   pmhrefresh.Bitmap:=Brefresh;
   pmAddFile.Bitmap:=Bunsupported;
   pmAddFolder.Bitmap:=Bfolder;
   pmSearchAdd.Bitmap:=Bsearch;
   po_addtoarchive.Bitmap:=BArchive;
   po_delete.Bitmap:=Bdelete;
   pmquickdelete.Bitmap:=Bdelete;
   po_zerofile.Bitmap:=Bwipe;
   pmzerofile.Bitmap:=Bwipe;
   po_exthere.Bitmap:=Bextractall;
   pmqeto.Bitmap:=Bextractall;
   MenuItemExtAllTo.Bitmap:=Bextractall;
   po_securedelete.Bitmap:=Bstop;
   pmsecuredelete.Bitmap:=Bstop;
   pmjump1.Bitmap:=Bsystemtools;
   pmqjmore.Bitmap:=bfolder;
   pmjump2.Bitmap:=Bdesk;
   pmqjdropbox.Bitmap:=Bcloudfolder;
   pmqjmyboxfiles.Bitmap:=Bcloudfolder;
   pmqjgoogledrive.Bitmap:=Bcloudfolder;
   pmqjonedrive.Bitmap:=Bcloudfolder;
   pmqjskydrive.Bitmap:=Bcloudfolder;
   pmqjubuntuone.Bitmap:=Bcloudfolder;
   MenuItemOpen_dropbox.Bitmap:=Bcloudfolder;
   MenuItemOpen_myboxfiles.Bitmap:=Bcloudfolder;
   MenuItemOpen_googledrive.Bitmap:=Bcloudfolder;
   MenuItemOpen_onedrive.Bitmap:=Bcloudfolder;
   MenuItemOpen_skydrive.Bitmap:=Bcloudfolder;
   MenuItemOpen_ubuntuone.Bitmap:=Bcloudfolder;
   MenuItemArchive_dropbox.Bitmap:=Bcloudfolder;
   MenuItemArchive_myboxfiles.Bitmap:=Bcloudfolder;
   MenuItemArchive_googledrive.Bitmap:=Bcloudfolder;
   MenuItemArchive_onedrive.Bitmap:=Bcloudfolder;
   MenuItemArchive_skydrive.Bitmap:=Bcloudfolder;
   MenuItemArchive_ubuntuone.Bitmap:=Bcloudfolder;
   MenuItemOpen_desktop1.Bitmap:=Bdesk;
   mpathdesk1.Bitmap:=Bdesk;
   mhistory.Bitmap:=Bplaceshistory;
   smhistorya1.Bitmap:=Bplaceshistory;
   smhistory1.Bitmap:=Bplaceshistory;
   po_test.Bitmap:=Btestall;
   pmtabsclose.Bitmap:=Bdelete;
   pmtabsbookmarkadd.Bitmap:=BBookmarkadd;
   pmtabsbookmarkorg.Bitmap:=BBookmark;
   theme_label1.Width:=i16res;
   theme_label1.Height:=i16res;
   theme_label1.Picture.Bitmap:=Bresetpath;
   theme_label1.Transparent:=true;
   Imagelistsearch.Transparent:=true;
   Imagelistsearch1.Transparent:=true;
   loadimglist1icons;
   LabelThemeLoaded.Caption:=txt_icons_found;
   ComboBoxTheme.hint:=thpath+extractfilepath(theme_path);
   LabelTheme.hint:=txt_3_5_managecustomthemes;
   LabelTheme1.hint:=thpath+extractfilepath(theme_path);
   imgloaded:=true;
   imgloading:=false;
   except
   LabelThemeLoaded.Caption:=txt_icons_not_found;
   end;
   end;
end;

procedure default_defaults;
begin
lang_file:='default.txt';//lang file
autoclosegwrap:=2; //close pealauncher when job completes if no error happens
enc7zscc:=0; //0 UTF-8 encoding 1 WIN 2 DOS
browsersd:=0; //0 start browsing from last visited directory (default) 1 computer's root 2 desktop 3 home 4 custom
browsersdir:='';
movetorelativepath:=1;//interactive two steps extraction: extract and then move to relative path after extraction completed
autoopen:=0; //don't open output dir by default when job completes
autotest:=0; //don't test archives after creation
convertverbose:=0; //no verbose confirmation for conversion steps
convertpw:=0; //change password during conversion - asks a new password in re-compression stage
libre_directive:=0; //0 off (default) 1 flexible 2 strict enable only calls to binaries released under OSI licenses
mailkeep:=0; //don't keep archives sent by mail
nameaspartent:=1;//by default name multiple items as selected item's folder
df:=18; //default format: last used
tsstyle:=0;//default timestamp style
pf:=15; //previous format, by default zip
pcompr:=1; //pea default Compression: average
pobj:=11; //pea default object control algorithm CRC32
pvol:=4; //pea default volume control algorithm SHA-3 256
pstream:=0; //pea default stream control algorithm AES+Twofish+Serpent 256 bit in EAX mode
salgo:=13; //file split default integrity check algorithm: none
zaout:=2; //Console binaries interface option: GUI, GUI+console, console (except for list/test/benchmark)
zaout1:=zaout;
clipmode:=0; //clipboard mode for cut/copy/paste: 0 standard mode, 1 advanced mode allowing multiple mixed cut and copy selection from various sources
showguihints:=1; //peazip shows hint popups: 1 yes (default) 0 no
showsearchbar:=0; //hide search bar by default
{$IFDEF MSWINDOWS}
wingetdesk;
local_desktop:=desktop_path;
indir:=txt_mypc;//local_desktop;
{$ELSE}
indir:='/';
//showguihints:=0; //show hint popups, now default on Linux as performance of the binary is improved
{$ENDIF} //initial directory (file/archive browser interface) (in case of conf failure at startup txt_my pc is empty, but this condition is checked in check_defaults_failure)
showpwfield:=0; //shows password fields: off (requires pw confirmation)
setencfn:=0; //default don't encrypt filenames (apply only to formats supporting this feature)
intpw:=0; //default don't force typing password interactively in backend console
extpw:=3; //ask for password on Extract/list/test functions from system's meus entries
browserstyle:=0; //0:browser 1:flat 2*:last used ( *=0 browser, *=1 flat);
extopt7z:=0; //overwrite policy for extraction with 7z (skip existing files)
extaction7z:=0; //action for extraction, 7z frontend
extactionarc:=0; //action for extraction, arc frontend
extactionace:=0; //action for extraction, ace frontend
{$IFDEF MSWINDOWS}work_dir:=1;{$ELSE}work_dir:=0;{$ENDIF}
custom_work_path:='';
extoptarc:=2; //overwrite policy for extraction with arc (skip existing files)
closeonsingleextract:=0;//close after extraction if no browsing actions took place
whenspecialopen:=2;//always extract everything for special file types in archives
howspecialopen:=0;//extract entire archive for special file types in archives
Form_peach.editExtEvForWhat.Caption:=SPECEXTCONST;
Form_peach.Editcommonalgo.Caption:=PREFALGOCONST;
Form_peach.editcustext.Caption:='';
Form_peach.LabelForceLayout.Caption:='';
Form_peach.EditCSVsep.Caption:=',';
csvsep:=',';
ignorepathextand:=0; //extract and... extracts to current path ignoring internal archive's path: off (all ignore paths directives are ignored if the content is a directory, as it would lose information about content's tree)
ignorepathdisp:=0; //ignore path extracting displayed objects: off
ignorepathsel:=0; //ignore path extracting selected objects: off
enableextand:=0; //do not enable extract and open with menu, only preview
removeintdir:=1;//remove intermediate dir on extract to new folder: on
//Performance parameter for 7z/p7zip -slt listing, stop time consuming operations (dramatically faster on archives containing many files):
prebrowse:=3;
maxargsize:=2;
taskpriority:=2; //launch tasks with normal priority
dragtargetprotect:=1; //lock drag and drop target window during operation
skipdel:=1;//skip deletion if temp work files are locked
disableintscript:=1;
nonverboselog:=1;//non-verbose output for 7z / p7zip (v15.x onward), faster when many small files are involved
use7zunrar5:=1;//use 7z / p7zip UNRAR5 implementation (v15.06+)
useextrac32:=0;//(Windows) use system's Extrac32 to unpack CAB files
enumd:=1; //enumerate content of directories added for archiving operations
userar:=1;//use winrar's rar.exe for rar compression if installed
userar5:=1;//create rar5 instead of rar4
userardict:=5;//(rar5 only) user dictionary size of 1..1024 MB, not implemented for legacy RAR4 format
userarblake2:=0;//(rar5 only) use BLAKE2 hash instead of CRC
userarsfx:=0;
userarsolid:=0;
userarrr:=0;
puserarrr:=3;
userarsaveopen:=0;
userarsavesecurity:=0;
userarsavestreams:=0;
userarlastmodtime:=0;
userarlock:=0;
addencext:=0; //1 add ".enc" suffix (before extension) when creating encrypted archives
privacy_mode:=0; //ask for password when application starts 1 skippable 2 ask until a non empty password (or keyfile) is provided (so no operation can be done forgetting to provide the password)
addtstext:=0; //add timestamp suffix when creating archives
repcustext:=0; //replace archive extension with custom one
defaulttabsmenu:=2;//address bar menu 1 bookmarks 2 filesystem (default) 3 history 4 functions
multi_option:=1; //generic multithreading
memuse_option:=0;//default, implicit
{$IFDEF MSWINDOWS}
favdelete:=0; //default delete mode for delete option concatenated with archive/extract operations 0 Recycle (Windows) 1 Quick 2 Zero 3 Secure
{$ELSE}
{$IFDEF DARWIN}
favdelete:=0;
{$ELSE}
favdelete:=1;
{$ENDIF}
{$ENDIF}
doptadd:=0;// do not delete originals after archiving by default
doptext:=0;// do not delete originals after extraction by default
prebrowsesize:=192; //max M blocks of memory allowed to list archive content in the browser
savehistory:=1; //save usage history - last archives, last directories, last searches, access data about bookmarks to ease bookmarks management
customsyntax:=1; //syntax type for custom executable, creation
customsyntax1:=1; //syntax type for custom executable, extraction
ws:=1; //save window status: on
ws_status:=0; //ws maximized: off
ws_left:=DLEFT;
ws_top:=DTOP;
ws_width:=DWIDTH;
ws_height:=DHEIGTH;
ws_gw_left:=DGWLEFT;
ws_gw_top:=DGWTOP;
ws_gw_width:=DGWWIDTH;
ws_gw_height:=DGWHEIGTH;
fav7z:=1;//archive types to be added to favourite popup
favARC:=0;
favbz:=1;
favcustom:=0;
favgz:=1;
favpea:=0;
favquad:=0;
favsfx:=1;
favsfxarc:=0;
favsplit:=0;
favtar:=0;
favupx:=0;
favzip:=1;
favzpaq:=0;
favwim:=0;
favxz:=0;
favbrotli:=1;
favzstandard:=1;
maxbrotli:=0;
maxzstd:=0;
level_7z:=2;  //default Compression level for .7z: average
level_xz:=2;
method_7z:='LZMA2'; //default method for .7z: LZMA2
level_arc:=4; //default Compression level for ARC
solid_arc:=1; //default solid mode for ARC 0 non-solid 1 solid, auto-adjust
rr_arc:=1; //default recovery records for ARC: ON
algo_arc:=0; //default encryption algorithm for ARC: 0 AES 1 Serpent 2 Twofish 3 Blowfish (always max keysize)
algo_zipenc:=0; //default encryption algorithm for ZIP: 0 AES 1 ZipCrypto
level_bzip2:=2; //default Compression level for bzip2: average
level_gz:=2; //default Compression level for gzip: average
level_paq:=1; //default Compression level for zpaq: normal
paqver:=2;//default ZPAQ
level_quad:=0; //default Compression level for quad: normal (high off)
level_upx:=10; //default Compression level for upx: best
level_zip:=2; //default Compression level for zip: fast
method_zip:='Deflate'; //default method for .zip: deflate
sort7zbytype:=1; //default sort files by type for 7z solid compression: on
openw_all7z:=0; //default archive files open for writing for 7z binary: off
snoi7z:=0;
snon7z:=0;
tartype:=0;//0 gnu (default), 1 pax
tartime:=0;//0 windows 100 ns (default), 1 unix 1 sec, 2 linux 1 ns mapped to 3 due to 7z syntax
sni7z:=0; //manage NT security information default off
sns7z:=1; //manage NTFS alternate streams default on
snh7z:=0; //do not follow hard links
snl7z:=0; //do not follow sym links
snz7z:=1; //propagate zone.identifier default on
stl7z:=0;//set 7z/p7zip archive time from most recent file time
ssp7z:=0;
storecreated:=1;//store complete timestamps in archives
algodisp:=0; //default way to display checksum/hash
algoall:=13; //default SAH256; 0 common algorithms (defined below); 1 all algorithms
algoadler:=0;
algocrc16:=0;
algocrc24:=0;
algocrc32:=1;
algocrc64:=1;
algoed2k:=0;
algomd4:=0;
algomd5:=1;
algoripemd160:=1;
algosha1:=1;
algosha3_256:=1;
algosha256:=1;
algosha3_512:=0;
algosha512:=0;
algowhirl:=0;
erasepasses:=0;
filesizebase:=0;
{$IFDEF MSWINDOWS}jobdefenc:=0;{$ELSE}jobdefenc:=1;{$ENDIF}//encoding for job definition 0 system's default; 1 utf8
archivenameenc:=1; //encoding for filenames in archives 0 replace extended chars with ?; 1 utf8
mcuzip:=1; //encode non ascii chars as utf8 in 7z77zip for ZIP filenames
syntaxlevel7z:=1; //for generic OS use the oldest syntax level supported 7z 21.07
{$IFDEF MSWINDOWS}syntaxlevel7z:=0;{$ENDIF}
{$IFDEF LINUX}syntaxlevel7z:=0;{$ENDIF}
ptsync:=2; //sync archive tree in navigation panel
defaultactionst:=0;//by default open input file
mappeddrivesinfo:=0; //(Windows) 0 skip, 1 get volume information for mapped network units
lastoutpath:=''; //last output path, saved only if save history feature is on (default)
splittersize:=220; form_peach.splitter1.Cursor:=crSizeNS;
splitter2size:=180; form_peach.splitter2.Cursor:=crSizeWE;
splitter3size:=180; form_peach.splitter3.Cursor:=crSizeWE;
splitsearchsize:=800; form_peach.splitsearch.Cursor:=crSizeWE;
lastbar:=0;//status bar
esna:=0;
euns:=0;
euns1:=1;
checkver:='unchecked';//it make configuration fall back to defaults if conf is not read correctly, i.e. because of I/O errors or because it is found incompatible version's configuration (different number of lines)
browsertype:=0;
browsersize:=0;
listsortcol:=12;
az:=true;
col1size:=COL1D;
col2size:=COL2D;
col3size:=COL3D;
col4size:=COL4D;
col5size:=COL5D;
col6size:=COL6D;
col7size:=COL7D;
colmethodsize:=COL5D;
tonewfolder:=0;
immediate_execution:=0;
parallelarchive:=0;
defaultextractpath:='';
defaultarchivepath:='';
rowselect:=false;
enlargeicons:=false;
dirbeforefiles:=1;
thighlight:=false;
ccreated:=false;
caccessed:=false;
cmethod:=true;
ctype:=true;
csize:=true;
cpacked:=true;
cdate:=true;
catt:=true;
ccrc:=true;
cfree:=true;
cfs:=true;
toolsize:=0;
lsize:=0;
ptoolsize:=0;
swapbars:=false;
showmenu:=true;
navbar:=0;
addressbar:=1;
ptabbar:=0;
filterbrowser:=0;
showthumbnails:=0;
pimmersive:=0;
simplesearch:=1;
recsearch:=1;
usebreadcrumb:=1;
keeppw:=1;
browserch:=4;
zcopy:=0;
expandfs:=0;
expandroot:=0;
expandbook:=1;
expandhistory:=0;
expandmore:=0;
expandrun:=0;
expandapps:=0;
expandfun:=0;
lastextractionpath:='';
arcabspath:=0;
lasttoolbar:=1;
spchar:=1;
tpreset:=1;
simgfun:=1;
simgw:=1024;
simgh:=768;
simgper:=0;
simgasp:=1;
simgconv:=0;
simgj:=90;
simgt:=10;
simgb:=10;
simgl:=10;
simgr:=10;
simgpercent:=1;
deco_style:=0;
set_archivetree:=false;
showvolatile:=0;
autoopentar:=1;
tar_atomic:=1;
tar_atomic_convert:=0;
qdup:=1;
noconfdel:=0;
swzipx:=0;
convint:=1;
tryopenwerrors:=1;
forcecanbechanged:=0;
excludeef:=0;
forcelayout:=0;
forcebrowse:=1;
forceconvert:=0;
nativedrag:=1;
autosync:=1;
sys7zlin:=0;
ignorepathdd:=0;
level_brotli:=3;
level_rar:=3;
level_zstd:=2;
renselonly:=1;//fixed to 1, 0 would to allow rename all displayed items regardless selection
renfilesonly:=0;
defaultspanning:=0;//single volume, do not split output
spansize:=100;
spanunit:=2;
autoclosepeazip:=0;
skipenctest:=0;
zpaqall:=0;
zpaqfull:=0;
{$IFDEF MSWINDOWS}zpaqabsolute:=0;{$ELSE}zpaqabsolute:=1;{$ENDIF}
zpaqforce:=0;
advopdictionary:=0;
advopword:=4;
advoppasses:=0;
advopblocksize:=0;
Form_peach.EditEncoding.Caption:='1252';
selnode:=0;
end;

procedure check_theme_failure;
begin
if graphicsfolderd<>'' then
   if graphicsfolderd[length(graphicsfolderd)]<>directoryseparator then graphicsfolderd:=graphicsfolderd+directoryseparator;
//if opacityd<0 then opacityd:=0;
if opacityd>100 then opacityd:=100;
if opacityd=0 then opacityd:=100;
if color1d='' then color1d:=ColorToString(PAPPCOL);
if (usealtcolord<0) or (usealtcolord>1) then usealtcolord:=0;
if (highlighttabsd<0) or (highlighttabsd>5) then highlighttabsd:=0;
if (accenttoolbard<0) or (accenttoolbard>8) then accenttoolbard:=0;
if (altaddressstyle<0) or (altaddressstyle>2) then altaddressstyle:=1;
if (solidaddressstyle<0) or (solidaddressstyle>8) then solidaddressstyle:=0;
if (toolcentered<0) or (toolcentered>1) then toolcentered:=0;
if (alttabstyle<0) or (alttabstyle>2) then alttabstyle:=2;
end;

function wingetprogramsfolder:integer;
begin
Result:=-1;
{$IFDEF MSWINDOWS}
winpfolder:='';
winpfolder32:='';
winpfolder:=(GetEnvironmentVariable('ProgramW6432'));
if winpfolder='' then //XP and older
   begin
   winpfolder:=(GetEnvironmentVariable('ProgramFiles'));
   winpfolder32:=winpfolder;
   end
else //Vista and newer
   begin
   winpfolder:=(GetEnvironmentVariable('ProgramFiles'));
   winpfolder32:=(GetEnvironmentVariable('ProgramFiles(x86)'));
   if winpfolder=winpfolder32 then winpfolder:=(GetEnvironmentVariable('ProgramW6432'));
   end;
Result:=0;
if not(directoryexists(winpfolder)) then
   begin
   winpfolder:='';
   Result:=1;
   end;
if not(directoryexists(winpfolder32)) then
   begin
   winpfolder32:='';
   Result:=1;
   end;
if winpfolder<>'' then
   if winpfolder[length(winpfolder)]<>directoryseparator then winpfolder:=winpfolder+directoryseparator;
if winpfolder32<>'' then
   if winpfolder32[length(winpfolder32)]<>directoryseparator then winpfolder32:=winpfolder32+directoryseparator;
{$ENDIF}
end;

function wingetsystemfolder:integer;
begin
Result:=-1;
{$IFDEF MSWINDOWS}
winsysfolder:='';
winsysfolder:=(GetEnvironmentVariable('SystemRoot'));
Result:=0;
if not(directoryexists(winsysfolder)) then
   begin
   winsysfolder:='';
   Result:=1;
   end;
if winsysfolder<>'' then
   if winsysfolder[length(winsysfolder)]<>directoryseparator then winsysfolder:=winsysfolder+directoryseparator;
{$ENDIF}
end;

function wingetdesk:integer;
begin
wingetdesk:=-1;
{$IFDEF MSWINDOWS}
desktop_path:=GetWindowsSpecialDir(CSIDL_DESKTOPDIRECTORY);
if not(directoryexists(desktop_path)) then home_path:=(GetEnvironmentVariable('USERPROFILE'))+'\Desktop\'; //try from environment variable
if not(directoryexists(desktop_path)) then desktop_path:=GetWindowsSpecialDir(CSIDL_COMMON_DESKTOPDIRECTORY);//fallback on common desktop
if not(directoryexists(desktop_path)) then desktop_path:=GetWindowsSpecialDir(CSIDL_COMMON_DESKTOPDIRECTORY);//fallback on profile
if not(directoryexists(desktop_path)) then desktop_path:=GetWindowsSpecialDir(CSIDL_PROFILE);//fallback on home
if not(directoryexists(desktop_path)) then
   begin
   desktop_path:='C:\';//fallback on C:\ rather than casting error on desktop (default initial dir)
   Result:=0;
   end
else Result:=0;
{$ENDIF}
end;

function wingetuserprofile:integer;
begin
wingetuserprofile:=-1;
{$IFDEF MSWINDOWS}
home_path:=GetWindowsSpecialDir(CSIDL_PROFILE);
if not(directoryexists(home_path)) then home_path:=(GetEnvironmentVariable('USERPROFILE'))+directoryseparator;
if not(directoryexists(home_path)) then
   begin
   home_path:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetappdatafolder:integer;
begin
wingetappdatafolder:=-1;
{$IFDEF MSWINDOWS}
winappdatafolder:=GetWindowsSpecialDir(CSIDL_APPDATA);
if not(directoryexists(winappdatafolder)) then winappdatafolder:=(GetEnvironmentVariable('APPDATA'))+directoryseparator;
if not(directoryexists(winappdatafolder)) then
   begin
   winappdatafolder:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetappdata(var s:ansistring):integer;
begin
wingetappdata:=-1;
{$IFDEF MSWINDOWS}
wingetappdatafolder;
s:=winappdatafolder+'PeaZip\';
wingetappdata:=0;
{$ENDIF}
end;

function wingetdocuments:integer;
begin
wingetdocuments:=-1;
{$IFDEF MSWINDOWS}
usr_documents:=GetWindowsSpecialDir(CSIDL_PERSONAL);
if not(directoryexists(usr_documents)) then
   begin
   usr_documents:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetmusic:integer;
begin
wingetmusic:=-1;
{$IFDEF MSWINDOWS}
usr_music:=GetWindowsSpecialDir(CSIDL_MYMUSIC);
if not(directoryexists(usr_music)) then
   begin
   usr_music:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetpictures:integer;
begin
wingetpictures:=-1;
{$IFDEF MSWINDOWS}
usr_pictures:=GetWindowsSpecialDir(CSIDL_MYPICTURES);
if not(directoryexists(usr_pictures)) then
   begin
   usr_pictures:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetvideos:integer;
begin
wingetvideos:=-1;
{$IFDEF MSWINDOWS}
usr_videos:=GetWindowsSpecialDir(CSIDL_MYVIDEO);
if not(directoryexists(usr_videos)) then
   begin
   usr_videos:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetsendto:integer;
begin
wingetsendto:=-1;
{$IFDEF MSWINDOWS}
usr_sendto:=GetWindowsSpecialDir(CSIDL_SENDTO);
if not(directoryexists(usr_sendto)) then
   begin
   usr_sendto:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetpublicdocuments:integer;
begin
wingetpublicdocuments:=-1;
{$IFDEF MSWINDOWS}
public_documents:=GetWindowsSpecialDir(CSIDL_COMMON_DOCUMENTS);
if not(directoryexists(public_documents)) then
   begin
   public_documents:='';
   Form_peach.pmJumppubdoc.Visible:=false;
   Form_peach.MenuItemArchive_pubdoc.Visible:=false;
   Form_peach.MenuItemOpen_pubdoc.Visible:=false;
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetpublichome:integer;
begin
wingetpublichome:=-1;
{$IFDEF MSWINDOWS}
try
public_home:=(GetEnvironmentVariable('PUBLIC'));
if public_home='' then
else
   if public_home[length(public_home)]<>directoryseparator then public_home:=public_home+directoryseparator;
except
end;
if not(directoryexists(public_home)) then
   begin
   public_home:='';
   Form_peach.pmJumppubhome.Visible:=false;
   Form_peach.MenuItemArchive_pubhome.Visible:=false;
   Form_peach.MenuItemOpen_pubhome.Visible:=false;
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetrecent:integer;
begin
wingetrecent:=-1;
{$IFDEF MSWINDOWS}
usr_recent:=GetWindowsSpecialDir(CSIDL_RECENT);
if not(directoryexists(usr_recent)) then
   begin
   usr_recent:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetdownloads:integer;
begin
wingetdownloads:=-1;
{$IFDEF MSWINDOWS}
usr_downloads:='';
if winver<>'nt6+' then
   begin
   Form_peach.pmJumpdownloads.Visible:=false;
   exit;
   end;
usr_downloads:=home_path+'Downloads\';
if not(directoryexists(usr_downloads)) then
   begin
   usr_downloads:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetsearches:integer;
begin
wingetsearches:=-1;
{$IFDEF MSWINDOWS}
usr_searches:='';
if winver<>'nt6+' then
   begin
   Form_peach.pmJumpsearches.Visible:=false;
   exit;
   end;
usr_searches:=home_path+'Searches\';
if not(directoryexists(usr_searches)) then
   begin
   usr_searches:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetlibraries:integer;
begin
wingetlibraries:=-1;
{$IFDEF MSWINDOWS}
usr_libraries:='';
usr_libraries:=home_path+'AppData\Roaming\Microsoft\Windows\Libraries\';
if not directoryexists(usr_libraries) then
   begin
   usr_libraries:='';
   Form_peach.pmJumplibraries.Visible:=false;
   exit;
   end;
if not(directoryexists(usr_libraries)) then
   begin
   usr_libraries:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function sysgetshared:integer;
begin
sysgetshared:=-1;
shared_dropbox:='';
shared_myboxfiles:='';
shared_googledrive:='';
shared_onedrive:='';
shared_skydrive:='';
shared_ubuntuone:='';
Form_peach.pmqjdropbox.visible:=false;
Form_peach.pmqjmyboxfiles.visible:=false;
Form_peach.pmqjgoogledrive.visible:=false;
Form_peach.pmqjonedrive.visible:=false;
Form_peach.pmqjskydrive.visible:=false;
Form_peach.pmqjubuntuone.visible:=false;
{$IFDEF MSWINDOWS}
if directoryexists(home_path+'Dropbox') then
   begin
   shared_dropbox:=home_path+'Dropbox\';
   Form_peach.pmqjdropbox.visible:=true;
   end;
if directoryexists(usr_documents+'My Box Files') then
   begin
   shared_myboxfiles:=usr_documents+'My Box Files\';
   Form_peach.pmqjmyboxfiles.visible:=true;
   end;
if directoryexists(home_path+'Google Drive') then
   begin
   shared_googledrive:=home_path+'Google Drive\';
   Form_peach.pmqjgoogledrive.visible:=true;
   end;
if directoryexists(home_path+'OneDrive') then
   begin
   shared_onedrive:=home_path+'OneDrive\';
   Form_peach.pmqjonedrive.visible:=true;
   end;
if directoryexists(home_path+'Workspaces') then
   begin
   shared_skydrive:=home_path+'Workspaces\';
   Form_peach.pmqjskydrive.visible:=true;
   end;
if directoryexists(home_path+'YandexDisk') then
   begin
   shared_ubuntuone:=home_path+'YandexDisk\';
   Form_peach.pmqjubuntuone.visible:=true;
   end;
{$ENDIF}
{$IFDEF LINUX}
{$ENDIF}
Form_peach.MenuItemArchive_dropbox.visible:=Form_peach.pmqjdropbox.visible;
Form_peach.MenuItemArchive_myboxfiles.visible:=Form_peach.pmqjmyboxfiles.visible;
Form_peach.MenuItemArchive_googledrive.visible:=Form_peach.pmqjgoogledrive.visible;
Form_peach.MenuItemArchive_onedrive.visible:=Form_peach.pmqjonedrive.visible;
Form_peach.MenuItemArchive_skydrive.visible:=Form_peach.pmqjskydrive.visible;
Form_peach.MenuItemArchive_ubuntuone.visible:=Form_peach.pmqjubuntuone.visible;
Form_peach.MenuItemOpen_dropbox.visible:=Form_peach.pmqjdropbox.visible;
Form_peach.MenuItemOpen_myboxfiles.visible:=Form_peach.pmqjmyboxfiles.visible;
Form_peach.MenuItemOpen_googledrive.visible:=Form_peach.pmqjgoogledrive.visible;
Form_peach.MenuItemOpen_onedrive.visible:=Form_peach.pmqjonedrive.visible;
Form_peach.MenuItemOpen_skydrive.visible:=Form_peach.pmqjskydrive.visible;
Form_peach.MenuItemOpen_ubuntuone.visible:=Form_peach.pmqjubuntuone.visible;
sysgetshared:=0;
end;

procedure check_defaults_failure;
begin
//no control on lang_file name
if (autoclosegwrap>4) then autoclosegwrap:=2;
if (enc7zscc>2) then enc7zscc:=0;
if (browsersd>4) then browsersd:=0;
if (movetorelativepath>1) then movetorelativepath:=1;
if (autoopen>1) then autoopen:=0;
if (autotest>1) then autotest:=0;
if (convertpw<0) or (convertpw>1) then convertpw:=0;
if (convertverbose<0) or (convertverbose>1) then convertverbose:=0;
if (libre_directive<0) or (libre_directive>2) then libre_directive:=0;
if (mailkeep>1) then mailkeep:=0;
if (nameaspartent>1) then nameaspartent:=1;
if (df>18) then df:=18;
if (tsstyle<0) or (tsstyle>3) then tsstyle:=0;
if (pf>17) then pf:=15;
if (pcompr>3) then pcompr:=1;
if (pobj>13) then pobj:=11;
if (pvol>13) then pvol:=4;
if (pstream>9) then pstream:=0;
if (salgo>13) then salgo:=13;
if (zaout>2) then zaout:=2;
zaout1:=zaout;
if (clipmode>1) then clipmode:=0;
case browsersd of
   1: begin
      {$IFDEF MSWINDOWS}
      indir:=txt_mypc;//local_desktop;
      {$ELSE}
      indir:='/';
      {$ENDIF}
      end;
   2: begin
      {$IFDEF MSWINDOWS}
      indir:=local_desktop;
      {$ELSE}
      indir:=local_desktop;
      if indir<>'' then
         if indir[length(indir)]<>directoryseparator then indir:=indir+directoryseparator;
      {$ENDIF}
      end;
   3: begin
      {$IFDEF MSWINDOWS}
      indir:=home_path;
      {$ELSE}
      indir:=home_path;
      if indir<>'' then
         if indir[length(indir)]<>directoryseparator then indir:=indir+directoryseparator;
      {$ENDIF}
      end;
   4: if directoryexists(browsersdir) then indir:=browsersdir;
   end;
if indir='' then
   begin
   {$IFDEF MSWINDOWS}
   indir:=txt_mypc;//local_desktop;
   {$ELSE}
   indir:='/';
   {$ENDIF}
   end;
if indir<>txt_mypc then
   if not(directoryexists(indir)) then
      begin
      {$IFDEF MSWINDOWS}
      indir:=txt_mypc;
      {$ELSE}
      indir:='/';
      {$ENDIF}
      end;
if (showguihints>1) then showguihints:=1;
if (showsearchbar>1) then showsearchbar:=0;
if (showpwfield>1) then showpwfield:=0;
if (setencfn>1) then setencfn:=0;
if (intpw>1) then intpw:=0;
if (extpw>4) then extpw:=3;
if (extopt7z>4) then extopt7z:=0;
if (extaction7z>4) then extaction7z:=0;
if (extactionarc>5) then extactionarc:=0;
if (extactionace>3) then extactionace:=0;
if (work_dir<0) or (work_dir>5) then {$IFDEF MSWINDOWS}work_dir:=1;{$ELSE}work_dir:=0;{$ENDIF}
if (extoptarc>2) then extoptarc:=0;
if (closeonsingleextract>1) then closeonsingleextract:=0;
if (whenspecialopen<0) or (whenspecialopen>2) then whenspecialopen:=2;
if (howspecialopen<0) or (howspecialopen>1) then howspecialopen:=0;
if (length(Form_peach.editExtEvForWhat.Caption)<1) or (length(Form_peach.editExtEvForWhat.Caption)>1000) then Form_peach.editExtEvForWhat.Caption:=SPECEXTCONST;
if (length(Form_peach.Editcommonalgo.Caption)<1) or (length(Form_peach.Editcommonalgo.Caption)>1000) then Form_peach.Editcommonalgo.Caption:=PREFALGOCONST;
if (ignorepathextand>1) then ignorepathextand:=0;
if (ignorepathdisp>1) then ignorepathdisp:=0;
if (ignorepathsel>1) then ignorepathsel:=0;
if (enableextand>1) then enableextand:=0;
if (nativedrag<0) or (nativedrag>1) then nativedrag:=1;
if (autosync<0) or (autosync>1) then autosync:=1;
if nativedrag=1 then ignorepathdd:=0 else ignorepathdd:=1;
if (removeintdir>1) then removeintdir:=1;
if (prebrowse>5) then prebrowse:=3;
if (maxargsize<0) or (maxargsize>7) then maxargsize:=2;
if (taskpriority>3) then taskpriority:=2;
if (dragtargetprotect>3) then dragtargetprotect:=1;
if (skipdel>1) then skipdel:=1;
if (disableintscript>1) then disableintscript:=1;
if (nonverboselog>1) then nonverboselog:=1;
if (use7zunrar5>1) then use7zunrar5:=1;
if (useextrac32>1) then useextrac32:=0;
if (enumd>1) then enumd:=1;
if (userar>1) then userar:=1;
if (userar5>1) then userar5:=1;
if (userardict<0) or (userardict>10) then userardict:=5;
if (userarblake2>1) then userarblake2:=0;
if (userarsfx>1) then userarsfx:=0;
if (userarsolid>1) then userarsolid:=0;
if (userarrr>1) then userarrr:=0;
if (puserarrr<1) or (puserarrr>100) then puserarrr:=3;
if (userarsaveopen>1) then userarsaveopen:=0;
if (userarsavesecurity>1) then userarsavesecurity:=0;
if (userarsavestreams>1) then userarsavestreams:=0;
if (userarlastmodtime>2) then userarlastmodtime:=0;
if (userarlock>1) then userarlock:=0;
if (addencext>1) then addencext:=0;
if (privacy_mode<0) or (privacy_mode>2) then privacy_mode:=0;
if (addtstext>1) then addtstext:=0;
if (repcustext>1) then repcustext:=0;
if (length(Form_peach.editcustext.Caption)>100) then Form_peach.editcustext.Caption:='';
if (defaulttabsmenu<1) or (defaulttabsmenu>4) then defaulttabsmenu:=2;
if (multi_option>9) then multi_option:=1;
if (memuse_option>9) then memuse_option:=0;
{$IFDEF MSWINDOWS}
if (favdelete<0) or (favdelete>3) then favdelete:=0;
{$ELSE}
{$IFDEF DARWIN}
if (favdelete<0) or (favdelete>3) then favdelete:=0;
{$ELSE}
if (favdelete<1) or (favdelete>3) then favdelete:=1;
{$ENDIF}
{$ENDIF}
if (prebrowsesize<4) or (prebrowsesize>512) then prebrowsesize:=192; //unused
if (savehistory>1) then savehistory:=1;
if (customsyntax>5) then customsyntax:=1;
if (customsyntax1>5) then customsyntax:=1;
if (ws>1) then ws:=1;
if (ws_status>1) then ws_status:=0; //default wsNormal
if (ws_left<0) or (ws_left>Screen.Width) then ws_left:=DLEFT; //don't allow to save the window position more than 1024*768 from lef-top corner of the screen
if (ws_top<0) or (ws_top>Screen.Height) then ws_top:=DTOP; //allow to use any window size, so don't check ws size
if (ws_gw_left<0) or (ws_gw_left>Screen.Width) then ws_gw_left:=DGWLEFT;
if (ws_gw_top<0) or (ws_gw_top>Screen.Height) then ws_gw_top:=DGWTOP;
if (fav7z>1) then fav7z:=1;
if (favARC>1) then favARC:=0;
if (favbz>1) then favbz:=1;
if (favcustom>1) then favcustom:=0;
if (favgz>1) then favgz:=1;
if (favpea>1) then favpea:=0;
if (favquad>1) then favquad:=0;
if (favsplit>1) then favsplit:=0;
if (favtar>1) then favtar:=0;
if (favsfx>1) then favsfx:=1;
if (favsfxarc>1) then favsfxarc:=0;
if (favupx>1) then favupx:=0;
if (favzip>1) then favzip:=1;
if (favwim>1) then favwim:=0;
if (favxz>1) then favxz:=0;
if (favbrotli>1) then favbrotli:=1;
if (favzstandard>1) then favzstandard:=1;
if (favzpaq>1) then favzpaq:=0;
if (level_7z>5) then level_7z:=3;
if (level_xz>4) then level_xz:=2;
if (method_7z<>'LZMA') and (method_7z<>'LZMA2') and (method_7z<>'PPMd') and (method_7z<>'BZip2') and
   (method_7z<>'Brotli') and (method_7z<>'FLZMA2') and (method_7z<>'Lizard_fastLZ4') and (method_7z<>'Lizard_LIZv1') and
   (method_7z<>'Lizard_fastLZ4+Huffman') and (method_7z<>'Lizard_LIZv1+Huffman') and (method_7z<>'LZ4') and (method_7z<>'LZ5') and
   (method_7z<>'Zstd') and (method_7z<>'Deflate') and (method_7z<>'Deflate64') then method_7z:='LZMA2';
if (level_arc>9) then level_arc:=4;
if (solid_arc>2) then solid_arc:=1;
if (rr_arc>1) then rr_arc:=1;
if (algo_arc>3) then algo_arc:=0;
if (algo_zipenc>1) then algo_arc:=1;
if (level_bzip2>4) then level_bzip2:=2;
if (level_gz>4) then level_gz:=2;
if (level_paq>3) then level_paq:=1;
if (paqver>2) then paqver:=2;
if (level_quad>1) then level_quad:=0;
if (level_upx>10) then level_upx:=10;
if (level_zip>5) then level_zip:=3;
if (method_zip<>'Deflate') and (method_zip<>'Deflate64') and (method_zip<>'BZip2') and (method_zip<>'LZMA') and (method_zip<>'PPMd') and (method_zip<>'XZ')
   {$IFNDEF MSWINDOWS}
   and (method_zip<>'Zstd')
   {$ENDIF}
   then method_zip:='Deflate';
if (openw_all7z>1) then openw_all7z:=0;
if (snoi7z>1) then snoi7z:=0;
if (snon7z>1) then snon7z:=0;
if (tartype>1) then tartype:=0;
if (tartime>2) then tartime:=0;
if (sni7z>1) then sni7z:=0;
if (sns7z>1) then sns7z:=1;
if (snh7z>1) then snh7z:=0;
if (snl7z>1) then snl7z:=0;
if (snz7z>1) then snz7z:=1;
if (stl7z>1) then stl7z:=0;
if (ssp7z>1) then ssp7z:=0;
if (storecreated>1) then storecreated:=1;
if (maxbrotli>1) then maxbrotli:=0;
if (maxzstd>1) then maxzstd:=0;
if (sort7zbytype>1) then sort7zbytype:=1;
if (algodisp>2) then algodisp:=0;
if (algoall>18) then algoall:=13;
if (algoadler>1) then algoadler:=0;
if (algocrc16>1) then algocrc16:=0;
if (algocrc24>1) then algocrc24:=0;
if (algocrc32>1) then algocrc32:=1;
if (algocrc64>1) then algocrc64:=0;
if (algoed2k>1) then algoed2k:=0;
if (algomd4>1) then algomd4:=0;
if (algomd5>1) then algomd5:=1;
if (algoripemd160>1) then algoripemd160:=1;
if (algosha1>1) then algosha1:=1;
if (algosha3_256>1) then algosha3_256:=1;
if (algosha256>1) then algosha256:=1;
if (algosha3_512>1) then algosha3_512:=0;
if (algosha512>1) then algosha512:=0;
if (algowhirl>1) then algowhirl:=0;
if (erasepasses>4) then erasepasses:=0;
if (filesizebase>2) then filesizebase:=0;
if (jobdefenc>1) then {$IFDEF MSWINDOWS}jobdefenc:=0;{$ELSE}jobdefenc:=1;{$ENDIF}
if (showvolatile<0) or (showvolatile>1) then showvolatile:=0;
if (archivenameenc>1) then archivenameenc:=1;
if (mcuzip>3) then mcuzip:=1;
if (syntaxlevel7z>1) then
{$IFDEF MSWINDOWS}syntaxlevel7z:=0;{$ElSE}
{$IFDEF LINUX}syntaxlevel7z:=0;{$ELSE}syntaxlevel7z:=1;{$ENDIF}{$ENDIF}
if (ptsync>2) then ptsync:=2;
if (defaultactionst>5) then defaultactionst:=0;
if (mappeddrivesinfo<0) or (mappeddrivesinfo>1) then mappeddrivesinfo:=0;
if (local_desktop='') or (not(directoryexists(local_desktop))) then local_desktop:=desktop_path;
if local_desktop<>'' then
   if local_desktop[length(local_desktop)]<>directoryseparator then local_desktop:=local_desktop+directoryseparator;
if (splittersize<0) then splittersize:=220;
if (splitter2size<0) then splitter2size:=180;
if (splitter3size<1) then splitter3size:=180;
if (splitsearchsize<0) then splitsearchsize:=800;
if (lastbar<0) or (lastbar>5) then lastbar:=0;
if (esna<0) or (esna>1) then esna:=0;
if (euns<0) or (euns>1) then euns:=0;
if (euns1<0) or (euns1>1) then euns1:=1;
if (browsertype<0) or (browsertype>2) then browsertype:=0;
if (browsersize<0) or (browsersize>2) then browsersize:=0;
if (listsortcol<1) or (listsortcol>16) then listsortcol:=12;
if (col1size<26) or (col1size>1024) then col1size:=COL1D; //on Windows listview column size is currently fixed to 25 in Lazarus 0.9.26.2
if (col2size<26) or (col2size>1024) then col2size:=COL2D;
if (col3size<26) or (col3size>1024) then col3size:=COL3D;
if (col4size<26) or (col4size>1024) then col4size:=COL4D;
if (col5size<26) or (col5size>1024) then col5size:=COL5D;
if (col6size<26) or (col6size>1024) then col6size:=COL6D;
if (col7size<26) or (col7size>1024) then col7size:=COL7D;
if (colmethodsize<26) or (colmethodsize>1024) then colmethodsize:=COL5D;
if (tonewfolder>1) then tonewfolder:=0;
if (immediate_execution>1) then immediate_execution:=0;
if (parallelarchive>1) then parallelarchive:=1;
if not(directoryexists(defaultextractpath)) then defaultextractpath:='';
if not(directoryexists(defaultarchivepath)) then defaultarchivepath:='';
if (zcopy>1) then zcopy:=0;
if (expandfs<0) or (expandfs>1) then expandfs:=0;
if (expandroot<0) or (expandroot>1) then expandroot:=0;
if (expandbook<0) or (expandbook>1) then expandbook:=1;
if (expandhistory<0) or (expandhistory>1) then expandhistory:=0;
if (expandmore<0) or (expandmore>1) then expandmore:=0;
if (expandrun<0) or (expandrun>1) then expandrun:=1;
if (expandapps<0) or (expandapps>1) then expandapps:=0;
if (expandfun<0) or (expandfun>1) then expandfun:=0;
if (toolsize<0) or (toolsize>7) then toolsize:=0; ptoolsize:=toolsize;
if (lsize<0) or (lsize>1) then lsize:=0;
if (navbar<0) or (navbar>3) then navbar:=0;
if (addressbar<0) or (addressbar>1) then addressbar:=1;
if (ptabbar<0) or (ptabbar>1) then ptabbar:=0;
if (filterbrowser>1) then filterbrowser:=0;
if (showthumbnails<0) or (showthumbnails>1) then showthumbnails:=0;
if (pimmersive<0) or (pimmersive>1) then pimmersive:=0;
if (simplesearch<0) or (simplesearch>1) then simplesearch:=1;
if (recsearch<0) or (recsearch>1) then recsearch:=1;
if (renfilesonly<0) or (renfilesonly>1) then renfilesonly:=0;
if (browserch<1) or (browserch>17) then browserch:=4;
if (arcabspath<0) or (arcabspath>1) then arcabspath:=0;
if (keeppw<0) or (keeppw>1) then keeppw:=1;
if (usebreadcrumb<0) or (usebreadcrumb>1) then usebreadcrumb:=1;
if (lasttoolbar<1) or (lasttoolbar>3) then lasttoolbar:=1;
if (spchar>1) then spchar:=1;
if (tpreset<1) or (tpreset>6) then tpreset:=1;
if (simgfun<0) or (simgfun>3) then simgfun:=1;
if (simgw<1) or (simgw>40000) then simgw:=1024;
if (simgh<1) or (simgh>30000) then simgh:=768;
if (simgper<0) or (simgper>1) then simgper:=0;
if (simgasp<0) or (simgasp>1) then simgasp:=1;
if (simgconv<0) or (simgconv>7) then simgconv:=0;
if (simgj<0) or (simgj>100) then simgj:=90;
if (simgt<0) or (simgt>40000) then simgt:=10;
if (simgb<0) or (simgb>40000) then simgb:=10;
if (simgl<0) or (simgl>40000) then simgl:=10;
if (simgr<0) or (simgr>40000) then simgr:=10;
if (simgpercent<0) or (simgpercent>1) then simgpercent:=1;
if (deco_style<0) or (deco_style>2) then deco_style:=0;
if (doptadd<0) or (doptadd>1) then doptadd:=0;
if (doptext<0) or (doptext>1) then doptext:=0;
if (autoopentar<0) or (autoopentar>1) then autoopentar:=1;
if (tar_atomic<0) or (tar_atomic>1) then tar_atomic:=1;
if (tar_atomic_convert<0) or (tar_atomic_convert>1) then tar_atomic_convert:=0;
if (qdup<0) or (qdup>1) then qdup:=1;
if (noconfdel<0) or (noconfdel>1) then noconfdel:=0;
if swzipx>1 then swzipx:=0;
if convint>1 then convint:=1;
if (tryopenwerrors<0) or (tryopenwerrors>1) then tryopenwerrors:=1;
if (forcecanbechanged<0) or (forcecanbechanged>1) then forcecanbechanged:=0;
if (excludeef<0) or (excludeef>1) then excludeef:=0;
if (forcelayout<0) or (forcelayout>1) then forcelayout:=0;
if (forcebrowse<0) or (forcebrowse>1) then forcebrowse:=1;
if (forceconvert<0) or (forceconvert>1) then forceconvert:=0;
if (level_brotli>=7) then level_brotli:=3;
if (level_rar>5) then level_rar:=3;
if (level_zstd>=9) then level_zstd:=2;
if (defaultspanning<0) or (defaultspanning>10) then defaultspanning:=0;
if (spansize<1) or (spansize>1000000000) then spansize:=100;
if (spanunit<0) or (spanunit>10) then spanunit:=2;
if (autoclosepeazip>1) then autoclosepeazip:=0;
if (skipenctest>1) then skipenctest:=0;
if (zpaqall>1) then zpaqall:=0;
if (zpaqfull>1) then zpaqfull:=0;
if (zpaqabsolute>1) then zpaqabsolute:=1;
if (zpaqforce>1) then zpaqforce:=0;
if (sys7zlin<0) or (sys7zlin>1) then sys7zlin:=0;
end;

procedure settabsstyled;
begin
Form_peach.ShapeTitleAddb1.Height:=tablabelheight;
Form_peach.ShapeTitleAddb2.Height:=tablabelheight;
Form_peach.ShapeTitleAddb3.Height:=tablabelheight;
Form_peach.ShapeTitleAddb4.Height:=tablabelheight;
Form_peach.ShapeTitleExtractb1.Height:=tablabelheight;
Form_peach.ShapeTitleExtractb2.Height:=tablabelheight;
Form_peach.ShapeTitleExtractb3.Height:=tablabelheight;
Form_peach.ShapeTitleExtractb4.Height:=tablabelheight;
Form_peach.ShapeTitleAppsb1.Height:=tablabelheight;
Form_peach.ShapeTitleAppsb2.Height:=tablabelheight;
FormPM.ShapeTitlePMb1.Height:=tablabelheight;
FormPM.ShapeTitlePMb2.Height:=tablabelheight;
Form_gwrap.ShapeTitleb1.Height:=tablabelheight;
Form_gwrap.ShapeTitleb2.Height:=tablabelheight;
Form_gwrap.ShapeTitleb3.Height:=tablabelheight;
Form_gwrap.ShapeTitleb4.Height:=tablabelheight;
if alttabstyle=1 then
begin
Form_peach.LabelTitleExtract1.AnchorSideTop.Control:=Form_peach.PanelTitleExtract;
Form_peach.LabelTitleExtract2.AnchorSideTop.Control:=Form_peach.PanelTitleExtract;
Form_peach.LabelTitleExtract3.AnchorSideTop.Control:=Form_peach.PanelTitleExtract;
Form_peach.LabelTitleExtract4.AnchorSideTop.Control:=Form_peach.PanelTitleExtract;
Form_peach.ShapeTitleExtractb1.visible:=false;
Form_peach.ShapeTitleExtractb2.visible:=false;
Form_peach.ShapeTitleExtractb3.visible:=false;
Form_peach.ShapeTitleExtractb4.visible:=false;
Form_peach.LabelTitleAdd1.AnchorSideTop.Control:=Form_peach.PanelTitleAdd;
Form_peach.LabelTitleAdd2.AnchorSideTop.Control:=Form_peach.PanelTitleAdd;
Form_peach.LabelTitleAdd3.AnchorSideTop.Control:=Form_peach.PanelTitleAdd;
Form_peach.LabelTitleAdd4.AnchorSideTop.Control:=Form_peach.PanelTitleAdd;
Form_peach.ShapeTitleAddb1.visible:=false;
Form_peach.ShapeTitleAddb2.visible:=false;
Form_peach.ShapeTitleAddb3.visible:=false;
Form_peach.ShapeTitleAddb4.visible:=false;
Form_peach.LabelTitleApps1.AnchorSideTop.Control:=Form_peach.PanelTitleApps;
Form_peach.LabelTitleApps2.AnchorSideTop.Control:=Form_peach.PanelTitleApps;
Form_peach.ShapeTitleAppsb1.visible:=false;
Form_peach.ShapeTitleAppsb2.visible:=false;
FormPM.LabelTitlepm1.AnchorSideTop.Control:=FormPM.PanelTitlePM;
FormPM.LabelTitlepm2.AnchorSideTop.Control:=FormPM.PanelTitlePM;
FormPM.ShapeTitlePMb1.visible:=false;
FormPM.ShapeTitlePMb2.visible:=false;
Form_gwrap.LabelTitle1.AnchorSideTop.Control:=Form_gwrap.PanelTitle;
Form_gwrap.LabelTitle2.AnchorSideTop.Control:=Form_gwrap.PanelTitle;
Form_gwrap.LabelTitle3.AnchorSideTop.Control:=Form_gwrap.PanelTitle;
Form_gwrap.LabelTitle4.AnchorSideTop.Control:=Form_gwrap.PanelTitle;
Form_gwrap.ShapeTitleb1.visible:=false;
Form_gwrap.ShapeTitleb2.visible:=false;
Form_gwrap.ShapeTitleb3.visible:=false;
Form_gwrap.ShapeTitleb4.visible:=false;
end
else
begin
Form_peach.LabelTitleExtract1.AnchorSideTop.Control:=Form_peach.ShapeTitleExtractb1;
Form_peach.LabelTitleExtract2.AnchorSideTop.Control:=Form_peach.ShapeTitleExtractb1;
Form_peach.LabelTitleExtract3.AnchorSideTop.Control:=Form_peach.ShapeTitleExtractb1;
Form_peach.LabelTitleExtract4.AnchorSideTop.Control:=Form_peach.ShapeTitleExtractb1;
Form_peach.ShapeTitleExtractb1.visible:=true;
Form_peach.ShapeTitleExtractb2.visible:=true;
Form_peach.ShapeTitleExtractb3.visible:=true;
Form_peach.ShapeTitleExtractb4.visible:=true;
Form_peach.LabelTitleAdd1.AnchorSideTop.Control:=Form_peach.ShapeTitleAddb1;
Form_peach.LabelTitleAdd2.AnchorSideTop.Control:=Form_peach.ShapeTitleAddb1;
Form_peach.LabelTitleAdd3.AnchorSideTop.Control:=Form_peach.ShapeTitleAddb1;
Form_peach.LabelTitleAdd4.AnchorSideTop.Control:=Form_peach.ShapeTitleAddb1;
Form_peach.ShapeTitleAddb1.visible:=true;
Form_peach.ShapeTitleAddb2.visible:=true;
Form_peach.ShapeTitleAddb3.visible:=true;
Form_peach.ShapeTitleAddb4.visible:=true;
Form_peach.LabelTitleApps1.AnchorSideTop.Control:=Form_peach.ShapeTitleAppsb1;
Form_peach.LabelTitleApps2.AnchorSideTop.Control:=Form_peach.ShapeTitleAppsb1;
Form_peach.ShapeTitleAppsb1.visible:=true;
Form_peach.ShapeTitleAppsb2.visible:=true;
FormPM.LabelTitlepm1.AnchorSideTop.Control:=FormPM.ShapeTitlePMb1;
FormPM.LabelTitlepm2.AnchorSideTop.Control:=FormPM.ShapeTitlePMb1;
FormPM.ShapeTitlePMb1.visible:=true;
FormPM.ShapeTitlePMb2.visible:=true;
Form_gwrap.LabelTitle1.AnchorSideTop.Control:=Form_gwrap.ShapeTitleb1;
Form_gwrap.LabelTitle2.AnchorSideTop.Control:=Form_gwrap.ShapeTitleb1;
Form_gwrap.LabelTitle3.AnchorSideTop.Control:=Form_gwrap.ShapeTitleb1;
Form_gwrap.LabelTitle4.AnchorSideTop.Control:=Form_gwrap.ShapeTitleb1;
Form_gwrap.ShapeTitleb1.visible:=true;
Form_gwrap.ShapeTitleb2.visible:=true;
Form_gwrap.ShapeTitleb3.visible:=true;
Form_gwrap.ShapeTitleb4.visible:=true;
end;
Unit8.alttabstyle:=alttabstyle;
Unit_gwrap.alttabstyle:=alttabstyle;
Unit8.highlighttabs:=highlighttabs;
Unit_gwrap.highlighttabs:=highlighttabs;
end;

procedure set_items_height;
var
   refsize:integer;
begin
with Form_peach do
begin
//get ratio between autosized button height at runtime and design time, to resize graphics and items with custom heights set at runtime
refsize:=ButtonRefSize.Height;
get_pformscaling(refsize,qscale,qscaleimages);
qscale:=(qscale*pzooming) div 100;
qscaleimages:=(qscaleimages*pzooming) div 100;
//colums sizes
COL1D:=(240*qscale) div 100;
COL2D:=(72*qscale) div 100;
COL3D:=(72*qscale) div 100;
COL4D:=(72*qscale) div 100;
COL5D:=(144*qscale) div 100;
COL6D:=(48*qscale) div 100;
COL7D:=(72*qscale) div 100;
//bars
pbarh:=(8*qscale) div 100;
pbarhsmall:=(4*qscale) div 100;
ShapeProgress.Height:=pbarh;
barheight:=(40*qscale) div 100;
mbarheight:=(48*qscale) div 100;
mmbarheight:=(44*qscale) div 100;
PanelListBar.Height:=barheight;
Bevel20.Height:=((32+ensmall)*qscale) div 100;
BevelTitleOptions1.Height:=barheight;
BevelTitleOptions2.Height:=barheight;
BevelTitleOptions3.Height:=barheight;
BevelTitleOptions4.Height:=barheight;
BevelTitleOptions5.Height:=barheight;
BevelTitleOptions6.Height:=barheight;
BevelTitleOptions7.Height:=barheight;
BevelTitleOptions8.Height:=barheight;
PanelNav5.Height:=barheight;
//tabs
tabheight:=(36*qscale) div 100;
if alttabstyle=2 then tablabelheight:=30
else tablabelheight:=24;
tablabelheight:=(tablabelheight*qscale) div 100;
tabheightl:=(48*qscale) div 100;
PanelBottom.Height:=tabheight;
PanelTitleAdd.Height:=tabheight;
PanelTitleExtract.Height:=tabheight;
PanelTitleApps.Height:=tabheight;
PanelActAdd.Height:=tabheightl;
PanelActExt.Height:=tabheightl;
PanelActDefaults.Height:=tabheightl;
FormPM.PanelTitlePM.Height:=tabheight;
settabsstyled;
//grid
case ensmall of
   0: rowsize:=((16+2+pspacing) * qscale) div 100;
   1: rowsize:=((18+2+pspacing) * qscale) div 100;
   2: rowsize:=((20+2+pspacing) * qscale) div 100;
   3: rowsize:=((24+2+pspacing) * qscale) div 100;
   4: rowsize:=((28+2+pspacing) * qscale) div 100;
   5: rowsize:=((32+2+pspacing) * qscale) div 100;
   end;
intcellhw:=((1+(pspacing div 2)) * qscale) div 100;
StringGrid1.DefaultRowHeight:=rowsize;
StringGrid2.DefaultRowHeight:=rowsize;
StringGridSessionHistory.DefaultRowHeight:=rowsize;
StringGridBookmarks.DefaultRowHeight:=rowsize;
StringGridClipboard.DefaultRowHeight:=rowsize;
StringGridCustEdit.DefaultRowHeight:=rowsize;
StringGridCustEdit1.DefaultRowHeight:=rowsize;
StringGridRecent.DefaultRowHeight:=rowsize;
FormPM.StringGridPM.DefaultRowHeight:=rowsize;
FormPM.StringGridPM1.DefaultRowHeight:=rowsize;
//panels
Panelnav4.Width:=(48*qscale) div 100;//48
//graphics
case ensmall of
   0: icon_sizeplus:=((16+pspacing) * qscaleimages) div 100;
   1: icon_sizeplus:=((18+pspacing) * qscaleimages) div 100;
   2: icon_sizeplus:=((20+pspacing) * qscaleimages) div 100;
   3: icon_sizeplus:=((24+pspacing) * qscaleimages) div 100;
   4: icon_sizeplus:=((28+pspacing) * qscaleimages) div 100;
   5: icon_sizeplus:=((32+pspacing) * qscaleimages) div 100;
   end;
il16 := TimageList.Create(owner);
il16.Height:=icon_sizeplus;
il16.Width:=icon_sizeplus;
ListView1.SmallImages:=il16;
ilsmall := TimageList.Create(owner);
ilsmall.Height:=icon_sizeplus;
ilsmall.Width:=icon_sizeplus;
ShellTreeView2.Images:=ilsmall;
ShellTreeView1.Images:=ilsmall;
TreeView1.Images:=ilsmall;
TabBar.Images:=ilsmall;
il48 := TimageList.Create(owner);
il48.Height:=((48+pspacing)*qscaleimages) div 100;
il48.Width:=((48+pspacing)*qscaleimages) div 100;
il96 := TimageList.Create(owner);
il96.Height:=((96+pspacing)*qscaleimages) div 100;
il96.Width:=((96+pspacing)*qscaleimages) div 100;
il192 := TimageList.Create(owner);
il192.Height:=((192+pspacing)*qscaleimages) div 100;
il192.Width:=((192+pspacing)*qscaleimages) div 100;
end;
end;

procedure setgridaltcolor;
begin
if usealtcolor=1 then
   begin
   Form_peach.StringGrid1.AlternateColor:=StringToColor(collow);
   Form_peach.StringGrid2.AlternateColor:=StringToColor(collow);
   Form_peach.StringGridCustEdit.AlternateColor:=StringToColor(collow);
   Form_peach.StringGridCustEdit1.AlternateColor:=StringToColor(collow);
   Form_peach.StringGridRecent.AlternateColor:=StringToColor(collow);
   Form_peach.StringGridSessionHistory.AlternateColor:=StringToColor(collow);
   Form_peach.StringGridBookmarks.AlternateColor:=StringToColor(collow);
   Form_peach.StringGridClipboard.AlternateColor:=StringToColor(collow);
   end
else
   begin
   Form_peach.StringGrid1.AlternateColor:=StringToColor(color2);
   Form_peach.StringGrid2.AlternateColor:=StringToColor(color2);
   Form_peach.StringGridCustEdit.AlternateColor:=StringToColor(color2);
   Form_peach.StringGridCustEdit1.AlternateColor:=StringToColor(color2);
   Form_peach.StringGridRecent.AlternateColor:=StringToColor(color2);
   Form_peach.StringGridSessionHistory.AlternateColor:=StringToColor(color2);
   Form_peach.StringGridBookmarks.AlternateColor:=StringToColor(color2);
   Form_peach.StringGridClipboard.AlternateColor:=StringToColor(color2);
   end;
end;

procedure settabaltcolor;
var tabcol,tabcol2:tcolor;
begin
case highlighttabs of
   0: begin
      tabcol:=StringToColor(color2);
      tabcol2:=StringToColor(color2);
      tabpencol:=StringToColor(color2);
      tabbrushcol:=StringToColor(colmid);
      tabbrushhighcol:=StringToColor(colvlow);
      end;
   1: begin
      tabcol:=StringToColor(color2);
      tabcol2:=StringToColor(color2);
      tabpencol:=StringToColor(color2);
      tabbrushcol:=pvvlblue;
      tabbrushhighcol:=pvvvlblue;
      end;
   2: begin
      tabcol:=StringToColor(collow);
      tabcol2:=StringToColor(colvlow);
      tabpencol:=StringToColor(collow);
      tabbrushcol:=StringToColor(colmid);
      tabbrushhighcol:=StringToColor(colvlow);
      end;
   3: begin
      tabcol:=StringToColor(colmid);
      tabcol2:=StringToColor(collow);
      tabpencol:=StringToColor(colmid);
      tabbrushcol:=StringToColor(colhigh);
      tabbrushhighcol:=StringToColor(collow);
      end;
   4: begin
      tabcol:=pvvvlblue;
      tabcol2:=pvvvvlblue;
      tabpencol:=pvvvlblue;
      tabbrushcol:=pvvlblue;
      tabbrushhighcol:=pvvvvlblue;
      end;
   5: begin
      tabcol:=pvvlblue;
      tabcol2:=pvvvlblue;
      tabpencol:=pvvlblue;
      tabbrushcol:=pvlblue;
      tabbrushhighcol:=pvvvlblue;
      end;
   end;
Form_peach.PanelTitleOptions.Color:=tabcol;
Form_peach.PanelTitleAdd.Color:=tabcol;
Form_peach.PanelTitleExtract.Color:=tabcol;
Form_peach.PanelTitleApps.Color:=tabcol;
Form_gwrap.PanelTitle.Color:=tabcol;
Unit_gwrap.tabpencol:=tabpencol;
Unit_gwrap.tabbrushcol:=tabbrushcol;
Unit_gwrap.tabbrushhighcol:=tabbrushhighcol;
FormPM.PanelTitlePM.Color:=tabcol;
Unit8.tabpencol:=tabpencol;
Unit8.tabbrushcol:=tabbrushcol;
Unit8.tabbrushhighcol:=tabbrushhighcol;
end;

procedure apply_theme; //apply colors but not opacity
begin
if color3='clForm' then color3:=ColorToString(PTACOL);
getpcolors(stringtocolor(color1),stringtocolor(color2),stringtocolor(color3),temperature);
img_utils.relwindowcolor:=stringtocolor(color2);
Form_peach.Color:=stringtocolor(color2);
//Form_peach.Font.Color:=stringtocolor(color5);
Form_peach.StringGridClipboard.Color:=Form_peach.Color;
FormAdvf.Color:=Form_peach.Color;
FormCrop.Color:=Form_peach.Color;
FormDlg.Color:=Form_peach.Color;
FormImgRes.Color:=Form_peach.Color;
FormInput.Color:=Form_peach.Color;
FormKF.Color:=Form_peach.Color;
FormPaths.Color:=Form_peach.Color;
FormPM.Color:=Form_peach.Color;
FormPW.Color:=Form_peach.Color;
FormSelect.Color:=Form_peach.Color;
FormWeb.Color:=Form_peach.Color;
Form_gwrap.Color:=Form_peach.Color;
Form_peach.Panelnav5.Color:=StringToColor(colbtnhigh);
Form_peach.Splitter2.Color:=StringToColor(colmid);
Form_peach.PanelFileBrowserOptions.Color:=StringToColor(collow);
Form_peach.ShapeThemes.Brush.Color:=StringToColor(collow);
Form_peach.ShapeThemes1.Brush.Color:=StringToColor(collow);
Form_peach.ShapeThemes2.Brush.Color:=StringToColor(collow);
case accenttoolbar of
0: begin
   Form_peach.PanelBarOpen.Color:=Form_peach.Color;
   Form_peach.Panelnav4.Color:=Form_peach.PanelBarOpen.Color;
   Form_peach.Bevel13.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel16.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel12.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel14.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel18.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel11.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel15.Pen.Color:=Form_peach.Splitter2.Color;
   end;
1: begin
   Form_peach.PanelBarOpen.Color:=StringToColor(colvlow);
   Form_peach.Panelnav4.Color:=Form_peach.PanelBarOpen.Color;
   Form_peach.Bevel13.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel16.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel12.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel14.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel18.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel11.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel15.Pen.Color:=Form_peach.Splitter2.Color;
   end;
2: begin
   Form_peach.PanelBarOpen.Color:=StringToColor(collow);
   Form_peach.Panelnav4.Color:=Form_peach.PanelBarOpen.Color;
   Form_peach.Bevel13.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel16.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel12.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel14.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel18.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel11.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.Bevel15.Pen.Color:=Form_peach.Splitter2.Color;
   end;
3: begin
   Form_peach.PanelBarOpen.Color:=StringToColor(colmid);
   Form_peach.Panelnav4.Color:=Form_peach.PanelBarOpen.Color;
   Form_peach.Bevel13.Pen.Color:=StringToColor(colhigh);
   Form_peach.Bevel16.Pen.Color:=StringToColor(colhigh);
   Form_peach.Bevel12.Pen.Color:=StringToColor(colhigh);
   Form_peach.Bevel14.Pen.Color:=StringToColor(colhigh);
   Form_peach.Bevel18.Pen.Color:=StringToColor(colhigh);
   Form_peach.Bevel11.Pen.Color:=StringToColor(colhigh);
   Form_peach.Bevel15.Pen.Color:=StringToColor(colhigh);
   end;
4: begin
   Form_peach.PanelBarOpen.Color:=StringToColor(colhigh);
   Form_peach.Panelnav4.Color:=Form_peach.PanelBarOpen.Color;
   Form_peach.Bevel13.Pen.Color:=StringToColor(colbtnhigh);
   Form_peach.Bevel16.Pen.Color:=StringToColor(colbtnhigh);
   Form_peach.Bevel12.Pen.Color:=StringToColor(colbtnhigh);
   Form_peach.Bevel14.Pen.Color:=StringToColor(colbtnhigh);
   Form_peach.Bevel18.Pen.Color:=StringToColor(colbtnhigh);
   Form_peach.Bevel11.Pen.Color:=StringToColor(colbtnhigh);
   Form_peach.Bevel15.Pen.Color:=StringToColor(colbtnhigh);
   end;
5: begin
   Form_peach.PanelBarOpen.Color:=pvvvvlblue;
   Form_peach.Panelnav4.Color:=pvvvvlblue;
   Form_peach.Bevel13.Pen.Color:=pvvlblue;
   Form_peach.Bevel16.Pen.Color:=pvvlblue;
   Form_peach.Bevel12.Pen.Color:=pvvlblue;
   Form_peach.Bevel14.Pen.Color:=pvvlblue;
   Form_peach.Bevel18.Pen.Color:=pvvlblue;
   Form_peach.Bevel11.Pen.Color:=pvvlblue;
   Form_peach.Bevel15.Pen.Color:=pvvlblue;
   end;
6: begin
   Form_peach.PanelBarOpen.Color:=pvvvlblue;
   Form_peach.Panelnav4.Color:=pvvvlblue;
   Form_peach.Bevel13.Pen.Color:=pvvlblue;
   Form_peach.Bevel16.Pen.Color:=pvvlblue;
   Form_peach.Bevel12.Pen.Color:=pvvlblue;
   Form_peach.Bevel14.Pen.Color:=pvvlblue;
   Form_peach.Bevel18.Pen.Color:=pvvlblue;
   Form_peach.Bevel11.Pen.Color:=pvvlblue;
   Form_peach.Bevel15.Pen.Color:=pvvlblue;
   end;
7: begin
   Form_peach.PanelBarOpen.Color:=pvvlblue;
   Form_peach.Panelnav4.Color:=pvvlblue;
   Form_peach.Bevel13.Pen.Color:=pvlblue;
   Form_peach.Bevel16.Pen.Color:=pvlblue;
   Form_peach.Bevel12.Pen.Color:=pvlblue;
   Form_peach.Bevel14.Pen.Color:=pvlblue;
   Form_peach.Bevel18.Pen.Color:=pvlblue;
   Form_peach.Bevel11.Pen.Color:=pvlblue;
   Form_peach.Bevel15.Pen.Color:=pvlblue;
   end;
8: begin
   Form_peach.PanelBarOpen.Color:=pvlblue;
   Form_peach.Panelnav4.Color:=pvlblue;
   Form_peach.Bevel13.Pen.Color:=plblue;
   Form_peach.Bevel16.Pen.Color:=plblue;
   Form_peach.Bevel12.Pen.Color:=plblue;
   Form_peach.Bevel14.Pen.Color:=plblue;
   Form_peach.Bevel18.Pen.Color:=plblue;
   Form_peach.Bevel11.Pen.Color:=plblue;
   Form_peach.Bevel15.Pen.Color:=plblue;
   end;
end;

case solidaddressstyle of
   0: Form_peach.PanelListbar.Color:=Form_peach.Color;
   1: Form_peach.PanelListbar.Color:=StringToColor(colvlow);
   2: Form_peach.PanelListbar.Color:=StringToColor(collow);
   3: Form_peach.PanelListbar.Color:=StringToColor(colmid);
   4: Form_peach.PanelListbar.Color:=StringToColor(colhigh);
   5: Form_peach.PanelListbar.Color:=pvvvvlblue;
   6: Form_peach.PanelListbar.Color:=pvvvlblue;
   7: Form_peach.PanelListbar.Color:=pvvlblue;
   8: Form_peach.PanelListbar.Color:=pvlblue;
   end;

Form_peach.PanelBottom.Color:=Form_peach.Color;
Form_peach.Splitter1.Color:=Form_peach.Color;
case altaddressstyle of
0: begin
   Form_peach.Bevel20.Brush.Color:=Form_peach.Color;
   Form_peach.ShapeAddress.Brush.Color:=Form_peach.Color;
   Form_peach.Bevel20.Pen.Color:=Form_peach.Splitter2.Color;
   Form_peach.splitsearch.Color:=Form_peach.Splitter2.Color;
   abactivecol:=pvvlblue;
   abarchivecol:=pvlblue;
   end;
1: begin
   Form_peach.Bevel20.Brush.Color:=Form_peach.PanelFileBrowserOptions.Color;
   Form_peach.ShapeAddress.Brush.Color:=Form_peach.PanelFileBrowserOptions.Color;
   Form_peach.Bevel20.Pen.Color:=Form_peach.PanelFileBrowserOptions.Color;
   Form_peach.splitsearch.Color:=StringToColor(colbtnhigh);
   abactivecol:=StringToColor(colmid);
   abarchivecol:=StringToColor(colhigh);
   end;
else
   begin
   Form_peach.Bevel20.Brush.Color:=pvvvlblue;
   Form_peach.ShapeAddress.Brush.Color:=pvvvlblue;
   Form_peach.Bevel20.Pen.Color:=pvvvlblue;
   Form_peach.splitsearch.Color:=plblue;
   abactivecol:=pvvlblue;
   abarchivecol:=pvlblue;
   end
end;

{Form_peach.Bevel20.Shape:=stRectangle; //the old squared look of the address bar
Form_peach.Bevel20.BorderSpacing.Right:=0;
Form_peach.ShapeAddress.BorderSpacing.Left:=2;
Form_peach.ShapeAddress.BorderSpacing.Right:=2;}
case alttabstyle of
   2:
   begin
   Form_peach.PanelTitleExtractTabAlign.AnchorSideLeft.Side:=asrleft;
   Form_peach.PanelTitleAddTabAlign.AnchorSideLeft.Side:=asrleft;
   Form_peach.PanelTitleAppsTabAlign.AnchorSideLeft.Side:=asrleft;
   FormPM.PanelTitlePMTabAlign.AnchorSideLeft.Side:=asrleft;
   Form_gwrap.PanelTitlePLTabAlign.AnchorSideLeft.Side:=asrleft;
   end
   else
   begin
   Form_peach.PanelTitleExtractTabAlign.AnchorSideLeft.Side:=asrCenter;
   Form_peach.PanelTitleAddTabAlign.AnchorSideLeft.Side:=asrCenter;
   Form_peach.PanelTitleAppsTabAlign.AnchorSideLeft.Side:=asrCenter;
   FormPM.PanelTitlePMTabAlign.AnchorSideLeft.Side:=asrCenter;
   Form_gwrap.PanelTitlePLTabAlign.AnchorSideLeft.Side:=asrCenter;
   end;
end;

Form_peach.Splitter3.Color:=Form_peach.Splitter2.Color;
Form_peach.ShapeTitleAddb1.Brush.Color:=StringToColor(collow);
Form_peach.ShapeTitleAddb2.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
Form_peach.ShapeTitleAddb3.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
Form_peach.ShapeTitleAddb4.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
Form_peach.ShapeTitleExtractb1.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
Form_peach.ShapeTitleExtractb2.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
Form_peach.ShapeTitleExtractb3.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
Form_peach.ShapeTitleExtractb4.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
Form_peach.ShapeTitleAppsb1.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
Form_peach.ShapeTitleAppsb2.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
FormPM.ShapeTitlePMb1.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
FormPM.ShapeTitlePMb2.Brush.Color:=Form_peach.ShapeTitleAddb1.Brush.Color;
Unit8.color2:=color2;
Form_peach.BevelTitleOpt1.Color:=Form_peach.Splitter2.Color;
Form_peach.BevelTitleOpt2.Color:=Form_peach.Splitter2.Color;
Form_peach.BevelTitleOpt3.Color:=Form_peach.Splitter2.Color;
Form_peach.BevelTitleOpt4.Color:=Form_peach.Splitter2.Color;
Form_peach.BevelTitleOpt5.Color:=Form_peach.Splitter2.Color;
Form_peach.BevelTitleOpt6.Color:=Form_peach.Splitter2.Color;
Form_peach.BevelTitleOpt7.Color:=Form_peach.Splitter2.Color;
Form_peach.BevelTitleOpt8.Color:=Form_peach.Splitter2.Color;
if lastbar=0 then
   Form_peach.Splitter1.Color:=stringtocolor(color2)
else
   Form_peach.Splitter1.Color:=stringtocolor(colbtnhigh);
update_info;
//grayed fonts
Form_peach.labelStatus.Font.Color:=pGray;
Form_peach.LabelStatusdisplayed.Font.Color:=pGray;
Form_peach.LabelPanelHintAdd.Font.Color:=pGray;
Form_peach.LabelPanelHintExtract.Font.Color:=pGray;
//accent app color fonts
Form_peach.Labelmoreopt.Font.Color:=ptextaccent;
Form_peach.Labelmoreopt1.Font.Color:=ptextaccent;
Form_peach.Lmanageschedule1.Font.Color:=ptextaccent;
Form_peach.Lmanageschedule2.Font.Color:=ptextaccent;
Form_peach.Lmanageschedule3.Font.Color:=ptextaccent;
Form_peach.Lmanageschedule4.Font.Color:=ptextaccent;
Form_peach.LabelStatus5.Font.Color:=ptextaccent;
Form_peach.LabelResetApp1.Font.Color:=ptextaccent;
Form_peach.LabelUpdates.Font.Color:=ptextaccent;
Form_peach.Labelsetwork.Font.Color:=ptextaccent;
Form_peach.LabelDonations.Font.Color:=ptextaccent;
Form_peach.LabelAbout2.Font.Color:=ptextaccent;
Form_peach.themes_download.Font.Color:=ptextaccent;
Form_peach.LabelConfigurePw.Font.Color:=ptextaccent;
Form_peach.LabelConfigurearc.Font.Color:=ptextaccent;
Form_peach.LabelConfigureext.Font.Color:=ptextaccent;
Form_peach.lsetdefaultout_arc.Font.Color:=ptextaccent;
Form_peach.lsetdefaultout_ext.Font.Color:=ptextaccent;
Form_peach.LabelLang2.Font.Color:=ptextaccent;
Form_peach.Labelcb7.Font.Color:=ptextaccent;
Form_peach.LabelResetHistory.Font.Color:=ptextaccent;
Form_peach.LabelResetBookmarks.Font.Color:=ptextaccent;
Form_peach.LabelResetPM.Font.Color:=ptextaccent;
Form_peach.LabelResetPtmp.Font.Color:=ptextaccent;
Form_peach.LabelConfigurePeaZip.Font.Color:=ptextaccent;
Form_peach.Labelcb17.Font.Color:=ptextaccent;
Form_peach.Labelcb19.Font.Color:=ptextaccent;
Form_peach.LabelConf1.Font.Color:=ptextaccent;
Form_peach.Label7.Font.Color:=ptextaccent;
Form_peach.LabelAppPath.Font.Color:=ptextaccent;
Form_peach.LabelConfigureSendTo.Font.Color:=ptextaccent;
Form_peach.themesave_label.Font.Color:=ptextaccent;
Form_peach.LabelDefaultColor1.Font.Color:=ptextaccent;
Form_peach.LabelColPresets.Font.Color:=ptextaccent;
Form_peach.LabelDefaultOpacity.Font.Color:=ptextaccent;
Form_peach.LabelDefaultColor2.Font.Color:=ptextaccent;
Form_peach.Labellightpresets.Font.Color:=ptextaccent;
Form_peach.LabelDefaultColor3.Font.Color:=ptextaccent;
Form_peach.labeltheme.Font.Color:=ptextaccent;
Form_peach.LabelAddFiles.Font.Color:=ptextaccent;
Form_peach.LabelAddFolder.Font.Color:=ptextaccent;
FormPW.LableListPath2.Font.Color:=ptextaccent;
FormPM.Button1.Font.Color:=ptextaccent;
FormPM.Button2.Font.Color:=ptextaccent;
FormInput.LabelLow.Font.Color:=ptextaccent;
FormInput.LabelUp.Font.Color:=ptextaccent;
FormInput.LabelTimestamp.Font.Color:=ptextaccent;
FormInput.Labelappdirn.Font.Color:=ptextaccent;
FormInput.Labelprepdirn.Font.Color:=ptextaccent;
FormInput.Labelrenamereset.Font.Color:=ptextaccent;
FormSelect.Label1.Font.Color:=ptextaccent;
FormSelect.Label3.Font.Color:=ptextaccent;
FormSelect.Label5.Font.Color:=ptextaccent;
Form_gwrap.LabelWarning1.Font.Color:=ptextaccent;
Form_gwrap.ImageButton2.Font.Color:=ptextaccent;
Form_gwrap.ImageSavePJ.Font.Color:=ptextaccent;
Form_gwrap.l2.Font.Color:=ptextaccent;
Form_gwrap.l4.Font.Color:=ptextaccent;
//PanelDefaults Themes
Form_peach.ColorButton1.Color:=stringtocolor(color1);
Form_peach.ColorButton1.ButtonColor:=stringtocolor(color1);
Form_peach.ColorButton2.Color:=stringtocolor(color2);
Form_peach.ColorButton2.ButtonColor:=stringtocolor(color2);
Form_peach.tbtemperature.Position:=temperature;
Form_peach.ColorButton3.Color:=stringtocolor(color3);
Form_peach.ColorButton3.ButtonColor:=stringtocolor(color3);
case pspacing of
   8: Form_peach.cbspacing.ItemIndex :=1;
   12: Form_peach.cbspacing.ItemIndex :=2;
   16: Form_peach.cbspacing.ItemIndex :=3;
   else Form_peach.cbspacing.ItemIndex :=0;
   end;
case pzooming of
   50: Form_peach.cbzooming.ItemIndex :=0;
   67: Form_peach.cbzooming.ItemIndex :=1;
   80: Form_peach.cbzooming.ItemIndex :=2;
   87: Form_peach.cbzooming.ItemIndex :=3;
   115: Form_peach.cbzooming.ItemIndex :=5;
   125: Form_peach.cbzooming.ItemIndex :=6;
   150: Form_peach.cbzooming.ItemIndex :=7;
   200: Form_peach.cbzooming.ItemIndex :=8;
   else Form_peach.cbzooming.ItemIndex :=4;
   end;
Form_peach.cbensmall.ItemIndex:=ensmall;
if usealtcolor=1 then
   Form_peach.CheckBoxAltgridcol.State:=cbChecked
else
   Form_peach.CheckBoxAltgridcol.State:=cbUnchecked;
Form_peach.CheckBoxAlttabcol.ItemIndex:=highlighttabs;
Form_peach.CheckBoxAccentToolBar.ItemIndex:=accenttoolbar;
Form_peach.CheckBoxAltBar.ItemIndex:=altaddressstyle;
Form_peach.CheckBoxSolidAddress.ItemIndex:=solidaddressstyle;
if toolcentered=1 then
   Form_peach.CheckBoxCenteredToolbar.State:=cbChecked
else
   Form_peach.CheckBoxCenteredToolbar.State:=cbUnchecked;
Form_peach.CheckBoxAltTab.ItemIndex:=alttabstyle;
setgridaltcolor;
settabaltcolor;
load_icons;
if prevpanel='open' then
   begin
   clicklabel_apps(Form_peach.LabelTitleApps1,Form_peach.ShapeTitleAppsb1);
   clicklabel_options(Form_peach.LabelTitleOptions6,Form_peach.BevelTitleOptions6);
   end;
end;

procedure decodebintheming(s: ansistring; var usealtcolor,highlighttabs,accenttoolbar,toolcentered,altaddressstyle,solidaddressstyle,alttabstyle,ensmall:integer);
begin
if length(s)<8 then
   begin
   usealtcolor:=0;
   highlighttabs:=0;
   accenttoolbar:=0;
   toolcentered:=0;
   altaddressstyle:=1;
   solidaddressstyle:=0;
   alttabstyle:=2;
   ensmall:=0;
   end
else
   begin
   usealtcolor:=strtoint(s[1]);//use alternate colors in grids
   highlighttabs:=strtoint(s[2]);//use alternate color for tabs
   accenttoolbar:=strtoint(s[3]);//use accent color in tool bar
   toolcentered:=strtoint(s[4]);//centered tool bar buttons
   altaddressstyle:=strtoint(s[5]);//use alternative address bar style
   solidaddressstyle:=strtoint(s[6]);//solid address bar style
   alttabstyle:=strtoint(s[7]);//use alternative tabs style
   ensmall:=strtoint(s[8]);//enlarge small icons
   end;
end;

procedure readconf_colors;
var
   s:ansistring;
begin
readln(conf,graphicsfolder);
if graphicsfolder[1]='r' then graphicsfolder:='themes'+directoryseparator+DEFAULT_THEME+directoryseparator;
readln(conf,opacity);//opactity
readln(conf,color1);//accent color
readln(conf,color2);//background color, used to derivate grayed colors
readln(conf,color3);//accent text color
readln(conf,color4);//unused
readln(conf,color5);//text, currently unsupported
readln(conf,s); decodebintheming(s,usealtcolor,highlighttabs,accenttoolbar,toolcentered,altaddressstyle,solidaddressstyle,alttabstyle,ensmall);
readln(conf,s); pzooming:=strtoint(s); //icons zooming
readln(conf,s); pspacing:=strtoint(s); //icons spacing
readln(conf,s); temperature:=strtoint(s); //color temperature
set_items_height;
apply_theme;
end;

procedure readconf_default_colors;
var
   s:ansistring;
begin
readln(conf,graphicsfolderd);
dodirseparators(graphicsfolderd);
readln(conf,opacityd);
readln(conf,color1d);
readln(conf,color2d);
readln(conf,color3d);
readln(conf,color4d);
readln(conf,color5d);
readln(conf,s); decodebintheming(s,usealtcolord,highlighttabsd,accenttoolbard,toolcenteredd,altaddressstyled,solidaddressstyled,alttabstyled,ensmalld);
readln(conf,s); pzoomingd:=strtoint(s);
readln(conf,s); pspacingd:=strtoint(s);
readln(conf,s); temperatured:=strtoint(s);
end;

function isawebservice(s:ansistring):boolean;
begin
if (pos('http://',s)=1) or (pos('https://',s)=1) or (pos('www.',s)=1) then
   result:=true
else
   result:=false;
end;

procedure set_ow_custedit_menu;
begin
with Form_peach do
begin
if StringGridCustedit.Cells[1,1]<>'' then owcustom1.Caption:=StringGridCustedit.Cells[1,1]
else
   if extractfilename(custedit1)<>'' then owcustom1.Caption:=extractfilename(custedit1)
   else owcustom1.Caption:=custedit1;
if StringGridCustedit.Cells[1,2]<>'' then owcustom2.Caption:=StringGridCustedit.Cells[1,2]
else
   if extractfilename(custedit2)<>'' then owcustom2.Caption:=extractfilename(custedit2)
   else owcustom2.Caption:=custedit2;
if StringGridCustedit.Cells[1,3]<>'' then owcustom3.Caption:=StringGridCustedit.Cells[1,3]
else
   if extractfilename(custedit3)<>'' then owcustom3.Caption:=extractfilename(custedit3)
   else owcustom3.Caption:=custedit3;
if StringGridCustedit.Cells[1,4]<>'' then owcustom4.Caption:=StringGridCustedit.Cells[1,4]
else
   if extractfilename(custedit4)<>'' then owcustom4.Caption:=extractfilename(custedit4)
   else owcustom4.Caption:=custedit4;
if StringGridCustedit.Cells[1,5]<>'' then owcustom5.Caption:=StringGridCustedit.Cells[1,5]
else
   if extractfilename(custedit5)<>'' then owcustom5.Caption:=extractfilename(custedit5)
   else owcustom5.Caption:=custedit5;
if StringGridCustedit.Cells[1,6]<>'' then owcustom6.Caption:=StringGridCustedit.Cells[1,6]
else
   if extractfilename(custedit6)<>'' then owcustom6.Caption:=extractfilename(custedit6)
   else owcustom6.Caption:=custedit6;
if StringGridCustedit.Cells[1,7]<>'' then owcustom7.Caption:=StringGridCustedit.Cells[1,7]
else
   if extractfilename(custedit7)<>'' then owcustom7.Caption:=extractfilename(custedit7)
   else owcustom7.Caption:=custedit7;
if StringGridCustedit.Cells[1,8]<>'' then owcustom8.Caption:=StringGridCustedit.Cells[1,8]
else
   if extractfilename(custedit8)<>'' then owcustom8.Caption:=extractfilename(custedit8)
   else owcustom8.Caption:=custedit8;
if StringGridCustedit.Cells[1,9]<>'' then owcustom_9.Caption:=StringGridCustedit.Cells[1,9]
else
   if extractfilename(custedit9)<>'' then owcustom_9.Caption:=extractfilename(custedit9)
   else owcustom_9.Caption:=custedit9;
if StringGridCustedit.Cells[1,10]<>'' then owcustom_10.Caption:=StringGridCustedit.Cells[1,10]
else
   if extractfilename(custedit10)<>'' then owcustom_10.Caption:=extractfilename(custedit10)
   else owcustom_10.Caption:=custedit10;
if StringGridCustedit.Cells[1,11]<>'' then owcustom_11.Caption:=StringGridCustedit.Cells[1,11]
else
   if extractfilename(custedit11)<>'' then owcustom_11.Caption:=extractfilename(custedit11)
   else owcustom_11.Caption:=custedit11;
if StringGridCustedit.Cells[1,12]<>'' then owcustom_12.Caption:=StringGridCustedit.Cells[1,12]
else
   if extractfilename(custedit12)<>'' then owcustom_12.Caption:=extractfilename(custedit12)
   else owcustom_12.Caption:=custedit12;
if StringGridCustedit.Cells[1,13]<>'' then owcustom_13.Caption:=StringGridCustedit.Cells[1,13]
else
   if extractfilename(custedit13)<>'' then owcustom_13.Caption:=extractfilename(custedit13)
   else owcustom_13.Caption:=custedit13;
if StringGridCustedit.Cells[1,14]<>'' then owcustom_14.Caption:=StringGridCustedit.Cells[1,14]
else
   if extractfilename(custedit14)<>'' then owcustom_14.Caption:=extractfilename(custedit14)
   else owcustom_14.Caption:=custedit14;
if StringGridCustedit.Cells[1,15]<>'' then owcustom_15.Caption:=StringGridCustedit.Cells[1,15]
else
   if extractfilename(custedit15)<>'' then owcustom_15.Caption:=extractfilename(custedit15)
   else owcustom_15.Caption:=custedit15;
if StringGridCustedit.Cells[1,16]<>'' then owcustom_16.Caption:=StringGridCustedit.Cells[1,16]
else
   if extractfilename(custedit16)<>'' then owcustom_16.Caption:=extractfilename(custedit16)
   else owcustom_16.Caption:=custedit16;
if StringGridCustedit1.Cells[1,1]<>'' then owcustom9.Caption:=StringGridCustedit1.Cells[1,1]
else owcustom9.Caption:=advedit1before+stringdelim('%f')+advedit1after;
if StringGridCustedit1.Cells[1,2]<>'' then owcustom10.Caption:=StringGridCustedit1.Cells[1,2]
else owcustom10.Caption:=advedit2before+stringdelim('%f')+advedit2after;
if StringGridCustedit1.Cells[1,3]<>'' then owcustom11.Caption:=StringGridCustedit1.Cells[1,3]
else owcustom11.Caption:=advedit3before+stringdelim('%f')+advedit3after;
if StringGridCustedit1.Cells[1,4]<>'' then owcustom12.Caption:=StringGridCustedit1.Cells[1,4]
else owcustom12.Caption:=advedit4before+stringdelim('%f')+advedit4after;
if StringGridCustedit1.Cells[1,5]<>'' then owcustom13.Caption:=StringGridCustedit1.Cells[1,5]
else owcustom13.Caption:=advedit5before+stringdelim('%f')+advedit5after;
if StringGridCustedit1.Cells[1,6]<>'' then owcustom14.Caption:=StringGridCustedit1.Cells[1,6]
else owcustom14.Caption:=advedit6before+stringdelim('%f')+advedit6after;
if StringGridCustedit1.Cells[1,7]<>'' then owcustom15.Caption:=StringGridCustedit1.Cells[1,7]
else owcustom15.Caption:=advedit7before+stringdelim('%f')+advedit7after;
if StringGridCustedit1.Cells[1,8]<>'' then owcustom16.Caption:=StringGridCustedit1.Cells[1,8]
else owcustom16.Caption:=advedit8before+stringdelim('%f')+advedit8after;
if custedit1<>'' then owcustom1.visible:=true else owcustom1.visible:=false;
if custedit2<>'' then owcustom2.visible:=true else owcustom2.visible:=false;
if custedit3<>'' then owcustom3.visible:=true else owcustom3.visible:=false;
if custedit4<>'' then owcustom4.visible:=true else owcustom4.visible:=false;
if custedit5<>'' then owcustom5.visible:=true else owcustom5.visible:=false;
if custedit6<>'' then owcustom6.visible:=true else owcustom6.visible:=false;
if custedit7<>'' then owcustom7.visible:=true else owcustom7.visible:=false;
if custedit8<>'' then owcustom8.visible:=true else owcustom8.visible:=false;
if custedit9<>'' then owcustom_9.visible:=true else owcustom_9.visible:=false;
if custedit10<>'' then owcustom_10.visible:=true else owcustom_10.visible:=false;
if custedit11<>'' then owcustom_11.visible:=true else owcustom_11.visible:=false;
if custedit12<>'' then owcustom_12.visible:=true else owcustom_12.visible:=false;
if custedit13<>'' then owcustom_13.visible:=true else owcustom_13.visible:=false;
if custedit14<>'' then owcustom_14.visible:=true else owcustom_14.visible:=false;
if custedit15<>'' then owcustom_15.visible:=true else owcustom_15.visible:=false;
if custedit16<>'' then owcustom_16.visible:=true else owcustom_16.visible:=false;
if advedit1before+advedit1after<>'' then owcustom9.visible:=true else owcustom9.visible:=false;
if advedit2before+advedit2after<>'' then owcustom10.visible:=true else owcustom10.visible:=false;
if advedit3before+advedit3after<>'' then owcustom11.visible:=true else owcustom11.visible:=false;
if advedit4before+advedit4after<>'' then owcustom12.visible:=true else owcustom12.visible:=false;
if advedit5before+advedit5after<>'' then owcustom13.visible:=true else owcustom13.visible:=false;
if advedit6before+advedit6after<>'' then owcustom14.visible:=true else owcustom14.visible:=false;
if advedit7before+advedit7after<>'' then owcustom15.visible:=true else owcustom15.visible:=false;
if advedit8before+advedit8after<>'' then owcustom16.visible:=true else owcustom16.visible:=false;
pmmore1.caption:=owcustom9.caption;
pmmore2.caption:=owcustom10.caption;
pmmore3.caption:=owcustom11.caption;
pmmore4.caption:=owcustom12.caption;
pmmore5.caption:=owcustom13.caption;
pmmore6.caption:=owcustom14.caption;
pmmore7.caption:=owcustom15.caption;
pmmore8.caption:=owcustom16.caption;
pmmore1.visible:=owcustom9.visible;
pmmore2.visible:=owcustom10.visible;
pmmore3.visible:=owcustom11.visible;
pmmore4.visible:=owcustom12.visible;
pmmore5.visible:=owcustom13.visible;
pmmore6.visible:=owcustom14.visible;
pmmore7.visible:=owcustom15.visible;
pmmore8.visible:=owcustom16.visible;
pmapp1.Caption:=owcustom1.Caption;
pmapp1.Visible:=owcustom1.Visible;
pmapp2.Caption:=owcustom2.Caption;
pmapp2.Visible:=owcustom2.Visible;
pmapp3.Caption:=owcustom3.Caption;
pmapp3.Visible:=owcustom3.Visible;
pmapp4.Caption:=owcustom4.Caption;
pmapp4.Visible:=owcustom4.Visible;
pmapp5.Caption:=owcustom5.Caption;
pmapp5.Visible:=owcustom5.Visible;
pmapp6.Caption:=owcustom6.Caption;
pmapp6.Visible:=owcustom6.Visible;
pmapp7.Caption:=owcustom7.Caption;
pmapp7.Visible:=owcustom7.Visible;
pmapp8.Caption:=owcustom8.Caption;
pmapp8.Visible:=owcustom8.Visible;
pmapp9.Caption:=owcustom_9.Caption;
pmapp9.Visible:=owcustom_9.Visible;
pmapp10.Caption:=owcustom_10.Caption;
pmapp10.Visible:=owcustom_10.Visible;
pmapp11.Caption:=owcustom_11.Caption;
pmapp11.Visible:=owcustom_11.Visible;
pmapp12.Caption:=owcustom_12.Caption;
pmapp12.Visible:=owcustom_12.Visible;
pmapp13.Caption:=owcustom_13.Caption;
pmapp13.Visible:=owcustom_13.Visible;
pmapp14.Caption:=owcustom_14.Caption;
pmapp14.Visible:=owcustom_14.Visible;
pmapp15.Caption:=owcustom_15.Caption;
pmapp15.Visible:=owcustom_15.Visible;
pmapp16.Caption:=owcustom_16.Caption;
pmapp16.Visible:=owcustom_16.Visible;
pmappadv1.Caption:=owcustom9.Caption;
pmappadv1.Visible:=owcustom9.Visible;
pmappadv2.Caption:=owcustom10.Caption;
pmappadv2.Visible:=owcustom10.Visible;
pmappadv3.Caption:=owcustom11.Caption;
pmappadv3.Visible:=owcustom11.Visible;
pmappadv4.Caption:=owcustom12.Caption;
pmappadv4.Visible:=owcustom12.Visible;
pmappadv5.Caption:=owcustom13.Caption;
pmappadv5.Visible:=owcustom13.Visible;
pmappadv6.Caption:=owcustom14.Caption;
pmappadv6.Visible:=owcustom14.Visible;
pmappadv7.Caption:=owcustom15.Caption;
pmappadv7.Visible:=owcustom15.Visible;
pmappadv8.Caption:=owcustom16.Caption;
pmappadv8.Visible:=owcustom16.Visible;
end;
end;

procedure set_eow_custedit_menu;
begin
with Form_peach do
begin
if StringGridCustedit.Cells[1,1]<>'' then eowcustom1.Caption:=StringGridCustedit.Cells[1,1]
else
   if extractfilename(custedit1)<>'' then eowcustom1.Caption:=extractfilename(custedit1)
   else eowcustom1.Caption:=custedit1;
if StringGridCustedit.Cells[1,2]<>'' then eowcustom2.Caption:=StringGridCustedit.Cells[1,2]
else
   if extractfilename(custedit2)<>'' then eowcustom2.Caption:=extractfilename(custedit2)
   else eowcustom2.Caption:=custedit2;
if StringGridCustedit.Cells[1,3]<>'' then eowcustom3.Caption:=StringGridCustedit.Cells[1,3]
else
   if extractfilename(custedit3)<>'' then eowcustom3.Caption:=extractfilename(custedit3)
   else eowcustom3.Caption:=custedit3;
if StringGridCustedit.Cells[1,4]<>'' then eowcustom4.Caption:=StringGridCustedit.Cells[1,4]
else
   if extractfilename(custedit4)<>'' then eowcustom4.Caption:=extractfilename(custedit4)
   else eowcustom4.Caption:=custedit4;
if StringGridCustedit.Cells[1,5]<>'' then eowcustom5.Caption:=StringGridCustedit.Cells[1,5]
else
   if extractfilename(custedit5)<>'' then eowcustom5.Caption:=extractfilename(custedit5)
   else eowcustom5.Caption:=custedit5;
if StringGridCustedit.Cells[1,6]<>'' then eowcustom6.Caption:=StringGridCustedit.Cells[1,6]
else
   if extractfilename(custedit6)<>'' then eowcustom6.Caption:=extractfilename(custedit6)
   else eowcustom6.Caption:=custedit6;
if StringGridCustedit.Cells[1,7]<>'' then eowcustom7.Caption:=StringGridCustedit.Cells[1,7]
else
   if extractfilename(custedit7)<>'' then eowcustom7.Caption:=extractfilename(custedit7)
   else eowcustom7.Caption:=custedit7;
if StringGridCustedit.Cells[1,8]<>'' then eowcustom8.Caption:=StringGridCustedit.Cells[1,8]
else
   if extractfilename(custedit8)<>'' then eowcustom8.Caption:=extractfilename(custedit8)
   else eowcustom8.Caption:=custedit8;
if StringGridCustedit.Cells[1,9]<>'' then eowcustom_9.Caption:=StringGridCustedit.Cells[1,9]
else
   if extractfilename(custedit9)<>'' then eowcustom_9.Caption:=extractfilename(custedit9)
   else eowcustom_9.Caption:=custedit9;
if StringGridCustedit.Cells[1,10]<>'' then eowcustom_10.Caption:=StringGridCustedit.Cells[1,10]
else
   if extractfilename(custedit10)<>'' then eowcustom_10.Caption:=extractfilename(custedit10)
   else eowcustom_10.Caption:=custedit10;
if StringGridCustedit.Cells[1,11]<>'' then eowcustom_11.Caption:=StringGridCustedit.Cells[1,11]
else
   if extractfilename(custedit11)<>'' then eowcustom_11.Caption:=extractfilename(custedit11)
   else eowcustom_11.Caption:=custedit11;
if StringGridCustedit.Cells[1,12]<>'' then eowcustom_12.Caption:=StringGridCustedit.Cells[1,12]
else
   if extractfilename(custedit12)<>'' then eowcustom_12.Caption:=extractfilename(custedit12)
   else eowcustom_12.Caption:=custedit12;
if StringGridCustedit.Cells[1,13]<>'' then eowcustom_13.Caption:=StringGridCustedit.Cells[1,13]
else
   if extractfilename(custedit13)<>'' then eowcustom_13.Caption:=extractfilename(custedit13)
   else eowcustom_13.Caption:=custedit13;
if StringGridCustedit.Cells[1,14]<>'' then eowcustom_14.Caption:=StringGridCustedit.Cells[1,14]
else
   if extractfilename(custedit14)<>'' then eowcustom_14.Caption:=extractfilename(custedit14)
   else eowcustom_14.Caption:=custedit14;
if StringGridCustedit.Cells[1,15]<>'' then eowcustom_15.Caption:=StringGridCustedit.Cells[1,15]
else
   if extractfilename(custedit15)<>'' then eowcustom_15.Caption:=extractfilename(custedit15)
   else eowcustom_15.Caption:=custedit15;
if StringGridCustedit.Cells[1,16]<>'' then eowcustom_16.Caption:=StringGridCustedit.Cells[1,16]
else
   if extractfilename(custedit16)<>'' then eowcustom_16.Caption:=extractfilename(custedit16)
   else eowcustom_16.Caption:=custedit16;
if StringGridCustedit1.Cells[1,1]<>'' then eowcustom9.Caption:=StringGridCustedit1.Cells[1,1]
else eowcustom9.Caption:=advedit1before+stringdelim('%f')+advedit1after;
if StringGridCustedit1.Cells[1,2]<>'' then eowcustom10.Caption:=StringGridCustedit1.Cells[1,2]
else eowcustom10.Caption:=advedit2before+stringdelim('%f')+advedit2after;
if StringGridCustedit1.Cells[1,3]<>'' then eowcustom11.Caption:=StringGridCustedit1.Cells[1,3]
else eowcustom11.Caption:=advedit3before+stringdelim('%f')+advedit3after;
if StringGridCustedit1.Cells[1,4]<>'' then eowcustom12.Caption:=StringGridCustedit1.Cells[1,4]
else eowcustom12.Caption:=advedit4before+stringdelim('%f')+advedit4after;
if StringGridCustedit1.Cells[1,5]<>'' then eowcustom13.Caption:=StringGridCustedit1.Cells[1,5]
else eowcustom13.Caption:=advedit5before+stringdelim('%f')+advedit5after;
if StringGridCustedit1.Cells[1,6]<>'' then eowcustom14.Caption:=StringGridCustedit1.Cells[1,6]
else eowcustom14.Caption:=advedit6before+stringdelim('%f')+advedit6after;
if StringGridCustedit1.Cells[1,7]<>'' then eowcustom15.Caption:=StringGridCustedit1.Cells[1,7]
else eowcustom15.Caption:=advedit7before+stringdelim('%f')+advedit7after;
if StringGridCustedit1.Cells[1,8]<>'' then eowcustom16.Caption:=StringGridCustedit1.Cells[1,8]
else eowcustom16.Caption:=advedit8before+stringdelim('%f')+advedit8after;
if custedit1<>'' then eowcustom1.visible:=true else eowcustom1.visible:=false;
if custedit2<>'' then eowcustom2.visible:=true else eowcustom2.visible:=false;
if custedit3<>'' then eowcustom3.visible:=true else eowcustom3.visible:=false;
if custedit4<>'' then eowcustom4.visible:=true else eowcustom4.visible:=false;
if custedit5<>'' then eowcustom5.visible:=true else eowcustom5.visible:=false;
if custedit6<>'' then eowcustom6.visible:=true else eowcustom6.visible:=false;
if custedit7<>'' then eowcustom7.visible:=true else eowcustom7.visible:=false;
if custedit8<>'' then eowcustom8.visible:=true else eowcustom8.visible:=false;
if custedit9<>'' then eowcustom_9.visible:=true else eowcustom_9.visible:=false;
if custedit10<>'' then eowcustom_10.visible:=true else eowcustom_10.visible:=false;
if custedit11<>'' then eowcustom_11.visible:=true else eowcustom_11.visible:=false;
if custedit12<>'' then eowcustom_12.visible:=true else eowcustom_12.visible:=false;
if custedit13<>'' then eowcustom_13.visible:=true else eowcustom_13.visible:=false;
if custedit14<>'' then eowcustom_14.visible:=true else eowcustom_14.visible:=false;
if custedit15<>'' then eowcustom_15.visible:=true else eowcustom_15.visible:=false;
if custedit16<>'' then eowcustom_16.visible:=true else eowcustom_16.visible:=false;
if advedit1before+advedit1after<>'' then eowcustom9.visible:=true else eowcustom9.visible:=false;
if advedit2before+advedit2after<>'' then eowcustom10.visible:=true else eowcustom10.visible:=false;
if advedit3before+advedit3after<>'' then eowcustom11.visible:=true else eowcustom11.visible:=false;
if advedit4before+advedit4after<>'' then eowcustom12.visible:=true else eowcustom12.visible:=false;
if advedit5before+advedit5after<>'' then eowcustom13.visible:=true else eowcustom13.visible:=false;
if advedit6before+advedit6after<>'' then eowcustom14.visible:=true else eowcustom14.visible:=false;
if advedit7before+advedit7after<>'' then eowcustom15.visible:=true else eowcustom15.visible:=false;
if advedit8before+advedit8after<>'' then eowcustom16.visible:=true else eowcustom16.visible:=false;
end;
end;

procedure set_pow_custedit_menu;
begin
with Form_peach do
begin
if StringGridCustedit.Cells[1,1]<>'' then powcustom1.Caption:=StringGridCustedit.Cells[1,1]
else
   if extractfilename(custedit1)<>'' then powcustom1.Caption:=extractfilename(custedit1)
   else powcustom1.Caption:=custedit1;
if StringGridCustedit.Cells[1,2]<>'' then powcustom2.Caption:=StringGridCustedit.Cells[1,2]
else
   if extractfilename(custedit2)<>'' then powcustom2.Caption:=extractfilename(custedit2)
   else powcustom2.Caption:=custedit2;
if StringGridCustedit.Cells[1,3]<>'' then powcustom3.Caption:=StringGridCustedit.Cells[1,3]
else
   if extractfilename(custedit3)<>'' then powcustom3.Caption:=extractfilename(custedit3)
   else powcustom3.Caption:=custedit3;
if StringGridCustedit.Cells[1,4]<>'' then powcustom4.Caption:=StringGridCustedit.Cells[1,4]
else
   if extractfilename(custedit4)<>'' then powcustom4.Caption:=extractfilename(custedit4)
   else powcustom4.Caption:=custedit4;
if StringGridCustedit.Cells[1,5]<>'' then powcustom5.Caption:=StringGridCustedit.Cells[1,5]
else
   if extractfilename(custedit5)<>'' then powcustom5.Caption:=extractfilename(custedit5)
   else powcustom5.Caption:=custedit5;
if StringGridCustedit.Cells[1,6]<>'' then powcustom6.Caption:=StringGridCustedit.Cells[1,6]
else
   if extractfilename(custedit6)<>'' then powcustom6.Caption:=extractfilename(custedit6)
   else powcustom6.Caption:=custedit6;
if StringGridCustedit.Cells[1,7]<>'' then powcustom7.Caption:=StringGridCustedit.Cells[1,7]
else
   if extractfilename(custedit7)<>'' then powcustom7.Caption:=extractfilename(custedit7)
   else powcustom7.Caption:=custedit7;
if StringGridCustedit.Cells[1,8]<>'' then powcustom8.Caption:=StringGridCustedit.Cells[1,8]
else
   if extractfilename(custedit8)<>'' then powcustom8.Caption:=extractfilename(custedit8)
   else powcustom8.Caption:=custedit8;
if StringGridCustedit.Cells[1,9]<>'' then powcustom_9.Caption:=StringGridCustedit.Cells[1,9]
else
   if extractfilename(custedit9)<>'' then powcustom_9.Caption:=extractfilename(custedit9)
   else powcustom_9.Caption:=custedit9;
if StringGridCustedit.Cells[1,10]<>'' then powcustom_10.Caption:=StringGridCustedit.Cells[1,10]
else
   if extractfilename(custedit10)<>'' then powcustom_10.Caption:=extractfilename(custedit10)
   else powcustom_10.Caption:=custedit10;
if StringGridCustedit.Cells[1,11]<>'' then powcustom_11.Caption:=StringGridCustedit.Cells[1,11]
else
   if extractfilename(custedit11)<>'' then powcustom_11.Caption:=extractfilename(custedit11)
   else powcustom_11.Caption:=custedit11;
if StringGridCustedit.Cells[1,12]<>'' then powcustom_12.Caption:=StringGridCustedit.Cells[1,12]
else
   if extractfilename(custedit12)<>'' then powcustom_12.Caption:=extractfilename(custedit12)
   else powcustom_12.Caption:=custedit12;
if StringGridCustedit.Cells[1,13]<>'' then powcustom_13.Caption:=StringGridCustedit.Cells[1,13]
else
   if extractfilename(custedit13)<>'' then powcustom_13.Caption:=extractfilename(custedit13)
   else powcustom_13.Caption:=custedit13;
if StringGridCustedit.Cells[1,14]<>'' then powcustom_14.Caption:=StringGridCustedit.Cells[1,14]
else
   if extractfilename(custedit14)<>'' then powcustom_14.Caption:=extractfilename(custedit14)
   else powcustom_14.Caption:=custedit14;
if StringGridCustedit.Cells[1,15]<>'' then powcustom_15.Caption:=StringGridCustedit.Cells[1,15]
else
   if extractfilename(custedit15)<>'' then powcustom_15.Caption:=extractfilename(custedit15)
   else powcustom_15.Caption:=custedit15;
if StringGridCustedit.Cells[1,16]<>'' then powcustom_16.Caption:=StringGridCustedit.Cells[1,16]
else
   if extractfilename(custedit16)<>'' then powcustom_16.Caption:=extractfilename(custedit16)
   else powcustom_16.Caption:=custedit16;
if StringGridCustedit1.Cells[1,1]<>'' then powcustom9.Caption:=StringGridCustedit1.Cells[1,1]
else powcustom9.Caption:=advedit1before+stringdelim('%f')+advedit1after;
if StringGridCustedit1.Cells[1,2]<>'' then powcustom10.Caption:=StringGridCustedit1.Cells[1,2]
else powcustom10.Caption:=advedit2before+stringdelim('%f')+advedit2after;
if StringGridCustedit1.Cells[1,3]<>'' then powcustom11.Caption:=StringGridCustedit1.Cells[1,3]
else powcustom11.Caption:=advedit3before+stringdelim('%f')+advedit3after;
if StringGridCustedit1.Cells[1,4]<>'' then powcustom12.Caption:=StringGridCustedit1.Cells[1,4]
else powcustom12.Caption:=advedit4before+stringdelim('%f')+advedit4after;
if StringGridCustedit1.Cells[1,5]<>'' then powcustom13.Caption:=StringGridCustedit1.Cells[1,5]
else powcustom13.Caption:=advedit5before+stringdelim('%f')+advedit5after;
if StringGridCustedit1.Cells[1,6]<>'' then powcustom14.Caption:=StringGridCustedit1.Cells[1,6]
else powcustom14.Caption:=advedit6before+stringdelim('%f')+advedit6after;
if StringGridCustedit1.Cells[1,7]<>'' then powcustom15.Caption:=StringGridCustedit1.Cells[1,7]
else powcustom15.Caption:=advedit7before+stringdelim('%f')+advedit7after;
if StringGridCustedit1.Cells[1,8]<>'' then powcustom16.Caption:=StringGridCustedit1.Cells[1,8]
else powcustom16.Caption:=advedit8before+stringdelim('%f')+advedit8after;
if custedit1<>'' then powcustom1.visible:=true else powcustom1.visible:=false;
if custedit2<>'' then powcustom2.visible:=true else powcustom2.visible:=false;
if custedit3<>'' then powcustom3.visible:=true else powcustom3.visible:=false;
if custedit4<>'' then powcustom4.visible:=true else powcustom4.visible:=false;
if custedit5<>'' then powcustom5.visible:=true else powcustom5.visible:=false;
if custedit6<>'' then powcustom6.visible:=true else powcustom6.visible:=false;
if custedit7<>'' then powcustom7.visible:=true else powcustom7.visible:=false;
if custedit8<>'' then powcustom8.visible:=true else powcustom8.visible:=false;
if custedit9<>'' then powcustom_9.visible:=true else powcustom_9.visible:=false;
if custedit10<>'' then powcustom_10.visible:=true else powcustom_10.visible:=false;
if custedit11<>'' then powcustom_11.visible:=true else powcustom_11.visible:=false;
if custedit12<>'' then powcustom_12.visible:=true else powcustom_12.visible:=false;
if custedit13<>'' then powcustom_13.visible:=true else powcustom_13.visible:=false;
if custedit14<>'' then powcustom_14.visible:=true else powcustom_14.visible:=false;
if custedit15<>'' then powcustom_15.visible:=true else powcustom_15.visible:=false;
if custedit16<>'' then powcustom_16.visible:=true else powcustom_16.visible:=false;
if advedit1before+advedit1after<>'' then powcustom9.visible:=true else powcustom9.visible:=false;
if advedit2before+advedit2after<>'' then powcustom10.visible:=true else powcustom10.visible:=false;
if advedit3before+advedit3after<>'' then powcustom11.visible:=true else powcustom11.visible:=false;
if advedit4before+advedit4after<>'' then powcustom12.visible:=true else powcustom12.visible:=false;
if advedit5before+advedit5after<>'' then powcustom13.visible:=true else powcustom13.visible:=false;
if advedit6before+advedit6after<>'' then powcustom14.visible:=true else powcustom14.visible:=false;
if advedit7before+advedit7after<>'' then powcustom15.visible:=true else powcustom15.visible:=false;
if advedit8before+advedit8after<>'' then powcustom16.visible:=true else powcustom16.visible:=false;
end;
end;

procedure set_aow_custedit_menu;
begin
with Form_peach do
begin
if StringGridCustedit.Cells[1,1]<>'' then aowcustom1.Caption:=StringGridCustedit.Cells[1,1]
else
   if extractfilename(custedit1)<>'' then aowcustom1.Caption:=extractfilename(custedit1)
   else aowcustom1.Caption:=custedit1;
if StringGridCustedit.Cells[1,2]<>'' then aowcustom2.Caption:=StringGridCustedit.Cells[1,2]
else
   if extractfilename(custedit2)<>'' then aowcustom2.Caption:=extractfilename(custedit2)
   else aowcustom2.Caption:=custedit2;
if StringGridCustedit.Cells[1,3]<>'' then aowcustom3.Caption:=StringGridCustedit.Cells[1,3]
else
   if extractfilename(custedit3)<>'' then aowcustom3.Caption:=extractfilename(custedit3)
   else aowcustom3.Caption:=custedit3;
if StringGridCustedit.Cells[1,4]<>'' then aowcustom4.Caption:=StringGridCustedit.Cells[1,4]
else
   if extractfilename(custedit4)<>'' then aowcustom4.Caption:=extractfilename(custedit4)
   else aowcustom4.Caption:=custedit4;
if StringGridCustedit.Cells[1,5]<>'' then aowcustom5.Caption:=StringGridCustedit.Cells[1,5]
else
   if extractfilename(custedit5)<>'' then aowcustom5.Caption:=extractfilename(custedit5)
   else aowcustom5.Caption:=custedit5;
if StringGridCustedit.Cells[1,6]<>'' then aowcustom6.Caption:=StringGridCustedit.Cells[1,6]
else
   if extractfilename(custedit6)<>'' then aowcustom6.Caption:=extractfilename(custedit6)
   else aowcustom6.Caption:=custedit6;
if StringGridCustedit.Cells[1,7]<>'' then aowcustom7.Caption:=StringGridCustedit.Cells[1,7]
else
   if extractfilename(custedit7)<>'' then aowcustom7.Caption:=extractfilename(custedit7)
   else aowcustom7.Caption:=custedit7;
if StringGridCustedit.Cells[1,8]<>'' then aowcustom8.Caption:=StringGridCustedit.Cells[1,8]
else
   if extractfilename(custedit8)<>'' then aowcustom8.Caption:=extractfilename(custedit8)
   else aowcustom8.Caption:=custedit8;
if StringGridCustedit.Cells[1,9]<>'' then aowcustom_9.Caption:=StringGridCustedit.Cells[1,9]
else
   if extractfilename(custedit9)<>'' then aowcustom_9.Caption:=extractfilename(custedit9)
   else aowcustom_9.Caption:=custedit9;
if StringGridCustedit.Cells[1,10]<>'' then aowcustom_10.Caption:=StringGridCustedit.Cells[1,10]
else
   if extractfilename(custedit10)<>'' then aowcustom_10.Caption:=extractfilename(custedit10)
   else aowcustom_10.Caption:=custedit10;
if StringGridCustedit.Cells[1,11]<>'' then aowcustom_11.Caption:=StringGridCustedit.Cells[1,11]
else
   if extractfilename(custedit11)<>'' then aowcustom_11.Caption:=extractfilename(custedit11)
   else aowcustom_11.Caption:=custedit11;
if StringGridCustedit.Cells[1,12]<>'' then aowcustom_12.Caption:=StringGridCustedit.Cells[1,12]
else
   if extractfilename(custedit12)<>'' then aowcustom_12.Caption:=extractfilename(custedit12)
   else aowcustom_12.Caption:=custedit12;
if StringGridCustedit.Cells[1,13]<>'' then aowcustom_13.Caption:=StringGridCustedit.Cells[1,13]
else
   if extractfilename(custedit13)<>'' then aowcustom_13.Caption:=extractfilename(custedit13)
   else aowcustom_13.Caption:=custedit13;
if StringGridCustedit.Cells[1,14]<>'' then aowcustom_14.Caption:=StringGridCustedit.Cells[1,14]
else
   if extractfilename(custedit14)<>'' then aowcustom_14.Caption:=extractfilename(custedit14)
   else aowcustom_14.Caption:=custedit14;
if StringGridCustedit.Cells[1,15]<>'' then aowcustom_15.Caption:=StringGridCustedit.Cells[1,15]
else
   if extractfilename(custedit15)<>'' then aowcustom_15.Caption:=extractfilename(custedit15)
   else aowcustom_15.Caption:=custedit15;
if StringGridCustedit.Cells[1,16]<>'' then aowcustom_16.Caption:=StringGridCustedit.Cells[1,16]
else
   if extractfilename(custedit16)<>'' then aowcustom_16.Caption:=extractfilename(custedit16)
   else aowcustom_16.Caption:=custedit16;
if StringGridCustedit1.Cells[1,1]<>'' then aowcustom9.Caption:=StringGridCustedit1.Cells[1,1]
else aowcustom9.Caption:=advedit1before+stringdelim('%f')+advedit1after;
if StringGridCustedit1.Cells[1,2]<>'' then aowcustom10.Caption:=StringGridCustedit1.Cells[1,2]
else aowcustom10.Caption:=advedit2before+stringdelim('%f')+advedit2after;
if StringGridCustedit1.Cells[1,3]<>'' then aowcustom11.Caption:=StringGridCustedit1.Cells[1,3]
else aowcustom11.Caption:=advedit3before+stringdelim('%f')+advedit3after;
if StringGridCustedit1.Cells[1,4]<>'' then aowcustom12.Caption:=StringGridCustedit1.Cells[1,4]
else aowcustom12.Caption:=advedit4before+stringdelim('%f')+advedit4after;
if StringGridCustedit1.Cells[1,5]<>'' then aowcustom13.Caption:=StringGridCustedit1.Cells[1,5]
else aowcustom13.Caption:=advedit5before+stringdelim('%f')+advedit5after;
if StringGridCustedit1.Cells[1,6]<>'' then aowcustom14.Caption:=StringGridCustedit1.Cells[1,6]
else aowcustom14.Caption:=advedit6before+stringdelim('%f')+advedit6after;
if StringGridCustedit1.Cells[1,7]<>'' then aowcustom15.Caption:=StringGridCustedit1.Cells[1,7]
else aowcustom15.Caption:=advedit7before+stringdelim('%f')+advedit7after;
if StringGridCustedit1.Cells[1,8]<>'' then aowcustom16.Caption:=StringGridCustedit1.Cells[1,8]
else aowcustom16.Caption:=advedit8before+stringdelim('%f')+advedit8after;
if custedit1<>'' then aowcustom1.visible:=true else aowcustom1.visible:=false;
if custedit2<>'' then aowcustom2.visible:=true else aowcustom2.visible:=false;
if custedit3<>'' then aowcustom3.visible:=true else aowcustom3.visible:=false;
if custedit4<>'' then aowcustom4.visible:=true else aowcustom4.visible:=false;
if custedit5<>'' then aowcustom5.visible:=true else aowcustom5.visible:=false;
if custedit6<>'' then aowcustom6.visible:=true else aowcustom6.visible:=false;
if custedit7<>'' then aowcustom7.visible:=true else aowcustom7.visible:=false;
if custedit8<>'' then aowcustom8.visible:=true else aowcustom8.visible:=false;
if custedit9<>'' then aowcustom_9.visible:=true else aowcustom_9.visible:=false;
if custedit10<>'' then aowcustom_10.visible:=true else aowcustom_10.visible:=false;
if custedit11<>'' then aowcustom_11.visible:=true else aowcustom_11.visible:=false;
if custedit12<>'' then aowcustom_12.visible:=true else aowcustom_12.visible:=false;
if custedit13<>'' then aowcustom_13.visible:=true else aowcustom_13.visible:=false;
if custedit14<>'' then aowcustom_14.visible:=true else aowcustom_14.visible:=false;
if custedit15<>'' then aowcustom_15.visible:=true else aowcustom_15.visible:=false;
if custedit16<>'' then aowcustom_16.visible:=true else aowcustom_16.visible:=false;
if advedit1before+advedit1after<>'' then aowcustom9.visible:=true else aowcustom9.visible:=false;
if advedit2before+advedit2after<>'' then aowcustom10.visible:=true else aowcustom10.visible:=false;
if advedit3before+advedit3after<>'' then aowcustom11.visible:=true else aowcustom11.visible:=false;
if advedit4before+advedit4after<>'' then aowcustom12.visible:=true else aowcustom12.visible:=false;
if advedit5before+advedit5after<>'' then aowcustom13.visible:=true else aowcustom13.visible:=false;
if advedit6before+advedit6after<>'' then aowcustom14.visible:=true else aowcustom14.visible:=false;
if advedit7before+advedit7after<>'' then aowcustom15.visible:=true else aowcustom15.visible:=false;
if advedit8before+advedit8after<>'' then aowcustom16.visible:=true else aowcustom16.visible:=false;
if advedit1before+advedit2before+advedit3before+advedit4before+advedit5before+advedit6before+advedit7before+advedit8before+
   advedit1after+advedit2after+advedit3after+advedit4after+advedit5after+advedit6after+advedit7after+advedit8after<>'' then aowseparator2.visible:=true else aowseparator2.visible:=false;
end;
end;

procedure set_custedit_menus;
begin
set_ow_custedit_menu;
set_eow_custedit_menu;
set_pow_custedit_menu;
set_aow_custedit_menu;
populatetree;
end;

procedure set_custedit_fromtable;
begin
with form_peach do
begin
custedit1:=StringGridCustedit.Cells[2,1];
custedit2:=StringGridCustedit.Cells[2,2];
custedit3:=StringGridCustedit.Cells[2,3];
custedit4:=StringGridCustedit.Cells[2,4];
custedit5:=StringGridCustedit.Cells[2,5];
custedit6:=StringGridCustedit.Cells[2,6];
custedit7:=StringGridCustedit.Cells[2,7];
custedit8:=StringGridCustedit.Cells[2,8];
custedit9:=StringGridCustedit.Cells[2,9];
custedit10:=StringGridCustedit.Cells[2,10];
custedit11:=StringGridCustedit.Cells[2,11];
custedit12:=StringGridCustedit.Cells[2,12];
custedit13:=StringGridCustedit.Cells[2,13];
custedit14:=StringGridCustedit.Cells[2,14];
custedit15:=StringGridCustedit.Cells[2,15];
custedit16:=StringGridCustedit.Cells[2,16];
advedit1before:=StringGridCustedit1.Cells[2,1];
advedit2before:=StringGridCustedit1.Cells[2,2];
advedit3before:=StringGridCustedit1.Cells[2,3];
advedit4before:=StringGridCustedit1.Cells[2,4];
advedit5before:=StringGridCustedit1.Cells[2,5];
advedit6before:=StringGridCustedit1.Cells[2,6];
advedit7before:=StringGridCustedit1.Cells[2,7];
advedit8before:=StringGridCustedit1.Cells[2,8];
advedit1after:=StringGridCustedit1.Cells[3,1];
advedit2after:=StringGridCustedit1.Cells[3,2];
advedit3after:=StringGridCustedit1.Cells[3,3];
advedit4after:=StringGridCustedit1.Cells[3,4];
advedit5after:=StringGridCustedit1.Cells[3,5];
advedit6after:=StringGridCustedit1.Cells[3,6];
advedit7after:=StringGridCustedit1.Cells[3,7];
advedit8after:=StringGridCustedit1.Cells[3,8];
advedit1alt:=StringGridCustedit1.Cells[4,1];
advedit2alt:=StringGridCustedit1.Cells[4,2];
advedit3alt:=StringGridCustedit1.Cells[4,3];
advedit4alt:=StringGridCustedit1.Cells[4,4];
advedit5alt:=StringGridCustedit1.Cells[4,5];
advedit6alt:=StringGridCustedit1.Cells[4,6];
advedit7alt:=StringGridCustedit1.Cells[4,7];
advedit8alt:=StringGridCustedit1.Cells[4,8];
end;
end;

procedure set_custedit_totable;
begin
with form_peach do
begin
StringGridCustedit.Cells[2,1]:=custedit1;
StringGridCustedit.Cells[2,2]:=custedit2;
StringGridCustedit.Cells[2,3]:=custedit3;
StringGridCustedit.Cells[2,4]:=custedit4;
StringGridCustedit.Cells[2,5]:=custedit5;
StringGridCustedit.Cells[2,6]:=custedit6;
StringGridCustedit.Cells[2,7]:=custedit7;
StringGridCustedit.Cells[2,8]:=custedit8;
StringGridCustedit.Cells[2,9]:=custedit9;
StringGridCustedit.Cells[2,10]:=custedit10;
StringGridCustedit.Cells[2,11]:=custedit11;
StringGridCustedit.Cells[2,12]:=custedit12;
StringGridCustedit.Cells[2,13]:=custedit13;
StringGridCustedit.Cells[2,14]:=custedit14;
StringGridCustedit.Cells[2,15]:=custedit15;
StringGridCustedit.Cells[2,16]:=custedit16;
StringGridCustedit.AutoSizeColumns;
StringGridCustedit1.Cells[2,1]:=advedit1before;
StringGridCustedit1.Cells[2,2]:=advedit2before;
StringGridCustedit1.Cells[2,3]:=advedit3before;
StringGridCustedit1.Cells[2,4]:=advedit4before;
StringGridCustedit1.Cells[2,5]:=advedit5before;
StringGridCustedit1.Cells[2,6]:=advedit6before;
StringGridCustedit1.Cells[2,7]:=advedit7before;
StringGridCustedit1.Cells[2,8]:=advedit8before;
StringGridCustedit1.Cells[3,1]:=advedit1after;
StringGridCustedit1.Cells[3,2]:=advedit2after;
StringGridCustedit1.Cells[3,3]:=advedit3after;
StringGridCustedit1.Cells[3,4]:=advedit4after;
StringGridCustedit1.Cells[3,5]:=advedit5after;
StringGridCustedit1.Cells[3,6]:=advedit6after;
StringGridCustedit1.Cells[3,7]:=advedit7after;
StringGridCustedit1.Cells[3,8]:=advedit8after;
StringGridCustedit1.Cells[4,1]:=advedit1alt;
StringGridCustedit1.Cells[4,2]:=advedit2alt;
StringGridCustedit1.Cells[4,3]:=advedit3alt;
StringGridCustedit1.Cells[4,4]:=advedit4alt;
StringGridCustedit1.Cells[4,5]:=advedit5alt;
StringGridCustedit1.Cells[4,6]:=advedit6alt;
StringGridCustedit1.Cells[4,7]:=advedit7alt;
StringGridCustedit1.Cells[4,8]:=advedit8alt;
StringGridCustedit1.AutoSizeColumns;
end;
end;

function check7zvolume(s:ansistring):boolean;
begin
check7zvolume:=false;
if length(s)>=4 then
   if copy(s,1,4)='\\.\' then check7zvolume:=true;
end;

function checkUNCpath(s:ansistring):boolean;
begin
checkUNCpath:=false;
if length(s)>=2 then
   if copy(s,1,2)=DirectorySeparator+DirectorySeparator then checkUNCpath:=true;
end;

procedure populaterecentpanel;
var
   i:integer;
begin
try
Form_peach.StringGridRecent.Rowcount:=17;
i:=1;
if Form_peach.mRecent1f.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=''; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent1f.Caption; i:=i+1; end;
if Form_peach.mRecent2f.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=''; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent2f.Caption; i:=i+1; end;
if Form_peach.mRecent3f.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=''; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent3f.Caption; i:=i+1; end;
if Form_peach.mRecent4f.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=''; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent4f.Caption; i:=i+1; end;
if Form_peach.mRecent5f.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=''; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent5f.Caption; i:=i+1; end;
if Form_peach.mRecent6f.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=''; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent6f.Caption; i:=i+1; end;
if Form_peach.mRecent7f.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=''; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent7f.Caption; i:=i+1; end;
if Form_peach.mRecent8f.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=''; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent8f.Caption; i:=i+1; end;

if Form_peach.mRecent1.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=' '; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent1.Caption; i:=i+1; end;
if Form_peach.mRecent2.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=' '; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent2.Caption; i:=i+1; end;
if Form_peach.mRecent3.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=' '; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent3.Caption; i:=i+1; end;
if Form_peach.mRecent4.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=' '; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent4.Caption; i:=i+1; end;
if Form_peach.mRecent5.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=' '; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent5.Caption; i:=i+1; end;
if Form_peach.mRecent6.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=' '; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent6.Caption; i:=i+1; end;
if Form_peach.mRecent7.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=' '; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent7.Caption; i:=i+1; end;
if Form_peach.mRecent8.Caption<>'' then begin Form_peach.StringGridRecent.Cells[0,i]:=' '; Form_peach.StringGridRecent.Cells[1,i]:=Form_peach.mRecent8.Caption; i:=i+1; end;
Form_peach.StringGridRecent.Rowcount:=i;
Form_peach.StringGridRecent.AutosizeColumns;
Form_peach.StringGridRecent.ColWidths[0]:=rowsize;
Form_peach.StringGridRecent.ColWidths[2]:=0;
Form_peach.StringGridRecent.ColWidths[3]:=0;
Form_peach.StringGridRecent.ColWidths[4]:=0;
except
end;
end;

procedure setsearchhistorymenu;
begin
with Form_peach do
begin
if pmshist1.Caption<>'' then pmshist1.Visible:=true else pmshist1.Visible:=false;
if pmshist2.Caption<>'' then pmshist2.Visible:=true else pmshist2.Visible:=false;
if pmshist3.Caption<>'' then pmshist3.Visible:=true else pmshist3.Visible:=false;
if pmshist4.Caption<>'' then pmshist4.Visible:=true else pmshist4.Visible:=false;
if pmshist5.Caption<>'' then pmshist5.Visible:=true else pmshist5.Visible:=false;
if pmshist6.Caption<>'' then pmshist6.Visible:=true else pmshist6.Visible:=false;
if pmshist7.Caption<>'' then pmshist7.Visible:=true else pmshist7.Visible:=false;
if pmshist8.Caption<>'' then pmshist8.Visible:=true else pmshist8.Visible:=false;
end;
end;

procedure checkrecent(var srec:Thistarray);
var
  i,j:integer;
  csrec:Thistarray;
begin
for i:=1 to 8 do csrec[i]:='';
j:=1;
for i:=1 to 8 do
   if fileexists(srec[i]) then
      begin
      csrec[j]:=srec[i];
      j:=j+1;
      end;
Form_peach.mRecent1.Caption:=csrec[1];
Form_peach.mRecent2.Caption:=csrec[2];
Form_peach.mRecent3.Caption:=csrec[3];
Form_peach.mRecent4.Caption:=csrec[4];
Form_peach.mRecent5.Caption:=csrec[5];
Form_peach.mRecent6.Caption:=csrec[6];
Form_peach.mRecent7.Caption:=csrec[7];
Form_peach.mRecent8.Caption:=csrec[8];
end;

procedure checkrecentf(var srecf:Thistarray);
var
  i,j:integer;
  csrecf:Thistarray;
begin
for i:=1 to 8 do csrecf[i]:='';
j:=1;
for i:=1 to 8 do
   if directoryexists(srecf[i]) then
      begin
      csrecf[j]:=srecf[i];
      j:=j+1;
      end;
Form_peach.mRecent1f.Caption:=csrecf[1];
Form_peach.mRecent2f.Caption:=csrecf[2];
Form_peach.mRecent3f.Caption:=csrecf[3];
Form_peach.mRecent4f.Caption:=csrecf[4];
Form_peach.mRecent5f.Caption:=csrecf[5];
Form_peach.mRecent6f.Caption:=csrecf[6];
Form_peach.mRecent7f.Caption:=csrecf[7];
Form_peach.mRecent8f.Caption:=csrecf[8];
end;

procedure setshowvolatile;
begin
if showvolatile=1 then
begin
Form_peach.checkboxseparate.Font.Style:=[fsItalic];
Form_peach.checkboxsamearc.Font.Style:=[fsItalic];
Form_peach.checkboxconvert.Font.Style:=[fsItalic];
Form_peach.checkboxconvert0.Font.Style:=[fsItalic];
Form_peach.checkboxconvert1.Font.Style:=[fsItalic];
Form_peach.CheckBoxTarBefore.Font.Style:=[fsItalic];
Form_peach.checkboxsameext.Font.Style:=[fsItalic];
Form_peach.ComboBoxArchive7.Font.Style:=[fsItalic];
Form_peach.ComboBoxArchivePaths.Font.Style:=[fsItalic];
Form_peach.Label7za5.Font.Style:=[fsItalic];
Form_peach.Label7za6.Font.Style:=[fsItalic];
Form_peach.Label7zaPasses.Font.Style:=[fsItalic];
Form_peach.Label7zsolidblock.Font.Style:=[fsItalic];
Form_peach.Label7za1.Font.Style:=[fsItalic];
Form_peach.Label7za8.Font.Style:=[fsItalic];
end
else
begin
Form_peach.checkboxseparate.Font.Style:=[];
Form_peach.checkboxsamearc.Font.Style:=[];
Form_peach.checkboxconvert.Font.Style:=[];
Form_peach.checkboxconvert0.Font.Style:=[];
Form_peach.checkboxconvert1.Font.Style:=[];
Form_peach.CheckBoxTarBefore.Font.Style:=[];
Form_peach.checkboxsameext.Font.Style:=[];
Form_peach.ComboBoxArchive7.Font.Style:=[];
Form_peach.ComboBoxArchivePaths.Font.Style:=[];
Form_peach.Label7za5.Font.Style:=[];
Form_peach.Label7za6.Font.Style:=[];
Form_peach.Label7zaPasses.Font.Style:=[];
Form_peach.Label7zsolidblock.Font.Style:=[];
Form_peach.Label7za1.Font.Style:=[];
Form_peach.Label7za8.Font.Style:=[];
end;
end;

procedure tool24apply;
begin
if (toolsize=0) then
begin
imgloaded:=false;
load_icons;
toolsize:=0;
ptoolsize:=toolsize;
settoolbar;
end;
end;

procedure setspecialextensions;
var
  astr: ansistring;
  aastr: array of ansistring;
  i,j:integer;
begin
astr:=Form_peach.editExtEvForWhat.Caption;
aastr:=astr.Split(' ');
j:=0;
SetLength(specextensions,0);
SetLength(specextensions,128);
for i:=0 to length(aastr)-1 do
   if aastr[i]<>'' then
      begin
      specextensions[j]:=aastr[i];
      if specextensions[j,1] <> '.' then specextensions[j]:='.'+specextensions[j];
      j:=j+1;
      if j>=128 then break;
      end;
SetLength(specextensions,j);
end;

procedure readconf_defaults;
var
   s:ansistring;
   srec,srecf:Thistarray;
begin
readln(conf,s); csvsep:=s; if s='' then csvsep:=','; Form_peach.EditCSVsep.Caption:=csvsep;
readln(conf,s);
readln(conf,s); autoclosegwrap:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); autoopen:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); zaout:=strtoint(s); zaout1:=zaout;
readln(conf,s);
readln(conf,s);
readln(conf,s); clipmode:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); indir:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); df:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); pf:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); pcompr:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); pobj:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); pvol:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); pstream:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); salgo:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); showguihints:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); showpwfield:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); extpw:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); browserstyle:=strtoint(s);
if (browserstyle=0) or (browserstyle=20) then browsingmode7z:=0 else browsingmode7z:=1;
readln(conf,s);
readln(conf,s);
readln(conf,s); ignorepathextand:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ignorepathdisp:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ignorepathsel:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); prebrowse:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); prebrowsesize:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); extopt7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); extoptarc:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); savehistory:=strtoint(s);
readln(conf,srec[1]); //Form_peach.mRecent1.Caption:=s;
readln(conf,srec[2]); //Form_peach.mRecent2.Caption:=s;
readln(conf,srec[3]); //Form_peach.mRecent3.Caption:=s;
readln(conf,srec[4]); //Form_peach.mRecent4.Caption:=s;
readln(conf,srec[5]); //Form_peach.mRecent5.Caption:=s;
readln(conf,srec[6]); //Form_peach.mRecent6.Caption:=s;
readln(conf,srec[7]); //Form_peach.mRecent7.Caption:=s;
readln(conf,srec[8]); //Form_peach.mRecent8.Caption:=s;
checkrecent(srec);
Form_peach.pmhr1.Caption:=Form_peach.mRecent1.Caption;
Form_peach.pmhr2.Caption:=Form_peach.mRecent2.Caption;
Form_peach.pmhr3.Caption:=Form_peach.mRecent3.Caption;
Form_peach.pmhr4.Caption:=Form_peach.mRecent4.Caption;
Form_peach.pmhr5.Caption:=Form_peach.mRecent5.Caption;
Form_peach.pmhr6.Caption:=Form_peach.mRecent6.Caption;
Form_peach.pmhr7.Caption:=Form_peach.mRecent7.Caption;
Form_peach.pmhr8.Caption:=Form_peach.mRecent8.Caption;
readln(conf,s);
readln(conf,s);
readln(conf,s); Form_peach.pcustom1.Caption:=s;
readln(conf,s); Form_peach.pcustom2.Caption:=s;
readln(conf,s); Form_peach.pcustom3.Caption:=s;
readln(conf,s); Form_peach.pcustom4.Caption:=s;
readln(conf,s); Form_peach.pcustom5.Caption:=s;
readln(conf,s); Form_peach.pcustom6.Caption:=s;
readln(conf,s); Form_peach.pcustom7.Caption:=s;
readln(conf,s); Form_peach.pcustom8.Caption:=s;
readln(conf,s); Form_peach.EditOPCustom.Caption:=s;
readln(conf,s); customsyntax:=strtoint(s);
readln(conf,s); Form_peach.EditOPCustom1.Caption:=s;
readln(conf,s); customsyntax1:=strtoint(s);
//load last window's status, if ws=0 those values are ignored
readln(conf,s);
readln(conf,s);
readln(conf,s); ws:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ws_status:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ws_left:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ws_top:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ws_width:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ws_height:=strtoint(s);
//load favourite archive types
readln(conf,s);
readln(conf,s);
readln(conf,s); fav7z:=strtoint(s);
readln(conf,s); favARC:=strtoint(s);
readln(conf,s); favbz:=strtoint(s);
readln(conf,s); favcustom:=strtoint(s);
readln(conf,s); favgz:=strtoint(s);
readln(conf,s); favpea:=strtoint(s);
readln(conf,s); favquad:=strtoint(s);
readln(conf,s); favsfx:=strtoint(s);
readln(conf,s); favsfxarc:=strtoint(s);
readln(conf,s); favsplit:=strtoint(s);
readln(conf,s); favtar:=strtoint(s);
readln(conf,s); favupx:=strtoint(s);
readln(conf,s); favzip:=strtoint(s);
readln(conf,s); favzpaq:=strtoint(s);
//load default Compression levels
readln(conf,s);
readln(conf,s);
readln(conf,s); level_7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); method_7z:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); level_arc:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); solid_arc:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); rr_arc:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); algo_arc:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_bzip2:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_gz:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_paq:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_quad:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_upx:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_zip:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); method_zip:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); openw_all7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); algodisp:=strtoint(s);
readln(conf,s); algoall:=strtoint(s);
readln(conf,s); algoadler:=strtoint(s);
readln(conf,s); algocrc16:=strtoint(s);
readln(conf,s); algocrc24:=strtoint(s);
readln(conf,s); algocrc32:=strtoint(s);
readln(conf,s); algocrc64:=strtoint(s);
readln(conf,s); algoed2k:=strtoint(s);
readln(conf,s); algomd4:=strtoint(s);
readln(conf,s); algomd5:=strtoint(s);
readln(conf,s); algoripemd160:=strtoint(s);
readln(conf,s); algosha1:=strtoint(s);
readln(conf,s); algosha3_256:=strtoint(s);
readln(conf,s); algosha256:=strtoint(s);
readln(conf,s); algosha3_512:=strtoint(s);
readln(conf,s); algosha512:=strtoint(s);
readln(conf,s); algowhirl:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); erasepasses:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s);
if (s<>'') then
   if directoryexists(s) then
      local_desktop:=s;
if check7zvolume(indir)=true then indir:={$IFDEF MSWINDOWS}txt_mypc;{$ELSE}'/';{$ENDIF}
readln(conf,s);
readln(conf,s);
readln(conf,s); jobdefenc:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); archivenameenc:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); lastoutpath:=s;
if lastoutpath='' then lastoutpath:=local_desktop;
readln(conf,s);
readln(conf,s);
readln(conf,s); splittersize:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); lastbar:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); esna:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); euns:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); checkver:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); browsertype:=strtoint(s);
readln(conf,s); listsortcol:=strtoint(s);
readln(conf,s); if strtoint(s)=1 then az:=true else az:=false;
readln(conf,s); col1size:=strtoint(s);
readln(conf,s); col2size:=strtoint(s);
readln(conf,s); col3size:=strtoint(s);
readln(conf,s); col4size:=strtoint(s);
readln(conf,s); col5size:=strtoint(s);
readln(conf,s); col6size:=strtoint(s);
readln(conf,s); col7size:=strtoint(s);
readln(conf,s); if strtoint(s)=1 then rowselect:=true else rowselect:=false;
readln(conf,s);
readln(conf,s);
readln(conf,s); tonewfolder:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); parallelarchive:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); defaultextractpath:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); defaultarchivepath:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); zcopy:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); if strtoint(s)=1 then showmenu:=true else showmenu:=false;
readln(conf,s);
readln(conf,s);
readln(conf,s); addressbar:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); navbar:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); if strtoint(s)=1 then ctype:=true else ctype:=false;
readln(conf,s); if strtoint(s)=1 then csize:=true else csize:=false;
readln(conf,s); if strtoint(s)=1 then cpacked:=true else cpacked:=false;
readln(conf,s); if strtoint(s)=1 then cdate:=true else cdate:=false;
readln(conf,s); if strtoint(s)=1 then catt:=true else catt:=false;
readln(conf,s); if strtoint(s)=1 then ccrc:=true else ccrc:=false;
readln(conf,s); if strtoint(s)=1 then cfree:=true else cfree:=false;
readln(conf,s); if strtoint(s)=1 then cfs:=true else cfs:=false;
readln(conf,s);
readln(conf,s);
readln(conf,s); toolsize:=strtoint(s); ptoolsize:=toolsize;
readln(conf,s); if strtoint(s)=1 then thighlight:=true else thighlight:=false;
readln(conf,s);
readln(conf,s);
readln(conf,s); splitter2size:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); expandfs:=strtoint(s);
readln(conf,s); expandroot:=strtoint(s);
readln(conf,s); expandbook:=strtoint(s);
readln(conf,s); expandhistory:=strtoint(s);
readln(conf,s); expandmore:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); enc7zscc:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); extaction7z:=strtoint(s);
readln(conf,s); extactionarc:=strtoint(s);
readln(conf,s); extactionace:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); work_dir:=strtoint(s); if work_dir=5 then Form_peach.CheckBoxrelative.enabled:=false;
readln(conf,s);
readln(conf,s);
readln(conf,s); mcuzip:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); mappeddrivesinfo:=strtoint(s);  session_mappeddrivesinfo:=mappeddrivesinfo;
readln(conf,s);
readln(conf,s);
readln(conf,s); expandrun:=strtoint(s);
readln(conf,s); expandapps:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); lastextractionpath:=s;
if lastextractionpath<>'' then
   if not(directoryexists(lastextractionpath)) then lastextractionpath:='';
readln(conf,s);
readln(conf,s);
readln(conf,s); setencfn:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); //ignorepathdd:=strtoint(s);removed from 6.8.0 release
readln(conf,s);
readln(conf,s);
readln(conf,s); if(strtoint(s))=1 then swapbars:=true else swapbars:=false;
readln(conf,s);
readln(conf,s);
readln(conf,s); nameaspartent:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); favwim:=strtoint(s);
readln(conf,s); favxz:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_xz:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); browsersize:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); Form_peach.pmshist1.Caption:=s;
readln(conf,s); Form_peach.pmshist2.Caption:=s;
readln(conf,s); Form_peach.pmshist3.Caption:=s;
readln(conf,s); Form_peach.pmshist4.Caption:=s;
readln(conf,s); Form_peach.pmshist5.Caption:=s;
readln(conf,s); Form_peach.pmshist6.Caption:=s;
readln(conf,s); Form_peach.pmshist7.Caption:=s;
readln(conf,s); Form_peach.pmshist8.Caption:=s;
setsearchhistorymenu;
readln(conf,s);
readln(conf,s);
readln(conf,s); showthumbnails:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); browserch:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); simplesearch:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); arcabspath:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); recsearch:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); keeppw:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); usebreadcrumb:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); pimmersive:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); lasttoolbar:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); spchar:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); paqver:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); tpreset:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); simgfun:=strtoint(s);
readln(conf,s); simgw:=strtoint(s);
readln(conf,s); simgh:=strtoint(s);
readln(conf,s); simgper:=strtoint(s);
readln(conf,s); simgasp:=strtoint(s);
readln(conf,s); simgconv:=strtoint(s);
readln(conf,s); simgj:=strtoint(s);
readln(conf,s); simgt:=strtoint(s);
readln(conf,s); simgb:=strtoint(s);
readln(conf,s); simgl:=strtoint(s);
readln(conf,s); simgr:=strtoint(s);
readln(conf,s); simgpercent:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); mailkeep:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); splitter3size:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); deco_style:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,srecf[1]);
readln(conf,srecf[2]);
readln(conf,srecf[3]);
readln(conf,srecf[4]);
readln(conf,srecf[5]);
readln(conf,srecf[6]);
readln(conf,srecf[7]);
readln(conf,srecf[8]);
checkrecentf(srecf);
Form_peach.pmhr1f.Caption:=Form_peach.mRecent1f.Caption;
Form_peach.pmhr2f.Caption:=Form_peach.mRecent2f.Caption;
Form_peach.pmhr3f.Caption:=Form_peach.mRecent3f.Caption;
Form_peach.pmhr4f.Caption:=Form_peach.mRecent4f.Caption;
Form_peach.pmhr5f.Caption:=Form_peach.mRecent5f.Caption;
Form_peach.pmhr6f.Caption:=Form_peach.mRecent6f.Caption;
Form_peach.pmhr7f.Caption:=Form_peach.mRecent7f.Caption;
Form_peach.pmhr8f.Caption:=Form_peach.mRecent8f.Caption;
setrecenticons_extract_archive;
populaterecentpanel;
readln(conf,s);
readln(conf,s);
readln(conf,s); enumd:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); defaulttabsmenu:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); multi_option:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); favdelete:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); expandfun:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); removeintdir:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); convertverbose:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); libre_directive:=strtoint(s);
if HLIBRE_DIR>0 then //set at compile time to hardcode use of libre software
   begin
   libre_directive:=HLIBRE_DIR;
   Form_peach.ComboBoxLibre.ItemIndex:=libre_directive;
   Form_peach.ComboBoxLibre.enabled:=false;
   end;
readln(conf,s);
readln(conf,s);
readln(conf,s); nonverboselog:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); tsstyle:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); use7zunrar5:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); sort7zbytype:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); browsersd:=strtoint(s);
readln(conf,s); browsersdir:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); doptadd:=strtoint(s);
readln(conf,s); doptext:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); addtstext:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); addencext:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ptabbar:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); privacy_mode:=strtoint(s);
if HPRIVACY_MODE>0 then
   begin
   privacy_mode:=HPRIVACY_MODE;
   Form_peach.ComboBoxPrivacy.ItemIndex:=privacy_mode;
   Form_peach.ComboBoxPrivacy.enabled:=false;
   end;
readln(conf,s);
readln(conf,s);
readln(conf,s); sni7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); sns7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); convertpw:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); showvolatile:=strtoint(s); setshowvolatile;
readln(conf,s);
readln(conf,s);
readln(conf,s); tryopenwerrors:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); forcecanbechanged:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); euns1:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); custom_work_path:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); algo_zipenc:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); nativedrag:=strtoint(s);
if (nativedrag<0) or (nativedrag>1) then nativedrag:=1;
if nativedrag=1 then ignorepathdd:=0 else ignorepathdd:=1;
if nativedrag=1 then Form_peach.Timerdrag.Enabled:=true else Form_peach.Timerdrag.Enabled:=false;
readln(conf,s);
readln(conf,s);
readln(conf,s); ws_gw_left:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ws_gw_top:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ws_gw_width:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); ws_gw_height:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); autosync:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); autoopentar:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_brotli:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_zstd:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); favbrotli:=strtoint(s);
readln(conf,s); favzstandard:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); renfilesonly:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); defaultspanning:=strtoint(s);
readln(conf,s); spansize:=strtoint(s);
readln(conf,s); spanunit:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); advopdictionary:=strtoint(s);
readln(conf,s); advopword:=strtoint(s);
readln(conf,s); advoppasses:=strtoint(s);
readln(conf,s); advopblocksize:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); autoclosepeazip:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); zpaqall:=strtoint(s);
readln(conf,s); zpaqabsolute:=strtoint(s);
readln(conf,s); zpaqforce:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); Form_peach.EditOP.Caption:=s;
readln(conf,s); Form_peach.EditOParc.Caption:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); stl7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); maxbrotli:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); maxzstd:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); noconfdel:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userar:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); level_rar:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userar5:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userardict:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userarblake2:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userarsfx:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userarsolid:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userarrr:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); puserarrr:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userarsaveopen:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userarsavesecurity:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userarsavestreams:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userarlastmodtime:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); userarlock:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); swzipx:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); closeonsingleextract:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); dragtargetprotect:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); whenspecialopen:=strtoint(s);
readln(conf,s); howspecialopen:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); Form_peach.EditEncoding.Caption:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); ptsync:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); sys7zlin:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); movetorelativepath:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); taskpriority:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); Form_peach.editExtEvForWhat.Caption:=s; setspecialextensions;
readln(conf,s);
readln(conf,s);
readln(conf,s); repcustext:=strtoint(s);
readln(conf,s); Form_peach.editcustext.Caption:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); forcebrowse:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); forceconvert:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); intpw:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); defaultactionst:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); enableextand:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); useextrac32:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); storecreated:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); skipenctest:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); if strtoint(s)=1 then ccreated:=true else ccreated:=false;
readln(conf,s); if strtoint(s)=1 then caccessed:=true else caccessed:=false;
readln(conf,s); if strtoint(s)=1 then cmethod:=true else cmethod:=false;
readln(conf,s); colmethodsize:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); Form_peach.Editcommonalgo.Caption:=s;
readln(conf,s);
readln(conf,s);
readln(conf,s); filesizebase:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); maxargsize:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); skipdel:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); disableintscript:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); filterbrowser:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); forcelayout:=strtoint(s);
readln(conf,s); Form_peach.LabelForceLayout.Caption:=s;
if (forcelayout=1) and (Form_peach.LabelForceLayout.Caption<>'') then
   if fileexists(Form_peach.LabelForceLayout.Caption) then
      loadlist(nil,Form_peach.LabelForceLayout.Caption);
readln(conf,s);
readln(conf,s);
readln(conf,s); immediate_execution:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s);
try
form_peach.ComboBoxArchive7.ItemIndex:=strtoint(s);
except
form_peach.ComboBoxArchive7.ItemIndex:=0;
end;
defaultarchiveaction:=form_peach.ComboBoxArchive7.ItemIndex;
readln(conf,s);
readln(conf,s);
readln(conf,s); showsearchbar:=strtoint(s);
readln(conf,s); splitsearchsize:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); snz7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); tartype:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); tartime:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); snoi7z:=strtoint(s);
readln(conf,s); snon7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); autotest:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); lsize:=strtoint(s); tool24apply;
readln(conf,s);
readln(conf,s);
readln(conf,s); ssp7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); snh7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); snl7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); memuse_option:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); tar_atomic:=strtoint(s);
readln(conf,s); tar_atomic_convert:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); zpaqfull:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); dirbeforefiles:=strtoint(s); set_dirbeforefiles(dirbeforefiles);
readln(conf,s);
readln(conf,s);
readln(conf,s); syntaxlevel7z:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); convint:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); excludeef:=strtoint(s);
readln(conf,s);
readln(conf,s);
readln(conf,s); if strtoint(s)=1 then enlargeicons:=true else enlargeicons:=false;
readln(conf,s);
readln(conf,s);
readln(conf,s); qdup:=strtoint(s);
end;

procedure writeconf_colors;
begin
writeln(conf,graphicsfolder);
writeln(conf,opacity);
writeln(conf,color1);
writeln(conf,color2);
writeln(conf,color3);
writeln(conf,color4);
writeln(conf,color5);
writeln(conf,inttostr(usealtcolor)+inttostr(highlighttabs)+inttostr(accenttoolbar)+inttostr(toolcentered)+inttostr(altaddressstyle)+inttostr(solidaddressstyle)+inttostr(alttabstyle)+inttostr(ensmall));
writeln(conf,inttostr(pzooming));
writeln(conf,inttostr(pspacing));
writeln(conf,inttostr(temperature));
end;

procedure writeconf_default_colors;
begin
writeln(conf,graphicsfolderd);
writeln(conf,opacityd);
writeln(conf,color1d);
writeln(conf,color2d);
writeln(conf,color3d);
writeln(conf,color4d);
writeln(conf,color5d);
writeln(conf,inttostr(usealtcolord)+inttostr(highlighttabsd)+inttostr(accenttoolbard)+inttostr(toolcenteredd)+inttostr(altaddressstyled)+inttostr(solidaddressstyled)+inttostr(alttabstyled)+inttostr(ensmalld));
writeln(conf,inttostr(pzoomingd));
writeln(conf,inttostr(pspacingd));
writeln(conf,inttostr(temperatured));
end;

procedure writeconf_defaults;
begin
writeln(conf,'[language]');
writeln(conf,lang_file);
writeln(conf,Form_peach.EditCSVsep.Caption);
writeln(conf,'[0: always keep open task window for inspection of reports 1: (default) keep open only for errors, list, test operations 2: keep open only for errors, list 3: never keep open for inspection]');
writeln(conf,inttostr(autoclosegwrap));
writeln(conf,'');
writeln(conf,'[open output directory when task ends]');
writeln(conf,inttostr(autoopen));
writeln(conf,'');
writeln(conf,'[console binaries interface]');
writeln(conf,inttostr(zaout));
writeln(conf,'');
writeln(conf,'[Clipboard mode]');
writeln(conf,inttostr(clipmode));
writeln(conf,'');
writeln(conf,'[Initial dir for file/archive browser]');
writeln(conf,indir);
writeln(conf,'');
writeln(conf,'[default archiving format]');
writeln(conf,inttostr(df));
writeln(conf,'');
writeln(conf,'[last used archiving format]');
writeln(conf,inttostr(pf));
writeln(conf,'');
writeln(conf,'[default PEA compression level]');
writeln(conf,inttostr(pcompr));
writeln(conf,'');
writeln(conf,'[default PEA object level control algorithm]');
writeln(conf,inttostr(pobj));
writeln(conf,'');
writeln(conf,'[default PEA volume level control algorithm]');
writeln(conf,inttostr(pvol));
writeln(conf,'');
writeln(conf,'[default PEA stream level control algorithm]');
writeln(conf,inttostr(pstream));
writeln(conf,'');
writeln(conf,'[default integrity check algorithm for file split]');
writeln(conf,inttostr(salgo));
writeln(conf,'');
writeln(conf,'[show hints popup]');
writeln(conf,inttostr(showguihints));
writeln(conf,'');
writeln(conf,'[show password field in clear]');
writeln(conf,inttostr(showpwfield));
writeln(conf,'');
writeln(conf,'[ask for password on extract/list/test operations from system''s menus]');
writeln(conf,inttostr(extpw));
writeln(conf,'');
writeln(conf,'[archive browser style]');
writeln(conf,inttostr(browserstyle));
writeln(conf,'');
writeln(conf,'[ignore archived path structure when performing extract and run or preview jobs: all ignore path directivesd are overridden in the content is a directory, as it would lose information about tree structure below]');
writeln(conf,inttostr(ignorepathextand));
writeln(conf,'');
writeln(conf,'[ignore archived path structure when performing extraction of displayed objects]');
writeln(conf,inttostr(ignorepathdisp));
writeln(conf,'');
writeln(conf,'[ignore archived path structure when performing extraction of selected objects]');
writeln(conf,inttostr(ignorepathsel));
writeln(conf,'');
writeln(conf,'[archive browser speed optimization: 0 no optimization 1..4 slower to faster optimization (3 default) 5 do not pre-parse archives, may non correctly list some out of standard archives]');
writeln(conf,inttostr(prebrowse));
writeln(conf,'');
writeln(conf,'[(obsolete) don''t pre-parse archives over this in-memory size]');
writeln(conf,inttostr(prebrowsesize));
writeln(conf,'');
writeln(conf,'[overwrite / skip policy using 7z binary]');
writeln(conf,inttostr(extopt7z));
writeln(conf,'');
writeln(conf,'[overwrite / skip policy using arc binary]');
writeln(conf,inttostr(extoptarc));
writeln(conf,'');
writeln(conf,'[save history of recent archives]');
writeln(conf,inttostr(savehistory));
writeln(conf,Form_peach.mRecent1.Caption);
writeln(conf,Form_peach.mRecent2.Caption);
writeln(conf,Form_peach.mRecent3.Caption);
writeln(conf,Form_peach.mRecent4.Caption);
writeln(conf,Form_peach.mRecent5.Caption);
writeln(conf,Form_peach.mRecent6.Caption);
writeln(conf,Form_peach.mRecent7.Caption);
writeln(conf,Form_peach.mRecent8.Caption);
writeln(conf,'');
writeln(conf,'[recently used custom executables]');
writeln(conf,Form_peach.pcustom1.Caption);
writeln(conf,Form_peach.pcustom2.Caption);
writeln(conf,Form_peach.pcustom3.Caption);
writeln(conf,Form_peach.pcustom4.Caption);
writeln(conf,Form_peach.pcustom5.Caption);
writeln(conf,Form_peach.pcustom6.Caption);
writeln(conf,Form_peach.pcustom7.Caption);
writeln(conf,Form_peach.pcustom8.Caption);
writeln(conf,Form_peach.EditOPcustom.Caption);
writeln(conf,inttostr(customsyntax));
writeln(conf,Form_peach.EditOPcustom1.Caption);
writeln(conf,inttostr(customsyntax1));
writeln(conf,'');
writeln(conf,'[save program''s windows status]');
writeln(conf,inttostr(ws));
if Form_peach.Visible=true then
   if Form_peach.WindowState=wsNormal then
      begin
      ws_status:=0;
      ws_left:=Form_peach.Left;
      ws_top:=Form_peach.Top;
      ws_width:=Form_peach.Width;
      ws_height:=Form_peach.Height;
      end
   else ws_status:=1;
writeln(conf,'');
writeln(conf,'[maximized status]');
writeln(conf,inttostr(ws_status));
writeln(conf,'');
writeln(conf,'[left]');
writeln(conf,inttostr(ws_left));
writeln(conf,'');
writeln(conf,'[top]');
writeln(conf,inttostr(ws_top));
writeln(conf,'');
writeln(conf,'[width]');
writeln(conf,inttostr(ws_width));
writeln(conf,'');
writeln(conf,'[height]');
writeln(conf,inttostr(ws_height));
//favourite archive types
writeln(conf,'');
writeln(conf,'[archive formats to show in favourite popup menu]');
writeln(conf,inttostr(fav7z));
writeln(conf,inttostr(favARC));
writeln(conf,inttostr(favbz));
writeln(conf,inttostr(favcustom));
writeln(conf,inttostr(favgz));
writeln(conf,inttostr(favpea));
writeln(conf,inttostr(favquad));
writeln(conf,inttostr(favsfx));
writeln(conf,inttostr(favsfxarc));
writeln(conf,inttostr(favsplit));
writeln(conf,inttostr(favtar));
writeln(conf,inttostr(favupx));
writeln(conf,inttostr(favzip));
writeln(conf,inttostr(favzpaq));
//Compression default levels
writeln(conf,'');
writeln(conf,'[default 7z compression level]');
if dontsavecustom7z=true then writeln(conf,inttostr(dlevel_7z)) else writeln(conf,inttostr(level_7z));
writeln(conf,'');
writeln(conf,'[default 7z compression method]');
if dontsavecustom7z=true then writeln(conf,dmethod_7z) else writeln(conf,method_7z);
writeln(conf,'');
writeln(conf,'[default ARC compression level]');
writeln(conf,inttostr(level_arc));
writeln(conf,'');
writeln(conf,'[default ARC solid mode]');
writeln(conf,inttostr(solid_arc));
writeln(conf,'');
writeln(conf,'[use recovery records in ARC]');
writeln(conf,inttostr(rr_arc));
writeln(conf,'');
writeln(conf,'[encryption algorithm for ARC 0 AES 1 Serpent 2 Twofish 3 Blowfish]');
writeln(conf,inttostr(algo_arc));
writeln(conf,'');
writeln(conf,'[default bzip2 compression level]');
writeln(conf,inttostr(level_bzip2));
writeln(conf,'');
writeln(conf,'[default gz compression level]');
writeln(conf,inttostr(level_gz));
writeln(conf,'');
writeln(conf,'[default zpaq compression level]');
writeln(conf,inttostr(level_paq));
writeln(conf,'');
writeln(conf,'[default quad/balz/bcm compression level]');
writeln(conf,inttostr(level_quad));
writeln(conf,'');
writeln(conf,'[default upx compression level]');
writeln(conf,inttostr(level_upx));
writeln(conf,'');
writeln(conf,'[default zip compression level]');
if dontsavecustomzip=true then writeln(conf,inttostr(dlevel_zip)) else writeln(conf,inttostr(level_zip));
writeln(conf,'');
writeln(conf,'[default zip compression method]');
if dontsavecustomzip=true then writeln(conf,dmethod_zip) else writeln(conf,method_zip);
writeln(conf,'');
writeln(conf,'[archive files open for writing (from 7z binary)]');
writeln(conf,inttostr(openw_all7z));
writeln(conf,'');
writeln(conf,'[checksum/hash file options: display format, default algorithm, common algorithms]');
writeln(conf,inttostr(algodisp));
writeln(conf,inttostr(algoall));
writeln(conf,inttostr(algoadler));
writeln(conf,inttostr(algocrc16));
writeln(conf,inttostr(algocrc24));
writeln(conf,inttostr(algocrc32));
writeln(conf,inttostr(algocrc64));
writeln(conf,inttostr(algoed2k));
writeln(conf,inttostr(algomd4));
writeln(conf,inttostr(algomd5));
writeln(conf,inttostr(algoripemd160));
writeln(conf,inttostr(algosha1));
writeln(conf,inttostr(algosha3_256));
writeln(conf,inttostr(algosha256));
writeln(conf,inttostr(algosha3_512));
writeln(conf,inttostr(algosha512));
writeln(conf,inttostr(algowhirl));
writeln(conf,'');
writeln(conf,'[erase file options: security level]');
writeln(conf,inttostr(erasepasses));
writeln(conf,'');
writeln(conf,'[desktop path]');
writeln(conf,local_desktop);
writeln(conf,'');
writeln(conf,'[job definition encoding]');
writeln(conf,inttostr(jobdefenc));
writeln(conf,'');
writeln(conf,'[archived object''s name encoding]');
writeln(conf,inttostr(archivenameenc));
writeln(conf,'');
writeln(conf,'[last output path]');
if savehistory=0 then lastoutpath:='';
writeln(conf,lastoutpath);
writeln(conf,'');
writeln(conf,'[height of the navigation''s splitter]');
writeln(conf,inttostr(splittersize));
writeln(conf,'');
writeln(conf,'[status bar view]');
writeln(conf,inttostr(lastbar));
writeln(conf,'');
writeln(conf,'[extract supported non-archive types]');
writeln(conf,inttostr(esna));
writeln(conf,'');
writeln(conf,'[extract unsupported archive types, specifying custom executable]');
writeln(conf,inttostr(euns));
writeln(conf,'');
writeln(conf,'[configuration check]');
writeln(conf,'PeaZip');
writeln(conf,'');
writeln(conf,'[browser''s style and settings]');
writeln(conf,inttostr(browsertype));
writeln(conf,inttostr(listsortcol));
if az=true then writeln(conf,'1') else writeln(conf,'0');
if (browsertype=0) and (Form_Peach.EditOpenIn.Caption<>txt_mypc) then
   begin
   writeln(conf,inttostr(Form_Peach.ListView1.Column[0].Width));
   if ctype=false then writeln(conf,inttostr(col2size)) else writeln(conf,inttostr(Form_Peach.ListView1.Column[1].Width));
   if csize=false then writeln(conf,inttostr(col3size)) else writeln(conf,inttostr(Form_Peach.ListView1.Column[2].Width));
   if cpacked=false then writeln(conf,inttostr(col4size)) else writeln(conf,inttostr(Form_Peach.ListView1.Column[3].Width));
   if cdate=false then writeln(conf,inttostr(col5size)) else writeln(conf,inttostr(Form_Peach.ListView1.Column[4].Width));
   if catt=false then writeln(conf,inttostr(col6size)) else writeln(conf,inttostr(Form_Peach.ListView1.Column[8].Width));
   if ccrc=false then writeln(conf,inttostr(col7size)) else writeln(conf,inttostr(Form_Peach.ListView1.Column[9].Width));
   end
else
   begin
   writeln(conf,inttostr(col1size));
   writeln(conf,inttostr(col2size));
   writeln(conf,inttostr(col3size));
   writeln(conf,inttostr(col4size));
   writeln(conf,inttostr(col5size));
   writeln(conf,inttostr(col6size));
   writeln(conf,inttostr(col7size));
   end;
if rowselect=true then writeln(conf,'1') else writeln(conf,'0');
writeln(conf,'');
writeln(conf,'[extract to new folder]');
if Form_peach.CheckBoxFolder.State=cbChecked then writeln(conf,'1') else writeln(conf,'0');
writeln(conf,'');
writeln(conf,'[execute archiving/extraction jobs in parallel when possible]');
if Form_peach.CheckBoxParallelarchiving.State=cbChecked then writeln(conf,'1') else writeln(conf,'0');
writeln(conf,'');
writeln(conf,'[default output path for extraction operations]');
writeln(conf,defaultextractpath);
writeln(conf,'');
writeln(conf,'[default output path for archiving operations]');
writeln(conf,defaultarchivepath);
writeln(conf,'');
writeln(conf,'[(Windows) copy files in restartable mode, slower]');
if Form_peach.CheckBoxzcopy.State=cbChecked then writeln(conf,'1') else writeln(conf,'0');
writeln(conf,'');
writeln(conf,'[show menu bar]');
if showmenu=true then writeln(conf,'1') else writeln(conf,'0');
writeln(conf,'');
writeln(conf,'[address bar]');
writeln(conf,inttostr(addressbar));
writeln(conf,'');
writeln(conf,'[navigation bar]');
writeln(conf,inttostr(navbar));
writeln(conf,'');
writeln(conf,'[columns to show]');
if ctype=true then writeln(conf,'1') else writeln(conf,'0');
if csize=true then writeln(conf,'1') else writeln(conf,'0');
if cpacked=true then writeln(conf,'1') else writeln(conf,'0');
if cdate=true then writeln(conf,'1') else writeln(conf,'0');
if catt=true then writeln(conf,'1') else writeln(conf,'0');
if ccrc=true then writeln(conf,'1') else writeln(conf,'0');
if cfree=true then writeln(conf,'1') else writeln(conf,'0');
if cfs=true then writeln(conf,'1') else writeln(conf,'0');
writeln(conf,'');
writeln(conf,'[toolbar]');
writeln(conf,inttostr(toolsize));
if thighlight=true then writeln(conf,'1') else writeln(conf,'0');
writeln(conf,'');
writeln(conf,'[size of the navigation sidebar]');
writeln(conf,inttostr(splitter2size));
writeln(conf,'');
writeln(conf,'[status of navigation groups]');
writeln(conf,inttostr(expandfs));
writeln(conf,inttostr(expandroot));
writeln(conf,inttostr(expandbook));
writeln(conf,inttostr(expandhistory));
writeln(conf,inttostr(expandmore));
writeln(conf,'');
writeln(conf,'[7z / p7zip backend encoding (-scc)]');
writeln(conf,inttostr(enc7zscc));
writeln(conf,'');
writeln(conf,'[extraction or alternative action for 7z, arc, and ace backend binaries]');
writeln(conf,inttostr(extaction7z));
writeln(conf,inttostr(extactionarc));
writeln(conf,inttostr(extactionace));
writeln(conf,'');
writeln(conf,'[working directory]');
writeln(conf,inttostr(work_dir));
writeln(conf,'');
writeln(conf,'[7z / p7zip text encoding for file names inside .ZIP files]');
writeln(conf,inttostr(mcuzip));
writeln(conf,'');
writeln(conf,'[(Windows) get volume information of mapped remote units]');
writeln(conf,inttostr(mappeddrivesinfo));
writeln(conf,'');
writeln(conf,'[status of run group]');
writeln(conf,inttostr(expandrun));
writeln(conf,inttostr(expandapps));
writeln(conf,'');
writeln(conf,'[last successful extraction path]');
if savehistory=0 then lastextractionpath:='';
writeln(conf,lastextractionpath);
writeln(conf,'');
writeln(conf,'[encrypt also filenames, if the feature is supported by the format]');
writeln(conf,inttostr(setencfn));
writeln(conf,'');
writeln(conf,'[ignore archived path structure when performing custom drag and drop extraction]');
writeln(conf,inttostr(ignorepathdd));
writeln(conf,'');
writeln(conf,'[swap position of Toolbar and Address bar]');
if swapbars=true then writeln(conf,'1') else writeln(conf,'0');
writeln(conf,'');
writeln(conf,'[if multiple items are added to a new archive, name the archive as selected item''s folder]');
writeln(conf,inttostr(nameaspartent));
writeln(conf,'');
writeln(conf,'[new favorite types (3.8)]');
writeln(conf,inttostr(favwim));
writeln(conf,inttostr(favxz));
writeln(conf,'');
writeln(conf,'[default xz compression level]');
writeln(conf,inttostr(level_xz));
writeln(conf,'');
writeln(conf,'[browser icons size]');
writeln(conf,inttostr(browsersize));
writeln(conf,'');
writeln(conf,'[search history]');
if savehistory=0 then
   begin
   writeln(conf,'');
   writeln(conf,'');
   writeln(conf,'');
   writeln(conf,'');
   writeln(conf,'');
   writeln(conf,'');
   writeln(conf,'');
   writeln(conf,'');
   end
else
   begin
   writeln(conf,Form_peach.pmshist1.Caption);
   writeln(conf,Form_peach.pmshist2.Caption);
   writeln(conf,Form_peach.pmshist3.Caption);
   writeln(conf,Form_peach.pmshist4.Caption);
   writeln(conf,Form_peach.pmshist5.Caption);
   writeln(conf,Form_peach.pmshist6.Caption);
   writeln(conf,Form_peach.pmshist7.Caption);
   writeln(conf,Form_peach.pmshist8.Caption);
   end;
writeln(conf,'');
writeln(conf,'[show thumbnails]');
writeln(conf,inttostr(showthumbnails));
writeln(conf,'');
writeln(conf,'[default checksum/hash algorithm for the file browser (calculated on request)]');
writeln(conf,inttostr(browserch));
writeln(conf,'');
writeln(conf,'[simple search mode]');
writeln(conf,inttostr(simplesearch));
writeln(conf,'');
writeln(conf,'[use absolute paths for ARC format]');
writeln(conf,inttostr(arcabspath));
writeln(conf,'');
writeln(conf,'[search is recursive by default]');
writeln(conf,inttostr(recsearch));
writeln(conf,'');
writeln(conf,'[keep password for current session]');
writeln(conf,inttostr(keeppw));
writeln(conf,'');
writeln(conf,'[show address field as breadcrumb]');
writeln(conf,inttostr(usebreadcrumb));
writeln(conf,'');
writeln(conf,'[immersive mode]');
writeln(conf,inttostr(pimmersive));
writeln(conf,'');
writeln(conf,'[toolbar]');
writeln(conf,inttostr(lasttoolbar));
writeln(conf,'');
writeln(conf,'[limit random password generator characters to letters and numbers (as required by some services)]');
if openstarted=true then
   try if FormKF.CheckBoxSuggestPW.State=cbChecked then spchar:=1 else spchar:=0; except spchar:=1; end
else spchar:=1;
writeln(conf,inttostr(spchar));
writeln(conf,'');
writeln(conf,'[default *paq family]');
writeln(conf,inttostr(paqver));
writeln(conf,'');
writeln(conf,'[last browser preset (overridden by style/size settings)]');
writeln(conf,inttostr(tpreset));
writeln(conf,'');
writeln(conf,'[image editing parameters]');
writeln(conf,inttostr(simgfun));
writeln(conf,inttostr(simgw));
writeln(conf,inttostr(simgh));
writeln(conf,inttostr(simgper));
writeln(conf,inttostr(simgasp));
writeln(conf,inttostr(simgconv));
writeln(conf,inttostr(simgj));
writeln(conf,inttostr(simgt));
writeln(conf,inttostr(simgb));
writeln(conf,inttostr(simgl));
writeln(conf,inttostr(simgr));
writeln(conf,inttostr(simgpercent));
writeln(conf,'');
writeln(conf,'[keep archives sent by mail]');
writeln(conf,inttostr(mailkeep));
writeln(conf,'');
writeln(conf,'[help/config section splitter position]');
writeln(conf,inttostr(splitter3size));
writeln(conf,'');
writeln(conf,'[thumbnails decoration style]');
writeln(conf,inttostr(deco_style));
writeln(conf,'');
writeln(conf,'[save history of recent directories]');
writeln(conf,Form_peach.mRecent1f.Caption);
writeln(conf,Form_peach.mRecent2f.Caption);
writeln(conf,Form_peach.mRecent3f.Caption);
writeln(conf,Form_peach.mRecent4f.Caption);
writeln(conf,Form_peach.mRecent5f.Caption);
writeln(conf,Form_peach.mRecent6f.Caption);
writeln(conf,Form_peach.mRecent7f.Caption);
writeln(conf,Form_peach.mRecent8f.Caption);
writeln(conf,'');
writeln(conf,'[enumerate content of directories sent to archiving operations: 0 no (faster) 1 yes (default, slower)]');
writeln(conf,inttostr(enumd));
writeln(conf,'');
writeln(conf,'[default address bar left menu: 1 bookmarks 2 filesystem (default) 3 history]');
writeln(conf,inttostr(defaulttabsmenu));
writeln(conf,'');
writeln(conf,'[default max threads option for 7z]');
writeln(conf,inttostr(multi_option));
writeln(conf,'');
writeln(conf,'[default deletion mode for delete after extraction / delete after archiving option: 0 recycle (Windows) 1 quick 2 zero 3 secure]');
writeln(conf,inttostr(favdelete));
writeln(conf,'');
writeln(conf,'[status of function branch in run group]');
writeln(conf,inttostr(expandfun));
writeln(conf,'');
writeln(conf,'[remove redundant intermediate directory (a single directory in output root) on "Extract to new folder" operations]');
writeln(conf,inttostr(removeintdir));
writeln(conf,'');
writeln(conf,'[verbose confirmation at each archive conversion step 1=yes, 0=no (default)]');
writeln(conf,inttostr(convertverbose));
writeln(conf,'');
writeln(conf,'[Free Software compliance 0 = permissive (default) 1 = allow only Free Software components 2 = allow only Free Software components and open archive formats; 1 and 2 modes can be hardcoded at compile time]');
writeln(conf,inttostr(libre_directive));
writeln(conf,'');
writeln(conf,'[non-verbose output log from 7z / p7zip, faster (especially when many small files are involved), but less informative 1=yes (default) 0=no]');
writeln(conf,inttostr(nonverboselog));
writeln(conf,'');
writeln(conf,'[timestamp style: 0 (default) name.date.time, 1 name.date, 2 date.time.name, 3 date.name]');
writeln(conf,inttostr(tsstyle));
writeln(conf,'');
writeln(conf,'[use 7z / p7zip implementation of UNRAR5 (even if RarLab''s UNRAR5 plugin is installed) 1=yes (default) 0=no NOTE: overridden by Free Software compliance setting if > 0]');
writeln(conf,inttostr(use7zunrar5));
writeln(conf,'');
writeln(conf,'[sort files by type for 7z solid compression 1 = on, usually better compression (default) 0 = off, faster on NTFS filesystem]');
writeln(conf,inttostr(sort7zbytype));
writeln(conf,'');
writeln(conf,'[always start file browser from 0 last browserd directory(default) 1 computer''s root 2 home 3 desktop 4 custom, defined below]');
writeln(conf,inttostr(browsersd));
writeln(conf,browsersdir);
writeln(conf,'');
writeln(conf,'[delete originals after archival, extraction: 0 no (default) 1 yes - anyway user will be asked for confirmation]');
writeln(conf,inttostr(doptadd));
writeln(conf,inttostr(doptext));
writeln(conf,'');
writeln(conf,'[add timestamp suffix when creating archives: 0 no (default) 1 yes]');
writeln(conf,inttostr(addtstext));
writeln(conf,'');
writeln(conf,'[add ".enc" suffix before extension when creating encrypted archives: 0 no (default) 1 yes]');
writeln(conf,inttostr(addencext));
writeln(conf,'');
writeln(conf,'[tab bar]');
writeln(conf,inttostr(ptabbar));
writeln(conf,'');
writeln(conf,'[privacy_mode directive 0 = none 1 = ask for password or keyfile when application starts, skippable 2 = non skippable]');
writeln(conf,inttostr(privacy_mode));
writeln(conf,'');
writeln(conf,'[manage NT security information]');
writeln(conf,inttostr(sni7z));
writeln(conf,'');
writeln(conf,'[manage NTFS alternate data streams]');
writeln(conf,inttostr(sns7z));
writeln(conf,'');
writeln(conf,'[change password during conversion 1=yes, 0=no (default)]');
writeln(conf,inttostr(convertpw));
writeln(conf,'');
writeln(conf,'[show volatile options]');
writeln(conf,inttostr(showvolatile));
writeln(conf,'');
writeln(conf,'[try to open archives containing errors]');
writeln(conf,inttostr(tryopenwerrors));
writeln(conf,'');
writeln(conf,'[try to edit non-canonical archive formats]');
writeln(conf,inttostr(forcecanbechanged));
writeln(conf,'');
writeln(conf,'[force extracting unsupported archive types using PeaZip]');
writeln(conf,inttostr(euns1));
writeln(conf,'');
writeln(conf,'[custom working directory]');
writeln(conf,custom_work_path);
writeln(conf,'');
writeln(conf,'[encryption algorithm for ZIP 0 AES 1 ZipCrypto (legacy)]');
writeln(conf,inttostr(algo_zipenc));
writeln(conf,'');
writeln(conf,'[use native drag and drop on Windows]');
writeln(conf,inttostr(nativedrag));
writeln(conf,'');
writeln(conf,'[launcher left]');
writeln(conf,inttostr(ws_gw_left));
writeln(conf,'');
writeln(conf,'[launcher top]');
writeln(conf,inttostr(ws_gw_top));
writeln(conf,'');
writeln(conf,'[launcher width]');
writeln(conf,inttostr(ws_gw_width));
writeln(conf,'');
writeln(conf,'[launcher height]');
writeln(conf,inttostr(ws_gw_height));
writeln(conf,'');
writeln(conf,'[automatically sync archives if previewed files are updated]');
writeln(conf,inttostr(autosync));
writeln(conf,'');
writeln(conf,'[automatically open TAR archive in TAR.* files]');
writeln(conf,inttostr(autoopentar));
writeln(conf,'');
writeln(conf,'[default Brotli compression level]');
writeln(conf,inttostr(level_brotli));
writeln(conf,'');
writeln(conf,'[default Zstd compression level]');
writeln(conf,inttostr(level_zstd));
writeln(conf,'');
writeln(conf,'[new favorite types (7.1)]');
writeln(conf,inttostr(favbrotli));
writeln(conf,inttostr(favzstandard));
writeln(conf,'');
writeln(conf,'[rename only files]');
writeln(conf,inttostr(renfilesonly));
writeln(conf,'');
writeln(conf,'[file spanning]');
writeln(conf,inttostr(defaultspanning));
writeln(conf,inttostr(spansize));
writeln(conf,inttostr(spanunit));
writeln(conf,'');
writeln(conf,'[advanced 7z/p7zip compression settings]');
if (dontsavecustom7z=true) or (dontsavecustomzip=true) then writeln(conf,inttostr(advopdictionary)) else writeln(conf,inttostr(Form_peach.ComboBoxArchive5.ItemIndex));
if (dontsavecustom7z=true) or (dontsavecustomzip=true) then writeln(conf,inttostr(advopword)) else writeln(conf,inttostr(Form_peach.ComboBoxArchive6.ItemIndex));
if (dontsavecustom7z=true) or (dontsavecustomzip=true) then writeln(conf,inttostr(advoppasses)) else writeln(conf,inttostr(Form_peach.ComboBoxArchivePasses.ItemIndex));
if (dontsavecustom7z=true) or (dontsavecustomzip=true) then writeln(conf,inttostr(advopblocksize)) else writeln(conf,inttostr(Form_peach.ComboBoxArchiveSolid.ItemIndex));
writeln(conf,'');
writeln(conf,'[auto close PeaZip when task completes]');
writeln(conf,inttostr(autoclosepeazip));
writeln(conf,'');
writeln(conf,'[ZPAQ advanced extraction options]');
writeln(conf,inttostr(zpaqall));
writeln(conf,inttostr(zpaqabsolute));
writeln(conf,inttostr(zpaqforce));
writeln(conf,'');
writeln(conf,'[Custom other parameters for 7z/p7zip and Arc]');
writeln(conf,Form_peach.EditOP.Caption);
writeln(conf,Form_peach.EditOParc.Caption);
writeln(conf,'');
writeln(conf,'[set 7z/p7zip archive time from most recent file time]');
writeln(conf,inttostr(stl7z));
writeln(conf,'');
writeln(conf,'[maximize Brotli compression using larger memory --large_window=27 (may be incompatible with some Brotli extractors)]');
writeln(conf,inttostr(maxbrotli));
writeln(conf,'');
writeln(conf,'[maximize Zstandard compression using larger memory window]');
writeln(conf,inttostr(maxzstd));
writeln(conf,'');
writeln(conf,'[do not ask confirmation to delete after extraction / archiving]');
writeln(conf,inttostr(noconfdel));
writeln(conf,'');
writeln(conf,'[automatically configure Custom compression to use Rar.exe as compressor, if WinRar is installed');
writeln(conf,inttostr(userar));
writeln(conf,'');
writeln(conf,'[default Rar.exe compression level]');
writeln(conf,inttostr(level_rar));
writeln(conf,'');
writeln(conf,'[1 create RAR5 (default) 0 create legacy RAR4]');
writeln(conf,inttostr(userar5));
writeln(conf,'');
writeln(conf,'[RAR5 dictionary size');
writeln(conf,inttostr(userardict));
writeln(conf,'');
writeln(conf,'[RAR5 use BLAKE2 hash instead of CRC]');
writeln(conf,inttostr(userarblake2));
writeln(conf,'');
writeln(conf,'[RAR create sfx]');
writeln(conf,inttostr(userarsfx));
writeln(conf,'');
writeln(conf,'[RAR create solid archive]');
writeln(conf,inttostr(userarsolid));
writeln(conf,'');
writeln(conf,'[RAR create recovery records]');
writeln(conf,inttostr(userarrr));
writeln(conf,'');
writeln(conf,'[RAR recovery records %]');
writeln(conf,inttostr(puserarrr));
writeln(conf,'');
writeln(conf,'[RAR save files open for writing]');
writeln(conf,inttostr(userarsaveopen));
writeln(conf,'');
writeln(conf,'[RAR save NT security]');
writeln(conf,inttostr(userarsavesecurity));
writeln(conf,'');
writeln(conf,'[RAR save NTFS alternate streams]');
writeln(conf,inttostr(userarsavestreams));
writeln(conf,'');
writeln(conf,'[RAR set archive time from most recent file time]');
writeln(conf,inttostr(userarlastmodtime));
writeln(conf,'');
writeln(conf,'[RAR lock archive]');
writeln(conf,inttostr(userarlock));
writeln(conf,'');
writeln(conf,'[switch to zipx extension form non-Deflate zip archives]');
writeln(conf,inttostr(swzipx));
writeln(conf,'');
writeln(conf,'[close PeaZip after extraction if no browsing actions took place]');
writeln(conf,inttostr(closeonsingleextract));
writeln(conf,'');
writeln(conf,'[protect drag and drop target window during operation: 0 no protection 1 lock 2 hide 3 lock and hide]');
writeln(conf,inttostr(dragtargetprotect));
writeln(conf,'');
writeln(conf,'[extract everything for special file types in archive: 0 never 1 ask 2 always; 0 entire archive, 1 displayed items only]');
writeln(conf,inttostr(whenspecialopen));
writeln(conf,inttostr(howspecialopen));
writeln(conf,'');
writeln(conf,'[custom code page for ZIP files, when -mcp option is used]');
writeln(conf,Form_peach.EditEncoding.Caption);
writeln(conf,'');
writeln(conf,'[update archive tree when browsing: 0 no 1 simple 2 full, keep visited nodes]');
writeln(conf,inttostr(ptsync));
writeln(conf,'');
writeln(conf,'[use system 7z]');
writeln(conf,inttostr(sys7zlin));
writeln(conf,'');
writeln(conf,'[interactive extraction, two steps: first extract to a fresh folder, then move to relative path in destination directory]');
writeln(conf,inttostr(movetorelativepath));
writeln(conf,'');
writeln(conf,'[tasks priority]');
writeln(conf,inttostr(taskpriority));
writeln(conf,'');
writeln(conf,'[special file types triggering extract everything for]');
writeln(conf,Form_peach.editExtEvForWhat.Caption);
writeln(conf,'');
writeln(conf,'[custom archive extension]');
writeln(conf,inttostr(repcustext));
writeln(conf,Form_peach.editcustext.Caption);
writeln(conf,'');
writeln(conf,'[try to browse non-canonical archive formats]');
writeln(conf,inttostr(forcebrowse));
writeln(conf,'');
writeln(conf,'[try to convert non-canonical archive formats]');
writeln(conf,inttostr(forceconvert));
writeln(conf,'');
writeln(conf,'[force typing password in backend console, apply also to generated scripts]');
writeln(conf,inttostr(intpw));
writeln(conf,'');
writeln(conf,'[default action on start-up for single input, e.g. double-click on associated file type from the system]');
writeln(conf,inttostr(defaultactionst));
writeln(conf,'');
writeln(conf,'[enable "Extract and open with" submenu]');
writeln(conf,inttostr(enableextand));
writeln(conf,'');
writeln(conf,'[(Windows) use integrated Extrac32 to unpack CAB 1=yes (default) 0=no NOTE: overridden by Free Software compliance setting if > 0]');
writeln(conf,inttostr(useextrac32));
writeln(conf,'');
writeln(conf,'[store Created and Last access timestamps in archive types supporting it]');
writeln(conf,inttostr(storecreated));
writeln(conf,'');
writeln(conf,'[skip testing archives for encryption before extraction]');
writeln(conf,inttostr(skipenctest));
writeln(conf,'');
writeln(conf,'[extended columns]');
if ccreated=true then writeln(conf,'1') else writeln(conf,'0');
if caccessed=true then writeln(conf,'1') else writeln(conf,'0');
if cmethod=true then writeln(conf,'1') else writeln(conf,'0');
if (browsertype=0) and (Form_Peach.EditOpenIn.Caption<>txt_mypc) and (fun='UN7Z') then
   if cmethod=false then
      writeln(conf,inttostr(col7size))
   else
      writeln(conf,inttostr(Form_Peach.ListView1.Column[7].Width))
else writeln(conf,inttostr(col7size));
writeln(conf,'');
writeln(conf,'[preferred checksum and hash algorithms]');
writeln(conf,Form_peach.Editcommonalgo.Caption);
writeln(conf,'');
writeln(conf,'[multiple-byte unit: 0 binary, multiple of 1024 (IEC kibibyte); 1 decimal, multiple of 1000 (IEC kilobyte); 2 no conversion, exact byte size]');
writeln(conf,inttostr(filesizebase));
writeln(conf,'');
writeln(conf,'[maximum length for arguments]');
writeln(conf,inttostr(maxargsize));
writeln(conf,'');
writeln(conf,'[skip deletion of locked files without interactive confirmation]');
writeln(conf,inttostr(skipdel));
writeln(conf,'');
writeln(conf,'[ignore interactive extraction option when creating scripts from Console tab]');
writeln(conf,inttostr(disableintscript));
writeln(conf,'');
writeln(conf,'[apply advanced inclusion and exclusion filters to archive browser]');
writeln(conf,inttostr(filterbrowser));
writeln(conf,'');
writeln(conf,'[load layout at startup]');
writeln(conf,inttostr(forcelayout));
writeln(conf,Form_peach.LabelForceLayout.Caption);
writeln(conf,'');
writeln(conf,'[immediate execution of custom compression profile or preset]');
writeln(conf,inttostr(immediate_execution));
writeln(conf,'');
writeln(conf,'[default archive creation action (new archive, add, update...)]');
if Form_peach.LabelStatus4.caption='' then writeln(conf,inttostr(form_peach.ComboBoxArchive7.ItemIndex))
else writeln(conf,inttostr(defaultarchiveaction));
writeln(conf,'');
writeln(conf,'[show search bar, and position]');
writeln(conf,inttostr(showsearchbar));
writeln(conf,inttostr(splitsearchsize));
writeln(conf,'');
writeln(conf,'[7z backend, propagate Zone.Identifier stream to extracted files (Windows)]');
writeln(conf,inttostr(snz7z));
writeln(conf,'');
writeln(conf,'[TAR standard]');
writeln(conf,inttostr(tartype));
writeln(conf,'');
writeln(conf,'[timestamp precision]');
writeln(conf,inttostr(tartime));
writeln(conf,'');
writeln(conf,'[7z backend, store owner/group ids and names in TAR archives (Linux)');
writeln(conf,inttostr(snoi7z));
writeln(conf,inttostr(snon7z));
writeln(conf,'');
writeln(conf,'[test archives after creation, for supported formats]');
writeln(conf,inttostr(autotest));
writeln(conf,'');
writeln(conf,'[tool bar large icon size]');
writeln(conf,inttostr(lsize));
writeln(conf,'');
writeln(conf,'[7z/p7zip do not change last access time]');
writeln(conf,inttostr(ssp7z));
writeln(conf,'');
writeln(conf,'[WIM, TAR store hard links as links]');
writeln(conf,inttostr(snh7z));
writeln(conf,'');
writeln(conf,'[WIM, TAR store symbolic links as links]');
writeln(conf,inttostr(snl7z));
writeln(conf,'');
writeln(conf,'[7z max memory usage %, 0 default]');
writeln(conf,inttostr(memuse_option));
writeln(conf,'');
writeln(conf,'[automatically extract TAR archive from TAR.* files, for extract and convert]');
writeln(conf,inttostr(tar_atomic));
writeln(conf,inttostr(tar_atomic_convert));
writeln(conf,'');
writeln(conf,'[ZPAQ rebuild full paths]');
writeln(conf,inttostr(zpaqfull));
writeln(conf,'');
writeln(conf,'[sort dirs before files]');
writeln(conf,inttostr(dirbeforefiles));
writeln(conf,'');
writeln(conf,'[7z / p7zip syntax level 0 latest tested for the app, 1 21.07]');
writeln(conf,inttostr(syntaxlevel7z));
writeln(conf,'');
writeln(conf,'[archive converion scripts allow user''s interaction]');
writeln(conf,inttostr(convint));
writeln(conf,'');
writeln(conf,'[7z / p7zip exclude empty folders]');
writeln(conf,inttostr(excludeef));
writeln(conf,'');
writeln(conf,'[enlarge file browser icons]');
if enlargeicons=true then writeln(conf,'1') else writeln(conf,'0');
writeln(conf,'');
writeln(conf,'[Use quick deduplication routine]');
writeln(conf,inttostr(qdup));
end;

function geticon(fullname,fulltype:ansistring; pc:boolean):integer;
var
   s,ext:ansistring;
begin
result:=-1;
ext:=lowercase(fulltype);
if pc=true then
   begin
   if ext = lowercase(txt_unit_removable) then result:=11; //Bremovable_supported
   if ext = lowercase(txt_unit_hd) then result:=8; //Bhd_supported
   if ext = lowercase(txt_unit_remote) then result:=10; //Bremote_supported
   if ext = lowercase(txt_unit_cd) then result:=6; //Bdvd_supported
   if ext = lowercase(txt_unit_ram) then result:=9; //Bram_supported
   if ext = lowercase(txt_unit_floppy) then result:=7; //Bfd_supported
   exit;
   end;
s:=fullname;
if (ext=lowercase(txt_list_isfolder)) or (ext=' [folder]') then begin result:=3; exit; end;
case ext of
'.lnk': result:=4;
'.txt','asc','.rtf','.wri','.ini','.log': result:=14;
'.doc','.dot','.docx','.dotx','.odt','.sxw','.wpd','.wps','.wpt','.gdoc','.tmdx': result:=2;
'.xls','.xlt','.xlsx','.xltm','.xltx','.ods','.gnm','.gnumeric','.csv','.123',
'.sxc','.gsheet','.numbers','.numbers-tef','.dif','.pmdx','.pmvx': result:=13;
'.pps','.ppt','.pot','.pptx','.ppsx','.potx','.odp','.gslides','.prdx': result:=18;
'.db','.dbf','.mdb','.adp','.mdf','.nsf','.dat','.fp','.fp3','.fp5','.fp7',
'.frm','.odb','.ora','.sql','.sqlite','.wdb','.rpt': result:=24;
'.eml': result:=23;
'.bat','.pif','.scr','.vbs','.cmd','.reg','.sh','.command','.csh': result:=20;
'.dll','.sys','.so': result:=22;
'.htm','.html','.xml','.mht','.url': result:=16;
'.pdf': result:=19;
'.ani','.cur','.ico','.icl','.icns','.xbm','.xpm': result:=26;
'.svg','.ps','.eps','.cdr','.ai','.cpt','.psd','.psp','.xcf','.pdn','.blend',
'.dwf','.dwg','.3ds','.pict','.pic','.pct','.dxf','.wmf','.djvu','.djv','.xps',
'.oxps','.tex','.gdraw','.pub','.pmd': result:=27;
'.png','.bmp','.tga','.tif','.tiff','.pbm','.pgm','.ppm','.pns': result:=17;
'.gif': result:=25;
'.jpg','.jpe','.jpeg','.jif','.jfif','.jfi','.jpx','.jp2','.j2k','.webp','.jps',
'.mpo','.heif','.heic': result:=35;
'.avi','.mpg','.mpeg','.mpe','.mpv','.mp2','.m2v','.xvid','.divx','.mp4','.m4v',
'.m4p','.mov','.qt','.3gp','.3g2','.wmv','.swf','.flv','.f4p','.f4v','.fla',
'.mkv','.mk3d','.webm','.vob','.ogv','.rm','.rmvb','.asf','.amv','.svi','.nsv',
'.mng','.apng','.mts','.ts': result:=15;
'.wav','.mp3','.mid','.wma','.aiff','.au','.ogg','.oga','.aac','.amr','.ape',
'.flac','.wv','.m4a','.mpc','.ra','.pcm','.gsm','.aa','.aax','.m4b','.mmf',
'.opus','.tta','.vox': result:=12;
'.7z':result:=45;
'.rar':result:=46;
'.zip','.zipx':result:=47;
'.001','.r01','.z01','.zx01':result:=48;
'.iso':result:=49;
'.deb','.rpm','.appx','.msix','.snap','.appimage':result:=50;
else
case testext(s) of //most used special formats are intercepted before
   -1: result:=5; //BUnsupported
   503: result:=21;//any other primarily non archive format not intercepted before (like swf fla flv)
   502: result:=21;//other office files, non executable compound
   501: result:=21;//other ooo files
   500: result:=1;//exe and msi
   else
      result:=0;//generic archives
   end;
end;
end;

function pgetbitmap(i:integer):TBitmap;
begin
case i of
   0: result:=Barchivesupported;
   1: result:=Bexesupported;
   2: result:=Bfilesupported;
   3: result:=Bfolder;
   4: result:=Blink;
   5: result:=Bunsupported;
   6: result:=Bdvd_supported;
   7: result:=Bfd_supported;
   8: result:=Bhd_supported;
   9: result:=Bram_supported;
  10: result:=Bremote_supported;
  11: result:=Bremovable_supported;
  12: result:=Baudio;
  13: result:=Bspreadsheet;
  14: result:=Btxt;
  15: result:=Bvideo;
  16: result:=Bweb;
  17: result:=Bimage;
  18: result:=Bpresentation;
  19: result:=Bpdf;
  20: result:=Bbat;
  21: result:=Bsupported;
  22: result:=Bdll;
  23: result:=Bmail;
  24: result:=Bdb;
  25: result:=Bgif;
  26: result:=Bico;
  27: result:=Bvector;
  28: result:=Binfo;
  29: result:=Bsearch;
  30: result:=Bbookmark;
  31: result:=Broot;
  32: result:=Bsystemtools;
  33: result:=Bexpand;
  34: result:=Bgopath;
  35: result:=Bjpeg;
  45: result:=Barc7z;
  46: result:=Barcrar;
  47: result:=Barczip;
  48: result:=Barcblock;
  49: result:=Barcdisk;
  50: result:=Barcinstaller;
   else result:=Bunsupported;
   end;
end;

function drawmenuicon(s1:ansistring):TBitmap;
var
   fulltype:ansistring;
   i:integer;
begin
with Form_peach do
begin
if s1='' then
   begin
   result:=nil;
   exit;
   end;
if (s1 = desktop_path) or (s1 = txt_desktop) then
   begin
   result:=Bdesk;
   exit;
   end;
if (s1 = home_path) or (s1 = txt_2_9_home) then
   begin
   result:=Bhomefolder;
   exit;
   end;
if (s1 = usr_documents) or (s1 = txt_2_4_documents) then
   begin
   result:=Bfilesupported;
   exit;
   end;
if (s1 = usr_downloads) or (s1 = txt_3_1_downloads) then
   begin
   result:=Bdownloadfolder;
   exit;
   end;
if (s1 = usr_music) or (s1 = txt_5_0_music) then
   begin
   result:=Baudio;
   exit;
   end;
if (s1 = usr_pictures) or (s1 = txt_5_0_pictures) then
   begin
   result:=Bimage;
   exit;
   end;
if (s1 = usr_videos) or (s1 = txt_5_0_videos) then
   begin
   result:=Bvideo;
   exit;
   end;
if (s1 = shared_dropbox) or (s1 = shared_myboxfiles) or (s1 = shared_googledrive)
   or (s1 = shared_onedrive) or (s1 = shared_skydrive) or (s1 = shared_ubuntuone)then
   begin
   result:=Bcloudfolder;
   exit;
   end;
{$IFDEF MSWINDOWS}
if (s1 = txt_mypc) or (s1 = 'Computer''s root') then
   begin
   result:=Bsystemtools;
   exit;
   end;
if length(s1) = 3 then
   begin
   i:=ord(s1[1])-64;
   result:=devicon[i];
   exit;
   end;
{$ENDIF}
if s1<>'' then
   if s1[length(s1)]=directoryseparator then fulltype:=txt_list_isfolder
else fulltype:=extractfileext(s1);
result:=pgetbitmap(geticon(s1,fulltype,false));
end;
end;

function drawhistoryicon(n:integer):TBitmap;
var
   s1,s2:ansistring;
begin
with Form_peach do
begin
s1:=StringGridSessionHistory.Cells[2,n];
if s1='' then
   begin
   result:=nil;
   exit;
   end;
if StringGridSessionHistory.Cells[1,n] = txt_list_found then
   begin
   result:=Bsearch;
   exit;
   end;
if StringGridSessionHistory.Cells[1,n] = txt_list_flat then
   begin
   result:=Bexpand;
   exit;
   end;
s2:=StringGridSessionHistory.Cells[3,n];
if s2<>''
   then s2:=s2[length(s2)];
if s2<>'*' then
   begin
   result:=Bgopath;
   exit;
   end;
result:=drawmenuicon(s1);
end;
end;

function drawrecenticon(s:ansistring):TBitmap;
var
   fulltype:ansistring;
   i:integer;
begin
with Form_peach do
begin
if s='' then
   begin
   result:=nil;
   exit;
   end;
{$IFDEF MSWINDOWS}
if (s = txt_mypc)  or (s = 'Computer''s root') then
   begin
   result:=Bsystemtools;
   exit;
   end;
if length(s) = 3 then
   begin
   i:=ord(s[1])-64;
   result:=devicon[i];
   exit;
   end;
{$ENDIF}
if s<>'' then
   if s[length(s)]=directoryseparator then fulltype:=txt_list_isfolder
   else fulltype:=extractfileext(s);
result:=pgetbitmap(geticon(s,fulltype,false));
end;
end;

procedure populaterecenticons;
begin
with Form_peach do
begin
if mRecent1.visible=true then mRecent1.Bitmap:=drawrecenticon(mRecent1.Caption);
if mRecent2.visible=true then mRecent2.Bitmap:=drawrecenticon(mRecent2.Caption);
if mRecent3.visible=true then mRecent3.Bitmap:=drawrecenticon(mRecent3.Caption);
if mRecent4.visible=true then mRecent4.Bitmap:=drawrecenticon(mRecent4.Caption);
if mRecent5.visible=true then mRecent5.Bitmap:=drawrecenticon(mRecent5.Caption);
if mRecent6.visible=true then mRecent6.Bitmap:=drawrecenticon(mRecent6.Caption);
if mRecent7.visible=true then mRecent7.Bitmap:=drawrecenticon(mRecent7.Caption);
if mRecent8.visible=true then mRecent8.Bitmap:=drawrecenticon(mRecent8.Caption);
if pmhr1.visible=true then pmhr1.Bitmap:=mRecent1.Bitmap;
if pmhr2.visible=true then pmhr2.Bitmap:=mRecent2.Bitmap;
if pmhr3.visible=true then pmhr3.Bitmap:=mRecent3.Bitmap;
if pmhr4.visible=true then pmhr4.Bitmap:=mRecent4.Bitmap;
if pmhr5.visible=true then pmhr5.Bitmap:=mRecent5.Bitmap;
if pmhr6.visible=true then pmhr6.Bitmap:=mRecent6.Bitmap;
if pmhr7.visible=true then pmhr7.Bitmap:=mRecent7.Bitmap;
if pmhr8.visible=true then pmhr8.Bitmap:=mRecent8.Bitmap;
if pmhr1.visible=true then pmamr1.Bitmap:=mRecent1.Bitmap;
if pmhr2.visible=true then pmamr2.Bitmap:=mRecent2.Bitmap;
if pmhr3.visible=true then pmamr3.Bitmap:=mRecent3.Bitmap;
if pmhr4.visible=true then pmamr4.Bitmap:=mRecent4.Bitmap;
if pmhr5.visible=true then pmamr5.Bitmap:=mRecent5.Bitmap;
if pmhr6.visible=true then pmamr6.Bitmap:=mRecent6.Bitmap;
if pmhr7.visible=true then pmamr7.Bitmap:=mRecent7.Bitmap;
if pmhr8.visible=true then pmamr8.Bitmap:=mRecent8.Bitmap;
end;
end;

procedure populaterecenticonsf;
begin
with Form_peach do
begin
if mRecent1f.visible=true then mRecent1f.Bitmap:=drawmenuicon(mRecent1f.Caption);
if mRecent2f.visible=true then mRecent2f.Bitmap:=drawmenuicon(mRecent2f.Caption);
if mRecent3f.visible=true then mRecent3f.Bitmap:=drawmenuicon(mRecent3f.Caption);
if mRecent4f.visible=true then mRecent4f.Bitmap:=drawmenuicon(mRecent4f.Caption);
if mRecent5f.visible=true then mRecent5f.Bitmap:=drawmenuicon(mRecent5f.Caption);
if mRecent6f.visible=true then mRecent6f.Bitmap:=drawmenuicon(mRecent6f.Caption);
if mRecent7f.visible=true then mRecent7f.Bitmap:=drawmenuicon(mRecent7f.Caption);
if mRecent8f.visible=true then mRecent8f.Bitmap:=drawmenuicon(mRecent8f.Caption);
if pmhr1f.visible=true then pmhr1f.Bitmap:=mRecent1f.Bitmap;
if pmhr2f.visible=true then pmhr2f.Bitmap:=mRecent2f.Bitmap;
if pmhr3f.visible=true then pmhr3f.Bitmap:=mRecent3f.Bitmap;
if pmhr4f.visible=true then pmhr4f.Bitmap:=mRecent4f.Bitmap;
if pmhr5f.visible=true then pmhr5f.Bitmap:=mRecent5f.Bitmap;
if pmhr6f.visible=true then pmhr6f.Bitmap:=mRecent6f.Bitmap;
if pmhr7f.visible=true then pmhr7f.Bitmap:=mRecent7f.Bitmap;
if pmhr8f.visible=true then pmhr8f.Bitmap:=mRecent8f.Bitmap;
end;
end;

procedure setrecenticons_extract_archive;
begin
Form_peach.pnr1.Caption:=Form_peach.mRecent1f.Caption;
Form_peach.pnr2.Caption:=Form_peach.mRecent2f.Caption;
Form_peach.pnr3.Caption:=Form_peach.mRecent3f.Caption;
Form_peach.pnr4.Caption:=Form_peach.mRecent4f.Caption;
Form_peach.pnr5.Caption:=Form_peach.mRecent5f.Caption;
Form_peach.pnr6.Caption:=Form_peach.mRecent6f.Caption;
Form_peach.pnr7.Caption:=Form_peach.mRecent7f.Caption;
Form_peach.pnr8.Caption:=Form_peach.mRecent8f.Caption;
Form_peach.pmemr1.Caption:=Form_peach.mRecent1f.Caption;
Form_peach.pmemr2.Caption:=Form_peach.mRecent2f.Caption;
Form_peach.pmemr3.Caption:=Form_peach.mRecent3f.Caption;
Form_peach.pmemr4.Caption:=Form_peach.mRecent4f.Caption;
Form_peach.pmemr5.Caption:=Form_peach.mRecent5f.Caption;
Form_peach.pmemr6.Caption:=Form_peach.mRecent6f.Caption;
Form_peach.pmemr7.Caption:=Form_peach.mRecent7f.Caption;
Form_peach.pmemr8.Caption:=Form_peach.mRecent8f.Caption;
Form_peach.pnra1.Caption:=Form_peach.mRecent1f.Caption;
Form_peach.pnra2.Caption:=Form_peach.mRecent2f.Caption;
Form_peach.pnra3.Caption:=Form_peach.mRecent3f.Caption;
Form_peach.pnra4.Caption:=Form_peach.mRecent4f.Caption;
Form_peach.pnra5.Caption:=Form_peach.mRecent5f.Caption;
Form_peach.pnra6.Caption:=Form_peach.mRecent6f.Caption;
Form_peach.pnra7.Caption:=Form_peach.mRecent7f.Caption;
Form_peach.pnra8.Caption:=Form_peach.mRecent8f.Caption;
Form_peach.pnr1.Visible:=Form_peach.mRecent1f.Visible;
Form_peach.pnr2.Visible:=Form_peach.mRecent2f.Visible;
Form_peach.pnr3.Visible:=Form_peach.mRecent3f.Visible;
Form_peach.pnr4.Visible:=Form_peach.mRecent4f.Visible;
Form_peach.pnr5.Visible:=Form_peach.mRecent5f.Visible;
Form_peach.pnr6.Visible:=Form_peach.mRecent6f.Visible;
Form_peach.pnr7.Visible:=Form_peach.mRecent7f.Visible;
Form_peach.pnr8.Visible:=Form_peach.mRecent8f.Visible;
Form_peach.pmemr1.Visible:=Form_peach.mRecent1f.Visible;
Form_peach.pmemr2.Visible:=Form_peach.mRecent2f.Visible;
Form_peach.pmemr3.Visible:=Form_peach.mRecent3f.Visible;
Form_peach.pmemr4.Visible:=Form_peach.mRecent4f.Visible;
Form_peach.pmemr5.Visible:=Form_peach.mRecent5f.Visible;
Form_peach.pmemr6.Visible:=Form_peach.mRecent6f.Visible;
Form_peach.pmemr7.Visible:=Form_peach.mRecent7f.Visible;
Form_peach.pmemr8.Visible:=Form_peach.mRecent8f.Visible;
Form_peach.pnra1.Visible:=Form_peach.mRecent1f.Visible;
Form_peach.pnra2.Visible:=Form_peach.mRecent2f.Visible;
Form_peach.pnra3.Visible:=Form_peach.mRecent3f.Visible;
Form_peach.pnra4.Visible:=Form_peach.mRecent4f.Visible;
Form_peach.pnra5.Visible:=Form_peach.mRecent5f.Visible;
Form_peach.pnra6.Visible:=Form_peach.mRecent6f.Visible;
Form_peach.pnra7.Visible:=Form_peach.mRecent7f.Visible;
Form_peach.pnra8.Visible:=Form_peach.mRecent8f.Visible;
if Form_peach.pnr1.visible=true then Form_peach.pnr1.Bitmap:=Form_peach.mRecent1f.Bitmap;
if Form_peach.pnr2.visible=true then Form_peach.pnr2.Bitmap:=Form_peach.mRecent2f.Bitmap;
if Form_peach.pnr3.visible=true then Form_peach.pnr3.Bitmap:=Form_peach.mRecent3f.Bitmap;
if Form_peach.pnr4.visible=true then Form_peach.pnr4.Bitmap:=Form_peach.mRecent4f.Bitmap;
if Form_peach.pnr5.visible=true then Form_peach.pnr5.Bitmap:=Form_peach.mRecent5f.Bitmap;
if Form_peach.pnr6.visible=true then Form_peach.pnr6.Bitmap:=Form_peach.mRecent6f.Bitmap;
if Form_peach.pnr7.visible=true then Form_peach.pnr7.Bitmap:=Form_peach.mRecent7f.Bitmap;
if Form_peach.pnr8.visible=true then Form_peach.pnr8.Bitmap:=Form_peach.mRecent8f.Bitmap;
if Form_peach.pmemr1.visible=true then Form_peach.pmemr1.Bitmap:=Form_peach.mRecent1f.Bitmap;
if Form_peach.pmemr2.visible=true then Form_peach.pmemr2.Bitmap:=Form_peach.mRecent2f.Bitmap;
if Form_peach.pmemr3.visible=true then Form_peach.pmemr3.Bitmap:=Form_peach.mRecent3f.Bitmap;
if Form_peach.pmemr4.visible=true then Form_peach.pmemr4.Bitmap:=Form_peach.mRecent4f.Bitmap;
if Form_peach.pmemr5.visible=true then Form_peach.pmemr5.Bitmap:=Form_peach.mRecent5f.Bitmap;
if Form_peach.pmemr6.visible=true then Form_peach.pmemr6.Bitmap:=Form_peach.mRecent6f.Bitmap;
if Form_peach.pmemr7.visible=true then Form_peach.pmemr7.Bitmap:=Form_peach.mRecent7f.Bitmap;
if Form_peach.pmemr8.visible=true then Form_peach.pmemr8.Bitmap:=Form_peach.mRecent8f.Bitmap;
if Form_peach.pnra1.visible=true then Form_peach.pnra1.Bitmap:=Form_peach.mRecent1f.Bitmap;
if Form_peach.pnra2.visible=true then Form_peach.pnra2.Bitmap:=Form_peach.mRecent2f.Bitmap;
if Form_peach.pnra3.visible=true then Form_peach.pnra3.Bitmap:=Form_peach.mRecent3f.Bitmap;
if Form_peach.pnra4.visible=true then Form_peach.pnra4.Bitmap:=Form_peach.mRecent4f.Bitmap;
if Form_peach.pnra5.visible=true then Form_peach.pnra5.Bitmap:=Form_peach.mRecent5f.Bitmap;
if Form_peach.pnra6.visible=true then Form_peach.pnra6.Bitmap:=Form_peach.mRecent6f.Bitmap;
if Form_peach.pnra7.visible=true then Form_peach.pnra7.Bitmap:=Form_peach.mRecent7f.Bitmap;
if Form_peach.pnra8.visible=true then Form_peach.pnra8.Bitmap:=Form_peach.mRecent8f.Bitmap;
Form_peach.pmemrf1.Caption:=Form_peach.mRecent1f.Caption;
Form_peach.pmemrf2.Caption:=Form_peach.mRecent2f.Caption;
Form_peach.pmemrf3.Caption:=Form_peach.mRecent3f.Caption;
Form_peach.pmemrf4.Caption:=Form_peach.mRecent4f.Caption;
Form_peach.pmemrf5.Caption:=Form_peach.mRecent5f.Caption;
Form_peach.pmemrf6.Caption:=Form_peach.mRecent6f.Caption;
Form_peach.pmemrf7.Caption:=Form_peach.mRecent7f.Caption;
Form_peach.pmemrf8.Caption:=Form_peach.mRecent8f.Caption;
Form_peach.pmemrf1.Visible:=Form_peach.mRecent1f.Visible;
Form_peach.pmemrf2.Visible:=Form_peach.mRecent2f.Visible;
Form_peach.pmemrf3.Visible:=Form_peach.mRecent3f.Visible;
Form_peach.pmemrf4.Visible:=Form_peach.mRecent4f.Visible;
Form_peach.pmemrf5.Visible:=Form_peach.mRecent5f.Visible;
Form_peach.pmemrf6.Visible:=Form_peach.mRecent6f.Visible;
Form_peach.pmemrf7.Visible:=Form_peach.mRecent7f.Visible;
Form_peach.pmemrf8.Visible:=Form_peach.mRecent8f.Visible;
if Form_peach.pmemrf1.visible=true then Form_peach.pmemrf1.Bitmap:=Form_peach.mRecent1f.Bitmap;
if Form_peach.pmemrf2.visible=true then Form_peach.pmemrf2.Bitmap:=Form_peach.mRecent2f.Bitmap;
if Form_peach.pmemrf3.visible=true then Form_peach.pmemrf3.Bitmap:=Form_peach.mRecent3f.Bitmap;
if Form_peach.pmemrf4.visible=true then Form_peach.pmemrf4.Bitmap:=Form_peach.mRecent4f.Bitmap;
if Form_peach.pmemrf5.visible=true then Form_peach.pmemrf5.Bitmap:=Form_peach.mRecent5f.Bitmap;
if Form_peach.pmemrf6.visible=true then Form_peach.pmemrf6.Bitmap:=Form_peach.mRecent6f.Bitmap;
if Form_peach.pmemrf7.visible=true then Form_peach.pmemrf7.Bitmap:=Form_peach.mRecent7f.Bitmap;
if Form_peach.pmemrf8.visible=true then Form_peach.pmemrf8.Bitmap:=Form_peach.mRecent8f.Bitmap;
end;

procedure addtofolderhistory(s:ansistring);
begin
if savehistory=0 then exit;
if s<>Form_peach.mRecent1f.Caption then
   if s<>Form_peach.mRecent2f.Caption then
      if s<>Form_peach.mRecent3f.Caption then
         if s<>Form_peach.mRecent4f.Caption then
            if s<>Form_peach.mRecent5f.Caption then
               if s<>Form_peach.mRecent6f.Caption then
                  if s<>Form_peach.mRecent7f.Caption then
                     begin
                     Form_peach.mRecent8f.Caption:=Form_peach.mRecent7f.Caption;
                     Form_peach.mRecent7f.Caption:=Form_peach.mRecent6f.Caption;
                     Form_peach.mRecent6f.Caption:=Form_peach.mRecent5f.Caption;
                     Form_peach.mRecent5f.Caption:=Form_peach.mRecent4f.Caption;
                     Form_peach.mRecent4f.Caption:=Form_peach.mRecent3f.Caption;
                     Form_peach.mRecent3f.Caption:=Form_peach.mRecent2f.Caption;
                     Form_peach.mRecent2f.Caption:=Form_peach.mRecent1f.Caption;
                     Form_peach.mRecent1f.Caption:=s;
                     end
                  else
                     begin
                     Form_peach.mRecent7f.Caption:=Form_peach.mRecent6f.Caption;
                     Form_peach.mRecent6f.Caption:=Form_peach.mRecent5f.Caption;
                     Form_peach.mRecent5f.Caption:=Form_peach.mRecent4f.Caption;
                     Form_peach.mRecent4f.Caption:=Form_peach.mRecent3f.Caption;
                     Form_peach.mRecent3f.Caption:=Form_peach.mRecent2f.Caption;
                     Form_peach.mRecent2f.Caption:=Form_peach.mRecent1f.Caption;
                     Form_peach.mRecent1f.Caption:=s;
                     end
               else
                  begin
                  Form_peach.mRecent6f.Caption:=Form_peach.mRecent5f.Caption;
                  Form_peach.mRecent5f.Caption:=Form_peach.mRecent4f.Caption;
                  Form_peach.mRecent4f.Caption:=Form_peach.mRecent3f.Caption;
                  Form_peach.mRecent3f.Caption:=Form_peach.mRecent2f.Caption;
                  Form_peach.mRecent2f.Caption:=Form_peach.mRecent1f.Caption;
                  Form_peach.mRecent1f.Caption:=s;
                  end
            else
               begin
               Form_peach.mRecent5f.Caption:=Form_peach.mRecent4f.Caption;
               Form_peach.mRecent4f.Caption:=Form_peach.mRecent3f.Caption;
               Form_peach.mRecent3f.Caption:=Form_peach.mRecent2f.Caption;
               Form_peach.mRecent2f.Caption:=Form_peach.mRecent1f.Caption;
               Form_peach.mRecent1f.Caption:=s;
               end
         else
            begin
            Form_peach.mRecent4f.Caption:=Form_peach.mRecent3f.Caption;
            Form_peach.mRecent3f.Caption:=Form_peach.mRecent2f.Caption;
            Form_peach.mRecent2f.Caption:=Form_peach.mRecent1f.Caption;
            Form_peach.mRecent1f.Caption:=s;
            end
      else
         begin
         Form_peach.mRecent3f.Caption:=Form_peach.mRecent2f.Caption;
         Form_peach.mRecent2f.Caption:=Form_peach.mRecent1f.Caption;
         Form_peach.mRecent1f.Caption:=s;
         end
   else
      begin
      Form_peach.mRecent2f.Caption:=Form_peach.mRecent1f.Caption;
      Form_peach.mRecent1f.Caption:=s;
      end;
if Form_peach.mRecent1f.Caption<>'' then Form_peach.mRecent1f.Visible:=true else Form_peach.mRecent1f.Visible:=false;
if Form_peach.mRecent2f.Caption<>'' then Form_peach.mRecent2f.Visible:=true else Form_peach.mRecent2f.Visible:=false;
if Form_peach.mRecent3f.Caption<>'' then Form_peach.mRecent3f.Visible:=true else Form_peach.mRecent3f.Visible:=false;
if Form_peach.mRecent4f.Caption<>'' then Form_peach.mRecent4f.Visible:=true else Form_peach.mRecent4f.Visible:=false;
if Form_peach.mRecent5f.Caption<>'' then Form_peach.mRecent5f.Visible:=true else Form_peach.mRecent5f.Visible:=false;
if Form_peach.mRecent6f.Caption<>'' then Form_peach.mRecent6f.Visible:=true else Form_peach.mRecent6f.Visible:=false;
if Form_peach.mRecent7f.Caption<>'' then Form_peach.mRecent7f.Visible:=true else Form_peach.mRecent7f.Visible:=false;
if Form_peach.mRecent8f.Caption<>'' then Form_peach.mRecent8f.Visible:=true else Form_peach.mRecent8f.Visible:=false;
Form_peach.pmhr1f.Caption:=Form_peach.mRecent1f.Caption;
Form_peach.pmhr2f.Caption:=Form_peach.mRecent2f.Caption;
Form_peach.pmhr3f.Caption:=Form_peach.mRecent3f.Caption;
Form_peach.pmhr4f.Caption:=Form_peach.mRecent4f.Caption;
Form_peach.pmhr5f.Caption:=Form_peach.mRecent5f.Caption;
Form_peach.pmhr6f.Caption:=Form_peach.mRecent6f.Caption;
Form_peach.pmhr7f.Caption:=Form_peach.mRecent7f.Caption;
Form_peach.pmhr8f.Caption:=Form_peach.mRecent8f.Caption;
Form_peach.pmhr1f.Visible:=Form_peach.mRecent1f.Visible;
Form_peach.pmhr2f.Visible:=Form_peach.mRecent2f.Visible;
Form_peach.pmhr3f.Visible:=Form_peach.mRecent3f.Visible;
Form_peach.pmhr4f.Visible:=Form_peach.mRecent4f.Visible;
Form_peach.pmhr5f.Visible:=Form_peach.mRecent5f.Visible;
Form_peach.pmhr6f.Visible:=Form_peach.mRecent6f.Visible;
Form_peach.pmhr7f.Visible:=Form_peach.mRecent7f.Visible;
Form_peach.pmhr8f.Visible:=Form_peach.mRecent8f.Visible;
setrecenticons_extract_archive;
populaterecenticonsf;
populaterecentpanel;
populatetree;
end;

procedure addtoarchivehistory(s:ansistring);
begin
if savehistory=0 then exit;
if s<>Form_peach.mRecent1.Caption then
   if s<>Form_peach.mRecent2.Caption then
      if s<>Form_peach.mRecent3.Caption then
         if s<>Form_peach.mRecent4.Caption then
            if s<>Form_peach.mRecent5.Caption then
               if s<>Form_peach.mRecent6.Caption then
                  if s<>Form_peach.mRecent7.Caption then
                     begin
                     Form_peach.mRecent8.Caption:=Form_peach.mRecent7.Caption;
                     Form_peach.mRecent7.Caption:=Form_peach.mRecent6.Caption;
                     Form_peach.mRecent6.Caption:=Form_peach.mRecent5.Caption;
                     Form_peach.mRecent5.Caption:=Form_peach.mRecent4.Caption;
                     Form_peach.mRecent4.Caption:=Form_peach.mRecent3.Caption;
                     Form_peach.mRecent3.Caption:=Form_peach.mRecent2.Caption;
                     Form_peach.mRecent2.Caption:=Form_peach.mRecent1.Caption;
                     Form_peach.mRecent1.Caption:=s;
                     end
                  else
                     begin
                     Form_peach.mRecent7.Caption:=Form_peach.mRecent6.Caption;
                     Form_peach.mRecent6.Caption:=Form_peach.mRecent5.Caption;
                     Form_peach.mRecent5.Caption:=Form_peach.mRecent4.Caption;
                     Form_peach.mRecent4.Caption:=Form_peach.mRecent3.Caption;
                     Form_peach.mRecent3.Caption:=Form_peach.mRecent2.Caption;
                     Form_peach.mRecent2.Caption:=Form_peach.mRecent1.Caption;
                     Form_peach.mRecent1.Caption:=s;
                     end
               else
                  begin
                  Form_peach.mRecent6.Caption:=Form_peach.mRecent5.Caption;
                  Form_peach.mRecent5.Caption:=Form_peach.mRecent4.Caption;
                  Form_peach.mRecent4.Caption:=Form_peach.mRecent3.Caption;
                  Form_peach.mRecent3.Caption:=Form_peach.mRecent2.Caption;
                  Form_peach.mRecent2.Caption:=Form_peach.mRecent1.Caption;
                  Form_peach.mRecent1.Caption:=s;
                  end
            else
               begin
               Form_peach.mRecent5.Caption:=Form_peach.mRecent4.Caption;
               Form_peach.mRecent4.Caption:=Form_peach.mRecent3.Caption;
               Form_peach.mRecent3.Caption:=Form_peach.mRecent2.Caption;
               Form_peach.mRecent2.Caption:=Form_peach.mRecent1.Caption;
               Form_peach.mRecent1.Caption:=s;
               end
         else
            begin
            Form_peach.mRecent4.Caption:=Form_peach.mRecent3.Caption;
            Form_peach.mRecent3.Caption:=Form_peach.mRecent2.Caption;
            Form_peach.mRecent2.Caption:=Form_peach.mRecent1.Caption;
            Form_peach.mRecent1.Caption:=s;
            end
      else
         begin
         Form_peach.mRecent3.Caption:=Form_peach.mRecent2.Caption;
         Form_peach.mRecent2.Caption:=Form_peach.mRecent1.Caption;
         Form_peach.mRecent1.Caption:=s;
         end
   else
      begin
      Form_peach.mRecent2.Caption:=Form_peach.mRecent1.Caption;
      Form_peach.mRecent1.Caption:=s;
      end;
if Form_peach.mRecent1.Caption<>'' then Form_peach.mRecent1.Visible:=true else Form_peach.mRecent1.Visible:=false;
if Form_peach.mRecent2.Caption<>'' then Form_peach.mRecent2.Visible:=true else Form_peach.mRecent2.Visible:=false;
if Form_peach.mRecent3.Caption<>'' then Form_peach.mRecent3.Visible:=true else Form_peach.mRecent3.Visible:=false;
if Form_peach.mRecent4.Caption<>'' then Form_peach.mRecent4.Visible:=true else Form_peach.mRecent4.Visible:=false;
if Form_peach.mRecent5.Caption<>'' then Form_peach.mRecent5.Visible:=true else Form_peach.mRecent5.Visible:=false;
if Form_peach.mRecent6.Caption<>'' then Form_peach.mRecent6.Visible:=true else Form_peach.mRecent6.Visible:=false;
if Form_peach.mRecent7.Caption<>'' then Form_peach.mRecent7.Visible:=true else Form_peach.mRecent7.Visible:=false;
if Form_peach.mRecent8.Caption<>'' then Form_peach.mRecent8.Visible:=true else Form_peach.mRecent8.Visible:=false;
Form_peach.pmhr1.Caption:=Form_peach.mRecent1.Caption;
Form_peach.pmhr2.Caption:=Form_peach.mRecent2.Caption;
Form_peach.pmhr3.Caption:=Form_peach.mRecent3.Caption;
Form_peach.pmhr4.Caption:=Form_peach.mRecent4.Caption;
Form_peach.pmhr5.Caption:=Form_peach.mRecent5.Caption;
Form_peach.pmhr6.Caption:=Form_peach.mRecent6.Caption;
Form_peach.pmhr7.Caption:=Form_peach.mRecent7.Caption;
Form_peach.pmhr8.Caption:=Form_peach.mRecent8.Caption;
Form_peach.pmhr1.Visible:=Form_peach.mRecent1.Visible;
Form_peach.pmhr2.Visible:=Form_peach.mRecent2.Visible;
Form_peach.pmhr3.Visible:=Form_peach.mRecent3.Visible;
Form_peach.pmhr4.Visible:=Form_peach.mRecent4.Visible;
Form_peach.pmhr5.Visible:=Form_peach.mRecent5.Visible;
Form_peach.pmhr6.Visible:=Form_peach.mRecent6.Visible;
Form_peach.pmhr7.Visible:=Form_peach.mRecent7.Visible;
Form_peach.pmhr8.Visible:=Form_peach.mRecent8.Visible;
Form_peach.pmamr1.Caption:=(Form_peach.mRecent1.Caption);
Form_peach.pmamr2.Caption:=(Form_peach.mRecent2.Caption);
Form_peach.pmamr3.Caption:=(Form_peach.mRecent3.Caption);
Form_peach.pmamr4.Caption:=(Form_peach.mRecent4.Caption);
Form_peach.pmamr5.Caption:=(Form_peach.mRecent5.Caption);
Form_peach.pmamr6.Caption:=(Form_peach.mRecent6.Caption);
Form_peach.pmamr7.Caption:=(Form_peach.mRecent7.Caption);
Form_peach.pmamr8.Caption:=(Form_peach.mRecent8.Caption);
Form_peach.pmamr1.Visible:=Form_peach.mRecent1.Visible;
Form_peach.pmamr2.Visible:=Form_peach.mRecent2.Visible;
Form_peach.pmamr3.Visible:=Form_peach.mRecent3.Visible;
Form_peach.pmamr4.Visible:=Form_peach.mRecent4.Visible;
Form_peach.pmamr5.Visible:=Form_peach.mRecent5.Visible;
Form_peach.pmamr6.Visible:=Form_peach.mRecent6.Visible;
Form_peach.pmamr7.Visible:=Form_peach.mRecent7.Visible;
Form_peach.pmamr8.Visible:=Form_peach.mRecent8.Visible;
addtofolderhistory(extractfilepath(s));
populaterecenticons;
populaterecentpanel;
populatetree;
end;

procedure addtocustomhistory(s:ansistring);
begin
if s<>Form_peach.pcustom1.Caption then
   if s<>Form_peach.pcustom2.Caption then
      if s<>Form_peach.pcustom3.Caption then
         if s<>Form_peach.pcustom4.Caption then
            if s<>Form_peach.pcustom5.Caption then
               if s<>Form_peach.pcustom6.Caption then
                  if s<>Form_peach.pcustom7.Caption then
                     begin
                     Form_peach.pcustom8.Caption:=Form_peach.pcustom7.Caption;
                     Form_peach.pcustom7.Caption:=Form_peach.pcustom6.Caption;
                     Form_peach.pcustom6.Caption:=Form_peach.pcustom5.Caption;
                     Form_peach.pcustom5.Caption:=Form_peach.pcustom4.Caption;
                     Form_peach.pcustom4.Caption:=Form_peach.pcustom3.Caption;
                     Form_peach.pcustom3.Caption:=Form_peach.pcustom2.Caption;
                     Form_peach.pcustom2.Caption:=Form_peach.pcustom1.Caption;
                     Form_peach.pcustom1.Caption:=s;
                     end
                  else
                     begin
                     Form_peach.pcustom7.Caption:=Form_peach.pcustom6.Caption;
                     Form_peach.pcustom6.Caption:=Form_peach.pcustom5.Caption;
                     Form_peach.pcustom5.Caption:=Form_peach.pcustom4.Caption;
                     Form_peach.pcustom4.Caption:=Form_peach.pcustom3.Caption;
                     Form_peach.pcustom3.Caption:=Form_peach.pcustom2.Caption;
                     Form_peach.pcustom2.Caption:=Form_peach.pcustom1.Caption;
                     Form_peach.pcustom1.Caption:=s;
                     end
               else
                  begin
                  Form_peach.pcustom6.Caption:=Form_peach.pcustom5.Caption;
                  Form_peach.pcustom5.Caption:=Form_peach.pcustom4.Caption;
                  Form_peach.pcustom4.Caption:=Form_peach.pcustom3.Caption;
                  Form_peach.pcustom3.Caption:=Form_peach.pcustom2.Caption;
                  Form_peach.pcustom2.Caption:=Form_peach.pcustom1.Caption;
                  Form_peach.pcustom1.Caption:=s;
                  end
            else
               begin
               Form_peach.pcustom5.Caption:=Form_peach.pcustom4.Caption;
               Form_peach.pcustom4.Caption:=Form_peach.pcustom3.Caption;
               Form_peach.pcustom3.Caption:=Form_peach.pcustom2.Caption;
               Form_peach.pcustom2.Caption:=Form_peach.pcustom1.Caption;
               Form_peach.pcustom1.Caption:=s;
               end
         else
            begin
            Form_peach.pcustom4.Caption:=Form_peach.pcustom3.Caption;
            Form_peach.pcustom3.Caption:=Form_peach.pcustom2.Caption;
            Form_peach.pcustom2.Caption:=Form_peach.pcustom1.Caption;
            Form_peach.pcustom1.Caption:=s;
            end
      else
         begin
         Form_peach.pcustom3.Caption:=Form_peach.pcustom2.Caption;
         Form_peach.pcustom2.Caption:=Form_peach.pcustom1.Caption;
         Form_peach.pcustom1.Caption:=s;
         end
   else
      begin
      Form_peach.pcustom2.Caption:=Form_peach.pcustom1.Caption;
      Form_peach.pcustom1.Caption:=s;
      end;
if Form_peach.pcustom1.Caption<>'' then Form_peach.pcustom1.Visible:=true else Form_peach.pcustom1.Visible:=false;
if Form_peach.pcustom2.Caption<>'' then Form_peach.pcustom2.Visible:=true else Form_peach.pcustom2.Visible:=false;
if Form_peach.pcustom3.Caption<>'' then Form_peach.pcustom3.Visible:=true else Form_peach.pcustom3.Visible:=false;
if Form_peach.pcustom4.Caption<>'' then Form_peach.pcustom4.Visible:=true else Form_peach.pcustom4.Visible:=false;
if Form_peach.pcustom5.Caption<>'' then Form_peach.pcustom5.Visible:=true else Form_peach.pcustom5.Visible:=false;
if Form_peach.pcustom6.Caption<>'' then Form_peach.pcustom6.Visible:=true else Form_peach.pcustom6.Visible:=false;
if Form_peach.pcustom7.Caption<>'' then Form_peach.pcustom7.Visible:=true else Form_peach.pcustom7.Visible:=false;
if Form_peach.pcustom8.Caption<>'' then Form_peach.pcustom8.Visible:=true else Form_peach.pcustom8.Visible:=false;
end;

procedure sethistory;
begin
   if Form_peach.mRecent1.Caption<>'' then Form_peach.mRecent1.Visible:=true else Form_peach.mRecent1.Visible:=false;
   if Form_peach.mRecent2.Caption<>'' then Form_peach.mRecent2.Visible:=true else Form_peach.mRecent2.Visible:=false;
   if Form_peach.mRecent3.Caption<>'' then Form_peach.mRecent3.Visible:=true else Form_peach.mRecent3.Visible:=false;
   if Form_peach.mRecent4.Caption<>'' then Form_peach.mRecent4.Visible:=true else Form_peach.mRecent4.Visible:=false;
   if Form_peach.mRecent5.Caption<>'' then Form_peach.mRecent5.Visible:=true else Form_peach.mRecent5.Visible:=false;
   if Form_peach.mRecent6.Caption<>'' then Form_peach.mRecent6.Visible:=true else Form_peach.mRecent6.Visible:=false;
   if Form_peach.mRecent7.Caption<>'' then Form_peach.mRecent7.Visible:=true else Form_peach.mRecent7.Visible:=false;
   if Form_peach.mRecent8.Caption<>'' then Form_peach.mRecent8.Visible:=true else Form_peach.mRecent8.Visible:=false;
   Form_peach.pmhr1.Visible:=Form_peach.mRecent1.Visible;
   Form_peach.pmhr2.Visible:=Form_peach.mRecent2.Visible;
   Form_peach.pmhr3.Visible:=Form_peach.mRecent3.Visible;
   Form_peach.pmhr4.Visible:=Form_peach.mRecent4.Visible;
   Form_peach.pmhr5.Visible:=Form_peach.mRecent5.Visible;
   Form_peach.pmhr6.Visible:=Form_peach.mRecent6.Visible;
   Form_peach.pmhr7.Visible:=Form_peach.mRecent7.Visible;
   Form_peach.pmhr8.Visible:=Form_peach.mRecent8.Visible;
   Form_peach.pnr1.Visible:=Form_peach.mRecent1f.Visible;
   Form_peach.pnr2.Visible:=Form_peach.mRecent2f.Visible;
   Form_peach.pnr3.Visible:=Form_peach.mRecent3f.Visible;
   Form_peach.pnr4.Visible:=Form_peach.mRecent4f.Visible;
   Form_peach.pnr5.Visible:=Form_peach.mRecent5f.Visible;
   Form_peach.pnr6.Visible:=Form_peach.mRecent6f.Visible;
   Form_peach.pnr7.Visible:=Form_peach.mRecent7f.Visible;
   Form_peach.pnr8.Visible:=Form_peach.mRecent8f.Visible;
   Form_peach.pmemr1.Visible:=Form_peach.mRecent1f.Visible;
   Form_peach.pmemr2.Visible:=Form_peach.mRecent2f.Visible;
   Form_peach.pmemr3.Visible:=Form_peach.mRecent3f.Visible;
   Form_peach.pmemr4.Visible:=Form_peach.mRecent4f.Visible;
   Form_peach.pmemr5.Visible:=Form_peach.mRecent5f.Visible;
   Form_peach.pmemr6.Visible:=Form_peach.mRecent6f.Visible;
   Form_peach.pmemr7.Visible:=Form_peach.mRecent7f.Visible;
   Form_peach.pmemr8.Visible:=Form_peach.mRecent8f.Visible;
   Form_peach.pmemrf1.Visible:=Form_peach.mRecent1f.Visible;
   Form_peach.pmemrf2.Visible:=Form_peach.mRecent2f.Visible;
   Form_peach.pmemrf3.Visible:=Form_peach.mRecent3f.Visible;
   Form_peach.pmemrf4.Visible:=Form_peach.mRecent4f.Visible;
   Form_peach.pmemrf5.Visible:=Form_peach.mRecent5f.Visible;
   Form_peach.pmemrf6.Visible:=Form_peach.mRecent6f.Visible;
   Form_peach.pmemrf7.Visible:=Form_peach.mRecent7f.Visible;
   Form_peach.pmemrf8.Visible:=Form_peach.mRecent8f.Visible;
   Form_peach.pnra1.Visible:=Form_peach.mRecent1f.Visible;
   Form_peach.pnra2.Visible:=Form_peach.mRecent2f.Visible;
   Form_peach.pnra3.Visible:=Form_peach.mRecent3f.Visible;
   Form_peach.pnra4.Visible:=Form_peach.mRecent4f.Visible;
   Form_peach.pnra5.Visible:=Form_peach.mRecent5f.Visible;
   Form_peach.pnra6.Visible:=Form_peach.mRecent6f.Visible;
   Form_peach.pnra7.Visible:=Form_peach.mRecent7f.Visible;
   Form_peach.pnra8.Visible:=Form_peach.mRecent8f.Visible;
   Form_peach.pmamr1.Caption:=(Form_peach.mRecent1.Caption);
   Form_peach.pmamr2.Caption:=(Form_peach.mRecent2.Caption);
   Form_peach.pmamr3.Caption:=(Form_peach.mRecent3.Caption);
   Form_peach.pmamr4.Caption:=(Form_peach.mRecent4.Caption);
   Form_peach.pmamr5.Caption:=(Form_peach.mRecent5.Caption);
   Form_peach.pmamr6.Caption:=(Form_peach.mRecent6.Caption);
   Form_peach.pmamr7.Caption:=(Form_peach.mRecent7.Caption);
   Form_peach.pmamr8.Caption:=(Form_peach.mRecent8.Caption);
   Form_peach.pmamr1.Visible:=Form_peach.mRecent1.Visible;
   Form_peach.pmamr2.Visible:=Form_peach.mRecent2.Visible;
   Form_peach.pmamr3.Visible:=Form_peach.mRecent3.Visible;
   Form_peach.pmamr4.Visible:=Form_peach.mRecent4.Visible;
   Form_peach.pmamr5.Visible:=Form_peach.mRecent5.Visible;
   Form_peach.pmamr6.Visible:=Form_peach.mRecent6.Visible;
   Form_peach.pmamr7.Visible:=Form_peach.mRecent7.Visible;
   Form_peach.pmamr8.Visible:=Form_peach.mRecent8.Visible;
   if Form_peach.mRecent1f.Caption<>'' then Form_peach.mRecent1f.Visible:=true else Form_peach.mRecent1f.Visible:=false;
   if Form_peach.mRecent2f.Caption<>'' then Form_peach.mRecent2f.Visible:=true else Form_peach.mRecent2f.Visible:=false;
   if Form_peach.mRecent3f.Caption<>'' then Form_peach.mRecent3f.Visible:=true else Form_peach.mRecent3f.Visible:=false;
   if Form_peach.mRecent4f.Caption<>'' then Form_peach.mRecent4f.Visible:=true else Form_peach.mRecent4f.Visible:=false;
   if Form_peach.mRecent5f.Caption<>'' then Form_peach.mRecent5f.Visible:=true else Form_peach.mRecent5f.Visible:=false;
   if Form_peach.mRecent6f.Caption<>'' then Form_peach.mRecent6f.Visible:=true else Form_peach.mRecent6f.Visible:=false;
   if Form_peach.mRecent7f.Caption<>'' then Form_peach.mRecent7f.Visible:=true else Form_peach.mRecent7f.Visible:=false;
   if Form_peach.mRecent8f.Caption<>'' then Form_peach.mRecent8f.Visible:=true else Form_peach.mRecent8f.Visible:=false;
   Form_peach.pmhr1f.Visible:=Form_peach.mRecent1f.Visible;
   Form_peach.pmhr2f.Visible:=Form_peach.mRecent2f.Visible;
   Form_peach.pmhr3f.Visible:=Form_peach.mRecent3f.Visible;
   Form_peach.pmhr4f.Visible:=Form_peach.mRecent4f.Visible;
   Form_peach.pmhr5f.Visible:=Form_peach.mRecent5f.Visible;
   Form_peach.pmhr6f.Visible:=Form_peach.mRecent6f.Visible;
   Form_peach.pmhr7f.Visible:=Form_peach.mRecent7f.Visible;
   Form_peach.pmhr8f.Visible:=Form_peach.mRecent8f.Visible;
end;

procedure settonewfolder(i:integer);
begin
with form_peach do
begin
case i of
  0: begin
     MenuItemOpen_ExtractHere.Bitmap:=Bextractall;
     po_exthere.Bitmap:=Bextractall;
     pmqeto.Bitmap:=Bextractall;
     MenuItemExtAllTo.Bitmap:=Bextractall;
     ButtonUn7zaTo.Hint:=txt_ext_sel;
     if toolsize<3 then
        begin
        ButtonUn7zaTo.Glyph:=Bextractall_big;
        end
     else
        if toolsize<6 then
           begin
           ButtonUn7zaTo.Glyph:=Bextractall;
           end;
     mfunextract.Bitmap:=Bextractall;
     ImageFlatext.Glyph:=Bextractall;
     ImageFlatext.Hint:=txt_ext_sel;
     end;
  1: begin
     MenuItemOpen_ExtractHere.Bitmap:=Bextractalln;
     po_exthere.Bitmap:=Bextractalln;
     pmqeto.Bitmap:=Bextractalln;
     MenuItemExtAllTo.Bitmap:=Bextractalln;
     ButtonUn7zaTo.Hint:=txt_caption_extract+' '+txt_newfolder;
     if toolsize<3 then
        begin
        ButtonUn7zaTo.Glyph:=Bextractalln_big;
        end
     else
        if toolsize<6 then
           begin
           ButtonUn7zaTo.Glyph:=Bextractalln;
           end;
     mfunextract.Bitmap:=Bextractalln;
     ImageFlatext.Glyph:=Bextractalln;
     ImageFlatext.Hint:=txt_caption_extract+' '+txt_newfolder;
     end;
  end;
end;
populatetree;
end;

procedure updateconf;
begin
Form_peach.RadioGroup0.ItemIndex:=df;
Form_peach.RadioGroupTS.ItemIndex:=tsstyle;
Form_peach.RadioGroup4.ItemIndex:=zaout;
Form_peach.EditDesk.Text:=local_desktop;
Form_peach.RadioGroup6.ItemIndex:=autoclosegwrap;
Form_peach.ComboBoxLibre.ItemIndex:=libre_directive;
Form_peach.ComboBoxPrivacy.ItemIndex:=privacy_mode;
Form_peach.ComboBox1.ItemIndex:=enc7zscc;
Form_peach.ComboBoxsd.ItemIndex:=browsersd;
Form_peach.LabelcbSDcustom.Caption:=browsersdir;
if clipmode=0 then Form_peach.CheckBoxClip.State:=cbUnchecked
else Form_peach.CheckBoxClip.State:=cbChecked;
if movetorelativepath=0 then Form_peach.CheckBoxrelative.State:=cbUnchecked
else Form_peach.CheckBoxrelative.State:=cbChecked;
if Form_peach.CheckBoxrelative.State=cbChecked then Form_peach.Labelsetwork.enabled:=true
else Form_peach.Labelsetwork.enabled:=false;
if Form_peach.CheckBoxrelative.enabled=false then Form_peach.Labelsetwork.enabled:=false;
case browserstyle of
   0: Form_peach.RadioGroupBrowser.ItemIndex:=0;
   1: Form_peach.RadioGroupBrowser.ItemIndex:=1;
   else Form_peach.RadioGroupBrowser.ItemIndex:=2;
   end;
if mailkeep=1 then Form_peach.CheckBoxMailKeep.State:=cbChecked
else Form_peach.CheckBoxMailKeep.State:=cbUnChecked;
if convertpw=1 then Form_peach.CheckBoxConvert0.State:=cbChecked
else Form_peach.CheckBoxConvert0.State:=cbUnChecked;
if convertverbose=1 then Form_peach.CheckBoxConvert1.State:=cbChecked
else Form_peach.CheckBoxConvert1.State:=cbUnChecked;
if autoopen=1 then
   begin
   Form_peach.CheckBoxAutoOpen.State:=cbChecked;
   Form_peach.pmopenout.Checked:=true;
   Form_peach.mtoggleop.Checked:=true;
   end
else
   begin
   Form_peach.CheckBoxAutoOpen.State:=cbUnChecked;
   Form_peach.pmopenout.Checked:=false;
   Form_peach.mtoggleop.Checked:=false;
   end;
if autotest=1 then
   Form_peach.CheckBoxAutoTest.State:=cbChecked
else
   Form_peach.CheckBoxAutoTest.State:=cbUnChecked;
if autoclosepeazip=1 then
   Form_peach.CheckBoxClosePeaZip.State:=cbChecked
else
   Form_peach.CheckBoxClosePeaZip.State:=cbUnChecked;
if skipenctest=1 then Form_peach.CheckBoxSkipenc.State:=cbChecked else Form_peach.CheckBoxSkipenc.State:=cbUnChecked;
if nameaspartent=1 then Form_peach.CheckBoxnameasparentfolder.State:=cbChecked else Form_peach.CheckBoxnameasparentfolder.State:=cbUnChecked;
if showguihints=1 then Form_peach.CheckBoxShowHints.State:=cbChecked else Form_peach.CheckBoxShowHints.State:=cbUnChecked;
if showguihints=1 then Form_peach.ShowHint:=true else Form_peach.ShowHint:=false;
Form_peach.RadioGrouppwrequest.ItemIndex:=extpw;
Form_peach.ComboBoxOverwrite.Itemindex:=extopt7z;
Form_peach.cbdeleteinputmode.ItemIndex:={$IFDEF MSWINDOWS}favdelete;{$ELSE}{$IFDEF DARWIN}favdelete;{$ELSE}favdelete-1;{$ENDIF}{$ENDIF}
Form_peach.cbdeleteinputmode1.ItemIndex:={$IFDEF MSWINDOWS}favdelete;{$ELSE}{$IFDEF DARWIN}favdelete;{$ELSE}favdelete-1;{$ENDIF}{$ENDIF}
if doptext=1 then
   begin
   Form_peach.CheckBoxDeleteInput.State:=cbChecked;
   Form_peach.cbdeleteinputmode.visible:=true;
   end
else
   begin
   Form_peach.CheckBoxDeleteInput.State:=cbUnChecked;
   Form_peach.cbdeleteinputmode.visible:=false;
   end;
if doptadd=1 then
   begin
   Form_peach.CheckBoxDeleteInput1.State:=cbChecked;
   Form_peach.cbdeleteinputmode1.visible:=true;
   end
else
   begin
   Form_peach.CheckBoxDeleteInput1.State:=cbUnChecked;
   Form_peach.cbdeleteinputmode1.visible:=false;
   end;
Form_peach.pmqen1.checked:=false;
Form_peach.pmqen2.checked:=false;
Form_peach.pmqen3.checked:=false;
Form_peach.pmqen4.checked:=false;
Form_peach.pmqen5.checked:=false;
case extopt7z of
   0: Form_peach.pmqen1.checked:=true;
   1: Form_peach.pmqen2.checked:=true;
   2: Form_peach.pmqen3.checked:=true;
   3: Form_peach.pmqen4.checked:=true;
   4: Form_peach.pmqen5.checked:=true;
   end;
Form_peach.RadioGroupAction.Itemindex:=extaction7z;
if extaction7z=1 then Form_peach.pmqenopath.Checked:=true else Form_peach.pmqenopath.Checked:=false;
Form_peach.RadioGroupActionArc.Itemindex:=extactionarc;
Form_peach.RadioGroupAction1.Itemindex:=extactionace;
Form_peach.ComboBoxWD.Itemindex:=work_dir;
Form_peach.Labelcwd.Caption:=custom_work_path;
Form_peach.ComboBoxOverwriteARC.Itemindex:=extoptarc;
if nativedrag=1 then Form_peach.CheckBoxDragDrop.State:=cbChecked else Form_peach.CheckBoxDragDrop.State:=cbUnChecked;
Form_peach.ComboBoxDrag.ItemIndex:=dragtargetprotect;
if nativedrag=0 then Form_peach.ComboBoxDrag.enabled:=false else Form_peach.ComboBoxDrag.enabled:=true;
if autosync=1 then Form_peach.CheckBoxEditArchives.State:=cbChecked else Form_peach.CheckBoxEditArchives.State:=cbUnChecked;
if sys7zlin=1 then Form_peach.cbsys7zlin.State:=cbChecked else Form_peach.cbsys7zlin.State:=cbUnChecked;
if ignorepathextand=1 then Form_peach.CheckBox4.State:=cbChecked else Form_peach.CheckBox4.State:=cbUnChecked;
if closeonsingleextract=1 then Form_peach.cbautoclosesingleextract.State:=cbChecked else Form_peach.cbautoclosesingleextract.State:=cbUnChecked;
Form_peach.cbExtEvForWhen.Itemindex:=whenspecialopen;
Form_peach.cbExtEvForHow.Itemindex:=howspecialopen;
if whenspecialopen=0 then Form_peach.cbExtEvForHow.enabled:=false else Form_peach.cbExtEvForHow.enabled:=true;
Form_peach.editExtEvForWhat.enabled:=Form_peach.cbExtEvForHow.enabled;
if ignorepathdisp=1 then Form_peach.CheckBoxIgnoreDisp.State:=cbChecked else Form_peach.CheckBoxIgnoreDisp.State:=cbUnChecked;
if ignorepathsel=1 then Form_peach.CheckBoxIgnoreSel.State:=cbChecked else Form_peach.CheckBoxIgnoreSel.State:=cbUnChecked;
if enableextand=1 then Form_peach.CheckBoxExtAnd.State:=cbChecked else Form_peach.CheckBoxExtAnd.State:=cbUnChecked;
if removeintdir=1 then
   begin
   Form_peach.CheckBoxFolder1.State:=cbChecked;
   Form_peach.CheckBoxIntDir.State:=cbChecked;
   Form_peach.pmqnointdir.Checked:=true;
   end
else
   begin
   Form_peach.CheckBoxFolder1.State:=cbUnChecked;
   Form_peach.CheckBoxIntDir.State:=cbUnChecked;
   Form_peach.pmqnointdir.Checked:=false;
   end;
if sni7z=1 then Form_peach.CheckBoxsni.State:=cbChecked else Form_peach.CheckBoxsni.State:=cbUnChecked;
if sns7z=1 then Form_peach.CheckBoxsns.State:=cbChecked else Form_peach.CheckBoxsns.State:=cbUnChecked;
if snh7z=1 then Form_peach.CheckBoxsnh.State:=cbChecked else Form_peach.CheckBoxsnh.State:=cbUnChecked;
if snl7z=1 then Form_peach.CheckBoxsnl.State:=cbChecked else Form_peach.CheckBoxsnl.State:=cbUnChecked;
if sni7z=1 then Form_peach.CheckBoxsni1.State:=cbChecked else Form_peach.CheckBoxsni1.State:=cbUnChecked;
if sns7z=1 then Form_peach.CheckBoxsns1.State:=cbChecked else Form_peach.CheckBoxsns1.State:=cbUnChecked;
if stl7z=1 then Form_peach.CheckBoxstl.State:=cbChecked else Form_peach.CheckBoxstl.State:=cbUnChecked;
if ssp7z=1 then Form_peach.CheckBoxssp.State:=cbChecked else Form_peach.CheckBoxssp.State:=cbUnChecked;
if snz7z=1 then Form_peach.CheckBoxsnz1.State:=cbChecked else Form_peach.CheckBoxsnz1.State:=cbUnChecked;
if storecreated=1 then Form_peach.cbtimecreated.State:=cbChecked else Form_peach.cbtimecreated.State:=cbUnChecked;
if maxbrotli=1 then Form_peach.CheckBoxBrotli.State:=cbChecked else Form_peach.CheckBoxBrotli.State:=cbUnChecked;
if maxzstd=1 then Form_peach.CheckBoxZstd.State:=cbChecked else Form_peach.CheckBoxZstd.State:=cbUnChecked;
if zpaqall=1 then Form_peach.CheckBoxzpaqall.State:=cbChecked else Form_peach.CheckBoxzpaqall.State:=cbUnChecked; Form_peach.CheckBoxzpaqallClick(nil);
if zpaqfull=1 then Form_peach.CheckBoxzpaqfull.State:=cbChecked else Form_peach.CheckBoxzpaqfull.State:=cbUnChecked; Form_peach.CheckBoxzpaqfullClick(nil);
if zpaqabsolute=1 then Form_peach.CheckBoxzpaqabsolute.State:=cbChecked else Form_peach.CheckBoxzpaqabsolute.State:=cbUnChecked; Form_peach.CheckBoxzpaqabsoluteClick(nil);
if zpaqforce=1 then Form_peach.CheckBoxzpaqforce.State:=cbChecked else Form_peach.CheckBoxzpaqforce.State:=cbUnChecked;
Form_peach.ComboBoxBrowser.ItemIndex:=prebrowse;
Form_peach.ComboBoxMaxArg.ItemIndex:=maxargsize;
Form_peach.ComboBoxPriority.ItemIndex:=taskpriority;
if nonverboselog=1 then Form_peach.CheckBoxBrowseNotVerbose.State:=cbChecked else Form_peach.CheckBoxBrowseNotVerbose.State:=cbUnChecked;
if skipdel=1 then Form_peach.CheckBoxSkipDel.State:=cbChecked else Form_peach.CheckBoxSkipDel.State:=cbUnChecked;
if use7zunrar5=1 then Form_peach.CheckBox7zunrar5.State:=cbChecked else Form_peach.CheckBox7zunrar5.State:=cbUnChecked;
if useextrac32=1 then Form_peach.CheckBoxExtrac32.State:=cbChecked else Form_peach.CheckBoxExtrac32.State:=cbUnChecked;
if enumd=1 then Form_peach.CheckBoxEnumd.State:=cbChecked else Form_peach.CheckBoxEnumd.State:=cbUnChecked;
if userar=1 then Form_peach.cbRAR.State:=cbChecked else Form_peach.cbRAR.State:=cbUnChecked;
if userar5=1 then Form_peach.cbRAR5.State:=cbChecked else Form_peach.cbRAR5.State:=cbUnChecked;
Form_peach.comboRARdict.Itemindex:=userardict;
if userarblake2=1 then Form_peach.cbRARBLAKE2.State:=cbChecked else Form_peach.cbRARBLAKE2.State:=cbUnChecked;
if userarsfx=1 then Form_peach.cbRARsfx.State:=cbChecked else Form_peach.cbRARsfx.State:=cbUnChecked;
if userarsolid=1 then Form_peach.cbRARsolid.State:=cbChecked else Form_peach.cbRARsolid.State:=cbUnChecked;
if userarrr=1 then Form_peach.cbRARrr.State:=cbChecked else Form_peach.cbRARrr.State:=cbUnChecked;
Form_peach.seRARrr.Value:=puserarrr;
if userarsaveopen=1 then Form_peach.cbRARsaveopen.State:=cbChecked else Form_peach.cbRARsaveopen.State:=cbUnChecked;
if userarsavesecurity=1 then Form_peach.cbRARsavesecurity.State:=cbChecked else Form_peach.cbRARsavesecurity.State:=cbUnChecked;
if userarsavestreams=1 then Form_peach.cbRARsavestreams.State:=cbChecked else Form_peach.cbRARsavestreams.State:=cbUnChecked;
Form_peach.cbRARlastmodtime.ItemIndex:=userarlastmodtime;
if userarlock=1 then Form_peach.cbRARlock.State:=cbChecked else Form_peach.cbRARlock.State:=cbUnChecked;
if addencext=1 then Form_peach.cbencext.State:=cbChecked else Form_peach.cbencext.State:=cbUnChecked;
if addtstext=1 then Form_peach.CheckBoxDate.State:=cbChecked else Form_peach.CheckBoxDate.State:=cbUnChecked;
if repcustext=1 then Form_peach.cbcustext.State:=cbChecked else Form_peach.cbcustext.State:=cbUnChecked;
if savehistory=1 then Form_peach.CheckBoxArchiveHistory.State:=cbChecked else Form_peach.CheckBoxArchiveHistory.State:=cbUnChecked;
if jobdefenc=1 then Form_peach.CheckBoxJobEncoding.State:=cbChecked else Form_peach.CheckBoxJobEncoding.State:=cbUnChecked;
if showvolatile=1 then Form_peach.CheckBoxShowvolatile.State:=cbChecked else Form_peach.CheckBoxShowvolatile.State:=cbUnChecked;
if autoopentar=1 then Form_peach.CheckBoxAutoOpenTar.State:=cbChecked else Form_peach.CheckBoxAutoOpenTar.State:=cbUnChecked;
if qdup=1 then Form_peach.cbqdup.State:=cbChecked else Form_peach.cbqdup.State:=cbUnChecked;
if tar_atomic=1 then Form_peach.CheckBoxAutoExtTar.State:=cbChecked else Form_peach.CheckBoxAutoExtTar.State:=cbUnChecked;
if tar_atomic_convert=1 then Form_peach.CheckBoxAutoExtTar1.State:=cbChecked else Form_peach.CheckBoxAutoExtTar1.State:=cbUnChecked;
if noconfdel=1 then Form_peach.CheckBoxNoConf.State:=cbChecked else Form_peach.CheckBoxNoConf.State:=cbUnChecked;
if swzipx=1 then Form_peach.CheckBoxzipxswitch.State:=cbChecked else Form_peach.CheckBoxzipxswitch.State:=cbUnChecked;
if convint=1 then Form_peach.CheckBoxAC.State:=cbChecked else Form_peach.CheckBoxAC.State:=cbUnChecked;
if tryopenwerrors=1 then Form_peach.CheckBoxForceOpen.State:=cbChecked else Form_peach.CheckBoxForceOpen.State:=cbUnChecked;
if forcecanbechanged=1 then Form_peach.CheckBoxForceEdit.State:=cbChecked else Form_peach.CheckBoxForceEdit.State:=cbUnChecked;
if excludeef=1 then Form_peach.CheckBoxExcludeEF.State:=cbChecked else Form_peach.CheckBoxExcludeEF.State:=cbUnChecked;
if immediate_execution=1 then Form_peach.mprofileimmediate.Checked:=true else Form_peach.mprofileimmediate.Checked:=false;
if forcelayout=1 then Form_peach.CheckBoxForceLayout.State:=cbChecked else Form_peach.CheckBoxForceLayout.State:=cbUnChecked;
if forcebrowse=1 then Form_peach.CheckBoxForceBrowse.State:=cbChecked else Form_peach.CheckBoxForceBrowse.State:=cbUnChecked;
if forceconvert=1 then Form_peach.CheckBoxForceConvert.State:=cbChecked else Form_peach.CheckBoxForceConvert.State:=cbUnChecked;
if archivenameenc=1 then Form_peach.CheckBoxEncoding.State:=cbChecked else Form_peach.CheckBoxEncoding.State:=cbUnChecked;
Form_peach.cbEncoding1.ItemIndex:=mcuzip;
if Form_peach.cbEncoding1.ItemIndex=3 then Form_peach.EditEncoding.Visible:=true else Form_peach.EditEncoding.Visible:=false;
Form_peach.ComboBoxSyntaxLevel.ItemIndex:=syntaxlevel7z;
Form_peach.cbtree.ItemIndex:=ptsync;
Form_peach.cbdefaultaction.ItemIndex:=defaultactionst;
if mappeddrivesinfo=1 then Form_peach.CheckBoxnetworkinfo.State:=cbChecked else Form_peach.CheckBoxnetworkinfo.State:=cbUnChecked;
if ws=1 then Form_peach.CheckBoxWindowStatus.State:=cbChecked else Form_peach.CheckBoxWindowStatus.State:=cbUnChecked;
if savehistory=1 then
   begin
   sethistory;
   end
else
   begin
   Form_peach.mRecent1.Caption:='';
   Form_peach.mRecent2.Caption:='';
   Form_peach.mRecent3.Caption:='';
   Form_peach.mRecent4.Caption:='';
   Form_peach.mRecent5.Caption:='';
   Form_peach.mRecent6.Caption:='';
   Form_peach.mRecent7.Caption:='';
   Form_peach.mRecent8.Caption:='';
   Form_peach.mRecent1f.Caption:='';
   Form_peach.mRecent2f.Caption:='';
   Form_peach.mRecent3f.Caption:='';
   Form_peach.mRecent4f.Caption:='';
   Form_peach.mRecent5f.Caption:='';
   Form_peach.mRecent6f.Caption:='';
   Form_peach.mRecent7f.Caption:='';
   Form_peach.mRecent8f.Caption:='';
   sethistory;
   end;
if Form_peach.pcustom1.Caption<>'' then Form_peach.pcustom1.Visible:=true else Form_peach.pcustom1.Visible:=false;
if Form_peach.pcustom2.Caption<>'' then Form_peach.pcustom2.Visible:=true else Form_peach.pcustom2.Visible:=false;
if Form_peach.pcustom3.Caption<>'' then Form_peach.pcustom3.Visible:=true else Form_peach.pcustom3.Visible:=false;
if Form_peach.pcustom4.Caption<>'' then Form_peach.pcustom4.Visible:=true else Form_peach.pcustom4.Visible:=false;
if Form_peach.pcustom5.Caption<>'' then Form_peach.pcustom5.Visible:=true else Form_peach.pcustom5.Visible:=false;
if Form_peach.pcustom6.Caption<>'' then Form_peach.pcustom6.Visible:=true else Form_peach.pcustom6.Visible:=false;
if Form_peach.pcustom7.Caption<>'' then Form_peach.pcustom7.Visible:=true else Form_peach.pcustom7.Visible:=false;
if Form_peach.pcustom8.Caption<>'' then Form_peach.pcustom8.Visible:=true else Form_peach.pcustom8.Visible:=false;
Form_peach.ComboBoxArchiveCustom.Itemindex:=customsyntax;
Form_peach.ComboBoxArchiveCustom1.Itemindex:=customsyntax1;
Form_peach.RadioGroup1.ItemIndex:=algodisp;
Form_peach.RadioGroup2.ItemIndex:=browserch-1;
Form_peach.RadioGroup3.ItemIndex:=algoall;
if esna=1 then Form_peach.checkbox1.State:=cbChecked else Form_peach.checkbox1.State:=cbUnChecked;
if euns=1 then
   begin
   Form_peach.checkbox2.State:=cbChecked;
   Form_peach.checkbox3.Enabled:=true;
   if euns1=1 then
      begin
      Form_peach.checkbox3.State:=cbChecked;
      Form_peach.CompressionCustom1.Enabled:=false;
      end
   else
       begin
       Form_peach.checkbox3.State:=cbUnChecked;
       Form_peach.CompressionCustom1.Enabled:=true;
       end;
   end
else
   begin
   Form_peach.checkbox2.State:=cbUnChecked;
   Form_peach.checkbox3.Enabled:=false;
   Form_peach.CompressionCustom1.Enabled:=false;
   if euns1=1 then
      begin
      Form_peach.checkbox3.State:=cbChecked;
      end
   else
       begin
       Form_peach.checkbox3.State:=cbUnChecked;
       end;
   end;
Form_peach.ComboBoxPasses.Itemindex:=erasepasses;
Form_peach.ComboBoxKiB.Itemindex:=filesizebase;
if tonewfolder=1 then
   begin
   Form_peach.CheckBoxFolder.State:=cbChecked;
   Form_peach.pmqenewfolder.checked:=true;
   Form_peach.mtogglenew.checked:=true;
   end
else
   begin
   Form_peach.CheckBoxFolder.State:=cbUnChecked;
   Form_peach.pmqenewfolder.checked:=false;
   Form_peach.mtogglenew.checked:=false;
   end;
if zcopy=1 then Form_peach.CheckBoxzcopy.State:=cbChecked else Form_peach.CheckBoxzcopy.State:=cbUnChecked;
if parallelarchive=1 then Form_peach.CheckBoxParallelarchiving.State:=cbChecked else Form_peach.CheckBoxParallelarchiving.State:=cbUnChecked;
if defaultextractpath<>'' then
   begin
   Form_peach.mdefaultextract.caption:=txt_caption_extract+' > '+txt_2_8_usedefaultoutpath+' '+defaultextractpath;
   Form_peach.mdefaultextract.checked:=true;
   end
else
   begin
   Form_peach.mdefaultextract.caption:=txt_caption_extract+' > '+txt_7_6_setdef;
   Form_peach.mdefaultextract.checked:=false;
   end;
Form_peach.pmusedefault.caption:=Form_peach.mdefaultextract.caption;
Form_peach.pmusedefault.checked:=Form_peach.mdefaultextract.checked;
Form_peach.lsetdefaultout_ext.caption:=Form_peach.mdefaultextract.caption;
if defaultarchivepath<>'' then
   begin
   Form_peach.mdefaultarchive.caption:=txt_archive+' > '+txt_2_8_usedefaultoutpath+' '+defaultarchivepath;
   Form_peach.mdefaultarchive.checked:=true;
   end
else
   begin
   Form_peach.mdefaultarchive.caption:=txt_archive+' > '+txt_7_6_setdef;
   Form_peach.mdefaultarchive.checked:=false;
   end;
Form_peach.lsetdefaultout_arc.caption:=Form_peach.mdefaultarchive.caption;
end;

procedure updateconf_modified;
begin
updateconf;
end;

procedure load_theme;
var
   thpath:ansistring;
begin
if theme_path='' then exit;
if theme_path[1]='r' then theme_path:='themes'+directoryseparator+DEFAULT_THEME+directoryseparator+'theme.txt';
getthemepath(thpath);
if (upcase(theme_name)<>upcase(DEFAULT_THEME)) and (upcase(theme_name)<>upcase('nographic-embedded')) then
   begin
   assignfile(conf,(thpath+theme_path));
   filemode:=0;
   reset(conf);
   read_header(conf);
   readln(conf,theme_name);
   readln(conf,theme_author);
   readln(conf,theme_license);
   readconf_default_colors;
   CloseFile(conf);
   end;
if (upcase(theme_name)=upcase(DEFAULT_THEME)) then
   begin
   theme_name:='main-embedded';
   theme_author:='Giorgio Tani';
   theme_license:='LGPLv3';
   graphicsfolderd:='themes'+DirectorySeparator+'main-embedded'+DirectorySeparator;
   dodirseparators(graphicsfolderd);
   opacityd:=100;
   color1d:=ColorToString(PAPPCOL);
   color2d:=ColorToString(clWindow);
   color3d:=ColorToString(PTACOL);
   color4d:=ColorToString(clAppWorkspace);
   color5d:=ColorToString(clWindowText);
   usealtcolord:=0;
   highlighttabsd:=0;
   accenttoolbard:=0;
   toolcenteredd:=0;
   altaddressstyled:=1;
   solidaddressstyled:=0;
   alttabstyled:=2;
   pzoomingd:=100;
   ensmalld:=0;
   pspacingd:=4;
   temperatured:=0;
   end;
if (upcase(theme_name)=upcase('nographic-embedded')) then
   begin
   theme_name:='nographic-embedded';
   theme_author:='Giorgio Tani';
   theme_license:='LGPLv3';
   graphicsfolderd:='themes'+DirectorySeparator+'nographic-embedded'+DirectorySeparator;
   dodirseparators(graphicsfolderd);
   opacityd:=100;
   color1d:=ColorToString(PAPPCOL);
   usealtcolord:=0;
   highlighttabsd:=0;
   accenttoolbard:=0;
   toolcenteredd:=0;
   altaddressstyled:=1;
   solidaddressstyled:=0;
   alttabstyled:=2;
   pzoomingd:=100;
   ensmalld:=0;
   pspacingd:=4;
   temperatured:=0;
   end;
if upcase(theme_name)='MAIN-EMBEDDED' then Form_peach.ComboBoxTheme.ItemIndex:=0
else
   if upcase(theme_name)='DIFFERENT' then Form_peach.ComboBoxTheme.ItemIndex:=1
   else
      if upcase(theme_name)='DROID' then Form_peach.ComboBoxTheme.ItemIndex:=2
      else
         if upcase(theme_name)='MAIN' then Form_peach.ComboBoxTheme.ItemIndex:=3
         else
            if upcase(theme_name)='TEN' then Form_peach.ComboBoxTheme.ItemIndex:=4
            else
               if upcase(theme_name)='TUXEDO' then Form_peach.ComboBoxTheme.ItemIndex:=5
               else
                  Form_peach.ComboBoxTheme.ItemIndex:=6;
end;

procedure load_default_theme;
begin
theme_name:='main-embedded';
theme_path:='themes'+directoryseparator+DEFAULT_THEME+directoryseparator+'theme.txt';
load_theme;
end;

procedure save_bookmarks;
var
   i,rc:integer;
begin
try
assignfile(book,(confpath+'bookmarks.txt'));
rewrite(book);
write_header(book);
rc:=Form_peach.StringGridBookmarks.RowCount;
if rc>1 then
   for i:=1 to rc-1 do
      begin
      if Form_peach.StringGridBookmarks.Cells[1,i]=txt_list_browsing then writeln(book,'0')
      else
         if Form_peach.StringGridBookmarks.Cells[1,i]=txt_list_flat then writeln(book,'1')
         else
            if Form_peach.StringGridBookmarks.Cells[1,i]=txt_list_found then writeln(book,'2')
            else writeln(book,'0');
      writeln(book,Form_peach.StringGridBookmarks.Cells[2,i]);
      writeln(book,Form_peach.StringGridBookmarks.Cells[4,i]);
      writeln(book,Form_peach.StringGridBookmarks.Cells[5,i]);
      writeln(book,Form_peach.StringGridBookmarks.Cells[6,i]);
      if savehistory=1 then
         begin
         writeln(book,Form_peach.StringGridBookmarks.Cells[7,i]);
         writeln(book,Form_peach.StringGridBookmarks.Cells[8,i]);
         writeln(book,Form_peach.StringGridBookmarks.Cells[9,i]);
         end
      else
         begin
         writeln(book,'');
         writeln(book,'');
         writeln(book,'');
         end;
      end
else writeln(book,' ');
CloseFile(book);
except
   try
   CloseFile(book);
   except
   end;
end;
end;

procedure save_custedit;
begin
try
assignfile(cedit,(confpath+'custedit.txt'));
rewrite(cedit);
write_header(cedit);
writeln(cedit,'[custom editors/players, override system''s file associations, 4.2+]');
with form_peach do
begin
writeln(cedit,StringGridCustedit.Cells[1,1]);
writeln(cedit,StringGridCustedit.Cells[1,2]);
writeln(cedit,StringGridCustedit.Cells[1,3]);
writeln(cedit,StringGridCustedit.Cells[1,4]);
writeln(cedit,StringGridCustedit.Cells[1,5]);
writeln(cedit,StringGridCustedit.Cells[1,6]);
writeln(cedit,StringGridCustedit.Cells[1,7]);
writeln(cedit,StringGridCustedit.Cells[1,8]);
writeln(cedit,StringGridCustedit.Cells[1,9]);
writeln(cedit,StringGridCustedit.Cells[1,10]);
writeln(cedit,StringGridCustedit.Cells[1,11]);
writeln(cedit,StringGridCustedit.Cells[1,12]);
writeln(cedit,StringGridCustedit.Cells[1,13]);
writeln(cedit,StringGridCustedit.Cells[1,14]);
writeln(cedit,StringGridCustedit.Cells[1,15]);
writeln(cedit,StringGridCustedit.Cells[1,16]);
writeln(cedit,StringGridCustedit.Cells[2,1]);
writeln(cedit,StringGridCustedit.Cells[2,2]);
writeln(cedit,StringGridCustedit.Cells[2,3]);
writeln(cedit,StringGridCustedit.Cells[2,4]);
writeln(cedit,StringGridCustedit.Cells[2,5]);
writeln(cedit,StringGridCustedit.Cells[2,6]);
writeln(cedit,StringGridCustedit.Cells[2,7]);
writeln(cedit,StringGridCustedit.Cells[2,8]);
writeln(cedit,StringGridCustedit.Cells[2,9]);
writeln(cedit,StringGridCustedit.Cells[2,10]);
writeln(cedit,StringGridCustedit.Cells[2,11]);
writeln(cedit,StringGridCustedit.Cells[2,12]);
writeln(cedit,StringGridCustedit.Cells[2,13]);
writeln(cedit,StringGridCustedit.Cells[2,14]);
writeln(cedit,StringGridCustedit.Cells[2,15]);
writeln(cedit,StringGridCustedit.Cells[2,16]);
writeln(cedit,StringGridCustedit1.Cells[1,1]);
writeln(cedit,StringGridCustedit1.Cells[1,2]);
writeln(cedit,StringGridCustedit1.Cells[1,3]);
writeln(cedit,StringGridCustedit1.Cells[1,4]);
writeln(cedit,StringGridCustedit1.Cells[1,5]);
writeln(cedit,StringGridCustedit1.Cells[1,6]);
writeln(cedit,StringGridCustedit1.Cells[1,7]);
writeln(cedit,StringGridCustedit1.Cells[1,8]);
writeln(cedit,StringGridCustedit1.Cells[2,1]);
writeln(cedit,StringGridCustedit1.Cells[2,2]);
writeln(cedit,StringGridCustedit1.Cells[2,3]);
writeln(cedit,StringGridCustedit1.Cells[2,4]);
writeln(cedit,StringGridCustedit1.Cells[2,5]);
writeln(cedit,StringGridCustedit1.Cells[2,6]);
writeln(cedit,StringGridCustedit1.Cells[2,7]);
writeln(cedit,StringGridCustedit1.Cells[2,8]);
writeln(cedit,StringGridCustedit1.Cells[3,1]);
writeln(cedit,StringGridCustedit1.Cells[3,2]);
writeln(cedit,StringGridCustedit1.Cells[3,3]);
writeln(cedit,StringGridCustedit1.Cells[3,4]);
writeln(cedit,StringGridCustedit1.Cells[3,5]);
writeln(cedit,StringGridCustedit1.Cells[3,6]);
writeln(cedit,StringGridCustedit1.Cells[3,7]);
writeln(cedit,StringGridCustedit1.Cells[3,8]);
writeln(cedit,StringGridCustedit1.Cells[4,1]);
writeln(cedit,StringGridCustedit1.Cells[4,2]);
writeln(cedit,StringGridCustedit1.Cells[4,3]);
writeln(cedit,StringGridCustedit1.Cells[4,4]);
writeln(cedit,StringGridCustedit1.Cells[4,5]);
writeln(cedit,StringGridCustedit1.Cells[4,6]);
writeln(cedit,StringGridCustedit1.Cells[4,7]);
writeln(cedit,StringGridCustedit1.Cells[4,8]);
end;
CloseFile(cedit);
except
   try
   CloseFile(cedit);
   except
   end;
end;
end;

procedure set_win_antivirus;
var
  avgver,istr:integer;
  comodopath,mbampath,esetdir:ansistring;
  astr,bstr,cstr,dstr:array [1..8] of ansistring;
begin
{$IFDEF MSWINDOWS}
istr:=0;
//Security essentials (legacy)
if fileexists(winpfolder32+'Microsoft Security Client\msseces.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Microsoft Security Essentials';
   bstr[istr]:=wincomspec+' /k ""'+winpfolder32+'Microsoft Security Client\Antimalware\MpCmdRun.exe" -Scan -ScanType 3 -File ';
   cstr[istr]:='"';
   dstr[istr]:=winpfolder32+'Microsoft Security Client\msseces.exe';
   end;
if fileexists(winpfolder+'Microsoft Security Client\msseces.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Microsoft Security Essentials';
   bstr[istr]:=wincomspec+' /k ""'+winpfolder+'Microsoft Security Client\Antimalware\MpCmdRun.exe" -Scan -ScanType 3 -File ';
   cstr[istr]:='"';
   dstr[istr]:=winpfolder+'Microsoft Security Client\msseces.exe';
   end;
//Windows defender with or without GUI
if fileexists(winpfolder32+'Windows Defender\MSASCui.exe') or fileexists(winpfolder32+'Windows Defender\MpCmdRun.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Microsoft Windows Defender';
   bstr[istr]:=wincomspec+' /k ""'+winpfolder32+'Windows Defender\MpCmdRun.exe" -Scan -ScanType 3 -File ';
   cstr[istr]:='"';
   if fileexists(winpfolder32+'Windows Defender\MSASCui.exe') then dstr[istr]:=winpfolder32+'Windows Defender\MSASCui.exe'
   else dstr[istr]:=winpfolder32+'Windows Defender\MpCmdRun.exe';
   end;
if fileexists(winpfolder+'Windows Defender\MSASCui.exe') or fileexists(winpfolder+'Windows Defender\MpCmdRun.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Microsoft Windows Defender';
   bstr[istr]:=wincomspec+' /k ""'+winpfolder+'Windows Defender\MpCmdRun.exe" -Scan -ScanType 3 -File ';
   cstr[istr]:='"';
   if fileexists(winpfolder+'Windows Defender\MSASCui.exe') then dstr[istr]:=winpfolder+'Windows Defender\MSASCui.exe'
   else dstr[istr]:=winpfolder+'Windows Defender\MpCmdRun.exe';
   end;

if fileexists(winpfolder32+'AVAST Software\avast\ashCmd.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Avast';
   bstr[istr]:='"'+winpfolder32+'AVAST Software\avast\ashCmd.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder32+'AVAST Software\avast\avastui.exe';
   end;
if fileexists(winpfolder+'AVAST Software\avast\ashCmd.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Avast';
   bstr[istr]:='"'+winpfolder+'AVAST Software\avast\ashCmd.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder+'AVAST Software\avast\avastui.exe';
   end;

for avgver:=99 downto 10 do
   begin
   if fileexists(winpfolder32+'AVG\AVG20'+inttostr(avgver)+'\avgscanx.exe') then
      begin
      istr:=istr+1;//stop at first match
      astr[istr]:='AVG Anti-Virus Free';
      bstr[istr]:=wincomspec+' /k ""'+winpfolder32+'AVG\AVG20'+inttostr(avgver)+'\avgscanx.exe" /SCAN=';
      cstr[istr]:='"';
      dstr[istr]:=winpfolder32+'AVG\AVG20'+inttostr(avgver)+'\avgui.exe';
      break;
      end;
   if fileexists(winpfolder+'AVG\AVG20'+inttostr(avgver)+'\avgscanx.exe') then
      begin
      istr:=istr+1;//stop at first match
      astr[istr]:='AVG Anti-Virus Free';
      bstr[istr]:=wincomspec+' /k ""'+winpfolder+'AVG\AVG20'+inttostr(avgver)+'\avgscanx.exe" /SCAN=';
      cstr[istr]:='"';
      dstr[istr]:=winpfolder+'AVG\AVG20'+inttostr(avgver)+'\avgui.exe';
      break;
      end;
   end;

if fileexists(winpfolder32+'Avira\AntiVir Desktop\avscan.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Avira AntiVir Personal';
   bstr[istr]:='"'+winpfolder32+'Avira\AntiVir Desktop\avscan.exe" /GUIMODE=1 /PATH=';
   cstr[istr]:='';
   dstr[istr]:=winpfolder32+'Avira\AntiVir Desktop\avcenter.exe';
   end;
if fileexists(winpfolder+'Avira\AntiVir Desktop\avscan.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Avira AntiVir Personal';
   bstr[istr]:='"'+winpfolder+'Avira\AntiVir Desktop\avscan.exe" /GUIMODE=1 /PATH=';
   cstr[istr]:='';
   dstr[istr]:=winpfolder+'Avira\AntiVir Desktop\avcenter.exe';
   end;

if fileexists(winpfolder32+'ClamWin\Bin\ClamWin.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='ClamWin';
   bstr[istr]:='"'+winpfolder32+'ClamWin\Bin\ClamWin.exe" --mode="scanner" --path=';
   cstr[istr]:='';
   dstr[istr]:=winpfolder32+'ClamWin\Bin\ClamWin.exe';
   end;
if fileexists(winpfolder+'ClamWin\Bin\ClamWin.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='ClamWin';
   bstr[istr]:='"'+winpfolder+'ClamWin\Bin\ClamWin.exe" --mode="scanner" --path=';
   cstr[istr]:='';
   dstr[istr]:=winpfolder+'ClamWin\Bin\ClamWin.exe';
   end;

comodopath:='';
if fileexists(winpfolder32+'Comodo\CCE\CCE.exe') then comodopath:=winpfolder32+'Comodo\CCE\CCE.exe';
if fileexists(winpfolder32+'CCE\CCE.exe') then comodopath:=winpfolder32+'CCE\CCE.exe';
if fileexists(winpfolder+'Comodo\CCE\CCE.exe') then comodopath:=winpfolder+'Comodo\CCE\CCE.exe';
if fileexists(winpfolder+'CCE\CCE.exe') then comodopath:=winpfolder+'CCE\CCE.exe';
if fileexists('C:\Comodo\CCE\CCE.exe') then comodopath:='C:\Comodo\CCE\CCE.exe';
if fileexists('C:\CCE\CCE.exe') then comodopath:='C:\CCE\CCE.exe';
if fileexists(local_desktop+'Comodo\CCE\CCE.exe') then comodopath:=local_desktop+'Comodo\CCE\CCE.exe';
if fileexists(local_desktop+'CCE\CCE.exe') then comodopath:=local_desktop+'CCE\CCE.exe';
if fileexists(home_path+'Comodo\CCE\CCE.exe') then comodopath:=home_path+'Comodo\CCE\CCE.exe';
if fileexists(home_path+'CCE\CCE.exe') then comodopath:=home_path+'CCE\CCE.exe';
if fileexists(usr_documents+'Comodo\CCE\CCE.exe') then comodopath:=usr_documents+'Comodo\CCE\CCE.exe';
if fileexists(usr_documents+'CCE\CCE.exe') then comodopath:=usr_documents+'CCE\CCE.exe';
if comodopath<>'' then
   begin
   istr:=istr+1;//adds only once
   astr[istr]:='Comodo Cleaning Essentials';
   bstr[istr]:='"'+comodopath+'" -s -p ';
   cstr[istr]:='';
   dstr[istr]:='"'+comodopath+'"';
   end;

esetdir:='';
if fileexists(winpfolder32+'ESET\ESET Smart Security\ecls.exe') then esetdir:=winpfolder32+'ESET\ESET Smart Security\';
if fileexists(winpfolder32+'ESET\ESET NOD32 Antivirus\ecls.exe') then esetdir:=winpfolder32+'ESET\ESET NOD32 Antivirus\';
if fileexists(winpfolder+'ESET\ESET Smart Security\ecls.exe') then esetdir:=winpfolder+'ESET\ESET Smart Security\';
if fileexists(winpfolder+'ESET\ESET NOD32 Antivirus\ecls.exe') then esetdir:=winpfolder+'ESET\ESET NOD32 Antivirus\';
if esetdir<>'' then
   begin
   istr:=istr+1;
   astr[istr]:='ESET/NOD32';
   bstr[istr]:='"'+esetdir+'ecls.exe" ';
   cstr[istr]:='';
   dstr[istr]:='"'+esetdir+'egui.exe"';
   end;

mbampath:='';
if fileexists(winpfolder32+'Malwarebytes'' Anti-Malware\mbam.exe') then mbampath:=winpfolder32+'Malwarebytes'' Anti-Malware\mbam.exe';
if fileexists(winpfolder+'Malwarebytes'' Anti-Malware\mbam.exe') then mbampath:=winpfolder+'Malwarebytes'' Anti-Malware\mbam.exe';
if fileexists(winpfolder32+'MALWAREBYTES ANTI-MALWARE\mbam.exe') then mbampath:=winpfolder32+'MALWAREBYTES ANTI-MALWARE\mbam.exe';
if fileexists(winpfolder+'MALWAREBYTES ANTI-MALWARE\mbam.exe') then mbampath:=winpfolder+'MALWAREBYTES ANTI-MALWARE\mbam.exe';
if fileexists(winpfolder32+'Malwarebytes\Anti-Malware\mbam.exe') then mbampath:=winpfolder32+'Malwarebytes\Anti-Malware\mbam.exe';
if fileexists(winpfolder+'Malwarebytes\Anti-Malware\mbam.exe') then mbampath:=winpfolder+'Malwarebytes\Anti-Malware\mbam.exe';
if mbampath<>'' then
   begin
   istr:=istr+1;
   astr[istr]:='Malwarebyte''s Anti-Malware';
   bstr[istr]:='"'+mbampath+'" ';  //MBAM free version does not support scripting the scan
   cstr[istr]:='';
   dstr[istr]:='"'+mbampath+'"';
   end;

if fileexists(winpfolder32+'Spybot - Search & Destroy\SDFiles.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Spybot - Search and Destroy';
   bstr[istr]:='"'+winpfolder32+'Spybot - Search & Destroy\SDFiles.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder32+'Spybot - Search & Destroy\SpybotSD.exe';
   end;
if fileexists(winpfolder+'Spybot - Search & Destroy\SDFiles.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Spybot - Search and Destroy';
   bstr[istr]:='"'+winpfolder+'Spybot - Search & Destroy\SDFiles.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder+'Spybot - Search & Destroy\SpybotSD.exe';
   end;

if fileexists(winpfolder32+'VirusTotalUploader2\VirusTotalUpload2.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='VirusTotal';
   bstr[istr]:='"'+winpfolder32+'VirusTotalUploader2\VirusTotalUpload2.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder32+'VirusTotalUploader2\VirusTotalUpload2.exe';
   end;
if fileexists(winpfolder+'VirusTotalUploader2\VirusTotalUpload2.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='VirusTotal';
   bstr[istr]:='"'+winpfolder+'VirusTotalUploader2\VirusTotalUpload2.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder+'VirusTotalUploader2\VirusTotalUpload2.exe';
   end;

with form_peach do
begin
StringGridCustedit1.Cells[1,1]:=astr[1];
advedit1before:=bstr[1];
advedit1after:=cstr[1];
advedit1alt:=dstr[1];
StringGridCustedit1.Cells[1,2]:=astr[2];
advedit2before:=bstr[2];
advedit2after:=cstr[2];
advedit2alt:=dstr[2];
StringGridCustedit1.Cells[1,3]:=astr[3];
advedit3before:=bstr[3];
advedit3after:=cstr[3];
advedit3alt:=dstr[3];
StringGridCustedit1.Cells[1,4]:=astr[4];
advedit4before:=bstr[4];
advedit4after:=cstr[4];
advedit4alt:=dstr[4];
StringGridCustedit1.Cells[1,5]:=astr[5];
advedit5before:=bstr[5];
advedit5after:=cstr[5];
advedit5alt:=dstr[5];
StringGridCustedit1.Cells[1,6]:=astr[6];
advedit6before:=bstr[6];
advedit6after:=cstr[6];
advedit6alt:=dstr[6];
StringGridCustedit1.Cells[1,7]:=astr[7];
advedit7before:=bstr[7];
advedit7after:=cstr[7];
advedit7alt:=dstr[7];
StringGridCustedit1.Cells[1,8]:=astr[8];
advedit8before:=bstr[8];
advedit8after:=cstr[8];
advedit8alt:=dstr[8];
end;
{$ENDIF}
end;

function checklinapp(s:utf8string):boolean;
begin
result:=false;
if (fileexists('/bin/'+s)) or
   (fileexists('/usr/bin/'+s)) then result:=true;
end;

function checkmacapp(s:utf8string):boolean;
begin
result:=false;
if (DirectoryExists('/Applications/'+s)) or
   (DirectoryExists('/System/Applications/'+s)) then result:=true;
end;

procedure reset_custedit;
var
   i,ioff,iacro,iooo:integer;
begin
with form_peach do
begin
for i:=1 to 16 do
   begin
   StringGridCustedit.Cells[1,i]:='';
   StringGridCustedit.Cells[2,i]:='';
   end;
for i:=1 to 8 do
   begin
   StringGridCustedit1.Cells[1,i]:='';
   StringGridCustedit1.Cells[2,i]:='';
   StringGridCustedit1.Cells[3,i]:='';
   StringGridCustedit1.Cells[4,i]:='';
   end;
custedit1:='';
advedit1before:='';
advedit1after:='';
advedit1alt:='';
custedit2:='';
advedit2before:='';
advedit2after:='';
advedit2alt:='';
custedit3:='';
advedit3before:='';
advedit3after:='';
advedit3alt:='';
custedit4:='';
advedit4before:='';
advedit4after:='';
advedit4alt:='';
custedit5:='';
advedit5before:='';
advedit5after:='';
advedit5alt:='';
custedit6:='';
advedit6before:='';
advedit6after:='';
advedit6alt:='';
custedit7:='';
advedit7before:='';
advedit7after:='';
advedit7alt:='';
custedit8:='';
advedit8before:='';
advedit8after:='';
advedit8alt:='';
custedit9:='';
custedit10:='';
custedit11:='';
custedit12:='';
custedit13:='';
custedit14:='';
custedit15:='';
custedit16:='';
{$IFDEF MSWINDOWS}
wingetprogramsfolder;
wingetsystemfolder;
wingetappdatafolder;
//try to find if some common applications are installed, preference for free software and for programs using same location for different versions
//1 Google search, open with default system browser
StringGridCustedit.Cells[1,1]:='Google';
custedit1:='https://www.google.com/search?q=';
//2 Notepad
StringGridCustedit.Cells[1,2]:='Notepad';
custedit2:='notepad.exe';
//3 media players: VLC then Windows Media Player
if fileexists(winpfolder+'VideoLAN\VLC\vlc.exe') then
   begin
   StringGridCustedit.Cells[1,3]:='VLC Media Player';
   custedit3:=winpfolder+'VideoLAN\VLC\vlc.exe';
   end
else
   begin
   StringGridCustedit.Cells[1,3]:='Windows Media Player';
   custedit3:='wmplayer.exe';
   end;
//4 image viewers FastStone then Irfan then XnView
if fileexists(winpfolder32+'IrfanView\i_view32.exe') then
   begin
   StringGridCustedit.Cells[1,4]:='IrfanView';
   custedit4:=winpfolder32+'IrfanView\i_view32.exe';
   end;
if fileexists(winpfolder32+'xnview\xnview.exe') then
   begin
   StringGridCustedit.Cells[1,4]:='XnView';
   custedit4:=winpfolder32+'xnview\xnview.exe';
   end;
if fileexists(winpfolder32+'FastStone Image Viewer\FSViewer.exe') then
   begin
   StringGridCustedit.Cells[1,4]:='FastStone Image Viewer';
   custedit4:=winpfolder32+'FastStone Image Viewer\FSViewer.exe';
   end;
if fileexists(winpfolder+'xnview\xnview.exe') then
   begin
   StringGridCustedit.Cells[1,4]:='XnView';
   custedit4:=winpfolder+'xnview\xnview.exe';
   end;
if fileexists(winpfolder+'IrfanView\i_view64.exe') then
   begin
   StringGridCustedit.Cells[1,4]:='IrfanView';
   custedit4:=winpfolder+'IrfanView\i_view64.exe';
   end;
if fileexists(winpfolder+'FastStone Image Viewer\FSViewer.exe') then
   begin
   StringGridCustedit.Cells[1,4]:='FastStone Image Viewer';
   custedit4:=winpfolder+'FastStone Image Viewer\FSViewer.exe';
   end;
//5 raster painting
if fileexists(winpfolder+'Paint.NET\PaintDotNet.exe') then
   begin
   StringGridCustedit.Cells[1,5]:='Paint.NET';
   custedit5:=winpfolder+'Paint.NET\PaintDotNet.exe';
   end
else
   begin
   StringGridCustedit.Cells[1,5]:='MS Paint';
   custedit5:='mspaint.exe';
   end;
//6 PDF Acrobat Reader DC, then PDF24 Reader, then older Acrobat Reader versions
for iacro:=4 to 11 do
begin
if fileexists(winpfolder32+'Adobe\Reader '+inttostr(iacro)+'.0\Reader\AcroRd32.exe') then
   begin
   StringGridCustedit.Cells[1,6]:='Acrobat Reader';
   custedit6:=winpfolder32+'Adobe\Reader '+inttostr(iacro)+'.0\Reader\AcroRd32.exe';
   end;
end;
if fileexists(winpfolder32+'PDF24\pdf24-Reader.exe') then
   begin
   StringGridCustedit.Cells[1,6]:='PDF24 Reader';
   custedit6:=winpfolder32+'PDF24\pdf24-Reader.exe';
   end;
if fileexists(winpfolder32+'Adobe\Acrobat Reader DC\Reader\AcroRd32.exe') then
   begin
   StringGridCustedit.Cells[1,6]:='Acrobat Reader DC';
   custedit6:=winpfolder32+'Adobe\Acrobat Reader DC\Reader\AcroRd32.exe';
   end;
//7 documents Office, then Libre/Open Office then Wordpad
//8 spreadsheet Office, then Libre/Open Office
//9 presentations Office, then Libre/Open Office
//10 database Office, then Libre/Open Office
//11 mail Office
//12 vector drawing Office, then Libre/Open Office
if fileexists(winpfolder+'Windows NT\Accessories\wordpad.exe') then
   begin
   StringGridCustedit.Cells[1,7]:='WordPad';
   custedit7:=winpfolder+'Windows NT\Accessories\wordpad.exe';
   end;
if fileexists(winpfolder+'LibreOffice\program\writer.exe') then
   begin
   StringGridCustedit.Cells[1,7]:='Writer';
   custedit7:=winpfolder+'LibreOffice\program\writer.exe';
   end;
if fileexists(winpfolder+'LibreOffice\program\calc.exe') then
   begin
   StringGridCustedit.Cells[1,8]:='Calc';
   custedit8:=winpfolder+'LibreOffice\program\calc.exe';
   end;
if fileexists(winpfolder+'LibreOffice\program\impress.exe') then
   begin
   StringGridCustedit.Cells[1,9]:='Impress';
   custedit9:=winpfolder+'LibreOffice\program\impress.exe';
   end;
if fileexists(winpfolder+'LibreOffice\program\base.exe') then
   begin
   StringGridCustedit.Cells[1,10]:='Base';
   custedit10:=winpfolder+'LibreOffice\program\base.exe';
   end;
if fileexists(winpfolder+'LibreOffice\program\draw.exe') then
   begin
   StringGridCustedit.Cells[1,12]:='Draw';
   custedit12:=winpfolder+'LibreOffice\program\draw.exe';
   end;
if fileexists(winpfolder+'OpenOffice\program\writer.exe') then
   begin
   StringGridCustedit.Cells[1,7]:='Writer';
   custedit7:=winpfolder+'OpenOffice\program\writer.exe';
   end;
if fileexists(winpfolder+'OpenOffice\program\calc.exe') then
   begin
   StringGridCustedit.Cells[1,8]:='Calc';
   custedit8:=winpfolder+'OpenOffice\program\calc.exe';
   end;
if fileexists(winpfolder+'OpenOffice\program\impress.exe') then
   begin
   StringGridCustedit.Cells[1,9]:='Impress';
   custedit9:=winpfolder+'OpenOffice\program\impress.exe';
   end;
if fileexists(winpfolder+'OpenOffice\program\base.exe') then
   begin
   StringGridCustedit.Cells[1,10]:='Base';
   custedit10:=winpfolder+'OpenOffice\program\base.exe';
   end;
if fileexists(winpfolder+'OpenOffice\program\draw.exe') then
   begin
   StringGridCustedit.Cells[1,12]:='Draw';
   custedit12:=winpfolder+'OpenOffice\program\draw.exe';
   end;
for iooo:=4 to 9 do
begin
if fileexists(winpfolder+'LibreOffice '+inttostr(iooo)+'\program\writer.exe') then
   begin
   StringGridCustedit.Cells[1,7]:='Writer';
   custedit7:=winpfolder+'LibreOffice '+inttostr(iooo)+'\program\writer.exe';
   end;
if fileexists(winpfolder+'LibreOffice '+inttostr(iooo)+'\program\calc.exe') then
   begin
   StringGridCustedit.Cells[1,8]:='Calc';
   custedit8:=winpfolder+'LibreOffice '+inttostr(iooo)+'\program\calc.exe';
   end;
if fileexists(winpfolder+'LibreOffice '+inttostr(iooo)+'\program\impress.exe') then
   begin
   StringGridCustedit.Cells[1,9]:='Impress';
   custedit9:=winpfolder+'LibreOffice '+inttostr(iooo)+'\program\impress.exe';
   end;
if fileexists(winpfolder+'LibreOffice '+inttostr(iooo)+'\program\base.exe') then
   begin
   StringGridCustedit.Cells[1,10]:='Base';
   custedit10:=winpfolder+'LibreOffice '+inttostr(iooo)+'\program\base.exe';
   end;
if fileexists(winpfolder+'LibreOffice '+inttostr(iooo)+'\program\draw.exe') then
   begin
   StringGridCustedit.Cells[1,12]:='Draw';
   custedit12:=winpfolder+'LibreOffice '+inttostr(iooo)+'\program\draw.exe';
   end;
if fileexists(winpfolder+'OpenOffice '+inttostr(iooo)+'\program\writer.exe') then
   begin
   StringGridCustedit.Cells[1,7]:='Writer';
   custedit7:=winpfolder+'OpenOffice '+inttostr(iooo)+'\program\writer.exe';
   end;
if fileexists(winpfolder+'OpenOffice '+inttostr(iooo)+'\program\calc.exe') then
   begin
   StringGridCustedit.Cells[1,8]:='Calc';
   custedit8:=winpfolder+'OpenOffice '+inttostr(iooo)+'\program\calc.exe';
   end;
if fileexists(winpfolder+'OpenOffice '+inttostr(iooo)+'\program\impress.exe') then
   begin
   StringGridCustedit.Cells[1,9]:='Impress';
   custedit9:=winpfolder+'OpenOffice '+inttostr(iooo)+'\program\impress.exe';
   end;
if fileexists(winpfolder+'OpenOffice '+inttostr(iooo)+'\program\base.exe') then
   begin
   StringGridCustedit.Cells[1,10]:='Base';
   custedit10:=winpfolder+'OpenOffice '+inttostr(iooo)+'\program\base.exe';
   end;
if fileexists(winpfolder+'OpenOffice '+inttostr(iooo)+'\program\draw.exe') then
   begin
   StringGridCustedit.Cells[1,12]:='Draw';
   custedit12:=winpfolder+'OpenOffice '+inttostr(iooo)+'\program\draw.exe';
   end;
end;
for ioff:=8 to 29 do
begin
if fileexists(winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\winword.exe') then
   begin
   StringGridCustedit.Cells[1,7]:='Word';
   custedit7:=winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\winword.exe';
   end;
if fileexists(winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\winword.exe') then
   begin
   StringGridCustedit.Cells[1,7]:='Word';
   custedit7:=winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\winword.exe';
   end;
if fileexists(winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\excel.exe') then
   begin
   StringGridCustedit.Cells[1,8]:='Excel';
   custedit8:=winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\excel.exe';
   end;
if fileexists(winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\excel.exe') then
   begin
   StringGridCustedit.Cells[1,8]:='Excel';
   custedit8:=winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\excel.exe';
   end;
if fileexists(winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\powerpnt.exe') then
   begin
   StringGridCustedit.Cells[1,9]:='PowerPoint';
   custedit9:=winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\powerpnt.exe';
   end;
if fileexists(winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\powerpnt.exe') then
   begin
   StringGridCustedit.Cells[1,9]:='PowerPoint';
   custedit9:=winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\powerpnt.exe';
   end;
if fileexists(winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\msaccess.exe') then
   begin
   StringGridCustedit.Cells[1,10]:='Access';
   custedit10:=winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\msaccess.exe';
   end;
if fileexists(winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\msaccess.exe') then
   begin
   StringGridCustedit.Cells[1,10]:='Access';
   custedit10:=winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\msaccess.exe';
   end;
if fileexists(winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\outlook.exe') then
   begin
   StringGridCustedit.Cells[1,11]:='Outlook';
   custedit11:=winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\outlook.exe';
   end;
if fileexists(winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\outlook.exe') then
   begin
   StringGridCustedit.Cells[1,11]:='Outlook';
   custedit11:=winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\outlook.exe';
   end;
if fileexists(winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\visio.exe') then
   begin
   StringGridCustedit.Cells[1,12]:='Visio';
   custedit12:=winpfolder32+'Microsoft Office\Office'+inttostr(ioff)+'\visio.exe';
   end;
if fileexists(winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\visio.exe') then
   begin
   StringGridCustedit.Cells[1,12]:='Visio';
   custedit12:=winpfolder+'Microsoft Office\Office'+inttostr(ioff)+'\visio.exe';
   end;
end;
//13 Internet Explorer
StringGridCustedit.Cells[1,13]:='Internet Explorer';
custedit13:='iexplore.exe';
//14 Chrome
if fileexists(extractfilepath((GetEnvironmentVariable('APPDATA')))+'Local\Google\Chrome\Application\chrome.exe') then
   begin
   StringGridCustedit.Cells[1,14]:='Chrome';
   custedit14:=extractfilepath((GetEnvironmentVariable('APPDATA')))+'Local\Google\Chrome\Application\chrome.exe';
   end;
if fileexists(winpfolder+'Google\Chrome\Application\chrome.exe') then
   begin
   StringGridCustedit.Cells[1,14]:='Chrome';
   custedit14:=winpfolder+'Google\Chrome\Application\chrome.exe';
   end;
//15 other browsers: FF then Opera
if fileexists(winpfolder+'Opera\opera.exe') then
   begin
   StringGridCustedit.Cells[1,15]:='Opera';
   custedit15:=winpfolder+'Opera\opera.exe';
   end;
if fileexists(winpfolder+'Mozilla Firefox\firefox.exe') then
   begin
   StringGridCustedit.Cells[1,15]:='Mozilla Firefox';
   custedit15:=winpfolder+'Mozilla Firefox\firefox.exe';
   end;
set_win_antivirus;
{$ELSE}
{$IFDEF DARWIN}
StringGridCustedit.Cells[1,1]:='Text editor';
custedit1:='open -t';
StringGridCustedit.Cells[1,2]:='Pages';
custedit2:='open -a Pages';
StringGridCustedit.Cells[1,3]:='Numbers';
custedit3:='open -a Numbers';
StringGridCustedit.Cells[1,4]:='Preview';
custedit4:='open -a Preview';
StringGridCustedit.Cells[1,5]:='Photos';
custedit5:='open -a Photo';
StringGridCustedit.Cells[1,6]:='Quick Time Player';
custedit6:='open -a "QuickTime Player"';
StringGridCustedit.Cells[1,7]:='Safari';
custedit7:='open -a Safari';
StringGridCustedit.Cells[1,8]:='Script Editor';
custedit8:='open -a "Script Editor"';
if checkmacapp('Gimp.app')=true then
   begin
   StringGridCustedit.Cells[1,9]:='Gimp';
   custedit9:='open -a Gimp';
   end
else
   if checkmacapp('Inkscape.app')=true then
      begin
      StringGridCustedit.Cells[1,9]:='Inkscape';
      custedit9:='open -a Inkscape';
      end
   else
      if checkmacapp('LibreOffice.app')=true then
         begin
         StringGridCustedit.Cells[1,9]:='Draw';
         custedit9:='open -a lodraw';
         end
      else
         if checkmacapp('OpenOffice.app')=true then
            begin
            StringGridCustedit.Cells[1,9]:='Draw';
            custedit9:='open -a oodraw';
            end;
if checkmacapp('VLC.app')=true then
   begin
   StringGridCustedit.Cells[1,10]:='VLC';
   custedit10:='open -a VLC';
   end;
if checkmacapp('Firefox')=true then
   begin
   StringGridCustedit.Cells[1,11]:='Mozilla Firefox';
   custedit11:='open -a Firefox';
   end;
if checkmacapp('Google Chrome.app')=true then
   begin
   StringGridCustedit.Cells[1,12]:='Google Chrome';
   custedit12:='open -a "Google Chrome"';
   end;

if checkmacapp('LibreOffice.app')=true then
   begin
   StringGridCustedit.Cells[1,13]:='Writer';
   custedit13:='open -a lowriter';
   end
else
   if checkmacapp('OpenOffice.app')=true then
      begin
      StringGridCustedit.Cells[1,13]:='Writer';
      custedit13:='open -a oowriter';
      end;
if checkmacapp('LibreOffice.app')=true then
   begin
   StringGridCustedit.Cells[1,14]:='Calc';
   custedit14:='open -a localc';
   end
else
   if checkmacapp('OpenOffice.app')=true then
      begin
      StringGridCustedit.Cells[1,14]:='Calc';
      custedit14:='open -a oocalc';
      end;
if checkmacapp('LibreOffice.app')=true then
   begin
   StringGridCustedit.Cells[1,15]:='Base';
   custedit15:='open -a lobase';
   end
else
   if checkmacapp('OpenOffice.app')=true then
      begin
      StringGridCustedit.Cells[1,15]:='Base';
      custedit15:='open -a oobase';
      end;
if checkmacapp('LibreOffice.app')=true then
   begin
   StringGridCustedit.Cells[1,16]:='Impress';
   custedit16:='open -a loimpress';
   end
else
   if checkmacapp('OpenOffice.app')=true then
      begin
      StringGridCustedit.Cells[1,16]:='Impress';
      custedit16:='open -a ooimpress';
      end;


{$ELSE}
StringGridCustedit.Cells[1,1]:='Text editor';
if desk_env=1 then custedit1:='gedit'
else
   if desk_env=2 then custedit1:='kwrite'
   else
      if checklinapp('mousepad')=true then
         begin
         StringGridCustedit.Cells[1,1]:='Mousepad';
         custedit1:='mousepad';
         end
      else
         if checklinapp('emacs')=true then custedit1:='emacs'
         else
            if checklinapp('vim')=true then custedit1:='vim'
            else custedit1:='vi';
//OpenOffice and LibreOffice
if checklinapp('lowriter')=true then
   begin
   StringGridCustedit.Cells[1,2]:='Writer';
   custedit2:='lowriter';
   end
else
   if checklinapp('oowriter')=true then
      begin
      StringGridCustedit.Cells[1,2]:='Writer';
      custedit2:='oowriter';
      end
   else
      if checklinapp('abiword')=true then
         begin
         StringGridCustedit.Cells[1,2]:='AbiWord';
         custedit2:='abiword';
         end
      else
         if checklinapp('latex')=true then
            begin
            StringGridCustedit.Cells[1,2]:='LaTeX';
            custedit2:='latex';
            end;
if checklinapp('localc')=true then
   begin
   StringGridCustedit.Cells[1,3]:='Calc';
   custedit3:='localc';
   end
else
   if checklinapp('oocalc')=true then
      begin
      StringGridCustedit.Cells[1,3]:='Calc';
      custedit3:='oocalc';
      end
   else
      if checklinapp('gnumeric')=true then
         begin
         StringGridCustedit.Cells[1,3]:='Gnumeric';
         custedit3:='gnumeric';
         end;
if checklinapp('lobase')=true then
   begin
   StringGridCustedit.Cells[1,4]:='Base';
   custedit4:='lobase';
   end
else
   if checklinapp('oobase')=true then
      begin
      StringGridCustedit.Cells[1,4]:='Base';
      custedit4:='oobase';
      end;
if checklinapp('loimpress')=true then
   begin
   StringGridCustedit.Cells[1,5]:='Impress';
   custedit5:='loimpress';
   end
else
   if checklinapp('ooimpress')=true then
      begin
      StringGridCustedit.Cells[1,5]:='Impress';
      custedit5:='ooimpress';
      end;
if checklinapp('lodraw')=true then
   begin
   StringGridCustedit.Cells[1,6]:='Draw';
   custedit6:='lodraw';
   end
else
   if checklinapp('oodraw')=true then
      begin
      StringGridCustedit.Cells[1,6]:='Draw';
      custedit6:='oodraw';
      end;
//video
if checklinapp('vlc')=true then
   begin
   StringGridCustedit.Cells[1,7]:='VLC';
   custedit7:='vlc';
   end;
if checklinapp('totem')=true then
   begin
   StringGridCustedit.Cells[1,8]:='Totem';
   custedit8:='totem';
   end
else
   if checklinapp('celluloid')=true then
      begin
      StringGridCustedit.Cells[1,8]:='Celluloid';
      custedit8:='celluloid';
      end
   else
      if checklinapp('parole')=true then
         begin
         StringGridCustedit.Cells[1,8]:='Parole';
         custedit8:='parole';
         end
      else
         if checklinapp('mplayer')=true then
            begin
            StringGridCustedit.Cells[1,8]:='mplayer';
            custedit8:='mplayer';
            end
         else
            if checklinapp('smplayer')=true then
               begin
               StringGridCustedit.Cells[1,8]:='smplayer';
               custedit8:='smplayer';
               end
            else
               if checklinapp('mpv')=true then
                  begin
                  StringGridCustedit.Cells[1,8]:='Mpv';
                  custedit8:='mpv';
                  end;
//audio
if checklinapp('rhythmbox')=true then
   begin
   StringGridCustedit.Cells[1,9]:='Rhythmbox';
   custedit9:='rhythmbox';
   end
else
   if checklinapp('juk')=true then
      begin
      StringGridCustedit.Cells[1,9]:='Juk';
      custedit9:='juk';
      end
   else
      if checklinapp('amarock')=true then
         begin
         StringGridCustedit.Cells[1,9]:='Amarok';
         custedit9:='amarock';
         end;
//graphics
if checklinapp('gimp')=true then
   begin
   StringGridCustedit.Cells[1,10]:='Gimp';
   custedit10:='gimp';
   end
else
   if checklinapp('inkscape')=true then
      begin
      StringGridCustedit.Cells[1,10]:='Inkscape';
      custedit10:='inkscape';
      end
   else
      if checklinapp('krita')=true then
      begin
      StringGridCustedit.Cells[1,10]:='Krita';
      custedit10:='krita';
      end;
if checklinapp('shotwell')=true then
   begin
   StringGridCustedit.Cells[1,11]:='Shotwell';
   custedit11:='shotwell';
   end
else
   if checklinapp('digikam')=true then
      begin
      StringGridCustedit.Cells[1,11]:='digiKam';
      custedit11:='digikam';
      end
   else
      if checklinapp('f-spot')=true then
         begin
         StringGridCustedit.Cells[1,11]:='F-Spot';
         custedit11:='f-spot';
         end;
if checklinapp('pix')=true then
   begin
   StringGridCustedit.Cells[1,12]:='Pix';
   custedit12:='pix';
   end
else
   if checklinapp('xviewer')=true then
      begin
      StringGridCustedit.Cells[1,12]:='XViewer';
      custedit12:='xviewer';
      end
   else
      if checklinapp('gnome-photos')=true then
         begin
         StringGridCustedit.Cells[1,12]:='Photos';
         custedit12:='gnome-photos';
         end
      else
         if checklinapp('ristretto')=true then
            begin
            StringGridCustedit.Cells[1,12]:='Ristretto';
            custedit12:='ristretto';
            end;
//browsers
if checklinapp('firefox')=true then
   begin
   StringGridCustedit.Cells[1,13]:='Mozilla Firefox';
   custedit13:='firefox';
   end;
if checklinapp('google-chrome')=true then
   begin
   StringGridCustedit.Cells[1,14]:='Google Chrome';
   custedit14:='google-chrome';
   end;
if checklinapp('opera')=true then
   begin
   StringGridCustedit.Cells[1,15]:='Opera';
   custedit15:='opera';
   end;
if checklinapp('web')=true then
   begin
   StringGridCustedit.Cells[1,16]:='Web';
   custedit16:='web';
   end
else
   if checklinapp('epiphany')=true then
      begin
      StringGridCustedit.Cells[1,16]:='Epiphany';
      custedit16:='epiphany';
      end
   else
      if checklinapp('konqueror')=true then
         begin
         StringGridCustedit.Cells[1,16]:='Konqueror';
         custedit16:='konqueror';
         end
      else
         if checklinapp('brave-browser')=true then
            begin
            StringGridCustedit.Cells[1,16]:='Brave';
            custedit16:='brave-browser';
            end
         else
            if checklinapp('midori')=true then
               begin
               StringGridCustedit.Cells[1,16]:='Midori';
               custedit16:='midori';
               end;
//AV
if checklinapp('clamscan')=true then
   begin
   StringGridCustedit1.Cells[1,1]:='ClamAV';
   advedit1before:='clamscan --bell -i ';
   advedit1after:='';
   advedit1alt:='';
   end;
if checklinapp('maldet')=true then
   begin
   StringGridCustedit1.Cells[1,2]:='LMD';
   advedit2before:='maldet -a ';
   advedit2after:='';
   advedit2alt:='';
   end;
{$ENDIF}
{$ENDIF}
end;
set_custedit_totable;
set_custedit_menus;
end;

//procedure to checksum files mode: selected=only selected files; displayed=all files displayed in current directory or filter
procedure getcheck(mode:ansistring);
var
   sbuf:array [1..32767] of byte;
   i,t,n,nsel,rc:integer;
   k:qword;
   inidir,s,strsel:ansistring;
   pgpsig:TPGPDigest;
   Adler:longint;
   CRC16:word;
   CRC24:longint;
   CRC32:longint;
   CRC64:TCRC64;
   ED2KContext:TED2KContext;
   ED2KRes:TED2KResult;
   MD4Context:THashContext;
   MD4Digest:TMD4Digest;
   MD5Context:THashContext;
   MD5Digest:TMD5Digest;
   RMD160Context:THashContext;
   RMD160Digest:TRMD160Digest;
   SHA1Context:THashContext;
   SHA1Digest:TSHA1Digest;
   SHA3_256Context:THashContext;
   SHA3_256Digest:TSHA3_256Digest;
   SHA256Context:THashContext;
   SHA256Digest:TSHA256Digest;
   SHA3_512Context:THashContext;
   SHA3_512Digest:TSHA3_512Digest;
   SHA512Context:THashContext;
   SHA512Digest:TSHA512Digest;
   WhirlContext:THashContext;
   WhirlDigest:TWhirlDigest;
   Blake2sContext:blake2s_ctx;
   Blake2bContext:THashContext;
   Blake2sDigest:TBlake2sDigest;
   Blake2bDigest:TBlake2bDigest;
   f:file of byte;
begin
if Form_peach.StringGridList.RowCount<2 then exit;
if Form_peach.StringGridList.Row=0 then exit;
if Form_peach.StringGridList.Cells[1,1]='' then exit;
{$IFDEF MSWINDOWS}if Form_peach.EditOpenIn.Text=txt_mypc then exit;{$ENDIF}
if mode='neutral' then if checklistanysel<>0 then mode:='displayed' else mode:='selected';
if mode='selected' then if checklisttotsel(nsel,strsel)<>0 then exit;
if browsertype<>0 then
   begin
   settpreset(1);
   if mode='selected' then mode:='displayed';//selection is lost changing to list
   end;
rc:=Form_peach.StringGridList.Rowcount;
s:=Form_peach.Caption;
inidir:=Form_peach.EditOpenIn.Caption;
if Form_peach.visible=true then
   begin
   enter_busy_status;
   for i:=1 to rc-1 do
      begin
      if (Form_peach.StringGridList.Cells[2,i]<>txt_list_isfolder) then
         begin
         if mode='selected' then
            if Form_peach.StringGridList.Cells[15,i]='0' then
               begin
               Form_peach.StringGridList.Cells[10,i]:='';
               continue;
               end;
         filemode:=0;
         try
         assignfile(f,Form_peach.StringGridList.Cells[11,i]);
         filemode:=0;
         reset(f);
         except
         Form_peach.StringGridList.Cells[10,i]:='';
         continue;
         end;
         if mode='selected' then Form_peach.Caption:=Form_Peach.ListView1.Column[9].Caption+' ('+inttostr(t+1)+'/'+inttostr(nsel)+') '+Form_peach.StringGridList.Cells[1,i]+'...'
         else Form_peach.Caption:=Form_Peach.ListView1.Column[9].Caption+' ('+inttostr(i)+'/'+inttostr(rc)+') '+Form_peach.StringGridList.Cells[1,i]+'...';
         k:=0;
         t:=t+1;
         case browserch of
            1: Adler32Init(adler);
            2: CRC16Init(CRC16);
            3: CRC24Init(CRC24);
            4: CRC32Init(CRC32);
            5: CRC64Init(CRC64);
            6: ED2K_Init(ED2KContext);
            7: MD4Init(MD4Context);
            8: MD5Init(MD5Context);
            9: RMD160Init(RMD160Context);
           10: SHA1Init(SHA1Context);
           11: Blake2s_Init(Blake2sContext,nil,0,BLAKE2S_MaxDigLen);
           12: SHA256Init(SHA256Context);
           13: SHA3_256Init(SHA3_256Context);
           14: Blake2b_Init(Blake2bContext,nil,0,BLAKE2B_MaxDigLen);
           15: SHA512Init(SHA512Context);
           16: SHA3_512Init(SHA3_512Context);
           17: Whirl_Init(WhirlContext);
            end;
         repeat
            blockread(f,sbuf,sizeof(sbuf),n);
            if n<>0 then
               begin
               inc(k,n);
               case browserch of
                  1: Adler32Update(adler,@sbuf,n);
                  2: CRC16Update(CRC16,@sbuf,n);
                  3: CRC24Update(CRC24,@sbuf,n);
                  4: CRC32Update(CRC32,@sbuf,n);
                  5: CRC64Update(CRC64,@sbuf,n);
                  6: ED2K_Update(ED2KContext,@sbuf,n);
                  7: MD4Update(MD4Context,@sbuf,n);
                  8: MD5Update(MD5Context,@sbuf,n);
                  9: RMD160Update(RMD160Context,@sbuf,n);
                 10: SHA1Update(SHA1Context,@sbuf,n);
                 11: Blake2s_update(Blake2sContext,@sbuf,n);
                 12: SHA256Update(SHA256Context,@sbuf,n);
                 13: SHA3_256Update(SHA3_256Context,@sbuf,n);
                 14: Blake2b_update(Blake2bContext,@sbuf,n);
                 15: SHA512Update(SHA512Context,@sbuf,n);
                 16: SHA3_512Update(SHA3_512Context,@sbuf,n);
                 17: Whirl_Update(WhirlContext,@sbuf,n);
                  end;
               Application.ProcessMessages;
               if (inidir<>Form_peach.EditOpenIn.Caption) or (endflag=true) then
                  begin
                  exit_busy_status;
                  Form_peach.Caption:=s;
                  exit;
                  end;
               end;
         until n<>sizeof(sbuf);
         close(f);
         case browserch of
            1: Adler32Final(adler);
            2: CRC16Final(CRC16);
            3: begin CRC24Final(CRC24); Long2PGP(CRC24, pgpsig); end;
            4: CRC32Final(CRC32);
            5: CRC64Final(CRC64);
            6: ED2K_Final(ED2KContext,ED2KRes);
            7: MD4Final(MD4Context,MD4Digest);
            8: MD5Final(MD5Context,MD5Digest);
            9: RMD160Final(RMD160Context,RMD160Digest);
           10: SHA1Final(SHA1Context,SHA1Digest);
           11: blake2s_Final(Blake2sContext,Blake2sDigest);
           12: SHA256Final(SHA256Context,SHA256Digest);
           13: SHA3_256Final(SHA3_256Context,SHA3_256Digest);
           14: blake2b_Final(Blake2bContext,Blake2bDigest);
           15: SHA512Final(SHA512Context,SHA512Digest);
           16: SHA3_512Final(SHA3_512Context,SHA3_512Digest);
           17: Whirl_Final(WhirlContext,WhirlDigest);
            end;
         case browserch of
            1: Adler := (Adler shr 24) or ((Adler shr 8) and $FF00) or ((Adler shl 8) and $FF0000) or (Adler shl 24);
            2: CRC16 := swap(CRC16);
            3: Form_peach.StringGridList.Cells[10,i]:=hexstr(@pgpsig,sizeof(pgpsig));
            4: CRC32 := (CRC32 shr 24) or ((CRC32 shr 8) and $FF00) or ((CRC32 shl 8) and $FF0000) or (CRC32 shl 24);
            end;
         case browserch of
            1: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@adler,sizeof(Adler)));
            2: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@CRC16,sizeof(CRC16)));
            4: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@CRC32,sizeof(CRC32)));
            5: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@CRC64,sizeof(CRC64)));
            6: begin
               Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@ED2KRes.eDonkey, sizeof(ED2KRes.eDonkey)));
               if ED2KRes.differ then Form_peach.StringGridList.Cells[7,i]:=Form_peach.StringGridList.Cells[7,i]+' / eMule: '+upcase(hexstr(@ED2KRes.eMule, sizeof(ED2KRes.eMule)));
               end;
            7: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@MD4Digest,sizeof(MD4Digest)));
            8: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@MD5Digest,sizeof(MD5Digest)));
            9: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@RMD160Digest,sizeof(RMD160Digest)));
           10: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA1Digest,sizeof(SHA1Digest)));
           11: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@Blake2sDigest,sizeof(Blake2sDigest)));
           12: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA256Digest,sizeof(SHA256Digest)));
           13: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA3_256Digest,sizeof(SHA3_256Digest)));
           14: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@Blake2bDigest,sizeof(Blake2bDigest)));
           15: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA512Digest,sizeof(SHA512Digest)));
           16: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA3_512Digest,sizeof(SHA3_512Digest)));
           17: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@WhirlDigest,sizeof(WhirlDigest)));
            end;
         Form_Peach.ListView1.Items[i-1].SubItems[8]:=Form_Peach.StringGridList.Cells[10,i];
         end;
      end;
   exit_busy_status;
   Form_peach.Caption:=s;
   //update_listview;
   end;
end;

function countsize(s:ansistring):integer;
var
   i:integer;
begin
result:=0;
for i:=1 to Form_peach.StringGridList.Rowcount-1 do
   if s=Form_peach.StringGridList.Cells[3,i] then result:=result+1;
end;

function countsize2(s:ansistring):integer;
var
   i:integer;
begin
result:=0;
for i:=1 to Form_peach.StringGridList.Rowcount-1 do
   begin
   if s=Form_peach.StringGridList.Cells[3,i] then result:=result+1;
   if result>1 then break;
   end;
end;

function checkduplicates:integer;
var
   i,j:integer;
   duplicate:boolean;
   s:ansistring;
begin
result:=0;
//test for identical checksums
for i:=1 to Form_peach.StringGridList.Rowcount-1 do
   begin
   s:=Form_peach.StringGridList.Cells[10,i];
   duplicate:=false;
   for j:=1 to Form_peach.StringGridList.Rowcount-1 do
      if (Form_peach.StringGridList.Cells[10,j]<>'')
      and (s=Form_peach.StringGridList.Cells[10,j])
      and (i<>j) then
         begin
         duplicate:=true;
         break;
         end;
   if duplicate=false then Form_peach.StringGridList.Cells[10,i]:=''
   else
      result:=result+1;
   Form_Peach.ListView1.Items[i-1].SubItems[8]:=Form_Peach.StringGridList.Cells[10,i];
   end;
//mark duplicate all copies but one (last found)
for i:=1 to Form_peach.StringGridList.Rowcount-2 do
   begin
   s:=Form_peach.StringGridList.Cells[10,i];
   for j:=i+1 to Form_peach.StringGridList.Rowcount-1 do
      if (Form_peach.StringGridList.Cells[10,j]<>'')
      and (s=Form_peach.StringGridList.Cells[10,j]) then
         begin
         Form_peach.StringGridList.Cells[4,i]:='D';
         Form_peach.StringGridList.Cells[14,i]:='D';
         Form_Peach.ListView1.Items[i-1].SubItems[2]:=Form_Peach.StringGridList.Cells[4,i];
         end;
   end;
end;

function checkduplicates2:integer;
var
   i:integer;
begin
result:=0;
for i:=1 to Form_peach.StringGridList.Rowcount-1 do
  if Form_peach.StringGridList.Cells[10,i]<>'' then result:=result+1;
end;

//procedure to deduplicate files, mode displayed: all in current folder / search filter; selected: all selected
procedure fulldeduplicate(mode:ansistring);
var
   sbuf:array [1..32767] of byte;
   dup,i,n,t,rc,nsel:integer;
   k:qword;
   inidir,s,strsel:ansistring;
   pgpsig:TPGPDigest;
   Adler:longint;
   CRC16:word;
   CRC24:longint;
   CRC32:longint;
   CRC64:TCRC64;
   ED2KContext:TED2KContext;
   ED2KRes:TED2KResult;
   MD4Context:THashContext;
   MD4Digest:TMD4Digest;
   MD5Context:THashContext;
   MD5Digest:TMD5Digest;
   RMD160Context:THashContext;
   RMD160Digest:TRMD160Digest;
   Blake2sContext:blake2s_ctx;
   Blake2bContext:THashContext;
   Blake2sDigest:TBlake2sDigest;
   Blake2bDigest:TBlake2bDigest;
   SHA1Context:THashContext;
   SHA1Digest:TSHA1Digest;
   SHA3_256Context:THashContext;
   SHA3_256Digest:TSHA3_256Digest;
   SHA256Context:THashContext;
   SHA256Digest:TSHA256Digest;
   SHA3_512Context:THashContext;
   SHA3_512Digest:TSHA3_512Digest;
   SHA512Context:THashContext;
   SHA512Digest:TSHA512Digest;
   WhirlContext:THashContext;
   WhirlDigest:TWhirlDigest;
   f:file of byte;
begin
if Form_peach.StringGridList.RowCount<2 then exit;
if Form_peach.StringGridList.Row=0 then exit;
if Form_peach.StringGridList.Cells[1,1]='' then exit;
{$IFDEF MSWINDOWS}if Form_peach.EditOpenIn.Text=txt_mypc then exit;{$ENDIF}
if mode='neutral' then if checklistanysel<>0 then mode:='displayed' else mode:='selected';
if mode='selected' then if checklisttotsel(nsel,strsel)<>0 then exit;
if browsertype<>0 then
   begin
   settpreset(1);
   if mode='selected' then mode:='displayed';//selection is lost changing to list
   end;
rc:=Form_peach.StringGridList.Rowcount;
s:=Form_peach.Caption;
inidir:=Form_peach.EditOpenIn.Caption;
if Form_peach.visible=true then
   begin
   enter_busy_status;
   for i:=1 to rc-1 do
      if (Form_peach.StringGridList.Cells[2,i]<>txt_list_isfolder) and (Form_peach.StringGridList.Cells[3,i]<>'0') then
         begin
         if mode='selected' then
            if Form_peach.StringGridList.Cells[15,i]='0' then
               begin
               Form_peach.StringGridList.Cells[10,i]:='';
               continue;
               end;
         if countsize(Form_peach.StringGridList.Cells[3,i])<2 then continue;
         filemode:=0;
         try
         assignfile(f,Form_peach.StringGridList.Cells[11,i]);
         filemode:=0;
         reset(f);
         except
         continue;
         end;
         if mode='selected' then Form_peach.Caption:=txt_4_1_duplicatesfind+', '+Form_Peach.ListView1.Column[9].Caption+' ('+inttostr(t+1)+'/'+inttostr(nsel)+') '+Form_peach.StringGridList.Cells[1,i]+'...'
         else Form_peach.Caption:=txt_4_1_duplicatesfind+', '+Form_Peach.ListView1.Column[9].Caption+' ('+inttostr(i)+'/'+inttostr(rc)+') '+Form_peach.StringGridList.Cells[1,i]+'...';
         k:=0;
         t:=t+1;
         case browserch of
            1: Adler32Init(adler);
            2: CRC16Init(CRC16);
            3: CRC24Init(CRC24);
            4: CRC32Init(CRC32);
            5: CRC64Init(CRC64);
            6: ED2K_Init(ED2KContext);
            7: MD4Init(MD4Context);
            8: MD5Init(MD5Context);
            9: RMD160Init(RMD160Context);
           10: SHA1Init(SHA1Context);
           11: Blake2s_Init(Blake2sContext,nil,0,BLAKE2S_MaxDigLen);
           12: SHA3_256Init(SHA3_256Context);
           13: SHA256Init(SHA256Context);
           14: Blake2b_Init(Blake2bContext,nil,0,BLAKE2B_MaxDigLen);
           15: SHA3_512Init(SHA3_512Context);
           16: SHA512Init(SHA512Context);
           17: Whirl_Init(WhirlContext);
            end;
         repeat
            blockread(f,sbuf,sizeof(sbuf),n);
            if n<>0 then
               begin
               inc(k,n);
               case browserch of
                  1: Adler32Update(adler,@sbuf,n);
                  2: CRC16Update(CRC16,@sbuf,n);
                  3: CRC24Update(CRC24,@sbuf,n);
                  4: CRC32Update(CRC32,@sbuf,n);
                  5: CRC64Update(CRC64,@sbuf,n);
                  6: ED2K_Update(ED2KContext,@sbuf,n);
                  7: MD4Update(MD4Context,@sbuf,n);
                  8: MD5Update(MD5Context,@sbuf,n);
                  9: RMD160Update(RMD160Context,@sbuf,n);
                 10: SHA1Update(SHA1Context,@sbuf,n);
                 11: Blake2s_update(Blake2sContext,@sbuf,n);
                 12: SHA3_256Update(SHA3_256Context,@sbuf,n);
                 13: SHA256Update(SHA256Context,@sbuf,n);
                 14: Blake2b_update(Blake2bContext,@sbuf,n);
                 15: SHA3_512Update(SHA3_512Context,@sbuf,n);
                 16: SHA512Update(SHA512Context,@sbuf,n);
                 17: Whirl_Update(WhirlContext,@sbuf,n);
                  end;
               Application.ProcessMessages;
               if (inidir<>Form_peach.EditOpenIn.Caption) or (endflag=true) then
                  begin
                  exit_busy_status;
                  Form_peach.Caption:=s;
                  exit;
                  end;
               end;
         until n<>sizeof(sbuf);
         close(f);
         case browserch of
            1: Adler32Final(adler);
            2: CRC16Final(CRC16);
            3: begin CRC24Final(CRC24); Long2PGP(CRC24, pgpsig); end;
            4: CRC32Final(CRC32);
            5: CRC64Final(CRC64);
            6: ED2K_Final(ED2KContext,ED2KRes);
            7: MD4Final(MD4Context,MD4Digest);
            8: MD5Final(MD5Context,MD5Digest);
            9: RMD160Final(RMD160Context,RMD160Digest);
           10: SHA1Final(SHA1Context,SHA1Digest);
           11: blake2s_Final(Blake2sContext,Blake2sDigest);
           12: SHA3_256Final(SHA3_256Context,SHA3_256Digest);
           13: SHA256Final(SHA256Context,SHA256Digest);
           14: blake2b_Final(Blake2bContext,Blake2bDigest);
           15: SHA3_512Final(SHA3_512Context,SHA3_512Digest);
           16: SHA512Final(SHA512Context,SHA512Digest);
           17: Whirl_Final(WhirlContext,WhirlDigest);
            end;
         case browserch of
            1: Adler := (Adler shr 24) or ((Adler shr 8) and $FF00) or ((Adler shl 8) and $FF0000) or (Adler shl 24);
            2: CRC16 := swap(CRC16);
            3: Form_peach.StringGridList.Cells[10,i]:=hexstr(@pgpsig,sizeof(pgpsig));
            4: CRC32 := (CRC32 shr 24) or ((CRC32 shr 8) and $FF00) or ((CRC32 shl 8) and $FF0000) or (CRC32 shl 24);
            end;
         case browserch of
            1: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@adler,sizeof(Adler)));
            2: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@CRC16,sizeof(CRC16)));
            4: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@CRC32,sizeof(CRC32)));
            5: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@CRC64,sizeof(CRC64)));
            6: begin
               Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@ED2KRes.eDonkey, sizeof(ED2KRes.eDonkey)));
               if ED2KRes.differ then Form_peach.StringGridList.Cells[7,i]:=Form_peach.StringGridList.Cells[7,i]+' / eMule: '+upcase(hexstr(@ED2KRes.eMule, sizeof(ED2KRes.eMule)));
               end;
            7: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@MD4Digest,sizeof(MD4Digest)));
            8: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@MD5Digest,sizeof(MD5Digest)));
            9: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@RMD160Digest,sizeof(RMD160Digest)));
           10: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA1Digest,sizeof(SHA1Digest)));
           11: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@Blake2sDigest,sizeof(Blake2sDigest)));
           12: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA3_256Digest,sizeof(SHA3_256Digest)));
           13: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA256Digest,sizeof(SHA256Digest)));
           14: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@Blake2bDigest,sizeof(Blake2bDigest)));
           15: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA3_512Digest,sizeof(SHA3_512Digest)));
           16: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@SHA512Digest,sizeof(SHA512Digest)));
           17: Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@WhirlDigest,sizeof(WhirlDigest)));
            end;
         Form_peach.StringGridList.Cells[10,i]:=Form_peach.StringGridList.Cells[3,i]+'/'+Form_peach.StringGridList.Cells[10,i];
         Form_Peach.ListView1.Items[i-1].SubItems[8]:=Form_Peach.StringGridList.Cells[10,i];
         end;
   Form_peach.Caption:=txt_4_1_duplicatesfind+', '+Form_Peach.ListView1.Column[9].Caption+' '+s+'...';
   dup:=checkduplicates;
   exit_busy_status;
   Form_peach.Caption:=s;
   //update_listview;
   if dup=0 then pMessageInfoOK(inttostr(dup)+' '+txt_4_1_duplicatesfound)
   else pMessageInfoOK(inttostr(dup)+' '+txt_4_1_duplicatesfound+'; '+txt_4_1_duplicateshint);
   end;
end;

//quick procedure to find approximate duplicate files
procedure quickdeduplicate(mode:ansistring);
var
   sbuf:array [1..32767] of byte;
   dup,i,n,t,rc,nsel:integer;
   k:qword;
   inidir,s,strsel:ansistring;
   CRC32:longint;
   f:file of byte;
begin
if Form_peach.StringGridList.RowCount<2 then exit;
if Form_peach.StringGridList.Row=0 then exit;
if Form_peach.StringGridList.Cells[1,1]='' then exit;
{$IFDEF MSWINDOWS}if Form_peach.EditOpenIn.Text=txt_mypc then exit;{$ENDIF}
if mode='neutral' then if checklistanysel<>0 then mode:='displayed' else mode:='selected';
if mode='selected' then if checklisttotsel(nsel,strsel)<>0 then exit;
if browsertype<>0 then
   begin
   settpreset(1);
   if mode='selected' then mode:='displayed';//selection is lost changing to list
   end;
rc:=Form_peach.StringGridList.Rowcount;
s:=Form_peach.Caption;
inidir:=Form_peach.EditOpenIn.Caption;
if Form_peach.visible=true then
   begin
   enter_busy_status;
   for i:=1 to rc-1 do
      if (Form_peach.StringGridList.Cells[2,i]<>txt_list_isfolder) and (Form_peach.StringGridList.Cells[3,i]<>'0') then
         begin
         if mode='selected' then
            if Form_peach.StringGridList.Cells[15,i]='0' then
               begin
               Form_peach.StringGridList.Cells[10,i]:='';
               continue;
               end;
         if countsize2(Form_peach.StringGridList.Cells[3,i])<2 then continue;
         filemode:=0;
         try
         assignfile(f,Form_peach.StringGridList.Cells[11,i]);
         filemode:=0;
         reset(f);
         except
         continue;
         end;
         if mode='selected' then Form_peach.Caption:=txt_6_6_pdupfind+', ('+inttostr(t+1)+'/'+inttostr(nsel)+') '+Form_peach.StringGridList.Cells[1,i]+'...'
         else Form_peach.Caption:=txt_6_6_pdupfind+', ('+inttostr(i)+'/'+inttostr(rc)+') '+Form_peach.StringGridList.Cells[1,i]+'...';
         k:=0;
         t:=t+1;
         CRC32Init(CRC32);
         blockread(f,sbuf,sizeof(sbuf),n);
         if n<>0 then
               begin
               inc(k,n);
               CRC32Update(CRC32,@sbuf,n);
               Application.ProcessMessages;
               if (inidir<>Form_peach.EditOpenIn.Caption) or (endflag=true) then
                  begin
                  exit_busy_status;
                  Form_peach.Caption:=s;
                  exit;
                  end;
               end;
         if StrToInt64(Form_peach.StringGridList.Cells[3,i])>(64*1024) then
            begin
            seek(f,StrToInt64(Form_peach.StringGridList.Cells[3,i]) div 2);
            blockread(f,sbuf,sizeof(sbuf),n);
            if n<>0 then
               begin
               inc(k,n);
               CRC32Update(CRC32,@sbuf,n);
               end;
            end;
         close(f);
         CRC32Final(CRC32);
         CRC32 := (CRC32 shr 24) or ((CRC32 shr 8) and $FF00) or ((CRC32 shl 8) and $FF0000) or (CRC32 shl 24);
         Form_peach.StringGridList.Cells[10,i]:=upcase(hexstr(@CRC32,sizeof(CRC32)));
         Form_peach.StringGridList.Cells[10,i]:=Form_peach.StringGridList.Cells[3,i]+'/'+Form_peach.StringGridList.Cells[10,i];
         Form_Peach.ListView1.Items[i-1].SubItems[8]:=Form_Peach.StringGridList.Cells[10,i];
         end;
   Form_peach.Caption:=txt_6_6_pdupfind+' '+s+'...';
   dup:=checkduplicates;
   exit_busy_status;
   Form_peach.Caption:=s;
   //update_listview;
   if dup=0 then pMessageInfoOK(inttostr(dup)+' '+txt_6_6_pdupfound)
   else pMessageInfoOK(inttostr(dup)+' '+txt_6_6_pdupfound+'; '+txt_4_1_duplicateshint);
   end;
end;

//find duplicate files with full or quick approximate function
procedure findduplicate(mode:ansistring);
begin
if qdup=1 then quickdeduplicate(mode)
else fulldeduplicate(mode);
end;

//procedure to analyze content of directories
procedure analyzefolders(mode:ansistring);
var
   i,t,rc,nsel:integer;
   nfiles,ndirs,ctsize:qword;
   inidir,s,strsel:ansistring;
begin
if Form_peach.StringGridList.RowCount<2 then exit;
if Form_peach.StringGridList.Row=0 then exit;
if Form_peach.StringGridList.Cells[1,1]='' then exit;
{$IFDEF MSWINDOWS}if Form_peach.EditOpenIn.Text=txt_mypc then exit;{$ENDIF}
if mode='selected' then if checklisttotsel(nsel,strsel)<>0 then exit;
if browsertype<>0 then
   begin
   settpreset(1);
   if mode='selected' then mode:='displayed';//selection is lost changing to list
   end;
rc:=Form_peach.StringGridList.Rowcount;
s:=Form_peach.Caption;
inidir:=Form_peach.EditOpenIn.Caption;
t:=1;
if Form_peach.visible=true then
   begin
   enter_busy_status;
   for i:=1 to rc-1 do
      if (Form_peach.StringGridList.Cells[2,i]=txt_list_isfolder) then
         begin
         if mode='selected' then
            if Form_peach.StringGridList.Cells[15,i]='0' then
               begin
               Form_peach.StringGridList.Cells[10,i]:='';
               continue;
               end;
         if mode='selected' then Form_peach.Caption:=txt_7_0_af+', ('+inttostr(t+1)+'/'+inttostr(nsel)+') '+Form_peach.StringGridList.Cells[1,i]+'...'
         else Form_peach.Caption:=txt_7_0_af+', ('+inttostr(i)+'/'+inttostr(rc)+') '+Form_peach.StringGridList.Cells[1,i]+'...';
         nfiles:=0;
         ndirs:=0;
         ctsize:=0;
         rcountsize(Form_peach.StringGridList.Cells[11,i]+directoryseparator,'*',faAnyFile,true,nfiles,ndirs,ctsize);
         Form_peach.StringGridList.Cells[10,i]:=inttostr(ndirs-1)+' '+txt_dirs+' '+inttostr(nfiles)+' '+txt_files+' '+nicenumber(inttostr(ctsize),filesizebase);
         Form_Peach.ListView1.Items[i-1].SubItems[8]:=Form_Peach.StringGridList.Cells[10,i];
         if ndirs-1+nfiles=0 then //mark empty folders
            begin
            Form_Peach.StringGridList.Cells[4,i]:='E';
            Form_peach.StringGridList.Cells[14,i]:='E';
            Form_Peach.ListView1.Items[i-1].SubItems[2]:=Form_Peach.StringGridList.Cells[4,i];
            end;
         t:=t+1;
         end;
   exit_busy_status;
   Form_peach.Caption:=s;
   end;
end;

procedure autobookmarks;
{$IFNDEF MSWINDOWS}
var
   s:ansistring;
{$ENDIF}
begin
try
assignfile(book,(confpath+'bookmarks.txt'));
rewrite(book);
write_header(book);
{$IFDEF MSWINDOWS}
writeln(book,'0');
writeln(book,'Computer''s root');
writeln(book,'*');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
wingetuserprofile;
writeln(book,'0');
writeln(book,home_path);
writeln(book,'*');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
wingetdesk;
writeln(book,'0');
writeln(book,desktop_path);
writeln(book,'*');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
wingetdownloads;
if usr_downloads<>'' then
   begin
   writeln(book,'0');
   writeln(book,usr_downloads);
   writeln(book,'*');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   end;
if directoryexists(home_path+'Dropbox') then
   begin
   writeln(book,'0');
   writeln(book,home_path+'Dropbox\');
   writeln(book,'*');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   end;
if directoryexists(usr_documents+'My Box Files') then
   begin
   writeln(book,'0');
   writeln(book,usr_documents+'My Box Files\');
   writeln(book,'*');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   end;
if directoryexists(home_path+'Google Drive') then
   begin
   writeln(book,'0');
   writeln(book,home_path+'Google Drive\');
   writeln(book,'*');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   end;
if directoryexists(home_path+'OneDrive') then
   begin
   writeln(book,'0');
   writeln(book,home_path+'OneDrive\');
   writeln(book,'*');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   end;
if directoryexists(home_path+'Workspaces') then
   begin
   writeln(book,'0');
   writeln(book,home_path+'Workspaces\');
   writeln(book,'*');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   end;
if directoryexists(home_path+'YandexDisk') then
   begin
   writeln(book,'0');
   writeln(book,home_path+'YandexDisk\');
   writeln(book,'*');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   end;
{$ELSE}
get_home_path(s);
writeln(book,'0');
writeln(book,s);
writeln(book,'*');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
get_desktop_path(s);
writeln(book,'0');
writeln(book,s);
writeln(book,'*');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
writeln(book,'');
if usr_downloads<>'' then
   begin
   writeln(book,'0');
   writeln(book,usr_downloads);
   writeln(book,'*');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   writeln(book,'');
   end;
{$ENDIF}
CloseFile(book);
load_bookmarks;
except
end;
end;

function extractbookmarkname(s:ansistring):ansistring;
var s1:ansistring;
begin
s1:=s;
if translatespecialfolders(s1)=false then
   begin
   if length(s1)>1 then
      if s1[length(s1)]=directoryseparator then setlength(s1,length(s1)-1);
   if extractfilename(s1)<>'' then s1:=extractfilename(s1);
   end;
result:=s1;
end;

procedure load_bookmarks;
var
   s:ansistring;
   rc,i:integer;
begin
try
assignfile(book,(confpath+'bookmarks.txt'));
filemode:=0;
reset(book);
read_header(book);
if eof(book)=false then
   repeat
   readln(book,s);
   if s=' ' then break;
   rc:=Form_peach.StringGridBookmarks.Rowcount+1;
   Form_peach.StringGridBookmarks.RowCount:=rc;
   try
   i:=strtoint(s);
   case i of
      0: s:=txt_list_browsing;
      1: s:=txt_list_flat;
      2: s:=txt_list_found;
      else s:=txt_list_browsing;
      end;
   except
   //consider s saved as text like in older version of bookmarks
   end;
   Form_peach.StringGridBookmarks.Cells[1,rc-1]:=s;
   readln(book,s);
   Form_peach.StringGridBookmarks.Cells[2,rc-1]:=s;
   Form_peach.StringGridBookmarks.Cells[3,rc-1]:=extractbookmarkname(s);
   readln(book,s);
   Form_peach.StringGridBookmarks.Cells[4,rc-1]:=s;
   readln(book,s);
   Form_peach.StringGridBookmarks.Cells[5,rc-1]:=s;
   readln(book,s);
   Form_peach.StringGridBookmarks.Cells[6,rc-1]:=s;
   if savehistory=1 then
      begin
      readln(book,s);
      if s='' then s:='0';
      Form_peach.StringGridBookmarks.Cells[7,rc-1]:=s;
      readln(book,s);
      Form_peach.StringGridBookmarks.Cells[8,rc-1]:=s;
      readln(book,s);
      if s='' then s:=FormatDateTime('yyyy-mm-dd hh:mm:ss',now);
      Form_peach.StringGridBookmarks.Cells[9,rc-1]:=s;
      Form_peach.StringGridBookmarks.Cells[10,rc-1]:=inttostr(length(Form_peach.StringGridBookmarks.Cells[7,rc-1]))+Form_peach.StringGridBookmarks.Cells[7,rc-1];
      end
   else
      begin
      readln(book,s);
      Form_peach.StringGridBookmarks.Cells[7,rc-1]:='';
      readln(book,s);
      Form_peach.StringGridBookmarks.Cells[8,rc-1]:='';
      readln(book,s);
      Form_peach.StringGridBookmarks.Cells[9,rc-1]:='';
      Form_peach.StringGridBookmarks.Cells[10,rc-1]:='';
      end;
   Form_peach.StringGridBookmarks.Cells[11,rc-1]:='0';
   until eof(book);
Form_peach.StringGridBookmarks.AutosizeColumns;
Form_peach.StringGridBookmarks.ColWidths[10]:=0;
Form_peach.StringGridBookmarks.ColWidths[11]:=0;
Form_peach.StringGridBookmarks.ColWidths[0]:=rowsize;
if Form_peach.StringGridBookmarks.Rowcount>1 then
   Form_peach.StringGridBookmarks.Cells[11,1]:='1';
CloseFile(book);
if Form_peach.StringGridBookmarks.Rowcount<=1 then
   if s=' ' then
   else
      autobookmarks;
except
   try
   CloseFile(book);
   except
   end;
   autobookmarks;
end;
end;

procedure load_custedit;
var
   s:ansistring;
begin
if fileexists(confpath+'custedit.txt')=false then
   begin
   reset_custedit;
   exit;
   end;
try
assignfile(cedit,(confpath+'custedit.txt'));
filemode:=0;
reset(cedit);
read_header(cedit);
readln(cedit,s); if s<>'[custom editors/players, override system''s file associations, 4.2+]' then
   begin
   reset_custedit; //reset to defaults if custedit is not found (don't reset if it is empty)
   try
   CloseFile(cedit);
   except
   end;
   exit;
   end;
with form_peach do
begin
readln(cedit,s); StringGridCustedit.Cells[1,1]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,2]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,3]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,4]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,5]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,6]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,7]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,8]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,9]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,10]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,11]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,12]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,13]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,14]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,15]:=s;
readln(cedit,s); StringGridCustedit.Cells[1,16]:=s;
readln(cedit,s); custedit1:=s;
readln(cedit,s); custedit2:=s;
readln(cedit,s); custedit3:=s;
readln(cedit,s); custedit4:=s;
readln(cedit,s); custedit5:=s;
readln(cedit,s); custedit6:=s;
readln(cedit,s); custedit7:=s;
readln(cedit,s); custedit8:=s;
readln(cedit,s); custedit9:=s;
readln(cedit,s); custedit10:=s;
readln(cedit,s); custedit11:=s;
readln(cedit,s); custedit12:=s;
readln(cedit,s); custedit13:=s;
readln(cedit,s); custedit14:=s;
readln(cedit,s); custedit15:=s;
readln(cedit,s); custedit16:=s;
readln(cedit,s); StringGridCustedit1.Cells[1,1]:=s;
readln(cedit,s); StringGridCustedit1.Cells[1,2]:=s;
readln(cedit,s); StringGridCustedit1.Cells[1,3]:=s;
readln(cedit,s); StringGridCustedit1.Cells[1,4]:=s;
readln(cedit,s); StringGridCustedit1.Cells[1,5]:=s;
readln(cedit,s); StringGridCustedit1.Cells[1,6]:=s;
readln(cedit,s); StringGridCustedit1.Cells[1,7]:=s;
readln(cedit,s); StringGridCustedit1.Cells[1,8]:=s;
readln(cedit,s); advedit1before:=s;
readln(cedit,s); advedit2before:=s;
readln(cedit,s); advedit3before:=s;
readln(cedit,s); advedit4before:=s;
readln(cedit,s); advedit5before:=s;
readln(cedit,s); advedit6before:=s;
readln(cedit,s); advedit7before:=s;
readln(cedit,s); advedit8before:=s;
readln(cedit,s); advedit1after:=s;
readln(cedit,s); advedit2after:=s;
readln(cedit,s); advedit3after:=s;
readln(cedit,s); advedit4after:=s;
readln(cedit,s); advedit5after:=s;
readln(cedit,s); advedit6after:=s;
readln(cedit,s); advedit7after:=s;
readln(cedit,s); advedit8after:=s;
readln(cedit,s); advedit1alt:=s;
readln(cedit,s); advedit2alt:=s;
readln(cedit,s); advedit3alt:=s;
readln(cedit,s); advedit4alt:=s;
readln(cedit,s); advedit5alt:=s;
readln(cedit,s); advedit6alt:=s;
readln(cedit,s); advedit7alt:=s;
readln(cedit,s); advedit8alt:=s;
end;
set_custedit_totable;
set_custedit_menus;
CloseFile(cedit);
except
   reset_custedit; //reset to defaults if custedit is not found (don't reset if it is empty)
   try
   CloseFile(cedit);
   except
   end;
end;
end;

procedure save_conf;
{
configuration is saved each time the application closed, or launches a new instance, or leaving settings interface
it is not saved launching pealauncher because relevant options are modified in setting interfaces
}
begin
if stayopen=false then try closefile(conf); except end;
   try
      assignfile(conf,confpath+'conf.txt');
      rewrite(conf);
      write_header(conf);
      if theme_path<>'' then writeln(conf,theme_path)
      else writeln(conf,'');
      writeconf_colors;
      writeconf_defaults;
      CloseFile(conf);
   except
      try
         CloseFile(conf);
      except
      end;
   end;
end;

procedure theme_failure;
begin
   load_default_theme;
   graphicsfolder:=graphicsfolderd;
   opacity:=opacityd;
   color1:=color1d;
   color2:=color2d;
   color3:=color3d;
   color4:=color4d;
   color5:=color5d;
   pspacing:=pspacingd;
   pzooming:=pzoomingd;
   ensmall:=ensmalld;
   usealtcolor:=usealtcolord;
   highlighttabs:=highlighttabsd;
   accenttoolbar:=accenttoolbard;
   toolcentered:=toolcenteredd;
   altaddressstyle:=altaddressstyled;
   solidaddressstyle:=solidaddressstyled;
   alttabstyle:=alttabstyled;
   temperature:=temperatured;
   imgloaded:=false;
   apply_theme;
   try
      CloseFile(conf);
   except
   end;
end;

function checkstopsequencefile:boolean;
begin
result:=fileexists(fget_usrtmp_path+STR_STOPALL);
end;

procedure clearstopsequencefile;
begin
if fileexists(fget_usrtmp_path+STR_STOPALL) then
try
udeletefile (fget_usrtmp_path+STR_STOPALL);
except
sleep(500);
udeletefile (fget_usrtmp_path+STR_STOPALL);
end;
end;

procedure load_conf;
var
  seqstep,s:ansistring;

procedure conf_volatile; //working configuration with embedded values
begin
default_defaults;
load_default_theme;
graphicsfolder:=graphicsfolderd;
opacity:=opacityd;
color1:=color1d;
color2:=color2d;
color3:=color3d;
color4:=color4d;
color5:=color5d;
pspacing:=pspacingd;
pzooming:=pzoomingd;
ensmall:=ensmalld;
usealtcolor:=usealtcolord;
highlighttabs:=highlighttabsd;
accenttoolbar:=accenttoolbard;
toolcentered:=toolcenteredd;
altaddressstyle:=altaddressstyled;
solidaddressstyle:=solidaddressstyled;
alttabstyle:=alttabstyled;
temperature:=temperatured;
//imgloaded:=false;
//apply_theme;
texts('volatile');
updateconf;
set_listview_col;
Form_peach.LabelConf.Caption:='';
indir:={$IFDEF MSWINDOWS}txt_mypc;{$ELSE}'/';{$ENDIF}
end;

procedure writeerror_file;
begin
try
assignfile(conf,GetTempDir+'peazip-error.txt');
rewrite(conf);
writeln(conf,seqstep);
//1 error in altconf 2 conf unusable 2a conf unreadable 2b conf cannot be re-pmccreated from scratch
CloseFile(conf);
except
end;
end;

function writedconf_file:integer;
begin
result:=-1;
assignfile(conf,confpath+'conf.txt');
rewrite(conf);
write_header(conf);
writeln(conf,theme_path);
writeconf_default_colors;
lang_file:='default.txt'; //set default language
writeconf_defaults;
CloseFile(conf);
result:=0;
end;

function readconf_file:integer;
var
   s:ansistring;
begin
result:=-1;
try
assignfile(conf,confpath+'conf.txt');
filemode:=0;
reset(conf);
read_header(conf);
readln(conf,theme_path);
readconf_colors;
readln(conf,s);
readln(conf,lang_file);
texts(lang_file);
readconf_defaults;
CloseFile(conf);
except
df:=18;
pf:=15;//reset default format / previous format in case of configuration error, to be enabled when new formats are introduced
CloseFile(conf);
end;
result:=0;
end;

function conf_failure:integer;
begin
result:=-1;
seqstep:='2b';
sleep(500);
try
   try CloseFile(conf); except end;
   conf_volatile;
   if writedconf_file<>0 then exit;
   result:=readconf_file;
except
   result:=-1;
   try CloseFile(conf); except end;
end;
end;

function conf_checktype: integer;
var
   s:ansistring;
begin
result:=-1;
//Installable packages can create binpath and sharepath as links in (peazip)/res
//so actual locations can be delegated to distro-specific installers
//This mechanism can also be used for confpath on unsupprted systems, non compliant
//neither with Windows nor with Open Desktop standard
{$IFDEF DARWIN}
binpath:=executable_path+'bin'+directoryseparator;//binaries, architecture dependant
{$ELSE}
binpath:=resource_path+'bin'+directoryseparator;//binaries, architecture dependant
{$ENDIF}
sharepath:=resource_path+'share'+directoryseparator;//non binaries resources, non-architecture dependant
if FileExists(resource_path+'portable') then //if file exists, assume portable version
   begin
   confpath:=resource_path+'conf'+directoryseparator; //configuration (portable)
   end
else
   begin
   {$IFDEF MSWINDOWS}
   if wingetappdata(confpath)<>0 then confpath:=(GetEnvironmentVariable('APPDATA'))+'\PeaZip\'; //if wingetappdata fails use env variables
   {$ELSE}
   s:=GetEnvironmentVariable('XDG_CONFIG_HOME');
   if s<>'' then confpath:=s+'/peazip/'
   else
      begin
      get_home_path(s);
      confpath:=s+'/.config/peazip/';
      end;
   {$ENDIF}
   if not(directoryexists(confpath)) then forcedirectories(confpath);
   confpath:=ExpandFileName(confpath);
   if confpath<>'' then
      if confpath[length(confpath)]<>directoryseparator then confpath:=confpath+directoryseparator;
   if not(directoryexists(confpath)) then confpath:=resource_path+'conf'+directoryseparator; //if alternative configuration directory does not exist or is not accessible, use res path
   end;
if HBINPATH<>'' then binpath:=HBINPATH;
if HCONFPATH<>'' then confpath:=HCONFPATH;
if HSHAREPATH<>'' then sharepath:=HSHAREPATH;
result:=0;
end;

begin
//0) initialize with default embedded values
conf_volatile;
//1) check if configuration is portable or installable
seqstep:='1';
if conf_checktype<>0 then
   begin
   sleep(500);
   try CloseFile(aconf); except end;
   if conf_checktype<>0 then
      begin
      conf_volatile;
      writeerror_file;
      exit;
      end;
   end;
//parts needing conf type/path being initialized
if (paramstr(1)='-peazipreset') or (paramstr(1)='-peaziptotalreset') then //eliminate issues that may not allow even to read configuration file
   begin
   assignfile(conf,GetTempDir+'peazip-reset.txt');
   rewrite(conf);
   writeln(conf,' ');
   CloseFile(conf);
   clearstopsequencefile;
   end;
persistent_source:=confpath+'rnd';
//2 read actual configuration
seqstep:='2';
try readconf_file; except seqstep:='2a'; checkver:=''; end;
if checkver<>'PeaZip' then //conf error or not loaded
   begin
   if fileexists(GetTempDir+'peazip-reset.txt') then udeletefile(GetTempDir+'peazip-reset.txt')
   else
      begin
      try CopyFile(confpath+'conf-lastgood.txt',confpath+'conf.txt',[cffOverwriteFile]); except end; //try last good known conf
      try readconf_file; except checkver:=''; end;
      end;
   if checkver<>'PeaZip' then //try (twice) to write a default configuration and load it
      if conf_failure<>0 then
         if conf_failure<>0 then
            begin
            conf_volatile;
            writeerror_file;
            exit;
            end;
   end
else
   begin
   try CopyFile(confpath+'conf.txt',confpath+'conf-lastgood.txt',[cffOverwriteFile]); except end;
   if fileexists(GetTempDir+'peazip-reset.txt') then udeletefile(GetTempDir+'peazip-reset.txt');
   end;
//load theme
s:=extractfilepath(theme_path);
if s<>'' then setlength(s,length(s)-1);
theme_name:=extractfilename(s);
if theme_name<>'main-embedded' then
   try
   imgloaded:=false;
   load_theme;
   check_theme_failure;
   apply_theme;
   except
   theme_failure;
   apply_theme;
   end;
//check theming and configuration values, apply if correct
check_defaults_failure;
updateconf;
Form_peach.LabelConf.Caption:=confpath;
end;

procedure set_multi(s:ansistring); //sets multithreading option for 7za
begin
if s='on' then //allow multithread selection for Compression (LZMA/2 and BZip2), may be replaced by code more oriented toward processors number
   begin
   Form_peach.ComboBoxArchive8.Enabled:=true;
   Form_peach.ComboBoxArchive8.ItemIndex:=multi_option;
   end;
if s='off' then //disallow multithread selection since Compression algorithms used are not supported
   begin
   Form_peach.ComboBoxArchive8.Enabled:=false;
   //Form_peach.ComboBoxArchive8.ItemIndex:=0;
   end;
end;

procedure set_values(archive_type,compression_method,compression_level:ansistring);
begin
if archive_type=prev_type then
   if compression_method=prev_method then
     if compression_level=prev_level then exit;
settingvalues:=true;
prev_type:=archive_type;
prev_method:=compression_method;
prev_level:=compression_level;
Form_peach.ComboBoxArchiveSolid.Enabled:=false;
Form_peach.ComboBoxArchiveSolid.ItemIndex:=0;
Form_peach.Subtitle7zaopt2.Visible:=false;
Form_peach.CheckBoxMQS.Enabled:=false;
if archive_type='7z' then
   begin
   Form_peach.CheckBoxMQS.Enabled:=true;
   Form_peach.ComboBoxArchiveSolid.Enabled:=true;
   Form_peach.ComboBoxArchive3.Clear;
   Form_peach.ComboBoxArchive3.DropDownCount:=15;
   Form_peach.ComboBoxArchive3.Items.Append('LZMA');
   Form_peach.ComboBoxArchive3.Items.Append('LZMA2');
   Form_peach.ComboBoxArchive3.Items.Append('PPMd');
   Form_peach.ComboBoxArchive3.Items.Append('BZip2');
   Form_peach.ComboBoxArchive3.Items.Append('Brotli');
   Form_peach.ComboBoxArchive3.Items.Append('FLZMA2');
   Form_peach.ComboBoxArchive3.Items.Append('Lizard_fastLZ4');
   Form_peach.ComboBoxArchive3.Items.Append('Lizard_LIZv1');
   Form_peach.ComboBoxArchive3.Items.Append('Lizard_fastLZ4+Huffman');
   Form_peach.ComboBoxArchive3.Items.Append('Lizard_LIZv1+Huffman');
   Form_peach.ComboBoxArchive3.Items.Append('LZ4');
   Form_peach.ComboBoxArchive3.Items.Append('LZ5');
   Form_peach.ComboBoxArchive3.Items.Append('Zstd');
   Form_peach.ComboBoxArchive3.Items.Append('Deflate');
   Form_peach.ComboBoxArchive3.Items.Append('Deflate64');
   Form_peach.ComboBoxArchive4.Clear;
   Form_peach.ComboBoxArchive4.DropDownCount:=6;
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_store);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fastest);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fast);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_normal);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_maximum);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_ultra);
   Form_peach.Label7za18.Visible:=true;
   Form_peach.Subtitle7zaopt2.Visible:=true;
   Form_peach.Combobox7zalgo.Visible:=true;
   Form_peach.Combobox7zalgo.Clear;
   Form_peach.Combobox7zalgo.DropDownCount:=1;
   Form_peach.Combobox7zalgo.Items.Append('AES256');
   Form_peach.Combobox7zalgo.ItemIndex:=0;
   if compression_level=txt_level_store then
      begin
      set_multi('off');
      Form_peach.ComboBoxArchive4.ItemIndex:=0;
      compression_method:='';
      Form_peach.ComboBoxArchive3.Clear;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=false;
      Form_peach.ComboBoxArchive5.Enabled:=false;
      Form_peach.ComboBoxArchive6.Enabled:=false;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      Form_peach.ComboBoxArchiveSolid.Enabled:=false;
      end;
   if compression_method='LZMA' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=0;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=25;
      Form_peach.ComboBoxArchive5.Items.Append('256 KB');
      Form_peach.ComboBoxArchive5.Items.Append('1 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4 MB');
      Form_peach.ComboBoxArchive5.Items.Append('6 MB');
      Form_peach.ComboBoxArchive5.Items.Append('8 MB');
      Form_peach.ComboBoxArchive5.Items.Append('12 MB');
      Form_peach.ComboBoxArchive5.Items.Append('16 MB');
      Form_peach.ComboBoxArchive5.Items.Append('24 MB');
      Form_peach.ComboBoxArchive5.Items.Append('32 MB');
      Form_peach.ComboBoxArchive5.Items.Append('48 MB');
      Form_peach.ComboBoxArchive5.Items.Append('64 MB');
      Form_peach.ComboBoxArchive5.Items.Append('96 MB');
      Form_peach.ComboBoxArchive5.Items.Append('128 MB');
      Form_peach.ComboBoxArchive5.Items.Append('192 MB');
      Form_peach.ComboBoxArchive5.Items.Append('256 MB');
      Form_peach.ComboBoxArchive5.Items.Append('384 MB');
      Form_peach.ComboBoxArchive5.Items.Append('512 MB');
      Form_peach.ComboBoxArchive5.Items.Append('768 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1024 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1536 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2048 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3072 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4096 MB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=12;
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchive6.Items.Append('24');
      Form_peach.ComboBoxArchive6.Items.Append('32');
      Form_peach.ComboBoxArchive6.Items.Append('48');
      Form_peach.ComboBoxArchive6.Items.Append('64');
      Form_peach.ComboBoxArchive6.Items.Append('96');
      Form_peach.ComboBoxArchive6.Items.Append('128');
      Form_peach.ComboBoxArchive6.Items.Append('192');
      Form_peach.ComboBoxArchive6.Items.Append('256');
      Form_peach.ComboBoxArchive6.Items.Append('273');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=6;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=4;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=10;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=12;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=10;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=12;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      end;
   if compression_method='LZMA2' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=1;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=25;
      Form_peach.ComboBoxArchive5.Items.Append('256 KB');
      Form_peach.ComboBoxArchive5.Items.Append('1 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4 MB');
      Form_peach.ComboBoxArchive5.Items.Append('6 MB');
      Form_peach.ComboBoxArchive5.Items.Append('8 MB');
      Form_peach.ComboBoxArchive5.Items.Append('12 MB');
      Form_peach.ComboBoxArchive5.Items.Append('16 MB');
      Form_peach.ComboBoxArchive5.Items.Append('24 MB');
      Form_peach.ComboBoxArchive5.Items.Append('32 MB');
      Form_peach.ComboBoxArchive5.Items.Append('48 MB');
      Form_peach.ComboBoxArchive5.Items.Append('64 MB');
      Form_peach.ComboBoxArchive5.Items.Append('96 MB');
      Form_peach.ComboBoxArchive5.Items.Append('128 MB');
      Form_peach.ComboBoxArchive5.Items.Append('192 MB');
      Form_peach.ComboBoxArchive5.Items.Append('256 MB');
      Form_peach.ComboBoxArchive5.Items.Append('384 MB');
      Form_peach.ComboBoxArchive5.Items.Append('512 MB');
      Form_peach.ComboBoxArchive5.Items.Append('768 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1024 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1536 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2048 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3072 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4096 MB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=12;
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchive6.Items.Append('24');
      Form_peach.ComboBoxArchive6.Items.Append('32');
      Form_peach.ComboBoxArchive6.Items.Append('48');
      Form_peach.ComboBoxArchive6.Items.Append('64');
      Form_peach.ComboBoxArchive6.Items.Append('96');
      Form_peach.ComboBoxArchive6.Items.Append('128');
      Form_peach.ComboBoxArchive6.Items.Append('192');
      Form_peach.ComboBoxArchive6.Items.Append('256');
      Form_peach.ComboBoxArchive6.Items.Append('273');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=7;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=4;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=11;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=10;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=14;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=12;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=15;
         end;
      end;
   if compression_method='PPMd' then
      begin
      set_multi('off');
      Form_peach.ComboBoxArchive3.ItemIndex:=2;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=21;
      Form_peach.ComboBoxArchive5.Items.Append('1 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4 MB');
      Form_peach.ComboBoxArchive5.Items.Append('6 MB');
      Form_peach.ComboBoxArchive5.Items.Append('8 MB');
      Form_peach.ComboBoxArchive5.Items.Append('12 MB');
      Form_peach.ComboBoxArchive5.Items.Append('16 MB');
      Form_peach.ComboBoxArchive5.Items.Append('24 MB');
      Form_peach.ComboBoxArchive5.Items.Append('32 MB');
      Form_peach.ComboBoxArchive5.Items.Append('48 MB');
      Form_peach.ComboBoxArchive5.Items.Append('64 MB');
      Form_peach.ComboBoxArchive5.Items.Append('96 MB');
      Form_peach.ComboBoxArchive5.Items.Append('128 MB');
      Form_peach.ComboBoxArchive5.Items.Append('192 MB');
      Form_peach.ComboBoxArchive5.Items.Append('256 MB');
      Form_peach.ComboBoxArchive5.Items.Append('384 MB');
      Form_peach.ComboBoxArchive5.Items.Append('512 MB');
      Form_peach.ComboBoxArchive5.Items.Append('768 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1024 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1536 MB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=15;
      Form_peach.ComboBoxArchive6.Items.Append('2');
      Form_peach.ComboBoxArchive6.Items.Append('3');
      Form_peach.ComboBoxArchive6.Items.Append('4');
      Form_peach.ComboBoxArchive6.Items.Append('5');
      Form_peach.ComboBoxArchive6.Items.Append('6');
      Form_peach.ComboBoxArchive6.Items.Append('7');
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('10');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('14');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchive6.Items.Append('20');
      Form_peach.ComboBoxArchive6.Items.Append('24');
      Form_peach.ComboBoxArchive6.Items.Append('28');
      Form_peach.ComboBoxArchive6.Items.Append('32');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=2;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=8;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=3;
         Form_peach.ComboBoxArchive6.ItemIndex:=2;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=10;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=7;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=12;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=11;
         Form_peach.ComboBoxArchive6.ItemIndex:=10;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=15;
         Form_peach.ComboBoxArchive6.ItemIndex:=14;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      end;
   if compression_method='BZip2' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=3;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=9;
      Form_peach.ComboBoxArchive5.Items.Append('100 KB');
      Form_peach.ComboBoxArchive5.Items.Append('200 KB');
      Form_peach.ComboBoxArchive5.Items.Append('300 KB');
      Form_peach.ComboBoxArchive5.Items.Append('400 KB');
      Form_peach.ComboBoxArchive5.Items.Append('500 KB');
      Form_peach.ComboBoxArchive5.Items.Append('600 KB');
      Form_peach.ComboBoxArchive5.Items.Append('700 KB');
      Form_peach.ComboBoxArchive5.Items.Append('800 KB');
      Form_peach.ComboBoxArchive5.Items.Append('900 KB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchivePasses.DropDownCount:=10;
      Form_peach.ComboBoxArchivePasses.Items.Append('1');
      Form_peach.ComboBoxArchivePasses.Items.Append('2');
      Form_peach.ComboBoxArchivePasses.Items.Append('3');
      Form_peach.ComboBoxArchivePasses.Items.Append('4');
      Form_peach.ComboBoxArchivePasses.Items.Append('5');
      Form_peach.ComboBoxArchivePasses.Items.Append('6');
      Form_peach.ComboBoxArchivePasses.Items.Append('7');
      Form_peach.ComboBoxArchivePasses.Items.Append('8');
      Form_peach.ComboBoxArchivePasses.Items.Append('9');
      Form_peach.ComboBoxArchivePasses.Items.Append('10');
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=false;
      Form_peach.ComboBoxArchivePasses.Enabled:=true;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=4;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=4;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=6;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=7;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=1;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=7;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=6;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=7;
         end;
      end;
   end;
   if (compression_method='Brotli') or
      (compression_method='Lizard_fastLZ4') or
      (compression_method='Lizard_LIZv1') or
      (compression_method='Lizard_fastLZ4+Huffman') or
      (compression_method='Lizard_LIZv1+Huffman') or
      (compression_method='LZ4')  or
      (compression_method='LZ5') or
      (compression_method='Zstd')then
      begin
      set_multi('on');
      case compression_method of
         'Brotli': Form_peach.ComboBoxArchive3.ItemIndex:=4;
         'Lizard_fastLZ4': Form_peach.ComboBoxArchive3.ItemIndex:=6;
         'Lizard_LIZv1': Form_peach.ComboBoxArchive3.ItemIndex:=7;
         'Lizard_fastLZ4+Huffman': Form_peach.ComboBoxArchive3.ItemIndex:=8;
         'Lizard_LIZv1+Huffman': Form_peach.ComboBoxArchive3.ItemIndex:=9;
         'LZ4': Form_peach.ComboBoxArchive3.ItemIndex:=10;
         'LZ5': Form_peach.ComboBoxArchive3.ItemIndex:=11;
         'Zstd': Form_peach.ComboBoxArchive3.ItemIndex:=12;
         end;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=0;
      Form_peach.ComboBoxArchive5.Enabled:=False;
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=0;
      Form_peach.ComboBoxArchive6.Enabled:=False;
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=0;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=4;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=8;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=12;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      end;
   if compression_method='FLZMA2' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=5;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=22;
      Form_peach.ComboBoxArchive5.Items.Append('64 KB');
      Form_peach.ComboBoxArchive5.Items.Append('1 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4 MB');
      Form_peach.ComboBoxArchive5.Items.Append('6 MB');
      Form_peach.ComboBoxArchive5.Items.Append('8 MB');
      Form_peach.ComboBoxArchive5.Items.Append('12 MB');
      Form_peach.ComboBoxArchive5.Items.Append('16 MB');
      Form_peach.ComboBoxArchive5.Items.Append('24 MB');
      Form_peach.ComboBoxArchive5.Items.Append('32 MB');
      Form_peach.ComboBoxArchive5.Items.Append('48 MB');
      Form_peach.ComboBoxArchive5.Items.Append('64 MB');
      Form_peach.ComboBoxArchive5.Items.Append('96 MB');
      Form_peach.ComboBoxArchive5.Items.Append('128 MB');
      Form_peach.ComboBoxArchive5.Items.Append('192 MB');
      Form_peach.ComboBoxArchive5.Items.Append('256 MB');
      Form_peach.ComboBoxArchive5.Items.Append('384 MB');
      Form_peach.ComboBoxArchive5.Items.Append('512 MB');
      Form_peach.ComboBoxArchive5.Items.Append('768 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1024 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1536 MB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=12;
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchive6.Items.Append('24');
      Form_peach.ComboBoxArchive6.Items.Append('32');
      Form_peach.ComboBoxArchive6.Items.Append('48');
      Form_peach.ComboBoxArchive6.Items.Append('64');
      Form_peach.ComboBoxArchive6.Items.Append('96');
      Form_peach.ComboBoxArchive6.Items.Append('128');
      Form_peach.ComboBoxArchive6.Items.Append('192');
      Form_peach.ComboBoxArchive6.Items.Append('256');
      Form_peach.ComboBoxArchive6.Items.Append('273');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=4;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=1;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=8;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=12;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=10;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=12;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      end;
if compression_method='Deflate' then
   begin
   set_multi('on');
   Form_peach.ComboBoxArchive3.ItemIndex:=13;
   Form_peach.ComboBoxArchive5.Clear;
   Form_peach.ComboBoxArchive5.DropDownCount:=1;
   Form_peach.ComboBoxArchive5.Items.Append('32 KB');
   Form_peach.ComboBoxArchive6.Clear;
   Form_peach.ComboBoxArchive6.DropDownCount:=12;
   Form_peach.ComboBoxArchive6.Items.Append('8');
   Form_peach.ComboBoxArchive6.Items.Append('12');
   Form_peach.ComboBoxArchive6.Items.Append('16');
   Form_peach.ComboBoxArchive6.Items.Append('24');
   Form_peach.ComboBoxArchive6.Items.Append('32');
   Form_peach.ComboBoxArchive6.Items.Append('48');
   Form_peach.ComboBoxArchive6.Items.Append('64');
   Form_peach.ComboBoxArchive6.Items.Append('96');
   Form_peach.ComboBoxArchive6.Items.Append('128');
   Form_peach.ComboBoxArchive6.Items.Append('192');
   Form_peach.ComboBoxArchive6.Items.Append('256');
   Form_peach.ComboBoxArchive6.Items.Append('258');
   Form_peach.ComboBoxArchivePasses.Clear;
   Form_peach.ComboBoxArchivePasses.DropDownCount:=15;
   Form_peach.ComboBoxArchivePasses.Items.Append('1');
   Form_peach.ComboBoxArchivePasses.Items.Append('2');
   Form_peach.ComboBoxArchivePasses.Items.Append('3');
   Form_peach.ComboBoxArchivePasses.Items.Append('4');
   Form_peach.ComboBoxArchivePasses.Items.Append('5');
   Form_peach.ComboBoxArchivePasses.Items.Append('6');
   Form_peach.ComboBoxArchivePasses.Items.Append('7');
   Form_peach.ComboBoxArchivePasses.Items.Append('8');
   Form_peach.ComboBoxArchivePasses.Items.Append('9');
   Form_peach.ComboBoxArchivePasses.Items.Append('10');
   Form_peach.ComboBoxArchivePasses.Items.Append('11');
   Form_peach.ComboBoxArchivePasses.Items.Append('12');
   Form_peach.ComboBoxArchivePasses.Items.Append('13');
   Form_peach.ComboBoxArchivePasses.Items.Append('14');
   Form_peach.ComboBoxArchivePasses.Items.Append('15');
   Form_peach.ComboBoxArchive3.Enabled:=true;
   Form_peach.ComboBoxArchive5.Enabled:=true;
   Form_peach.ComboBoxArchive6.Enabled:=true;
   Form_peach.ComboBoxArchivePasses.Enabled:=true;
   if compression_level=txt_level_fastest then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=1;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=4;//4;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=4;
      end;
   if compression_level=txt_level_fast then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=2;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=4;//4;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=8;
      end;
   if compression_level=txt_level_normal then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=3;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=4;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=12;
      end;
   if compression_level=txt_level_maximum then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=4;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=6;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=2;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
      end;
   if compression_level=txt_level_ultra then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=5;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=8;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=9;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
      end;
   end;
if compression_method='Deflate64' then
   begin
   set_multi('on');
   Form_peach.ComboBoxArchive3.ItemIndex:=14;
   Form_peach.ComboBoxArchive5.Clear;
   Form_peach.ComboBoxArchive5.DropDownCount:=1;
   Form_peach.ComboBoxArchive5.Items.Append('64 KB');
   Form_peach.ComboBoxArchive6.Clear;
   Form_peach.ComboBoxArchive6.DropDownCount:=12;
   Form_peach.ComboBoxArchive6.Items.Append('8');
   Form_peach.ComboBoxArchive6.Items.Append('12');
   Form_peach.ComboBoxArchive6.Items.Append('16');
   Form_peach.ComboBoxArchive6.Items.Append('24');
   Form_peach.ComboBoxArchive6.Items.Append('32');
   Form_peach.ComboBoxArchive6.Items.Append('48');
   Form_peach.ComboBoxArchive6.Items.Append('64');
   Form_peach.ComboBoxArchive6.Items.Append('96');
   Form_peach.ComboBoxArchive6.Items.Append('128');
   Form_peach.ComboBoxArchive6.Items.Append('192');
   Form_peach.ComboBoxArchive6.Items.Append('256');
   Form_peach.ComboBoxArchive6.Items.Append('257');
   Form_peach.ComboBoxArchivePasses.Clear;
   Form_peach.ComboBoxArchivePasses.DropDownCount:=15;
   Form_peach.ComboBoxArchivePasses.Items.Append('1');
   Form_peach.ComboBoxArchivePasses.Items.Append('2');
   Form_peach.ComboBoxArchivePasses.Items.Append('3');
   Form_peach.ComboBoxArchivePasses.Items.Append('4');
   Form_peach.ComboBoxArchivePasses.Items.Append('5');
   Form_peach.ComboBoxArchivePasses.Items.Append('6');
   Form_peach.ComboBoxArchivePasses.Items.Append('7');
   Form_peach.ComboBoxArchivePasses.Items.Append('8');
   Form_peach.ComboBoxArchivePasses.Items.Append('9');
   Form_peach.ComboBoxArchivePasses.Items.Append('10');
   Form_peach.ComboBoxArchivePasses.Items.Append('11');
   Form_peach.ComboBoxArchivePasses.Items.Append('12');
   Form_peach.ComboBoxArchivePasses.Items.Append('13');
   Form_peach.ComboBoxArchivePasses.Items.Append('14');
   Form_peach.ComboBoxArchivePasses.Items.Append('15');
   Form_peach.ComboBoxArchive3.Enabled:=true;
   Form_peach.ComboBoxArchive5.Enabled:=true;
   Form_peach.ComboBoxArchive6.Enabled:=true;
   Form_peach.ComboBoxArchivePasses.Enabled:=true;
   if compression_level=txt_level_fastest then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=1;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=4;//4;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=4;
      end;
   if compression_level=txt_level_fast then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=2;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=4;//4;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=8;
      end;
   if compression_level=txt_level_normal then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=3;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=4;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=12;
      end;
   if compression_level=txt_level_maximum then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=4;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=6;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=2;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
      end;
   if compression_level=txt_level_ultra then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=5;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=8;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=9;
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
      end;
   end;
if archive_type='xz' then
   begin
   Form_peach.ComboBoxArchiveSolid.Enabled:=true;
   Form_peach.ComboBoxArchive3.Clear;
   Form_peach.ComboBoxArchive3.DropDownCount:=1;
   Form_peach.ComboBoxArchive3.Items.Append('LZMA2');
   Form_peach.ComboBoxArchive3.ItemIndex:=0;
   Form_peach.ComboBoxArchive4.Clear;
   Form_peach.ComboBoxArchive4.DropDownCount:=5;
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fastest);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fast);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_normal);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_maximum);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_ultra);
   Form_peach.Label7za18.Visible:=true;
   Form_peach.Label7za18.Visible:=false;
   Form_peach.Combobox7zalgo.Visible:=false;
   if compression_method='LZMA2' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=1;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=25;
      Form_peach.ComboBoxArchive5.Items.Append('256 KB');
      Form_peach.ComboBoxArchive5.Items.Append('1 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4 MB');
      Form_peach.ComboBoxArchive5.Items.Append('6 MB');
      Form_peach.ComboBoxArchive5.Items.Append('8 MB');
      Form_peach.ComboBoxArchive5.Items.Append('12 MB');
      Form_peach.ComboBoxArchive5.Items.Append('16 MB');
      Form_peach.ComboBoxArchive5.Items.Append('24 MB');
      Form_peach.ComboBoxArchive5.Items.Append('32 MB');
      Form_peach.ComboBoxArchive5.Items.Append('48 MB');
      Form_peach.ComboBoxArchive5.Items.Append('64 MB');
      Form_peach.ComboBoxArchive5.Items.Append('96 MB');
      Form_peach.ComboBoxArchive5.Items.Append('128 MB');
      Form_peach.ComboBoxArchive5.Items.Append('192 MB');
      Form_peach.ComboBoxArchive5.Items.Append('256 MB');
      Form_peach.ComboBoxArchive5.Items.Append('384 MB');
      Form_peach.ComboBoxArchive5.Items.Append('512 MB');
      Form_peach.ComboBoxArchive5.Items.Append('768 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1024 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1536 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2048 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3072 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4096 MB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=12;
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchive6.Items.Append('24');
      Form_peach.ComboBoxArchive6.Items.Append('32');
      Form_peach.ComboBoxArchive6.Items.Append('48');
      Form_peach.ComboBoxArchive6.Items.Append('64');
      Form_peach.ComboBoxArchive6.Items.Append('96');
      Form_peach.ComboBoxArchive6.Items.Append('128');
      Form_peach.ComboBoxArchive6.Items.Append('192');
      Form_peach.ComboBoxArchive6.Items.Append('256');
      Form_peach.ComboBoxArchive6.Items.Append('273');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=0;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=7;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=4;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=11;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=10;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=14;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=12;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=15;
         end;
      end;
   end;
if archive_type='wim' then
   begin
   set_multi('off');
   Form_peach.ComboBoxArchive3.Clear;
   Form_peach.ComboBoxArchive3.DropDownCount:=1;
   Form_peach.ComboBoxArchive3.Items.Append('');
   Form_peach.ComboBoxArchive4.Clear;
   Form_peach.ComboBoxArchive4.DropDownCount:=1;
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_store);
   Form_peach.ComboBoxArchive5.Clear;
   Form_peach.ComboBoxArchive5.DropDownCount:=1;
   Form_peach.ComboBoxArchive5.Items.Append('');
   Form_peach.ComboBoxArchive6.Clear;
   Form_peach.ComboBoxArchive6.DropDownCount:=1;
   Form_peach.ComboBoxArchive6.Items.Append('');
   Form_peach.ComboBoxArchivePasses.Clear;
   Form_peach.ComboBoxArchive3.ItemIndex:=0;
   Form_peach.ComboBoxArchive4.ItemIndex:=0;
   Form_peach.ComboBoxArchive5.ItemIndex:=0;
   Form_peach.ComboBoxArchive6.ItemIndex:=0;
   Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
   Form_peach.ComboBoxArchive3.Enabled:=false;
   Form_peach.ComboBoxArchive5.Enabled:=false;
   Form_peach.ComboBoxArchive6.Enabled:=false;
   Form_peach.Label7za18.Visible:=false;
   Form_peach.Combobox7zalgo.Visible:=false;
   Form_peach.ComboBoxArchivePasses.Enabled:=false;
   end;
if archive_type='tar' then
   begin
   set_multi('off');
   Form_peach.ComboBoxArchive3.Clear;
   Form_peach.ComboBoxArchive3.DropDownCount:=1;
   Form_peach.ComboBoxArchive3.Items.Append('');
   Form_peach.ComboBoxArchive4.Clear;
   Form_peach.ComboBoxArchive4.DropDownCount:=1;
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_store);
   Form_peach.ComboBoxArchive5.Clear;
   Form_peach.ComboBoxArchive5.DropDownCount:=1;
   Form_peach.ComboBoxArchive5.Items.Append('');
   Form_peach.ComboBoxArchive6.Clear;
   Form_peach.ComboBoxArchive6.DropDownCount:=1;
   Form_peach.ComboBoxArchive6.Items.Append('');
   Form_peach.ComboBoxArchivePasses.Clear;
   Form_peach.ComboBoxArchive3.ItemIndex:=0;
   Form_peach.ComboBoxArchive4.ItemIndex:=0;
   Form_peach.ComboBoxArchive5.ItemIndex:=0;
   Form_peach.ComboBoxArchive6.ItemIndex:=0;
   Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
   Form_peach.ComboBoxArchive3.Enabled:=false;
   Form_peach.ComboBoxArchive5.Enabled:=false;
   Form_peach.ComboBoxArchive6.Enabled:=false;
   Form_peach.Label7za18.Visible:=false;
   Form_peach.Combobox7zalgo.Visible:=false;
   Form_peach.ComboBoxArchivePasses.Enabled:=false;
   end;
if archive_type='zip' then
   begin
   Form_peach.ComboBoxArchive3.Clear;
   {$IFDEF MSWINDOWS}
   Form_peach.ComboBoxArchive3.DropDownCount:=6;
   {$ELSE}
   Form_peach.ComboBoxArchive3.DropDownCount:=7;
   {$ENDIF}
   Form_peach.ComboBoxArchive3.Items.Append('Deflate');
   Form_peach.ComboBoxArchive3.Items.Append('Deflate64');
   Form_peach.ComboBoxArchive3.Items.Append('BZip2');
   Form_peach.ComboBoxArchive3.Items.Append('LZMA');
   Form_peach.ComboBoxArchive3.Items.Append('PPMd');
   Form_peach.ComboBoxArchive3.Items.Append('XZ');
   {$IFNDEF MSWINDOWS}
   Form_peach.ComboBoxArchive3.Items.Append('Zstd');
   {$ENDIF}
   Form_peach.ComboBoxArchive4.Clear;
   Form_peach.ComboBoxArchive4.DropDownCount:=6;
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_store);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fastest);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fast);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_normal);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_maximum);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_ultra);
   Form_peach.Label7za18.Visible:=true;
   Form_peach.Subtitle7zaopt2.Visible:=true;
   Form_peach.Combobox7zalgo.Visible:=true;
   Form_peach.Combobox7zalgo.Clear;
   Form_peach.Combobox7zalgo.DropDownCount:=2;
   Form_peach.Combobox7zalgo.Items.Append('AES256');
   Form_peach.Combobox7zalgo.Items.Append(txt_zipcrypto_hint);
   Form_peach.Combobox7zalgo.ItemIndex:=algo_zipenc;
   if compression_level=txt_level_store then
      begin
      set_multi('off');
      Form_peach.ComboBoxArchive4.ItemIndex:=0;
      compression_method:='';
      Form_peach.ComboBoxArchive3.Clear;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=false;
      Form_peach.ComboBoxArchive5.Enabled:=false;
      Form_peach.ComboBoxArchive6.Enabled:=false;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      end;
   if compression_method='Deflate' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=0;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=1;
      Form_peach.ComboBoxArchive5.Items.Append('32 KB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=12;
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchive6.Items.Append('24');
      Form_peach.ComboBoxArchive6.Items.Append('32');
      Form_peach.ComboBoxArchive6.Items.Append('48');
      Form_peach.ComboBoxArchive6.Items.Append('64');
      Form_peach.ComboBoxArchive6.Items.Append('96');
      Form_peach.ComboBoxArchive6.Items.Append('128');
      Form_peach.ComboBoxArchive6.Items.Append('192');
      Form_peach.ComboBoxArchive6.Items.Append('256');
      Form_peach.ComboBoxArchive6.Items.Append('258');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchivePasses.DropDownCount:=15;
      Form_peach.ComboBoxArchivePasses.Items.Append('1');
      Form_peach.ComboBoxArchivePasses.Items.Append('2');
      Form_peach.ComboBoxArchivePasses.Items.Append('3');
      Form_peach.ComboBoxArchivePasses.Items.Append('4');
      Form_peach.ComboBoxArchivePasses.Items.Append('5');
      Form_peach.ComboBoxArchivePasses.Items.Append('6');
      Form_peach.ComboBoxArchivePasses.Items.Append('7');
      Form_peach.ComboBoxArchivePasses.Items.Append('8');
      Form_peach.ComboBoxArchivePasses.Items.Append('9');
      Form_peach.ComboBoxArchivePasses.Items.Append('10');
      Form_peach.ComboBoxArchivePasses.Items.Append('11');
      Form_peach.ComboBoxArchivePasses.Items.Append('12');
      Form_peach.ComboBoxArchivePasses.Items.Append('13');
      Form_peach.ComboBoxArchivePasses.Items.Append('14');
      Form_peach.ComboBoxArchivePasses.Items.Append('15');
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=true;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;//4;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;//4;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=2;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=8;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=9;
         end;
      end;
   if compression_method='Deflate64' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=1;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=1;
      Form_peach.ComboBoxArchive5.Items.Append('64 KB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=12;
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchive6.Items.Append('24');
      Form_peach.ComboBoxArchive6.Items.Append('32');
      Form_peach.ComboBoxArchive6.Items.Append('48');
      Form_peach.ComboBoxArchive6.Items.Append('64');
      Form_peach.ComboBoxArchive6.Items.Append('96');
      Form_peach.ComboBoxArchive6.Items.Append('128');
      Form_peach.ComboBoxArchive6.Items.Append('192');
      Form_peach.ComboBoxArchive6.Items.Append('256');
      Form_peach.ComboBoxArchive6.Items.Append('257');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchivePasses.DropDownCount:=15;
      Form_peach.ComboBoxArchivePasses.Items.Append('1');
      Form_peach.ComboBoxArchivePasses.Items.Append('2');
      Form_peach.ComboBoxArchivePasses.Items.Append('3');
      Form_peach.ComboBoxArchivePasses.Items.Append('4');
      Form_peach.ComboBoxArchivePasses.Items.Append('5');
      Form_peach.ComboBoxArchivePasses.Items.Append('6');
      Form_peach.ComboBoxArchivePasses.Items.Append('7');
      Form_peach.ComboBoxArchivePasses.Items.Append('8');
      Form_peach.ComboBoxArchivePasses.Items.Append('9');
      Form_peach.ComboBoxArchivePasses.Items.Append('10');
      Form_peach.ComboBoxArchivePasses.Items.Append('11');
      Form_peach.ComboBoxArchivePasses.Items.Append('12');
      Form_peach.ComboBoxArchivePasses.Items.Append('13');
      Form_peach.ComboBoxArchivePasses.Items.Append('14');
      Form_peach.ComboBoxArchivePasses.Items.Append('15');
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=true;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;//4;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;//4;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=2;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=8;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=9;
         end;
      end;
   if compression_method='BZip2' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=2;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=9;
      Form_peach.ComboBoxArchive5.Items.Append('100 KB');
      Form_peach.ComboBoxArchive5.Items.Append('200 KB');
      Form_peach.ComboBoxArchive5.Items.Append('300 KB');
      Form_peach.ComboBoxArchive5.Items.Append('400 KB');
      Form_peach.ComboBoxArchive5.Items.Append('500 KB');
      Form_peach.ComboBoxArchive5.Items.Append('600 KB');
      Form_peach.ComboBoxArchive5.Items.Append('700 KB');
      Form_peach.ComboBoxArchive5.Items.Append('800 KB');
      Form_peach.ComboBoxArchive5.Items.Append('900 KB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchivePasses.DropDownCount:=10;
      Form_peach.ComboBoxArchivePasses.Items.Append('1');
      Form_peach.ComboBoxArchivePasses.Items.Append('2');
      Form_peach.ComboBoxArchivePasses.Items.Append('3');
      Form_peach.ComboBoxArchivePasses.Items.Append('4');
      Form_peach.ComboBoxArchivePasses.Items.Append('5');
      Form_peach.ComboBoxArchivePasses.Items.Append('6');
      Form_peach.ComboBoxArchivePasses.Items.Append('7');
      Form_peach.ComboBoxArchivePasses.Items.Append('8');
      Form_peach.ComboBoxArchivePasses.Items.Append('9');
      Form_peach.ComboBoxArchivePasses.Items.Append('10');
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=false;
      Form_peach.ComboBoxArchivePasses.Enabled:=true;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=4;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=1;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=0;
         Form_peach.ComboBoxArchivePasses.ItemIndex:=6;
         end;
      end;
   if compression_method='LZMA' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=3;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=25;
      Form_peach.ComboBoxArchive5.Items.Append('256 KB');
      Form_peach.ComboBoxArchive5.Items.Append('1 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4 MB');
      Form_peach.ComboBoxArchive5.Items.Append('6 MB');
      Form_peach.ComboBoxArchive5.Items.Append('8 MB');
      Form_peach.ComboBoxArchive5.Items.Append('12 MB');
      Form_peach.ComboBoxArchive5.Items.Append('16 MB');
      Form_peach.ComboBoxArchive5.Items.Append('24 MB');
      Form_peach.ComboBoxArchive5.Items.Append('32 MB');
      Form_peach.ComboBoxArchive5.Items.Append('48 MB');
      Form_peach.ComboBoxArchive5.Items.Append('64 MB');
      Form_peach.ComboBoxArchive5.Items.Append('96 MB');
      Form_peach.ComboBoxArchive5.Items.Append('128 MB');
      Form_peach.ComboBoxArchive5.Items.Append('192 MB');
      Form_peach.ComboBoxArchive5.Items.Append('256 MB');
      Form_peach.ComboBoxArchive5.Items.Append('384 MB');
      Form_peach.ComboBoxArchive5.Items.Append('512 MB');
      Form_peach.ComboBoxArchive5.Items.Append('768 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1024 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1536 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2048 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3072 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4096 MB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=12;
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchive6.Items.Append('24');
      Form_peach.ComboBoxArchive6.Items.Append('32');
      Form_peach.ComboBoxArchive6.Items.Append('48');
      Form_peach.ComboBoxArchive6.Items.Append('64');
      Form_peach.ComboBoxArchive6.Items.Append('96');
      Form_peach.ComboBoxArchive6.Items.Append('128');
      Form_peach.ComboBoxArchive6.Items.Append('192');
      Form_peach.ComboBoxArchive6.Items.Append('256');
      Form_peach.ComboBoxArchive6.Items.Append('273');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=4;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=10;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=12;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         end;
      end;
   if compression_method='PPMd' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=4;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=9;
      Form_peach.ComboBoxArchive5.Items.Append('1 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4 MB');
      Form_peach.ComboBoxArchive5.Items.Append('8 MB');
      Form_peach.ComboBoxArchive5.Items.Append('16 MB');
      Form_peach.ComboBoxArchive5.Items.Append('32 MB');
      Form_peach.ComboBoxArchive5.Items.Append('64 MB');
      Form_peach.ComboBoxArchive5.Items.Append('128 MB');
      Form_peach.ComboBoxArchive5.Items.Append('256 MB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=15;
      Form_peach.ComboBoxArchive6.Items.Append('2');
      Form_peach.ComboBoxArchive6.Items.Append('3');
      Form_peach.ComboBoxArchive6.Items.Append('4');
      Form_peach.ComboBoxArchive6.Items.Append('5');
      Form_peach.ComboBoxArchive6.Items.Append('6');
      Form_peach.ComboBoxArchive6.Items.Append('7');
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('9');
      Form_peach.ComboBoxArchive6.Items.Append('10');
      Form_peach.ComboBoxArchive6.Items.Append('11');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('13');
      Form_peach.ComboBoxArchive6.Items.Append('14');
      Form_peach.ComboBoxArchive6.Items.Append('15');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=2;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=2;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=4;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=6;
         Form_peach.ComboBoxArchive6.ItemIndex:=8;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=7;
         Form_peach.ComboBoxArchive6.ItemIndex:=10;
         end;
      end;

   if compression_method='XZ' then
      begin
      set_multi('on');
      Form_peach.ComboBoxArchive3.ItemIndex:=5;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=25;
      Form_peach.ComboBoxArchive5.Items.Append('256 KB');
      Form_peach.ComboBoxArchive5.Items.Append('1 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4 MB');
      Form_peach.ComboBoxArchive5.Items.Append('6 MB');
      Form_peach.ComboBoxArchive5.Items.Append('8 MB');
      Form_peach.ComboBoxArchive5.Items.Append('12 MB');
      Form_peach.ComboBoxArchive5.Items.Append('16 MB');
      Form_peach.ComboBoxArchive5.Items.Append('24 MB');
      Form_peach.ComboBoxArchive5.Items.Append('32 MB');
      Form_peach.ComboBoxArchive5.Items.Append('48 MB');
      Form_peach.ComboBoxArchive5.Items.Append('64 MB');
      Form_peach.ComboBoxArchive5.Items.Append('96 MB');
      Form_peach.ComboBoxArchive5.Items.Append('128 MB');
      Form_peach.ComboBoxArchive5.Items.Append('192 MB');
      Form_peach.ComboBoxArchive5.Items.Append('256 MB');
      Form_peach.ComboBoxArchive5.Items.Append('384 MB');
      Form_peach.ComboBoxArchive5.Items.Append('512 MB');
      Form_peach.ComboBoxArchive5.Items.Append('768 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1024 MB');
      Form_peach.ComboBoxArchive5.Items.Append('1536 MB');
      Form_peach.ComboBoxArchive5.Items.Append('2048 MB');
      Form_peach.ComboBoxArchive5.Items.Append('3072 MB');
      Form_peach.ComboBoxArchive5.Items.Append('4096 MB');
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=12;
      Form_peach.ComboBoxArchive6.Items.Append('8');
      Form_peach.ComboBoxArchive6.Items.Append('12');
      Form_peach.ComboBoxArchive6.Items.Append('16');
      Form_peach.ComboBoxArchive6.Items.Append('24');
      Form_peach.ComboBoxArchive6.Items.Append('32');
      Form_peach.ComboBoxArchive6.Items.Append('48');
      Form_peach.ComboBoxArchive6.Items.Append('64');
      Form_peach.ComboBoxArchive6.Items.Append('96');
      Form_peach.ComboBoxArchive6.Items.Append('128');
      Form_peach.ComboBoxArchive6.Items.Append('192');
      Form_peach.ComboBoxArchive6.Items.Append('256');
      Form_peach.ComboBoxArchive6.Items.Append('273');
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchive5.Enabled:=true;
      Form_peach.ComboBoxArchive6.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchive5.ItemIndex:=0;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchive5.ItemIndex:=4;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchive5.ItemIndex:=8;
         Form_peach.ComboBoxArchive6.ItemIndex:=4;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchive5.ItemIndex:=10;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchive5.ItemIndex:=12;
         Form_peach.ComboBoxArchive6.ItemIndex:=6;
         end;
      end;
   {$IFNDEF MSWINDOWS}
   if (compression_method='Zstd') then
      begin
      set_multi('on');
      case compression_method of
         'Zstd': Form_peach.ComboBoxArchive3.ItemIndex:=6;
         end;
      Form_peach.ComboBoxArchive5.Clear;
      Form_peach.ComboBoxArchive5.DropDownCount:=0;
      Form_peach.ComboBoxArchive5.Enabled:=False;
      Form_peach.ComboBoxArchive6.Clear;
      Form_peach.ComboBoxArchive6.DropDownCount:=0;
      Form_peach.ComboBoxArchive6.Enabled:=False;
      Form_peach.ComboBoxArchivePasses.Clear;
      Form_peach.ComboBoxArchive3.Enabled:=true;
      Form_peach.ComboBoxArchivePasses.Enabled:=false;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=0;
      if compression_level=txt_level_fastest then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=1;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=4;
         end;
      if compression_level=txt_level_fast then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=2;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=8;
         end;
      if compression_level=txt_level_normal then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=3;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=12;
         end;
      if compression_level=txt_level_maximum then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=4;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      if compression_level=txt_level_ultra then
         begin
         Form_peach.ComboBoxArchive4.ItemIndex:=5;
         Form_peach.ComboBoxArchiveSolid.ItemIndex:=13;
         end;
      end;
   {$ENDIF}
   end;
if archive_type='bz2' then
   begin
   set_multi('on');
   Form_peach.ComboBoxArchive3.Clear;
   Form_peach.ComboBoxArchive3.DropDownCount:=1;
   Form_peach.ComboBoxArchive3.Items.Append('BZip2');
   Form_peach.ComboBoxArchive3.ItemIndex:=0;
   Form_peach.ComboBoxArchive4.Clear;
   Form_peach.ComboBoxArchive4.DropDownCount:=5;
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fastest);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fast);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_normal);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_maximum);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_ultra);
   Form_peach.ComboBoxArchive5.Clear;
   Form_peach.ComboBoxArchive5.DropDownCount:=9;
   Form_peach.ComboBoxArchive5.Items.Append('100 KB');
   Form_peach.ComboBoxArchive5.Items.Append('200 KB');
   Form_peach.ComboBoxArchive5.Items.Append('300 KB');
   Form_peach.ComboBoxArchive5.Items.Append('400 KB');
   Form_peach.ComboBoxArchive5.Items.Append('500 KB');
   Form_peach.ComboBoxArchive5.Items.Append('600 KB');
   Form_peach.ComboBoxArchive5.Items.Append('700 KB');
   Form_peach.ComboBoxArchive5.Items.Append('800 KB');
   Form_peach.ComboBoxArchive5.Items.Append('900 KB');
   Form_peach.ComboBoxArchive6.Clear;
   Form_peach.ComboBoxArchivePasses.Clear;
   Form_peach.ComboBoxArchivePasses.DropDownCount:=10;
   Form_peach.ComboBoxArchivePasses.Items.Append('1');
   Form_peach.ComboBoxArchivePasses.Items.Append('2');
   Form_peach.ComboBoxArchivePasses.Items.Append('3');
   Form_peach.ComboBoxArchivePasses.Items.Append('4');
   Form_peach.ComboBoxArchivePasses.Items.Append('5');
   Form_peach.ComboBoxArchivePasses.Items.Append('6');
   Form_peach.ComboBoxArchivePasses.Items.Append('7');
   Form_peach.ComboBoxArchivePasses.Items.Append('8');
   Form_peach.ComboBoxArchivePasses.Items.Append('9');
   Form_peach.ComboBoxArchivePasses.Items.Append('10');
   Form_peach.ComboBoxArchive3.Enabled:=true;
   Form_peach.ComboBoxArchive5.Enabled:=true;
   Form_peach.ComboBoxArchive6.Enabled:=false;
   Form_peach.Label7za18.Visible:=false;
   Form_peach.Combobox7zalgo.Visible:=false;
   Form_peach.ComboBoxArchivePasses.Enabled:=true;
   if compression_level=txt_level_fastest then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=0;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=0;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      end;
   if compression_level=txt_level_fast then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=1;
      Form_peach.ComboBoxArchive5.ItemIndex:=4;
      Form_peach.ComboBoxArchive6.ItemIndex:=0;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      end;
   if compression_level=txt_level_normal then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=2;
      Form_peach.ComboBoxArchive5.ItemIndex:=8;
      Form_peach.ComboBoxArchive6.ItemIndex:=0;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      end;
   if compression_level=txt_level_maximum then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=3;
      Form_peach.ComboBoxArchive5.ItemIndex:=8;
      Form_peach.ComboBoxArchive6.ItemIndex:=0;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=1;
      end;
   if compression_level=txt_level_ultra then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=4;
      Form_peach.ComboBoxArchive5.ItemIndex:=8;
      Form_peach.ComboBoxArchive6.ItemIndex:=0;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=6;
      end;
   end;
if archive_type='gz' then
   begin
   set_multi('on');
   Form_peach.ComboBoxArchive3.Clear;
   Form_peach.ComboBoxArchive3.DropDownCount:=1;
   Form_peach.ComboBoxArchive3.Items.Append('Deflate');
   Form_peach.ComboBoxArchive3.ItemIndex:=0;
   Form_peach.ComboBoxArchive4.Clear;
   Form_peach.ComboBoxArchive4.DropDownCount:=5;
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fastest);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_fast);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_normal);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_maximum);
   Form_peach.ComboBoxArchive4.Items.Append(txt_level_ultra);
   Form_peach.ComboBoxArchive5.Clear;
   Form_peach.ComboBoxArchive5.DropDownCount:=1;
   Form_peach.ComboBoxArchive5.Items.Append('32 KB');
   Form_peach.ComboBoxArchive6.Clear;
   Form_peach.ComboBoxArchive6.DropDownCount:=12;
   Form_peach.ComboBoxArchive6.Items.Append('8');
   Form_peach.ComboBoxArchive6.Items.Append('12');
   Form_peach.ComboBoxArchive6.Items.Append('16');
   Form_peach.ComboBoxArchive6.Items.Append('24');
   Form_peach.ComboBoxArchive6.Items.Append('32');
   Form_peach.ComboBoxArchive6.Items.Append('48');
   Form_peach.ComboBoxArchive6.Items.Append('64');
   Form_peach.ComboBoxArchive6.Items.Append('96');
   Form_peach.ComboBoxArchive6.Items.Append('128');
   Form_peach.ComboBoxArchive6.Items.Append('192');
   Form_peach.ComboBoxArchive6.Items.Append('256');
   Form_peach.ComboBoxArchive6.Items.Append('258');
   Form_peach.ComboBoxArchivePasses.Clear;
   Form_peach.ComboBoxArchivePasses.DropDownCount:=15;
   Form_peach.ComboBoxArchivePasses.Items.Append('1');
   Form_peach.ComboBoxArchivePasses.Items.Append('2');
   Form_peach.ComboBoxArchivePasses.Items.Append('3');
   Form_peach.ComboBoxArchivePasses.Items.Append('4');
   Form_peach.ComboBoxArchivePasses.Items.Append('5');
   Form_peach.ComboBoxArchivePasses.Items.Append('6');
   Form_peach.ComboBoxArchivePasses.Items.Append('7');
   Form_peach.ComboBoxArchivePasses.Items.Append('8');
   Form_peach.ComboBoxArchivePasses.Items.Append('9');
   Form_peach.ComboBoxArchivePasses.Items.Append('10');
   Form_peach.ComboBoxArchivePasses.Items.Append('11');
   Form_peach.ComboBoxArchivePasses.Items.Append('12');
   Form_peach.ComboBoxArchivePasses.Items.Append('13');
   Form_peach.ComboBoxArchivePasses.Items.Append('14');
   Form_peach.ComboBoxArchivePasses.Items.Append('15');
   Form_peach.ComboBoxArchive3.Enabled:=true;
   Form_peach.ComboBoxArchive5.Enabled:=true;
   Form_peach.ComboBoxArchive6.Enabled:=true;
   Form_peach.Label7za18.Visible:=false;
   Form_peach.Combobox7zalgo.Visible:=false;
   Form_peach.ComboBoxArchivePasses.Enabled:=true;
   if compression_level=txt_level_fastest then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=0;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=0;//4;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      end;
   if compression_level=txt_level_fast then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=1;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=2;//4;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      end;
   if compression_level=txt_level_normal then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=2;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=4;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=0;
      end;
   if compression_level=txt_level_maximum then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=3;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=6;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=2;
      end;
   if compression_level=txt_level_ultra then
      begin
      Form_peach.ComboBoxArchive4.ItemIndex:=4;
      Form_peach.ComboBoxArchive5.ItemIndex:=0;
      Form_peach.ComboBoxArchive6.ItemIndex:=8;
      Form_peach.ComboBoxArchivePasses.ItemIndex:=9;
      end;
   end;
if openw_all7z=1 then Form_peach.CheckBoxArchiveOF.State:=cbChecked
else Form_peach.CheckBoxArchiveOF.State:=cbUnChecked;
if snoi7z=1 then Form_peach.CheckBoxsnoi.State:=cbChecked
else Form_peach.CheckBoxsnoi.State:=cbUnChecked;
if snon7z=1 then Form_peach.CheckBoxsnon.State:=cbChecked
else Form_peach.CheckBoxsnon.State:=cbUnChecked;
Form_peach.ComboBoxmemuse.ItemIndex:=memuse_option;
Form_peach.ComboBoxtar.ItemIndex:=tartype;
Form_peach.ComboBoxtar1.ItemIndex:=tartime;
if sort7zbytype=1 then Form_peach.CheckBoxMQS.State:=cbChecked
else Form_peach.CheckBoxMQS.State:=cbUnChecked;
if loadadvdefaults=true then
   begin
   if (advopdictionary>=0) and (advopdictionary<Form_peach.ComboBoxArchive5.Items.Count) then
      Form_peach.ComboBoxArchive5.ItemIndex:=advopdictionary;
   if (advopword>=0) and (advopword<Form_peach.ComboBoxArchive6.Items.Count) then
      Form_peach.ComboBoxArchive6.ItemIndex:=advopword;
   if (advoppasses>=0) and (advoppasses<Form_peach.ComboBoxArchivePasses.Items.Count) then
      Form_peach.ComboBoxArchivePasses.ItemIndex:=advoppasses;
   if (advopblocksize>=0) and (advopblocksize<Form_peach.ComboBoxArchiveSolid.Items.Count) then
      Form_peach.ComboBoxArchiveSolid.ItemIndex:=advopblocksize;
   end;
settingvalues:=false;
end;

procedure change_imagesplit;
begin
   case Form_peach.ComboBoxArchive1.ItemIndex of
      0: Form_peach.ImageSplit.Picture.Bitmap:=nil;
      1: Form_peach.ImageSplit.Picture.Bitmap:=nil;
      2: Form_peach.ImageSplit.Picture.Bitmap:=Bfd_supported;
      3: Form_peach.ImageSplit.Picture.Bitmap:=Bmail;
      4: Form_peach.ImageSplit.Picture.Bitmap:=Bmail;
      5: Form_peach.ImageSplit.Picture.Bitmap:=Bdvd_supported;
      6: Form_peach.ImageSplit.Picture.Bitmap:=Bdvd_supported;
      7: Form_peach.ImageSplit.Picture.Bitmap:=Bhd_supported;
      8: Form_peach.ImageSplit.Picture.Bitmap:=Bdvd_supported;
      9: Form_peach.ImageSplit.Picture.Bitmap:=Bdvd_supported;
      10: Form_peach.ImageSplit.Picture.Bitmap:=Bdvd_supported;
      end;
end;

procedure suggest_outname(var s:ansistring; t:ansistring; i:integer); //suggest output name, without extension (if applicable)
var
   str,pname,aname:ansistring;
   usefoldername:boolean;
begin
if (Form_peach.Edit5.Enabled=false) then //existing archive is being updated
   begin
   s:=Form_peach.editopenin.text;
   cutextension(s);
   exit;//does not change archive name if adding to existing archive
   end;
usefoldername:=false;
if (i=0) or (i>Form_peach.StringGrid1.RowCount-1) then i:=Form_peach.StringGrid1.Row;
if Form_peach.StringGrid1.RowCount>1 then
   begin
   //use specified name (if entered) or compose name from selected object's name
   if (Form_peach.CheckBoxNameAsParentFolder.Checked=true) and (Form_peach.CheckBoxSeparate.Checked=false) then
      if Form_peach.StringGrid1.RowCount>2 then
         begin
         usefoldername:=true;
         str:=extractfilepath(Form_peach.StringGrid1.Cells[8,i]);
         if str<>'' then
            if str[length(str)]=directoryseparator then setlength(str,length(str)-1);
         pname:=extractfilename(str);
         str:=str+directoryseparator;
         str:=str+pname;
         end
      else str:=Form_peach.StringGrid1.Cells[8,i]
   else str:=Form_peach.StringGrid1.Cells[8,i];
   aname:=str;
   cutextension(aname); //aname has the extension cut
   if directoryexists(str) then s:=str //never cut after last dot for directories
   else s:=aname; //else cut extension by default
   //exceptions:
   if (t=txt_split) or (t=STR_BZIP2) or (t=STR_GZIP) or (t=STR_XZ) or (t=STR_QUAD) or (t=STR_BROTLI) or (t=STR_ZSTD) then s:=str;
   //full name if using split, to have filename.ext.001
   //full name if using Bzip2, Gz, Xz, QUAD/BALZ/BCM, Brotli, and Zstd in order to keep original file extension
   if (t=STR_ZPAQ) and (Form_peach.RadioGroupPaq.ItemIndex=0) then s:=str; //full name if using LPAQ, to keep original file extension
   if (Form_peach.StringGrid1.Rowcount=2) and (Form_peach.StringGrid1.Cells[2,1]=txt_list_isfolder) then s:=str; //don't strip "extension" if compressing a single dir (it is indeed part of the name)
   if (Form_peach.StringGrid1.Rowcount=2) and (upcase(copy(str,length(str)-3,4))='.TAR') then s:=str; //don't strip .tar extension if compressing a single tar, to have filename.tar.compression
   if usefoldername=true then s:=str;//if naming after the parent directory, never cut extension (it is a directory name)
   //if a directory name is returned
   if extractfilename(s)='' then s:=s+copy(Form_peach.StringGrid1.Cells[8,Form_peach.StringGrid1.Row],1,1);
   if s=directoryseparator then s:='1';
   end;
end;

function testname(name:ansistring; sg:TStringGrid):integer; //test if an object is already listed in the stringgrid
var
   i:integer;
begin
testname:=1;
if checkfiledirname(name)<>0 then begin pMessageWarningOK(txt_2_7_validatefn+' '+name); exit; end;
for i:=1 to sg.RowCount-1 do
   if sg.Cells[8,i]=name then
      begin
      testname:=1;
      exit;
      end;
testname:=0;
end;

procedure deselectingrid(sg:tstringgrid);
var
   i:integer;
begin
if sg.Rowcount<2 then exit;
if sg.ColCount<12 then exit;
for i:=1 to sg.Rowcount-1 do
   sg.Cells[11,i]:='0';
end;

procedure addfilestr(sg:TStringGrid; filename:ansistring);
var
   fsize:qword;
   s:ansistring;
   rc,iext:integer;
begin
if sg=Form_Peach.Stringgrid1 then
   begin
   try
   srcfilesize(filename,fsize);
   rc:=sg.Rowcount+1;
   sg.RowCount:=rc;
   sg.Cells[0,rc-1]:='';
   sg.Cells[1,rc-1]:=extractfilename(filename);
   sg.Cells[2,rc-1]:=extractfileext(filename);
   try sg.Cells[3,rc-1]:=nicenumber(inttostr(fsize),filesizebase); except end;
   sg.Cells[4,rc-1]:='0';
   sg.Cells[5,rc-1]:='1';
   try sg.Cells[6,rc-1]:=FormatDateTime('yyyy-mm-dd hh:mm:ss', filedatetodatetime(fileage(filename)));
   dword2decodedFileAttributes(filegetattr(filename),s);
   sg.Cells[7,rc-1]:=s; except end;
   sg.Cells[8,rc-1]:=filename;
   sg.Cells[9,rc-1]:=prefixf+filename;
   sg.Cells[12,rc-1]:=inttostr(fsize);
   sg.Cells[10,rc-1]:=inttostr(length(inttostr(length(sg.Cells[12,rc-1]))))+inttostr(length(sg.Cells[12,rc-1]))+sg.Cells[12,rc-1];
   sg.Cells[11,rc-1]:='0';
   tpcomp:=testpcomp(filename);
   sg.Cells[15,rc-1]:=inttostr(fsize*tpcomp);
   except
   exit;
   end;
   end
else
   begin
   try
   srcfilesize(filename,fsize);
   rc:=sg.Rowcount+1;
   sg.RowCount:=rc;
   sg.Cells[0,rc-1]:='';
   sg.Cells[1,rc-1]:=extractfilename(filename);
   sg.Cells[2,rc-1]:=extractfileext(filename);
   sg.Cells[3,rc-1]:=nicenumber(inttostr(fsize),filesizebase);
   sg.Cells[4,rc-1]:='';
   iext:=testext(filename);
   if sg=Form_Peach.Stringgrid2 then
      if iext>=0 then
         if (iext>=500) and (iext<=503) then
                           sg.Cells[4,rc-1]:='.'
                        else
                           sg.Cells[4,rc-1]:='+';
   sg.Cells[5,rc-1]:=FormatDateTime('yyyy-mm-dd hh:mm:ss', filedatetodatetime(fileage(filename)));
   dword2decodedFileAttributes(filegetattr(filename),s);
   sg.Cells[6,rc-1]:=s;
   sg.Cells[7,rc-1]:='';
   sg.Cells[8,rc-1]:=filename;
   sg.Cells[9,rc-1]:=prefixf+filename;
   sg.Cells[12,rc-1]:=inttostr(fsize);
   sg.Cells[10,rc-1]:=inttostr(length(inttostr(length(sg.Cells[12,rc-1]))))+inttostr(length(sg.Cells[12,rc-1]))+sg.Cells[12,rc-1];
   sg.Cells[11,rc-1]:='0';
   except
   exit;
   end;
   end;
end;

function rListint(mode: string;
  dir, mask: ansistring;
  fattrib: qword;
  recur: boolean;
  var nfiles, ndirs: qword;
  var flist: TFoundList;
  var fsizes: TFoundListSizes;
  var ftimes: TFoundListAges;
  var fattr: TFoundListAttrib;
  var fattr_dec: TFoundList
  ): integer;
var
  r: TSearchRec;
begin
  result := 1;
  Inc(ndirs, 1);
  if FindFirst(dir + mask, fattrib, r) = 0 then
  begin
    try
      if upcase(mode) = 'DETAILS' then
        repeat
          if ((r.Name <> '.') and (r.Name <> '..')) then
          begin
            SetLength(flist, nfiles + 1);
            SetLength(fsizes, nfiles + 1);
            SetLength(ftimes, nfiles + 1);
            SetLength(fattr, nfiles + 1);
            SetLength(fattr_dec, nfiles + 1);
            flist[nfiles] := dir + (r.Name);
            if (r.Attr and faDirectory <> 0) then
            begin
              if flist[nfiles][length(flist[nfiles])] <> DirectorySeparator then
                flist[nfiles] := flist[nfiles] + DirectorySeparator;
              Inc(ndirs, 1);
            end;
            fsizes[nfiles] := r.Size;
            ftimes[nfiles] := r.Time;
            fattr[nfiles] := r.Attr;
            dword2decodedFileAttributes(r.Attr, fattr_dec[nfiles]);
            Inc(nfiles, 1);
            if nfiles and (1024)-1 = 0 then Application.ProcessMessages;
          end;
        until findnext(r) <> 0;
    except
      FindClose(r);
      result := 2;
      exit;
    end;
    FindClose(r);
  end;
  if recur = True then
    if FindFirst(dir + '*', fattrib or faDirectory, r) = 0 then
    begin
      try
        repeat
          if ((r.Attr and faDirectory) <> 0) and (r.Name <> '.') and
            (r.Name <> '..') then
          begin
            rListint(mode, dir + (r.Name) +
              DirectorySeparator, mask, fattrib, recur, nfiles, ndirs, flist, fsizes, ftimes, fattr, fattr_dec);
            Dec(ndirs, 1);
            application.ProcessMessages;
          end;
        until findnext(r) <> 0;
      except
        FindClose(r);
        result := 4;
        exit;
      end;
      FindClose(r);
    end;
  if result = 1 then
    result := 0;
end;

function dirsizetcint(path, mask: ansistring;
  fattrib: qword;
  recur: boolean;
  addtofirstobj: boolean;
  var nfiles, ndirs: qword;
  var size, tcsize: qword
  ): integer;
var
  i,tpcomp: integer;
  dir: ansistring;
  flist: TFoundList;
  fsizes: TFoundListSizes;
  ftimes: TFoundListAges;
  fattr: TFoundListAttrib;
  fattr_dec: TFoundList;
begin
  result := 1;
  if addtofirstobj = True then
    nfiles := 1
  else
    nfiles := 0;
  ndirs := 0;
  size := 0;
  tcsize := 0;
  try
    //check for valid path, else set executable path as path
    if length(path) = 0 then
      dir := extractfilepath(ParamStr(0))
    else
      dir := path;
    //check for directoryseparator at the end of the path (needed)
    if dir<>'' then
      if dir[length(dir)] <> DirectorySeparator then
      dir := dir + DirectorySeparator;
    result := rListint('DETAILS', dir, mask, fattrib, recur, nfiles, ndirs, flist,
      fsizes, ftimes, fattr, fattr_dec);
    if addtofirstobj = False then
      ndirs := ndirs - 1;
    for i := 0 to length(fsizes) - 1 do
      begin
      size := size + fsizes[i];
      tpcomp:=testpcomp(flist[i]);
      tcsize := tcsize+ (fsizes[i] * tpcomp);
      end;
  except
    result := 4;
    exit;
  end;
  if result = 1 then
    result := 0;
end;

procedure addfolderstr(sg:TStringGrid; foldername:ansistring);
var
   r:TSearchRec;
   s:ansistring;
   nfiles,ndirs,size,tpcompsize:qword;
   rc:integer;
begin
rc:=sg.Rowcount+1;
sg.RowCount:=rc;
sg.Cells[0,rc-1]:='';
sg.Cells[1,rc-1]:=extractfilename(foldername);
if (extractfilename(foldername)='') and (foldername<>'') then sg.Cells[1,rc-1]:=copy(foldername,1,1);
sg.Cells[2,rc-1]:=txt_list_isfolder;
sg.Cells[3,rc-1]:='0 B';
sg.Cells[4,rc-1]:='1';
sg.Cells[5,rc-1]:='0';
if FindFirst(foldername+'.',faDirectory,r) = 0 then
   begin
   sg.Cells[6,rc-1]:=FormatDateTime('yyyy-mm-dd hh:mm:ss', filedatetodatetime(r.Time));
   dword2decodedFileAttributes(r.Attr,s);
   sg.Cells[7,rc-1]:=s;
   end;
FindClose(r);
sg.Cells[8,rc-1]:=foldername;
sg.Cells[9,rc-1]:=prefixd+foldername;
sg.Cells[10,rc-1]:='0';
sg.Cells[11,rc-1]:='0';
sg.Cells[12,rc-1]:='0';
sg.Cells[15,rc-1]:='0';
if (tmpenumd=true) then
   begin
   //enumerate content
   if sg=Form_peach.StringGrid1 then DirSizetcint(foldername,'*',FaAnyFile,true,true,nfiles,ndirs,size,tpcompsize)
      else DirSize(foldername,'*',FaAnyFile,true,true,nfiles,ndirs,size);
   if sg.Rowcount=1 then exit;
   sg.Cells[3,rc-1]:=nicenumber(inttostr(size),filesizebase);
   sg.Cells[4,rc-1]:=inttostr(ndirs);
   sg.Cells[5,rc-1]:=inttostr(nfiles-ndirs);
   sg.Cells[12,rc-1]:=inttostr(size);
   sg.Cells[10,rc-1]:=inttostr(length(inttostr(length(sg.Cells[12,rc-1]))))+inttostr(length(sg.Cells[12,rc-1]))+sg.Cells[12,rc-1];
   sg.Cells[15,rc-1]:=inttostr(tpcompsize);
   end;
end;

procedure check_tarbefore(tdirs:integer);
var i:integer;
begin
if (Form_peach.CheckBoxSeparate.Enabled=true) then
   if (Form_peach.CheckBoxSeparate.State=cbChecked) then exit;//disable if creating separate archives
Form_peach.CheckBoxSameArc.State:=cbUnChecked;
on_checkboxsamearcclick;
Form_peach.CheckBoxSameArc.Enabled:=False;
Form_peach.CheckBoxSeparate.State:=cbUnChecked;
on_checkboxseparateclick;
Form_peach.CheckBoxSeparate.Enabled:=False;
Form_peach.CheckBoxConvert.State:=cbUnChecked;
Form_peach.CheckBoxConvert.Enabled:=False;
Form_peach.CheckBoxConvert0.visible:=Form_peach.CheckBoxConvert.Checked;
Form_peach.CheckBoxConvert1.visible:=Form_peach.CheckBoxConvert.Checked;
if (tdirs=0) and (Form_peach.StringGrid1.RowCount<3) then
   Form_peach.CheckBoxTarBefore.State:=cbUnchecked
else
   begin
   Form_peach.CheckBoxTarBefore.State:=cbChecked;
   Form_Peach.StringGridTB.RowCount:=Form_Peach.StringGrid1.RowCount;
   for i:=0 to Form_Peach.StringGrid1.RowCount-1 do
      Form_Peach.StringGridTB.Rows[i].Assign(Form_Peach.StringGrid1.Rows[i]);
   end;
end;

function addext(s:ansistring):ansistring;
begin
if Form_peach.CheckBoxTarBefore.State=cbChecked then
   if extractfileext(s)<>'.tar' then s:=s+'.tar';
if (Form_peach.cbType.Text=txt_custom) or (Form_peach.cbType.Text=txt_custom+'/RAR') then
   begin
   if Form_peach.EditExtCustom.Caption<>'' then result:=s+'.'+Form_peach.EditExtCustom.Caption
   else result:=s;
   exit;
   end;
if Form_peach.cbType.Text=STR_PEA then begin result:=s+'.pea'; exit; end;
if Form_peach.cbType.Text=txt_split then begin result:=s+'.001'; exit; end;
if Form_peach.cbType.Text=STR_UPX then begin result:=s+'.exe'; exit; end;
if ((archive_type='7z') and (Form_peach.CheckBoxArchive6.State=cbChecked)) or
   ((archive_type='arc') and (Form_peach.CheckBoxArc2.State=cbChecked))
   then result:=s+'.exe'
   else result:=s+'.'+archive_type;
end;

function pathistmp(s:ansistring):boolean;
begin
result:=false;
if (pos(STR_TMP,s)) or
   (pos(STR_PZWORKTMP,s)) or
   (pos(STR_STMP,s)) or
   (pos(STR_TMPEXT,s)) or
   (pos(STR_TMPDD,s)) or
   (pos(STR_PEAZIPTMP,s))<>0 then result:=true;
end;

procedure checkoutpath_archive;
begin
if form_peach.visible=true then
   if pathistmp(Form_peach.Edit5.Text)=true then
      Form_peach.Edit5.Color:=PLYELLOW
   else
      Form_peach.Edit5.Color:=stringtocolor(color2);
end;

procedure tempcheckoutpath_extract;
begin
if form_peach.visible=true then
   if pos(STR_TMP,Form_peach.EditOpenOut.Text)<>0 then
      if (DirectoryExists(Form_peach.pnha1.Caption)=true) and (pos(STR_TMP,Form_peach.pnha1.Caption)=0) then Form_peach.EditOpenOut.Text:=Form_peach.pnha1.Caption
      else
         if (DirectoryExists(Form_peach.pnha2.Caption)=true) and (pos(STR_TMP,Form_peach.pnha2.Caption)=0) then Form_peach.EditOpenOut.Text:=Form_peach.pnha2.Caption
         else
            if (DirectoryExists(Form_peach.pnha3.Caption)=true) and (pos(STR_TMP,Form_peach.pnha3.Caption)=0) then Form_peach.EditOpenOut.Text:=Form_peach.pnha3.Caption
            else
               if (DirectoryExists(Form_peach.pnha4.Caption)=true) and (pos(STR_TMP,Form_peach.pnha4.Caption)=0) then Form_peach.EditOpenOut.Text:=Form_peach.pnha4.Caption
               else
                  if (DirectoryExists(Form_peach.pnha5.Caption)=true) and (pos(STR_TMP,Form_peach.pnha5.Caption)=0) then Form_peach.EditOpenOut.Text:=Form_peach.pnha5.Caption
                  else
                     if (DirectoryExists(Form_peach.pnha6.Caption)=true) and (pos(STR_TMP,Form_peach.pnha6.Caption)=0) then Form_peach.EditOpenOut.Text:=Form_peach.pnha6.Caption
                     else
                        if (DirectoryExists(Form_peach.pnha7.Caption)=true) and (pos(STR_TMP,Form_peach.pnha7.Caption)=0) then Form_peach.EditOpenOut.Text:=Form_peach.pnha7.Caption
                        else
                           if (DirectoryExists(Form_peach.pnha8.Caption)=true) and (pos(STR_TMP,Form_peach.pnha8.Caption)=0) then Form_peach.EditOpenOut.Text:=Form_peach.pnha8.Caption;
end;

procedure checkoutpath_extract;
begin
if form_peach.visible=true then
   if pathistmp(Form_peach.EditOpenOut.Text)=true then
      begin
      Form_peach.EditOpenOut.Color:=PLYELLOW;
      if pos(STR_TMP,Form_peach.EditOpenOut.Text)<>0 then Form_peach.EditOpenOut.Hint:=txt_7_0_exttmppath+char($0D)+char($0A)+copy(Form_peach.EditOpenOut.Caption,0,pos(STR_TMP,Form_peach.EditOpenOut.Caption)-1);
      end
   else
      begin
      Form_peach.EditOpenOut.Color:=stringtocolor(color2);
      Form_peach.EditOpenOut.Hint:='';
      end;
updatecontent_ext;
end;

procedure autosize_stringgrid1;
begin
Form_peach.StringGrid1.AutoSizeColumns;
Form_peach.StringGrid1.ColWidths[0]:=rowsize;
Form_peach.StringGrid1.ColWidths[1]:=COL1D;
Form_peach.StringGrid1.ColWidths[9]:=0;
Form_peach.StringGrid1.ColWidths[10]:=0;
Form_peach.StringGrid1.ColWidths[11]:=0;
Form_peach.StringGrid1.ColWidths[12]:=0;
Form_peach.StringGrid1.colwidths[13]:=0;
Form_peach.StringGrid1.colwidths[14]:=0;
Form_peach.StringGrid1.colwidths[15]:=0;
end;

procedure hide_panelhintadd;
begin
Form_peach.PanelHintAdd.Visible:=false;
Form_peach.StringGrid1.Hint:=txt_2_7_archivehint;
end;

procedure hide_panelhintextract;
begin
Form_peach.PanelHintExtract.Visible:=false;
Form_peach.StringGrid2.Hint:=txt_2_7_exthint;
end;

procedure updatecontent(sg:TStringGrid; var tvolumes,tdirs,tfiles,tsize:qword; upsort:boolean); //update label showing bytes/files/dirs listed in the stringgrid1; update list of archive types
var
   i:integer;
   s:ansistring;
   tpcompsize:qword;
begin
if updatingcontent=1 then exit;
updatingcontent:=1;
tfiles:=0;
tdirs:=0;
tvolumes:=0;
tsize:=0;
tpcompsize:=0;
//hint overlay for add
if sg=Form_peach.StringGrid1 then
   if sg.RowCount>1 then hide_panelhintadd
   else Form_peach.PanelHintAdd.Visible:=true;
for i:=1 to sg.RowCount-1 do
   begin
   tdirs:=tdirs+strtoint(sg.Cells[4,i]);
   tfiles:=tfiles+strtoint(sg.Cells[5,i]);
   try
      tsize:=tsize+strtoqword(sg.Cells[12,i]);
      tpcompsize:=tpcompsize+strtoqword(sg.Cells[15,i]);
   except
   end;
   if upsort=true then sg.Cells[11,i]:='0';
   end;
autosize_stringgrid1;
if using_tarbefore=false then
   begin
   if (Form_peach.cbType.Text=STR_GZIP) or
      (Form_peach.cbType.Text=STR_BZIP2) or
      (Form_peach.cbType.Text=STR_XZ) or
      (Form_peach.cbType.Text=STR_QUAD) or
      (Form_peach.cbType.Text=STR_BROTLI) or
      (Form_peach.cbType.Text=STR_ZSTD) or
      (Form_peach.cbType.Text=txt_split) or
      ((Form_peach.cbType.Text=STR_ZPAQ) and (Form_peach.RadioGroupPaq.ItemIndex=0)) then
      check_tarbefore(tdirs);
   end;
if Form_peach.StringGrid1.RowCount=1 then
   begin
   status1:=inttostr(tdirs)+' '+txt_dirs+' '+inttostr(tfiles)+' '+txt_files+' '+nicenumber(inttostr(tsize),filesizebase);
   if updatingarchive_inarchive=false then
      begin
      Form_peach.LabelStatusAr2.Caption:=status1;
      Form_peach.LabelStatus4.Caption:='';
      end
   else
      begin
      Form_peach.LabelStatusAr2.Caption:=status1;
      Form_peach.LabelStatus4.Caption:=txt_2_7_updating;
      Form_peach.edit5.Caption:=form_peach.editopenin.caption;
      end;
   if (Form_peach.EditName3.Text='') or (Form_peach.Edit4.Text='') then setoutname(s,0);
   updatingcontent:=0;
   exit;
   end;
if upsort=true then
   begin
   Form_peach.StringGrid1.SortColRow(true,9);
   Form_peach.StringGrid1.Cells[11,1]:='1';
   Form_peach.StringGrid1.Row:=1;
   end;
status1:=inttostr(tdirs)+' '+txt_dirs+' '+inttostr(tfiles)+' '+txt_files+' '+nicenumber(inttostr(tsize),filesizebase);
if updatingarchive_inarchive=false then
   begin
   Form_peach.LabelStatusAr2.Caption:=status1;
   if tsize<>0 then Form_peach.LabelStatusAr2.Caption:=Form_peach.LabelStatusAr2.Caption+' | '+txt_4_7_pcomp+' '+inttostr((tsize*100 - tpcompsize) div tsize)+'%';
   Form_peach.LabelStatus4.Caption:='';
   end
else
   begin
   Form_peach.LabelStatusAr2.Caption:=status1;
   if tsize<>0 then Form_peach.LabelStatusAr2.Caption:=Form_peach.LabelStatusAr2.Caption+' | '+txt_4_7_pcomp+' '+inttostr((tsize*100 - tpcompsize) div tsize)+'%';
   Form_peach.LabelStatus4.Caption:=txt_2_7_updating;
   Form_peach.edit5.Caption:=form_peach.editopenin.caption;
   end;
if (Form_peach.EditName3.Text='') or (Form_peach.Edit4.Text='') then setoutname(s,0);
updatingcontent:=0;
end;

procedure autosize_stringgrid2;
begin
with Form_peach do
begin
StringGrid2.AutoSizeColumns;
StringGrid2.ColWidths[0]:=rowsize;
StringGrid2.ColWidths[1]:=COL1D;
StringGrid2.ColWidths[9]:=0;
StringGrid2.ColWidths[10]:=0;
StringGrid2.ColWidths[11]:=0;
StringGrid2.ColWidths[12]:=0;
StringGrid2.colwidths[13]:=0;
StringGrid2.colwidths[14]:=0;
StringGrid2.colwidths[15]:=0;
end;
end;

procedure setextzpaqext(iszpaq:integer);
begin
case iszpaq of
   0: //no extended option
   begin
   Form_peach.PanelExtZPAQ.visible:=false;
   Form_peach.Labeladvextzpaq.visible:=false;
   Form_peach.RadioGroupAction.enabled:=true;
   Form_peach.ComboBoxOverwrite.enabled:=true;
   Form_peach.Labeladvextzpaq1.visible:=false;
   Form_peach.CheckBoxzpaqforce.visible:=false;
   end;
   1: //zpaq extended options (all etended options)
   begin
   Form_peach.PanelExtZPAQ.visible:=true;
   Form_peach.Labeladvextzpaq.visible:=true;
   Form_peach.RadioGroupAction.enabled:=false;
   Form_peach.ComboBoxOverwrite.enabled:=false;
   Form_peach.Labeladvextzpaq1.visible:=true;
   Form_peach.CheckBoxzpaqforce.visible:=true;
   end;
   2: //all options
   begin
   Form_peach.PanelExtZPAQ.visible:=true;
   Form_peach.Labeladvextzpaq.visible:=true;
   Form_peach.RadioGroupAction.enabled:=true;
   Form_peach.ComboBoxOverwrite.enabled:=true;
   Form_peach.Labeladvextzpaq1.visible:=true;
   Form_peach.CheckBoxzpaqforce.visible:=true;
   end;
   3: //br zst extended options
   begin
   Form_peach.PanelExtZPAQ.visible:=false;
   Form_pea