program t_shak01;

{Simple test SHAKE128 and SHAKE256 with 250 bit message and 512 byte digest}

{$i std.inc}

{$ifdef APPCONS}
  {$apptype console}
{$endif}


uses
  {$ifdef WINCRT} WinCRT, {$endif}
  BTypes, Mem_Util, SHA3;


const
    msg250: array[0.. 31] of byte = (
              $03,$72,$cd,$1c,$e0,$b7,$4c,$e0,
              $5e,$71,$7f,$c4,$b9,$a8,$2c,$e1,
              $a8,$88,$f4,$ef,$7b,$00,$27,$a5,
              $d6,$dc,$5f,$8d,$13,$93,$6e,$01);

  shake256: array[0..511] of byte = (
              $80,$7b,$24,$45,$e6,$2e,$7e,$5c,
              $2a,$1a,$70,$1b,$06,$5a,$4c,$05,
              $b5,$00,$b9,$e3,$4b,$1b,$26,$bc,
              $3a,$01,$4f,$9c,$7d,$03,$93,$5e,
              $a9,$e3,$b0,$66,$31,$df,$c5,$7e,
              $33,$b6,$0b,$31,$c8,$a0,$c8,$86,
              $e1,$c4,$66,$5f,$af,$27,$2a,$12,
              $cd,$9c,$f0,$bd,$1a,$3b,$c6,$97,
              $03,$fb,$f9,$e1,$81,$6c,$61,$8c,
              $b8,$e9,$17,$b3,$fb,$59,$aa,$93,
              $93,$7c,$89,$2e,$ed,$90,$82,$07,
              $6a,$ef,$c8,$ad,$23,$d0,$4a,$1b,
              $ed,$88,$2f,$a7,$43,$cb,$ef,$c5,
              $17,$aa,$20,$04,$0e,$b7,$1e,$20,
              $9a,$d5,$e7,$db,$5a,$78,$d8,$bd,
              $27,$86,$f7,$b3,$a0,$41,$90,$ca,
              $39,$cf,$3f,$86,$60,$be,$63,$46,
              $eb,$7b,$f7,$7f,$d2,$52,$4b,$10,
              $40,$5e,$92,$e3,$7a,$10,$b6,$7f,
              $80,$cb,$42,$22,$be,$9e,$00,$19,
              $d3,$30,$94,$05,$73,$06,$e7,$ba,
              $65,$39,$a7,$13,$94,$8e,$97,$61,
              $8a,$5c,$a6,$ff,$01,$4a,$a7,$92,
              $50,$b5,$17,$bc,$85,$56,$7f,$44,
              $51,$de,$22,$e6,$cf,$e3,$d9,$8d,
              $52,$39,$13,$49,$ff,$e6,$8c,$6e,
              $8f,$dc,$95,$82,$95,$af,$f3,$ff,
              $2f,$0a,$8a,$ef,$f2,$e3,$d4,$6a,
              $c2,$ba,$f8,$71,$1c,$da,$4d,$f0,
              $6c,$24,$5d,$f4,$da,$8c,$2b,$0d,
              $72,$2c,$13,$63,$a9,$4c,$38,$f2,
              $4b,$63,$02,$11,$26,$50,$52,$41,
              $ca,$85,$a0,$3c,$57,$31,$c0,$b7,
              $01,$49,$c1,$05,$45,$a1,$a7,$b5,
              $d9,$ca,$7d,$d1,$c1,$81,$58,$88,
              $4d,$4c,$37,$a4,$0e,$0a,$b2,$b9,
              $71,$80,$27,$4a,$02,$db,$70,$25,
              $d2,$32,$ce,$e6,$a8,$d9,$d4,$a2,
              $c6,$52,$d3,$33,$83,$fe,$05,$ba,
              $43,$96,$59,$b8,$03,$09,$b6,$9f,
              $aa,$71,$f7,$00,$d5,$50,$a0,$d1,
              $d0,$a0,$ef,$e3,$f6,$7a,$da,$02,
              $e2,$d9,$ba,$8a,$7f,$2e,$41,$6e,
              $89,$a3,$e3,$cb,$37,$de,$73,$83,
              $8d,$d7,$53,$aa,$93,$64,$7c,$ab,
              $fb,$b2,$a9,$9c,$9f,$ea,$2d,$9d,
              $0e,$02,$b0,$82,$92,$94,$c6,$f4,
              $36,$7b,$4d,$09,$e2,$13,$cf,$2e,
              $11,$dd,$df,$0c,$4c,$00,$d6,$16,
              $7e,$81,$73,$85,$18,$e0,$b4,$ab,
              $fb,$d3,$4d,$26,$55,$a3,$55,$3f,
              $ba,$17,$56,$f6,$09,$47,$43,$c4,
              $06,$e5,$ad,$5d,$e5,$fd,$da,$11,
              $24,$23,$06,$c5,$2f,$aa,$87,$54,
              $08,$16,$df,$93,$14,$4f,$77,$c1,
              $d8,$ea,$95,$8c,$73,$f8,$d4,$7b,
              $c4,$ca,$ce,$c1,$10,$54,$52,$c4,
              $47,$fe,$94,$0c,$8a,$9e,$94,$98,
              $42,$c3,$d7,$c2,$ef,$5e,$27,$fd,
              $1a,$20,$87,$dd,$4e,$00,$8f,$c2,
              $3d,$d6,$54,$e4,$69,$51,$b7,$e7,
              $82,$d9,$87,$f8,$d1,$f1,$29,$b1,
              $3e,$98,$b3,$de,$f7,$07,$2e,$f5,
              $f6,$c1,$88,$7a,$8d,$db,$aa,$33);

  shake128: array[0..511] of byte = (
              $f7,$b1,$c8,$f5,$fd,$61,$36,$ae,
              $b4,$d8,$bf,$a0,$74,$07,$87,$a6,
              $d2,$e7,$af,$48,$8e,$96,$cb,$c3,
              $a5,$e0,$92,$9a,$59,$89,$c0,$af,
              $49,$79,$4a,$a6,$c6,$4a,$58,$42,
              $b9,$c0,$81,$23,$8d,$fc,$4d,$5c,
              $2f,$17,$58,$43,$02,$6f,$72,$ec,
              $10,$c4,$64,$36,$71,$37,$2f,$d0,
              $83,$80,$9f,$51,$e2,$a7,$45,$6e,
              $55,$e1,$a0,$7d,$eb,$95,$ae,$ea,
              $62,$bb,$39,$ad,$fa,$dc,$4b,$42,
              $aa,$6b,$28,$9a,$af,$eb,$e2,$c0,
              $56,$f8,$62,$00,$7b,$7f,$89,$17,
              $16,$57,$3b,$c5,$4b,$d6,$56,$57,
              $fd,$5d,$d1,$12,$c8,$76,$63,$cd,
              $45,$84,$c9,$22,$47,$ba,$a3,$d2,
              $28,$41,$5a,$98,$e0,$db,$e5,$bb,
              $12,$8e,$43,$65,$49,$2c,$32,$2c,
              $a7,$20,$12,$0b,$f3,$4d,$b0,$b9,
              $7a,$6d,$c0,$32,$d5,$df,$e0,$68,
              $dc,$96,$17,$3c,$ee,$aa,$9b,$af,
              $48,$f2,$1e,$4c,$cb,$ba,$13,$4f,
              $af,$84,$b0,$25,$08,$d9,$e1,$fc,
              $94,$86,$ae,$b6,$73,$b2,$7b,$a8,
              $61,$24,$cd,$28,$5b,$4c,$1b,$17,
              $60,$12,$4c,$4a,$d6,$c5,$03,$ad,
              $35,$f6,$91,$f6,$28,$53,$e9,$79,
              $ce,$ed,$f7,$06,$27,$a0,$b9,$3a,
              $42,$73,$83,$88,$75,$2c,$8f,$41,
              $54,$c3,$e9,$ab,$b1,$b5,$36,$38,
              $08,$1d,$82,$59,$54,$5f,$80,$1b,
              $5f,$15,$76,$4d,$da,$74,$49,$0a,
              $33,$97,$51,$8f,$8f,$78,$c7,$3e,
              $c6,$8e,$51,$78,$e8,$43,$4f,$31,
              $38,$1b,$1f,$e5,$0e,$03,$4b,$2e,
              $b7,$83,$9f,$13,$4e,$57,$53,$de,
              $61,$06,$a0,$21,$4f,$7f,$4d,$8f,
              $f5,$3c,$06,$3a,$eb,$1f,$4a,$74,
              $e6,$6d,$3e,$2c,$92,$5f,$c2,$f5,
              $5b,$e8,$3a,$9e,$8d,$23,$06,$1c,
              $df,$01,$4d,$fa,$b5,$97,$6c,$a0,
              $da,$87,$ab,$6d,$fe,$26,$35,$12,
              $78,$2e,$ad,$e5,$ab,$9b,$95,$f1,
              $14,$47,$a8,$f0,$90,$0c,$4a,$a6,
              $e3,$16,$65,$95,$7e,$c3,$ac,$b1,
              $7a,$36,$54,$d6,$83,$e0,$3e,$d2,
              $2e,$d3,$30,$c2,$89,$4f,$7a,$20,
              $97,$ba,$00,$4c,$61,$2b,$7c,$86,
              $cd,$74,$38,$21,$51,$97,$55,$73,
              $85,$d1,$2b,$d8,$6d,$9a,$0a,$7d,
              $8e,$fe,$64,$d0,$b6,$25,$4a,$a0,
              $4f,$87,$c4,$80,$7a,$da,$5f,$27,
              $6f,$cc,$f0,$16,$8f,$05,$8c,$1b,
              $15,$bd,$f9,$6f,$36,$9d,$c5,$ed,
              $55,$85,$b8,$d5,$fe,$0f,$e0,$09,
              $db,$40,$7d,$0b,$16,$8c,$78,$70,
              $3d,$8f,$7d,$57,$ab,$25,$41,$76,
              $c2,$46,$42,$04,$61,$be,$cd,$af,
              $af,$df,$d4,$df,$f6,$42,$9f,$4f,
              $25,$92,$80,$6c,$7e,$7a,$a6,$d2,
              $39,$84,$df,$1b,$6c,$54,$8f,$b0,
              $17,$4e,$8d,$af,$72,$5f,$04,$05,
              $1a,$a9,$95,$e3,$df,$ab,$45,$b4,
              $11,$97,$9c,$a4,$9d,$de,$86,$22);


var
  bitlen: longint;
  state:  TSHA3State;
  err,k:  integer;
  buf: array[0..511] of byte;

begin
  writeln('Test program for SHAKE128/256    (c) 2015 W.Ehrhardt');
  writeln('----------------------------------------------------');
  bitlen := 250;
  err := SHA3_Init(state,__SHAKE_128);
  k := bitlen shr 3;
  if err=0 then err := SHA3_Update(state, @msg250, k);
  if err=0 then err := SHA3_FinalBit_LSB(state, msg250[k], bitlen and 7, @buf, 8*sizeof(buf));
  write('SKAKE128 test ');
  if err=0 then begin
    if  compmem(@buf, @shake128, sizeof(shake128)) then writeln('passed.')
    else writeln('failed!');
  end
  else writeln(' reports error: ',err);

  err := SHA3_Init(state,__SHAKE_256);
  k := bitlen shr 3;
  if err=0 then err := SHA3_Update(state, @msg250, k);
  if err=0 then err := SHA3_FinalBit_LSB(state, msg250[k], bitlen and 7, @buf, 8*sizeof(buf));
  write('SKAKE256 test ');
  if err=0 then begin
    if  compmem(@buf, @shake256, sizeof(shake256)) then writeln('passed.')
    else writeln('failed!');
  end
  else writeln(' reports error: ',err);
end.

