
(*************************************************************************
 Include file for AES_ENCR.PAS - Compressed tables/Helper types

 Version  Date      Author      Modification
 -------  --------  -------     ------------------------------------------
 0.10     09.07.06  W.Ehrhardt  Initial version for compressed tables
 0.11     13.07.06  we          Removed AES_LONGBOX consts, b3 gets box byte
 0.12     19.07.06  we          TCeDummy
**************************************************************************)

(**** (C) Copyright 2002-2006 Wolfgang Ehrhardt -- see copying_we.txt ****)


type
  TH3 = packed record
          L: longint;
          b0,b1,b2,box: byte;
        end;

  TH2 = packed record
          b0: byte;
          L: longint;
          b1,b2,box: byte;
        end;

  TH1 = packed record
          b0,b1: byte;
          L: longint;
          b2,box: byte;
        end;

  TH0 = packed record
          b0,b1,b2: byte;
          L: longint;
          box: byte;
        end;

  TEU = record
          case integer of
            0: (E0: TH0);
            1: (E1: TH1);
            2: (E2: TH2);
            3: (E3: TH3);
        end;

{$ifdef StrictLong}
  {$warnings off}
  {$R-} {avoid D9+ errors!}
{$endif}

const
  {$ifdef AES_Encr_DummyAlign}
    TCeDummy : longint = 0;  {Use to align TCe to 8 byte boundary}
  {$endif}
  TCe: packed array[0..2047] of byte = (
         $63,$63,$a5,$c6,$63,$63,$a5,$63,$7c,$7c,$84,$f8,$7c,$7c,$84,$7c,
         $77,$77,$99,$ee,$77,$77,$99,$77,$7b,$7b,$8d,$f6,$7b,$7b,$8d,$7b,
         $f2,$f2,$0d,$ff,$f2,$f2,$0d,$f2,$6b,$6b,$bd,$d6,$6b,$6b,$bd,$6b,
         $6f,$6f,$b1,$de,$6f,$6f,$b1,$6f,$c5,$c5,$54,$91,$c5,$c5,$54,$c5,
         $30,$30,$50,$60,$30,$30,$50,$30,$01,$01,$03,$02,$01,$01,$03,$01,
         $67,$67,$a9,$ce,$67,$67,$a9,$67,$2b,$2b,$7d,$56,$2b,$2b,$7d,$2b,
         $fe,$fe,$19,$e7,$fe,$fe,$19,$fe,$d7,$d7,$62,$b5,$d7,$d7,$62,$d7,
         $ab,$ab,$e6,$4d,$ab,$ab,$e6,$ab,$76,$76,$9a,$ec,$76,$76,$9a,$76,
         $ca,$ca,$45,$8f,$ca,$ca,$45,$ca,$82,$82,$9d,$1f,$82,$82,$9d,$82,
         $c9,$c9,$40,$89,$c9,$c9,$40,$c9,$7d,$7d,$87,$fa,$7d,$7d,$87,$7d,
         $fa,$fa,$15,$ef,$fa,$fa,$15,$fa,$59,$59,$eb,$b2,$59,$59,$eb,$59,
         $47,$47,$c9,$8e,$47,$47,$c9,$47,$f0,$f0,$0b,$fb,$f0,$f0,$0b,$f0,
         $ad,$ad,$ec,$41,$ad,$ad,$ec,$ad,$d4,$d4,$67,$b3,$d4,$d4,$67,$d4,
         $a2,$a2,$fd,$5f,$a2,$a2,$fd,$a2,$af,$af,$ea,$45,$af,$af,$ea,$af,
         $9c,$9c,$bf,$23,$9c,$9c,$bf,$9c,$a4,$a4,$f7,$53,$a4,$a4,$f7,$a4,
         $72,$72,$96,$e4,$72,$72,$96,$72,$c0,$c0,$5b,$9b,$c0,$c0,$5b,$c0,
         $b7,$b7,$c2,$75,$b7,$b7,$c2,$b7,$fd,$fd,$1c,$e1,$fd,$fd,$1c,$fd,
         $93,$93,$ae,$3d,$93,$93,$ae,$93,$26,$26,$6a,$4c,$26,$26,$6a,$26,
         $36,$36,$5a,$6c,$36,$36,$5a,$36,$3f,$3f,$41,$7e,$3f,$3f,$41,$3f,
         $f7,$f7,$02,$f5,$f7,$f7,$02,$f7,$cc,$cc,$4f,$83,$cc,$cc,$4f,$cc,
         $34,$34,$5c,$68,$34,$34,$5c,$34,$a5,$a5,$f4,$51,$a5,$a5,$f4,$a5,
         $e5,$e5,$34,$d1,$e5,$e5,$34,$e5,$f1,$f1,$08,$f9,$f1,$f1,$08,$f1,
         $71,$71,$93,$e2,$71,$71,$93,$71,$d8,$d8,$73,$ab,$d8,$d8,$73,$d8,
         $31,$31,$53,$62,$31,$31,$53,$31,$15,$15,$3f,$2a,$15,$15,$3f,$15,
         $04,$04,$0c,$08,$04,$04,$0c,$04,$c7,$c7,$52,$95,$c7,$c7,$52,$c7,
         $23,$23,$65,$46,$23,$23,$65,$23,$c3,$c3,$5e,$9d,$c3,$c3,$5e,$c3,
         $18,$18,$28,$30,$18,$18,$28,$18,$96,$96,$a1,$37,$96,$96,$a1,$96,
         $05,$05,$0f,$0a,$05,$05,$0f,$05,$9a,$9a,$b5,$2f,$9a,$9a,$b5,$9a,
         $07,$07,$09,$0e,$07,$07,$09,$07,$12,$12,$36,$24,$12,$12,$36,$12,
         $80,$80,$9b,$1b,$80,$80,$9b,$80,$e2,$e2,$3d,$df,$e2,$e2,$3d,$e2,
         $eb,$eb,$26,$cd,$eb,$eb,$26,$eb,$27,$27,$69,$4e,$27,$27,$69,$27,
         $b2,$b2,$cd,$7f,$b2,$b2,$cd,$b2,$75,$75,$9f,$ea,$75,$75,$9f,$75,
         $09,$09,$1b,$12,$09,$09,$1b,$09,$83,$83,$9e,$1d,$83,$83,$9e,$83,
         $2c,$2c,$74,$58,$2c,$2c,$74,$2c,$1a,$1a,$2e,$34,$1a,$1a,$2e,$1a,
         $1b,$1b,$2d,$36,$1b,$1b,$2d,$1b,$6e,$6e,$b2,$dc,$6e,$6e,$b2,$6e,
         $5a,$5a,$ee,$b4,$5a,$5a,$ee,$5a,$a0,$a0,$fb,$5b,$a0,$a0,$fb,$a0,
         $52,$52,$f6,$a4,$52,$52,$f6,$52,$3b,$3b,$4d,$76,$3b,$3b,$4d,$3b,
         $d6,$d6,$61,$b7,$d6,$d6,$61,$d6,$b3,$b3,$ce,$7d,$b3,$b3,$ce,$b3,
         $29,$29,$7b,$52,$29,$29,$7b,$29,$e3,$e3,$3e,$dd,$e3,$e3,$3e,$e3,
         $2f,$2f,$71,$5e,$2f,$2f,$71,$2f,$84,$84,$97,$13,$84,$84,$97,$84,
         $53,$53,$f5,$a6,$53,$53,$f5,$53,$d1,$d1,$68,$b9,$d1,$d1,$68,$d1,
         $00,$00,$00,$00,$00,$00,$00,$00,$ed,$ed,$2c,$c1,$ed,$ed,$2c,$ed,
         $20,$20,$60,$40,$20,$20,$60,$20,$fc,$fc,$1f,$e3,$fc,$fc,$1f,$fc,
         $b1,$b1,$c8,$79,$b1,$b1,$c8,$b1,$5b,$5b,$ed,$b6,$5b,$5b,$ed,$5b,
         $6a,$6a,$be,$d4,$6a,$6a,$be,$6a,$cb,$cb,$46,$8d,$cb,$cb,$46,$cb,
         $be,$be,$d9,$67,$be,$be,$d9,$be,$39,$39,$4b,$72,$39,$39,$4b,$39,
         $4a,$4a,$de,$94,$4a,$4a,$de,$4a,$4c,$4c,$d4,$98,$4c,$4c,$d4,$4c,
         $58,$58,$e8,$b0,$58,$58,$e8,$58,$cf,$cf,$4a,$85,$cf,$cf,$4a,$cf,
         $d0,$d0,$6b,$bb,$d0,$d0,$6b,$d0,$ef,$ef,$2a,$c5,$ef,$ef,$2a,$ef,
         $aa,$aa,$e5,$4f,$aa,$aa,$e5,$aa,$fb,$fb,$16,$ed,$fb,$fb,$16,$fb,
         $43,$43,$c5,$86,$43,$43,$c5,$43,$4d,$4d,$d7,$9a,$4d,$4d,$d7,$4d,
         $33,$33,$55,$66,$33,$33,$55,$33,$85,$85,$94,$11,$85,$85,$94,$85,
         $45,$45,$cf,$8a,$45,$45,$cf,$45,$f9,$f9,$10,$e9,$f9,$f9,$10,$f9,
         $02,$02,$06,$04,$02,$02,$06,$02,$7f,$7f,$81,$fe,$7f,$7f,$81,$7f,
         $50,$50,$f0,$a0,$50,$50,$f0,$50,$3c,$3c,$44,$78,$3c,$3c,$44,$3c,
         $9f,$9f,$ba,$25,$9f,$9f,$ba,$9f,$a8,$a8,$e3,$4b,$a8,$a8,$e3,$a8,
         $51,$51,$f3,$a2,$51,$51,$f3,$51,$a3,$a3,$fe,$5d,$a3,$a3,$fe,$a3,
         $40,$40,$c0,$80,$40,$40,$c0,$40,$8f,$8f,$8a,$05,$8f,$8f,$8a,$8f,
         $92,$92,$ad,$3f,$92,$92,$ad,$92,$9d,$9d,$bc,$21,$9d,$9d,$bc,$9d,
         $38,$38,$48,$70,$38,$38,$48,$38,$f5,$f5,$04,$f1,$f5,$f5,$04,$f5,
         $bc,$bc,$df,$63,$bc,$bc,$df,$bc,$b6,$b6,$c1,$77,$b6,$b6,$c1,$b6,
         $da,$da,$75,$af,$da,$da,$75,$da,$21,$21,$63,$42,$21,$21,$63,$21,
         $10,$10,$30,$20,$10,$10,$30,$10,$ff,$ff,$1a,$e5,$ff,$ff,$1a,$ff,
         $f3,$f3,$0e,$fd,$f3,$f3,$0e,$f3,$d2,$d2,$6d,$bf,$d2,$d2,$6d,$d2,
         $cd,$cd,$4c,$81,$cd,$cd,$4c,$cd,$0c,$0c,$14,$18,$0c,$0c,$14,$0c,
         $13,$13,$35,$26,$13,$13,$35,$13,$ec,$ec,$2f,$c3,$ec,$ec,$2f,$ec,
         $5f,$5f,$e1,$be,$5f,$5f,$e1,$5f,$97,$97,$a2,$35,$97,$97,$a2,$97,
         $44,$44,$cc,$88,$44,$44,$cc,$44,$17,$17,$39,$2e,$17,$17,$39,$17,
         $c4,$c4,$57,$93,$c4,$c4,$57,$c4,$a7,$a7,$f2,$55,$a7,$a7,$f2,$a7,
         $7e,$7e,$82,$fc,$7e,$7e,$82,$7e,$3d,$3d,$47,$7a,$3d,$3d,$47,$3d,
         $64,$64,$ac,$c8,$64,$64,$ac,$64,$5d,$5d,$e7,$ba,$5d,$5d,$e7,$5d,
         $19,$19,$2b,$32,$19,$19,$2b,$19,$73,$73,$95,$e6,$73,$73,$95,$73,
         $60,$60,$a0,$c0,$60,$60,$a0,$60,$81,$81,$98,$19,$81,$81,$98,$81,
         $4f,$4f,$d1,$9e,$4f,$4f,$d1,$4f,$dc,$dc,$7f,$a3,$dc,$dc,$7f,$dc,
         $22,$22,$66,$44,$22,$22,$66,$22,$2a,$2a,$7e,$54,$2a,$2a,$7e,$2a,
         $90,$90,$ab,$3b,$90,$90,$ab,$90,$88,$88,$83,$0b,$88,$88,$83,$88,
         $46,$46,$ca,$8c,$46,$46,$ca,$46,$ee,$ee,$29,$c7,$ee,$ee,$29,$ee,
         $b8,$b8,$d3,$6b,$b8,$b8,$d3,$b8,$14,$14,$3c,$28,$14,$14,$3c,$14,
         $de,$de,$79,$a7,$de,$de,$79,$de,$5e,$5e,$e2,$bc,$5e,$5e,$e2,$5e,
         $0b,$0b,$1d,$16,$0b,$0b,$1d,$0b,$db,$db,$76,$ad,$db,$db,$76,$db,
         $e0,$e0,$3b,$db,$e0,$e0,$3b,$e0,$32,$32,$56,$64,$32,$32,$56,$32,
         $3a,$3a,$4e,$74,$3a,$3a,$4e,$3a,$0a,$0a,$1e,$14,$0a,$0a,$1e,$0a,
         $49,$49,$db,$92,$49,$49,$db,$49,$06,$06,$0a,$0c,$06,$06,$0a,$06,
         $24,$24,$6c,$48,$24,$24,$6c,$24,$5c,$5c,$e4,$b8,$5c,$5c,$e4,$5c,
         $c2,$c2,$5d,$9f,$c2,$c2,$5d,$c2,$d3,$d3,$6e,$bd,$d3,$d3,$6e,$d3,
         $ac,$ac,$ef,$43,$ac,$ac,$ef,$ac,$62,$62,$a6,$c4,$62,$62,$a6,$62,
         $91,$91,$a8,$39,$91,$91,$a8,$91,$95,$95,$a4,$31,$95,$95,$a4,$95,
         $e4,$e4,$37,$d3,$e4,$e4,$37,$e4,$79,$79,$8b,$f2,$79,$79,$8b,$79,
         $e7,$e7,$32,$d5,$e7,$e7,$32,$e7,$c8,$c8,$43,$8b,$c8,$c8,$43,$c8,
         $37,$37,$59,$6e,$37,$37,$59,$37,$6d,$6d,$b7,$da,$6d,$6d,$b7,$6d,
         $8d,$8d,$8c,$01,$8d,$8d,$8c,$8d,$d5,$d5,$64,$b1,$d5,$d5,$64,$d5,
         $4e,$4e,$d2,$9c,$4e,$4e,$d2,$4e,$a9,$a9,$e0,$49,$a9,$a9,$e0,$a9,
         $6c,$6c,$b4,$d8,$6c,$6c,$b4,$6c,$56,$56,$fa,$ac,$56,$56,$fa,$56,
         $f4,$f4,$07,$f3,$f4,$f4,$07,$f4,$ea,$ea,$25,$cf,$ea,$ea,$25,$ea,
         $65,$65,$af,$ca,$65,$65,$af,$65,$7a,$7a,$8e,$f4,$7a,$7a,$8e,$7a,
         $ae,$ae,$e9,$47,$ae,$ae,$e9,$ae,$08,$08,$18,$10,$08,$08,$18,$08,
         $ba,$ba,$d5,$6f,$ba,$ba,$d5,$ba,$78,$78,$88,$f0,$78,$78,$88,$78,
         $25,$25,$6f,$4a,$25,$25,$6f,$25,$2e,$2e,$72,$5c,$2e,$2e,$72,$2e,
         $1c,$1c,$24,$38,$1c,$1c,$24,$1c,$a6,$a6,$f1,$57,$a6,$a6,$f1,$a6,
         $b4,$b4,$c7,$73,$b4,$b4,$c7,$b4,$c6,$c6,$51,$97,$c6,$c6,$51,$c6,
         $e8,$e8,$23,$cb,$e8,$e8,$23,$e8,$dd,$dd,$7c,$a1,$dd,$dd,$7c,$dd,
         $74,$74,$9c,$e8,$74,$74,$9c,$74,$1f,$1f,$21,$3e,$1f,$1f,$21,$1f,
         $4b,$4b,$dd,$96,$4b,$4b,$dd,$4b,$bd,$bd,$dc,$61,$bd,$bd,$dc,$bd,
         $8b,$8b,$86,$0d,$8b,$8b,$86,$8b,$8a,$8a,$85,$0f,$8a,$8a,$85,$8a,
         $70,$70,$90,$e0,$70,$70,$90,$70,$3e,$3e,$42,$7c,$3e,$3e,$42,$3e,
         $b5,$b5,$c4,$71,$b5,$b5,$c4,$b5,$66,$66,$aa,$cc,$66,$66,$aa,$66,
         $48,$48,$d8,$90,$48,$48,$d8,$48,$03,$03,$05,$06,$03,$03,$05,$03,
         $f6,$f6,$01,$f7,$f6,$f6,$01,$f6,$0e,$0e,$12,$1c,$0e,$0e,$12,$0e,
         $61,$61,$a3,$c2,$61,$61,$a3,$61,$35,$35,$5f,$6a,$35,$35,$5f,$35,
         $57,$57,$f9,$ae,$57,$57,$f9,$57,$b9,$b9,$d0,$69,$b9,$b9,$d0,$b9,
         $86,$86,$91,$17,$86,$86,$91,$86,$c1,$c1,$58,$99,$c1,$c1,$58,$c1,
         $1d,$1d,$27,$3a,$1d,$1d,$27,$1d,$9e,$9e,$b9,$27,$9e,$9e,$b9,$9e,
         $e1,$e1,$38,$d9,$e1,$e1,$38,$e1,$f8,$f8,$13,$eb,$f8,$f8,$13,$f8,
         $98,$98,$b3,$2b,$98,$98,$b3,$98,$11,$11,$33,$22,$11,$11,$33,$11,
         $69,$69,$bb,$d2,$69,$69,$bb,$69,$d9,$d9,$70,$a9,$d9,$d9,$70,$d9,
         $8e,$8e,$89,$07,$8e,$8e,$89,$8e,$94,$94,$a7,$33,$94,$94,$a7,$94,
         $9b,$9b,$b6,$2d,$9b,$9b,$b6,$9b,$1e,$1e,$22,$3c,$1e,$1e,$22,$1e,
         $87,$87,$92,$15,$87,$87,$92,$87,$e9,$e9,$20,$c9,$e9,$e9,$20,$e9,
         $ce,$ce,$49,$87,$ce,$ce,$49,$ce,$55,$55,$ff,$aa,$55,$55,$ff,$55,
         $28,$28,$78,$50,$28,$28,$78,$28,$df,$df,$7a,$a5,$df,$df,$7a,$df,
         $8c,$8c,$8f,$03,$8c,$8c,$8f,$8c,$a1,$a1,$f8,$59,$a1,$a1,$f8,$a1,
         $89,$89,$80,$09,$89,$89,$80,$89,$0d,$0d,$17,$1a,$0d,$0d,$17,$0d,
         $bf,$bf,$da,$65,$bf,$bf,$da,$bf,$e6,$e6,$31,$d7,$e6,$e6,$31,$e6,
         $42,$42,$c6,$84,$42,$42,$c6,$42,$68,$68,$b8,$d0,$68,$68,$b8,$68,
         $41,$41,$c3,$82,$41,$41,$c3,$41,$99,$99,$b0,$29,$99,$99,$b0,$99,
         $2d,$2d,$77,$5a,$2d,$2d,$77,$2d,$0f,$0f,$11,$1e,$0f,$0f,$11,$0f,
         $b0,$b0,$cb,$7b,$b0,$b0,$cb,$b0,$54,$54,$fc,$a8,$54,$54,$fc,$54,
         $bb,$bb,$d6,$6d,$bb,$bb,$d6,$bb,$16,$16,$3a,$2c,$16,$16,$3a,$16);

var
  Te: array[byte] of TEU absolute TCe;

{$ifdef StrictLong}
  {$warnings on}
  {$ifdef RangeChecks_on}
    {$R+}
  {$endif}
{$endif}


