[Setup]                          
AppId={{5A2BC38A-406C-4A5B-BF45-6991F9A05325}
AppName=PeaZip
AppVerName=PeaZip 6.8.1
AppVersion=6.8.1
AppPublisher=Giorgio Tani
AppPublisherURL=http://www.peazip.org
AppSupportURL=http://www.peazip.org
AppUpdatesURL=http://www.peazip.org
DefaultDirName={pf}\PeaZip
DisableDirPage=no
DefaultGroupName=PeaZip
DisableProgramGroupPage=yes
LicenseFile=C:\input\peazip-6.8.1.WINDOWS\copying.txt
OutputDir=C:\output\
OutputBaseFilename=peazip-6.8.1.WINDOWS
SetupIconFile=peazip-icon-green.ico
Compression=lzma2
SolidCompression=yes
ChangesAssociations=yes

[Languages]
Name: "default"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}";
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "C:\input\peazip-6.8.1.WINDOWS\peazip.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "C:\input\peazip-6.8.1.WINDOWS\dragdropfilesdll.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "C:\input\peazip-6.8.1.WINDOWS\res\*"; DestDir: "{app}\res"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "C:\input\peazip-6.8.1.WINDOWS\SendTo.7z"; DestDir: "{app}"; Flags: ignoreversion
Source: "C:\input\peazip-6.8.1.WINDOWS\copying.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "C:\input\peazip-6.8.1.WINDOWS\readme_Win32.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "C:\input\peazip-6.8.1.WINDOWS\peazip_help.pdf"; DestDir: "{app}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[INI]
Filename: "{app}\peazip.url"; Section: "InternetShortcut"; Key: "URL"; String: "http://www.peazip.org"

[Icons]
Name: "{group}\PeaZip"; Filename: "{app}\peazip.exe"
; Name: "{group}\Reset PeaZip"; Filename: "{app}\peazip.exe"; Parameters: "-peazipreset"
Name: "{group}\{cm:ProgramOnTheWeb,PeaZip}"; Filename: "{app}\peazip.url"
Name: "{group}\{cm:UninstallProgram,PeaZip}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\PeaZip"; Filename: "{app}\peazip.exe"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\PeaZip"; Filename: "{app}\peazip.exe"; Tasks: quicklaunchicon

[Run]
;Filename: "{app}\peazip.exe"; Description: "{cm:LaunchProgram,PeaZip}"; Flags: nowait postinstall skipifsilent
;temporarily deactivated since this works correctly (using current user's profile) only for Vista or more recent systems

[InstallDelete]
Type: filesandordirs; Name: "{app}\res\lang"

[UninstallDelete]
Type: files; Name: "{app}\peazip.url"

[CustomMessages]
Associations_Caption=Associations
Associations_Description=Set file associations
Associations_Labelfull1_Caption0=Read/write supported types:
Associations_Labelread1_Caption0=Read supported types:
Associations_cb7z_Caption0=7Z, XZ
Associations_cbbz2_Caption0=BZ2
Associations_cbgz_Caption0=GZ
Associations_cbpaq8_Caption0=*PAQ
Associations_cbquad_Caption0=QUAD/BALZ
Associations_cbtar_Caption0=TAR
Associations_cbzip_Caption0=ZIP, ZIPX
Associations_cbfullnone_Caption0=None of the above group (override selection)
Associations_cbarj_Caption0=ARJ
Associations_cbcab_Caption0=CAB
Associations_cblinux_Caption0=Linux (DEB, RPM, PET/PUP, SLP)
Associations_cbiso_Caption0=ISO, UDF
Associations_cblha_Caption0=LHA
Associations_cblzh_Caption0=LZH
Associations_cbrar_Caption0=RAR
Associations_cbcpio_Caption0=CPIO, Z
Associations_cbreadnone_Caption0=None of the above group (override selection)
Associations_cbace_Caption0=ACE
Associations_cbarc_Caption0=ARC/WRC
Associations_cbMac_Caption0=Mac (DMG/HFS)
context_Caption=Context menu
context_Description=Create application's entries in system's context menu
context_cbcontextext2here_Caption0=Extract here
context_cbcontextsplit_Caption0=Split file
context_cbcontextconvert_Caption0=Convert
context_cbcontextnone_Caption0=No context menu entry (override selection)
context_cbcontextext2folder_Caption0=Extract here (in new folder)
context_cbcontextext2smart_Caption0=Extract here (smart)
context_cbcontext7zs_Caption0=Add to .7Z
context_cbcontextzips_Caption0=Add to .ZIP
context_cbcontexttest_Caption0=Test archive(s)
context_cbcontextwipe_Caption0=Secure delete
context_cbcontextadd2archiveseparate_Caption0=Add to separate archive(s)
context_cbcontextsfx_Caption0=Add to self extracting
context_CheckBox3_Caption0=Add to .7Z, ultra
context_CheckBox4_Caption0=Add to .ZIP, fastest
context_cbcascaded_Caption0=Cascaded menu
context_cbcontextzipmail_Caption0=Zip and mail
context_cbcontextbrowse_Caption0=Browse path with PeaZip
context_cbcontextcrc_Caption0=CRC, hash and file tools
Links_Caption=SendTo
Links_Description=Create application's entries in SendTo menu
Links_cbfunext2here_Caption0=Extract here
Links_cbfun7z_Caption0=Add to .7Z
Links_cbfunzip_Caption0=Add to .ZIP
Links_cbfunsfx_Caption0=Add to self extracting
Links_cbfunsplit_Caption0=Split file
Links_cbfunnone_Caption0=No SendTo menu entry (override selection)
Links_cbfunext2folder_Caption0=Extract here (in new folder)
Links_cbfun7zs_Caption0=Add to separate .7Z
Links_cbfunzips_Caption0=Add to separate .ZIP
Links_cbfunencrypt_Caption0=Encrypt (PEA)
Links_cbfuntest_Caption0=Test archive(s)
Links_cbfunzipmail_Caption0=Add to .ZIP and mail
Links_cbfun7zmail_Caption0=Add to .7Z and mail
Links_cbfunsfxmail_Caption0=Add to sfx and mail
Links_cbfunwipe_Caption0=Secure delete
Links_cbfunext2to_Caption0=Extract...
Links_CheckBoxbrowsepath_Caption0=Browse path with PeaZip
Links_CheckBoxcommand_Caption0=Open command prompt here
Links_cbfunadd_Caption0=Add to archive
Links_cbfunconvert_Caption0=Convert
Links_cbfunopen_Caption0=Open as archive
install_Caption=Install PeaZip
install_Description=Installation options
install_Labelinstall1_Caption0=Default installation, context menu and SendTo menu entries
install_Labelinstall1_Caption2=Configure file associations
install_RadioButtoninstall1_Caption0=Standard installation
install_RadioButtoninstall2_Caption0=Custom installation
install_RadioButtoninstall3_Caption0=No system integration
install_RadioButtoninstall4_Caption0=Update only, keep current system integration
install_cbreset_Caption0=Reset current configuration
install_lupdate_Caption0=Check for updates
install_l1_Caption0=|
install_lhelp_Caption0=Help
install_l2_Caption0=|
install_lfaq_Caption0=FAQ
install_LabelAppLang_Caption0=Application language
 				
[Code]
var
  MyProgChecked: Boolean;
  MyProgCheckResult: Boolean;
  FinishedInstall: Boolean;
  Labelfull1: TLabel;
  Bevel1: TBevel;
  Labelread1: TLabel;
  Bevel2: TBevel;
  cb7z: TCheckBox;
  cbbz2: TCheckBox;
  cbgz: TCheckBox;
  cbpaq8: TCheckBox;
  cbquad: TCheckBox;
  cbtar: TCheckBox;
  cbzip: TCheckBox;
  cbfullnone: TCheckBox;
  cbarj: TCheckBox;
  cbcab: TCheckBox;
  cblinux: TCheckBox;
  cbiso: TCheckBox;
  cblha: TCheckBox;
  cblzh: TCheckBox;
  cbrar: TCheckBox;
  cbcpio: TCheckBox;
  cbreadnone: TCheckBox;
	cbace: TCheckBox;
	cbarc: TCheckBox;
	cbMac: TCheckBox;
  Bevel1context: TBevel;
  cbcontextext2here: TCheckBox;
  cbcontextsplit: TCheckBox;
  cbcontextconvert: TCheckBox;
  cbcontextnone: TCheckBox;
  cbcontextext2folder: TCheckBox;
  cbcontextext2smart: TCheckBox;
  cbcontext7zs: TCheckBox;
  cbcontextzips: TCheckBox;
  cbcontexttest: TCheckBox;
  cbcontextwipe: TCheckBox;
  cbcontextadd2archiveseparate: TCheckBox;
  cbcontextsfx: TCheckBox;
  CheckBox3: TCheckBox;
  CheckBox4: TCheckBox;
  cbcascaded: TCheckBox;
  cbcontextzipmail: TCheckBox;
  cbcontextbrowse: TCheckBox;
  cbcontextcrc: TCheckBox;
  Bevel1fun: TBevel;
  cbfunext2here: TCheckBox;
  cbfun7z: TCheckBox;
  cbfunzip: TCheckBox;
  cbfunsfx: TCheckBox;
  cbfunsplit: TCheckBox;
  cbfunnone: TCheckBox;
  cbfunext2folder: TCheckBox;
  cbfun7zs: TCheckBox;
  cbfunzips: TCheckBox;
  cbfunencrypt: TCheckBox;
  cbfuntest: TCheckBox;
  cbfunzipmail: TCheckBox;
  cbfun7zmail: TCheckBox;
  cbfunsfxmail: TCheckBox;
  cbfunwipe: TCheckBox;
  cbfunext2to: TCheckBox;
  CheckBoxbrowsepath: TCheckBox;
  CheckBoxcommand: TCheckBox;
  cbfunadd: TCheckBox;
  cbfunconvert: TCheckBox;
  cbfunopen: TCheckBox;
  Labelinstall1: TLabel;
  RadioButtoninstall1: TRadioButton;
  RadioButtoninstall2: TRadioButton;
  RadioButtoninstall3: TRadioButton;
  RadioButtoninstall4: TRadioButton;
  LabelAppLang: TLabel;
  ComboBox1: TComboBox;
  cbreset: TCheckbox;
  lupdate: TLabel;
  l1: TLabel;
  lhelp: TLabel;
  l2: TLabel;
  lfaq: TLabel;

{ install_Activate }

procedure install_Activate(Page: TWizardPage);
begin
  // enter code here...
end;

{ install_ShouldSkipPage }

function install_ShouldSkipPage(Page: TWizardPage): Boolean;
begin
  Result := False;
end;

{ install_BackButtonClick }

function install_BackButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ install_NextkButtonClick }

function install_NextButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ install_CancelButtonClick }

procedure install_CancelButtonClick(Page: TWizardPage; var Cancel, Confirm: Boolean);
begin
  // enter code here...
end;

procedure install_lupdateClick(Sender: TObject);
var
  ErrorCode: Integer;
begin
   ShellExecAsOriginalUser('open', 'http://www.peazip.org', '', '', SW_SHOW, ewNoWait, ErrorCode);
end;

procedure install_lhelpClick(Sender: TObject);
var
  ErrorCode: Integer;
begin
   ShellExecAsOriginalUser('open', 'http://www.peazip.org/peazip-help.html', '', '', SW_SHOW, ewNoWait, ErrorCode)
end;

procedure install_lfaqClick(Sender: TObject);
var
  ErrorCode: Integer;
begin
   ShellExecAsOriginalUser('open', 'http://www.peazip.org/peazip-help-faq.html', '', '', SW_SHOW, ewNoWait, ErrorCode)
end;

{ install_CreatePage }

function install_CreatePage(PreviousPageId: Integer): Integer;
var
  Page: TWizardPage;
begin
  Page := CreateCustomPage(
    PreviousPageId,
    ExpandConstant('{cm:install_Caption}'),
	  ExpandConstant('{cm:install_Description}')
  );

{ Labelinstall1 }
  Labelinstall1 := TLabel.Create(Page);
  with Labelinstall1 do
  begin
    Parent := Page.Surface;
    Caption :=
      ExpandConstant('{cm:install_Labelinstall1_Caption0}') + #13 +
      ExpandConstant('{cm:install_Labelinstall1_Caption2}');
    Left := ScaleX(32);
    Top := ScaleY(26);
    Width := ScaleX(363);
    Height := ScaleY(64);
  end;

  { RadioButtoninstall1 }
  RadioButtoninstall1 := TRadioButton.Create(Page);
  with RadioButtoninstall1 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_RadioButtoninstall1_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(0);
    Width := ScaleX(385);
    Height := ScaleY(25);
    Checked := True;
    TabOrder := 0;
    TabStop := True;
  end;

  { RadioButtoninstall2 }
  RadioButtoninstall2 := TRadioButton.Create(Page);
  with RadioButtoninstall2 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_RadioButtoninstall2_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(60);
    Width := ScaleX(385);
    Height := ScaleY(25);
    TabOrder := 1;
    TabStop := True;
  end;

  { RadioButtoninstall3 }
  RadioButtoninstall3 := TRadioButton.Create(Page);
  with RadioButtoninstall3 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_RadioButtoninstall3_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(80);
    Width := ScaleX(385);
    Height := ScaleY(25);
    TabOrder := 2;
    TabStop := True;
  end;

  { RadioButtoninstall4 }
  RadioButtoninstall4 := TRadioButton.Create(Page);
  with RadioButtoninstall4 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_RadioButtoninstall4_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(100);
    Width := ScaleX(385);
    Height := ScaleY(25);
    TabOrder := 3;
    TabStop := True;
  end;

  { LabelAppLang }
  LabelAppLang := TLabel.Create(Page);
  with LabelAppLang do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_LabelAppLang_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(153);
    Width := ScaleX(99);
    Height := ScaleY(13);
  end;
  if (GetWindowsVersion < $06000000) then LabelAppLang.visible:=false;
  
  { ComboBox1 }
  ComboBox1 := TComboBox.Create(Page);
  with ComboBox1 do
  begin
    Parent := Page.Surface;
    Left := ScaleX(128);
    Top := ScaleY(150);
    Width := ScaleX(200);
    Height := ScaleY(21);
    TabOrder := 4;
    Style := csDropDownList;
    Text := 'EN - English';
    Items.Add('AR - Arabic');
    Items.Add('BG - Bulgarian');
    Items.Add('BY-CR - Belarusian (Cyrillic)');
    Items.Add('BY-LT - Belarusian (Latin)');
    Items.Add('CHS - Chinese Simplified');
    Items.Add('CHT - Chinese Traditional');
    Items.Add('CZ - Czech');
    Items.Add('DE-UML - German');
    Items.Add('DE-UML-ALT - German (alternative)');
    Items.Add('EN - English');
    Items.Add('EN-GB - British English');
    Items.Add('ES-ES - Spanish');
    Items.Add('ES-LA - Spanish (Latin-America)');
    Items.Add('EU - Basque');
    Items.Add('FI - Finnish');
    Items.Add('FR - French');
    Items.Add('GL - Galician');
    Items.Add('GR - Greek');
    Items.Add('HU - Hungarian');
    Items.Add('ID - Bahasa Indonesia');
    Items.Add('IT - Italian');
    Items.Add('JA - Japanese');
    Items.Add('KO - Korean');
    Items.Add('NL - Dutch');
    Items.Add('NO - Norwegian');
    Items.Add('PL - Polish');
    Items.Add('PT-BR - Portuguese (Brazil)');
    Items.Add('PT-PT - Portuguese (Portugal)');
    Items.Add('RO - Romanian');
    Items.Add('RU - Russian');
    Items.Add('SI - Sinhala');
    Items.Add('SK - Slovak');
    Items.Add('SL - Slovenian');
    Items.Add('SV - Swedish');
    Items.Add('TJ - Tajik');
    Items.Add('TR - Turkish');
    Items.Add('UK - Ukrainian');
    Items.Add('UZ - Uzbek');
    Items.Add('VN - Vietnamese');
    ItemIndex := 9;
  end;
  if (GetWindowsVersion < $06000000) then ComboBox1.visible:=false;

  { cbreset }
  cbreset := Tcheckbox.Create(Page);
  with cbreset do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_cbreset_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(203);
    Width := ScaleX(160);
    Height := ScaleY(25);
  end;  
  if (GetWindowsVersion < $06000000) then cbreset.visible:=false;

  { lupdate }
  lupdate := TLabel.Create(Page);
  with lupdate do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_lupdate_Caption0}');
    Left := ScaleX(220);
    Top := ScaleY(208);
    Width := ScaleX(88);
    Height := ScaleY(13);
    Cursor := crHand;
    Font.Color := 16711680;
    Font.Height := ScaleY(-11);
    Font.Name := 'Tahoma';
    Font.Style := [fsUnderline];
    OnClick := @install_lupdateClick;
  end;

  { l1 }
  l1 := TLabel.Create(Page);
  with l1 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_l1_Caption0}');
    Left := ScaleX(316);
    Top := ScaleY(208);
    Width := ScaleX(4);
    Height := ScaleY(13);
    Font.Height := ScaleY(-11);
    Font.Name := 'Tahoma';
  end;

  { lhelp }
  lhelp := TLabel.Create(Page);
  with lhelp do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_lhelp_Caption0}');
    Left := ScaleX(328);
    Top := ScaleY(208);
    Width := ScaleX(21);
    Height := ScaleY(13);
    Cursor := crHand;
    Font.Color := 16711680;
    Font.Height := ScaleY(-11);
    Font.Name := 'Tahoma';
    Font.Style := [fsUnderline];
    OnClick := @install_lhelpClick;
  end;

  { l2 }
  l2 := TLabel.Create(Page);
  with l2 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_l2_Caption0}');
    Left := ScaleX(357);
    Top := ScaleY(208);
    Width := ScaleX(4);
    Height := ScaleY(13);
    Font.Height := ScaleY(-11);
    Font.Name := 'Tahoma';
  end;

  { lfaq }
  lfaq := TLabel.Create(Page);
  with lfaq do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:install_lfaq_Caption0}');
    Left := ScaleX(369);
    Top := ScaleY(208);
    Width := ScaleX(21);
    Height := ScaleY(13);
    Cursor := crHand;
    Font.Color := 16711680;
    Font.Height := ScaleY(-11);
    Font.Name := 'Tahoma';
    Font.Style := [fsUnderline];
    OnClick := @install_lfaqClick;
  end;

  with Page do
  begin
    OnActivate := @install_Activate;
    OnShouldSkipPage := @install_ShouldSkipPage;
    OnBackButtonClick := @install_BackButtonClick;
    OnNextButtonClick := @install_NextButtonClick;
    OnCancelButtonClick := @install_CancelButtonClick;
  end;

  Result := Page.ID;
end;       				
				
				{ Associations_Activate }
				
				procedure Associations_Activate(Page: TWizardPage);
				begin
				  // enter code here...
				end;
				
				{ Associations_ShouldSkipPage }
				
				function Associations_ShouldSkipPage(Page: TWizardPage): Boolean;
				begin
				  if (radiobuttoninstall3.Checked = True) or (radiobuttoninstall4.Checked = True) then Result := True
          else Result := False;
				end;
				
				{ Associations_BackButtonClick }
				
				function Associations_BackButtonClick(Page: TWizardPage): Boolean;
				begin
				  Result := True;
				end;
				
				{ Associations_NextkButtonClick }
				
				function Associations_NextButtonClick(Page: TWizardPage): Boolean;
				begin
				  Result := True;
				end;
				
				{ Associations_CancelButtonClick }
				
				procedure Associations_CancelButtonClick(Page: TWizardPage; var Cancel, Confirm: Boolean);
				begin
				  // enter code here...
				end;
				
				{ Associations_CreatePage }
				
				function Associations_CreatePage(PreviousPageId: Integer): Integer;
				var
				  Page: TWizardPage;
				begin
				  Page := CreateCustomPage(
				    PreviousPageId,
				    ExpandConstant('{cm:Associations_Caption}'),
				    ExpandConstant('{cm:Associations_Description}')
				  );
				
{ Labelfull1 }
Labelfull1 := TLabel.Create(Page);
with Labelfull1 do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_Labelfull1_Caption0}');
  Left := ScaleX(0);
  Top := ScaleY(0);
  Width := ScaleX(163);
  Height := ScaleY(13);
  Font.Color := -16777208;
  Font.Height := ScaleY(-11);
  Font.Name := 'Tahoma';
  Font.Style := [fsBold];
  WordWrap := True;
end;

{ Bevel1 }
Bevel1 := TBevel.Create(Page);
with Bevel1 do
begin
  Parent := Page.Surface;
  Left := ScaleX(8);
  Top := ScaleY(20);
  Width := ScaleX(396);
  Height := ScaleY(52);
end;

{ Labelread1 }
Labelread1 := TLabel.Create(Page);
with Labelread1 do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_Labelread1_Caption0}');
  Left := ScaleX(0);
  Top := ScaleY(112);
  Width := ScaleX(128);
  Height := ScaleY(13);
  Font.Color := -16777208;
  Font.Height := ScaleY(-11);
  Font.Name := 'Tahoma';
  Font.Style := [fsBold];
  WordWrap := True;
end;

{ Bevel2 }
Bevel2 := TBevel.Create(Page);
with Bevel2 do
begin
  Parent := Page.Surface;
  Left := ScaleX(8);
  Top := ScaleY(132);
  Width := ScaleX(396);
  Height := ScaleY(78);
end;

{ cb7z }
cb7z := TCheckBox.Create(Page);
with cb7z do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cb7z_Caption0}');
  Left := ScaleX(16);
  Top := ScaleY(24);
  Width := ScaleX(81);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 2;
end;

{ cbbz2 }
cbbz2 := TCheckBox.Create(Page);
with cbbz2 do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbbz2_Caption0}');
  Left := ScaleX(216);
  Top := ScaleY(24);
  Width := ScaleX(73);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 4;
end;

{ cbgz }
cbgz := TCheckBox.Create(Page);
with cbgz do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbgz_Caption0}');
  Left := ScaleX(316);
  Top := ScaleY(24);
  Width := ScaleX(81);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 5;
end;

{ cbpaq8 }
cbpaq8 := TCheckBox.Create(Page);
with cbpaq8 do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbpaq8_Caption0}');
  Left := ScaleX(16);
  Top := ScaleY(48);
  Width := ScaleX(81);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 6;
end;

{ cbquad }
cbquad := TCheckBox.Create(Page);
with cbquad do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbquad_Caption0}');
  Left := ScaleX(116);
  Top := ScaleY(48);
  Width := ScaleX(73);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 7;
end;

{ cbtar }
cbtar := TCheckBox.Create(Page);
with cbtar do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbtar_Caption0}');
  Left := ScaleX(216);
  Top := ScaleY(48);
  Width := ScaleX(73);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 8;
end;

{ cbzip }
cbzip := TCheckBox.Create(Page);
with cbzip do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbzip_Caption0}');
  Left := ScaleX(316);
  Top := ScaleY(48);
  Width := ScaleX(81);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 9;
end;

{ cbfullnone }
cbfullnone := TCheckBox.Create(Page);
with cbfullnone do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbfullnone_Caption0}');
  Left := ScaleX(8);
  Top := ScaleY(74);
  Width := ScaleX(321);
  Height := ScaleY(25);
  TabOrder := 0;
end;

{ cbarj }
cbarj := TCheckBox.Create(Page);
with cbarj do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbarj_Caption0}');
  Left := ScaleX(116);
  Top := ScaleY(136);
  Width := ScaleX(81);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 11;
end;

{ cbcab }
cbcab := TCheckBox.Create(Page);
with cbcab do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbcab_Caption0}');
  Left := ScaleX(216);
  Top := ScaleY(136);
  Width := ScaleX(73);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 12;
end;

{ cblinux }
cblinux := TCheckBox.Create(Page);
with cblinux do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cblinux_Caption0}');
  Left := ScaleX(16);
  Top := ScaleY(184);
  Width := ScaleX(200);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 18;
end;

{ cbiso }
cbiso := TCheckBox.Create(Page);
with cbiso do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbiso_Caption0}');
  Left := ScaleX(16);
  Top := ScaleY(160);
  Width := ScaleX(81);
  Height := ScaleY(17);
  TabOrder := 14;
end;

{ cblha }
cblha := TCheckBox.Create(Page);
with cblha do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cblha_Caption0}');
  Left := ScaleX(116);
  Top := ScaleY(160);
  Width := ScaleX(73);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 15;
end;

{ cblzh }
cblzh := TCheckBox.Create(Page);
with cblzh do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cblzh_Caption0}');
  Left := ScaleX(216);
  Top := ScaleY(160);
  Width := ScaleX(73);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 16;
end;

{ cbrar }
cbrar := TCheckBox.Create(Page);
with cbrar do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbrar_Caption0}');
  Left := ScaleX(316);
  Top := ScaleY(160);
  Width := ScaleX(81);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 17;
end;

{ cbcpio }
cbcpio := TCheckBox.Create(Page);
with cbcpio do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbcpio_Caption0}');
  Left := ScaleX(316);
  Top := ScaleY(136);
  Width := ScaleX(73);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 13;
end;

{ cbreadnone }
cbreadnone := TCheckBox.Create(Page);
with cbreadnone do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbreadnone_Caption0}');
  Left := ScaleX(8);
  Top := ScaleY(210);
  Width := ScaleX(329);
  Height := ScaleY(25);
  TabOrder := 1;
end;

{ cbace }
cbace := TCheckBox.Create(Page);
with cbace do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbace_Caption0}');
  Left := ScaleX(16);
  Top := ScaleY(136);
  Width := ScaleX(81);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 10;
end;

{ cbarc }
cbarc := TCheckBox.Create(Page);
with cbarc do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbarc_Caption0}');
  Left := ScaleX(116);
  Top := ScaleY(24);
  Width := ScaleX(73);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 3;
end;

{ cbMac }
cbMac := TCheckBox.Create(Page);
with cbMac do
begin
  Parent := Page.Surface;
  Caption := ExpandConstant('{cm:Associations_cbMac_Caption0}');
  Left := ScaleX(216);
  Top := ScaleY(184);
  Width := ScaleX(200);
  Height := ScaleY(17);
  Checked := True;
  State := cbChecked;
  TabOrder := 19;
end;
				
				  with Page do
				  begin
				    OnActivate := @Associations_Activate;
				    OnShouldSkipPage := @Associations_ShouldSkipPage;
				    OnBackButtonClick := @Associations_BackButtonClick;
				    OnNextButtonClick := @Associations_NextButtonClick;
				    OnCancelButtonClick := @Associations_CancelButtonClick;
				  end;
				
				  Result := Page.ID;
				end;
				
{ context_Activate }

procedure context_Activate(Page: TWizardPage);
begin
  // enter code here...
end;

{ context_ShouldSkipPage }

function context_ShouldSkipPage(Page: TWizardPage): Boolean;
begin
	if (radiobuttoninstall1.Checked = True) or (radiobuttoninstall3.Checked = True) or (radiobuttoninstall4.Checked = True) then Result := True
  else Result := False;
end;

{ context_BackButtonClick }

function context_BackButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ context_NextkButtonClick }

function context_NextButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ context_CancelButtonClick }

procedure context_CancelButtonClick(Page: TWizardPage; var Cancel, Confirm: Boolean);
begin
  // enter code here...
end;

{ context_CreatePage }

function context_CreatePage(PreviousPageId: Integer): Integer;
var
  Page: TWizardPage;
begin
  Page := CreateCustomPage(
    PreviousPageId,
    ExpandConstant('{cm:context_Caption}'),
    ExpandConstant('{cm:context_Description}')
  );

{ Bevel1context }
  Bevel1context := TBevel.Create(Page);
  with Bevel1context do
  begin
    Parent := Page.Surface;
    Left := ScaleX(8);
    Top := ScaleY(2);
    Width := ScaleX(396);
    Height := ScaleY(210);
  end;
  
  { cbcontextext2here }
  cbcontextext2here := TCheckBox.Create(Page);
  with cbcontextext2here do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextext2here_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(48);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 7;
  end;
  
  { cbcontextsplit }
  cbcontextsplit := TCheckBox.Create(Page);
  with cbcontextsplit do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextsplit_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(148);
    Width := ScaleX(177);
    Height := ScaleY(17);
    TabOrder := 6;
  end;

  { cbcontextconvert }
  cbcontextconvert := TCheckBox.Create(Page);
  with cbcontextconvert do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextconvert_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(168);
    Width := ScaleX(177);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 7;
  end;
  
  { cbcontextnone }
  cbcontextnone := TCheckBox.Create(Page);
  with cbcontextnone do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextnone_Caption0}');
    Left := ScaleX(8);
    Top := ScaleY(214);
    Width := ScaleX(240);
    Height := ScaleY(17);
    TabOrder := 0;
  end;
  
  { cbcontextext2folder }
  cbcontextext2folder := TCheckBox.Create(Page);
  with cbcontextext2folder do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextext2folder_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(88);
    Width := ScaleX(177);
    Height := ScaleY(17);
    TabOrder := 9;
  end;

  { cbcontextext2smart }
  cbcontextext2smart := TCheckBox.Create(Page);
  with cbcontextext2smart do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextext2smart_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(68);
    Width := ScaleX(177);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 8;
  end;
  
  { cbcontext7zs }
  cbcontext7zs := TCheckBox.Create(Page);
  with cbcontext7zs do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontext7zs_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(48);
    Width := ScaleX(169);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 2;
  end;
  
  { cbcontextzips }
  cbcontextzips := TCheckBox.Create(Page);
  with cbcontextzips do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextzips_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(88);
    Width := ScaleX(169);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 3;
  end;
  
  { cbcontexttest }
  cbcontexttest := TCheckBox.Create(Page);
  with cbcontexttest do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontexttest_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(108);
    Width := ScaleX(185);
    Height := ScaleY(17);
    TabOrder := 10;
  end;
  
  { cbcontextwipe }
  cbcontextwipe := TCheckBox.Create(Page);
  with cbcontextwipe do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextwipe_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(8);
    Width := ScaleX(177);
    Height := ScaleY(17);
    TabOrder := 5;
  end;
  
  { cbcontextadd2archiveseparate }
  cbcontextadd2archiveseparate := TCheckBox.Create(Page);
  with cbcontextadd2archiveseparate do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextadd2archiveseparate_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(8);
    Width := ScaleX(169);
    Height := ScaleY(17);
    TabOrder := 1;
  end;
  
  { cbcontextsfx }
  cbcontextsfx := TCheckBox.Create(Page);
  with cbcontextsfx do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextsfx_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(28);
    Width := ScaleX(169);
    Height := ScaleY(17);
    TabOrder := 4;
  end;

  { CheckBox3 }
  CheckBox3 := TCheckBox.Create(Page);
  with CheckBox3 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_CheckBox3_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(68);
    Width := ScaleX(169);
    Height := ScaleY(17);
    TabOrder := 11;
  end;
  
  { CheckBox4 }
  CheckBox4 := TCheckBox.Create(Page);
  with CheckBox4 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_CheckBox4_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(108);
    Width := ScaleX(169);
    Height := ScaleY(17);
    TabOrder := 12;
  end;

  { cbcontextzipmail }
  cbcontextzipmail := TCheckBox.Create(Page);
  with cbcontextzipmail do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextzipmail_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(128);
    Width := ScaleX(169);
    Height := ScaleY(17);
    TabOrder := 15;
  end;

  { cbcontextbrowse }
  cbcontextbrowse := TCheckBox.Create(Page);
  with cbcontextbrowse do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextbrowse_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(148);
    Width := ScaleX(169);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 16;
  end;

  { cbcontextcrc }
  cbcontextcrc := TCheckBox.Create(Page);
  with cbcontextcrc do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextcrc_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(168);
    Width := ScaleX(169);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 17;
  end;
  
  { cbcascaded }
  cbcascaded := TCheckBox.Create(Page);
  with cbcascaded do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcascaded_Caption0}');
    Left := ScaleX(260);
    Top := ScaleY(214);
    Width := ScaleX(185);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 14;
  end;
  if (GetWindowsVersion <= $06000000) then cbcascaded.visible:=false;

  with Page do
  begin
    OnActivate := @context_Activate;
    OnShouldSkipPage := @context_ShouldSkipPage;
    OnBackButtonClick := @context_BackButtonClick;
    OnNextButtonClick := @context_NextButtonClick;
    OnCancelButtonClick := @context_CancelButtonClick;
  end;

  Result := Page.ID;
end;
    
{ Links_Activate }

procedure Links_Activate(Page: TWizardPage);
begin
  // enter code here...
end;

{ Links_ShouldSkipPage }

function Links_ShouldSkipPage(Page: TWizardPage): Boolean;
begin
if (radiobuttoninstall1.Checked = True) or (radiobuttoninstall3.Checked = True) or (radiobuttoninstall4.Checked = True) then Result := True
else Result := False;
end;

{ Links_BackButtonClick }

function Links_BackButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ Links_NextkButtonClick }

function Links_NextButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ Links_CancelButtonClick }

procedure Links_CancelButtonClick(Page: TWizardPage; var Cancel, Confirm: Boolean);
begin
  // enter code here...
end;

{ Links_CreatePage }

function Links_CreatePage(PreviousPageId: Integer): Integer;
var
  Page: TWizardPage;
begin
  Page := CreateCustomPage(
    PreviousPageId,
    ExpandConstant('{cm:Links_Caption}'),
    ExpandConstant('{cm:Links_Description}')
  );

{ Bevel1fun }
  Bevel1fun := TBevel.Create(Page);
  with Bevel1fun do
  begin
    Parent := Page.Surface;
    Left := ScaleX(8);
    Top := ScaleY(2);
    Width := ScaleX(396);
    Height := ScaleY(210);
  end;
  
  { cbfunext2here }
  cbfunext2here := TCheckBox.Create(Page);
  with cbfunext2here do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunext2here_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(48);
    Width := ScaleX(177);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 12;
  end;
  
  { cbfun7z }
  cbfun7z := TCheckBox.Create(Page);
  with cbfun7z do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfun7z_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(28);
    Width := ScaleX(169);
    Height := ScaleY(17);
    TabOrder := 2;
  end;
  
  { cbfunzip }
  cbfunzip := TCheckBox.Create(Page);
  with cbfunzip do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunzip_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(88);
    Width := ScaleX(177);
    Height := ScaleY(17);
    TabOrder := 5;
  end;
  
  { cbfunsfx }
  cbfunsfx := TCheckBox.Create(Page);
  with cbfunsfx do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunsfx_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(148);
    Width := ScaleX(177);
    Height := ScaleY(17);
    TabOrder := 8;
  end;
  
  { cbfunsplit }
  cbfunsplit := TCheckBox.Create(Page);
  with cbfunsplit do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunsplit_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(168);
    Width := ScaleX(177);
    Height := ScaleY(17);
    TabOrder := 19;
  end;

    { cbfunconvert }
  cbfunconvert := TCheckBox.Create(Page);
  with cbfunconvert do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunconvert_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(188);
    Width := ScaleX(169);
    Height := ScaleY(17);
    TabOrder := 20;
  end;
  
  { cbfunnone }
  cbfunnone := TCheckBox.Create(Page);
  with cbfunnone do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunnone_Caption0}');
    Left := ScaleX(8);
    Top := ScaleY(214);
    Width := ScaleX(321);
    Height := ScaleY(17);
    TabOrder := 0;
  end;
  
  { cbfunext2folder }
  cbfunext2folder := TCheckBox.Create(Page);
  with cbfunext2folder do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunext2folder_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(68);
    Width := ScaleX(180);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 13;
  end;
  
  { cbfun7zs }
  cbfun7zs := TCheckBox.Create(Page);
  with cbfun7zs do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfun7zs_Caption0}');
    Left := ScaleX(32);
    Top := ScaleY(48);
    Width := ScaleX(161);
    Height := ScaleY(17);
    TabOrder := 3;
  end;
  
  { cbfunzips }
  cbfunzips := TCheckBox.Create(Page);
  with cbfunzips do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunzips_Caption0}');
    Left := ScaleX(32);
    Top := ScaleY(108);
    Width := ScaleX(153);
    Height := ScaleY(17);
    TabOrder := 6;
  end;
  
  { cbfunencrypt }
  cbfunencrypt := TCheckBox.Create(Page);
  with cbfunencrypt do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunencrypt_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(188);
    Width := ScaleX(169);
    Height := ScaleY(17);
    TabOrder := 10;
  end;
  
  { cbfuntest }
  cbfuntest := TCheckBox.Create(Page);
  with cbfuntest do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfuntest_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(108);
    Width := ScaleX(185);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 15;
  end;
  
  { cbfunzipmail }
  cbfunzipmail := TCheckBox.Create(Page);
  with cbfunzipmail do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunzipmail_Caption0}');
    Left := ScaleX(32);
    Top := ScaleY(128);
    Width := ScaleX(153);
    Height := ScaleY(17);
    TabOrder := 7;
  end;
  
  { cbfun7zmail }
  cbfun7zmail := TCheckBox.Create(Page);
  with cbfun7zmail do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfun7zmail_Caption0}');
    Left := ScaleX(32);
    Top := ScaleY(68);
    Width := ScaleX(161);
    Height := ScaleY(17);
    TabOrder := 4;
  end;
  
  { cbfunsfxmail }
  cbfunsfxmail := TCheckBox.Create(Page);
  with cbfunsfxmail do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunsfxmail_Caption0}');
    Left := ScaleX(32);
    Top := ScaleY(168);
    Width := ScaleX(161);
    Height := ScaleY(17);
    TabOrder := 9;
  end;
  
  { cbfunwipe }
  cbfunwipe := TCheckBox.Create(Page);
  with cbfunwipe do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunwipe_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(148);
    Width := ScaleX(169);
    Height := ScaleY(17);
    TabOrder := 18;
  end;
  
  { cbfunext2to }
  cbfunext2to := TCheckBox.Create(Page);
  with cbfunext2to do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunext2to_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(88);
    Width := ScaleX(177);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 14;
  end;
  
  { CheckBoxbrowsepath }
  CheckBoxbrowsepath := TCheckBox.Create(Page);
  with CheckBoxbrowsepath do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_CheckBoxbrowsepath_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(8);
    Width := ScaleX(177);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 16;
  end;
  
  { CheckBoxcommand }
  CheckBoxcommand := TCheckBox.Create(Page);
  with CheckBoxcommand do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_CheckBoxcommand_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(128);
    Width := ScaleX(177);
    Height := ScaleY(17);
    TabOrder := 17;
  end;
  
  { cbfunadd }
  cbfunadd := TCheckBox.Create(Page);
  with cbfunadd do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunadd_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(8);
    Width := ScaleX(169);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 1;
  end;
  
  { cbfunopen }
  cbfunopen := TCheckBox.Create(Page);
  with cbfunopen do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Links_cbfunopen_Caption0}');
    Left := ScaleX(208);
    Top := ScaleY(28);
    Width := ScaleX(169);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 11;
  end;

  with Page do
  begin
    OnActivate := @Links_Activate;
    OnShouldSkipPage := @Links_ShouldSkipPage;
    OnBackButtonClick := @Links_BackButtonClick;
    OnNextButtonClick := @Links_NextButtonClick;
    OnCancelButtonClick := @Links_CancelButtonClick;
  end;

  Result := Page.ID;
end;
				
				{ InitializeWizard }
				
				procedure InitializeWizard();
				begin		
          Associations_CreatePage(wpSelectDir);//InfoBefore);
				  Links_CreatePage(wpSelectDir);
				  context_CreatePage(wpSelectDir);
				  install_CreatePage(wpInfoBefore);//(wpWelcome);
				end;

function shouldskippage(CurPageID: Integer): Boolean;
begin
if (radiobuttoninstall1.Checked = True) or (radiobuttoninstall4.Checked = True) then
   begin
   if curpageid=wpSelectDir then Result := True;
	 if curpageid=wpSelectTasks then Result := True;
	 end;
end;

procedure clearlinks;
begin
deletefile(expandconstant('{sendto}')+'\Add to archive.lnk');
deletefile(expandconstant('{sendto}')+'\Convert.lnk');
deletefile(expandconstant('{sendto}')+'\Add to .7Z.lnk');
deletefile(expandconstant('{sendto}')+'\Add to .7Z and send by mail.lnk');
deletefile(expandconstant('{sendto}')+'\Add to separate .7Z.lnk');
deletefile(expandconstant('{sendto}')+'\Add to .ZIP.lnk');
deletefile(expandconstant('{sendto}')+'\Add to .ZIP and send by mail.lnk');
deletefile(expandconstant('{sendto}')+'\Add to separate .ZIP.lnk');
deletefile(expandconstant('{sendto}')+'\Add to self-extracting archive.lnk');
deletefile(expandconstant('{sendto}')+'\Add to sfx and send by mail.lnk');
deletefile(expandconstant('{sendto}')+'\Encrypt.lnk');
deletefile(expandconstant('{sendto}')+'\Split file.lnk');
deletefile(expandconstant('{sendto}')+'\Secure delete.lnk');
deletefile(expandconstant('{sendto}')+'\Extract here.lnk');
deletefile(expandconstant('{sendto}')+'\Extract....lnk');
deletefile(expandconstant('{sendto}')+'\Extract here (in new folder).lnk');
deletefile(expandconstant('{sendto}')+'\Open with PeaZip.lnk');
deletefile(expandconstant('{sendto}')+'\Test archive(s).lnk');
deletefile(expandconstant('{sendto}')+'\Open as archive.lnk');
deletefile(expandconstant('{sendto}')+'\Browse path with PeaZip.lnk');
deletefile(expandconstant('{sendto}')+'\Open command prompt here.lnk');
end;

procedure clearcontextlegacy;
begin
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to archive');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to .7Z');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to .7Z, fastest');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to .7Z, normal');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to .7Z, ultra');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to .ZIP');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to .ZIP, fastest');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to .ZIP, normal');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to .ZIP, ultra');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Zip and mail');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to self-extracting archive');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to separate archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to separate .7Z');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Add to separate .ZIP');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Open as archive');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Browse path with PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Split file');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Convert');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Secure delete');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\CRC, hash and file tools');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Extract here (smart)');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to archive');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to .7Z');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to .7Z, fastest');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to .7Z, normal');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to .7Z, ultra');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to .ZIP');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to .ZIP, fastest');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to .ZIP, normal');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to .ZIP, ultra');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Zip and mail');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to self-extracting archive');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to separate archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to separate .7Z');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Add to separate .ZIP');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Browse path with PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Split file');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Convert');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Secure delete');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\CRC, hash and file tools');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\Extract...');
//legacy versions
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to archive');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to .7Z');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to .7Z, fastest');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to .7Z, normal');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to .7Z, ultra');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to .ZIP');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to .ZIP, fastest');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to .ZIP, normal');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to .ZIP, ultra');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Zip and mail');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to self-extracting archive');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to separate archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to separate .7Z');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Add to separate .ZIP');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Browse path with PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Split file');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\Secure delete');
RegDeleteKeyIncludingSubkeys(HKCR, 'PEA\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'PEA\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PEA\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, '001\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, '001\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, '001\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, '7Z\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'XZ\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARC\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'WRC\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'BZ2\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'GZ\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ1\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ5\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ8\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8F\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8JD\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8L\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8O\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZPAQ\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'QUAD\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'BALZ\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'TAR\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'TGZ\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZIP\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'ACE\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARJ\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'CAB\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'CPIO\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'DEB\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'DMG\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'HFS\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'ISO\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'UDF\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'LHA\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'LZH\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'PET\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'PUP\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'RAR\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'RPM\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'SLP\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, 'Z\shell\Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, '7Z\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'XZ\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARC\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'WRC\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'BZ2\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'GZ\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ1\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ5\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ8\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8F\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8JD\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8L\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8O\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZPAQ\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'QUAD\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'BALZ\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'TAR\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'TGZ\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZIP\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ACE\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARJ\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'CAB\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'CPIO\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'DEB\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'DMG\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'HFS\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ISO\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'UDF\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LHA\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LZH\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PET\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PUP\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'RAR\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'RPM\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'SLP\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, 'Z\shell\Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, '7Z\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'XZ\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARC\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'WRC\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'BZ2\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'GZ\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ1\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ5\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ8\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8F\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8JD\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8L\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8O\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZPAQ\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'QUAD\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'BALZ\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'TAR\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'TGZ\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZIP\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'ACE\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARJ\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'CAB\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'CPIO\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'DEB\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'DMG\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'HFS\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'ISO\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'UDF\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'LHA\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'LZH\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'PET\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'PUP\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'RAR\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'RPM\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'SLP\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, 'Z\shell\Extract...');
RegDeleteKeyIncludingSubkeys(HKCR, '7Z\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'XZ\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARC\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'WRC\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'BZ2\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'GZ\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ1\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ5\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ8\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8F\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8JD\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8L\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8O\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZPAQ\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'QUAD\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'BALZ\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'TAR\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'TGZ\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZIP\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ACE\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARJ\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'CAB\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'CPIO\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'DEB\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'DMG\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'HFS\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'ISO\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'UDF\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LHA\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'LZH\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PET\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'PUP\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'RAR\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'RPM\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'SLP\shell\Test archive(s)');
RegDeleteKeyIncludingSubkeys(HKCR, 'Z\shell\Test archive(s)');
end;

procedure clearcontextseven;
begin
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'AllFileSystemObjects\shell\PeaZip');
if IsWin64 then
   begin
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesingle');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7z');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zfastest');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7znormal');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zultra');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezip');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipfastest');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipnormal');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipultra');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipmail');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesfx');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browsepath');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2split');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2convert');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2here');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2smart');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2folder');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2main');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2a');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2test');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze');
   end
else
   begin
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesingle');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7z');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zfastest');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7znormal');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zultra');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezip');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipfastest');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipnormal');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipultra');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipmail');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesfx');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browsepath');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2split');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2convert');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2here');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2smart');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2folder');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2main');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2a');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2test');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze');
   end;
//legacy versions
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'Folder\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'PEA\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, '001\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, '7Z\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'XZ\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARC\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'WRC\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'BZ2\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'GZ\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ1\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ5\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ8\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8F\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8JD\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8L\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8O\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZPAQ\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'QUAD\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'BALZ\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'TAR\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'TGZ\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'ZIP\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'ACE\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'ARJ\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'CAB\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'CPIO\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'Z\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'DEB\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'PET\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'PUP\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'RPM\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'SLP\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'DMG\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'HFS\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'ISO\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'UDF\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'LHA\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'LZH\shell\PeaZip');
RegDeleteKeyIncludingSubkeys(HKCR, 'RAR\shell\PeaZip');
end;

procedure clearassociations;
begin
if RegKeyExists(HKLM, 'SOFTWARE\PeaZip') then RegDeleteKeyIncludingSubkeys(HKLM, 'SOFTWARE\PeaZip');
if RegKeyExists(HKLM, 'SOFTWARE\PeaZip_additional') then RegDeleteKeyIncludingSubkeys(HKLM, 'SOFTWARE\PeaZip_additional');
end;

procedure contextseven;
var
  s,sfs,sall:ansistring;
begin
      s:='';
      sfs:='';
      sall:='';

      s:=s+'PeaZip.ext2browseasarchive; ';
      if cbcontextbrowse.state = cbChecked then s:=s+'PeaZip.ext2browsepath; '; 
      s:=s+'PeaZip.add2separate; ';       
      if cbcontextadd2archiveseparate.state = cbChecked then s:=s+'PeaZip.add2separatesingle; ';
      if cbcontext7zs.state = cbChecked then s:=s+'PeaZip.add2separate7z; ';
      if checkbox3.state = cbChecked then s:=s+'PeaZip.add2separate7zultra; ';
      if cbcontextsfx.state = cbChecked then s:=s+'PeaZip.add2separatesfx; ';
      if cbcontextzips.state = cbChecked then s:=s+'PeaZip.add2separatezip; ';
      if checkbox4.state = cbChecked then s:=s+'PeaZip.add2separatezipfastest; ';
      if cbcontextzipmail.state = cbChecked then s:=s+'PeaZip.add2separatezipmail; ';      
      if cbcontextconvert.state = cbChecked then s:=s+'PeaZip.add2convert; ';
      if cbcontextsplit.state = cbChecked then s:=s+'PeaZip.add2split; ';
      if cbcontextcrc.state = cbChecked then s:=s+'PeaZip.analyze; ';
      if cbcontextwipe.state = cbChecked then s:=s+'PeaZip.add2wipe; ';

      sfs:='PeaZip.ext2main; '+s; //AllFileSystemObjects

      sall:=sall+'PeaZip.ext2main; ';
      if cbcontextext2here.state = cbChecked then sall:=sall+'PeaZip.ext2here; ';
      if cbcontextext2smart.state = cbChecked then sall:=sall+'PeaZip.ext2smart; ';
      if cbcontextext2folder.state = cbChecked then sall:=sall+'PeaZip.ext2folder; ';
      if cbcontexttest.state = cbChecked then sall:=sall+'PeaZip.ext2test; ';

      sall:=sall+s; //*

      RegWriteStringValue(HKCR, '*\shell\PeaZip', 'SubCommands', sall);
      RegWriteStringValue(HKCR, '*\shell\PeaZip', 'MultiSelectModel', 'player');
      RegWriteStringValue(HKCR, '*\shell\PeaZip', 'Icon', ExpandConstant('"{app}\peazip.exe",0'));
      RegWriteStringValue(HKCR, '*\shell\PeaZip\command', '', ''); //workaround: in Windows 7 it is not needed a \command key for this type of entry, but some optimization/cleaning utilities (i.e. TuneUp) would otherwise delete all entries in \shell missing a \command key
      RegDeleteValue(HKCR, '*\shell\PeaZip\command', ''); //the key created for the workaround is emptied to default value, otherwise it may be detected as a defective link by some utilities

      RegWriteStringValue(HKCR, 'AllFileSystemObjects\shell\PeaZip', 'SubCommands', sfs);
      RegWriteStringValue(HKCR, 'AllFileSystemObjects\shell\PeaZip', 'MultiSelectModel', 'player');
      RegWriteStringValue(HKCR, 'AllFileSystemObjects\shell\PeaZip', 'Icon', ExpandConstant('"{app}\peazip.exe",0'));
      RegWriteStringValue(HKCR, 'AllFileSystemObjects\shell\PeaZip\command', '', ''); //workaround: in Windows 7 it is not needed a \command key for this type of entry, but some optimization/cleaning utilities (i.e. TuneUp) would otherwise delete all entries in \shell missing a \command key
      RegDeleteValue(HKCR, 'AllFileSystemObjects\shell\PeaZip\command', ''); //the key created for the workaround is emptied to default value, otherwise it may be detected as a defective link by some utilities     

      if IsWin64 then
        begin
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate', '', '&Add to archive');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteDWordValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate', 'CommandFlags', 32);
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesingle', '', 'Add to separate archive(s)');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesingle', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesingle\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multiseparate" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7z', '', 'Add to .&7Z');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7z', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7z\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7z" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zfastest', '', 'Add to .7Z, fastest');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zfastest', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zfastest\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7zfastest" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7znormal', '', 'Add to .7Z, normal');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7znormal', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7znormal\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7znormal" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zultra', '', 'Add to .7Z, ultra');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zultra', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zultra\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7zultra" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezip', '', 'Add to .&ZIP');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezip', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezip\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizip" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipfastest', '', 'Add to .ZIP, fastest');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipfastest', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipfastest\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipfastest" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipnormal', '', 'Add to .ZIP, normal');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipnormal', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipnormal\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipnormal" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipultra', '', 'Add to .ZIP, ultra');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipultra', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipultra\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipultra" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipmail', '', 'Zip and mail');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipmail', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",3'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipmail\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipmail" "%1"')); 
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesfx', '', 'Add to self-extracting archive');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesfx', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesfx\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multisfx" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive', '', '&Open as archive');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive', 'Icon', ExpandConstant('"{app}\peazip.exe",0'));
        RegWriteDWordValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive', 'CommandFlags', 32);
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2browseasarchive" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browsepath', '', '&Browse path with PeaZip');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browsepath', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",8'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browsepath\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2browsepath" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2split', '', 'Split file');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2split', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",5'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2split\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multisplit" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2convert', '', 'Convert');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2convert', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",7'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2convert\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multiconvert" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe', '', 'Secure delete');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",6'));
        RegWriteDWordValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe', 'CommandFlags', 32);
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2wipe" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2here', '', 'Extract &here');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2here', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2here\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multihere" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2smart', '', 'Extract here (&smart)');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2smart', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2smart\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multismart" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2folder', '', 'Extract here (in &new folder)');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2folder', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2folder\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multifolder" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2main', '', '&Extract...');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2main', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2main\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multi" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2a', '', 'Extract archives');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2a', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2a\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multi" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2test', '', 'Test archive(s)');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2test', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",1'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2test\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2test" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze', '', 'CRC, hash and file tools');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",9'));
        RegWriteDWordValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze', 'CommandFlags', 32);
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze\command', '', ExpandConstant('"{app}\res\PEA.EXE" "PEAUTILS" "7" "%1"'));
        end
      else
        begin
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate', '', '&Add to archive');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteDWordValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate', 'CommandFlags', 32);
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesingle', '', 'Add to separate archive(s)');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesingle', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesingle\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multiseparate" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7z', '', 'Add to .&7Z');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7z', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7z\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7z" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zfastest', '', 'Add to .7Z, fastest');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zfastest', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zfastest\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7zfastest" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7znormal', '', 'Add to .7Z, normal');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7znormal', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7znormal\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7znormal" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zultra', '', 'Add to .7Z, ultra');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zultra', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separate7zultra\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7zultra" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezip', '', 'Add to .&ZIP');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezip', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezip\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizip" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipfastest', '', 'Add to .ZIP, fastest');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipfastest', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipfastest\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipfastest" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipnormal', '', 'Add to .ZIP, normal');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipnormal', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipnormal\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipnormal" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipultra', '', 'Add to .ZIP, ultra');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipultra', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipultra\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipultra" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipmail', '', 'Zip and mail');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipmail', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",3'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatezipmail\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipmail" "%1"')); 
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesfx', '', 'Add to self-extracting archive');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesfx', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",2'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2separatesfx\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multisfx" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive', '', '&Open as archive');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive', 'Icon', ExpandConstant('"{app}\peazip.exe",0'));
        RegWriteDWordValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive', 'CommandFlags', 32);
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browseasarchive\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2browseasarchive" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browsepath', '', '&Browse path with PeaZip');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browsepath', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",8'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2browsepath\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2browsepath" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2split', '', 'Split file');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2split', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",5'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2split\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multisplit" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2convert', '', 'Convert');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2convert', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",7'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2convert\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multiconvert" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe', '', 'Secure delete');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",6'));
        RegWriteDWordValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe', 'CommandFlags', 32);
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.add2wipe\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2wipe" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2here', '', 'Extract &here');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2here', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2here\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multihere" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2smart', '', 'Extract here (&smart)');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2smart', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2smart\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multismart" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2folder', '', 'Extract here (in &new folder)');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2folder', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2folder\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multifolder" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2main', '', '&Extract...');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2main', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2main\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multi" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2a', '', 'Extract archives');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2a', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2a\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multi" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2test', '', 'Test archive(s)');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2test', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",1'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.ext2test\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2test" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze', '', 'CRC, hash and file tools');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze', 'Icon', ExpandConstant('"{app}\res\icons\peazip_seven.icl",9'));
        RegWriteDWordValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze', 'CommandFlags', 32);
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaZip.analyze\command', '', ExpandConstant('"{app}\res\PEA.EXE" "PEAUTILS" "7" "%1"'));
        end;

end;

procedure contextlegacy;
begin

       RegWriteStringValue(HKCR, '*\shell\Add to archive\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Add to archive', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, '*\shell\Add to archive', '', '&Add to archive');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to archive\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Add to archive', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to archive', '', '&Add to archive');

    if cbcontext7zs.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Add to .7Z\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7z" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Add to .7Z', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, '*\shell\Add to .7Z', '', 'Add to .&7Z');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .7Z\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7z" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .7Z', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .7Z', '', 'Add to .&7Z');
       end;
    if CheckBox3.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Add to .7Z, ultra\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7zultra" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Add to .7Z, ultra', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .7Z, ultra\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multi7zultra" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .7Z, ultra', 'MultiSelectModel', 'player');
       end; 
    if cbcontextzips.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Add to .ZIP\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizip" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Add to .ZIP', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, '*\shell\Add to .ZIP', '', 'Add to .&ZIP');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .ZIP\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizip" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .ZIP', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .ZIP', '', 'Add to .&ZIP');
       end;
    if CheckBox4.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Add to .ZIP, fastest\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipfastest" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Add to .ZIP, fastest', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .ZIP, fastest\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipfastest" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Add to .ZIP, fastest', 'MultiSelectModel', 'player');
       end;
    if cbcontextzipmail.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Zip and mail\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipmail" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Zip and mail', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Zip and mail\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multizipmail" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Zip and mail', 'MultiSelectModel', 'player');
       end;
    if cbcontextsfx.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Add to self-extracting archive\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multisfx" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Add to self-extracting archive', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to self-extracting archive\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multisfx" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Add to self-extracting archive', 'MultiSelectModel', 'player');
       end;
    if cbcontextadd2archiveseparate.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Add to separate archive(s)\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multiseparate" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Add to separate archive(s)', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Add to separate archive(s)\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multiseparate" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Add to separate archive(s)', 'MultiSelectModel', 'player');
       end;

       RegWriteStringValue(HKCR, '*\shell\Open as archive\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2openasarchive" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Open as archive', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, '*\shell\Open as archive', '', '&Open as archive');

    if cbcontextbrowse.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Browse path with PeaZip\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2browsepath" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Browse path with PeaZip', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, '*\shell\Browse path with PeaZip', '', '&Browse path with PeaZip');
       RegWriteStringValue(HKCR, 'Directory\shell\Browse path with PeaZip\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2browsepath" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Browse path with PeaZip', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Browse path with PeaZip', '', '&Browse path with PeaZip');
       end;
       
    if cbcontextcrc.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\CRC, hash and file tools\command', '', ExpandConstant('"{app}\res\PEA.EXE" "PEAUTILS" "7" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\CRC, hash and file tools', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\CRC, hash and file tools\command', '', ExpandConstant('"{app}\res\PEA.EXE" "PEAUTILS" "7" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\CRC, hash and file tools', 'MultiSelectModel', 'single');
       end;

    if cbcontextsplit.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Split file\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multisplit" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Split file', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Split file\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multisplit" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Split file', 'MultiSelectModel', 'player');
       end;
    if cbcontextconvert.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Convert\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multiconvert" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Convert', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Convert\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2multiconvert" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Convert', 'MultiSelectModel', 'player');
       end;
    if cbcontextwipe.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\Secure delete\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2wipe" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\Secure delete', 'MultiSelectModel', 'player');
       RegWriteStringValue(HKCR, 'Directory\shell\Secure delete\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-add2wipe" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\Secure delete', 'MultiSelectModel', 'player');
       end;

    RegWriteStringValue(HKCR, '*\shell\Extract...\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multi" "%1"'));
    RegWriteStringValue(HKCR, '*\shell\Extract...', 'MultiSelectModel', 'player');
    RegWriteStringValue(HKCR, '*\shell\Extract...', '', '&Extract...');
    RegWriteStringValue(HKCR, 'Directory\shell\Extract...\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multi" "%1"'));
    RegWriteStringValue(HKCR, 'Directory\shell\Extract...', 'MultiSelectModel', 'player');
    RegWriteStringValue(HKCR, 'Directory\shell\Extract...', '', '&Extract...');

    if cbcontextext2here.state = cbChecked then
       begin
          RegWriteStringValue(HKCR, '*\shell\Extract here\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multihere" "%1"'));
          RegWriteStringValue(HKCR, '*\shell\Extract here', 'MultiSelectModel', 'player');
          RegWriteStringValue(HKCR, '*\shell\Extract here', '', 'Extract &here');
       end;
    if cbcontextext2smart.state = cbChecked then
       begin
          RegWriteStringValue(HKCR, '*\shell\Extract here (smart)\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multismart" "%1"'));
          RegWriteStringValue(HKCR, '*\shell\Extract here (smart)', 'MultiSelectModel', 'player');
          RegWriteStringValue(HKCR, '*\shell\Extract here (smart)', '', 'Extract here (&smart)');
       end;
    if cbcontextext2folder.state = cbChecked then
       begin
          RegWriteStringValue(HKCR, '*\shell\Extract here (in new folder)\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2multifolder" "%1"'));
          RegWriteStringValue(HKCR, '*\shell\Extract here (in new folder)', 'MultiSelectModel', 'player');
          RegWriteStringValue(HKCR, '*\shell\Extract here (in new folder)', '', 'Extract here (in &new folder)');
       end;
    if cbcontexttest.state = cbChecked then
       begin     
          RegWriteStringValue(HKCR, '*\shell\Test archive(s)\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "-ext2test" "%1"'));
          RegWriteStringValue(HKCR, '*\shell\Test archive(s)', 'MultiSelectModel', 'player');
       end;
end;

procedure dolinks;
begin
    //link to PeaZip -add2archive: add to generic archive
    if cbfunadd.state = cbChecked then
      begin
  CreateShellLink(
  ExpandConstant('{sendto}\Add to archive.lnk'),
  'PeaZip archiver, add to archive',
  ExpandConstant('{app}\peazip.exe'),
  '-add2archive',
  '',
  ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
  2,//icon index
  SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2convert: convert existing archives
    if cbfunconvert.state = cbChecked then
      begin
  CreateShellLink(
  ExpandConstant('{sendto}\Convert.lnk'),
  'PeaZip archiver, convert existing archive',
  ExpandConstant('{app}\peazip.exe'),
  '-add2convert',
  '',
  ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
  7,//icon index
  SW_SHOWNORMAL);
      end;

    //link to PeaZip -ext2here: extract here
    if cbfunext2here.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Extract here.lnk'),
      'PeaZip archiver, extract here',
      ExpandConstant('{app}\peazip.exe'),
      '-ext2here',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      4,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -ext2folder: extract here to new folder
    if cbfunext2folder.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Extract here (in new folder).lnk'),
      'PeaZip archiver, extract here to new folder',
      ExpandConstant('{app}\peazip.exe'),
      '-ext2folder',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      4,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -ext2main: extract with options
    if cbfunext2to.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Extract....lnk'),
      'PeaZip archiver, extract into specified path',
      ExpandConstant('{app}\peazip.exe'),
      '-ext2main',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      4,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add27z: add to .7z archive
    if cbfun7z.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Add to .7Z.lnk'),
      'PeaZip archiver, add to .7Z archive',
      ExpandConstant('{app}\peazip.exe'),
      '-add27z',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      2,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add27zmail: add to .7z archive and send by mail
    if cbfun7zmail.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Add to .7Z and send by mail.lnk'),
      'PeaZip archiver, add to .7Z archive and send it by mail',
      ExpandConstant('{app}\peazip.exe'),
      '-add27zmail',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      3,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2separate7z: add to separate .7z archives
    if cbfun7zs.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Add to separate .7Z.lnk'),
      'PeaZip archiver, add to separate .7Z archives',
      ExpandConstant('{app}\peazip.exe'),
      '-add2separate7z',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      2,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2zip: add to .zip archive
    if cbfunzip.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Add to .ZIP.lnk'),
      'PeaZip archiver, add to .ZIP archive',
      ExpandConstant('{app}\peazip.exe'),
      '-add2zip',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      2,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2zipmail: add to .zip archive and send by mail
    if cbfunzipmail.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Add to .ZIP and send by mail.lnk'),
      'PeaZip archiver, add to .ZIP archive and send it by mail',
      ExpandConstant('{app}\peazip.exe'),
      '-add2zipmail',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      3,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2separatezip: add to separate .zip archives
    if cbfunzips.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Add to separate .ZIP.lnk'),
      'PeaZip archiver, add to separate .ZIP archives',
      ExpandConstant('{app}\peazip.exe'),
      '-add2separatezip',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      2,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2sfx7z: add to sfx 7z archive
    if cbfunsfx.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Add to self-extracting archive.lnk'),
      'PeaZip archiver, add to self extracting .7z archive',
      ExpandConstant('{app}\peazip.exe'),
      '-add2sfx7z',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      2,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2sfx7zmail: add to sfx 7z archive and send by mail
    if cbfunsfxmail.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Add to sfx and send by mail.lnk'),
      'PeaZip archiver, add to self extracting .7z archive and send it by mail',
      ExpandConstant('{app}\peazip.exe'),
      '-add2sfx7zmail',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      3,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2crypt: add to encrypted .pea archive
    if cbfunencrypt.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Encrypt.lnk'),
      'PeaZip archiver, add to encrypted .pea archive',
      ExpandConstant('{app}\peazip.exe'),
      '-add2crypt',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      0,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2split: raw file split
    if cbfunsplit.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Split file.lnk'),
      'PeaZip archiver, raw split single file',
      ExpandConstant('{app}\peazip.exe'),
      '-add2split',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      5,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -add2wipe: Secure delete
    if cbfunwipe.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Secure delete.lnk'),
      'PeaZip archiver, secure delete',
      ExpandConstant('{app}\peazip.exe'),
      '-add2wipe',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      6,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -ext2test: test archive's content
    if cbfuntest.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Test archive(s).lnk'),
      'PeaZip archiver, test archive(s)',
      ExpandConstant('{app}\peazip.exe'),
      '-ext2test',
      '',
      ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      1,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -ext2openasarchive
    if cbfunopen.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Open as archive.lnk'),
      'PeaZip archiver, open as archive',
      ExpandConstant('{app}\peazip.exe'),
      '-ext2openasarchive',
      '',
      '',//ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      1,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -ext2browsepath: browse path
    if CheckBoxbrowsepath.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Browse path with PeaZip.lnk'),
      'PeaZip archiver, browse path',
      ExpandConstant('{app}\peazip.exe'),
      '-ext2browsepath',
      '',
      '',//ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      1,//icon index
      SW_SHOWNORMAL);
      end;

    //link to PeaZip -ext2commandprompt: open command prompt here
    if CheckBoxcommand.state = cbChecked then
      begin
      CreateShellLink(
      ExpandConstant('{sendto}\Open command prompt here.lnk'),
      'PeaZip archiver, open command prompt here',
      ExpandConstant('{app}\peazip.exe'),
      '-ext2commandprompt',
      '',
      '',//ExpandConstant('{app}\res\icons\peazip_seven.icl'),//icon filename
      1,//icon index
      SW_SHOWNORMAL);
      end;
end;

procedure doassociations;
begin

  RegWriteStringValue(HKCR, '.pea', '', 'PeaZip.PEA');
  RegWriteStringValue(HKCR, 'PeaZip.PEA', '', 'PEA archive');
  RegWriteStringValue(HKCR, 'PeaZip.PEA\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
  RegWriteStringValue(HKCR, 'PeaZip.PEA\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));

  RegWriteStringValue(HKCR, '.001', '', 'PeaZip.001');
  RegWriteStringValue(HKCR, 'PeaZip.001', '', 'Split file');
  RegWriteStringValue(HKCR, 'PeaZip.001\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_BLOCK.ICO,0'));
  RegWriteStringValue(HKCR, 'PeaZip.001\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));

  if cbfullnone.state = cbUnchecked then
    begin
    //declare that filetype associations were created
    RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip', '', 'Created filetype associations');
    //7z/arc
    if cb7z.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip\7Z', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.7z', '', 'PeaZip.7Z');
      RegWriteStringValue(HKCR, 'PeaZip.7Z', '', '7Z archive');
      RegWriteStringValue(HKCR, 'PeaZip.7Z\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_7Z.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.7Z\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      RegWriteStringValue(HKCR, '.xz', '', 'PeaZip.XZ');
      RegWriteStringValue(HKCR, 'PeaZip.XZ', '', 'XZ compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.XZ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.XZ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //arc/wrc
    if cbarc.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip\ARC', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.arc', '', 'PeaZip.ARC');
      RegWriteStringValue(HKCR, 'PeaZip.ARC', '', 'FreeARC archive');
      RegWriteStringValue(HKCR, 'PeaZip.ARC\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.ARC\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      RegWriteStringValue(HKCR, '.wrc', '', 'PeaZip.WRC');
      RegWriteStringValue(HKCR, 'PeaZip.WRC', '', 'FreeARC archive');
      RegWriteStringValue(HKCR, 'PeaZip.WRC\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.WRC\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //BZip2
    if cbbz2.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip\BZ2', '', 'Associated PeaZip with file type(s)');
      //BZ
      RegWriteStringValue(HKCR, '.bz', '', 'PeaZip.BZ');
      RegWriteStringValue(HKCR, 'PeaZip.BZ', '', 'BZip2 compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.BZ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.BZ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //BZ2
      RegWriteStringValue(HKCR, '.bz2', '', 'PeaZip.BZ2');
      RegWriteStringValue(HKCR, 'PeaZip.BZ2', '', 'BZip2 compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.BZ2\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.BZ2\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //TBZ
      RegWriteStringValue(HKCR, '.tbz', '', 'PeaZip.TBZ');
      RegWriteStringValue(HKCR, 'PeaZip.TBZ', '', 'BZip2 compressed TAR archive');
      RegWriteStringValue(HKCR, 'PeaZip.TBZ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.TBZ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //TBZ2
      RegWriteStringValue(HKCR, '.tbz2', '', 'PeaZip.TBZ2');
      RegWriteStringValue(HKCR, 'PeaZip.TBZ2', '', 'BZip2 compressed TAR archive');
      RegWriteStringValue(HKCR, 'PeaZip.TBZ2\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.TBZ2\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //GZip
    if cbgz.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip\GZ', '', 'Associated PeaZip with file type(s)');
      //GZ
      RegWriteStringValue(HKCR, '.gz', '', 'PeaZip.GZ');
      RegWriteStringValue(HKCR, 'PeaZip.GZ', '', 'GZip compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.GZ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.GZ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //TGZ
      RegWriteStringValue(HKCR, '.tgz', '', 'PeaZip.TGZ');
      RegWriteStringValue(HKCR, 'PeaZip.TGZ', '', 'GZip compressed TAR archive');
      RegWriteStringValue(HKCR, 'PeaZip.TGZ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.TGZ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //*PAQ group
    if cbpaq8.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip\PAQ', '', 'Associated PeaZip with file type(s)');
      //LPAQ1
      RegWriteStringValue(HKCR, '.lpaq1', '', 'PeaZip.LPAQ1');
      RegWriteStringValue(HKCR, 'PeaZip.LPAQ1', '', 'LPAQ1 compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.LPAQ1\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.LPAQ1\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //LPAQ5
      RegWriteStringValue(HKCR, '.lpaq5', '', 'PeaZip.LPAQ5');
      RegWriteStringValue(HKCR, 'PeaZip.LPAQ5', '', 'LPAQ5 compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.LPAQ5\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.LPAQ5\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //LPAQ8
      RegWriteStringValue(HKCR, '.lpaq8', '', 'PeaZip.LPAQ8');
      RegWriteStringValue(HKCR, 'PeaZip.LPAQ8', '', 'LPAQ8 compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.LPAQ8\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.LPAQ8\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //PAQ8F
      RegWriteStringValue(HKCR, '.paq8f', '', 'PeaZip.PAQ8F');
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8F', '', 'PAQ8F archive');
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8F\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8F\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //PAQ8JD
      RegWriteStringValue(HKCR, '.paq8jd', '', 'PeaZip.PAQ8JD');
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8JD', '', 'PAQ8JD archive');
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8JD\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8JD\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //PAQ8L
      RegWriteStringValue(HKCR, '.paq8l', '', 'PeaZip.PAQ8L');
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8L', '', 'PAQ8L archive');
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8L\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8L\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //PAQ8O
      RegWriteStringValue(HKCR, '.paq8o', '', 'PeaZip.PAQ8O');
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8O', '', 'PAQ8O archive');
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8O\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.PAQ8O\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //ZPAQ
      RegWriteStringValue(HKCR, '.zpaq', '', 'PeaZip.ZPAQ');
      RegWriteStringValue(HKCR, 'PeaZip.ZPAQ', '', 'ZPAQ archive');
      RegWriteStringValue(HKCR, 'PeaZip.ZPAQ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.ZPAQ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    if cbquad.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip\QUAD', '', 'Associated PeaZip with file type(s)');
      //QUAD
      RegWriteStringValue(HKCR, '.quad', '', 'PeaZip.QUAD');
      RegWriteStringValue(HKCR, 'PeaZip.QUAD', '', 'QUAD compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.QUAD\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.QUAD\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //BALZ
      RegWriteStringValue(HKCR, '.balz', '', 'PeaZip.BALZ');
      RegWriteStringValue(HKCR, 'PeaZip.BALZ', '', 'BALZ compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.BALZ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.BALZ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //Tar
    if cbtar.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip\TAR', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.tar', '', 'PeaZip.TAR');
      RegWriteStringValue(HKCR, 'PeaZip.TAR', '', 'TAR archive');
      RegWriteStringValue(HKCR, 'PeaZip.TAR\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.TAR\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //Zip
    if cbzip.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip\ZIP', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.zip', '', 'PeaZip.ZIP');
      RegWriteStringValue(HKCR, 'PeaZip.ZIP', '', 'ZIP archive');
      RegWriteStringValue(HKCR, 'PeaZip.ZIP\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_ZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.ZIP\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip\ZIPX', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.zipx', '', 'PeaZip.ZIPX');
      RegWriteStringValue(HKCR, 'PeaZip.ZIPX', '', 'ZIPX archive');
      RegWriteStringValue(HKCR, 'PeaZip.ZIPX\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_ZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.ZIPX\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    end;
  if cbreadnone.state = cbUnchecked then
    begin //associate types with browse/extract only support
    //declare that additional filetype associations were created
    RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional', '', 'Created additional filetype associations');
    //ACE
    if cbace.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\ACE', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.ACE', '', 'PeaZip.ACE');
      RegWriteStringValue(HKCR, 'PeaZip.ACE', '', 'ACE archive');
      RegWriteStringValue(HKCR, 'PeaZip.ACE\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.ACE\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //ARJ
    if cbarj.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\ARJ', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.ARJ', '', 'PeaZip.ARJ');
      RegWriteStringValue(HKCR, 'PeaZip.ARJ', '', 'ARJ archive');
      RegWriteStringValue(HKCR, 'PeaZip.ARJ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.ARJ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //CAB
    if cbcab.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\CAB', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.CAB', '', 'PeaZip.CAB');
      RegWriteStringValue(HKCR, 'PeaZip.CAB', '', 'CAB archive');
      RegWriteStringValue(HKCR, 'PeaZip.CAB\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.CAB\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //CPIO
    if cbcpio.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\CPIO', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.CPIO', '', 'PeaZip.CPIO');
      RegWriteStringValue(HKCR, 'PeaZip.CPIO', '', 'CPIO archive');
      RegWriteStringValue(HKCR, 'PeaZip.CPIO\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.CPIO\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //Z
      RegWriteStringValue(HKCR, '.Z', '', 'PeaZip.Z');
      RegWriteStringValue(HKCR, 'PeaZip.Z', '', 'Z compressed file');
      RegWriteStringValue(HKCR, 'PeaZip.Z\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.Z\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //TZ
      RegWriteStringValue(HKCR, '.tz', '', 'PeaZip.TZ');
      RegWriteStringValue(HKCR, 'PeaZip.TZ', '', 'Z compressed TAR archive');
      RegWriteStringValue(HKCR, 'PeaZip.TZ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.TZ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //TZ
      RegWriteStringValue(HKCR, '.taz', '', 'PeaZip.TAZ');
      RegWriteStringValue(HKCR, 'PeaZip.TAZ', '', 'Z compressed TAR archive');
      RegWriteStringValue(HKCR, 'PeaZip.TAZ\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.TAZ\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //Disk images
    if cbiso.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\ISO', '', 'Associated PeaZip with file type(s)');
      //ISO
      RegWriteStringValue(HKCR, '.ISO', '', 'PeaZip.ISO');
      RegWriteStringValue(HKCR, 'PeaZip.ISO', '', 'ISO disk image');
      RegWriteStringValue(HKCR, 'PeaZip.ISO\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_CD.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.ISO\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //UDF
      RegWriteStringValue(HKCR, '.UDF', '', 'PeaZip.UDF');
      RegWriteStringValue(HKCR, 'PeaZip.UDF', '', 'UDF disk image');
      RegWriteStringValue(HKCR, 'PeaZip.UDF\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_CD.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.UDF\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //LHA
    if cblha.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\LHA', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.LHA', '', 'PeaZip.LHA');
      RegWriteStringValue(HKCR, 'PeaZip.LHA', '', 'LHA archive');
      RegWriteStringValue(HKCR, 'PeaZip.LHA\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.LHA\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //Linux packages (DEB, RPM, PET/PUP)
    if cblinux.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\linux', '', 'Associated PeaZip with file type(s)');
      //DEB
      RegWriteStringValue(HKCR, '.DEB', '', 'PeaZip.DEB');
      RegWriteStringValue(HKCR, 'PeaZip.DEB', '', 'DEB package');
      RegWriteStringValue(HKCR, 'PeaZip.DEB\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.DEB\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //PET
      RegWriteStringValue(HKCR, '.PET', '', 'PeaZip.PET');
      RegWriteStringValue(HKCR, 'PeaZip.PET', '', 'PET package (Puppy Linux)');
      RegWriteStringValue(HKCR, 'PeaZip.PET\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.PET\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //PUP
      RegWriteStringValue(HKCR, '.PUP', '', 'PeaZip.PUP');
      RegWriteStringValue(HKCR, 'PeaZip.PUP', '', 'PUP package (Puppy Linux)');
      RegWriteStringValue(HKCR, 'PeaZip.PUP\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.PUP\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //RPM
      RegWriteStringValue(HKCR, '.RPM', '', 'PeaZip.RPM');
      RegWriteStringValue(HKCR, 'PeaZip.RPM', '', 'RPM package');
      RegWriteStringValue(HKCR, 'PeaZip.RPM\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.RPM\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //SLP
      RegWriteStringValue(HKCR, '.SLP', '', 'PeaZip.SLP');
      RegWriteStringValue(HKCR, 'PeaZip.SLP', '', 'SLP package');
      RegWriteStringValue(HKCR, 'PeaZip.SLP\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.SLP\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //LZH
    if cblzh.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\LZH', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.LZH', '', 'PeaZip.LZH');
      RegWriteStringValue(HKCR, 'PeaZip.LZH', '', 'LZH archive');
      RegWriteStringValue(HKCR, 'PeaZip.LZH\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.LZH\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //Mac formats (DMG, HFS)
    if cbMac.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\mac', '', 'Associated PeaZip with file type(s)');
      //DMG
      RegWriteStringValue(HKCR, '.DMG', '', 'PeaZip.DMG');
      RegWriteStringValue(HKCR, 'PeaZip.DMG', '', 'DMG package');
      RegWriteStringValue(HKCR, 'PeaZip.DMG\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.DMG\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      //UDF
      RegWriteStringValue(HKCR, '.HFS', '', 'PeaZip.HFS');
      RegWriteStringValue(HKCR, 'PeaZip.HFS', '', 'UDF package');
      RegWriteStringValue(HKCR, 'PeaZip.HFS\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.HFS\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    //RAR
    if cbrar.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaZip_additional\RAR', '', 'Associated PeaZip with file type(s)');
      RegWriteStringValue(HKCR, '.RAR', '', 'PeaZip.RAR');
      RegWriteStringValue(HKCR, 'PeaZip.RAR', '', 'RAR archive');
      RegWriteStringValue(HKCR, 'PeaZip.RAR\DefaultIcon', '', ExpandConstant('{app}\RES\ICONS\PEAZIP_RAR.ICO,0'));
      RegWriteStringValue(HKCR, 'PeaZip.RAR\shell\open\command', '', ExpandConstant('"{app}\PEAZIP.EXE" "%1"'));
      end;
    end;
end;

function NextButtonClick(CurPageID: Integer): Boolean;
var
  ResultCode: Integer;
  ErrorCode: Integer;
begin

if CurPageID = wpReady then
  begin

  if (radiobuttoninstall4.Checked = False) then //only for installers
    begin
    clearcontextlegacy;
    clearcontextseven;
    clearlinks;
    clearassociations;
    BringToFrontAndRestore();

  if (radiobuttoninstall3.Checked = False) then
    begin
    //context menu
    if cbcontextnone.state = cbUnchecked then
       if (GetWindowsVersion >= $06010000) then 
          if cbcascaded.state = cbChecked then contextseven
          else contextlegacy
       else contextlegacy;
    //sendto menu
    if cbfunnone.state = cbUnchecked then dolinks;
    //associations
    doassociations;
  end;

  end;

  try
  if cbreset.checked=true then 
     if (GetWindowsVersion >= $06000000) then ShellExecAsOriginalUser('', ExpandConstant('{app}\peazip.exe'), '-peaziptotalreset', '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
  except end;

  BringToFrontAndRestore();
  end;
Result := True;
end;

procedure dolanguage;
var
  ErrorCode: Integer;
  slang:string;
begin    
case combobox1.itemindex of
 0: slang:='ar.txt';
 1: slang:='bg.txt';
 2: slang:='by-cr.txt';
 3: slang:='by-lt.txt';
 4: slang:='chs.txt';
 5: slang:='cht.txt';
 6: slang:='cz.txt';
 7: slang:='de-uml.txt';
 8: slang:='de-uml-alt.txt';
 9: slang:='en.txt';
 10: slang:='en-gb.txt';
 11: slang:='es-es.txt';
 12: slang:='es-la.txt';
 13: slang:='eu.txt';
 14: slang:='fi.txt';
 15: slang:='fr.txt';
 16: slang:='gl.txt';
 17: slang:='gr.txt';
 18: slang:='hu.txt';
 19: slang:='id.txt';
 20: slang:='it.txt';
 21: slang:='ja.txt';
 22: slang:='ko.txt';
 23: slang:='nl.txt';
 24: slang:='no.txt';
 25: slang:='pl.txt';
 26: slang:='pt-br.txt';
 27: slang:='pt-pt.txt';
 28: slang:='ro.txt';
 29: slang:='ru.txt';
 30: slang:='si.txt';
 31: slang:='sk.txt';
 32: slang:='sl.txt';
 33: slang:='sv.txt';
 34: slang:='tj.txt';
 35: slang:='tr.txt';
 36: slang:='uk.txt';
 37: slang:='uz.txt';
 38: slang:='vn.txt';
 else slang:='en.txt';
end;
if (GetWindowsVersion >= $06000000) then ShellExecAsOriginalUser('', ExpandConstant('{app}\peazip.exe'), '-peaziplanguage '+slang, '', SW_SHOW, ewWaitUntilTerminated, ErrorCode);
end;

procedure CurStepChanged(CurStep: TSetupStep);
begin
if CurStep=ssPostInstall then 
dolanguage;
end;

procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
begin
if CurUninstallStep = usDone then
  begin
  clearlinks; //delete links
  clearcontextlegacy;
  clearcontextseven; //delete context menu items
  clearassociations; //delete filetype associations (by read/write and/or read only group), if created by previous setup
  BringToFrontAndRestore();
  end;
end;