{-Test prog for CRC/HASH, we 29.05.17}

{Newer Delphi system.hash unit can be used parallel to CRC/Hash. The Delphi bug}
{from https://quality.embarcadero.com/browse/RSP-15827 was resolved  04/May/17.}

program t_emb_we;

uses
  system.hash,
  btypes, mem_util, hash, md5, sha256;

{$i std.inc}

{$ifdef APPCONS}
  {$apptype console}
{$endif}

const
  msg: packed array[0..2] of char8 = 'abc';

{---------------------------------------------------------------------------}
procedure we_test;
var
  md5dig: TMD5Digest;
  shadig: TSHA256Digest;
begin
  writeln('Using WE - CRC/Hash');
  MD5Full(md5dig, @msg, sizeof(msg));
  writeln('      MD5 ', hexstr(@md5dig,sizeof(md5dig)));
  SHA256Full(shadig,@msg, sizeof(msg));
  writeln('  SHA-256 ', hexstr(@shadig,sizeof(shadig)));
end;

{---------------------------------------------------------------------------}
procedure emba_test;
begin
  writeln('Using system.hash');
  writeln('      MD5 ', THashMD5.GetHashString(msg));
  writeln('  SHA-256 ', THashSHA2.GetHashString(msg));
end;

begin
  writeln('Test hashing "abc"');
  we_test;
  emba_test;
end.
