<?php

/* -------------------------------------------------------------------------
	!!!The character encoding of this file must be `INT_ENC`
	defined in Config.inc.php (the default value is EUC-JP)!!!

	設定
	for PC2M Website Transcoder for Mobile Clients
	Copyright (C) 2005-2007 ucb.rcdtokyo and the contributors
	http://www.rcdtokyo.com/pc2m/note/
------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------
	追加パス（include_path）の設定など
------------------------------------------------------------------------- */

/* PHPが読み込みを行うパスを追加するには以下のコメントを外して
 * 「/home/hoge/include:」の箇所を適宜書き換えてください。
 * 書式は「パス1:パス2:パス3:」のようにパスを区切り文字で区切ります。
 * 区切り文字はUNIX系は「:」でWin32版は「;」です。
 */

// ini_set('include_path', '/home/hoge/include/:'.ini_get('include_path'));

/* -------------------------------------------------------------------------
	画像処理の可否
------------------------------------------------------------------------- */

/* サーバのPHPにGDライブラリが組み込まれていないなどの場合は画像処理が行え
 * ません。この場合は、以下をfalseまたはコメントアウトにしてください。
 */

define('IMAGE_ENABLED', true);

/* 通常は、メインのスクリプトが画像処理も行いますが、無料のレンタルサーバを
 * 利用している場合などで、HTMLやCGI、PHPなどに広告が強制挿入される場合は、
 * 画像処理を行う専用のスクリプトを、メインのスクリプトをコピーして別に用意
 * したり、さらにそれを、メインのスクリプトとは異なるディレクトリに配置する
 * 必要があるかもしれません。
 * この場合は、定数IMAGE_CONVERTERに画像変換用のスクリプトのURLを、メインの
 * スクリプトからの相対パス、またはhttpで始まる絶対パスで指定します。
 * そして、これをメインのスクリプトとは異なるディレクトリに配置する場合は、
 * 他にの設定を変更する必要があります。
 * この詳細は、以下のページをご覧ください。
 * http://www.rcdtokyo.com/pc2m/note/archives/i000768.php
 */

// define('IMAGE_CONVERTER', 'im.php');

/* -------------------------------------------------------------------------
	セッション関連
------------------------------------------------------------------------- */

/* セッション機能が有効な場合は、携帯端末の種類に関わらず、フォーム認証を含
 * むCookieの送受信やベーシック認証、アクセス履歴の表示、Refererの送信とい
 * った機能が利用できます。また設定もセッションデータに保存されるため、URL
 * のパラメータが省略でき、結果、より多くの文字を表示できます。
 * さらに、スクリプトの管理者であれば、以前のセッションデータを簡単に復元し
 * 設定やCookieをそのまま使い続けることができます。
 * セッション機能を利用する場合は、そのセキュリティについて留意する必要があ
 * ります。詳細は以下のページをご覧ください。
 * http://www.rcdtokyo.com/pc2m/note/archives/i000770.php
 */

/* セッション機能を利用しない場合は、以下の定数ENABLE_SESSIONをfalseまたは
 * コメントアウトしてください。
 * なおセッション機能が無効の場合はINPUT type="password"は表示されません。
 * これは、Cookieの送受信が行われないため、殆どのサイトでパスワードの認証が
 * 行われないにも関わらず不用意にパスワードが送信されることを防ぐためです。
 */

define('ENABLE_SESSION', true);

/* session.save_pathは、セッションデータファイルの保存先ディレクトリの指定
 * です。未指定の場合はシステムの一時ディレクトリになりますが、共用サーバで
 * は、自身の管理下にあるディレクトリを指定してください。
 * このディレクトリは、パーミッションが707や777など、書き込み可能になってい
 * る必要があります。また、これを、外部からHTTPなどでのアクセスが可能なディ
 * レクトリに設定する場合は、「deny from all」のように記述した.htaccessファ
 * イルを配置するなどして、外部からのアクセスを禁止するようにしてください。
 * なお、画像の変換を行うスクリプトを、メインのスクリプトとは別に用意して、
 * 異なるディレクトリに配置する場合は、両方のスクリプトが同じセッションデー
 * タを参照できるように、これをフルパスで指定してください。
 * この詳細は、以下のページをご覧ください。
 * http://www.rcdtokyo.com/pc2m/note/archives/i000768.php
 */

ini_set('session.save_path', './data');

/* 定数SESSION_ID_LENGTHはセッションIDの桁数です。セッションIDはランダムな
 * 英数字で構成されますが、桁数が少ないとIDが重複してしまう可能性があるた
 * め、最低でも6桁程度を目安に、多くの利用者が見込まれる場合は、より多く設
 * 定するようにしてください。ただし、多くの携帯端末ではセッションIDはURLの
 * クエリー文字列に埋め込まれ、この場合はページ内のすべてのリンクがセッショ
 * ンIDの文字列を含むことになるため、桁数が多くなるほど1画面あたりに表示で
 * きる文字数は減少します。
 * 未定義の場合は32桁です。
 */

define('SESSION_ID_LENGTH', 6);

/* 定数SESSION_INSECURE_LIFETIMEとSESSION_SECURE_LIFETIMEは、いずれもセッシ
 * ョンデータの存続期限を指定するもので、最後のアクセスからここで指定した秒
 * 数以上経過しているセッションデータは破棄されます。
 * 後者は、端末自体がCookieをサポートしている場合など、セッション乗っ取りの
 * 危険性が低いと思われる場合に適用され、それ以外は前者が適用されます。
 * 従って前者は、利用者の利便を妨げないと思われる範囲で極力短い数値を指定す
 * るようにしてください。また後者も、あまり長い時間を指定するのは避けてくだ
 * さい。
 * 未定義の場合は、両者とも「300」秒（5分）となります。
 */

define('SESSION_INSECURE_LIFETIME', 10 * 60);
define('SESSION_SECURE_LIFETIME', 20 * 60);

/* 上の2ヶの定数で指定した存続期限が経過しても、セッションデータのファイル
 * が削除されるわけではありません。これらの削除は、PHPのGarbage Collection
 * （ゴミ回収）プロセスによって行われます。具体的には、最後のアクセスから
 * session.gc_maxlifetime秒経過しているセッションデータのファイルは、セッシ
 * ョンが起動される毎に、session.gc_probability/session.gc_divisorの確率で
 * 削除されます。
 * なお、session.gc_maxlifetimeの値が、定数SESSION_INSECURE_LIFETIMEや
 * SESSION_SECURE_LIFETIMEの値よりも短い場合は、これらで指定した存続期限に
 * 達していないセッションデータのファイルも削除されてしまう可能性がある点に
 * 注意してください。
 */

// ini_set('session.gc_maxlifetime', '24 * 60');
// ini_set('session.gc_probability', '1');
// ini_set('session.gc_divisor', '100');

/* 初期のJ-PHONE端末など、POST送信に対応していない端末では全ての入力フォー
 * ムはGETメソッドで送信されますが、定数USE_ONLYPOST_FORPASSがtrueの場合、
 * これらの端末ではINPUT type="password"は除去され表示されません。
 * これは、GET送信によってパスワードがURL文字列中に漏洩することを防ぐための
 * 措置です。
 * これらの端末でもINPUT type="password"を表示する場合は以下をfalseにしてく
 * ださい。
 */

define('USE_ONLYPOST_FORPASS', true);

/* 定数MAX_HISTORY_KEEPは、セッションの復元時に復元されるアクセス履歴の数で
 * す。それ以前の履歴は、復元時には破棄されます。
 * セッションの復元の詳細は以下のページをご覧ください。
 * http://www.rcdtokyo.com/pc2m/note/archives/i000769.php
 */

define('MAX_HISTORY_KEEP', 30);

/* 定数SESSION_COOKIE_PATHはセッションCookieが有効なパスの指定です。
 * これはメインスクリプトと画像変換スクリプトを異なるディレクトリに配置する
 * 場合に、両方のスクリプトが同じセッションデータを参照するために必要な指定
 * してくださいです。それ以外は指定する必要はありません。
 * 詳細は、以下のページをご覧ください。
 * http://www.rcdtokyo.com/pc2m/note/archives/i000768.php
 */

// define('SESSION_COOKIE_PATH', '/hoge/pc2m/');

/* -------------------------------------------------------------------------
	アクセス制限
------------------------------------------------------------------------- */

/* このスクリプトはその性格上いわゆる「公開プロキシ」として利用される可能性
 * があります。以下の設定を利用することで、その可能性を軽減することができる
 * かもしれません。
 */

/* 定数ALLOW_ONLYMOBILEがtrueの場合、（日本の）モバイルキャリアのネットワー
 * ク以外からのアクセスを拒否します。
 * これはホスト名（REMOTE_HOST）、またはIPアドレス（REMOTE_ADDR）から得られ
 * たホスト名がモバイルキャリアのドメイン名に合致しない、あるいはIPアドレス
 * がIPRange.inc.phpに登録されたIPアドレス範囲に合致しない場合、モバイルキ
 * ャリアのネットワークではないとみなします。
 * なお、これを利用すると、スクリプトの管理者がPCなどから確認することもでき
 * なくなる筈なので、特定のIPアドレス範囲からのアクセスについてはこの対象外
 * とすることができます。この場合は、配列$exclude_iprangeに除外するIPアドレ
 * スの範囲を指定してください。
 * IPアドレス範囲は「nnn.nnn.nnn.nnn/nn」形式です。よくわからなければ、例え
 * ば自身のPCに現在割り当てられているIPアドレスが「123.123.123.123」なら、
 * 「123.123.123.0/24」のようにしておくといいかもしれません。
 * IPアドレスが固定の場合は「IPアドレス/32」のように記述してください。
 */

// define('ALLOW_ONLYMOBILE', true);
// $exclude_iprange = array(
//  '123.123.123.0/24',
// );

/* あるいは、DNSブラックリスト（DNSBL）に登録されているIPアドレスを拒否する
 * こともできます。ただし「モバイルキャリアのネットワーク」からのアクセスと
 * みなされたIPアドレスは除外となるので、上の方法との併用は無意味です。
 * DNSBLの確認はセッションが初期化される際にのみ行われ、以降セッションが継
 * 続している間は行われません。つまり、セッション機能を無効にしている場合に
 * はこれは機能しません。
 * 定数RESTRICT_HOSTS_INDNSBLがtrueの場合、DNSBLの確認を行います。
 * 配列$dnsblsには、利用するDNSBLサーバを指定します。
 * なお、この機能を利用するにはPEARのNet_DNSBLとNet_CheckIPが必要です。
 */

// define('RESTRICT_HOSTS_INDNSBL', true);
// $dnsbls = array(
//	'niku.2ch.net',
//	'bsb.spamlookup.net',
//	'zen.spamhaus.org',
// );

/* -------------------------------------------------------------------------
	SSL（HTTPS）通信の可否
------------------------------------------------------------------------- */

/* サーバのPHPにOpenSSLモジュールが組み込まれていない場合はHTTPSで始まるURL
 * にはアクセスはできません。
 * この場合は、以下をfalseまたはコメントアウトにしてください。
 */

define('SSL_ENABLED', true);

/* -------------------------------------------------------------------------
	RSSフィードの変換の可否
------------------------------------------------------------------------- */

/* サーバのPHPにXMLモジュールが組み込まれていない、あるいはPEARのXML_RSSパ
 * ッケージが利用できない場合はRSSフィードの変換表示は行えません。
 * この場合は、以下をfalseまたはコメントアウトにしてください。
 */

define('RSS_ENABLED', true);

/* -------------------------------------------------------------------------
	既定のアクセス先URL
------------------------------------------------------------------------- */

/* リクエストに適切なURLまたは（クイックサーチ機能が有効の場合）検索語が含
 * まれない場合、Frontpage.inc.phpの内容を表示するか、以下で指定するURLをデ
 * フォルトのアクセス先とするか、いずれかを選択できます。
 * Frontpage.inc.phpの内容を表示する場合は以下はコメントアウトしてください。
 */

// define('DEFAULT_URL', 'http://www.foo.bar/');

/* -------------------------------------------------------------------------
	リクエストキーワードの先頭文字
------------------------------------------------------------------------- */

/* このスクリプトでは、リクエストの内容に、未エンコードのURLも受け付けます
 * が、その場合スクリプト自身が取り扱うものと、アクセス先のサイトに引き渡す
 * べきものとが混在する可能性があり、両者を区別するためには、スクリプト自身
 * が取り扱うリクエストのキーワードは、アクセス先のサイトで使用されていない
 * ものにしておく必要があります。
 * ここでは、スクリプト自身が扱うリクエストについて、その全てのキーワードの
 * 先頭に共通に付与される文字を指定します。例えばこれを「_foo_」とした場
 * 合、スクリプトに渡されるアクセス先のURLは「_foo_u」というキーワードで参
 * 照されることになります。
 * 指定可能な文字種は英数字と「-_」です。また「si|ui|li」は使用できません。
 * なお、携帯端末ではクエリー文字列の長さに制限があるので（通常は500バイト
 * 程度で、300バイト以内という機種も存在する模様）、あまり長い文字列は避け
 * てください。
 */

define('KEY_PREFIX', '_ucb_');

/* -------------------------------------------------------------------------
	User-Agent
------------------------------------------------------------------------- */

/* スクリプトがサイトにアクセスする際のUser-Agent（HTTP_USER_AGENT）です。
 * サイトによってはこの内容によって表示内容が変わる場合があります。
 * 未定義の場合はPEARのHTTP_Requestの既定のものが使われます。
 */

define(
	'PEAR_USER_AGENT',
	'Mozilla/5.0 (compatible; PEAR HTTP_Request class; http://www.rcdtokyo.com/pc2m/)'
);

/*
 * 設定画面での選択で、上のUser-Agentヘッダに替えて以下の連想配列で指定する
 * HTTPヘッダを出力することができます。
 * HTTPヘッダは、User-Agentに限らず任意のものが指定できます（User-Agentを指
 * 定しない場合は、PEARのHTTP_Requestの既定のものが使われます）。また、ここ
 * での指定は、このスクリプトが既定で出力するHTTPヘッダを上書きします。
 * なお、携帯端末での表示をエミュレートする用途でこれを利用する場合、携帯端
 * 末の多くは独自のHTTPヘッダを出力しており、携帯端末を判別するウェブアプリ
 * ケーションは、こうした独自のHTTPヘッダをその判別に用いる場合がある点に注
 * 意してください。
 */

/* [書式]
 * $alternative_http_headers = array (
 *     array(
 *         'description' => '設定画面で表示される項目名',
 *         'headers' => array(
 *             'HTTPヘッダ名' => '値'
 *         )
 *     )
 * );
 */

// $alternative_http_headers = array(
// 	array(
// 		'description' => 'DoCoMo D505i',
// 		'headers' => array(
// 			'User-Agent' => 'DoCoMo/1.0/D505i/c20/TB/W20H10'
// 		)
// 	),
// 	array(
// 		'description' => 'Nokia 6230i',
// 		'headers' => array(
// 			'User-Agent' => 'Nokia6230i/2.0 (03.25) Profile/MIDP-2.0 Configuration/CLDC-1.1',
// 			'Accept-Charset' => 'ISO-8859-1, US-ASCII, UTF-8; q=0.8, ISO-10646-UCS-2; q=0.6',
// 			'Accept-Language' => 'en',
// 			'X-Wap-Profile' => 'http://nds1.nds.nokia.com/uaprof/N6230ir200.xml'
// 		)
// 	),
// );

/* -------------------------------------------------------------------------
	ページ分割の計算時に端末のキャッシュサイズから控除するバイト数
------------------------------------------------------------------------- */

/* メインのスクリプトの冒頭にある「define('DEBUG_MODE', false);」とある部分
 * の「false」を「true」に変更すると、スクリプトの表示の末尾に、
 * 「Length:***bytes」のように、その出力内容の総バイト数が表示されます。
 * 以下の値は、これを参考に調整するといいかもしれません。
 */

/* アクセス先のページを変換したHTMLソースのサイズが端末のキャッシュサイズを
 * 超える場合はページが分割されますが、分割を計算する時点ではHTML出力のテン
 * プレート（Template.inc.php）に書かれたメニュー部分などのサイズはわかって
 * いません。
 * そこで、定数SIZE_REDUNDANCYにこれに相当する値を指定しておき、その値を分
 * 割の計算時に差し引くという方法を採っています。
 * Template.inc.phpの出力内容を考慮して適当と思われる値を指定してください。
 * 厳密である必要はありません。
 * 未定義の場合は「1000」バイトとなります。
 */

define('SIZE_REDUNDANCY', 1000);

/* 定数URL_REDUNDANCYには、Template.inc.phpでアクセス先のURLが登場する回数
 * を指定してください。これも厳密である必要はありません。
 * 上の定数SIZE_REDUNDANCYは固定値ですが、実際にTemplate.inc.phpが展開され
 * るサイズは可変で、特にアクセス先のURLの文字数によって大幅に変動します。
 * そこでページ分割の計算時には、上の定数SIZE_REDUNDANCYの値に加えて、アク
 * セス先のURLをエンコードした文字数に以下の定数URL_REDUNDANCYの値を乗じた
 * 数も控除します。
 * 未定義の場合は「4」回となります。
 */

define('URL_REDUNDANCY', 4);

/* -------------------------------------------------------------------------
	キャッシュサイズの上限値
------------------------------------------------------------------------- */

/* アクセス先のページを変換したHTMLソースのサイズはキャッシュサイズに応じて
 * 分割されますが、キャッシュサイズの指定がリクエストに含まれない場合は、端
 * 末のキャッシュサイズが利用されます。端末のキャッシュサイズは、端末が送信
 * する環境変数を参照して取得しますが、端末によっては、実際にはそのキャッ
 * シュサイズ分の量のHTMLソースを、全て処理しないものもある模様です。
 * 定数CACHESIZE_THRESHOLDが定義されている場合、キャッシュサイズの指定がリ
 * クエストに含まれない場合は、端末のキャッシュサイズ（バイト単位）がこれ以
 * 上の値なら、スクリプトがページ分割の計算に利用するキャッシュサイズはこの
 * 値となります。
 * これにより、上述のような端末で、ページが表示できない問題を回避します。
 */

define('CACHESIZE_THRESHOLD', 20000);

/* -------------------------------------------------------------------------
	META refreshによるリダイレクト回数の制限
------------------------------------------------------------------------- */

/* サイトによっては、META refreshで移動を繰り返す場合がありますが、無限ルー
 * プに陥る指定になっている可能性もあり得るため、回数制限を設けます。
 * 未定義の場合は「5」回となります｡
 */

define('MAX_META_REDIRECT', 5);

/* -------------------------------------------------------------------------
	最大で読み込むContent-Length
------------------------------------------------------------------------- */

/* アクセス先のサーバがContent-Lengthヘッダを出力する場合、このサイズを超え
 * るファイルは読み込みません。
 * 未定義の場合は「300000」バイト（300KB）となります。
 */

define('ALLOWABLE_CLENGTH', 1000000);

/* -------------------------------------------------------------------------
	imgタグを切り捨てるしきい値
------------------------------------------------------------------------- */

/* PC向けのサイトでは、デザイン上のちょっとした飾りのために画像が用いられま
 * すが、携帯端末での閲覧時にはこれらは無意味なので、これらを除去するための
 * 設定です。
 * widthまたはheightがピクセル単位で指定されていて、その値がこれ以下のimgタ
 * グは除去されます。ちなみに、width/heightが％での指定の場合はその値に関わ
 * らず全て除去します。
 * 未定義の場合は全てのimgタグは除去されません。
 */

define('IMG_THRESHOLD', 50);

/* -------------------------------------------------------------------------
	リサイズを許可する画像の最大横幅
------------------------------------------------------------------------- */

/* 定数ALLOWABLE_PIXSIZEは画像の最大横幅で、スクリプトの利用者が画像サイズの入
 * 力欄にこれを超える値を入力した場合、あるいは端末の画面サイズがこの値を超える
 * 場合は、この値が利用されます。
 * なおこの指定は画像の縦長は制限しません。
 * 未定義の場合は「640」ピクセルとなります。
 */

define('ALLOWABLE_PIXSIZE', 640);

/* -------------------------------------------------------------------------
	既定の画質
------------------------------------------------------------------------- */

/* 画像変換時に、画質が指定されていない場合の規定の画質を指定します。
 * AVERAGE_COMPRESSION_RATIOは、JPEGに変換する際のJPEG圧縮率（%）で、未定義
 * の場合は「50」となります。
 * AVERAGE_PALETTE_BITは、JPEGなどのフルカラー画像を、PNGまたはGIFに変換する
 * 際のパレットの色深度（ビット数）で、未定義の場合は「6」となります。また、
 * 画質が%で指定された場合はこの値を50%として色深度が算出されます。
 * 詳細は以下の「画質の選択」をご覧ください。
 * http://www.rcdtokyo.com/pc2m/note/archives/i000161.php
 */

define('AVERAGE_COMPRESSION_RATIO', 50);
define('AVERAGE_PALETTE_BIT', 6);

/* -------------------------------------------------------------------------
	“リッチ”端末の設定
------------------------------------------------------------------------- */

/* 設定画面で変更できる各項目の初期値は、キャッシュサイズが充分ではない旧来
 * の端末でも支障のないような設定になっていますが、“リッチ”だとみなされる
 * 端末に対しては、これらの初期値を変更することができます。
 * 端末のキャッシュサイズが定数RICHTERM_THRESHOLD（バイト単位）以上なら、そ
 * の端末は“リッチ”だとみなし、各設定値が初期状態で適用されます。
 * この機能を無効にする場合は、これをコメントアウトしてください。
 * 定数RICHTERM_VISUALは「テキストと画像の同時表示」、定数
 * RICHTERM_LEGACYTAGSは「装飾タグの保持」、定数RICHTERM_KANACONVは「全角->
 * 半角変換」の、各設定値で、その値には、設定画面の各フォームのvalue値と同じ
 * 値を使用します。いずれも、コメントアウトにすることで、その項目の変更につ
 * いては適用外とすることができます。
 * いずれも、その本来の初期値を変更するとパケットをより多く消費することにな
 * ります。従って、パケ放題の加入者ではない端末の利用が見込まれる場合は、こ
 * の機能は利用するべきではないでしょう。
 */

define('RICHTERM_THRESHOLD', 98304);
define('RICHTERM_VISUAL', 1);
define('RICHTERM_LEGACYTAGS', 1);
define('RICHTERM_KANACONV', 1);

/* -------------------------------------------------------------------------
	クエリー文字列での表示設定の保持
------------------------------------------------------------------------- */

/* セッション機能が有効の場合、設定画面で行う表示設定はセッションデータに保
 * 存されます。定数KEEP_SETTING_INQUERYがfalseまたは未定義の場合、セッショ
 * ンが期限切れなどで初期化された場合は表示設定も初期化されますが、これが
 * trueの場合、設定値はURLのクエリー文字列中にも埋め込まれるため、セッショ
 * ンが初期化された後も、表示については引き続き同じ設定で利用し続けることが
 * できます。ただし、その分URLが冗長になるため、1画面あたりに表示可能な文字
 * 数は減少します。
 */

define('KEEP_SETTING_INQUERY', true);

/* -------------------------------------------------------------------------
	インデントを伴うタグの変換
------------------------------------------------------------------------- */

/* 一般的に携帯端末は一行あたりに表示可能な文字数が限られるため、インデント
 * を伴う表示は好ましいとは限りません。定数CONVERT_INDENT_TAGSがtrueの場合
 * インデントを伴うタグの幾つかを、インデントを伴わないものに変換します。
 * この場合、blockquoteはhrに、dl|dt|ddはpに変換されます。
 */

// define('CONVERT_INDENT_TAGS', true);

/* -------------------------------------------------------------------------
	データベース関連
------------------------------------------------------------------------- */

/* この項目の説明は、README_DBOPT.TXTファイルをご覧ください。
 */

// define('USE_DATABASE', true);
$dbconf = array(
	'dbtype' => 'mysql',
	'host' => 'localhost',
	'port' => '3306',
	'user' => 'データベース接続用のユーザ名',
	'pass' => 'データベース接続用のパスワード',
	'dbname' => 'データベース名',
	'prefix' => 'pc2m_',
);
define('DBGC_RECORDEXPIRE_SINCELAST', 7 * 24 * 60 * 60);
define('DBGC_RECORDEXPIRE_NOTINUSE', 2 * 60 * 60);
define('DBGC_INTERVAL', 2 * 60 * 60);

/* -------------------------------------------------------------------------
	クイックサーチの設定
------------------------------------------------------------------------- */

/* URL入力欄にURLとして評価できない文字列が入力された場合、その文字列を検索
 * 語として、設定されているURLに付与して送信した結果を表示します。
 * 利用者は「キーワード 検索語」（スペース区切り）と入力することで、検索語
 * を送信するURLを特定することができます。キーワードが省略された場合は、定
 * 数QUICK_SEARCHの値をキーワードとして使用します。
 * 定数QUICK_SEARCHが未定義の場合、この機能は無効となり、URL入力欄にURLとし
 * て評価できない文字列が入力された場合はエラーメッセージが表示されます。
 */

define('QUICK_SEARCH', 'g');

/* 連想配列$quick_searchの添え字はキーワードで、英数字の小文字のみ有効です
 * （キーワードは小文字に変換の上評価されるためで、利用者が入力するキーワー
 * ドは大小文字のいずれでも構いません）。なお、「英数字.（ドット）英数字」
 * という文字列はURL（の一部）とみなされるため使用できません。
 * 値は配列で、その最初の値は検索語を付与するGETリクエストのURLで、二番目の
 * 値はURLに検索語を付与する際の文字エンコーディングです。
 */

/* [書式]
 * $quick_search = array (
 *     'キーワード' => array(
 *         '検索語が追加されるGETリクエストのURL',
 *         'URLに検索語を付与する際の文字エンコーディング'
 *     )
 * );
 */

$quick_search = array(

	/* google */
	'g' => array(
		'http://www.google.co.jp/search?lr=lang_ja&q=',
		'UTF-8'
	),
	/* google「I'm Feeling Lucky」 */
	'gfl' => array(
		'http://www.google.co.jp/search?lr=lang_ja&btnI=I%27m+Feeling+Lucky&q=',
		'UTF-8'
	),
	/* wikipedia日本語 */
	'wpj' => array(
		'http://ja.wikipedia.org/wiki/Special:Search?search=',
		'UTF-8'
	),
	/* スペースALC 英辞郎 */
	'alc' => array(
		'http://www2.alc.co.jp/ejr/index.php?word_in2=%82%A0%82%A2%82%A4%82%A6%82%A8&word_in3=PVawEWi72JXCKoa0Je&word_in=',
		'SJIS'
	),
);

/* -------------------------------------------------------------------------
	自動トリミングの設定
------------------------------------------------------------------------- */

/* 表示開始位置の指定がない場合で、アクセス先のURLが、連想配列$force_trimの
 * 添え字を含む場合、そのキーの値として設定されている検索語が最初に登場する
 * 位置から表示を開始します。ニュースやブログのサイトなどを、記事本文に先立
 * ってメニュー項目などが延々と表示されるサイトについて、記事本文から表示が
 * 開始されるようにすることを想定しています。
 */

/* 自動トリミングを行わない場合は、定数FORCE_TRIMをfalseまたはコメントアウ
 * トしてください。
 */

define('FORCE_TRIM', true);

/* 連想配列$force_trimの添え字は、自動トリミングの対象となるURLの一部です。
 * これは部分一致で評価され大小文字を区別しません。また、添え字の評価は記述
 * してある順番に行われ、合致するものが見つかれば以降の添え字は評価されませ
 * ん。つまり例えば、添え字が「example.com」→「sub.example.com」という順番
 * に書かれている場合、後者が評価されることはありません。ちなみに、添え字に
 * 「.」と指定すると全てのURLに合致するわけですが、この指定は必ず最後に記述
 * しなければなりません。
 * 値は配列で、その最初の値は検索語を、二番目の値は検索語をid|name属性の値
 * として検索するかどうかの真偽値です。検索語は完全一致で評価され大小文字を
 * 区別します。
 * 検索語をさらに配列とすることで、ひとつの添え字に対して複数の検索語を設定
 * することができます。
 * 真偽値がtrueの場合、検索語はid|name属性の値として検索されます。例えば、
 * これがtrueで、検索語が「content」だった場合、「id="content"」や
 * 「name="content"」などの文字列が全て検索の対象になり、括り文字のバリエー
 * ションや空白文字の有無も考慮されます。
 */

/* [書式]
 * $force_trim = array (
 *     'URLの一部' => array(
 *         '検索語'またはarray('検索語', '検索語', ...),
 *         true|false（検索語をid|name属性の値として検索するかどうか）
 *     ),
 * );
 */

$force_trim = array(

	'nikkei.co.jp' => array(
		'topnews',
		true,
	),
	'nikkeibp.co.jp' => array(
		'article',
		true,
	),
	'asahi.com' => array(
		'constart',
		true,
	),
	'nikkansports.com' => array(
		array('content', 'mainnews'),
		true,
	),
	'mainichi-msn.co.jp' => array(
		'main',
		true,
	),
	'sankei.co.jp' => array(
		array('tpP', 'headln'),
		true,
	),
	'sanspo.com' => array(
		'main',
		true,
	),
	'hochi.yomiuri.co.jp' => array(
		'top',
		true,
	),
	'yomiuri.co.jp' => array(
		'main',
		true,
	),
	'cnn.co.jp' => array(
		array('topnews', 'kiji'),
		true,
		),
	'pcweb.mycom.co.jp' => array(
		'Contents',
		true,
	),
	'itmedia.co.jp' => array(
		'mark',
		true,
	),
);

/* -------------------------------------------------------------------------
	文字エンコーディングの指定など
------------------------------------------------------------------------- */

define('OUTPUT_ENC', 'SJIS-win');
define('INT_ENC', 'UTF-8');
define('DETECT_ORDER', 'ASCII, JIS, UTF-8, EUC-JP, SJIS');

/* -------------------------------------------------------------------------
	全角半角の変換
------------------------------------------------------------------------- */

/* 表示モードが全角半角の変換を「する」の場合の、mb_convert_kana関数の動作
 * を決めるオプション文字の組み合わせを指定します。
 * これを例えば「ask」とすると、全角の英数字、スペース、カタカナが半角に変
 * 換されます。未定義の場合は空文字列（変換しない）になります。
 * 以下は、主なオプション文字です。
 *
 * r：全角アルファベットを半角に
 * n：全角数字を半角に
 * a：全角アルファベットと数字を半角に
 * s：全角スペースを半角に
 * k：全角カタカナを半角に
 *
 * その他のオプション文字については以下のPHPマニュアルを参照してください。
 * ただし、オプション文字のうち「NAS」はいずれも指定してはいけません。
 * これらが指定されていると、HTMLタグまでもが全角文字に変換され、HTMLタグと
 * して認識されなくなります。
 * http://www.php.net/manual/ja/function.mb-convert-kana.php
 */

define('KANA_CONVOPT', 'ask');

/* -------------------------------------------------------------------------
	文字の変換表
------------------------------------------------------------------------- */

/* 携帯端末が表示できない実体参照などを代替文字に置き換える変換表です。
 * 置換はpreg_replace関数により行われ、、連想配列$replace_charsの各キーが、
 * 検索を行う正規表現パターンで、その値が、パターンを置換する文字列となりま
 * す。正規表現と修飾子については以下のPHPマニュアルを参照してください。
 * http://www.php.net/manual/ja/pcre.pattern.syntax.php
 * http://www.php.net/manual/ja/pcre.pattern.modifiers.php
 *
 * なお、「全角半角の変換」設定で「r」または「a」を指定している場合は、必ず
 * 全角の「＜」を「&lt;」に、全角の「＞」を「&gt;」に変換する設定を加えてく
 * ださい。さもなければ、それぞれ半角に変換された結果、端末|ブラウザはこれ
 * をタグの開閉記号と誤認します。
 */

/* [書式]
 * $replace_chars = array(
 *     "'変換元の正規表現'修飾子" => "変換後の文字列",
 * );
 */

$replace_chars = array(

	// 全角記号
	"'＜'"						=> "&lt;",
	"'＞'"						=> "&gt;",

	// 実体参照 一般記号
	"'&(?:#128|#8364|euro);'"	=> "EUR.",
	"'&(?:#137|#8240|permil);'"		=> "‰",
	"'&(?:#153|trade);'"		=> "(TM)",
	"'&(?:#160|nbsp);'"			=> "\x20",
	"'&(?:#161|iexcl);'"		=> "!",
	"'&(?:#162|cent);'"			=> "￠",
	"'&(?:#163|pound);'"		=> "￡",
	"'&(?:#165|yen);'"			=> "\\",
	"'&(?:#166|brvbar);'"		=> "",
	"'&(?:#167|sect);'"			=> "§",
	"'&(?:#168|uml);'"			=> "¨",
	"'&(?:#170|ordf);'"			=> "(a)",
	"'&(?:#171|laquo);'"		=> "&lt;&lt;",
	"'&(?:#176|deg);'"			=> "°",
	"'&(?:#182|para);'"			=> "¶",
	"'&(?:#183|middot);'"		=> "・",
	"'&(?:#187|raquo);'"		=> "&gt;&gt;",
	"'&(?:#188|frac14);'"		=> "1/4",
	"'&(?:#189|frac12);'"		=> "1/2",
	"'&(?:#190|frac34);'"		=> "3/4",
	"'&(?:#191|iquest);'"		=> "?",
	"'&(?:#402|fnof);'"			=> "f",
	"'&(?:#8211|ndash);'"		=> "-",
	"'&(?:#8212|mdash);'"		=> "－",
	"'&(?:#8216|lsquo);'"		=> "‘",
	"'&(?:#8217|rsquo);'"		=> "’",
	"'&(?:#8218|sbquo);'"		=> ",",
	"'&(?:#8220|ldquo);'"		=> "“",
	"'&(?:#8221|rdquo);'"		=> "”",
	"'&(?:#8224|dagger);'"		=> "†",
	"'&(?:#8225|Dagger);'"		=> "‡",
	"'&(?:#8226|bull);'"		=> "・",
	"'&(?:#8230|hellip);'"		=> "…",
	"'&(?:#8242|prime);'"		=> "′",
	"'&(?:#8243|Prime);'"		=> "″",
	"'&(?:#8249|lsaquo);'"		=> "&lt;",
	"'&(?:#8250|rsaquo);'"		=> "&gt;",
	"'&(?:#8254|oline);'"		=> "~",
	"'&(?:#8260|frasl);'"		=> "/",
	"'&(?:#8465|image);'"		=> "I",
	"'&(?:#8472|weierp);'"		=> "p",
	"'&(?:#8476|real);'"		=> "R",
	"'&(?:#8592|larr);'"		=> "←",
	"'&(?:#8593|uarr);'"		=> "↑",
	"'&(?:#8594|rarr);'"		=> "→",
	"'&(?:#8595|darr);'"		=> "↓",
	"'&(?:#8596|harr);'"		=> "⇔",
	"'&(?:#8656|lArr);'"		=> "←",
	"'&(?:#8657|uArr);'"		=> "↑",
	"'&(?:#8658|rArr);'"		=> "⇒",
	"'&(?:#8659|dArr);'"		=> "↓",
	"'&(?:#8660|hArr);'"		=> "⇔",
	"'&(?:#8901|sdot);'"		=> ".",
	"'&(?:#8968|lceil);'"		=> "「",
	"'&(?:#8971|rfloor);'"		=> "」",
	"'&(?:#9001|lang);'"		=> "{",
	"'&(?:#9002|rang);'"		=> "}",

	// 実体参照 数学記号
	"'&(?:#172|not);'"			=> "￢",
	"'&(?:#177|plusmn);'"		=> "±",
	"'&(?:#178|sup2);'"			=> "(2)",
	"'&(?:#179|sup3);'"			=> "(3)",
	"'&(?:#185|sup1);'"			=> "(1)",
	"'&(?:#215|times);'"		=> "×",
	"'&(?:#247|divide);'"		=> "÷",
	"'&(?:#8704|forall);'"		=> "∀",
	"'&(?:#8706|part);'"		=> "∂",
	"'&(?:#8707|exist);'"		=> "∃",
	"'&(?:#8711|nabla);'"		=> "∇",
	"'&(?:#8712|isin);'"		=> "∈",
	"'&(?:#8715|ni);'"			=> "∋",
	"'&(?:#8721|sum);'"			=> "∑",
	"'&(?:#8722|minus);'"		=> "－",
	"'&(?:#8730|radic);'"		=> "√",
	"'&(?:#8733|prop);'"		=> "∝",
	"'&(?:#8734|infin);'"		=> "∞",
	"'&(?:#8736|ang);'"			=> "∠",
	"'&(?:#8743|and);'"			=> "∧",
	"'&(?:#8744|or);'"			=> "∨",
	"'&(?:#8745|cap);'"			=> "∩",
	"'&(?:#8746|cup);'"			=> "∪",
	"'&(?:#8747|int);'"			=> "∫",
	"'&(?:#8756|there4);'"		=> "∴",
	"'&(?:#8776|asymp);'"		=> "≒",
	"'&(?:#8786|cong);'"		=> "≒",
	"'&(?:#8800|ne);'"			=> "≠",
	"'&(?:#8801|equiv);'"		=> "≡",
	"'&(?:#8804|le);'"			=> "<=",
	"'&(?:#8805|ge);'"			=> ">=",
	"'&(?:#8834|sub);'"			=> "⊂",
	"'&(?:#8835|sup);'"			=> "⊃",
	"'&(?:#8838|sube);'"		=> "⊆",
	"'&(?:#8839|supe);'"		=> "⊇",
	"'&(?:#8869|perp);'"		=> "⊥",

	// 実体参照 ギリシャ文字
	"'&(?:#913|Alpha);'"		=> "Α",
	"'&(?:#914|Beta);'"			=> "Β",
	"'&(?:#915|Gamma);'"		=> "Γ",
	"'&(?:#916|Delta);'"		=> "Δ",
	"'&(?:#917|Epsilon);'"		=> "Ε",
	"'&(?:#918|Zeta);'"			=> "Ζ",
	"'&(?:#919|Eta);'"			=> "Η",
	"'&(?:#920|Theta);'"		=> "Θ",
	"'&(?:#921|Iota);'"			=> "Ι",
	"'&(?:#922|Kappa);'"		=> "Κ",
	"'&(?:#923|Lambda);'"		=> "Λ",
	"'&(?:#924|Mu);'"			=> "Μ",
	"'&(?:#925|Nu);'"			=> "Ν",
	"'&(?:#926|Xi);'"			=> "Ξ",
	"'&(?:#927|Omicron);'"		=> "Ο",
	"'&(?:#928|Pi);'"			=> "Π",
	"'&(?:#929|Rho);'"			=> "Ρ",
	"'&(?:#931|Sigma);'"		=> "Σ",
	"'&(?:#932|Tau);'"			=> "Τ",
	"'&(?:#933|Upsilon);'"		=> "Υ",
	"'&(?:#934|Phi);'"			=> "Φ",
	"'&(?:#935|Chi);'"			=> "Χ",
	"'&(?:#936|Psi);'"			=> "Ψ",
	"'&(?:#937|Omega);'"		=> "Ω",
	"'&(?:#945|alpha);'"		=> "α",
	"'&(?:#946|beta);'"			=> "β",
	"'&(?:#947|gamma);'"		=> "γ",
	"'&(?:#948|delta);'"		=> "δ",
	"'&(?:#949|epsilon);'"		=> "ε",
	"'&(?:#950|zeta);'"			=> "ζ",
	"'&(?:#951|eta);'"			=> "η",
	"'&(?:#952|theta);'"		=> "θ",
	"'&(?:#953|iota);'"			=> "ι",
	"'&(?:#954|kappa);'"		=> "κ",
	"'&(?:#955|lambda);'"		=> "λ",
	"'&(?:#956|mu);'"			=> "μ",
	"'&(?:#957|nu);'"			=> "ν",
	"'&(?:#958|xi);'"			=> "ξ",
	"'&(?:#959|omicron);'"		=> "ο",
	"'&(?:#960|pi);'"			=> "π",
	"'&(?:#961|rho);'"			=> "ρ",
	"'&(?:#963|sigma);'"		=> "σ",
	"'&(?:#964|tau);'"			=> "τ",
	"'&(?:#965|upsilon);'"		=> "υ",
	"'&(?:#966|phi);'"			=> "φ",
	"'&(?:#967|chi);'"			=> "χ",
	"'&(?:#968|psi);'"			=> "ψ",
	"'&(?:#969|omega);'"		=> "ω",

	// The character entity references of some Latin-1 and 2 caharacters
	// will be replaced with a plain ASCII character.
	// Note that the numeric character reference is not supported here.
	"'&([a-z])grave;'i"			=> "\\1",
	"'&([a-z])acute;'i"			=> "\\1",
	"'&([a-z])circ;'i"			=> "\\1",
	"'&([a-z])tilde;'i"			=> "\\1",
	"'&([a-z])uml;'i"			=> "\\1",
	"'&([a-z])ring;'i"			=> "\\1",
	"'&([a-z]{2})lig;'i"		=> "\\1",
	"'&([a-z])cedil;'i"			=> "\\1",
	"'&(o)slash;'i"				=> "\\1",
	"'&([a-z])caron;'i"			=> "\\1",

	// Single raw characters of some Latin-1 supplements
	// will be replaced with a plain ASCII character.
	// THIS IS VALID ONLY IF INT_ENC CONSTANT (SEE ABOVE) IS UTF-8.
	// "'\xc2\xa1'"						=> "!",
	// "'\xc3[\x80\x81\x82\x83\x84\x85]'"	=> "A",
	// "'\xc3\x86'"						=> "AE",
	// "'\xc3\x87'"						=> "C",
	// "'\xc3[\x88\x89\x8a\x8b]'"			=> "E",
	// "'\xc3[\x8c\x8d\x8e\x8f]'"			=> "I",
	// "'\xc3\x90'"						=> "D",
	// "'\xc3\x91'"						=> "N",
	// "'\xc3[\x92\x92\x93\x94\x95\x96]'"	=> "O",
	// "'\xc3[\x99\x9a\x9b\x9c]'"			=> "U",
	// "'\xc3\x9d'"						=> "Y",
	// "'\xc3[\xa0\xa1\xa2\xa3\xa4\xa5]'"	=> "a",
	// "'\xc3\xa6'"						=> "ae",
	// "'\xc3\xa7'"						=> "c",
	// "'\xc3[\xa8\xa9\xaa\xab]'"			=> "e",
	// "'\xc3[\xac\xad\xae\xaf]'"			=> "i",
	// "'\xc3\xb1'"						=> "n",
	// "'\xc3[\xb2\xb3\xb4\xb5\xb6]'"		=> "o",
	// "'\xc3[\xb9\xba\xbb\xbc]'"			=> "u",
	// "'\xc3[\xbd\xbf]'"					=> "y",
);

/* -------------------------------------------------------------------------
	拡張子によるMIMEタイプの強制割り当て
------------------------------------------------------------------------- */

/* このスクリプトは、アクセス先のオブジェクトの処理方法を、アクセス先のサー
 * バが送信するそのMIMEタイプ（Content-Type）によって判断しており、通常はフ
 * ァイルの拡張子については考慮しません。しかし、アクセス先のサーバの管理者
 * が、必ずしも適切なMIMEタイプを設定しているとは限らず、例えば、マルチメデ
 * ィアオブジェクトのメタファイルはしばしばtext/plainに設定されています。
 * 以下の連想配列$mime_typesに登録した拡張子は、サーバの送信するMIMEタイプ
 * に関わらず、登録したMIMEタイプとして処理されます。
 * なお、このスクリプトがサポートしていないMIMEタイプについては、サポート外
 * である旨のエラーメッセージが表示されるのみなので、これらについてはMIMEタ
 * イプを正確に記述する必要はありません。
 */

/* [書式]
 * $mime_types = array(
 *     '拡張子' => 'MIMEタイプ',
 * );
 */

$mime_types = array(
	// RealVideo/Audio
	'ra'	=> 'audio/x-pn-realaudio',
	'ram'	=> 'audio/x-pn-realaudio',
	'rpm'	=> 'audio/x-pn-realaudio-plugin',

	// Windows Media
	'asf'	=> 'video/x-ms-asf',
	'asx'	=> 'video/x-ms-asf',
	'wma'	=> 'audio/x-ms-wma',
	'wax'	=> 'audio/x-ms-wax',
	'wmv'	=> 'video/x-ms-wmv',
	'wvx'	=> 'video/x-ms-wvx',
	'wm'	=> 'video/x-ms-wm',
	'wmx'	=> 'video/x-ms-wmx',
);

/* -------------------------------------------------------------------------
	アクセス先の制限
------------------------------------------------------------------------- */

/* このスクリプトを自身のサイトの携帯対応に利用する場合は、自身のサイト以外
 * にはこのスクリプト経由でアクセスされたくはないかもしれません。
 * このように特定のURL以外へのアクセスを禁止したい場合は、定数RESTRICT_URL
 * をtrueにし、配列$allowed_urlにアクセスを許可するURLのホスト名とパス名を
 * 指定してください。
 * ホスト名は後方一致で評価されます。つまり「.foo.bar」と指定した場合
 * 「www.foo.bar」にも「home.foo.bar」にもマッチし、「www.foo.bar」とすれば
 * 「home.foo.bar」にはマッチしません。なお先頭にピリオドのない「foo.bar」
 * は「barfoo.bar」にもマッチするので注意してください。
 * パスは評価不要なら省略してください。パス名は複数指定できます。
 * パス名は前方一致で評価されますが、URLの評価は利用者が指定したURL（アクセ
 * ス先のサーバによるリダイレクトなどの処理を反映したものではなく）に対して
 * 行われる点に注意してください。つまり、利用者は
 * 「http://www.example.com/foo/(index.html)」というURLを省略して、
 * 「www.example.com/foo」と指定することができますが、あなたがfooディレクト
 * リ以外へのアクセスを禁止したいと思って、パス名を「/foo/」と指定している
 * と、これはこの省略形のURLにはマッチしません。一方「/foo」はこれにマッチ
 * しますが「/foobar」にもマッチしてしまいます。
 * なお、この指定は画像に対しても有効なので、画像がHTMLとは異なるホスト/パ
 * スから配信される場合はそちらも指定しておく必要があります。例えばAmazonア
 * ソシエイトを利用していて、商品画像をAmazonが配信しているものを表示してい
 * る場合「images.amazon.com」などへのアクセスも許可する必要があります。
 */

// define('RESTRICT_URL', true);

/* [書式]
 * $allowed_url = array (
 *     array(
 *         'ホスト',
 *         array(
 *             'パス1'
 *             'パス2'
 *         )
 *     )
 * );
 */

// $allowed_urls = array(
// 	array(
// 		'.foo.bar'
// 	),
// 	array(
// 		'www.example.com',
// 		array(
// 			'/foo',
// 			'/bar',
// 		)
// 	),
// );

// $urls_to_redirect = array(
// 	array(
// 		'.foo.bar'
// 	),
// 	array(
// 		'www.example.com',
// 		array(
// 			'/foo',
// 			'/bar',
// 		)
// 	),
// );

/* -------------------------------------------------------------------------
	アクセスキーを有効にするURL
------------------------------------------------------------------------- */

/* [書式]
 * $urls_to_enable_accesskey = array (
 *     array(
 *         'ホスト',
 *         array(
 *             'パス1'
 *             'パス2'
 *         )
 *     )
 * );
 */

$urls_to_enable_accesskey = array(
	array(
		'.2ch.net'
	)
);

/* -------------------------------------------------------------------------
	MISC
------------------------------------------------------------------------- */

$tags_to_remove = array('script', 'style', 'iframe', 'noframes?');
// define('FANCY_URL_PREFIX', '/pc2m/');
// define('ALWAYS_USE_FANCY_URL', true);

?>