<?php

/* -------------------------------------------------------------------------
	!!!The character encoding of this file must be `INT_ENC`
	defined in Config.inc.php (the default value is EUC-JP)!!!

	セッションの復元操作画面
	for PC2M Website Transcoder for Mobile Clients
	Copyright (C) 2005-2007 ucb.rcdtokyo and the contributors
	http://www.rcdtokyo.com/pc2m/note/
------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------
	設定画面のページタイトル
------------------------------------------------------------------------- */

define('AUTH_TITLE', 'セッションの復元');

/* -------------------------------------------------------------------------
	メッセージボディ

	メッセージボディは、HTMLソースの文字列をreturnする形式で記述します。
	以下の内容は、表示される際には全角半角の変換が行われますが、それ以外の変
	換処理は一切行われません。すなわち、携帯端末が対応しているすべてのタグを
	制約なしに利用できます。
------------------------------------------------------------------------- */

// 認証データ
$_auth_db = array(

	// '端末IDのMD5ハッシュ値' => '暗証番号のMD5ハッシュ値',

);

if (!isset($_SESSION)) {
	return 'セッションが動作していないため、この機能は利用できません。';
}
if (!isset($_auth_db) or !$_auth_db) {
	return '初期設定が完了していません。';
}
if ($local_args['p'] === null or $local_args['i'] === null) {
	return '<form action="'.basename($_SERVER['SCRIPT_NAME']).'" method="post" utn="utn">'.
		(($local_args['d'] !== null and !ENABLE_SESSION_COOKIE)?
			'<input type="hidden" name="'.KEY_PREFIX.'d" value="'.$local_args['d'].'">': null).
		'<input type="hidden" name="'.KEY_PREFIX.'a" value="l">
		<input type="radio" name="'.KEY_PREFIX.'i" value="1" checked="checked">セッション復元/バックアップ開始<br>
		<input type="radio" name="'.KEY_PREFIX.'i" value="0">バックアップ消去<br>
		<input type="password" name="'.KEY_PREFIX.'p" size="8" istyle="4"><input type="submit" value="実行">
		</form>
		<p>※バックアップを消去すると現在のセッションも破棄されるため、これまでのCookieやアクセス履歴、表示設定などは全て消滅します</p>';
}
if ($client->is_mobile === false or $client->getSerialId() === null or !isset($_SERVER['HTTP_USER_AGENT'])) {
	return '端末IDが送信されていません。';
}
if (!isset($_auth_db[md5($_SERVER['HTTP_USER_AGENT'].$client->getSerialId())])) {
	return '端末IDが一致しません。';
}
if ($_auth_db[md5($_SERVER['HTTP_USER_AGENT'].$client->getSerialId())] != md5($local_args['p'])) {
	return 'パスワードが一致しません。';
}
$_auth_key = md5($_SERVER['HTTP_USER_AGENT'].
	$client->getSerialId().
	$client->hostname.
	'1'.
	(ENABLE_SESSION_COOKIE? 1: 0).
	$local_args['p']);
$_session_save_path = realpath(session_save_path()).'/';
$_session_filename = 'sess_'.session_id();
$_backup_filename = 'pc2m_backup_'.$_auth_key;
if ($local_args['i'] === '0') {
	if (!file_exists($_session_save_path.$_backup_filename)) {
		return 'バックアップはありません。';
	}
	if (false === @unlink($_session_save_path.$_backup_filename)) {
		return 'バックアップの消去に失敗した模様。';
	}
	$_SESSION = array();
	if (isset($_COOKIE[session_name()])) {
		setcookie(session_name(), '', time() -42000, '/');
	}
	session_destroy();
	return 'バックアップを消去し、現在のセッションを破棄しました。<br>
		バックアップはキャンセルされています。再開されるまでバックアップは行われません。';
}
if ($local_args['i'] === '1') {
	if (!file_exists($_session_save_path.$_backup_filename)) {
		$_SESSION['authenticated'] = $_auth_key;
		return 'バックアップはありませんでしたので、新たにバックアップを開始しました。';
	}
	session_write_close();
	if (false === @copy($_session_save_path.$_backup_filename, $_session_save_path.$_session_filename)) {
		return 'セッションの復元に失敗した模様。';
	}
	session_start();

	$_SESSION['atime'] = time();
	if (isset($_SESSION['www_authenticate'])) {
		unset($_SESSION['www_authenticate']);
	}
	if (isset($_SESSION['history']) and !empty($_SESSION['history'])) {
		if (count($_SESSION['history']) > MAX_HISTORY_KEEP) {
			$_SESSION['history'] = sortMultiArray($_SESSION['history'], 0);
			while (count($_SESSION['history']) > MAX_HISTORY_KEEP) {
				array_pop($_SESSION['history']);
			}
		}
	}
	if (isset($_SESSION['cookies']) and !empty($_SESSION['cookies'])) {
		foreach ($_SESSION['cookies'] as $key => $value) {
			if (!isset($value['expires'])
				or $value['expires'] === null
				or strtotime($value['expires']) < time()) {
				unset($_SESSION['cookies'][$key]);
			}
		}
	}
	$fs = null;
	if (false !== $fs = filesize($_session_save_path.$_session_filename)) {
		$fs = '('.number_format(round($fs /1000), 1).'KB)';
	}
	return 'セッションを復元しました。'.$fs;
	
}

?>
