/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.weather;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import jp.sf.pal.weather.Weather;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WeatherWebService {
    public static final String WEATHER_URI = "http://weather.livedoor.com/forecast/webservice/rest/v1?";
    public static final String TODAY = "today";
    public static final String TOMORROW = "tomorrow";
    public static final String DAYAFTERTOMORROW = "dayaftertomorrow";
    public static final String FORCAST_MAP_URI = "http://weather.livedoor.com/forecast/rss/forecastmap.xml";
    public static final String NODE_TITLE = "title";
    public static final String NODE_TELOP = "telop";
    public static final String NODE_LOCATION = "location";
    public static final String ATTR_AREA = "area";
    public static final String ATTR_PREF = "pref";
    public static final String ATTR_CITY = "city";
    public static final String NODE_LINK = "link";
    public static final String NODE_PUBLICTIME = "publictime";
    public static final String NODE_IMAGE = "image";
    public static final String NODE_IMAGE_TITLE = "title";
    public static final String NODE_IMAGE_LINK = "link";
    public static final String NODE_IMAGE_URL = "url";
    public static final String NODE_IMAGE_WIDTH = "width";
    public static final String NODE_IMAGE_HEIGHT = "height";
    public static final String NODE_DESCRIPTION = "description";
    public static final String NODE_COPYRIGHT = "copyright";
    public static final String NODE_COPYRIGHT_TITLE = "title";
    public static final String NODE_COPYRIGHT_LINK = "link";
    public static final String NODE_TEMPERATURE = "temperature";
    public static final String NODE_TEMP_MAX = "max";
    public static final String NODE_TEMP_MIN = "min";
    public static final String NODE_TEMP_CELSIUS = "celsius";
    public static final String NODE_CITY = "city";
    public static final String ATTR_CITY_TITLE = "title";
    public static final String ATTR_CITY_ID = "id";
    private Weather weather;
    private Map lwwsChildMap;
    private Map cityMap = new TreeMap();
    private String city;
    private String day = "today";

    public WeatherWebService() {
        this.weather = new Weather();
    }

    public WeatherWebService(String city) {
        this();
        this.city = city;
    }

    public WeatherWebService(String city, String day) {
        this(city);
        this.day = day;
    }

    public Weather getWeather() {
        String uri = "http://weather.livedoor.com/forecast/webservice/rest/v1?city=" + this.city + "&day=" + this.day;
        this.getWeatherInfo(uri);
        return this.weather;
    }

    public Map getCityMap() {
        this.getCityInfo();
        return this.cityMap;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public void setCity(String city) {
        this.city = city;
    }

    private void getWeatherInfo(String uri) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document weather_doc = builder.parse(uri);
            Node lwws = weather_doc.getFirstChild();
            this.lwwsChildMap = this.getElement(lwws);
            this.setWeather();
        }
        catch (FactoryConfigurationError fce) {
            fce.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
    }

    private void getCityInfo() {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document city_doc = builder.parse(FORCAST_MAP_URI);
            Element rss = city_doc.getDocumentElement();
            Element channel = (Element)rss.getElementsByTagName("channel").item(0);
            Element sourceNode = (Element)channel.getElementsByTagName("ldWeather:source").item(0);
            this.setCityMap(sourceNode);
        }
        catch (FactoryConfigurationError fce) {
            fce.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
    }

    private void setCityMap(Element node) {
        NodeList nodeList = node.getChildNodes();
        String id = null;
        String title = null;
        if (nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Node childNode = nodeList.item(i);
                if (childNode.getNodeType() == 1) {
                    this.setCityMap((Element)childNode);
                }
                ++i;
            }
        } else {
            String nodeName = node.getNodeName();
            if (nodeName.equals("city")) {
                id = node.getAttribute(ATTR_CITY_ID);
                title = node.getAttribute("title");
                this.cityMap.put(Integer.parseInt(id), title);
            }
        }
    }

    private void setWeather() {
        Node titleNode = (Node)this.lwwsChildMap.get("title");
        String title = titleNode.getFirstChild().getNodeValue();
        this.weather.setTitle(title);
        Node telopNode = (Node)this.lwwsChildMap.get(NODE_TELOP);
        String telop = telopNode.getFirstChild().getNodeValue();
        this.weather.setTelop(telop);
        Node linkNode = (Node)this.lwwsChildMap.get("link");
        String link = linkNode.getFirstChild().getNodeValue();
        this.weather.setLink(link);
        Node publictimeNode = (Node)this.lwwsChildMap.get(NODE_PUBLICTIME);
        String publictime = publictimeNode.getFirstChild().getNodeValue();
        this.weather.setPublictime(publictime);
        this.getLocationInfo();
        this.getImageInfo();
        this.getCopyrightInfo();
        this.getTemperatureInfo();
        Node descriptionNode = (Node)this.lwwsChildMap.get(NODE_DESCRIPTION);
        String description = descriptionNode.getFirstChild().getNodeValue();
        this.weather.setDescription(description);
    }

    private void getLocationInfo() {
        Node locationNode = (Node)this.lwwsChildMap.get(NODE_LOCATION);
        NamedNodeMap locationAttr = locationNode.getAttributes();
        String area = locationAttr.getNamedItem(ATTR_AREA).getNodeValue();
        String pref = locationAttr.getNamedItem(ATTR_PREF).getNodeValue();
        String city = locationAttr.getNamedItem("city").getNodeValue();
        this.weather.setArea(area);
        this.weather.setPref(pref);
        this.weather.setCity(city);
    }

    private void getImageInfo() {
        Node imageNode = (Node)this.lwwsChildMap.get(NODE_IMAGE);
        Map imageMap = this.getElement(imageNode);
        Node titleNode = (Node)imageMap.get("title");
        Node linkNode = (Node)imageMap.get("link");
        Node urlNode = (Node)imageMap.get(NODE_IMAGE_URL);
        Node widthNode = (Node)imageMap.get(NODE_IMAGE_WIDTH);
        Node heightNode = (Node)imageMap.get(NODE_IMAGE_HEIGHT);
        String title = titleNode.getFirstChild().getNodeValue();
        String link = linkNode.getFirstChild().getNodeValue();
        String url = urlNode.getFirstChild().getNodeValue();
        String width = widthNode.getFirstChild().getNodeValue();
        String height = heightNode.getFirstChild().getNodeValue();
        this.weather.setImgTitle(title);
        this.weather.setImgLink(link);
        this.weather.setImgUrl(url);
        this.weather.setImgHeight(height);
        this.weather.setImgWidth(width);
    }

    private void getCopyrightInfo() {
        Node copyrightNode = (Node)this.lwwsChildMap.get(NODE_COPYRIGHT);
        Map copyrightMap = this.getElement(copyrightNode);
        Node titleNode = (Node)copyrightMap.get("title");
        Node linkNode = (Node)copyrightMap.get("link");
        String title = titleNode.getFirstChild().getNodeValue();
        String link = linkNode.getFirstChild().getNodeValue();
        this.weather.setCopyrightTitle(title);
        this.weather.setCopyrightLink(link);
    }

    private void getTemperatureInfo() {
        Map minMap;
        Node minCNode;
        Node tempNode = (Node)this.lwwsChildMap.get(NODE_TEMPERATURE);
        Map tempMap = this.getElement(tempNode);
        Map maxMap = this.getElement((Node)tempMap.get(NODE_TEMP_MAX));
        Node maxCNode = (Node)maxMap.get(NODE_TEMP_CELSIUS);
        if (maxCNode.getFirstChild() != null) {
            this.weather.setTempMax(maxCNode.getFirstChild().getNodeValue());
        }
        if ((minCNode = (Node)(minMap = this.getElement((Node)tempMap.get(NODE_TEMP_MIN))).get(NODE_TEMP_CELSIUS)).getFirstChild() != null) {
            this.weather.setTempMin(minCNode.getFirstChild().getNodeValue());
        }
    }

    private Map getElement(Node node) {
        HashMap<String, Node> elementMap = new HashMap<String, Node>();
        NodeList childNodeList = node.getChildNodes();
        int i = 0;
        while (i < childNodeList.getLength()) {
            Node childNode = childNodeList.item(i);
            if (childNode.getNodeType() == 1) {
                String nodeName = childNode.getNodeName();
                elementMap.put(nodeName, childNode);
            }
            ++i;
        }
        return elementMap;
    }
}

