/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.weather;

import java.io.IOException;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import jp.sf.pal.weather.Weather;
import jp.sf.pal.weather.WeatherWebService;

public class WeatherPortlet
extends GenericPortlet {
    public static final String CITYID_ATTR_NAME = "id";
    public static final String WEATHER_ATTR_NAME = "weather";
    public static final String CITYMAP_ATTR_NAME = "city";
    public static final String TODAY_WEATHER_ATTR_NAME = "todayweather";
    public static final String TOMORROW_WEATHER_ATTR_NAME = "tomorrowweather";
    public static final String DAYAFTERTOMORROW_WEATHER_ATTR_NAME = "dayaftertomorrowweather";
    public static final String DESCRIPTIONDISPMODE_ATTR_NAME = "description";
    public static final String IS_TODAY_WEATHER_DISPLAYED_ATTR_NAME = "istodaydisplay";
    public static final String IS_TOMORROW_WEATHER_DISPLAYED_ATTR_NAME = "istomorrowdisplay";
    public static final String IS_DAYAFTERTOMORROW_WEATHER_DISPLAYED_ATTR_NAME = "isdayaftertomorrowdisplay";
    public static final String CITY_PARAM_NAME = "city";
    public static final String TODAY_PARAM_NAME = "today";
    public static final String TOMORROW_PARAM_NAME = "tomorrow";
    public static final String DAYAFTERTOMORROW_PARAM_NAME = "dayaftertomorrow";
    public static final String DESCRIPTIONDISPMODE_PARAM_NAME = "description";
    public static final String CITY_PARAM_DEFAULT_VALUE = "default";
    public static final String DAY_PARAM_ON_VALUE = "on";
    public static final String DESCRIPTIONDISPMODE_ON_VALUE = "on";
    public static final String VIEW_MODE_ONE_DAY_JSP_PATH = "/WEB-INF/view/weather.jsp";
    public static final String VIEW_MODE_TWO_DAYS_JSP_PATH = "/WEB-INF/view/twodaysview.jsp";
    public static final String EDIT_MODE_JSP_PATH = "/WEB-INF/view/edit.jsp";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletContext context = this.getPortletContext();
        String id = request.getParameter("city");
        PortletPreferences prefs = request.getPreferences();
        if (id == null) {
            id = prefs.getValue("city", null);
        }
        WeatherWebService webService = new WeatherWebService(id);
        Map cityMap = webService.getCityMap();
        Weather today_weather = null;
        boolean dispToday = prefs.getValue(TODAY_PARAM_NAME, null).equals("on");
        request.setAttribute(IS_TODAY_WEATHER_DISPLAYED_ATTR_NAME, (Object)new Boolean(dispToday));
        if (dispToday) {
            WeatherWebService todayService = new WeatherWebService(id);
            todayService.setDay(TODAY_PARAM_NAME);
            today_weather = todayService.getWeather();
            request.setAttribute(TODAY_WEATHER_ATTR_NAME, (Object)today_weather);
        }
        Weather tomorrow_weather = null;
        boolean dispTomorrow = prefs.getValue(TOMORROW_PARAM_NAME, null).equals("on");
        request.setAttribute(IS_TOMORROW_WEATHER_DISPLAYED_ATTR_NAME, (Object)new Boolean(dispTomorrow));
        if (dispTomorrow) {
            WeatherWebService tomorrowService = new WeatherWebService(id);
            tomorrowService.setDay(TOMORROW_PARAM_NAME);
            tomorrow_weather = tomorrowService.getWeather();
            request.setAttribute(TOMORROW_WEATHER_ATTR_NAME, (Object)tomorrow_weather);
        }
        Weather dayaftertomorrow_weather = null;
        boolean dispDayAfterTomorrow = prefs.getValue(DAYAFTERTOMORROW_PARAM_NAME, null).equals("on");
        request.setAttribute(IS_DAYAFTERTOMORROW_WEATHER_DISPLAYED_ATTR_NAME, (Object)new Boolean(dispDayAfterTomorrow));
        if (dispDayAfterTomorrow) {
            WeatherWebService dayAfterTomorrowService = new WeatherWebService(id);
            dayAfterTomorrowService.setDay(DAYAFTERTOMORROW_PARAM_NAME);
            dayaftertomorrow_weather = dayAfterTomorrowService.getWeather();
            request.setAttribute(DAYAFTERTOMORROW_WEATHER_ATTR_NAME, (Object)dayaftertomorrow_weather);
        }
        if (!dispToday) {
            if (dispTomorrow) {
                request.setAttribute(TODAY_WEATHER_ATTR_NAME, (Object)tomorrow_weather);
            } else {
                request.setAttribute(TODAY_WEATHER_ATTR_NAME, dayaftertomorrow_weather);
            }
        }
        request.setAttribute("city", (Object)cityMap);
        request.setAttribute(CITYID_ATTR_NAME, (Object)id);
        boolean isDispOverview = prefs.getValue("description", null).equals("on");
        request.setAttribute("description", (Object)new Boolean(isDispOverview));
        PortletRequestDispatcher rd = null;
        rd = context.getRequestDispatcher(VIEW_MODE_ONE_DAY_JSP_PATH);
        rd.include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (request.getPortletMode().equals((Object)PortletMode.EDIT)) {
            this.processActionForEdit(request, response);
        } else if (request.getPortletMode().equals((Object)PortletMode.VIEW)) {
            this.processActionForView(request, response);
        }
    }

    private void processActionForView(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String id = request.getParameter("city");
        PortletPreferences prefs = request.getPreferences();
        if (id == null || id.equals(CITY_PARAM_DEFAULT_VALUE)) {
            id = prefs.getValue("city", null);
        }
        response.setRenderParameter("city", id);
    }

    private void processActionForEdit(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String id = request.getParameter("city");
        String today = request.getParameter(TODAY_PARAM_NAME);
        String tomorrow = request.getParameter(TOMORROW_PARAM_NAME);
        String dayaftertomorrow = request.getParameter(DAYAFTERTOMORROW_PARAM_NAME);
        String descriptionDisplayMode = request.getParameter("description");
        PortletPreferences prefs = request.getPreferences();
        if (id == null || id.equals(CITY_PARAM_DEFAULT_VALUE)) {
            id = prefs.getValue("city", null);
        }
        if (today == null && tomorrow == null && dayaftertomorrow == null) {
            return;
        }
        if (today == null) {
            today = "";
        }
        if (tomorrow == null) {
            tomorrow = "";
        }
        if (dayaftertomorrow == null) {
            dayaftertomorrow = "";
        }
        if (descriptionDisplayMode == null) {
            descriptionDisplayMode = "";
        }
        prefs.setValue("city", id);
        prefs.setValue(TODAY_PARAM_NAME, today);
        prefs.setValue(TOMORROW_PARAM_NAME, tomorrow);
        prefs.setValue(DAYAFTERTOMORROW_PARAM_NAME, dayaftertomorrow);
        prefs.setValue("description", descriptionDisplayMode);
        prefs.store();
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletContext context = this.getPortletContext();
        PortletPreferences prefs = request.getPreferences();
        String id = prefs.getValue("city", null);
        String today = prefs.getValue(TODAY_PARAM_NAME, null);
        String tomorrow = prefs.getValue(TOMORROW_PARAM_NAME, null);
        String dayaftertomorrow = prefs.getValue(DAYAFTERTOMORROW_PARAM_NAME, null);
        String descriptionDisplayMode = prefs.getValue("description", null);
        WeatherWebService webService = new WeatherWebService();
        Map cityMap = webService.getCityMap();
        request.setAttribute("city", (Object)cityMap);
        request.setAttribute(CITYID_ATTR_NAME, (Object)id);
        request.setAttribute(TODAY_PARAM_NAME, (Object)(today.equals("on") ? "checked" : ""));
        request.setAttribute(TOMORROW_PARAM_NAME, (Object)(tomorrow.equals("on") ? "checked" : ""));
        request.setAttribute(DAYAFTERTOMORROW_PARAM_NAME, (Object)(dayaftertomorrow.equals("on") ? "checked" : ""));
        request.setAttribute("description", (Object)(descriptionDisplayMode.equals("on") ? "checked" : ""));
        PortletRequestDispatcher rd = context.getRequestDispatcher(EDIT_MODE_JSP_PATH);
        rd.include(request, response);
    }
}

