<?php
require_once './conf/conf.inc.php';
require_once P2_LIB_DIR . '/FileCtl.php';
require_once P2_LIB_DIR . '/wap.class.php';

/**
 * 2ch IDɃOC
 *
 * @access  public
 * @return  string|false  2ch SIDԂ
 */
function login2ch()
{
    global $_conf;

    // 2chID, PWݒǂݍ
    if ($array = P2Util::readIdPw2ch()) {
        list($login2chID, $login2chPW, $autoLogin2ch) = $array;

    } else {
        P2Util::pushInfoHtml('<p>p2 error: 2chOĈ߂IDƃpX[ho^ĉB[<a href="login2ch.php" target="subject">2chOCǗ</a>]</p>');
        return false;
    }

    $auth2ch_url    = 'https://2chv.tora3.net/futen.cgi';
    $postf          = "ID=" . $login2chID . "&PW=" . $login2chPW; // urlencodeƒʂȂȂ̂Œ
    $x_2ch_ua       = 'X-2ch-UA: ' . $_conf['p2uaname'] . '/' . $_conf['p2version'];
    $dolib2ch       = 'DOLIB/1.00';
    $tempfile       = $_conf['pref_dir'] . "/p2temp.php";

    // Ô߂炩tempt@CĂ
    if (file_exists($tempfile)) {
        unlink($tempfile);
    }

    $curl_msg = '';

    // ܂fsockopenSSLڑ
    // PHPRpCOpenSSLT|[gLɂȂĂȂƗpłA
    // DSOŁiopenssl.{so,dll}jł̓G[oB
    // @see http://jp.php.net/manual/ja/function.fsockopen.php
    if ($_conf['precede_openssl']) {
        if (!extension_loaded('openssl')) {
            $curl_msg .= "uPHPopensslv͎gȂ悤ł";
        } elseif (!$r = _getAuth2chWithOpenSSL($login2chID, $login2chPW, $auth2ch_url, $x_2ch_ua, $dolib2ch)) {
            $curl_msg .= "uPHPopensslvŎssB";
        }
    }

    if (empty($r)) {
    
        // R}hCURLD
        if (empty($_conf['precede_phpcurl'])) {
            if (!$r = _getAuth2chWithCommandCurl($login2chID, $login2chPW, $tempfile, $auth2ch_url, $x_2ch_ua, $dolib2ch)) {
                $curl_msg .= "usystemcurlR}hvŎssB";
                if (!extension_loaded('curl')) {
                    $curl_msg .= "uPHPcurlv͎gȂ悤ł";
                } elseif (!$r = _getAuth2chWithPhpCurl($tempfile, $auth2ch_url, $x_2ch_ua, $dolib2ch, $postf)) {
                    $curl_msg .= "uPHPcurlvŎssB";
                }
            }

        // PHP CURLD
        } else {
            if (!extension_loaded('curl')) {
                $curl_msg .= "uPHPcurlv͎gȂ悤ł";
            } elseif (!$r = _getAuth2chWithPhpCurl($tempfile, $auth2ch_url, $x_2ch_ua, $dolib2ch, $postf)) {
                $curl_msg .= "uPHPcurlvŎssB";
            }

            if (empty($r)) {
                if (!$r = _getAuth2chWithCommandCurl($login2chID, $login2chPW, $tempfile, $auth2ch_url, $x_2ch_ua, $dolib2ch)) {
                    $curl_msg .= "usystemcurlR}hvŎssB";
                }
            }
        }
    
    }
    
    
    // ڑsȂ
    if (empty($r)) {
        if (file_exists($_conf['idpw2ch_php'])) { unlink($_conf['idpw2ch_php']); }
        if (file_exists($_conf['sid2ch_php']))  { unlink($_conf['sid2ch_php']); }
        
        P2Util::pushInfoHtml('<p>p2 info: 2˂ւ́IDOCsɂ́AsystemcurlR}hgp\ł邩APHP<a href="http://www.php.net/manual/ja/ref.curl.php">CURL֐</a>LłKv܂B</p>');

        P2Util::pushInfoHtml(sprintf('<p>p2 error: 2chOCɎs܂B%s</p>', hs($curl_msg)));
        return false;
    }
    
    
    
    // tempt@C͂Ɏ̂Ă
    if (file_exists($tempfile)) { unlink($tempfile); }
    
    $r = rtrim($r);
    
    // 
    if (preg_match('/SESSION-ID=(.+?):(.+)/', $r, $matches)) {
        $uaMona = $matches[1];
        $SID2ch = $matches[1] . ':' . $matches[2];
    } else {
        //error_log($r);
        if (file_exists($_conf['sid2ch_php'])) { unlink($_conf['sid2ch_php']); }
        P2Util::pushInfoHtml("<p>p2 error: 2chOCڑɎs܂B</p>");
        return false;
    }
    
    // F؏ƍsȂ
    if ($uaMona == 'ERROR') {
        file_exists($_conf['idpw2ch_php']) and unlink($_conf['idpw2ch_php']);
        file_exists($_conf['sid2ch_php']) and unlink($_conf['sid2ch_php']);
        P2Util::pushInfoHtml("<p>p2 error: 2chOCSESSION-ID̎擾Ɏs܂BIDƃpX[hmF̏AOCĉB</p>");
        return false;
    }

    //echo $r;//
    
    // SID̋L^ێ
    $cont = <<<EOP
<?php
\$uaMona = '{$uaMona}';
\$SID2ch = '{$SID2ch}';
?>
EOP;
    FileCtl::make_datafile($_conf['sid2ch_php'], $_conf['pass_perm']);
    if (false === file_put_contents($_conf['sid2ch_php'], $cont, LOCK_EX)) {
        P2Util::pushInfoHtml("<p>p2 Error: {$_conf['sid2ch_php']} ۑł܂łBOCo^sB</p>");
        return false;
    }
    
    return $SID2ch;
}


//==============================================================================
// ֐ĩt@Cł̂ݗpj
//==============================================================================
/**
 * systemR}hcurlsāA2chOCSID𓾂
 *
 * @access  private
 * @return  string|false
 */
function _getAuth2chWithCommandCurl($login2chID, $login2chPW, $tempfile, $auth2ch_url, $x_2ch_ua, $dolib2ch)
{
    global $_conf;

    $curlrtn = 1;
    
    // proxy̐ݒ
    if ($_conf['proxy_use']) {
        $with_proxy = " -x " . $_conf['proxy_host'] . ":" . $_conf['proxy_port'];
    } else {
        $with_proxy = '';
    }
    
    // usystemR}hcurlviؖ؂js
    $curlcmd = "curl -H \"{$x_2ch_ua}\" -A {$dolib2ch} -d ID={$login2chID} -d PW={$login2chPW} -o {$tempfile}{$with_proxy} {$auth2ch_url}";
    system($curlcmd, $curlrtn);
    
    // usystemR}hcurlviؖ؂jŖȂAiؖ؂Ȃjōă`W
    if ($curlrtn != 0) {
        $curlcmd = "curl -H \"{$x_2ch_ua}\" -A {$dolib2ch} -d ID={$login2chID} -d PW={$login2chPW} -o {$tempfile}{$with_proxy} -k {$auth2ch_url}";
        system($curlcmd, $curlrtn);
    }
    
    if ($curlrtn == 0) {
        if ($r = file_get_contents($tempfile)) {
            return $r;
        }
    }
    
    return false;
}

/**
 * PHPcurl2chOCSID𓾂
 *
 * @access  private
 * @return  string|false
 */
function _getAuth2chWithPhpCurl($tempfile, $auth2ch_url, $x_2ch_ua, $dolib2ch, $postf)
{
    global $_conf;
    
    // PHPCURLgȂAŃ`W
    if (extension_loaded('curl')) {
        // uPHPcurlviؖ؂jŎs
        _execAuth2chWithPhpCurl($tempfile, $auth2ch_url, $x_2ch_ua, $dolib2ch, $postf, true);
        // uPHPcurlviؖ؂jŖȂAuPHPcurlviؖ؂Ȃjōă`W
        clearstatcache();
        if (!file_exists($tempfile) || !filesize($tempfile)) {
            _execAuth2chWithPhpCurl($tempfile, $auth2ch_url, $x_2ch_ua, $dolib2ch, $postf, false);
        }
        if ($r = file_get_contents($tempfile)) {
            return $r;
        }
    
    }
    
    return false;
}

/**
 * PHPcurlsāAt@CɃf[^ۑ
 *
 * @access  private
 * @return  boolean
 */
function _execAuth2chWithPhpCurl($tempfile, $auth2ch_url, $x_2ch_ua, $dolib2ch, $postf, $withk = false)
{
    global $_conf;
    
    if (!$ch = curl_init()) {
        return false;
    }
    if (!$fp = fopen($tempfile, 'wb')) {
        return false;
    }
    @flock($fp, LOCK_EX);
    curl_setopt($ch, CURLOPT_FILE, $fp);
    curl_setopt($ch, CURLOPT_URL, $auth2ch_url);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array($x_2ch_ua));
    curl_setopt($ch, CURLOPT_USERAGENT, $dolib2ch);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postf);
    // ؖ̌؂ȂȂ
    if ($withk) {
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    }
    // vLV̐ݒ
    if ($_conf['proxy_use']) {
        curl_setopt($ch, CURLOPT_PROXY, $_conf['proxy_host'] . ':' . $_conf['proxy_port']);
    }
    curl_exec($ch);
    curl_close($ch);
    @flock($fp, LOCK_UN);
    fclose($fp);
    
    return true;
}

/**
 * fsockopenSSLڑ2chOCSID𓾂iؖ؂Ȃj
 *
 * @access  private
 * @return  string|false
 */
function _getAuth2chWithOpenSSL($login2chID, $login2chPW, $auth2ch_url, $x_2ch_ua, $dolib2ch)
{
    global $_conf;

    $wap_ua = new WapUserAgent;
    $wap_ua->setAgent($dolib2ch);
    $wap_ua->setTimeout($_conf['fsockopen_time_limit']);

    $wap_req = new WapRequest;
    $wap_req->setMethod('POST');
    $wap_req->post['ID'] = $login2chID;
    $wap_req->post['PW'] = $login2chPW;
    $wap_req->setHeaders($x_2ch_ua . "\r\n");
    $wap_req->setUrl($auth2ch_url);
    if ($_conf['proxy_use']) {
        $wap_req->setProxy($_conf['proxy_host'], $_conf['proxy_port']);
    }

    // futen.cgi̎dlAƂeXgPHP̂A
    // ƂɂOCłPOST镶URLGR[hĂƎs
    $wap_req->setNoUrlencodePost(true);
    
    $wap_res = $wap_ua->request($wap_req);

    //P2Util::pushInfoHtml(Var_Dump::display(array($wap_ua, $wap_req, $wap_res), TRUE));

    if (!$wap_res or !$wap_res->is_success()) {
        return false;
    }

    return $wap_res->content;
}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
