<?php
/**
 * p2 - 񑀍NX
 * static\bhŗp
 */
class StrCtl
{
    /**
     * tH[瑗Ă[h}b`֐ɓK
     *
     * @static
     * @access  public
     * @return  string  $word_fm  Kp^[BSJISŕԂB
     */
    function wordForMatch($word, $method = 'regex')
    {
        $word_fm = $word;
        
        // û܂܁vłȂ΁ASp󔒂𔼊p󔒂ɋ
        if ($method != 'just') {
            $word_fm = mb_convert_kana($word_fm, 's');
        }
        
        $word_fm = trim($word_fm);
        $word_fm = htmlspecialchars($word_fm, ENT_NOQUOTES);
        
        if (in_array($method, array('and', 'or', 'just'))) {
            // preg_quote()2oCgڂ0x5B("[")"["ȂǂϊĂ܂̂
            // UTF-8ɂĂ琳K\̓ꕶGXP[v
            $word_fm = mb_convert_encoding($word_fm, 'UTF-8', 'SJIS-win');
            if (P2_MBREGEX_AVAILABLE == 1) {
                $word_fm = preg_quote($word_fm);
            } else {
                $word_fm = preg_quote($word_fm, '/');
            }
            $word_fm = mb_convert_encoding($word_fm, 'SJIS-win', 'UTF-8');
            
        // AregexiK\jȂ
        } else {
            $word_fm = str_replace('/', '\/', $word_fm);
            
            $tmp_pattern = '/' . mb_convert_encoding($word_fm, 'UTF-8', 'SJIS-win') . '/u';
            if (false === @preg_match($tmp_pattern, '.')) {
                P2Util::pushInfoHtml(
                    sprintf(
                        'p2 warning: tB^̐K\Ɍ肪܂ "%s"',
                        hs($word_fm)
                    )
                );
                $word_fm = '';
            }
            
            if (P2_MBREGEX_AVAILABLE == 0) {
                $word_fm = str_replace('/', '\/', $word_fm);
            }
            // ̃ChJ[h͏Ă܂
            $word_fm = rtrim($word_fm, '.+*');
        }
        return $word_fm;
    }

    /**
     * }`oCgΉŐK\}b`肷
     *
     * @static
     * @access  public
     * @param   string  $pattern    }b`BSJISœĂB
     * @param   string  $targetHtml ΏەBSJISœĂBHTML
     * @param   int     $zenhan     1:Sp/p̋ʂSɂȂ
     *                             iIɂƁA̎gpʂ{炢ɂȂBxS͂قǂłȂj
     *                              2:Sp/p x ʂȂ}b`
     *                              0:Sp/p ʂȂ
     * @return  string|false      }b`}b`A}b`ȂfalseԂ
     */
    function filterMatch($pattern, $targetHtml, $zenhan = 1)
    {
        global $res_filter;
        
        if ($res_filter['method'] == 'regex') {
            $pattern = StrCtl::replaceRegexAnyChar($pattern);
        }
        
        // IDtB^ÓASppɋʂȂ
        if ($res_filter['field'] == 'id' && $res_filter['method'] == 'just') {
            $zenhan = 0;
        }
        
        if ($zenhan == 1) {
            // Sp/p S ʂȂ}b`
            $pattern    = StrCtl::getPatternToHan($pattern);
            $targetHtml = StrCtl::getPatternToHan($targetHtml, true);
        
        } elseif ($zenhan == 2) {
            // Sp/p x ʂȂ}b`
            $pattern = StrCtl::getPatternZenHan($pattern); // K\p^[
        }
        
        // HTMLvfɃ}b`Ȃ߂̔ےǂ݃p^[t
        $pattern = $pattern . '(?![^<]*>)';

        if (P2_MBREGEX_AVAILABLE == 1) {
            $result = mb_eregi($pattern, $targetHtml, $matches);    // None|Error:FALSE
        } else {
            // UTF-8ɕϊĂ珈
            $pattern = str_replace('/', '\/', $pattern);
            $pattern_utf8 = '/' . mb_convert_encoding($pattern, 'UTF-8', 'SJIS-win') . '/iu';
            $target_utf8 = mb_convert_encoding($targetHtml, 'UTF-8', 'SJIS-win');
            $result = preg_match($pattern_utf8, $target_utf8, $matches);    // None:0, Error:FALSE
            //$result = mb_convert_encoding($result, 'SJIS-win', 'UTF-8');
        }
        
        if (!$result) {
            return false;
        }
        return $matches[0];
    }
    
    /**
     * }`oCgΉHTMĽ}[LO
     *
     * @static
     * @access  public
     * @param   string  $pattern    }b`BSJISœĂB炩htmlspecialchars()Ă邱ƁB
     * @param   string  $targetHtml uΏەBSJISœĂBHTMLB
     * @return  string  HTML
     */
    function filterMarking($pattern, $targetHtml, $marker = '<b class="filtering">\\0</b>')
    {
        global $res_filter;
        
        if ($res_filter['method'] == 'regex') {
            $pattern = StrCtl::replaceRegexAnyChar($pattern);
        }
        
        // Sp/pixjʂȂ}b`
        $pattern = StrCtl::getPatternZenHan($pattern); // K\p^[

        // HTMLvfɃ}b`Ȃ߂̔ےǂ݃p^[t
        $pattern = $pattern . '(?![^<]*>)';

        $result = false;
        if (P2_MBREGEX_AVAILABLE == 1) {
            $result = mb_eregi_replace($pattern, $marker, $targetHtml);    // Error => FALSE
        } else {
            // UTF-8ɕϊĂ珈
            $pattern = str_replace('/', '\/', $pattern);
            $pattern_utf8 = '/' . mb_convert_encoding($pattern, 'UTF-8', 'SJIS-win') . '/iu';
            $target_utf8 = mb_convert_encoding($targetHtml, 'UTF-8', 'SJIS-win');
            $result = preg_replace($pattern_utf8, $marker, $target_utf8);
            $result = mb_convert_encoding($result, 'SJIS-win', 'UTF-8');
        }

        if ($result === false) {
            return $targetHtml;
        }
        return $result;
    }
    
    /**
     * K\́u.vi^O܂܂Ȃ悤Ɂju
     *
     * @static
     * @access  private
     * @param   string  $regex
     * @return  string
     */
    function replaceRegexAnyChar($regex, $replace = '[^<>]')
    {
        static $cache_ = array();
        
        // ꉞLbVĂ
        if (array_key_exists($regex, $cache_)) {
            return $cache_[$regex];
        }
        
        $len = strlen($regex);
        $new = '';
        $esc = false;
        $cls = false;

        for ($i = 0; $i < $len; $i++) {
            $c = $regex[$i];

            if ($c == '\\') {
                $esc = !$esc;
                $new .= '\\';
                continue;
            }

            switch ($c) {
            case '.':
                if (!$esc && !$cls) {
                    $new .= $replace;
                } else {
                    $new .= '.';
                }
                break;

            case '[':
                if (!$esc && !$cls) {
                    $cls = true;
                }
                $new .= '[';
                break;

            case ']':
                if (!$esc && $cls) {
                    $cls = false;
                }
                $new .= ']';
                break;

            default:
                $new .= $c;
            }

            $esc = false;
        }
        
        $cache_[$regex] = $new;
        return $new;
    }

    /**
     * Sp/pixjʂȂpb`邽߂̐K\p^[𓾂
     * iӁFK\̓ꕶꏏɏĂ܂Ƃ_ĂȂB\d \j
     *
     * @static
     * @access  private
     * @return  string
     */
    function getPatternZenHan($pattern)
    {
        $petterns = array();
        
        $pattern_han = StrCtl::getPatternToHan($pattern);
        if ($pattern != $pattern_han) {
            $petterns[] = $pattern_han;
        }
        $pattern_zen = StrCtl::getPatternToZen($pattern);
        if ($pattern != $pattern_zen) {
            $petterns[] = $pattern_zen;
        }
        if ($petterns) {
            $pattern = '(?:' . implode('|', array_merge(array($pattern), $petterns)) . ')';
        }

        return $pattern;
    }

    /**
     * ip^[j𔼊pɂ
     *
     * @static
     * @access  private
     * @return  string
     */
    function getPatternToHan($pattern, $no_escape = false)
    {
        $kigou = StrCtl::getKigouPattern($no_escape);
        
        // 
        //$pattern = str_replace($kigou['zen'], $kigou['han'], $pattern);

        if (P2_MBREGEX_AVAILABLE == 1) {

            foreach ($kigou['zen'] as $k => $v) {
        
                $word_fm = $kigou['zen'][$k];
                
                /*
                // preg_quote()2oCgڂ0x5B("[")"["ȂǂϊĂ܂̂
                // UTF-8ɂĂ琳K\̓ꕶGXP[v
                $word_fm = mb_convert_encoding($word_fm, 'UTF-8', 'SJIS-win');
                $word_fm = preg_quote($word_fm);
                $word_fm = mb_convert_encoding($word_fm, 'SJIS-win', 'UTF-8');
                */
                
                $pattern = mb_ereg_replace($word_fm, $kigou['han'][$k], $pattern);
            }
        }
        
        //echo $pattern;
        $pattern = mb_convert_kana($pattern, 'rnk');
        
        
        
        return $pattern;
    }
    
    /**
     * ip^[jSpɂ
     *
     * @static
     * @access  private
     * @return  string
     */
    function getPatternToZen($pattern, $no_escape = false)
    {
        $kigou = StrCtl::getKigouPattern($no_escape);
        
        // 
        // $pattern = str_replace($kigou['han'], $kigou['zen'], $pattern);
        
        if (P2_MBREGEX_AVAILABLE == 1) {
            foreach ($kigou['zen'] as $k => $v) {
        
                $word_fm = $kigou['han'][$k];
                
                
                // preg_quote()2oCgڂ0x5B("[")"["ȂǂϊĂ܂̂
                // UTF-8ɂĂ琳K\̓ꕶGXP[v
                $word_fm = mb_convert_encoding($word_fm, 'UTF-8', 'SJIS-win');
                $word_fm = preg_quote($word_fm);
                $word_fm = mb_convert_encoding($word_fm, 'SJIS-win', 'UTF-8');
                
                
                $pattern = mb_ereg_replace($word_fm, $kigou['zen'][$k], $pattern);
            }
        }
        
        $pattern = mb_convert_kana($pattern, 'RNKV');
        
        return $pattern;
    }
    
    /**
     * Sp/p̋Lp^[𓾂
     *
     * @static
     * @access  private
     * @return  string
     */
    function getKigouPattern($no_escape = false)
    {
        $kigou['zen'] = array(
            'M', 'i', 'j', 'H', '', '', '', '', '',   '', 'I',
            '', '{', '',  '', '`', 'b', 'o', 'p', 'Q', 'D'
        );
        $kigou['han'] = array(
            '`',  '\(', '\)', '\?', '#',  '\$', '%',  '@',  '&lt;', '&gt;', '\!',
            '\*', '\+', '&amp;', '=', '~', '\|', '\{', '\}', '_', '\.'
        );
        
        // NG ---- $ < 
        // str_replace ʂɁẢBB
        //$kigou['zen'] = array('M', 'i', 'j', 'H', '', '', '', '', 'I',   '', '{', '');
        //$kigou['han'] = array('`',  '\(', '\)', '\?', '#',  '%',  '@',  '&gt;', '\!', '\*', '\+', '&amp;');

        if ($no_escape) {
            $kigou['han'] = array_map(create_function('$str', 'return ltrim($str, "\\\");'), $kigou['han']);
            /*
            foreach ($kigou['han'] as $k => $v) {
                $kigou['han'][$k] = ltrim($v, '\\');
            }
            */
        }
        
        return $kigou;
    }
}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
