/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.xml.model.helpers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.engines.impl.EnginesLoader;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.hibernate.xml.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdStructureHelper {
    public static String ENT_HIBERNATE_ID = "Hibernate3Id";
    public static String ENT_HIBERNATE_COMPOSITE_ID = "Hibernate3CompositeId";
    public static String ID_PATH_PART = "[id]";

    public static XModelObject getIdChild(XModelObject clsReference) {
        return clsReference.getChildByPath(ID_PATH_PART);
    }

    public static boolean isId(XModelObject object) {
        if (object == null) {
            return false;
        }
        String entity = object.getModelEntity().getName();
        return ENT_HIBERNATE_ID.equals(entity) || ENT_HIBERNATE_COMPOSITE_ID.equals(entity);
    }

    public static XModelObject[] getIdStructure(XModelObject id) {
        if (ENT_HIBERNATE_ID.equals(id.getModelEntity().getName())) {
            return new XModelObject[]{id};
        }
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        XModelObject[] cs = id.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (!cs[i].getModelEntity().getName().startsWith("HibernateMeta")) {
                list.add(cs[i]);
            }
            ++i;
        }
        return list.toArray(new XModelObject[0]);
    }

    public static XModelObject[] getAsAttributes(XModelObject id) throws XModelException {
        String name = id.getAttributeValue("name");
        if (name.length() == 0) {
            return new XModelObject[0];
        }
        String entity = id.getModelEntity().getName();
        if (ENT_HIBERNATE_ID.equals(entity)) {
            XModelObject c = id.getModel().createModelObject("HibernateProperty", null);
            EnginesLoader.merge((XModelObject)c, (XModelObject)id, (boolean)false);
            return new XModelObject[]{c};
        }
        if ("HibernateCompositeId".equals(entity)) {
            String cls = id.getAttributeValue("class");
            if (cls.length() == 0) {
                XModelObject[] cs = id.getChildren();
                ArrayList<XModelObject> list = new ArrayList<XModelObject>();
                int i = 0;
                while (i < cs.length) {
                    XModelObject gc;
                    if (!cs[i].getModelEntity().getName().startsWith("HibernateMeta") && (gc = IdStructureHelper.getAsAttribute(cs[i])) != null) {
                        list.add(gc);
                    }
                    ++i;
                }
                return list.toArray(new XModelObject[0]);
            }
            XModelObject c = id.getModel().createModelObject("HibernateComponent", null);
            EnginesLoader.merge((XModelObject)c, (XModelObject)id, (boolean)false);
            XModelObject[] cs = id.getChildren();
            int i = 0;
            while (i < cs.length) {
                XModelObject gc = IdStructureHelper.getAsAttribute(cs[i]);
                if (gc != null) {
                    c.addChild(gc);
                }
                ++i;
            }
            return new XModelObject[]{c};
        }
        return new XModelObject[0];
    }

    public static XModelObject getAsAttribute(XModelObject key) throws XModelException {
        String er;
        String ec = key.getModelEntity().getName();
        String string = "HibernateKeyProperty".equals(ec) ? "HibernateProperty" : (er = "HibernateKeyManyToOne".equals(ec) ? "HibernateManyToOne" : null);
        if (er == null) {
            return null;
        }
        XModelObject a = key.getModel().createModelObject(er, null);
        EnginesLoader.merge((XModelObject)a, (XModelObject)key, (boolean)false);
        return a;
    }

    public static List getAsColumns(XModelObject id) throws XModelException {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        String entity = id.getModelEntity().getName();
        if (ENT_HIBERNATE_ID.equals(entity)) {
            IdStructureHelper.addColumnsToList(id, list);
        } else if (ENT_HIBERNATE_COMPOSITE_ID.equals(entity)) {
            XModelObject[] cs = id.getChildren();
            int i = 0;
            while (i < cs.length) {
                if (!cs[i].getModelEntity().getName().startsWith("HibernateMeta")) {
                    IdStructureHelper.addColumnsToList(cs[i], list);
                }
                ++i;
            }
        }
        return list;
    }

    private static void addColumnsToList(XModelObject o, List<XModelObject> list) throws XModelException {
        XModelObject[] cs = o.getChildren("HibernateColumn");
        if (cs.length > 0) {
            int i = 0;
            while (i < cs.length) {
                list.add(cs[i].copy());
                ++i;
            }
        } else {
            String column = o.getAttributeValue("column");
            if (column == null) {
                return;
            }
            XModelObject c = o.getModel().createModelObject("HibernateColumn", null);
            EnginesLoader.merge((XModelObject)c, (XModelObject)o, (boolean)false);
            if (column.length() > 0) {
                c.setAttributeValue("name", column);
            }
            list.add(c);
        }
    }

    public static boolean isDefaultId(XModelObject id) {
        return IdStructureHelper.isNamelessId(id) && !IdStructureHelper.isIdComposite(id) && id.getAttributeValue("column").length() == 0 && id.getChildren("HibernateColumn").length == 0;
    }

    public static boolean isNamelessId(XModelObject id) {
        return IdStructureHelper.isId(id) && id.getAttributeValue("name").length() == 0;
    }

    public static String getIdType(XModelObject id) {
        if (id == null) {
            return null;
        }
        if (ENT_HIBERNATE_ID.equals(id.getModelEntity().getName())) {
            return id.getAttributeValue("type");
        }
        if (IdStructureHelper.isIdComposite(id)) {
            return id.getAttributeValue("class");
        }
        return null;
    }

    public static boolean isIdComposite(XModelObject id) {
        return ENT_HIBERNATE_COMPOSITE_ID.equals(id.getModelEntity().getName());
    }

    public static XModelObject newDefaultId(XModel model) {
        return XModelObjectLoaderUtil.createValidObject((XModel)model, (String)ENT_HIBERNATE_ID);
    }

    public static boolean isCompositeIdOfOtherType(XModelObject object) {
        if (object == null || !IdStructureHelper.isIdComposite(object)) {
            return false;
        }
        return object.getAttributeValue("name").length() > 0 || object.getAttributeValue("class").length() > 0;
    }

    public static boolean isLastPropertyInCompositeId(XModelObject object) {
        if (object == null) {
            return false;
        }
        XModelObject parent = object.getParent();
        if (parent == null || !IdStructureHelper.isIdComposite(parent)) {
            return false;
        }
        return IdStructureHelper.getIdStructure(parent).length < 2;
    }

    public static void showLastPropertyInCompositeIdWarning(XModel model) {
        String message = Messages.IdStructureHelper_ShouldNotRemoveLastAttribute;
        model.getService().showDialog(Messages.IdStructureHelper_WarningTitle, message, new String[]{Messages.IdStructureHelper_CloseOption}, null, 2);
    }
}

