/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.xml.model.helpers;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.hibernate.xml.model.helpers.IdStructureHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsStructureHelper {
    public static String ENT_HIBERNATE_COLUMN = "Hibernate3Column";

    public static boolean isColumnObject(XModelObject object) {
        return ENT_HIBERNATE_COLUMN.equals(object.getModelEntity().getName());
    }

    public static XModelObject newColumn(XModel model, String name) {
        XModelObject c = model.createModelObject(ENT_HIBERNATE_COLUMN, null);
        c.setAttributeValue("name", name);
        return c;
    }

    public static XModelObject newColumn(XModel model, Properties p) {
        return model.createModelObject(ENT_HIBERNATE_COLUMN, p);
    }

    public static boolean hasNoChildColumns(XModelObject columnOwner) {
        return columnOwner.getChildren(ENT_HIBERNATE_COLUMN).length == 0;
    }

    public static XModelObject[] getChildColumns(XModelObject columnOwner) {
        return columnOwner.getChildren(ENT_HIBERNATE_COLUMN);
    }

    public static String getDeclaredColumnName(XModelObject columnOwner) {
        if (!ColumnsStructureHelper.hasNoChildColumns(columnOwner)) {
            return null;
        }
        String column = columnOwner.getAttributeValue("column");
        if (column == null || column.length() > 0) {
            return column;
        }
        String name = columnOwner.getAttributeValue("name");
        if (name != null && name.length() == 0 && IdStructureHelper.isId(columnOwner)) {
            return "id";
        }
        return name;
    }

    public static XModelObject getDeclaredColumn(XModelObject columnOwner) {
        String name = ColumnsStructureHelper.getDeclaredColumnName(columnOwner);
        if (name == null) {
            return null;
        }
        XModelObject c = ColumnsStructureHelper.newColumn(columnOwner.getModel(), name);
        XAttribute[] as = c.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            String n = as[i].getName();
            if (!"name".equals(n) && (v = columnOwner.getAttributeValue(n)) != null && !v.equals(as[i].getDefaultValue())) {
                c.setAttributeValue(n, v);
            }
            ++i;
        }
        return c;
    }

    public static XModelObject[] getColumns(XModelObject columnOwner) {
        XModelObject[] xModelObjectArray;
        XModelObject declaredColumn = ColumnsStructureHelper.getDeclaredColumn(columnOwner);
        if (declaredColumn != null) {
            XModelObject[] xModelObjectArray2 = new XModelObject[1];
            xModelObjectArray = xModelObjectArray2;
            xModelObjectArray2[0] = declaredColumn;
        } else {
            xModelObjectArray = columnOwner.getChildren(ENT_HIBERNATE_COLUMN);
        }
        return xModelObjectArray;
    }

    public static boolean isColumnChildRequired(XModelEntity attribute, XModelObject column) {
        if (column == null || attribute.getChild(ENT_HIBERNATE_COLUMN) == null) {
            return false;
        }
        XAttribute[] as = column.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            String n = as[i].getName();
            if (!("name".equals(n) || "persistent".equals(n) || (v = column.getAttributeValue(n)) == null || v.equals(as[i].getDefaultValue()) || attribute.getAttribute(n) != null)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static XModelObject createAttributeColumn(XModelObject column) {
        XAttribute[] as = column.getModelEntity().getAttributes();
        XModelObject c = column.getModel().createModelObject(ENT_HIBERNATE_COLUMN, null);
        int i = 0;
        while (i < as.length) {
            String n = as[i].getName();
            String v = column.getAttributeValue(n);
            if (v != null && !v.equals(as[i].getDefaultValue())) {
                c.setAttributeValue(n, v);
            }
            ++i;
        }
        return c;
    }

    public static void mergeColumnDataToAttribute(XModelObject attribute, XModelObject column) throws XModelException {
        if (column == null || attribute == null) {
            return;
        }
        if (column.isActive() && attribute.isActive()) {
            column = column.copy();
        }
        XAttribute[] as = column.getModelEntity().getAttributes();
        boolean active = attribute.isActive();
        int i = 0;
        while (i < as.length) {
            String n = as[i].getName();
            String v = column.getAttributeValue(n);
            if ("name".equals(n)) {
                n = "column";
                if (v.equals(attribute.getAttributeValue("name"))) {
                    v = "";
                }
            }
            if (v != null) {
                if (!active) {
                    attribute.setAttributeValue(n, v);
                } else {
                    attribute.getModel().changeObjectAttribute(attribute, n, v);
                }
            }
            ++i;
        }
    }

    public static Set getTableColumns(XModelObject table) {
        HashSet<String> set = new HashSet<String>();
        if (table == null) {
            return set;
        }
        XModelObject[] cs = table.getChildren();
        int i = 0;
        while (i < cs.length) {
            set.add(cs[i].getAttributeValue("name"));
            ++i;
        }
        return set;
    }

    public static void provideUniqueName(XModelObject column, Set<String> columns) {
        String n = column.getAttributeValue("name");
        if (columns.contains(n)) {
            int i = 1;
            while (columns.contains(String.valueOf(n) + i)) {
                ++i;
            }
            n = String.valueOf(n) + i;
            column.setAttributeValue("name", n);
        }
        columns.add(n);
    }

    public static void replaceColumnDeclarationWithChild(XModelObject attrReference, Properties p) throws XModelException {
        XModelObject c = ColumnsStructureHelper.newColumn(attrReference.getModel(), p);
        ColumnsStructureHelper.replaceColumnDeclarationWithChild(attrReference, c);
    }

    public static void replaceColumnDeclarationWithChild(XModelObject attrReference, XModelObject column) throws XModelException {
        DefaultCreateHandler.addCreatedObject((XModelObject)attrReference, (XModelObject)column, (int)-1);
        XModelObject c = ColumnsStructureHelper.newColumn(attrReference.getModel(), attrReference.getAttributeValue("name"));
        ColumnsStructureHelper.mergeColumnDataToAttribute(attrReference, c);
    }
}

