/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.facelets.template;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.vpe.editor.VpeIncludeInfo;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VpeInsertTemplate
extends VpeAbstractTemplate {
    private static final String DEFINE_ELEMENT_NAME_PARAM = "defineElementName";
    private String defineElementName = "define";

    protected void init(Element templateElement) {
        this.children = true;
        this.modify = false;
        this.defineElementName = templateElement.getAttribute(DEFINE_ELEMENT_NAME_PARAM) != null ? templateElement.getAttribute(DEFINE_ELEMENT_NAME_PARAM) : "define";
        this.initTemplateSections(templateElement, false, true, false, false, false);
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        VpeVisualDomBuilder visualBuilder = pageContext.getVisualBuilder();
        VpeIncludeInfo includeInfo = visualBuilder.getCurrentIncludeInfo();
        if (includeInfo != null && includeInfo.getElement() != null) {
            String name = ((Element)sourceNode).getAttribute("name");
            if (name != null && (name = name.trim()).length() <= 0) {
                name = null;
            }
            if (name != null) {
                Element defineElement = this.findDefineElement(includeInfo.getElement(), name);
                if (defineElement != null) {
                    VpeCreationData creationData = this.createInsert(defineElement, visualDocument);
                    creationData.setData((Object)pageContext.getVisualBuilder().popIncludeStack());
                    return creationData;
                }
            } else {
                List<Node> elements = this.findUndefinedElement(includeInfo.getElement());
                VpeCreationData creationData = new VpeCreationData(null);
                for (Node node : elements) {
                    VpeChildrenInfo childInfo = new VpeChildrenInfo(null);
                    childInfo.addSourceChild(node);
                    creationData.addChildrenInfo(childInfo);
                }
                creationData.setData((Object)pageContext.getVisualBuilder().popIncludeStack());
                return creationData;
            }
        }
        VpeCreationData creationData = this.createStub((Element)sourceNode, visualDocument);
        creationData.setData(null);
        return creationData;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData creationData) {
        VpeIncludeInfo includeInfo = (VpeIncludeInfo)creationData.getData();
        if (includeInfo != null) {
            pageContext.getVisualBuilder().pushIncludeStack(includeInfo);
        }
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    private Element findDefineElement(Element defineContainer, String defineName) {
        Element defineElement = null;
        NodeList children = defineContainer.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Element childElement = (Element)child;
                if (this.defineElementName.equals(childElement.getLocalName()) && defineName.equals(childElement.getAttribute("name"))) {
                    defineElement = childElement;
                } else {
                    Element tempDefineElement = this.findDefineElement(childElement, defineName);
                    if (tempDefineElement != null) {
                        defineElement = tempDefineElement;
                    }
                }
            }
            ++i;
        }
        return defineElement;
    }

    private List<Node> findUndefinedElement(Element defineContainer) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList children = defineContainer.getChildNodes();
        int len = children.getLength();
        int i = 0;
        while (i < len) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 || child.getNodeType() == 3) {
                if (child.getNodeType() == 1 && !this.defineElementName.equals(child.getLocalName())) {
                    result.add(child);
                } else if (child.getNodeType() == 3 && ((Text)child).getNodeValue() != null && ((Text)child).getNodeValue().trim().length() > 0) {
                    result.add(child);
                }
            }
            ++i;
        }
        return result;
    }

    private VpeCreationData createInsert(Node defineElement, nsIDOMDocument visualDocument) {
        VpeCreationData creationData = new VpeCreationData(null);
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(null);
        childrenInfo.addSourceChild(defineElement);
        creationData.addChildrenInfo(childrenInfo);
        return creationData;
    }

    private VpeCreationData createStub(Element element, nsIDOMDocument visualDocument) {
        nsIDOMElement visualNewElement = visualDocument.createElement("div");
        return new VpeCreationData((nsIDOMNode)visualNewElement);
    }

    public void setPseudoContent(VpePageContext pageContext, Node sourceContainer, nsIDOMNode visualContainer, nsIDOMDocument visualDocument) {
    }
}

