/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELMultiExpression;
import org.jboss.tools.common.el.core.model.ELObject;
import org.jboss.tools.common.el.core.model.ELObjectType;
import org.jboss.tools.common.el.internal.core.model.ELExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELObjectImpl;
import org.jboss.tools.common.el.internal.core.model.ELOperatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELMultiExpressionImpl
extends ELExpressionImpl
implements ELMultiExpression {
    List<ELExpression> expressions = new ArrayList<ELExpression>();
    List<ELOperatorImpl> operators = new ArrayList<ELOperatorImpl>();

    @Override
    public List<ELExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public List<ELOperatorImpl> getOperators() {
        return this.operators;
    }

    @Override
    public void addChild(ELObjectImpl child) {
        if (child instanceof ELExpressionImpl) {
            this.addExpression((ELExpressionImpl)child);
        } else if (child instanceof ELOperatorImpl) {
            this.addOperator((ELOperatorImpl)child);
        } else {
            throw new IllegalArgumentException("EL instance can have only EL expression as child.");
        }
    }

    public void addExpression(ELExpressionImpl expression) {
        if (this.expressions.size() > this.operators.size()) {
            throw new IllegalArgumentException("Expecting operator");
        }
        super.addChild(expression);
        this.expressions.add(expression);
    }

    public void addOperator(ELOperatorImpl operator) {
        while (this.expressions.size() <= this.operators.size()) {
            this.addChild(new ELExpressionImpl(){

                public ELObjectType getType() {
                    return ELObjectType.EL_UNKNOWN;
                }
            });
        }
        super.addChild(operator);
        this.operators.add(operator);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.children != null) {
            for (ELObject c : this.children) {
                sb.append(c.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public ELObjectType getType() {
        return ELObjectType.EL_MULTI_EXPRESSION;
    }

    @Override
    public void collectInvocations(List<ELInvocationExpression> list) {
        for (ELExpression expr : this.expressions) {
            ((ELExpressionImpl)expr).collectInvocations(list);
        }
    }
}

