/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELObjectType;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.core.parser.SyntaxError;
import org.jboss.tools.common.el.internal.core.model.ELExpressionImpl;
import org.jboss.tools.common.el.internal.core.model.ELObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELInstanceImpl
extends ELObjectImpl
implements ELInstance {
    ELExpressionImpl expression;
    List<SyntaxError> errors = new ArrayList<SyntaxError>();

    @Override
    public LexicalToken getOpenInstanceToken() {
        LexicalToken result = this.getFirstToken();
        if (result != null && result.getType() == 1) {
            return result;
        }
        return null;
    }

    @Override
    public LexicalToken getCloseInstanceToken() {
        LexicalToken result = this.getLastToken();
        if (result != null && result.getType() == 2) {
            return result;
        }
        return null;
    }

    @Override
    public ELExpression getExpression() {
        return this.expression;
    }

    @Override
    public List<SyntaxError> getErrors() {
        return this.errors;
    }

    @Override
    public void addChild(ELObjectImpl child) {
        if (!(child instanceof ELExpressionImpl)) {
            throw new IllegalArgumentException("EL instance can have only EL expression as child.");
        }
        this.setExpression((ELExpressionImpl)child);
    }

    public void setExpression(ELExpressionImpl expression) {
        if (this.expression == expression) {
            return;
        }
        if (this.expression != null) {
            this.removeChild(this.expression);
        }
        this.expression = expression;
        if (expression != null) {
            super.addChild(expression);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getOpenInstanceToken() != null) {
            sb.append(this.getOpenInstanceToken().getText());
        }
        if (this.expression != null) {
            sb.append(this.expression.toString());
        }
        if (this.getCloseInstanceToken() != null) {
            sb.append(this.getCloseInstanceToken().getText());
        }
        return sb.toString();
    }

    @Override
    public ELObjectType getType() {
        return ELObjectType.EL_INSTANCE;
    }

    public boolean contains(int position) {
        int end;
        if (position < this.getFirstToken().getStart()) {
            return false;
        }
        LexicalToken l = this.getLastToken();
        if (l == null) {
            l = this.getFirstToken();
        }
        if (position > (end = l.getStart() + l.getLength())) {
            return false;
        }
        return this.getCloseInstanceToken() == null || position != end;
    }

    public void addError(SyntaxError error) {
        this.errors.add(error);
    }
}

