/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.parser.SyntaxError;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.FileUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ELReference
implements ITextSourceReference {
    private IFile resource;
    private IPath path;
    private int length;
    private int startPosition;
    private ELExpression[] el;
    private Set<IMarker> markers;
    private IMarker[] markerArray;
    private boolean needToInitMarkers = false;
    private List<SyntaxError> syntaxErrors;
    private String source;
    private IMarker[] EMPTY_MARKER_ARRAY = new IMarker[0];

    public int getLength() {
        return this.length;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public IFile getResource() {
        if (this.resource == null) {
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.resource = wsRoot.getFile(this.path);
        }
        return this.resource;
    }

    public void setResource(IFile resource) {
        this.resource = resource;
        if (resource != null) {
            this.path = resource.getFullPath();
        }
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public String getSourceText() {
        if (this.source == null) {
            this.source = this.getELModel().getSource();
        }
        return this.source;
    }

    public ELExpression[] getEl() {
        if (this.el == null) {
            HashSet<ELExpression> exps = new HashSet<ELExpression>();
            String elText = FileUtil.getContentFromEditorOrFile((IFile)this.resource);
            int startEl = elText.indexOf("#{");
            if (startEl > -1) {
                ELParser parser = ELParserUtil.getJbossFactory().createParser();
                ELModel model = parser.parse(elText);
                List<SyntaxError> errors = model.getSyntaxErrors();
                if (!errors.isEmpty()) {
                    ELCorePlugin.getDefault().logWarning("ELObject hold incorrect information. Maybe resource " + this.getResource() + " has been changed.");
                    return null;
                }
                List<ELInstance> is = model.getInstances();
                for (ELInstance i : is) {
                    if (!i.getErrors().isEmpty()) {
                        ELCorePlugin.getDefault().logWarning("ELObject hold incorrect information. Maybe resource " + this.getResource() + " has been changed.");
                        continue;
                    }
                    exps.add(i.getExpression());
                }
            }
            this.el = exps.toArray(new ELExpression[0]);
        }
        return this.el;
    }

    public void setEl(ELExpression[] el) {
        this.el = el;
    }

    public void setEl(List<ELInstance> insts) {
        HashSet<ELExpression> exps = new HashSet<ELExpression>();
        for (ELInstance el : insts) {
            exps.add(el.getExpression());
        }
        this.el = exps.toArray(new ELExpression[0]);
    }

    private void initMarkers() {
        if (this.markers == null) {
            IFile file;
            this.markers = new HashSet<IMarker>();
            if (this.needToInitMarkers && (file = this.getResource()) != null) {
                IMarker[] markers = null;
                try {
                    markers = file.findMarkers(null, true, 2);
                }
                catch (CoreException e) {
                    ELCorePlugin.getDefault().logError(e);
                }
                int i = 0;
                while (i < markers.length) {
                    String groupName = markers[i].getAttribute("groupName", null);
                    if (groupName != null && groupName.equals(this.getMarkerGroupId())) {
                        int start = markers[i].getAttribute("charStart", -1);
                        int end = markers[i].getAttribute("charEnd", -1);
                        if (start >= this.startPosition && end <= this.startPosition + this.length) {
                            this.addMarker(markers[i]);
                        }
                    }
                    ++i;
                }
            }
            this.needToInitMarkers = false;
        }
    }

    public List<SyntaxError> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    public void setSyntaxErrors(List<SyntaxError> syntaxErrors) {
        this.syntaxErrors = syntaxErrors;
    }

    protected abstract String getMarkerGroupId();

    public synchronized void setNeedToInitMarkers(boolean needToInitMarkers) {
        this.needToInitMarkers = needToInitMarkers;
    }

    public synchronized void setMarkers(Set<IMarker> markers) {
        this.markers = markers;
    }

    public synchronized IMarker[] getMarkers() {
        this.initMarkers();
        if (this.markerArray == null) {
            this.markerArray = this.markers.isEmpty() ? this.EMPTY_MARKER_ARRAY : this.markers.toArray(new IMarker[0]);
        }
        return this.markerArray;
    }

    public synchronized void addMarker(IMarker marker) {
        if (marker == null) {
            return;
        }
        this.markerArray = null;
        if (this.markers == null) {
            this.markers = new HashSet<IMarker>();
        }
        this.markers.add(marker);
    }

    public synchronized void deleteMarkers() {
        this.initMarkers();
        for (IMarker marker : this.markers) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                ELCorePlugin.getDefault().logError(e);
            }
        }
        this.markers.clear();
        this.markerArray = null;
    }

    public synchronized void store(Element element) {
        element.setAttribute("path", this.path.toString());
        element.setAttribute("offset", "" + this.startPosition);
        element.setAttribute("length", "" + this.length);
    }

    public synchronized void load(Element element) {
        this.path = new Path(element.getAttribute("path"));
        this.startPosition = new Integer(element.getAttribute("offset"));
        this.length = new Integer(element.getAttribute("length"));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        ELReference el = (ELReference)obj;
        return this.path.equals((Object)el.path) && this.startPosition == el.startPosition;
    }

    public int hashCode() {
        return this.path.hashCode() + this.startPosition;
    }

    public ELModel getELModel() {
        ELExpression[] exprs = this.getEl();
        if (exprs.length > 0) {
            return exprs[0].getModel();
        }
        return null;
    }
}

