/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.ui.ca;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.util.SharedXMLEditorPluginImageHelper;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.ca.AbstractELCompletionEngine;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.ui.ElUiPlugin;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class ELProposalProcessor
extends AbstractContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private char[] autoActivChars;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (viewer == null) {
            return NO_PROPOSALS;
        }
        IDocument document = viewer.getDocument();
        int start = 0;
        int end = document.getLength();
        int[] region = this.getRegion(document, offset);
        if (region != null) {
            start = region[0];
            end = region[1];
        }
        return this.computeCompletionProposals(viewer, offset, start, end);
    }

    private int[] getRegion(IDocument document, int offset) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        try {
            IDOMDocument xmlDocument;
            IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = 0;
            int end = document.getLength();
            if (n instanceof IDOMNode) {
                start = ((IDOMNode)n).getStartOffset();
                end = ((IDOMNode)n).getEndOffset();
            }
            int[] nArray = new int[]{start, end};
            return nArray;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
                model = null;
            }
        }
    }

    protected abstract boolean isEnabled(IFile var1);

    protected abstract Image getImage();

    protected abstract ELContext getELContext(IFile var1);

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, int start, int end) {
        ITextEditor part = EclipseUIUtil.getActiveEditor();
        if (part == null) {
            return NO_PROPOSALS;
        }
        IEditorInput editorInput = part.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return NO_PROPOSALS;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        if (!this.isEnabled(file)) {
            return NO_PROPOSALS;
        }
        ELContext context = this.getELContext(file);
        if (context == null) {
            return NO_PROPOSALS;
        }
        ELReference ref = context.getELReference(offset);
        if (ref == null) {
            return NO_PROPOSALS;
        }
        ELResolver[] resolvers = ELResolverFactoryManager.getInstance().getResolvers((IResource)file);
        ArrayList<Proposal> resultList = new ArrayList<Proposal>();
        String prefix = this.getPrefix(viewer, offset, start, end);
        prefix = prefix == null ? "" : prefix;
        String proposalPrefix = "";
        String proposalSufix = "";
        String elStartChar = "#";
        String documentContent = ref.getELModel().getSource();
        if (this.getELEndPosition(offset - ref.getStartPosition(), documentContent) == -1) {
            proposalSufix = "}";
        }
        int i = 0;
        while (i < resolvers.length) {
            List suggestions = resolvers[i].getProposals(context, offset);
            List uniqueSuggestions = AbstractELCompletionEngine.makeProposalsUnique((List)suggestions);
            for (TextProposal kbProposal : uniqueSuggestions) {
                Image image;
                String string = kbProposal.getReplacementString();
                Image image2 = image = kbProposal.hasImage() ? kbProposal.getImage() : this.getImage();
                if (string.length() < 0) continue;
                string = String.valueOf(proposalPrefix) + string + proposalSufix;
                if (string.length() > 0 && ('#' == string.charAt(0) || '$' == string.charAt(0))) {
                    string = String.valueOf(elStartChar) + string.substring(1);
                }
                if (string.startsWith("['") && string.endsWith("']") && prefix != null && prefix.endsWith(".")) {
                    String newPrefix = prefix.substring(0, prefix.length() - 1);
                    resultList.add(new Proposal(string, prefix, newPrefix, offset, offset - 1 + string.length() - proposalSufix.length(), image));
                    continue;
                }
                resultList.add(new Proposal(string, prefix, offset, offset + string.length() - proposalSufix.length(), image));
            }
            ++i;
        }
        if (resultList.isEmpty()) {
            return NO_PROPOSALS;
        }
        ICompletionProposal[] resultArray = new ICompletionProposal[resultList.size()];
        resultArray = resultList.toArray(resultArray);
        Arrays.sort(resultArray, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal arg0, ICompletionProposal arg1) {
                String str0 = arg0 == null ? "" : arg0.getDisplayString();
                String str1 = arg1 == null ? "" : arg1.getDisplayString();
                return str0.compareTo(str1);
            }
        });
        return resultArray;
    }

    private int getELEndPosition(int initialOffset, String restOfCurrentValue) {
        int offset = -1;
        char inQuotesChar = '\u0000';
        while (++offset < restOfCurrentValue.length() - initialOffset) {
            int backslashCount;
            if (inQuotesChar == '\u0000') {
                if ('}' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    return offset;
                }
                if ('#' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    return -1;
                }
                if ('<' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    return -1;
                }
                if ('>' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    return -1;
                }
                if ('/' == restOfCurrentValue.charAt(initialOffset + offset) && initialOffset + offset + 1 < restOfCurrentValue.length() && '>' == restOfCurrentValue.charAt(initialOffset + offset + 1)) {
                    return -1;
                }
                if ('\"' == restOfCurrentValue.charAt(initialOffset + offset) || '\'' == restOfCurrentValue.charAt(initialOffset + offset)) {
                    inQuotesChar = restOfCurrentValue.charAt(initialOffset + offset);
                }
                if ('\\' != restOfCurrentValue.charAt(initialOffset + offset)) continue;
                backslashCount = 1;
                while (initialOffset + offset + backslashCount < restOfCurrentValue.length() && restOfCurrentValue.charAt(initialOffset + offset + backslashCount) == '\\') {
                    ++backslashCount;
                }
                if (initialOffset + offset + backslashCount >= restOfCurrentValue.length()) {
                    return -1;
                }
                if (backslashCount % 2 != 1 || '\"' != restOfCurrentValue.charAt(initialOffset + offset + backslashCount) && '\'' != restOfCurrentValue.charAt(initialOffset + offset + backslashCount)) continue;
                inQuotesChar = restOfCurrentValue.charAt(initialOffset + offset + backslashCount);
                offset += backslashCount;
                continue;
            }
            if ('\"' == restOfCurrentValue.charAt(initialOffset + offset) || '\'' == restOfCurrentValue.charAt(initialOffset + offset)) {
                inQuotesChar = '\u0000';
            }
            if ('\\' != restOfCurrentValue.charAt(initialOffset + offset)) continue;
            backslashCount = 1;
            while (initialOffset + offset + backslashCount < restOfCurrentValue.length() && restOfCurrentValue.charAt(initialOffset + offset + backslashCount) == '\\') {
                ++backslashCount;
            }
            if (initialOffset + offset + backslashCount >= restOfCurrentValue.length()) {
                return -1;
            }
            if (backslashCount % 2 != 1 || '\"' != restOfCurrentValue.charAt(initialOffset + offset + backslashCount) && '\'' != restOfCurrentValue.charAt(initialOffset + offset + backslashCount)) continue;
            inQuotesChar = '\u0000';
            offset += backslashCount;
        }
        return -1;
    }

    public String getPrefix(ITextViewer viewer, int offset, int start, int end) throws StringIndexOutOfBoundsException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        return this.getPrefix(doc, offset, start, end);
    }

    public String getPrefix(IDocument document, int offset, int start, int end) throws StringIndexOutOfBoundsException {
        if (document == null || document.get() == null || offset > document.get().length()) {
            return null;
        }
        ELInvocationExpression expr = AbstractELCompletionEngine.findExpressionAtOffset((IDocument)document, (int)offset, (int)start, (int)end);
        if (expr == null) {
            return null;
        }
        return document.get().substring(expr.getStartPosition(), offset);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        if (this.autoActivChars == null) {
            IPreferenceStore store = EditorsUI.getPreferenceStore();
            String superDefaultChars = store.getDefaultString("content_assist_autoactivation_triggers_java");
            StringBuffer redhatDefaultChars = new StringBuffer(superDefaultChars);
            if (superDefaultChars.indexOf("{") < 0) {
                redhatDefaultChars.append('{');
            }
            if (superDefaultChars.indexOf(".") < 0) {
                redhatDefaultChars.append('.');
            }
            if (superDefaultChars.indexOf("[") < 0) {
                redhatDefaultChars.append('[');
            }
            this.autoActivChars = new char[redhatDefaultChars.length()];
            redhatDefaultChars.getChars(0, redhatDefaultChars.length(), this.autoActivChars, 0);
            store.setDefault("content_assist_autoactivation_triggers_java", redhatDefaultChars.toString());
            store.setValue("content_assist_autoactivation_triggers_java", redhatDefaultChars.toString());
        }
        return this.autoActivChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public static final class Proposal
    implements ICompletionProposal,
    ICompletionProposalExtension,
    ICompletionProposalExtension2,
    ICompletionProposalExtension3,
    ICompletionProposalExtension4,
    IRelevanceCompletionProposal {
        private final String fString;
        private final String fPrefix;
        private final String fNewPrefix;
        private final int fOffset;
        private int fNewPosition;
        private Image fImage;

        public Proposal(String string, String prefix, int offset) {
            this(string, prefix, offset, offset + string.length());
        }

        public Proposal(String string, String prefix, int offset, int newPosition) {
            this(string, prefix, prefix, offset, offset + string.length(), null);
        }

        public Proposal(String string, String prefix, int offset, int newPosition, Image image) {
            this(string, prefix, prefix, offset, offset + string.length(), image);
        }

        public Proposal(String string, String prefix, String newPrefix, int offset, int newPosition) {
            this(string, prefix, newPrefix, offset, newPosition, null);
        }

        public Proposal(String string, String prefix, String newPrefix, int offset, int newPosition, Image image) {
            this.fString = string;
            this.fPrefix = prefix;
            this.fNewPrefix = newPrefix;
            this.fOffset = offset;
            this.fNewPosition = newPosition;
            this.fImage = image;
        }

        public void apply(IDocument document) {
            this.apply(null, '\u0000', 0, this.fOffset);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fNewPosition, 0);
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            String dispString = String.valueOf(this.fNewPrefix == null ? this.fPrefix : this.fNewPrefix) + this.fString;
            if (dispString != null) {
                if (dispString.indexOf(123) == -1 && dispString.indexOf(125) != -1) {
                    dispString = dispString.substring(0, dispString.indexOf(125));
                }
                if (dispString.indexOf(123) != -1 && dispString.indexOf(125) == -1) {
                    dispString = String.valueOf(dispString) + "}";
                }
            }
            return dispString;
        }

        public Image getImage() {
            return this.fImage == null ? SharedXMLEditorPluginImageHelper.getImage((String)"icons/full/obj16/attribute_obj.gif") : this.fImage;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void apply(IDocument document, char trigger, int offset) {
            try {
                int docCharsToReplace = this.fNewPrefix == null || this.fPrefix == null ? 0 : this.fPrefix.length() - this.fNewPrefix.length();
                String replacement = this.fString.substring(offset - this.fOffset);
                document.replace(offset - docCharsToReplace, docCharsToReplace, replacement);
            }
            catch (BadLocationException x) {
                ElUiPlugin.getDefault().logError(x);
            }
        }

        public boolean isValidFor(IDocument document, int offset) {
            return this.validate(document, offset, null);
        }

        public char[] getTriggerCharacters() {
            return null;
        }

        public int getContextInformationPosition() {
            return 0;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            this.apply(viewer.getDocument(), trigger, offset);
            if (this.fString != null && this.fString.endsWith("}")) {
                --this.fNewPosition;
            }
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            try {
                int prefixStart = this.fOffset - this.fPrefix.length();
                return offset >= this.fOffset && offset < this.fOffset + this.fString.length() && document.get(prefixStart, offset - prefixStart).equals((String.valueOf(this.fPrefix) + this.fString).substring(0, offset - prefixStart));
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        public IInformationControlCreator getInformationControlCreator() {
            return null;
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return String.valueOf(this.fPrefix) + this.fString;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return this.fOffset - this.fPrefix.length();
        }

        public boolean isAutoInsertable() {
            return false;
        }

        public int getCursorPosition() {
            return this.fNewPosition;
        }

        public int getRelevance() {
            return 820;
        }
    }
}

