/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.ui.palette.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.ui.views.palette.PaletteContents;
import org.jboss.tools.common.model.ui.views.palette.editor.PaletteEditor;
import org.jboss.tools.common.model.util.ClassLoaderUtil;
import org.jboss.tools.vpe.ui.palette.model.PaletteCategory;
import org.jboss.tools.vpe.ui.palette.model.PaletteItem;
import org.jboss.tools.vpe.ui.palette.model.PaletteModelHelper;
import org.jboss.tools.vpe.ui.palette.model.PaletteRoot;
import org.jboss.tools.vpe.ui.palette.model.PaletteXModelObject;

public class PaletteModel {
    private static PaletteModel instance;
    private static Object monitor;
    private PaletteEditor editor = new PaletteEditor();
    private PaletteRoot paletteRoot = null;
    private PaletteContents paletteContents = new PaletteContents(null);

    static {
        ClassLoaderUtil.init();
        instance = null;
        monitor = new Object();
    }

    private PaletteModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PaletteModel getInstance(PaletteContents contents) {
        if (instance != null) {
            return instance;
        }
        Object object = monitor;
        synchronized (object) {
            if (instance == null) {
                PaletteModel inst = new PaletteModel();
                inst.setPaletteContentsInternal(contents);
                inst.createModel();
                instance = inst;
            }
        }
        return instance;
    }

    public XModel getXModel() {
        return ModelUtilities.getPreferenceModel();
    }

    private XModelObject getXPaletteRoot() {
        return this.getXModel().getRoot("Palette");
    }

    private XModelObject[] findXObjects(XModelObject root, String elementType) {
        ArrayList<XModelObject> v = new ArrayList<XModelObject>();
        int i = 0;
        while (i < root.getChildren().length) {
            if (root.getChildAt(i).getAttributeValue("element type").equals(elementType)) {
                v.add(root.getChildAt(i));
            }
            ++i;
        }
        return v.size() == 0 ? null : v.toArray(new XModelObject[0]);
    }

    private XModelObject[] getGroups(XModelObject root) {
        ArrayList v = new ArrayList();
        this.collectGroups(root, v);
        return v.size() == 0 ? new XModelObject[]{} : v.toArray(new XModelObject[0]);
    }

    private void collectGroups(XModelObject o, ArrayList list) {
        int i = 0;
        while (i < o.getChildren().length) {
            XModelObject c = o.getChildAt(i);
            if (!"yes".equals(c.getAttributeValue("hidden"))) {
                if (PaletteModelHelper.isSubGroup(c)) {
                    list.add(c);
                } else if (PaletteModelHelper.isGroup(c)) {
                    this.collectGroups(c, list);
                }
            }
            ++i;
        }
    }

    private void createModel() {
        this.load(null);
    }

    public PaletteRoot getPaletteRoot() {
        return this.paletteRoot;
    }

    public void load(XModelObject lastAddedXCat) {
        XModelObject xpalette = this.getXPaletteRoot();
        if (this.paletteRoot == null) {
            this.paletteRoot = new PaletteRoot(xpalette);
        }
        if (xpalette == null) {
            return;
        }
        XModelObject[] xcats = this.getGroups(xpalette);
        if (xcats == null) {
            return;
        }
        int i = 0;
        int l = 0;
        while (l < xcats.length) {
            if (!"yes".equals(xcats[l].getAttributeValue("hidden"))) {
                int j = this.indexOf((PaletteContainer)this.paletteRoot, xcats[l], i);
                if (j == -1) {
                    this.paletteRoot.add(i, (PaletteEntry)this.createCategory(xcats[l], lastAddedXCat == xcats[l]));
                } else {
                    PaletteCategory cat = (PaletteCategory)this.getEntry((PaletteContainer)this.paletteRoot, j);
                    if (i < j) {
                        this.moveUp((PaletteContainer)this.paletteRoot, (PaletteEntry)cat, j - i);
                    }
                    cat.setXModelObject(xcats[l]);
                    cat.setVisible(this.isCategoryVisible(cat));
                    this.loadCategory(xcats[l], cat);
                }
                ++i;
            }
            ++l;
        }
        this.cutOff((PaletteContainer)this.paletteRoot, i);
    }

    private PaletteCategory createCategory(XModelObject xcat, boolean open) {
        PaletteCategory cat = new PaletteCategory(xcat, open);
        cat.setVisible(this.isCategoryVisible(cat));
        this.loadCategory(xcat, cat);
        return cat;
    }

    private void loadCategory(XModelObject xcat, PaletteCategory cat) {
        XModelObject[] xitems = xcat.getChildren();
        int i = 0;
        int l = 0;
        while (l < xitems.length) {
            if (xitems[l].getAttributeValue("element type").equals("macro")) {
                PaletteItem item;
                if ((item = (PaletteItem)this.getEntry((PaletteContainer)cat, i++)) == null) {
                    cat.add((PaletteEntry)new PaletteItem(xitems[l]));
                } else {
                    item.setXModelObject(xitems[l]);
                }
            }
            ++l;
        }
        this.cutOff((PaletteContainer)cat, i);
    }

    private int indexOf(PaletteContainer container, XModelObject xobject, int startIndex) {
        List v = container.getChildren();
        if (v != null) {
            int max = v.size();
            int i = startIndex;
            while (i < max) {
                if (xobject == ((PaletteXModelObject)v.get(i)).getXModelObject()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private PaletteEntry getEntry(PaletteContainer container, int index) {
        List v = container.getChildren();
        if (index < v.size()) {
            return (PaletteEntry)v.get(index);
        }
        return null;
    }

    private void moveUp(PaletteContainer container, PaletteEntry entry, int height) {
        int i = 0;
        while (i < height) {
            container.moveUp(entry);
            ++i;
        }
    }

    private void cutOff(PaletteContainer container, int size) {
        int oldSize;
        List v = container.getChildren();
        if (v != null && (oldSize = v.size()) > size) {
            int i = oldSize - 1;
            while (i >= size) {
                container.remove((PaletteEntry)v.get(i));
                --i;
            }
        }
    }

    public void addModelTreeListener(XModelTreeListener listener) {
        this.getXModel().addModelTreeListener(listener);
    }

    public void removeModelTreeListener(XModelTreeListener listener) {
        this.getXModel().removeModelTreeListener(listener);
    }

    public void openEditor(Shell shell) {
        this.editor.setObject(shell);
        this.editor.execute();
    }

    public void runShowHideDialog() {
        XActionInvoker.invoke((String)"HiddenTabs", (XModelObject)this.paletteRoot.getXModelObject(), (Properties)new Properties());
    }

    public void runImportTLDDialog() {
        XActionInvoker.invoke((String)"ImportTLDToPaletteWizard", (String)"CreateActions.ImportTLD", (XModelObject)this.paletteRoot.getXModelObject(), (Properties)new Properties());
    }

    private boolean setPaletteContentsInternal(PaletteContents contents) {
        if (!this.paletteContents.equalsContents(contents)) {
            this.paletteContents = contents != null ? contents : new PaletteContents(null);
            return true;
        }
        return false;
    }

    private boolean isCategoryVisible(PaletteCategory cat) {
        return true;
    }

    public void setPaletteContents(PaletteContents contents) {
        if (!this.setPaletteContentsInternal(contents)) {
            return;
        }
        List children = this.paletteRoot.getChildren();
        int i = 0;
        while (i < children.size()) {
            PaletteCategory cat = (PaletteCategory)children.get(i);
            cat.setVisible(this.isCategoryVisible(cat));
            ++i;
        }
    }
}

