/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.ui.palette;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.views.palette.IPaletteAdapter;
import org.jboss.tools.common.model.ui.views.palette.IPalettePageAdapter;
import org.jboss.tools.common.model.ui.views.palette.PaletteContents;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.vpe.ui.palette.DescriptionManager;
import org.jboss.tools.vpe.ui.palette.DropTargetManager;
import org.jboss.tools.vpe.ui.palette.PalettePlugin;
import org.jboss.tools.vpe.ui.palette.PaletteUIMessages;
import org.jboss.tools.vpe.ui.palette.PaletteViewer;
import org.jboss.tools.vpe.ui.palette.PaletteViewerPreferences;
import org.jboss.tools.vpe.ui.palette.model.PaletteModel;
import org.jboss.tools.vpe.ui.palette.model.PaletteRoot;
import org.osgi.framework.Bundle;

public class PaletteAdapter
implements IPaletteAdapter {
    private static final URL BASE_URL = EclipseResourceUtil.getInstallURL((Bundle)Platform.getBundle((String)"org.jboss.tools.common.model.ui"));
    private static final String IMAGE_PATH = "images/xstudio/palette/";
    private IPalettePageAdapter viewPart = null;
    private PaletteModel model = null;
    private PaletteViewer viewer = null;
    private Control palette = null;
    private DescriptionManager descriptionManager = null;
    private DropTargetManager dropManager = null;
    private PaletteModelListener modelListener = null;
    private PaletteContents paletteContents;

    public void setPaletteViewPart(IPalettePageAdapter viewPart) {
        this.viewPart = viewPart;
    }

    public void initActionBars() {
        IActionBars bars = this.viewPart.getActionBars();
        if (bars != null) {
            bars.getToolBarManager().add((IAction)new PaletteEditAction());
            bars.getToolBarManager().add((IAction)new ShowHideTabsAction());
            bars.getToolBarManager().add((IAction)new ImportTLDAction());
        }
    }

    public Control createControl(Composite root) {
        this.model = PaletteModel.getInstance(this.paletteContents);
        this.viewer = new PaletteViewer(this.viewPart);
        this.palette = this.viewer.createControl(root);
        this.viewer.setPaletteViewerPreferences((org.eclipse.gef.ui.palette.PaletteViewerPreferences)new PaletteViewerPreferences());
        PaletteRoot paletteRoot = this.model.getPaletteRoot();
        this.viewer.setPaletteRoot(paletteRoot);
        this.descriptionManager = new DescriptionManager(this.viewer);
        this.descriptionManager.install(this.palette);
        this.dropManager = new DropTargetManager(this.viewer, this.model);
        this.dropManager.install(this.palette);
        this.modelListener = new PaletteModelListener();
        this.model.addModelTreeListener(this.modelListener);
        this.viewer.addDragStartSupport();
        return this.palette;
    }

    public void setEnabled(boolean enabled) {
        if (this.viewer != null) {
            this.viewer.setEnabled(enabled);
        }
    }

    public void dispose() {
        this.model.removeModelTreeListener(this.modelListener);
        this.dropManager.dispose();
        this.descriptionManager.dispose();
        this.viewPart.getActionBars().getToolBarManager().removeAll();
        this.viewer = null;
        this.viewPart = null;
    }

    public void setPaletteContents(PaletteContents contents) {
        this.paletteContents = contents;
        if (this.model != null) {
            this.model.setPaletteContents(contents);
        }
    }

    private void reload(XModelObject lastAddedXCat) {
        if (this.viewer != null) {
            this.viewer.deselectAll();
        }
        this.model.load(lastAddedXCat);
        this.setEnabled(true);
    }

    private ImageDescriptor getImageDescriptor(String fileName) {
        try {
            URL url = new URL(BASE_URL, IMAGE_PATH + fileName);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            PalettePlugin.getPluginLog().logError((Throwable)e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private class ImportTLDAction
    extends Action {
        public ImportTLDAction() {
            super(PaletteUIMessages.IMPORT_TLD, PaletteAdapter.this.getImageDescriptor("tld_import.gif"));
            this.setToolTipText(PaletteUIMessages.IMPORT);
        }

        public void run() {
            PaletteAdapter.this.model.runImportTLDDialog();
        }
    }

    private class PaletteEditAction
    extends Action {
        public PaletteEditAction() {
            super(PaletteUIMessages.PALETTE_EDITOR, PaletteAdapter.this.getImageDescriptor("palette_editor.gif"));
            this.setToolTipText(PaletteUIMessages.PALETTE_EDITOR);
        }

        public void run() {
            PaletteAdapter.this.model.openEditor(PaletteAdapter.this.palette.getShell());
        }
    }

    private class PaletteModelListener
    implements XModelTreeListener {
        private boolean isTransaction = false;
        private boolean isDirty = false;
        private XModelObject lastAddedCat = null;

        private PaletteModelListener() {
        }

        public void nodeChanged(XModelTreeEvent event) {
            this.run(event);
        }

        public void structureChanged(XModelTreeEvent event) {
            this.run(event);
        }

        private void run(XModelTreeEvent event) {
            if ("transaction_begin".equals(event.getInfo())) {
                this.isTransaction = true;
                return;
            }
            if ("transaction_end".equals(event.getInfo())) {
                this.isTransaction = false;
                if (this.isDirty) {
                    this.isDirty = false;
                    PaletteAdapter.this.reload(this.lastAddedCat);
                    this.lastAddedCat = null;
                }
                return;
            }
            XModel xmodel = PaletteAdapter.this.model.getXModel();
            XModelObject exo = event.getModelObject();
            boolean q = event.kind() == 3 && xmodel.getRoot().getPath().equals(exo.getPath());
            XModelObject xroot = xmodel.getRoot("Palette");
            if (xroot == null || this.isExist(xroot, event.getModelObject()) || q) {
                Object info;
                if (event.kind() == 1 && xroot != null && xroot.getPath().equals(exo.getPath()) && (info = event.getInfo()) instanceof XModelObject) {
                    this.lastAddedCat = (XModelObject)info;
                }
                if (this.isTransaction) {
                    this.isDirty = true;
                } else {
                    PaletteAdapter.this.reload(this.lastAddedCat);
                    this.lastAddedCat = null;
                }
            }
        }

        private boolean isExist(XModelObject root, XModelObject modelObject) {
            if (root == null || modelObject == null) {
                return false;
            }
            if (modelObject.getPath() == null || root.getPath() == null) {
                return false;
            }
            return (String.valueOf(modelObject.getPath()) + "/").startsWith(String.valueOf(root.getPath()) + "/");
        }
    }

    private class ShowHideTabsAction
    extends Action {
        public ShowHideTabsAction() {
            super(PaletteUIMessages.SHOW_HIDE_TABS, PaletteAdapter.this.getImageDescriptor("visibility.gif"));
            this.setToolTipText(PaletteUIMessages.SHOW_HIDE);
        }

        public void run() {
            PaletteAdapter.this.model.runShowHideDialog();
        }
    }
}

