/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.HashSet;
import java.util.Set;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.proxy.VpeProxyUtil;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.util.ElService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SourceDomUtil {
    private static final Set<String> templatesNamespacesWithRendered = new HashSet<String>();

    static {
        templatesNamespacesWithRendered.add("h:");
        templatesNamespacesWithRendered.add("a4j:");
        templatesNamespacesWithRendered.add("rich:");
        templatesNamespacesWithRendered.add("seam:");
    }

    public static Node getAncestorNode(Node sourceNode, String tagName) {
        if (tagName == null) {
            return null;
        }
        Node element = sourceNode;
        do {
            if (!tagName.equalsIgnoreCase(element.getNodeName())) continue;
            return element;
        } while ((element = element.getParentNode()) != null);
        return null;
    }

    public static Node getParentHavingDomMapping(Node sourceNode, VpeDomMapping domMapping) {
        VpeNodeMapping nodeMapping = null;
        Node parent = sourceNode;
        while ((nodeMapping = domMapping.getNodeMapping(parent = parent.getParentNode())) == null && parent != null) {
        }
        return parent;
    }

    public static boolean isRenderedAttrEqFalse(VpePageContext pageContext, Element sourceNode) {
        boolean result = false;
        Element tempElement = sourceNode;
        if (sourceNode.hasAttribute("rendered")) {
            String templateName;
            String[] templatePrefix;
            if (ElService.getInstance().isELNode(pageContext, sourceNode)) {
                tempElement = (Element)VpeProxyUtil.createProxyForELExpressionNode(pageContext, sourceNode);
            }
            if ("false".equals(tempElement.getAttribute("rendered")) && (templatePrefix = (templateName = VpeTemplateManager.getInstance().getTemplateName(pageContext, sourceNode)).split(":")).length > 1 && templatesNamespacesWithRendered.contains(String.valueOf(templatePrefix[0]) + ":")) {
                result = true;
            }
        }
        return result;
    }
}

