/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.util.ProjectNaturesChecker;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class ProjectNaturesInfoDialog
extends MessageDialog {
    private Button button;
    private Link link;
    private boolean isRemember = false;
    private static final String QUESTION = "Do not show this dialog again!";
    private static final String TITLE = "Missing Natures";
    private IProject project;

    public ProjectNaturesInfoDialog(String[] missingNatures, IProject project) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TITLE, null, "", 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.project = project;
        this.message = this.getMessageInfo(missingNatures, project);
    }

    protected Control createCustomArea(Composite parent) {
        GridLayout gridLayout = (GridLayout)parent.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)gridLayout);
        this.button = new Button(parent, 32);
        GridData gridData = new GridData(32);
        this.button.setLayoutData((Object)gridData);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectNaturesInfoDialog.this.isRemember = !ProjectNaturesInfoDialog.this.isRemember;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectNaturesInfoDialog.this.isRemember = !ProjectNaturesInfoDialog.this.isRemember;
            }
        });
        this.button.setText(QUESTION);
        this.link = new Link(parent, 0);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = true;
        this.link.setLayoutData((Object)gridData);
        this.link.setText("<A>" + VpeUIMessages.MOZILLA_LOADING_ERROR_LINK_TEXT + "</A>");
        this.link.setToolTipText(VpeUIMessages.MOZILLA_LOADING_ERROR_LINK);
        this.link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectNaturesInfoDialog.this.processLink(ProjectNaturesInfoDialog.this.link);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectNaturesInfoDialog.this.processLink(ProjectNaturesInfoDialog.this.link);
            }
        });
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                this.project.setPersistentProperty(ProjectNaturesChecker.IS_NATURES_CHECK_NEED, Boolean.toString(!this.isRemember));
            }
            catch (CoreException coreException) {}
        }
        super.buttonPressed(buttonId);
    }

    private void processLink(Link link) {
        BusyIndicator.showWhile((Display)link.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                URL theURL = null;
                try {
                    theURL = new URL(VpeUIMessages.MOZILLA_LOADING_ERROR_LINK);
                }
                catch (MalformedURLException e) {
                    VpePlugin.reportProblem(e);
                }
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    support.getExternalBrowser().openURL(theURL);
                }
                catch (PartInitException e) {
                    VpePlugin.reportProblem((Exception)((Object)e));
                }
            }
        });
    }

    private String arrayToString(String[] strings) {
        StringBuilder builder = new StringBuilder("");
        int i = 0;
        while (i < strings.length) {
            builder.append(String.valueOf(strings[i]) + "\n");
            ++i;
        }
        return builder.toString();
    }

    private String getMessageInfo(String[] missingNatures, IProject project) {
        String dialogMessage = "JBoss Tools Visual Editor might not fully work in project \"" + project.getName() + "\" because it does not have JSF and code completion enabled completely.\n\n" + "Please use the Configure menu on the project to enable JSF if " + "you want all features of the editor working.";
        return dialogMessage;
    }
}

