/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.jboss.tools.vpe.editor.util.ProjectNaturesInfoDialog;

public class ProjectNaturesChecker
implements IResourceChangeListener {
    private static final String SEARCH_CLASS = "javax.faces.webapp.FacesServlet";
    public static final QualifiedName IS_NATURES_CHECK_NEED = new QualifiedName("", "Is natures check");
    public static final QualifiedName IS_JSF_CHECK_NEED = new QualifiedName("", "Is JSF check");
    private Set<IProject> projectsCollection = new HashSet<IProject>(0);
    private static final String JSF_NATURE = "JavaServer Faces Nature";
    private static final String KB_NATURE = "Knowledge Base Nature";
    private static ProjectNaturesChecker checker;

    public static ProjectNaturesChecker getInstance() {
        if (checker == null) {
            checker = new ProjectNaturesChecker();
        }
        return checker;
    }

    private ProjectNaturesChecker() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    ProjectNaturesChecker.this.handleResourceChangeEvent(event);
                }
            });
        }
    }

    public void checkNatures(IProject project) throws CoreException {
        String[] missingNatures;
        if (project == null) {
            return;
        }
        this.addProject(project);
        boolean isJSFCheck = true;
        boolean isNaturesCheck = true;
        this.updateProjectPersistentProperties(project);
        isJSFCheck = Boolean.parseBoolean(project.getPersistentProperty(IS_JSF_CHECK_NEED));
        isNaturesCheck = Boolean.parseBoolean(project.getPersistentProperty(IS_NATURES_CHECK_NEED));
        if (isJSFCheck && isNaturesCheck && (missingNatures = this.getMissingNatures(project)) != null) {
            KbProject.checkKBBuilderInstalled((IResource)project);
            ProjectNaturesInfoDialog dialog = new ProjectNaturesInfoDialog(missingNatures, project);
            dialog.open();
        }
    }

    private String[] getMissingNatures(IProject project) throws CoreException {
        ArrayList<String> missimgNatures = new ArrayList<String>(0);
        if (project.getNature("org.jboss.tools.jst.web.kb.kbnature") == null) {
            missimgNatures.add(JSF_NATURE);
        }
        if (project.getNature("org.jboss.tools.jsf.jsfnature") == null) {
            missimgNatures.add(KB_NATURE);
        }
        if (missimgNatures.size() == 0) {
            return null;
        }
        return missimgNatures.toArray(new String[0]);
    }

    private void handleResourceChangeEvent(IResourceChangeEvent changeEvent) {
        IResourceDelta[] affectedChildren = changeEvent.getDelta().getAffectedChildren();
        if (affectedChildren == null) {
            return;
        }
        int i = 0;
        while (i < affectedChildren.length) {
            IResourceDelta resourceDelta = affectedChildren[i];
            if (resourceDelta.getResource() instanceof IProject) {
                IProject project = (IProject)resourceDelta.getResource();
                if (resourceDelta.getKind() == 1) {
                    this.processAddProject(project);
                } else if (resourceDelta.getKind() == 2) {
                    this.processRemoveProject(project);
                } else {
                    try {
                        this.updateProjectJSFPersistents(project);
                    }
                    catch (CoreException e) {
                        VpePlugin.getPluginLog().logError((Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    private void updateProjectPersistentProperties(IProject project) throws CoreException {
        if (project.isAccessible()) {
            String jsfCheckString = project.getPersistentProperty(IS_JSF_CHECK_NEED);
            if (jsfCheckString == null) {
                this.updateProjectJSFPersistents(project);
            }
            if (project.getPersistentProperty(IS_NATURES_CHECK_NEED) == null) {
                project.setPersistentProperty(IS_NATURES_CHECK_NEED, "true");
            }
        }
    }

    public IProject getProject(IProject project) {
        return this.projectsCollection.contains(project) ? project : null;
    }

    public void addProject(IProject project) {
        if (this.getProject(project) == null) {
            this.projectsCollection.add(project);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.projectsCollection.clear();
    }

    private void processAddProject(IProject project) {
        this.addProject(project);
        try {
            this.updateProjectJSFPersistents(project);
        }
        catch (CoreException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private void processRemoveProject(IProject project) {
        this.projectsCollection.remove(project);
    }

    private void updateProjectJSFPersistents(IProject project) throws CoreException {
        if (project.isAccessible()) {
            try {
                IJavaElement javaElement = FileUtil.searchForClass(JavaCore.create((IProject)project), SEARCH_CLASS);
                if (javaElement == null) {
                    project.setPersistentProperty(IS_JSF_CHECK_NEED, "false");
                } else {
                    project.setPersistentProperty(IS_JSF_CHECK_NEED, "true");
                }
            }
            catch (CoreException coreException) {
                project.setPersistentProperty(IS_JSF_CHECK_NEED, "false");
            }
        }
    }
}

