/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.resref.core.AbsoluteFolderReferenceList;
import org.jboss.tools.vpe.resref.core.RelativeFolderReferenceList;

public class FileUtil {
    private static final String JSF2_RESOURCES = "/resources/";

    public static final String getJSF2ResourcePath(VpePageContext pageContext, String resourceStr) {
        if (resourceStr.contains(":")) {
            String[] parts = resourceStr.split(":");
            return FileUtil.getJSF2ResourcePath(pageContext, parts[0], parts[1]);
        }
        return FileUtil.getJSF2ResourcePath(pageContext, null, resourceStr);
    }

    public static final String getJSF2ResourcePath(VpePageContext pageContext, String library, String name) {
        String tempString = library == null ? name : String.valueOf(library) + '/' + name;
        tempString = JSF2_RESOURCES + tempString;
        String result = "";
        if (VpeCreatorUtil.getFile(tempString, pageContext) == null) {
            String tempEntryPath = FileUtil.seachResourceInClassPath(pageContext, "META-INF" + tempString);
            if (tempEntryPath != null) {
                result = tempEntryPath;
            }
        } else {
            result = tempString;
        }
        return result;
    }

    public static boolean isExistsInJSF2Resources(VpePageContext pageContext, String resStr) {
        String resourceString = resStr;
        resourceString = resourceString.replaceAll(":", "/");
        resourceString = JSF2_RESOURCES + resourceString;
        return FileUtil.getFile(pageContext.getEditPart().getEditorInput(), resourceString) != null || FileUtil.seachResourceInClassPath(pageContext, "META-INF" + resourceString) != null;
    }

    private static String seachResourceInClassPath(VpePageContext pageContext, String classPathResource) {
        String result = null;
        IFile currentFile = (IFile)pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage();
        IProject project = currentFile.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                JarPackageFragmentRoot jarPackageFragmentRoot;
                ZipEntry zipEntry;
                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n2];
                if (fragmentRoot instanceof JarPackageFragmentRoot && (zipEntry = (jarPackageFragmentRoot = (JarPackageFragmentRoot)fragmentRoot).getJar().getEntry(classPathResource)) != null) {
                    InputStream inputStream = jarPackageFragmentRoot.getJar().getInputStream(zipEntry);
                    IPath stateLocation = VpePlugin.getDefault().getStateLocation();
                    String fileName = null;
                    String fileExtension = null;
                    if (classPathResource.lastIndexOf(".") != -1) {
                        fileName = classPathResource.substring(classPathResource.lastIndexOf("/") + 1, classPathResource.lastIndexOf("."));
                        fileExtension = classPathResource.substring(classPathResource.lastIndexOf("."), classPathResource.length());
                    }
                    if (fileName != null && fileName.length() > 0 && fileExtension != null && fileExtension.length() > 0) {
                        int len;
                        File temporaryFile = File.createTempFile(fileName, fileExtension, new File(stateLocation.toOSString()));
                        temporaryFile.deleteOnExit();
                        FileOutputStream out = new FileOutputStream(temporaryFile, false);
                        byte[] buf = new byte[1024];
                        while ((len = inputStream.read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                        }
                        inputStream.close();
                        ((OutputStream)out).close();
                        result = temporaryFile.getAbsolutePath();
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            VpePlugin.reportProblem(e);
        }
        catch (FileNotFoundException e) {
            VpePlugin.reportProblem(e);
        }
        catch (CoreException e) {
            VpePlugin.reportProblem((Exception)((Object)e));
        }
        catch (IOException e) {
            VpePlugin.reportProblem(e);
        }
        return result;
    }

    public static IFile getFile(IEditorInput input, String value) {
        Path tagPath = new Path(value);
        if (tagPath.isEmpty()) {
            return null;
        }
        if (input instanceof IFileEditorInput) {
            IContainer container = null;
            if (tagPath.isAbsolute()) {
                container = FileUtil.getWebRoot((IFileEditorInput)input);
            } else {
                IFile inputFile = ((IFileEditorInput)input).getFile();
                if (inputFile != null) {
                    container = inputFile.getParent();
                }
            }
            IFile f = container == null ? null : container.getFile((IPath)tagPath);
            return f == null || !f.exists() ? null : f;
        }
        if (input instanceof ILocationProvider) {
            IPath path = ((ILocationProvider)input).getPath((Object)input);
            if (path == null || path.segmentCount() < 1) {
                return null;
            }
            path = path.removeLastSegments(1).append(value);
            return EclipseResourceUtil.getFile((String)path.toString());
        }
        return null;
    }

    private static IContainer getWebRoot(IFileEditorInput input) {
        IProject project = input.getFile().getProject();
        if (project != null && project.isOpen()) {
            IModelNature modelNature = EclipseResourceUtil.getModelNature((IProject)project);
            XModel model = modelNature == null ? null : modelNature.getModel();
            XModelObject webRoot = model == null ? null : model.getByPath("FileSystems/WEB-ROOT");
            IResource webRootResource = webRoot == null ? null : EclipseResourceUtil.getResource((XModelObject)webRoot);
            return webRootResource instanceof IContainer ? (IContainer)webRootResource : null;
        }
        return null;
    }

    public static IFile getFile(String fileName, IFile includeFile) {
        IFile file = null;
        if (fileName.startsWith("/")) {
            ResourceReference[] resources = AbsoluteFolderReferenceList.getInstance().getAllResources(includeFile);
            if (resources != null && resources.length == 1) {
                String location = String.valueOf(resources[0].getLocation()) + fileName;
                Path path = new Path(location);
                return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            }
            IVirtualComponent com = ComponentCore.createComponent((IProject)includeFile.getProject());
            if (com != null) {
                IVirtualFolder webRootFolder = com.getRootFolder().getFolder((IPath)new Path("/"));
                IContainer folder = webRootFolder.getUnderlyingFolder();
                IPath path = folder.getFullPath().append(fileName);
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            } else {
                file = FileUtil.resolveRelatedPath(includeFile, fileName);
            }
        } else {
            ResourceReference[] resources = RelativeFolderReferenceList.getInstance().getAllResources(includeFile);
            if (resources != null && resources.length == 1) {
                String location = String.valueOf(resources[0].getLocation()) + File.separator + fileName;
                Path path = new Path(location);
                return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            }
            file = FileUtil.resolveRelatedPath(includeFile, fileName);
        }
        return file;
    }

    private static IFile resolveRelatedPath(IFile baseFile, String relatedFilePath) {
        IPath currentFolder = baseFile.getParent().getFullPath();
        IPath path = currentFolder.append(relatedFilePath);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    public static void openEditor(IFile file) {
        IWorkbenchPage workbenchPage = VpePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            if (file != null) {
                IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException ex) {
            VpePlugin.reportProblem((Exception)((Object)ex));
        }
    }

    public static IPath getInputPath(IEditorInput input) {
        IFile inputFile;
        IPath inputPath = null;
        if (input instanceof ILocationProvider) {
            inputPath = ((ILocationProvider)input).getPath((Object)input);
        } else if (input instanceof IFileEditorInput && (inputFile = ((IFileEditorInput)input).getFile()) != null) {
            inputPath = inputFile.getLocation();
        }
        return inputPath;
    }

    public static IJavaElement searchForClass(IJavaProject javaProject, String className) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)8);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        final ArrayList matches = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                matches.add(match);
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (CoreException coreException) {}
        Iterator i = matches.iterator();
        while (i != null && i.hasNext()) {
            IJavaElement element = (IJavaElement)((SearchMatch)i.next()).getElement();
            String classQualifiedName = FileUtil.getQualifiedClassName(element);
            if (!className.equals(classQualifiedName)) continue;
            return element;
        }
        return javaProject.findType(className, (IProgressMonitor)new NullProgressMonitor());
    }

    private static String getQualifiedClassName(IJavaElement element) {
        if (element instanceof IType) {
            return ((IType)element).getFullyQualifiedName('.');
        }
        return null;
    }
}

