/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format.css;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.vpe.editor.toolbar.format.css.SinglePropertyValue;
import org.jboss.tools.vpe.editor.toolbar.format.css.Token;

public class MultiPropertyValue
extends Token {
    private ArrayList tokens = new ArrayList();

    public MultiPropertyValue(String dirtyValue) {
        super(dirtyValue);
        this.parse(dirtyValue);
    }

    private void parse(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " ", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(" ")) {
                this.tokens.add(new Token(token));
                continue;
            }
            this.tokens.add(new SinglePropertyValue(token));
        }
    }

    public SinglePropertyValue getSinglePropertyValue(String value) {
        int i = 0;
        while (i < this.tokens.size()) {
            SinglePropertyValue propertyValue;
            if (this.tokens.get(i) instanceof SinglePropertyValue && value.equalsIgnoreCase((propertyValue = (SinglePropertyValue)this.tokens.get(i)).getCleanValue())) {
                return propertyValue;
            }
            ++i;
        }
        return null;
    }

    public SinglePropertyValue[] getSinglePropertyValues() {
        ArrayList values = new ArrayList();
        int i = 0;
        while (i < this.tokens.size()) {
            if (this.tokens.get(i) instanceof SinglePropertyValue) {
                values.add(this.tokens.get(i));
            }
            ++i;
        }
        return values.toArray(new SinglePropertyValue[values.size()]);
    }

    public boolean addSingleValue(String value) {
        SinglePropertyValue propertyValue = this.getSinglePropertyValue(value);
        if (propertyValue == null) {
            String newValue = value;
            if (!((Token)this.tokens.get(this.tokens.size() - 1)).getDirtyValue().endsWith(" ")) {
                newValue = " " + newValue;
            }
            return this.tokens.add(new SinglePropertyValue(newValue));
        }
        return false;
    }

    public boolean removeSinglePropertyValue(String value) {
        SinglePropertyValue propertyValue = this.getSinglePropertyValue(value);
        if (propertyValue != null) {
            return this.tokens.remove(propertyValue);
        }
        return false;
    }

    public boolean hasPropertyValue() {
        int i = 0;
        while (i < this.tokens.size()) {
            if (this.tokens.get(i) instanceof SinglePropertyValue) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.tokens.size()) {
            buffer.append(this.tokens.get(i).toString());
            ++i;
        }
        return buffer.toString();
    }
}

