/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format;

import java.util.HashMap;
import org.eclipse.swt.widgets.Combo;
import org.jboss.tools.vpe.editor.template.textformating.FormatAttributeData;
import org.jboss.tools.vpe.editor.toolbar.format.ComboFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.css.StyleAttribute;
import org.jboss.tools.vpe.editor.toolbar.format.css.StyleProperty;
import org.w3c.dom.Attr;

public class FontSizeFormatController
extends ComboFormatController {
    public static String TYPE = "FontSizeFormat";
    private static String STYLE_PROPERTY_NAME = "FONT-SIZE";
    private static HashMap<String, String> SIZES = new HashMap();

    static {
        SIZES.put("1", "xx-small");
        SIZES.put("2", "x-small");
        SIZES.put("3", "small");
        SIZES.put("4", "medium");
        SIZES.put("5", "large");
        SIZES.put("6", "x-large");
        SIZES.put("7", "xx-large");
    }

    public FontSizeFormatController(FormatControllerManager manager, Combo comboBlockFormat) {
        super(manager, comboBlockFormat);
    }

    public String getType() {
        return TYPE;
    }

    protected void setStyle(Attr styleAttribute, FormatAttributeData templateData) {
        String value = this.createStylePropertyValue();
        if (value != null) {
            FontSizeFormatController.setSingleStyleProperty(styleAttribute, STYLE_PROPERTY_NAME, value);
        } else {
            StyleAttribute style = new StyleAttribute(styleAttribute);
            style.removeStyleProperty(STYLE_PROPERTY_NAME);
            String newStyle = style.toString().trim();
            styleAttribute.setValue(newStyle);
        }
    }

    private String createStylePropertyValue() {
        if (this.selectionText != null && this.selectionText.trim().length() > 0) {
            return SIZES.get(this.selectionText.trim());
        }
        return null;
    }

    public void setToolbarItemEnabled(boolean enabled) {
        String fontSize;
        StyleAttribute styleAttribute;
        StyleProperty fontProperty;
        Attr style;
        this.comboBlockFormat.setEnabled(enabled);
        if (enabled && (style = this.getStyleAttributeFromSelectedNode(true)) != null && (fontProperty = (styleAttribute = new StyleAttribute(style)).getProperty(STYLE_PROPERTY_NAME)) != null && (fontSize = fontProperty.getFirstSinglePropertyValue()) != null) {
            String[] items = this.getComboBlockFormat().getItems();
            int i = 1;
            while (i < items.length) {
                if (SIZES.get(items[i]).equals(fontSize)) {
                    if (this.getComboBlockFormat().getSelectionIndex() != i) {
                        this.getComboBlockFormat().select(i);
                    }
                    return;
                }
                ++i;
            }
        }
        this.getComboBlockFormat().select(0);
    }
}

