/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format;

import java.util.HashMap;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.jboss.tools.vpe.editor.template.textformating.FormatAttributeData;
import org.jboss.tools.vpe.editor.toolbar.format.ComboFormatController;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class BlockFormatController
extends ComboFormatController {
    public static String TYPE = "BlockFormat";
    public static HashMap TAGS = new HashMap();
    public static HashMap TEXTS;
    private String tagName;

    static {
        TAGS.put("address", "Address");
        TAGS.put("h1", "Heading 1");
        TAGS.put("h2", "Heading 2");
        TAGS.put("h3", "Heading 3");
        TAGS.put("h4", "Heading 4");
        TAGS.put("h5", "Heading 5");
        TAGS.put("h6", "Heading 6");
        TEXTS = new HashMap();
        TEXTS.put("Address", "address");
        TEXTS.put("Heading 1", "h1");
        TEXTS.put("Heading 2", "h2");
        TEXTS.put("Heading 3", "h3");
        TEXTS.put("Heading 4", "h4");
        TEXTS.put("Heading 5", "h5");
        TEXTS.put("Heading 6", "h6");
    }

    public BlockFormatController(FormatControllerManager manager, Combo comboBlockFormat) {
        super(manager, comboBlockFormat);
    }

    public String getType() {
        return TYPE;
    }

    public void handleEvent(Event event) {
        this.selectionIndex = ((Combo)event.widget).getSelectionIndex();
        this.selectionText = ((Combo)event.widget).getText();
        this.tagName = (String)TEXTS.get(this.selectionText);
        if (this.tagName == null) {
            this.tagName = "normal";
        }
        super.handleEvent(event);
    }

    protected void setStyle(Attr styleAttribute, FormatAttributeData templateData) {
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setToolbarItemEnabled(boolean enabled) {
        this.comboBlockFormat.setEnabled(enabled);
        if (enabled) {
            Node selectedNode = this.manager.getCurrentSelectedNode();
            String nodeName = this.getNodeName(selectedNode).toLowerCase();
            String text = (String)TAGS.get(nodeName);
            if (text == null) {
                this.getComboBlockFormat().select(0);
                return;
            }
            if (text != null && text.equals(this.getComboBlockFormat().getText())) {
                return;
            }
            String[] items = this.getComboBlockFormat().getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equalsIgnoreCase(text)) {
                    this.getComboBlockFormat().select(i);
                    return;
                }
                ++i;
            }
        }
        this.getComboBlockFormat().deselectAll();
    }

    private String getNodeName(Node node) {
        String nodeName = "";
        do {
            nodeName = node.getNodeName();
            node = node.getParentNode();
        } while (nodeName.equalsIgnoreCase("u") || nodeName.equalsIgnoreCase("b") || nodeName.equalsIgnoreCase("i"));
        return nodeName;
    }
}

