/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.expression;

import java.util.List;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeFunction;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.w3c.dom.Node;

public class VpeFunctionHasInParents
extends VpeFunction {
    public VpeValue exec(VpePageContext pageContext, Node sourceNode) throws VpeExpressionException {
        String prm = this.getParameter(0).exec(pageContext, sourceNode).stringValue();
        Node parentNode = sourceNode.getParentNode();
        while (parentNode != null) {
            String parentSourcePrefix = parentNode.getPrefix();
            if (parentSourcePrefix == null) {
                parentSourcePrefix = "";
            }
            List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(parentNode, pageContext);
            TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(parentSourcePrefix, taglibs);
            String parentNodeName = parentNode.getNodeName();
            if (sourceNodeTaglib != null) {
                String sourceNodeUri = sourceNodeTaglib.getUri();
                String templateTaglibPrefix = VpeTemplateManager.getInstance().getTemplateTaglibPrefix(sourceNodeUri);
                if (templateTaglibPrefix != null) {
                    parentNodeName = String.valueOf(templateTaglibPrefix) + ":" + parentNode.getLocalName();
                }
            }
            if (parentNodeName.equals(prm)) {
                return new VpeValue(true);
            }
            parentNode = parentNode.getParentNode();
        }
        return new VpeValue(false);
    }
}

