/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.Map;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeLinkCreator
extends VpeAbstractCreator {
    private boolean caseSensitive;
    private VpeExpression hrefExpr;

    VpeLinkCreator(Element taglibElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(taglibElement, dependencyMap);
    }

    private void build(Element element, VpeDependencyMap dependencyMap) {
        Attr hrefAttr = element.getAttributeNode("href");
        if (hrefAttr != null) {
            try {
                String hrefStr = hrefAttr.getValue();
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(hrefStr, this.caseSensitive);
                this.hrefExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
    }

    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) {
        String href_value = this.getExprValue(pageContext, this.hrefExpr, sourceNode);
        nsIDOMNode newNode = pageContext.getVisualBuilder().addLinkNodeToHead(href_value, "no", false);
        visualNodeMap.put(this, newNode);
        VpeCreatorInfo creatorInfo = new VpeCreatorInfo(null);
        return creatorInfo;
    }

    public void removeElement(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        nsIDOMNode linkNode = (nsIDOMNode)visualNodeMap.get(this);
        if (linkNode != null) {
            pageContext.getVisualBuilder().removeLinkNodeFromHead(linkNode);
            visualNodeMap.remove(this);
        }
    }

    public void refreshElement(VpePageContext pageContext, Element sourceElement, Map visualNodeMap) {
        nsIDOMNode newNode;
        String href_value = this.getExprValue(pageContext, this.hrefExpr, sourceElement);
        nsIDOMNode oldNode = (nsIDOMNode)visualNodeMap.get(this);
        if (oldNode == null) {
            newNode = pageContext.getVisualBuilder().addLinkNodeToHead(href_value, "no", false);
        } else {
            newNode = pageContext.getVisualBuilder().replaceLinkNodeToHead(oldNode, href_value, "no");
            if (visualNodeMap.containsKey(this)) {
                visualNodeMap.remove(this);
            }
        }
        visualNodeMap.put(this, newNode);
    }

    public void removeAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name) {
        this.refreshElement(pageContext, sourceElement, visualNodeMap);
    }

    public void setAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name, String value) {
        this.refreshElement(pageContext, sourceElement, visualNodeMap);
    }

    private String getExprValue(VpePageContext pageContext, VpeExpression expr, Node sourceNode) {
        String value;
        if (expr != null) {
            try {
                value = expr.exec(pageContext, sourceNode).stringValue();
            }
            catch (VpeExpressionException ex) {
                VpePlugin.reportProblem(ex);
                value = "";
            }
        } else {
            value = "";
        }
        return value;
    }
}

