/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeAttributeCreator;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeLabeledFormCreator
extends VpeAbstractCreator {
    private boolean caseSensitive;
    private VpeExpression labelNameExpr;
    private List propertyCreators;
    private Set dependencySet;

    VpeLabeledFormCreator(Element gridElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(gridElement, dependencyMap);
    }

    private void build(Element gridElement, VpeDependencyMap dependencyMap) {
        Attr labelNameAttr = gridElement.getAttributeNode("labelName");
        if (labelNameAttr != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(labelNameAttr.getValue(), this.caseSensitive);
                this.labelNameExpr = info.getExpression();
                this.dependencySet = info.getDependencySet();
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if (VpeTemplateManager.ATTR_LABELED_FORM_PROPERTIES != null) {
            int i = 0;
            while (i < VpeTemplateManager.ATTR_LABELED_FORM_PROPERTIES.length) {
                String attrName = VpeTemplateManager.ATTR_LABELED_FORM_PROPERTIES[i];
                Attr attr = gridElement.getAttributeNode(attrName);
                if (attr != null) {
                    if (this.propertyCreators == null) {
                        this.propertyCreators = new ArrayList();
                    }
                    this.propertyCreators.add(new VpeAttributeCreator(attrName, attr.getValue(), dependencyMap, this.caseSensitive));
                }
                ++i;
            }
        }
    }

    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        NodeList children;
        int count;
        VpeValue vpeValue;
        String labelAttrName = "label";
        if (this.labelNameExpr != null && (vpeValue = this.labelNameExpr.exec(pageContext, sourceNode)) != null) {
            labelAttrName = vpeValue.stringValue();
        }
        nsIDOMElement visualTable = visualDocument.createElement("table");
        VpeCreatorInfo creatorInfo = new VpeCreatorInfo((nsIDOMNode)visualTable);
        if (this.propertyCreators != null) {
            int i = 0;
            while (i < this.propertyCreators.size()) {
                VpeCreatorInfo info;
                VpeCreator creator = (VpeCreator)this.propertyCreators.get(i);
                if (creator != null && (info = creator.create(pageContext, (Element)sourceNode, visualDocument, visualTable, visualNodeMap)) != null && info.getVisualNode() != null) {
                    nsIDOMAttr attr = (nsIDOMAttr)info.getVisualNode();
                    visualTable.setAttributeNode(attr);
                }
                ++i;
            }
        }
        int n = count = (children = sourceNode.getChildNodes()) != null ? children.getLength() : 0;
        if (count > 0) {
            Node[] sourceChildren = new Node[count];
            int childrenCount = 0;
            int i = 0;
            while (i < count) {
                Node node = children.item(i);
                short type = node.getNodeType();
                if (type == 1 || type == 3 && node.getNodeValue().trim().length() > 0) {
                    sourceChildren[childrenCount] = node;
                    ++childrenCount;
                }
                ++i;
            }
            Node attrNode = null;
            int i2 = 0;
            while (i2 < childrenCount) {
                NamedNodeMap attrMap = sourceChildren[i2].getAttributes();
                if (attrMap != null) {
                    attrNode = attrMap.getNamedItem(labelAttrName);
                }
                nsIDOMElement row = visualDocument.createElement("tr");
                nsIDOMElement labelCell = visualDocument.createElement("td");
                if (attrNode != null) {
                    String labelValue = attrNode.getNodeValue();
                    nsIDOMText text = visualDocument.createTextNode(labelValue);
                    labelCell.appendChild((nsIDOMNode)text);
                }
                row.appendChild((nsIDOMNode)labelCell);
                nsIDOMElement valueCell = visualDocument.createElement("td");
                row.appendChild((nsIDOMNode)valueCell);
                visualTable.appendChild((nsIDOMNode)row);
                VpeChildrenInfo rowInfo = new VpeChildrenInfo(row);
                rowInfo.addSourceChild(sourceChildren[i2]);
                creatorInfo.addChildrenInfo(rowInfo);
                ++i2;
            }
        }
        creatorInfo.addDependencySet(this.dependencySet);
        return creatorInfo;
    }
}

