/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class VpeAbstractBodyTemplate
extends VpeAbstractTemplate {
    protected abstract String getTargetAttributeName(String var1);

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement body = VpeAbstractBodyTemplate.getBody((nsIDOMNode)visualDocument.getDocumentElement());
        this.cleanBody(body);
        nsIDOMElement div = visualDocument.createElement("div");
        NamedNodeMap sourceNodeAttributes = sourceNode.getAttributes();
        int i = 0;
        while (i < sourceNodeAttributes.getLength()) {
            Node sourceAttribute = sourceNodeAttributes.item(i);
            String sourceAttributeName = sourceAttribute.getNodeName();
            String attributeValue = sourceAttribute.getNodeValue();
            String targetAttributeName = this.getTargetAttributeName(sourceAttributeName);
            if (targetAttributeName != null) {
                if ("id".equalsIgnoreCase(targetAttributeName)) {
                    div.setAttribute("id", attributeValue);
                } else {
                    if ("style".equalsIgnoreCase(targetAttributeName)) {
                        attributeValue = VpeStyleUtil.addFullPathIntoURLValue(attributeValue, pageContext);
                    }
                    if ("background".equalsIgnoreCase(targetAttributeName)) {
                        attributeValue = VpeStyleUtil.addFullPathIntoBackgroundValue(attributeValue, pageContext.getEditPart().getEditorInput());
                    }
                    try {
                        body.setAttribute(targetAttributeName, attributeValue);
                    }
                    catch (XPCOMException xPCOMException) {}
                }
            }
            ++i;
        }
        return new VpeCreationData((nsIDOMNode)div);
    }

    protected void cleanBody(nsIDOMElement body) {
        nsIDOMNamedNodeMap attributes = body.getAttributes();
        long len = attributes.getLength();
        int j = 0;
        int i = 0;
        while ((long)i < len) {
            nsIDOMNode attr = attributes.item((long)j);
            if ("id".equalsIgnoreCase(attr.getNodeName())) {
                ++j;
            } else {
                body.removeAttribute(attr.getNodeName());
            }
            ++i;
        }
    }

    protected static nsIDOMElement getBody(nsIDOMNode node) {
        nsIDOMNodeList nodeChildren = node.getChildNodes();
        int i = 0;
        while ((long)i < nodeChildren.getLength()) {
            nsIDOMNode nodeChild = nodeChildren.item((long)i);
            if ("body".equalsIgnoreCase(nodeChild.getNodeName())) {
                return (nsIDOMElement)nodeChild.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            }
            nsIDOMElement body = VpeAbstractBodyTemplate.getBody(nodeChild);
            if (body != null) {
                return body;
            }
            ++i;
        }
        return null;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    public void beforeRemove(VpePageContext pageContext, Node sourceNode, nsIDOMNode visualNode, Object data) {
        nsIDOMElement body = VpeAbstractBodyTemplate.getBody((nsIDOMNode)visualNode.getOwnerDocument().getDocumentElement());
        this.cleanBody(body);
    }
}

