/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.selection;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.vpe.editor.selection.VpeSelectionHelper;
import org.jboss.tools.vpe.editor.selection.VpeSourceSelection;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class VpeSourceSelectionBuilder {
    StructuredTextEditor sourceEditor;

    public VpeSourceSelectionBuilder(StructuredTextEditor sourceEditor) {
        this.sourceEditor = sourceEditor;
    }

    public VpeSourceSelection getSelection() {
        Object node;
        IDOMElement element;
        Node focusNode;
        boolean reversionFlag;
        Point range = this.sourceEditor.getTextViewer().getSelectedRange();
        int anchorPosition = range.x;
        int focusPosition = range.x + range.y;
        boolean extendFlag = range.y != 0;
        boolean bl = reversionFlag = extendFlag && anchorPosition == VpeSelectionHelper.getCaretOffset(this.sourceEditor);
        if (reversionFlag) {
            anchorPosition = focusPosition;
            focusPosition = range.x;
        }
        if ((focusNode = VpeSourceSelectionBuilder.getSourceNodeAt(this.sourceEditor, focusPosition)) == null) {
            return null;
        }
        int focusOffset = this.getSourceNodeOffset(focusNode, focusPosition, !reversionFlag);
        Node anchorNode = null;
        int anchorOffset = 0;
        if (extendFlag) {
            anchorNode = VpeSourceSelectionBuilder.getSourceNodeAt(this.sourceEditor, anchorPosition);
            anchorOffset = this.getSourceNodeOffset(anchorNode, anchorPosition, reversionFlag);
        } else {
            anchorNode = focusNode;
            anchorOffset = focusOffset;
        }
        VpeSourceSelection selection = null;
        selection = reversionFlag ? new VpeSourceSelection(focusNode, focusOffset, anchorNode, anchorOffset) : new VpeSourceSelection(anchorNode, anchorOffset, focusNode, focusOffset);
        ArrayList<AttrImpl> selectedNodes = null;
        if (focusNode instanceof IDOMElement && focusPosition < (element = (IDOMElement)focusNode).getEndStartOffset()) {
            NamedNodeMap attrs = focusNode.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                AttrImpl attr = (AttrImpl)attrs.item(i);
                ITextRegion region = attr.getValueRegion();
                if (region == null) break;
                int attrStart = region.getStart();
                int attrEnd = attrStart + attr.getValue().length();
                if (range.x - ((ElementImpl)attr.getOwnerElement()).getStartOffset() - 1 >= attrStart && range.x - ((ElementImpl)attr.getOwnerElement()).getStartOffset() - 1 <= attrEnd) {
                    selectedNodes = new ArrayList<AttrImpl>();
                    selectedNodes.add(attr);
                    break;
                }
                ++i;
            }
        }
        if (selectedNodes == null) {
            selectedNodes = VpeSelectionHelper.getTextWidgetSelectedNodes(this.sourceEditor.getModel(), this.sourceEditor.getSelectionProvider());
        }
        if (selectedNodes != null && selectedNodes.size() == 1 && (node = selectedNodes.get(0)) instanceof AttrImpl) {
            AttrImpl attr = (AttrImpl)node;
            int attrStart = attr.getValueRegion().getStart();
            int attrEnd = attrStart + attr.getValue().length();
            if (range.x - ((ElementImpl)attr.getOwnerElement()).getStartOffset() - 1 >= attrStart && range.x - ((ElementImpl)attr.getOwnerElement()).getStartOffset() - 1 <= attrEnd) {
                selection.setFocusAttribute((Attr)node);
                Point attrRange = new Point(range.x - (((ElementImpl)attr.getOwnerElement()).getStartOffset() + attr.getValueRegion().getStart()) - 1, range.y);
                selection.setFocusAttributeRange(attrRange);
            }
        }
        return selection;
    }

    public static Node getSourceNodeAt(StructuredTextEditor srcEditor, int offset) {
        if (srcEditor != null && srcEditor.getModel() != null) {
            IndexedRegion node = srcEditor.getModel().getIndexedRegion(offset);
            if (node == null) {
                node = srcEditor.getModel().getIndexedRegion(offset - 1);
            }
            if (node instanceof Node) {
                return (Node)node;
            }
        }
        return null;
    }

    private int getSourceNodeOffset(Node node, int pos, boolean endFlag) {
        if (node == null) {
            return 0;
        }
        int start = ((IndexedRegion)node).getStartOffset();
        int end = ((IndexedRegion)node).getEndOffset();
        if (node.getNodeType() == 3) {
            if (pos < start) {
                return 0;
            }
            if (pos > end) {
                return end - start;
            }
            return pos - start;
        }
        if (node.getNodeType() == 1) {
            ElementImpl element = (ElementImpl)node;
            if (element.isContainer()) {
                if (pos < element.getStartEndOffset()) {
                    return 0;
                }
                if (element.hasEndTag() && pos <= element.getEndStartOffset()) {
                    return 2;
                }
                return 1;
            }
            return endFlag ? 1 : 0;
        }
        if (node.getNodeType() == 8) {
            int offset;
            if (pos > end) {
                pos = end;
            }
            return (offset = pos - start - 4) < 0 ? 0 : offset;
        }
        return endFlag ? 1 : 0;
    }
}

