/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.jboss.tools.vpe.editor.selection.VpeSelectedNodeInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class VpeSourceSelection {
    private Node startNode;
    private int startOffset;
    private Node endNode;
    private int endOffset;
    private List selectedNodes;
    private Attr focusAttribute;
    private Point focusAttributeRange;

    public VpeSourceSelection(Node startNode, int startOffset, Node endNode, int endOffset) {
        this.startNode = startNode;
        this.startOffset = startOffset;
        this.endNode = endNode;
        this.endOffset = endOffset;
        this.selectedNodes = this.getSelNodes();
    }

    public List getSelectedNodes() {
        return this.selectedNodes;
    }

    private List getSelNodes() {
        ArrayList<VpeSelectedNodeInfo> nodes = Collections.EMPTY_LIST;
        VpeNodeIterator nodeIterator = new VpeNodeIterator(this.startNode, this.endNode);
        Node nextNode = nodeIterator.nextNode();
        if (nextNode != null) {
            nodes = new ArrayList<VpeSelectedNodeInfo>();
        }
        while (nextNode != null) {
            VpeSelectedNodeInfo nextNodeInfo = null;
            short type = nextNode.getNodeType();
            if (type == 3 || type == 8) {
                nextNodeInfo = nextNode == this.startNode && nextNode == this.endNode ? new VpeSelectedNodeInfo(nextNode, this.startOffset, this.endOffset) : (nextNode == this.startNode ? new VpeSelectedNodeInfo(nextNode, this.startOffset, nextNode.getNodeValue().length()) : (nextNode == this.endNode ? new VpeSelectedNodeInfo(nextNode, 0, this.endOffset) : new VpeSelectedNodeInfo(nextNode, 0, nextNode.getNodeValue().length())));
            } else if (nextNode.getNodeType() == 1 && !this.inParents(nextNode, this.endNode)) {
                nextNodeInfo = new VpeSelectedNodeInfo(nextNode);
            }
            if (nextNodeInfo != null) {
                nodes.add(nextNodeInfo);
            }
            nextNode = nodeIterator.nextNode();
        }
        return nodes;
    }

    private boolean inParents(Node node1, Node node2) {
        if (node2 != null) {
            Node p = node2.getParentNode();
            while (p != null) {
                if (p == node1) {
                    return true;
                }
                p = p.getParentNode();
            }
        }
        return false;
    }

    public Node getCommonAncestor() {
        if (this.endNode == null) {
            return null;
        }
        Node na = this.endNode;
        while (na != null) {
            Node ta = this.startNode;
            while (ta != null) {
                if (ta == na) {
                    return ta;
                }
                ta = ta.getParentNode();
            }
            na = na.getParentNode();
        }
        return null;
    }

    public boolean isOneNodeSelected() {
        return this.startNode == this.endNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public Node getStartNode() {
        return this.startNode;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public boolean isCollapsed() {
        return this.isOneNodeSelected() && this.startOffset == this.endOffset;
    }

    public Node getFocusNode() {
        return this.endNode;
    }

    public int getFocusOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public Attr getFocusAttribute() {
        return this.focusAttribute;
    }

    public void setFocusAttribute(Attr focusAttribute) {
        this.focusAttribute = focusAttribute;
    }

    public Point getFocusAttributeRange() {
        return this.focusAttributeRange;
    }

    public void setFocusAttributeRange(Point focusAttributeRange) {
        this.focusAttributeRange = focusAttributeRange;
    }

    public static class VpeNodeIterator {
        private Node nextNode;
        private Node endNode;

        public VpeNodeIterator(Node startNode, Node endNode) {
            this.nextNode = startNode;
            this.endNode = endNode;
        }

        public Node nextNode() {
            Node node = this.getNextNode();
            if (node != null) {
                return node;
            }
            return null;
        }

        private final Node getNextNode() {
            if (this.nextNode == null) {
                return null;
            }
            Node oldNext = this.nextNode;
            Node child = this.nextNode.getFirstChild();
            if (child != null) {
                this.nextNode = child;
                return oldNext;
            }
            Node node = this.nextNode;
            while (node != null && !node.equals(this.endNode)) {
                Node next = node.getNextSibling();
                if (next != null) {
                    this.nextNode = next;
                    return oldNext;
                }
                node = node.getParentNode();
            }
            this.nextNode = null;
            return oldNext;
        }
    }
}

