/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.preferences;

import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeEditAnyDialog;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class TemplatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private static final String[] COLUMNS_NAMES = new String[]{VpeUIMessages.TemplatesTableProvider_TagName, VpeUIMessages.TemplatesTableProvider_TagForDisplay, VpeUIMessages.TemplatesTableProvider_URI, VpeUIMessages.TemplatesTableProvider_Children};
    private static final int[] COLUMNS_WIDTHS = new int[]{50, 50, 90, 40};
    private Table tagsTable;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private List<VpeAnyData> tagsList = VpeTemplateManager.getInstance().getAnyTemplates();
    protected boolean tagListWasChanged;

    public String getTitle() {
        return VpeUIMessages.TEMPLATES;
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setFont(parent.getFont());
        this.tagsTable = new Table(composite, 68352);
        TableLayout layout = new TableLayout();
        this.tagsTable.setLayout((Layout)layout);
        this.tagsTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.tagsTable.setHeaderVisible(true);
        this.tagsTable.setLinesVisible(true);
        int i = 0;
        while (i < COLUMNS_NAMES.length) {
            TableColumn column = new TableColumn(this.tagsTable, 0);
            column.setText(COLUMNS_NAMES[i]);
            ColumnWeightData columnLayoutData = new ColumnWeightData(COLUMNS_WIDTHS[i], true);
            layout.addColumnData((ColumnLayoutData)columnLayoutData);
            ++i;
        }
        this.updateTagsTable();
        this.addButton = new Button(composite, 524288);
        this.addButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.addButton.setText(VpeUIMessages.TemplatesPreferencePage_Add);
        this.editButton = new Button(composite, 524288);
        this.editButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.editButton.setText(VpeUIMessages.TemplatesPreferencePage_Edit);
        this.removeButton = new Button(composite, 524288);
        this.removeButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.removeButton.setText(VpeUIMessages.TemplatesPreferencePage_Remove);
        this.addButton.addListener(24, (Listener)this);
        this.addButton.addListener(13, (Listener)this);
        this.editButton.addListener(24, (Listener)this);
        this.editButton.addListener(13, (Listener)this);
        this.removeButton.addListener(24, (Listener)this);
        this.removeButton.addListener(13, (Listener)this);
        return composite;
    }

    private void updateTagsTable() {
        if (this.tagsTable == null || this.tagsTable.isDisposed()) {
            return;
        }
        int selectionIndex = this.tagsTable.getSelectionIndex();
        this.tagsTable.clearAll();
        this.tagsTable.update();
        TableItem tableItem = null;
        int i = 0;
        while (i < this.tagsList.size()) {
            tableItem = this.tagsTable.getItemCount() > i ? this.tagsTable.getItem(i) : new TableItem(this.tagsTable, 2048, i);
            String[] itemColumnsData = new String[this.tagsTable.getColumnCount()];
            int j = 0;
            while (j < itemColumnsData.length) {
                itemColumnsData[j] = this.toVisualValue(this.getValueAt(i, j));
                ++j;
            }
            tableItem.setText(itemColumnsData);
            ++i;
        }
        if (selectionIndex > 0) {
            try {
                this.tagsTable.setSelection(selectionIndex);
            }
            catch (SWTException sWTException) {}
        }
    }

    public String getValueAt(int row, int column) {
        String result = "List is empty";
        if (this.tagsList != null) {
            VpeAnyData tagItem = this.tagsList.get(row);
            switch (column) {
                case 0: {
                    result = tagItem.getName();
                    break;
                }
                case 1: {
                    result = tagItem.getTagForDisplay();
                    break;
                }
                case 2: {
                    result = tagItem.getUri();
                    break;
                }
                case 3: {
                    result = tagItem.isChildren() ? VpeUIMessages.TemplatesTableProvider_Yes : VpeUIMessages.TemplatesTableProvider_No;
                }
            }
        }
        return result;
    }

    private String toVisualValue(String v) {
        if (v == null) {
            return "";
        }
        if (v.indexOf(10) >= 0) {
            v = v.replace('\n', ' ');
        }
        if (v.indexOf(9) >= 0) {
            v = v.replace('\t', ' ');
        }
        if (v.indexOf(13) >= 0) {
            v = v.replace('\r', ' ');
        }
        return v;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        int selectIndex = this.tagsTable.getSelectionIndex();
        if (source == this.addButton) {
            VpeAnyData data = new VpeAnyData("", "", "");
            VpeEditAnyDialog editDialog = new VpeEditAnyDialog(this.getShell(), data);
            editDialog.open();
            if (data.isChanged()) {
                this.tagsList.add(data);
                this.tagListWasChanged = true;
            }
        } else if (source == this.editButton) {
            if (selectIndex > -1) {
                VpeAnyData data = this.tagsList.get(selectIndex);
                VpeEditAnyDialog editDialog = new VpeEditAnyDialog(this.getShell(), data);
                editDialog.open();
                if (data.isChanged()) {
                    this.tagListWasChanged = true;
                }
            }
        } else if (source == this.removeButton && selectIndex > -1) {
            this.tagsTable.remove(selectIndex);
            this.tagsList.remove(selectIndex);
            this.tagListWasChanged = true;
        }
        this.updateTagsTable();
    }

    public boolean performOk() {
        if (this.tagListWasChanged) {
            VpeTemplateManager.getInstance().setAnyTemplates(this.tagsList);
        }
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    protected void performDefaults() {
        this.tagsList = VpeTemplateManager.getInstance().getAnyTemplates();
        this.updateTagsTable();
    }
}

