/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.mozilla;

import org.jboss.tools.vpe.editor.mozilla.EditorDomEventListener;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDragSession;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsISelectionListener;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsITransferable;
import org.mozilla.xpcom.Mozilla;

class MozillaDomEventListener
implements nsIDOMEventListener,
nsISelectionListener {
    private XulRunnerEditor visualEditor;
    private EditorDomEventListener editorDomEventListener;
    public static final String MOZAFTERPAINT = "MozAfterPaint";
    public static final String SCROLL = "scroll";
    public static final String MOUSEMOVEEVENTTYPE = "mousemove";
    public static final String MOUSEDOWNEVENTTYPE = "mousedown";
    public static final String MOUSEUPEVENTTYPE = "mouseup";
    public static final String CLICKEVENTTYPE = "click";
    public static final String KEYPRESS = "keypress";
    public static final String DBLCLICK = "dblclick";
    public static final String CONTEXTMENUEVENTTYPE = "contextmenu";
    public static final String DRAGGESTUREEVENT = "draggesture";
    public static final String DRAGOVEREVENT = "dragover";
    public static final String DRAGDROPEVENT = "dragdrop";
    public static final String DRAGENTEREVENT = "dragenter";
    public static final String DRAGEXITEVENT = "dragexit";

    MozillaDomEventListener() {
    }

    void setEditorDomEventListener(EditorDomEventListener listener) {
        this.editorDomEventListener = listener;
    }

    private EditorDomEventListener getEditorDomEventListener() {
        return this.editorDomEventListener;
    }

    boolean isXulElement(nsIDOMMouseEvent mouseEvent) {
        return false;
    }

    void setVisualEditor(XulRunnerEditor visualEditor) {
        this.visualEditor = visualEditor;
    }

    public boolean onPasteOrDrop(nsIDOMEvent event, nsITransferable transferable) {
        nsIDragSession dragSession;
        nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)event.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
        if (this.editorDomEventListener != null && !this.isXulElement(mouseEvent) && (dragSession = this.visualEditor.getCurrentDragSession()).isDataFlavorSupported("vpe/model")) {
            this.editorDomEventListener.onPasteOrDrop(mouseEvent, "vpe/model", "");
        }
        mouseEvent.preventDefault();
        mouseEvent.stopPropagation();
        return false;
    }

    public nsISupports queryInterface(String arg0) {
        return Mozilla.queryInterface((nsISupports)this, (String)arg0);
    }

    public void handleEvent(nsIDOMEvent domEvent) {
        if (this.getEditorDomEventListener() != null) {
            String eventType = domEvent.getType();
            if (MOUSEMOVEEVENTTYPE.equals(eventType)) {
                nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)domEvent.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
                this.getEditorDomEventListener().mouseMove(mouseEvent);
            } else if (MOUSEDOWNEVENTTYPE.equals(eventType)) {
                nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)domEvent.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
                this.getEditorDomEventListener().mouseDown(mouseEvent);
            } else if (MOUSEUPEVENTTYPE.equals(eventType)) {
                nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)domEvent.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
                this.getEditorDomEventListener().mouseUp(mouseEvent);
            } else if (CLICKEVENTTYPE.equals(eventType)) {
                nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)domEvent.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
                this.getEditorDomEventListener().mouseClick(mouseEvent);
            } else if (DBLCLICK.equals(eventType)) {
                nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)domEvent.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
                this.getEditorDomEventListener().mouseDblClick(mouseEvent);
            } else if (KEYPRESS.equals(eventType)) {
                nsIDOMKeyEvent keyEvent = (nsIDOMKeyEvent)domEvent.queryInterface("{028e0e6e-8b01-11d3-aae7-0010838a3123}");
                this.getEditorDomEventListener().keyPress(keyEvent);
            } else if (CONTEXTMENUEVENTTYPE.equals(eventType)) {
                this.getEditorDomEventListener().onShowContextMenu(0L, domEvent, (nsIDOMNode)domEvent.getTarget().queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}"));
            } else if (!DRAGGESTUREEVENT.equals(eventType)) {
                if (DRAGDROPEVENT.equals(eventType)) {
                    this.getEditorDomEventListener().dragDrop(domEvent);
                    domEvent.stopPropagation();
                    domEvent.preventDefault();
                } else if (!DRAGENTEREVENT.equals(eventType) && !DRAGEXITEVENT.equals(eventType) && DRAGOVEREVENT.equals(eventType)) {
                    this.getEditorDomEventListener().dragOver(domEvent);
                }
            }
            this.getEditorDomEventListener().onRefresh();
        }
    }

    public void notifySelectionChanged(nsIDOMDocument domDocument, nsISelection selection, short reason) {
        if (this.editorDomEventListener != null) {
            this.editorDomEventListener.notifySelectionChanged(domDocument, selection, reason);
        }
    }
}

