/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.i18n.ILocaleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainLocaleProvider
implements ILocaleProvider {
    private static final String ELEMENT_NATURE = "nature";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ELEMENT_LOCALE_PROVIDER = "localeProvider";
    private Map<String, ? extends List<IExtension>> natureToExtensions;
    private Map<IExtension, ILocaleProvider> extensionToProvider = new HashMap<IExtension, ILocaleProvider>();
    private IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.jboss.tools.vpe.localeProvider");
    private static MainLocaleProvider instance;
    private String localeString = "";

    private MainLocaleProvider() {
        this.initNatureExtensionsMap();
    }

    public static MainLocaleProvider getInstance() {
        if (instance == null) {
            instance = new MainLocaleProvider();
        }
        return instance;
    }

    @Override
    public Locale getLocale(StructuredTextEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)editorInput).getFile().getProject();
            try {
                String[] natures;
                String[] stringArray = natures = project.getDescription().getNatureIds();
                int n = natures.length;
                int n2 = 0;
                while (n2 < n) {
                    String natureId = stringArray[n2];
                    for (ILocaleProvider provider : this.getProviders(natureId)) {
                        Locale locale = provider.getLocale(editor);
                        if (locale == null) continue;
                        this.localeString = provider.getLocaleString();
                        return locale;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                VpePlugin.getPluginLog().logError("CoreException occured.", (Throwable)e);
            }
        }
        return Locale.getDefault();
    }

    private void initNatureExtensionsMap() {
        IExtension[] extensions;
        HashMap<String, ? extends List<IExtension>> natureExtensionsMap = new HashMap<String, List<IExtension>>();
        IExtension[] iExtensionArray = extensions = this.extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (ELEMENT_NATURE.equals(element.getName())) {
                    String natureId = element.getAttribute(ATTRIBUTE_ID);
                    ArrayList<IExtension> extensionList = (ArrayList<IExtension>)natureExtensionsMap.get(natureId);
                    if (extensionList == null) {
                        extensionList = new ArrayList<IExtension>();
                        natureExtensionsMap.put(natureId, extensionList);
                    }
                    extensionList.add(extension);
                }
                ++n4;
            }
            ++n2;
        }
        for (ArrayList configurationsList : natureExtensionsMap.values()) {
            configurationsList.trimToSize();
        }
        this.natureToExtensions = natureExtensionsMap;
    }

    private List<ILocaleProvider> getProviders(String natureId) {
        List<IExtension> extensions = this.natureToExtensions.get(natureId);
        if (extensions == null) {
            return Collections.emptyList();
        }
        ArrayList<ILocaleProvider> providers = new ArrayList<ILocaleProvider>(extensions.size());
        for (IExtension extension : extensions) {
            ILocaleProvider provider = this.extensionToProvider.get(extension);
            if (provider == null) {
                provider = this.createLocaleProvider(extension);
            }
            if (provider == null) continue;
            providers.add(provider);
        }
        return providers;
    }

    private ILocaleProvider createLocaleProvider(IExtension extension) {
        ILocaleProvider provider = null;
        try {
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (ELEMENT_LOCALE_PROVIDER.equals(element.getName())) {
                    provider = (ILocaleProvider)element.createExecutableExtension(ATTRIBUTE_CLASS);
                    this.extensionToProvider.put(extension, provider);
                    break;
                }
                ++n2;
            }
        }
        catch (InvalidRegistryObjectException e) {
            VpePlugin.getPluginLog().logError("The extension registry object is no longer valid.", (Throwable)e);
        }
        catch (CoreException e) {
            VpePlugin.getPluginLog().logError("CoreException occured.", (Throwable)e);
        }
        return provider;
    }

    @Override
    public String getLocaleString() {
        return this.localeString;
    }
}

