/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.jst.jsp.editor.IVisualContext;
import org.jboss.tools.jst.jsp.preferences.VpePreference;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.bundle.BundleMap;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.jboss.tools.vpe.resref.core.AbsoluteFolderReferenceList;
import org.jboss.tools.vpe.resref.core.RelativeFolderReferenceList;
import org.jboss.tools.vpe.resref.core.TaglibReferenceList;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VpePageContext
implements IVisualContext {
    private Set connectorDocuments = new HashSet();
    private BundleMap bundle;
    private Set bundleDependencySet = new HashSet();
    private VpeSourceDomBuilder sourceBuilder;
    private VpeVisualDomBuilder visualBuilder;
    private VpeEditorPart editPart;
    private nsIDOMNode currentVisualNode;
    private Map<String, String> customElementsAttributes;

    public VpePageContext(BundleMap bundle, VpeEditorPart editPart) {
        this.bundle = bundle;
        this.editPart = editPart;
    }

    public VpeSourceDomBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    public boolean isAbsolutePosition() {
        return "yes".equals(VpePreference.USE_ABSOLUTE_POSITION.getValue());
    }

    public void addAttributeInCustomElementsMap(String key, String value) {
        this.getCustomElementsAttributes().put(key, value);
    }

    public void clearCustomElementAttributesMap() {
        this.getCustomElementsAttributes().clear();
    }

    public void setSourceDomBuilder(VpeSourceDomBuilder sourceBuilder) {
        this.sourceBuilder = sourceBuilder;
        this.refreshConnector();
    }

    public void refreshConnector() {
    }

    public VpeVisualDomBuilder getVisualBuilder() {
        return this.visualBuilder;
    }

    public void setVisualDomBuilder(VpeVisualDomBuilder visualBuilder) {
        this.visualBuilder = visualBuilder;
    }

    public VpeDomMapping getDomMapping() {
        return this.visualBuilder.getDomMapping();
    }

    public void clearAll() {
        this.bundleDependencySet.clear();
        this.bundle.clearAll();
    }

    public void dispose() {
        Iterator iterator = this.connectorDocuments.iterator();
        while (iterator.hasNext()) {
            IDocument cfr_ignored_0 = (IDocument)iterator.next();
        }
        this.connectorDocuments.clear();
        this.connectorDocuments = null;
        this.bundle.dispose();
        this.clearAll();
        this.editPart = null;
        this.sourceBuilder = null;
        this.visualBuilder = null;
    }

    public BundleMap getBundle() {
        return this.bundle;
    }

    public void addBundleDependency(Element sourceNode) {
    }

    public void removeBundleDependency(Element sourceNode) {
        this.bundleDependencySet.remove(sourceNode);
    }

    public void refreshBundleValues() {
        if (this.getVisualBuilder() == null) {
            return;
        }
        List nodes = this.getVisualBuilder().getSourceNodes();
        for (Object object : nodes) {
            if (!(object instanceof Element)) continue;
            Element sourceElement = (Element)object;
            this.visualBuilder.refreshBundleValues(sourceElement);
        }
    }

    public boolean isCorrectNS(Node sourceNode) {
        String sourcePrefix = sourceNode.getPrefix();
        if (sourcePrefix == null || ((ElementImpl)sourceNode).isJSPTag()) {
            return true;
        }
        List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(sourceNode, this);
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs);
        return sourceNodeTaglib != null;
    }

    public String getSourceTaglibUri(Node sourceNode) {
        String sourcePrefix = sourceNode.getPrefix();
        if (sourcePrefix == null || ((ElementImpl)sourceNode).isJSPTag()) {
            return null;
        }
        List<TaglibData> taglibs = XmlUtil.getTaglibsForNode(sourceNode, this);
        TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix(sourcePrefix, taglibs);
        if (sourceNodeTaglib == null) {
            return null;
        }
        String sourceNodeUri = sourceNodeTaglib.getUri();
        return sourceNodeUri;
    }

    public VpeEditorPart getEditPart() {
        return this.editPart;
    }

    public List<TaglibData> getIncludeTaglibs() {
        if (this.getEditPart() == null) {
            return new ArrayList<TaglibData>();
        }
        IEditorInput input = this.getEditPart().getEditorInput();
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        ResourceReference[] resourceReferences = new ResourceReference[]{};
        if (file != null) {
            resourceReferences = TaglibReferenceList.getInstance().getAllResources(file);
        }
        ArrayList<TaglibData> taglibData = new ArrayList<TaglibData>();
        ResourceReference[] resourceReferenceArray = resourceReferences;
        int n = resourceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference resourceReference = resourceReferenceArray[n2];
            taglibData.add(new TaglibData(0, resourceReference.getLocation(), resourceReference.getProperties()));
            ++n2;
        }
        return taglibData;
    }

    public ResourceReference getRuntimeRelativeFolder(IFile file) {
        ResourceReference[] list = RelativeFolderReferenceList.getInstance().getAllResources(file);
        if (list.length > 0) {
            return list[list.length - 1];
        }
        return null;
    }

    public ResourceReference getRuntimeAbsoluteFolder(IFile file) {
        ResourceReference[] list = AbsoluteFolderReferenceList.getInstance().getAllResources(file);
        if (list.length > 0) {
            return list[list.length - 1];
        }
        return null;
    }

    public List<TaglibData> getTagLibs(Node sourceNode) {
        return XmlUtil.getTaglibsForNode(sourceNode, this);
    }

    public nsIDOMNode getCurrentVisualNode() {
        return this.currentVisualNode;
    }

    public void setCurrentVisualNode(nsIDOMNode currentVisualNode) {
        this.currentVisualNode = currentVisualNode;
    }

    public void processDisplayEvents() {
        Display display = null;
        display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    public Map<String, String> getCustomElementsAttributes() {
        if (this.customElementsAttributes == null) {
            this.customElementsAttributes = new HashMap<String, String>();
        }
        return this.customElementsAttributes;
    }
}

