/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.ITextSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.sse.ui.internal.view.events.TextSelectionChangedEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.el.core.ELReferenceList;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.editors.dnd.DropCommandFactory;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.DropUtils;
import org.jboss.tools.common.model.ui.editors.dnd.IDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposalFactory;
import org.jboss.tools.common.model.ui.editors.dnd.context.InnerDragBuffer;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTSync;
import org.jboss.tools.common.resref.core.ResourceReferenceListListener;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.editor.IJSPTextEditor;
import org.jboss.tools.jst.jsp.editor.IVisualController;
import org.jboss.tools.jst.jsp.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.jsp.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.jst.jsp.jspeditor.dnd.JSPTagProposalFactory;
import org.jboss.tools.jst.jsp.preferences.VpePreference;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.jst.web.tld.model.TLDUtil;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.dnd.DndUtil;
import org.jboss.tools.vpe.editor.VpeDisposeException;
import org.jboss.tools.vpe.editor.VpeDropWindow;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.VpeEventBean;
import org.jboss.tools.vpe.editor.VpeSelectionBuilder;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.VpeSourceInnerDragInfo;
import org.jboss.tools.vpe.editor.VpeSourceInnerDropInfo;
import org.jboss.tools.vpe.editor.VpeVisualCaretInfo;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.VpeVisualInnerDragInfo;
import org.jboss.tools.vpe.editor.VpeVisualInnerDropInfo;
import org.jboss.tools.vpe.editor.bundle.BundleMap;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.menu.VpeMenuCreator;
import org.jboss.tools.vpe.editor.mozilla.EditorDomEventListener;
import org.jboss.tools.vpe.editor.mozilla.MozillaDropInfo;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.selection.VpeSelectionHelper;
import org.jboss.tools.vpe.editor.template.IKeyEventHandler;
import org.jboss.tools.vpe.editor.template.ISelectionManager;
import org.jboss.tools.vpe.editor.template.IZoomEventManager;
import org.jboss.tools.vpe.editor.template.KeyEventManager;
import org.jboss.tools.vpe.editor.template.SelectionManager;
import org.jboss.tools.vpe.editor.template.VpeIncludeList;
import org.jboss.tools.vpe.editor.template.VpeTemplateListener;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.ZoomEventManager;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.util.DocTypeUtil;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeDndUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.resref.core.AbsoluteFolderReferenceList;
import org.jboss.tools.vpe.resref.core.CSSReferenceList;
import org.jboss.tools.vpe.resref.core.RelativeFolderReferenceList;
import org.jboss.tools.vpe.resref.core.TaglibReferenceList;
import org.jboss.tools.vpe.selbar.SelectionBar;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerVpeUtils;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMMutationEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIFile;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsISupportsCString;
import org.mozilla.interfaces.nsISupportsString;
import org.mozilla.xpcom.Mozilla;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VpeController
implements INodeAdapter,
IModelLifecycleListener,
INodeSelectionListener,
ITextSelectionListener,
SelectionListener,
EditorDomEventListener,
VpeTemplateListener,
XModelTreeListener,
ResourceReferenceListListener,
ISelectionChangedListener,
IVisualController {
    private boolean visualEditorVisible = true;
    private boolean synced = true;
    StructuredTextEditor sourceEditor;
    private MozillaEditor visualEditor;
    XulRunnerEditor xulRunnerEditor;
    private VpeSelectionController visualSelectionController;
    VpeDomMapping domMapping;
    private VpeSourceDomBuilder sourceBuilder;
    private VpeVisualDomBuilder visualBuilder;
    private VpeSelectionBuilder selectionBuilder;
    private ActiveEditorSwitcher switcher = new ActiveEditorSwitcher();
    private Attr lastRemovedAttr;
    private String lastRemovedAttrName;
    private boolean mouseUpSelectionReasonFlag;
    private boolean mouseDownSelectionFlag;
    private boolean sourceChangeFlag;
    private boolean commentNodeChanged;
    private VpePageContext pageContext;
    private BundleMap bundle;
    private VpeEditorPart editPart;
    public static final int LEFT_BUTTON = 0;
    private CSSReferenceList cssReferenceListListener;
    private TaglibReferenceList taglibReferenceListListener;
    private ELReferenceList elReferenceListListener;
    private AbsoluteFolderReferenceList absoluteFolderReferenceListListener;
    private RelativeFolderReferenceList relativeFolderReferenceListListener;
    private VpeIncludeList includeList = new VpeIncludeList();
    private VpeVisualInnerDragInfo innerDragInfo = null;
    private FormatControllerManager toolbarFormatControllerManager = null;
    private SelectionBar selectionBar = null;
    private XModelTreeListenerSWTSync optionsListener;
    private UIJob job = null;
    private UIJob uiJob;
    private UIJob visualRefreshJob;
    private UIJob reinitJob;
    private IZoomEventManager zoomEventManager;
    private LinkedList<VpeEventBean> changeEvents;
    Shell tip;
    private ISelectionManager selectionManager;
    private IKeyEventHandler keyEventHandler;
    public static final String MODEL_FLAVOR = "vpe/model";
    private int vpeUpdateDelayTime;
    VpeDropWindow dropWindow = null;

    public VpeController(VpeEditorPart editPart) {
        this.editPart = editPart;
        this.dropWindow = new VpeDropWindow(editPart.getSite().getShell());
    }

    void init(StructuredTextEditor sourceEditor, MozillaEditor visualEditor) {
        this.sourceEditor = sourceEditor;
        if (sourceEditor instanceof IJSPTextEditor) {
            ((IJSPTextEditor)sourceEditor).setVPEController((IVisualController)this);
            this.dropWindow.setEditor((IJSPTextEditor)sourceEditor);
        }
        this.visualEditor = visualEditor;
        visualEditor.setController(this);
        this.bundle = new BundleMap();
        this.bundle.init(sourceEditor);
        this.pageContext = new VpePageContext(this.bundle, this.editPart);
        this.domMapping = new VpeDomMapping(this.pageContext);
        this.sourceBuilder = new VpeSourceDomBuilder(this.domMapping, this, VpeTemplateManager.getInstance(), sourceEditor, this.pageContext);
        this.visualBuilder = new VpeVisualDomBuilder(this.domMapping, this, visualEditor, this.pageContext);
        this.pageContext.setSourceDomBuilder(this.sourceBuilder);
        this.pageContext.setVisualDomBuilder(this.visualBuilder);
        IDOMModel sourceModel = (IDOMModel)this.getModel();
        if (sourceModel == null) {
            return;
        }
        sourceModel.addModelLifecycleListener((IModelLifecycleListener)this);
        IEditorInput editorInput = this.pageContext.getEditPart().getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            XModel xm = null;
            IProject project = ((IFileEditorInput)editorInput).getFile().getProject();
            IModelNature mn = EclipseResourceUtil.getModelNature((IProject)project);
            if (mn != null) {
                xm = mn.getModel();
            }
            if (xm != null) {
                WebProject.getInstance((XModel)xm).getTaglibMapping().revalidate(WebAppHelper.getWebApp((XModel)xm));
            }
        }
        visualEditor.getEditor();
        IDOMDocument sourceDocument = sourceModel.getDocument();
        this.visualBuilder.buildDom((Document)sourceDocument);
        VpeTemplateManager.getInstance().addTemplateListener(this);
        this.xulRunnerEditor = visualEditor.getXulRunnerEditor();
        this.zoomEventManager = new ZoomEventManager(this.xulRunnerEditor);
        this.visualSelectionController = new VpeSelectionController(visualEditor.getEditor().getSelectionController());
        this.selectionBuilder = new VpeSelectionBuilder(this.domMapping, this.sourceBuilder, this.visualBuilder, this.visualSelectionController);
        this.selectionManager = new SelectionManager(this.pageContext, sourceEditor, this.visualSelectionController);
        this.keyEventHandler = new KeyEventManager(sourceEditor, this.domMapping, this.pageContext);
        ISelectionProvider provider = sourceEditor.getSelectionProvider();
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        StyledText textWidget = VpeSelectionHelper.getSourceTextWidget(sourceEditor);
        if (textWidget != null) {
            textWidget.addSelectionListener((SelectionListener)this);
        }
        visualEditor.setEditorDomEventListener(this);
        this.switcher.initActiveEditor();
        if (this.optionsListener == null) {
            XModelObject optionsObject = ModelUtilities.getPreferenceModel().getByPath(VpePreference.EDITOR_PATH);
            this.optionsListener = new XModelTreeListenerSWTSync((XModelTreeListener)this);
            optionsObject.getModel().addModelTreeListener((XModelTreeListener)this.optionsListener);
        }
        this.cssReferenceListListener = CSSReferenceList.getInstance();
        this.cssReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.taglibReferenceListListener = TaglibReferenceList.getInstance();
        this.taglibReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.absoluteFolderReferenceListListener = AbsoluteFolderReferenceList.getInstance();
        this.absoluteFolderReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.relativeFolderReferenceListListener = RelativeFolderReferenceList.getInstance();
        this.relativeFolderReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.elReferenceListListener = ELReferenceList.getInstance();
        this.elReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.vpeUpdateDelayTime = 400;
        this.sourceSelectionChanged(true);
    }

    public void dispose() {
        IDOMModel sourceModel;
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        if (this.uiJob != null) {
            this.uiJob.cancel();
            this.getChangeEvents().clear();
            this.uiJob = null;
        }
        if (this.visualRefreshJob != null) {
            this.visualRefreshJob.cancel();
            this.visualRefreshJob = null;
        }
        if (this.optionsListener != null) {
            XModelObject optionsObject = ModelUtilities.getPreferenceModel().getByPath(VpePreference.EDITOR_PATH);
            optionsObject.getModel().removeModelTreeListener((XModelTreeListener)this.optionsListener);
            this.optionsListener.dispose();
            this.optionsListener = null;
        }
        if ((sourceModel = (IDOMModel)this.getModel()) != null) {
            sourceModel.removeModelLifecycleListener((IModelLifecycleListener)this);
        }
        this.switcher.destroyActiveEditor();
        this.switcher = null;
        VpeTemplateManager.getInstance().removeTemplateListener(this);
        if (this.visualBuilder != null) {
            this.visualBuilder.dispose();
            this.visualBuilder = null;
        }
        this.sourceBuilder = null;
        if (this.sourceEditor != null) {
            ISelectionProvider provider = this.sourceEditor.getSelectionProvider();
            provider.removeSelectionChangedListener((ISelectionChangedListener)this);
            StyledText textWidget = VpeSelectionHelper.getSourceTextWidget(this.sourceEditor);
            if (textWidget != null) {
                textWidget.removeSelectionListener((SelectionListener)this);
            }
            ((IJSPTextEditor)this.sourceEditor).setVPEController(null);
        }
        if (this.dropWindow != null) {
            this.dropWindow.setEditor(null);
        }
        if (this.visualEditor != null) {
            this.visualEditor.setEditorDomEventListener(null);
            if (this.visualSelectionController != null) {
                this.visualSelectionController = null;
            }
            this.visualEditor = null;
        }
        if (this.cssReferenceListListener != null) {
            this.cssReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        if (this.taglibReferenceListListener != null) {
            this.taglibReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        if (this.absoluteFolderReferenceListListener != null) {
            this.absoluteFolderReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        if (this.elReferenceListListener != null) {
            this.elReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        if (this.relativeFolderReferenceListListener != null) {
            this.relativeFolderReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        this.toolbarFormatControllerManager = null;
    }

    public boolean isAdapterForType(Object type) {
        return type == this;
    }

    public void notifyChanged(final INodeNotifier notifier, final int eventType, final Object feature, final Object oldValue, final Object newValue, final int pos) {
        if (!this.isVisualEditorVisible()) {
            this.setSynced(false);
            return;
        }
        Display display = null;
        if (PlatformUI.isWorkbenchRunning()) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        if (display != null && Thread.currentThread() == display.getThread()) {
            this.getChangeEvents().addLast(new VpeEventBean(notifier, eventType, feature, oldValue, newValue, pos));
            if (this.uiJob == null) {
                this.uiJob = new UIJob(VpeUIMessages.VPE_UPDATE_JOB_TITLE){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        monitor.beginTask(VpeUIMessages.VPE_UPDATE_JOB_TITLE, 100);
                        while (VpeController.this.getChangeEvents().size() > 0) {
                            monitor.worked(100 / VpeController.this.getChangeEvents().size());
                            VpeEventBean eventBean = VpeController.this.getChangeEvents().getFirst();
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            try {
                                VpeController.this.notifyChangedInUiThread(eventBean.getNotifier(), eventBean.getEventType(), eventBean.getFeature(), eventBean.getOldValue(), eventBean.getNewValue(), eventBean.getPos());
                            }
                            catch (VpeDisposeException vpeDisposeException) {
                                break;
                            }
                            catch (NullPointerException ex) {
                                if (VpeController.this.switcher != null) {
                                    throw ex;
                                }
                            }
                            catch (Exception ex) {
                                VpePlugin.getPluginLog().logError((Throwable)ex);
                            }
                            VpeController.this.getChangeEvents().remove(eventBean);
                        }
                        if (VpeController.this.switcher != null && VpeController.this.switcher.startActiveEditor(2)) {
                            try {
                                VpeController.this.sourceSelectionChanged();
                                if (VpeController.this.toolbarFormatControllerManager != null) {
                                    VpeController.this.toolbarFormatControllerManager.selectionChanged();
                                }
                            }
                            finally {
                                VpeController.this.switcher.stopActiveEditor();
                            }
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
            }
            if (this.uiJob.getState() != 4) {
                this.uiJob.setPriority(30);
                this.uiJob.schedule((long)this.getVpeUpdateDelayTime());
            } else {
                this.uiJob.cancel();
                this.uiJob.schedule((long)this.getVpeUpdateDelayTime());
                this.setVpeUpdateDelayTime(400);
            }
            return;
        }
        if (this.job != null) {
            this.job.cancel();
        }
        this.job = new UIJob("NotifyChangedJob"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                VpeController.this.notifyChangedInUiThread(notifier, eventType, feature, oldValue, newValue, pos);
                return Status.OK_STATUS;
            }
        };
        this.job.setPriority(30);
        this.job.schedule(1000L);
    }

    public void notifyChangedInUiThread(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int pos) {
        if (this.switcher == null || !this.switcher.startActiveEditor(2)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_SOURCE_MUTATION_EVENT) {
                this.printSourceEvent(notifier, eventType, feature, oldValue, newValue, pos);
            }
            if (this.visualBuilder == null) {
                return;
            }
            switch (eventType) {
                case 1: {
                    this.sourceChangeFlag = true;
                    short type = ((Node)notifier).getNodeType();
                    this.visualEditor.hideResizer();
                    this.visualBuilder.setSelectionRectangle(null);
                    if (type == 3) {
                        boolean update = this.visualBuilder.setText((Node)notifier);
                        this.visualEditor.showResizer();
                        if (!update) {
                            this.visualBuilder.updateNode((Node)notifier);
                        }
                    } else if (type == 8) {
                        if ("yes".equals(VpePreference.SHOW_COMMENTS.getValue())) {
                            this.visualBuilder.setSelectionRectangle(null);
                            this.visualBuilder.updateNode((Node)notifier);
                        }
                    } else if (feature != null && ((Node)feature).getNodeType() == 2) {
                        if (newValue != null) {
                            String attrName = ((Attr)feature).getName();
                            if ((Attr)feature == this.lastRemovedAttr && !attrName.equals(this.lastRemovedAttrName)) {
                                this.lastRemovedAttr = null;
                                this.visualBuilder.removeAttribute((Element)notifier, this.lastRemovedAttrName);
                            }
                            this.visualBuilder.setAttribute((Element)notifier, ((Attr)feature).getName(), (String)newValue);
                        } else {
                            this.lastRemovedAttr = (Attr)feature;
                            this.lastRemovedAttrName = ((Attr)feature).getName();
                            this.visualBuilder.removeAttribute((Element)notifier, this.lastRemovedAttrName);
                        }
                    }
                    this.visualEditor.showResizer();
                    break;
                }
                case 2: {
                    if (newValue instanceof Node && 8 != ((Node)newValue).getNodeType()) {
                        this.visualBuilder.removeNode((Node)newValue);
                    }
                    break;
                }
                case 3: {
                    if (8 == ((Node)feature).getNodeType()) {
                        this.visualBuilder.updateNode((Node)feature);
                        this.commentNodeChanged = true;
                        break;
                    }
                    this.visualBuilder.stopToggle((Node)feature);
                    this.visualBuilder.removeNode((Node)feature);
                    break;
                }
                case 4: {
                    if (!this.commentNodeChanged) {
                        this.visualEditor.hideResizer();
                        this.visualBuilder.setSelectionRectangle(null);
                        this.visualBuilder.updateNode((Node)notifier);
                        break;
                    }
                    this.commentNodeChanged = false;
                    break;
                }
                case 5: {
                    if (!this.sourceChangeFlag) {
                        if (feature != null && ((Node)feature).getNodeType() == 3) {
                            this.visualEditor.hideResizer();
                            this.visualBuilder.setSelectionRectangle(null);
                            this.visualBuilder.setText((Node)feature);
                            this.visualEditor.showResizer();
                        }
                        break;
                    }
                    this.sourceChangeFlag = false;
                }
            }
        }
        finally {
            if (this.switcher == null) {
                throw new VpeDisposeException("VpeController already disposed");
            }
            this.switcher.stopActiveEditor();
        }
    }

    public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
        if (!this.switcher.startActiveEditor(2)) {
            return;
        }
        try {
            List nodes = event.getSelectedNodes();
            if (nodes != null && nodes.size() > 0) {
                Node sourceNode = (Node)nodes.get(0);
                if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                    System.out.println(">>>>>>>>>>>>>> nodeSelectionChanged  sourceNode: " + sourceNode.getNodeName() + " " + event.getCaretPosition());
                }
                if (event.getSource() instanceof IContentOutlinePage) {
                    this.sourceSelectionChanged();
                }
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    public void textSelectionChanged(TextSelectionChangedEvent event) {
        if (!this.switcher.startActiveEditor(2)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                System.out.println(">>>>>>>>>>>>>> textSelectionChanged  " + event.getSource());
            }
            this.sourceSelectionChanged();
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (!this.switcher.startActiveEditor(2)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                System.out.println(">>>>>>>>>>>>>> widgetSelected");
            }
            if (event.getSource() instanceof StyledText) {
                this.sourceSelectionChanged();
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
            System.out.println(">>>>>>>>>>>>>> widgetDefaultSelected");
        }
    }

    public void sourceSelectionChanged() {
        this.sourceSelectionChanged(false);
    }

    public void sourceSelectionChanged(boolean showCaret) {
        if (this.getChangeEvents().size() > 0) {
            return;
        }
        if (this.selectionManager != null) {
            this.selectionManager.refreshVisualSelection();
        }
    }

    public void sourceSelectionToVisualSelection(boolean showCaret) {
        if (!this.switcher.startActiveEditor(2)) {
            return;
        }
        try {
            this.sourceSelectionChanged(showCaret);
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    public void processPreModelEvent(ModelLifecycleEvent event) {
    }

    public void processPostModelEvent(ModelLifecycleEvent event) {
        if (this.switcher == null || !this.switcher.startActiveEditor(2)) {
            return;
        }
        try {
            if (event.getType() == 2) {
                if (VpeDebug.PRINT_SOURCE_MODEL_LIFECYCLE_EVENT) {
                    System.out.println(">>> processPostModelEvent: " + event.toString());
                }
                IStructuredModel model = event.getModel();
                model.removeModelLifecycleListener((IModelLifecycleListener)this);
                IDOMModel sourceModel = (IDOMModel)this.getModel();
                sourceModel.addModelLifecycleListener((IModelLifecycleListener)this);
                this.bundle.clearAll();
                this.bundle.refresh();
                sourceModel.getDocument();
            }
        }
        finally {
            if (this.switcher != null) {
                this.switcher.stopActiveEditor();
            }
        }
    }

    @Override
    public void subtreeModified(nsIDOMMutationEvent mutationEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_VISUAL_MUTATION_EVENT) {
                this.printVisualEvent((nsIDOMEvent)mutationEvent);
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void nodeInserted(nsIDOMMutationEvent mutationEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            nsIDOMNode targetNode;
            if (VpeDebug.PRINT_VISUAL_MUTATION_EVENT) {
                this.printVisualEvent((nsIDOMEvent)mutationEvent);
            }
            if (!VpeVisualDomBuilder.isAnonElement(targetNode = mutationEvent.getRelatedNode())) {
                this.sourceBuilder.addNode(targetNode);
                this.visualBuilder.resetPseudoElement(targetNode);
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void nodeRemoved(nsIDOMMutationEvent mutationEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            nsIDOMNode targetNode;
            if (VpeDebug.PRINT_VISUAL_MUTATION_EVENT) {
                this.printVisualEvent((nsIDOMEvent)mutationEvent);
            }
            if (!VpeVisualDomBuilder.isAnonElement(targetNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mutationEvent))) {
                this.visualBuilder.setSelectionRectangle(null);
                this.sourceBuilder.removeNode(targetNode);
                this.visualBuilder.resetPseudoElement(targetNode);
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void nodeRemovedFromDocument(nsIDOMMutationEvent mutationEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_VISUAL_MUTATION_EVENT) {
                this.printVisualEvent((nsIDOMEvent)mutationEvent);
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void nodeInsertedIntoDocument(nsIDOMMutationEvent mutationEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_VISUAL_MUTATION_EVENT) {
                this.printVisualEvent((nsIDOMEvent)mutationEvent);
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void attrModified(nsIDOMMutationEvent mutationEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_VISUAL_MUTATION_EVENT) {
                this.printVisualEvent((nsIDOMEvent)mutationEvent);
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void characterDataModified(nsIDOMMutationEvent mutationEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_VISUAL_MUTATION_EVENT) {
                this.printVisualEvent((nsIDOMEvent)mutationEvent);
            }
            nsIDOMNode targetNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mutationEvent);
            this.sourceBuilder.setText(targetNode);
            this.visualBuilder.resetPseudoElement(targetNode);
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void notifySelectionChanged(nsIDOMDocument doc, nsISelection selection, short reason) {
        if (this.switcher.startActiveEditor(3)) {
            try {
                boolean bl = this.mouseUpSelectionReasonFlag = (reason & 4) > 0;
                if (reason == 8 || reason == 16 || (reason & 2) == 2) {
                    nsIDOMNode node;
                    if (VpeDebug.PRINT_VISUAL_SELECTION_EVENT) {
                        System.out.println("<<< notifySelectionChanged: " + reason);
                    }
                    if ((node = SelectionUtil.getSelectedNode(selection)) != null) {
                        this.selectionManager.setSelection(selection);
                    }
                }
                this.visualSelectionController.setCaretEnabled(true);
            }
            finally {
                this.switcher.stopActiveEditor();
            }
        }
    }

    @Override
    public void mouseDown(nsIDOMMouseEvent mouseEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_VISUAL_MOUSE_EVENT) {
                System.out.println("<<< mouseDown  targetNode: ");
            }
            if (mouseEvent.getButton() == 0) {
                nsIDOMElement selectedElement = this.getXulRunnerEditor().getLastSelectedElement();
                if (selectedElement != null && VpeVisualDomBuilder.inDragArea(XulRunnerVpeUtils.getElementBounds((nsIDOMNode)selectedElement), VisualDomUtil.getMousePoint(mouseEvent))) {
                    this.dragGesture((nsIDOMEvent)mouseEvent);
                } else {
                    this.selectionManager.setSelection(mouseEvent);
                }
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void mouseUp(nsIDOMMouseEvent mouseEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_VISUAL_MOUSE_EVENT) {
                System.out.println("<<< mouseUp");
            }
            if (this.mouseDownSelectionFlag) {
                mouseEvent.preventDefault();
                mouseEvent.stopPropagation();
                this.mouseDownSelectionFlag = false;
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void mouseClick(nsIDOMMouseEvent mouseEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            nsIDOMNode visualNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mouseEvent);
            if (visualNode != null) {
                if (!this.mouseUpSelectionReasonFlag) {
                    if (VpeDebug.PRINT_VISUAL_MOUSE_EVENT) {
                        System.out.println("<<< mouseClick  visualNode: " + visualNode.getNodeName() + " (" + visualNode + ")");
                    }
                    this.visualBuilder.isContentArea(visualNode);
                } else {
                    this.mouseUpSelectionReasonFlag = false;
                }
                this.visualBuilder.doToggle(VisualDomUtil.getTargetNode((nsIDOMEvent)mouseEvent));
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void mouseDblClick(nsIDOMMouseEvent mouseEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            nsIDOMNode visualNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mouseEvent);
            if (visualNode != null) {
                this.sourceBuilder.openOn(visualNode);
                if (VpeDebug.PRINT_VISUAL_MOUSE_EVENT) {
                    System.out.println("<<< mouseDblClick  visualNode: " + visualNode.getNodeName() + " (" + visualNode + ")");
                }
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void mouseMove(nsIDOMMouseEvent mouseEvent) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            nsIDOMNode visualNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mouseEvent);
            if (visualNode != null) {
                this.visualBuilder.setMoveCursor(mouseEvent);
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void keyPress(nsIDOMKeyEvent keyEvent) {
        boolean isHandleCurrentEvent;
        if (VpeDebug.PRINT_VISUAL_KEY_EVENT) {
            System.out.println("<<< keyPress  type: " + keyEvent.getType() + "  Ctrl: " + keyEvent.getCtrlKey() + "  Shift: " + keyEvent.getShiftKey() + "  CharCode: " + keyEvent.getCharCode() + "  KeyCode: " + keyEvent.getKeyCode());
        }
        if (!this.switcher.startActiveEditor(3)) {
            this.switcher.stopActiveEditor();
            return;
        }
        try {
            this.visualEditor.hideResizer();
        }
        finally {
            this.switcher.stopActiveEditor();
        }
        this.setVpeUpdateDelayTime(0);
        boolean keyBindingPressed = false;
        Event keyboardEvent = new Event();
        keyboardEvent.widget = this.xulRunnerEditor.getBrowser();
        keyboardEvent.stateMask = (keyEvent.getAltKey() ? 65536 : 0) | (keyEvent.getCtrlKey() ? 262144 : 0) | (keyEvent.getShiftKey() ? 131072 : 0) | (keyEvent.getMetaKey() ? SWT.MOD1 : 0);
        keyboardEvent.x = 0;
        keyboardEvent.y = 0;
        keyboardEvent.type = 1;
        keyboardEvent.keyCode = keyEvent.getKeyCode() == 0L ? (int)keyEvent.getCharCode() : (int)keyEvent.getKeyCode();
        List possibleKeyStrokes = WorkbenchKeyboard.generatePossibleKeyStrokes((Event)keyboardEvent);
        IWorkbench iWorkbench = VpePlugin.getDefault().getWorkbench();
        if (iWorkbench.hasService(IBindingService.class)) {
            IBindingService iBindingService = (IBindingService)iWorkbench.getService(IBindingService.class);
            KeySequence sequenceBeforeKeyStroke = KeySequence.getInstance();
            Iterator iterator = possibleKeyStrokes.iterator();
            while (iterator.hasNext()) {
                Binding binding;
                KeySequence sequenceAfterKeyStroke = KeySequence.getInstance((KeySequence)sequenceBeforeKeyStroke, (KeyStroke)((KeyStroke)iterator.next()));
                if (!iBindingService.isPerfectMatch((TriggerSequence)sequenceAfterKeyStroke) || (binding = iBindingService.getPerfectMatch((TriggerSequence)sequenceAfterKeyStroke)) == null || binding.getParameterizedCommand() == null || binding.getParameterizedCommand().getCommand() == null) continue;
                keyBindingPressed = true;
            }
        }
        boolean bl = isHandleCurrentEvent = !keyBindingPressed || this.isZoomEvent(keyEvent);
        if (isHandleCurrentEvent) {
            IZoomEventManager zoomEventManager;
            if (this.keyEventHandler instanceof KeyEventManager && (zoomEventManager = ((KeyEventManager)this.keyEventHandler).getZoomEventManager()) == null) {
                this.zoomEventManager = new ZoomEventManager(this.getXulRunnerEditor());
                ((KeyEventManager)this.keyEventHandler).setZoomEventManager(this.zoomEventManager);
            }
            if (this.keyEventHandler.handleKeyPress(keyEvent)) {
                keyEvent.preventDefault();
            }
        }
    }

    private boolean isZoomEvent(nsIDOMKeyEvent keyEvent) {
        return keyEvent.getCtrlKey() && (keyEvent.getCharCode() == 61L || keyEvent.getCharCode() == 45L || keyEvent.getCharCode() == 48L);
    }

    @Override
    public void elementResized(nsIDOMElement element, int constrains, int top, int left, int width, int height) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            this.visualEditor.hideResizer();
        }
        finally {
            this.switcher.stopActiveEditor();
        }
        this.visualBuilder.resize(element, constrains, top, left, width, height);
        this.sourceSelectionChanged();
    }

    @Override
    public void dragGesture(nsIDOMEvent domEvent) {
        nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)domEvent.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
        boolean canDragFlag = this.canInnerDrag(mouseEvent);
        if (canDragFlag) {
            this.startDragSession(domEvent);
        }
    }

    public void onShowContextMenu(long contextFlags, nsIDOMEvent event, nsIDOMNode node) {
        Node selectedSourceNode = null;
        VpeNodeMapping nodeMapping = SelectionUtil.getNodeMappingBySourceSelection(this.sourceEditor, this.domMapping);
        if (nodeMapping != null) {
            selectedSourceNode = nodeMapping.getSourceNode();
        }
        MenuManager menuManager = new MenuManager("#popup");
        Menu contextMenu = menuManager.createContextMenu(this.visualEditor.getControl());
        contextMenu.addMenuListener(new MenuListener(contextMenu){
            Menu menu;
            {
                this.menu = menu;
            }

            public void menuHidden(MenuEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        menu.dispose();
                    }
                });
            }

            public void menuShown(MenuEvent e) {
            }
        });
        new VpeMenuCreator(menuManager, selectedSourceNode).createMenu();
        contextMenu.setVisible(true);
    }

    @Override
    public void templateReloaded() {
        this.visualRefresh();
    }

    public void visualRefresh() {
        if (!this.isVisualEditorVisible()) {
            this.setSynced(false);
            return;
        }
        if (this.uiJob != null && this.uiJob.getState() != 0) {
            return;
        }
        if (this.visualRefreshJob == null || this.visualRefreshJob.getState() == 0) {
            this.visualRefreshJob = new UIJob(VpeUIMessages.VPE_VISUAL_REFRESH_JOB){

                /*
                 * Loose catch block
                 */
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!VpeController.this.switcher.startActiveEditor(2)) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        try {
                            monitor.beginTask(VpeUIMessages.VPE_VISUAL_REFRESH_JOB, -1);
                            VpeController.this.visualRefreshImpl();
                            monitor.done();
                            VpeController.this.setSynced(true);
                        }
                        catch (VpeDisposeException vpeDisposeException) {
                            if (VpeController.this.switcher != null) {
                                VpeController.this.switcher.stopActiveEditor();
                            }
                        }
                        catch (NullPointerException ex) {
                            block16: {
                                if (VpeController.this.switcher == null) break block16;
                                throw ex;
                            }
                            if (VpeController.this.switcher != null) {
                                VpeController.this.switcher.stopActiveEditor();
                            }
                        }
                        catch (Exception ex) {
                            VpePlugin.getPluginLog().logError((Throwable)ex);
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            if (VpeController.this.switcher != null) {
                                VpeController.this.switcher.stopActiveEditor();
                            }
                        }
                    }
                    finally {
                        if (VpeController.this.switcher != null) {
                            VpeController.this.switcher.stopActiveEditor();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.visualRefreshJob.setPriority(20);
            this.visualRefreshJob.schedule();
        }
    }

    void visualRefreshImpl() {
        this.visualEditor.hideResizer();
        String currentDoctype = DocTypeUtil.getDoctype(this.visualEditor.getEditorInput());
        String visualEditorDoctype = this.visualEditor.getDoctype();
        if (currentDoctype != null && visualEditorDoctype != null && !visualEditorDoctype.equals(currentDoctype)) {
            this.visualEditor.reload();
        } else {
            this.visualBuilder.setSelectionRectangle(null);
            this.visualEditor.reload();
        }
    }

    public void preLongOperation() {
        this.switcher.startActiveEditor(3);
    }

    public void postLongOperation() {
        this.switcher.stopActiveEditor();
        this.visualRefresh();
    }

    private void printSourceEvent(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int pos) {
        System.out.println(">>> eventType: " + INodeNotifier.EVENT_TYPE_STRINGS[eventType] + "  pos: " + pos + "  notifier: " + ((Node)notifier).getNodeName() + "  hashCode: " + notifier.hashCode());
        if (feature != null) {
            if (feature instanceof Node) {
                System.out.println("     feature: " + ((Node)feature).getNodeType() + " " + ((Node)feature).getNodeName() + "  hashCode: " + feature.hashCode());
            } else {
                System.out.println("     feature: " + feature);
            }
        }
        if (oldValue != null) {
            if (oldValue instanceof Node) {
                System.out.println("     oldValue: " + ((Node)oldValue).getNodeName() + "  hashCode: " + oldValue.hashCode());
            } else {
                System.out.println("     oldValue: " + oldValue);
            }
        }
        if (newValue != null) {
            if (newValue instanceof Node) {
                System.out.println("     newValue: " + ((Node)newValue).getNodeName() + "  hashCode: " + newValue.hashCode() + " " + ((Node)newValue).getNodeType());
            } else {
                System.out.println("     newValue: " + newValue);
            }
        }
    }

    private void printVisualEvent(nsIDOMEvent event) {
        System.out.print("<<< " + event.getType());
        if (event instanceof nsIDOMMutationEvent) {
            nsIDOMMutationEvent mutationEvent = (nsIDOMMutationEvent)event;
            System.out.print("  EventPhase: " + mutationEvent.getEventPhase());
            nsIDOMNode relatedNode = mutationEvent.getRelatedNode();
            System.out.print("  RelatedNode: " + (relatedNode == null ? null : relatedNode.getNodeName()));
            nsIDOMNode targetNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mutationEvent);
            String name = targetNode != null ? targetNode.getNodeName() : null;
            System.out.print("  TargetNode: " + name + " (" + targetNode + ")");
            System.out.print("  PrevValue: " + mutationEvent.getPrevValue().trim());
            System.out.print("  NewValue: " + mutationEvent.getNewValue().trim());
        }
        System.out.println();
    }

    void refreshTemplates() {
        if (this.includeList.includesRefresh()) {
            this.visualRefresh();
        }
        VpeTemplateManager.getInstance().reload();
        if (this.bundle != null) {
            this.bundle.refresh();
            if (this.pageContext != null) {
                if (!this.switcher.startActiveEditor(2)) {
                    return;
                }
                try {
                    this.pageContext.refreshBundleValues();
                }
                finally {
                    this.switcher.stopActiveEditor();
                }
            }
        }
    }

    public void nodeChanged(XModelTreeEvent event) {
        this.visualRefresh();
    }

    public void structureChanged(XModelTreeEvent event) {
    }

    public void refreshExternalLinks() {
        this.pageContext.getVisualBuilder().refreshExternalLinks();
    }

    public IPath getPath() {
        IEditorInput input;
        if (this.editPart != null && (input = this.editPart.getEditorInput()) != null && input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getFullPath();
        }
        return null;
    }

    public void changed(Object source) {
        if (this.cssReferenceListListener == source) {
            this.pageContext.getVisualBuilder().refreshExternalLinks();
        } else if (this.absoluteFolderReferenceListListener == source || this.relativeFolderReferenceListListener == source || this.taglibReferenceListListener == source || this.elReferenceListListener == source) {
            this.visualRefresh();
        }
    }

    @Override
    public void dragEnter(nsIDOMEvent event) {
        if (VpeDebug.PRINT_VISUAL_DRAGDROP_EVENT) {
            System.out.println("<<<<<<<<<<<<<<<<<<<< DragEnter");
        }
    }

    @Override
    public void dragExit(nsIDOMEvent event) {
        if (VpeDebug.PRINT_VISUAL_DRAGDROP_EVENT) {
            System.out.println("<<<<<<<<<<<<<<<<<<<< dragExit");
        }
    }

    @Override
    public void dragOver(nsIDOMEvent event) {
        this.visualBuilder.getDnd().dragOver(event, this);
    }

    public void _dragOver(nsIDOMEvent event) {
        if (!this.switcher.startActiveEditor(3)) {
            return;
        }
        try {
            boolean canDrop;
            if (VpeDebug.PRINT_VISUAL_DRAGDROP_EVENT) {
                System.out.println("<<<<<<<<<<<<<<<<<<<< dragOver");
            }
            boolean bl = canDrop = !this.xulRunnerEditor.isMozillaDragFlavor();
            if (canDrop) {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                boolean bl2 = canDrop = clipboard.getContents((Transfer)ModelTransfer.getInstance()) != null;
            }
            if (canDrop) {
                canDrop = VpeDndUtil.isDropEnabled((IModelObjectEditorInput)this.sourceEditor.getEditorInput());
            }
            if (canDrop) {
                VpeVisualCaretInfo caretInfo = this.selectionBuilder.getVisualCaretInfo(event);
                canDrop = caretInfo.exist();
                if (canDrop) {
                    caretInfo.showCaret();
                } else {
                    caretInfo.hideCaret();
                }
            }
            if (!canDrop) {
                event.stopPropagation();
                event.preventDefault();
            }
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void drop(nsIDOMEvent event) {
        if (VpeDebug.PRINT_VISUAL_DRAGDROP_EVENT) {
            System.out.println("<<< outerDrop");
        }
        event.preventDefault();
    }

    @Override
    public boolean canInnerDrag(nsIDOMMouseEvent event) {
        this.onHideTooltip();
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.print("<<<<<< canInnerDrag");
        }
        if (this.innerDragInfo != null) {
            this.innerDragInfo.release();
            this.innerDragInfo = null;
        }
        boolean canDrag = false;
        VpeVisualInnerDragInfo dragInfo = this.selectionBuilder.getInnerDragInfo(event);
        if (dragInfo != null) {
            nsIDOMNode dragNode = dragInfo.getNode();
            if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
                System.out.print(" dragNode: " + dragNode.getNodeName() + "(" + dragNode + ")");
            }
            switch (dragNode.getNodeType()) {
                case 1: {
                    canDrag = this.visualBuilder.canInnerDrag((nsIDOMElement)dragNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"));
                    break;
                }
                case 3: {
                    canDrag = this.visualBuilder.isTextEditable(dragNode);
                }
            }
            if (canDrag) {
                VpeSourceInnerDragInfo sourceInnerDragInfo = this.visualBuilder.getSourceInnerDragInfo(dragInfo);
                if (sourceInnerDragInfo.getNode() != null) {
                    this.innerDragInfo = dragInfo;
                    InnerDragBuffer.object = sourceInnerDragInfo.getNode();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            InnerDragBuffer.object = null;
                        }
                    });
                } else {
                    canDrag = false;
                }
            }
            if (!canDrag) {
                dragInfo.release();
            }
        }
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.println("  canDrag: " + canDrag);
        }
        return canDrag;
    }

    @Override
    public MozillaDropInfo canInnerDrop(nsIDOMMouseEvent event) {
        nsIDOMNode visualNode;
        Node sourceNode;
        this.onHideTooltip();
        if (this.dropWindow.active) {
            if (!event.getAltKey()) {
                this.dropWindow.close();
            } else {
                return null;
            }
        }
        if (event.getAltKey() && (sourceNode = this.domMapping.getNearSourceNode(visualNode = VisualDomUtil.getTargetNode((nsIDOMEvent)event))) != null) {
            this.dropWindow.active = true;
            this.dropWindow.setEventPosition(event.getScreenX(), event.getScreenY());
            this.dropWindow.setInitialTargetNode(sourceNode);
            this.dropWindow.open();
            event.stopPropagation();
            event.preventDefault();
            return null;
        }
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.print("<<<<<< canInnerDrop");
        }
        boolean canDrop = false;
        nsIDOMNode caretParent = null;
        long caretOffset = 0L;
        if (this.innerDragInfo != null) {
            VpeVisualInnerDropInfo visualDropInfo = this.selectionBuilder.getInnerDropInfo((nsIDOMEvent)event);
            if (visualDropInfo.getDropContainer() != null) {
                VpeVisualInnerDropInfo newVisualDropInfo;
                VpeSourceInnerDragInfo sourceInnerDragInfo;
                VpeSourceInnerDropInfo sourceDropInfo;
                if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
                    System.out.print("  x: " + visualDropInfo.getMouseX() + "  y: " + visualDropInfo.getMouseY() + "  container: " + visualDropInfo.getDropContainer().getNodeName() + "(" + visualDropInfo.getDropContainer() + ")  parent: " + visualDropInfo.getDropContainer().getParentNode().getNodeName() + "(" + visualDropInfo.getDropContainer().getParentNode() + ")  offset: " + visualDropInfo.getDropOffset());
                }
                if ((canDrop = (sourceDropInfo = this.visualBuilder.getSourceInnerDropInfo((sourceInnerDragInfo = this.visualBuilder.getSourceInnerDragInfo(this.innerDragInfo)).getNode(), visualDropInfo, true)).canDrop()) && (newVisualDropInfo = this.visualBuilder.getInnerDropInfo(sourceDropInfo.getContainer(), sourceDropInfo.getOffset())) != null) {
                    this.visualBuilder.correctVisualDropPosition(newVisualDropInfo, visualDropInfo);
                    caretParent = newVisualDropInfo.getDropContainer();
                    caretOffset = newVisualDropInfo.getDropOffset();
                }
            }
            visualDropInfo.release();
        }
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.println("  canDrop: " + canDrop);
        }
        return new MozillaDropInfo(canDrop, caretParent, caretOffset);
    }

    @Override
    public void innerDrop(nsIDOMMouseEvent event) {
        VpeVisualInnerDropInfo visualDropInfo;
        this.onHideTooltip();
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.print("<<<<<< innerDrop");
        }
        if (this.innerDragInfo != null && (visualDropInfo = this.selectionBuilder.getInnerDropInfo((nsIDOMEvent)event)).getDropContainer() != null) {
            VpeVisualInnerDropInfo newVisualDropInfo;
            VpeSourceInnerDragInfo sourceInnerDragInfo;
            VpeSourceInnerDropInfo sourceDropInfo;
            if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
                System.out.print("  container: " + visualDropInfo.getDropContainer().getNodeName() + "(" + visualDropInfo.getDropContainer() + ")" + "  offset: " + visualDropInfo.getDropOffset());
            }
            if ((sourceDropInfo = this.visualBuilder.getSourceInnerDropInfo((sourceInnerDragInfo = this.visualBuilder.getSourceInnerDragInfo(this.innerDragInfo)).getNode(), visualDropInfo, true)).canDrop() && (newVisualDropInfo = this.visualBuilder.getInnerDropInfo(sourceDropInfo.getContainer(), sourceDropInfo.getOffset())) != null) {
                this.visualBuilder.correctVisualDropPosition(newVisualDropInfo, visualDropInfo);
                sourceDropInfo.setTop(visualDropInfo.getMouseY());
                sourceDropInfo.setLeft(visualDropInfo.getMouseX());
                this.visualBuilder.innerDrop(sourceInnerDragInfo, sourceDropInfo);
                if (this.innerDragInfo != null) {
                    this.innerDragInfo.release();
                    this.innerDragInfo = null;
                }
            }
        }
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.println();
        }
    }

    @Override
    public MozillaDropInfo canExternalDrop(nsIDOMMouseEvent mouseEvent, String flavor, String data) {
        nsIDOMEvent event;
        nsIDOMNode visualNode;
        Node sourceNode;
        InnerDragBuffer.object = null;
        this.onHideTooltip();
        if (this.dropWindow.active) {
            if (!mouseEvent.getAltKey()) {
                this.dropWindow.close();
            } else {
                return new MozillaDropInfo(false, null, 0L);
            }
        }
        if (mouseEvent.getAltKey() && (sourceNode = this.domMapping.getNearSourceNode(visualNode = (nsIDOMNode)(event = (nsIDOMEvent)mouseEvent.queryInterface("{a66b7b80-ff46-bd97-0080-5f8ae38add32}")).getTarget().queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}"))) != null) {
            if (!MODEL_FLAVOR.equals(flavor)) {
                this.dropWindow.flavor = flavor;
            }
            this.dropWindow.active = true;
            this.dropWindow.setEventPosition(mouseEvent.getScreenX(), mouseEvent.getScreenY());
            this.dropWindow.setInitialTargetNode(sourceNode);
            this.dropWindow.open();
            mouseEvent.stopPropagation();
            mouseEvent.preventDefault();
            return new MozillaDropInfo(false, null, 0L);
        }
        boolean canDrop = false;
        nsIDOMNode caretParent = null;
        long caretOffset = 0L;
        if (MODEL_FLAVOR.equals(flavor)) {
            XModelObject object = PreferenceModelUtilities.getPreferenceModel().getModelBuffer().source();
            if (object.getFileType() == 1 && !TLDUtil.isTaglib((XModelObject)object)) {
                IFile f = (IFile)EclipseResourceUtil.getResource((XModelObject)object);
                canDrop = f != null;
                VpeVisualInnerDropInfo visualDropInfo = this.selectionBuilder.getInnerDropInfo((nsIDOMEvent)mouseEvent);
                caretParent = visualDropInfo.getDropContainer();
                caretOffset = visualDropInfo.getDropOffset();
            } else {
                VpeVisualInnerDropInfo newVisualDropInfo;
                VpeSourceInnerDropInfo sourceDropInfo;
                String tagname = this.getTagName(object);
                if (tagname.indexOf("taglib") >= 0) {
                    tagname = "taglib";
                }
                Element sourceDragNode = ((Document)this.getModel().getAdapter(Document.class)).createElement(tagname);
                VpeVisualInnerDropInfo visualDropInfo = this.selectionBuilder.getInnerDropInfo((nsIDOMEvent)mouseEvent);
                if (visualDropInfo.getDropContainer() != null && (canDrop = (sourceDropInfo = this.visualBuilder.getSourceInnerDropInfo(sourceDragNode, visualDropInfo, true)).canDrop()) && (newVisualDropInfo = this.visualBuilder.getInnerDropInfo(sourceDropInfo.getContainer(), sourceDropInfo.getOffset())) != null) {
                    this.visualBuilder.correctVisualDropPosition(newVisualDropInfo, visualDropInfo);
                    caretParent = newVisualDropInfo.getDropContainer();
                    caretOffset = newVisualDropInfo.getDropOffset();
                }
                visualDropInfo.release();
            }
        } else if ("application/x-moz-file".equals(flavor) || "text/x-moz-url".equals(flavor)) {
            VpeVisualInnerDropInfo visualDropInfo = this.selectionBuilder.getInnerDropInfo((nsIDOMEvent)mouseEvent);
            caretParent = visualDropInfo.getDropContainer();
            caretOffset = visualDropInfo.getDropOffset();
            canDrop = true;
        }
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.println("  canDrop: " + canDrop + (canDrop ? "  container: " + caretParent.getNodeName() + "  offset: " + caretOffset : ""));
        }
        return new MozillaDropInfo(canDrop, caretParent, caretOffset);
    }

    public VpeSourceInnerDropInfo canExternalDropMacro(XModelObject object, Node parentNode, int offset) {
        String tagname = this.getTagName(object);
        Element sourceDragNode = ((Document)this.getModel().getAdapter(Document.class)).createElement(tagname);
        return this.visualBuilder.getSourceInnerDropInfo(sourceDragNode, parentNode, offset, false);
    }

    public void externalDropAny(String flavor, String data, Point range, Node container) {
        if (flavor == null || flavor.length() == 0) {
            return;
        }
        IDropCommand dropCommand = DropCommandFactory.getInstance().getDropCommand(flavor, (ITagProposalFactory)JSPTagProposalFactory.getInstance());
        boolean promptAttributes = JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Ask for tag attributes during tag insert");
        dropCommand.getDefaultModel().setPromptForTagAttributesRequired(promptAttributes);
        DropData dropData = new DropData(flavor, data, this.sourceEditor.getEditorInput(), (ISourceViewer)this.sourceEditor.getAdapter(ISourceViewer.class), (ISelectionProvider)new VpeSelectionProvider(range.x, range.y), container);
        if (this.sourceEditor instanceof JSPTextEditor) {
            dropData.setValueProvider(((JSPTextEditor)this.sourceEditor).createAttributeDescriptorValueProvider());
        }
        dropCommand.execute(dropData);
    }

    private String getTagName(XModelObject object) {
        String tagname = object.getAttributeValue("name");
        XModelObject parent = object.getParent();
        String uri = parent == null ? "" : parent.getAttributeValue("library uri");
        String defaultPrefix = parent == null ? "" : parent.getAttributeValue("default prefix");
        String[] texts = new String[]{"<" + tagname + ">"};
        JSPPaletteInsertHelper.applyPrefix((String[])texts, (ITextEditor)this.sourceEditor, (String)tagname, (String)uri, (String)defaultPrefix);
        tagname = texts[0].substring(1, texts[0].length() - 1);
        return tagname;
    }

    @Override
    public void externalDrop(nsIDOMMouseEvent mouseEvent, String flavor, String data) {
        this.onHideTooltip();
        VpeVisualInnerDropInfo visualDropInfo = this.selectionBuilder.getInnerDropInfo((nsIDOMEvent)mouseEvent);
        Point range = this.selectionBuilder.getSourceSelectionRangeAtVisualNode(visualDropInfo.getDropContainer(), (int)visualDropInfo.getDropOffset());
        DndUtil.DragTransferData dragTransferData = DndUtil.getDragTransferData();
        nsISupports aValue = dragTransferData.getValue();
        String aFlavor = "";
        if (VpeDndUtil.isNsIFileInstance(aValue)) {
            nsIFile aFile = (nsIFile)aValue.queryInterface("{c8c0a080-0868-11d3-915f-d9d889d48e3c}");
            String path = aFile.getPath();
            data = path != null ? DropUtils.convertPathToUrl((String)path) : null;
            aFlavor = "application/x-moz-file";
        } else if (VpeDndUtil.isNsICStringInstance(aValue)) {
            nsISupportsCString aString = (nsISupportsCString)aValue.queryInterface("{d65ff270-4a1c-11d3-9890-006008962422}");
            data = aString.getData();
            aFlavor = "text/html";
        } else if (VpeDndUtil.isNsIStringInstance(aValue)) {
            nsISupportsString aString = (nsISupportsString)aValue.queryInterface("{d79dc970-4a1c-11d3-9890-006008962422}");
            data = aString.getData();
            aFlavor = MODEL_FLAVOR.equals(dragTransferData.getFlavor()) ? dragTransferData.getFlavor() : "text/x-moz-url";
        }
        if (visualDropInfo.getDropContainer() != null && data != null) {
            if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
                System.out.println("  drop!  container: " + visualDropInfo.getDropContainer().getNodeName());
            }
            this.externalDropAny(aFlavor, data, range, null);
        }
    }

    @Override
    public void onShowTooltip(int x, int y, String text) {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        Display display = this.visualEditor.getControl().getDisplay();
        Shell parent = this.visualEditor.getControl().getShell();
        this.tip = new Shell(parent, 540672);
        Color bckgColor = new Color((Device)this.tip.getDisplay(), 255, 250, 236);
        this.tip.setBackground(bckgColor);
        Shell composite = this.tip;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        final StyledText tipControlHeaderText = new StyledText((Composite)composite, 10);
        tipControlHeaderText.setForeground(bckgColor);
        tipControlHeaderText.setBackground(bckgColor);
        String formatText = text.trim();
        String[] attributeString = formatText.split("\n");
        String[] buffer = attributeString[0].split(" ");
        tipControlHeaderText.setText(buffer[0].toString());
        tipControlHeaderText.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                Color color = new Color((Device)tipControlHeaderText.getDisplay(), 201, 51, 40);
                if (event.lineOffset == 0) {
                    StyleRange st = new StyleRange();
                    st.fontStyle = 1;
                    st.foreground = color;
                    event.styles = new StyleRange[]{st};
                    st.start = event.lineOffset;
                    st.length = event.lineText.length();
                }
            }
        });
        GridData gridData = new GridData(1809);
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        tipControlHeaderText.setLayoutData((Object)gridData);
        StringBuffer tempAttr = new StringBuffer();
        StringBuffer tempValue = new StringBuffer();
        if (attributeString.length >= 2) {
            int i = 1;
            while (i < attributeString.length) {
                buffer = attributeString[i].split(" ", 2);
                if (i == 1) {
                    tempAttr.append(String.valueOf(buffer[0]) + " ");
                    tempValue.append(String.valueOf(buffer.length >= 2 ? buffer[1] : "") + " ");
                } else {
                    tempAttr.append("\n" + buffer[0] + " ");
                    tempValue.append(" \n" + (buffer.length >= 2 ? buffer[1] : "") + " ");
                }
                ++i;
            }
            StyledText tipControlAttributeText = new StyledText((Composite)composite, 10);
            tipControlAttributeText.setForeground(bckgColor);
            tipControlAttributeText.setBackground(bckgColor);
            tipControlAttributeText.setText(tempAttr.toString());
            tipControlAttributeText.addLineStyleListener(new LineStyleListener(){

                public void lineGetStyle(LineStyleEvent event) {
                    Color color = new Color((Device)tipControlHeaderText.getDisplay(), 42, 148, 0);
                    StyleRange st = new StyleRange();
                    st.start = event.lineOffset;
                    st.length = event.lineText.length();
                    st.foreground = color;
                    st.fontStyle = 0;
                    event.styles = new StyleRange[]{st};
                }
            });
            GridData gridData1 = new GridData(1809);
            gridData1.horizontalAlignment = 4;
            tipControlAttributeText.setLayoutData((Object)gridData1);
            StyledText tipControlValueText = new StyledText((Composite)composite, 10);
            tipControlValueText.setBackground(bckgColor);
            tipControlValueText.setText(tempValue.toString());
            GridData gridData2 = new GridData(1809);
            gridData2.horizontalAlignment = 4;
            tipControlValueText.setLayoutData((Object)gridData2);
        }
        Point point = display.getCursorLocation();
        point.y += 21;
        this.tip.setLocation(point);
        this.tip.pack();
        this.tip.setVisible(true);
    }

    @Override
    public void onHideTooltip() {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
    }

    public VpePageContext getPageContext() {
        return this.pageContext;
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public FormatControllerManager getToolbarFormatControllerManager() {
        return this.toolbarFormatControllerManager;
    }

    public void setToolbarFormatControllerManager(FormatControllerManager formatControllerManager) {
        this.toolbarFormatControllerManager = formatControllerManager;
    }

    public void setSelectionBarController(SelectionBar selectionBar) {
        this.selectionBar = selectionBar;
    }

    public IStructuredModel getModel() {
        return this.sourceEditor.getModel();
    }

    public VpeDomMapping getDomMapping() {
        return this.domMapping;
    }

    public VpeIncludeList getIncludeList() {
        if (this.includeList == null) {
            VpePlugin.getPluginLog().logError("includeList - NULL!!!");
        }
        return this.includeList;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.selectionBar != null) {
            this.selectionBar.updateNodes(false);
        }
        if (!this.isVisualEditorVisible()) {
            return;
        }
        if (this.editPart.getVisualMode() != 1 && this.toolbarFormatControllerManager != null) {
            this.toolbarFormatControllerManager.selectionChanged();
        }
        if (!this.switcher.startActiveEditor(2)) {
            return;
        }
        try {
            if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                System.out.println(">>>>>>>>>>>>>> selectionChanged  " + event.getSource());
            }
            this.sourceSelectionChanged();
        }
        finally {
            this.switcher.stopActiveEditor();
        }
    }

    @Override
    public void onPasteOrDrop(nsIDOMMouseEvent mouseEvent, String flavor, String data) {
        this.onHideTooltip();
        VpeVisualInnerDropInfo visualDropInfo = this.selectionBuilder.getInnerDropInfo((nsIDOMEvent)mouseEvent);
        Point range = this.selectionBuilder.getSourceSelectionRangeAtVisualNode(visualDropInfo.getDropContainer(), (int)visualDropInfo.getDropOffset());
        VpeSourceInnerDropInfo sourceDropInfo = null;
        XModelObject object = PreferenceModelUtilities.getPreferenceModel().getModelBuffer().source();
        String tagname = this.getTagName(object);
        if (tagname.indexOf("taglib") >= 0) {
            tagname = "taglib";
        }
        Element sourceDragNode = ((Document)this.getModel().getAdapter(Document.class)).createElement(tagname);
        if (visualDropInfo.getDropContainer() != null) {
            sourceDropInfo = this.visualBuilder.getSourceInnerDropInfo(sourceDragNode, visualDropInfo, true);
            range = this.selectionBuilder.getSourceSelectionRange(sourceDropInfo.getContainer(), sourceDropInfo.getOffset());
        }
        if (visualDropInfo.getDropContainer() != null) {
            if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
                System.out.println("  drop!  container: " + visualDropInfo.getDropContainer().getNodeName());
            }
            final String finalFlavor = flavor;
            final String finalData = data;
            final Point finalRange = range;
            final Node finalDropContainer = sourceDropInfo == null ? null : sourceDropInfo.getContainer();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    VpeController.this.externalDropAny(finalFlavor, finalData, finalRange, finalDropContainer);
                }
            });
        }
    }

    public void drop(Node node, Node parentNode, int offset) {
        this.visualBuilder.innerDrop(node, parentNode, offset);
    }

    public nsISupports queryInterface(String arg0) {
        Mozilla.getInstance();
        return Mozilla.queryInterface((nsISupports)this, (String)arg0);
    }

    @Override
    public void onRefresh() {
        Display.getDefault().asyncExec((Runnable)new Thread(){

            public void run() {
                if (VpeController.this.getXulRunnerEditor() != null) {
                    VpeController.this.getXulRunnerEditor().showSelectionRectangle();
                }
            }
        });
    }

    public XulRunnerEditor getXulRunnerEditor() {
        return this.xulRunnerEditor;
    }

    public void setXulRunnerEditor(XulRunnerEditor xulRunnerEditor) {
        this.xulRunnerEditor = xulRunnerEditor;
    }

    @Override
    public void startDragSession(nsIDOMEvent domEvent) {
        this.visualBuilder.getDnd().startDragSession(domEvent);
    }

    @Override
    public void dragDrop(nsIDOMEvent domEvent) {
        this.visualBuilder.getDnd().dragDrop(domEvent, this);
    }

    public VpeSelectionBuilder getSelectionBuilder() {
        return this.selectionBuilder;
    }

    public void setSelectionBuilder(VpeSelectionBuilder selectionBuilder) {
        this.selectionBuilder = selectionBuilder;
    }

    public boolean isVisualEditorVisible() {
        return this.visualEditorVisible;
    }

    public void setVisualEditorVisible(boolean visualEditorVisible) {
        this.visualEditorVisible = visualEditorVisible;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }

    public LinkedList<VpeEventBean> getChangeEvents() {
        if (this.changeEvents == null) {
            this.changeEvents = new LinkedList();
        }
        return this.changeEvents;
    }

    public void reinit() {
        if (this.reinitJob != null) {
            this.reinitJob.cancel();
        }
        this.reinitJob = new UIJob(VpeUIMessages.VPE_VISUAL_REFRESH_JOB){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                VpeController.this.reinitImpl();
                return Status.OK_STATUS;
            }
        };
        this.reinitJob.schedule();
    }

    private void reinitImpl() {
        try {
            if (this.switcher == null || !this.switcher.startActiveEditor(2)) {
                return;
            }
            try {
                this.visualEditor.reinitDesignMode();
                this.visualBuilder.setSelectionRectangle(null);
                this.visualEditor.setEditorDomEventListener(this);
                IDOMModel sourceModel = (IDOMModel)this.getModel();
                if (sourceModel != null) {
                    IDOMDocument sourceDocument = sourceModel.getDocument();
                    this.visualBuilder.rebuildDom((Document)sourceDocument);
                } else {
                    this.visualBuilder.rebuildDom(null);
                }
                this.visualSelectionController = new VpeSelectionController(this.visualEditor.getEditor().getSelectionController());
                this.selectionBuilder = new VpeSelectionBuilder(this.domMapping, this.sourceBuilder, this.visualBuilder, this.visualSelectionController);
                this.selectionManager = new SelectionManager(this.pageContext, this.sourceEditor, this.visualSelectionController);
                this.keyEventHandler = new KeyEventManager(this.sourceEditor, this.domMapping, this.pageContext);
                float currentZoom = this.zoomEventManager.getCurrentZoom();
                this.zoomEventManager = new ZoomEventManager(this.getXulRunnerEditor());
                this.zoomEventManager.setCurrentZoom(currentZoom);
                ((KeyEventManager)this.keyEventHandler).setZoomEventManager(this.zoomEventManager);
                this.sourceSelectionChanged();
            }
            catch (VpeDisposeException vpeDisposeException) {}
        }
        finally {
            if (this.switcher != null) {
                this.switcher.stopActiveEditor();
            }
        }
    }

    public VpeSelectionController getVisualSelectionController() {
        return this.visualSelectionController;
    }

    public VpeSourceDomBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    public VpeVisualDomBuilder getVisualBuilder() {
        return this.visualBuilder;
    }

    private int getVpeUpdateDelayTime() {
        return this.vpeUpdateDelayTime;
    }

    private void setVpeUpdateDelayTime(int vpeUpdateDelayTime) {
        this.vpeUpdateDelayTime = vpeUpdateDelayTime;
    }

    public ISelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void updateVpeToolbar() {
        this.visualEditor.updateShowSelectionBarItem(this.selectionBar.isVisible());
    }

    public IZoomEventManager getZoomEventManager() {
        return this.zoomEventManager;
    }

    public void setZoomEventManager(IZoomEventManager zoomEventManager) {
        this.zoomEventManager = zoomEventManager;
    }

    private class ActiveEditorSwitcher {
        private static final int ACTIVE_EDITOR_CANNOT = 0;
        private static final int ACTIVE_EDITOR_NONE = 1;
        private static final int ACTIVE_EDITOR_SOURCE = 2;
        private static final int ACTIVE_EDITOR_VISUAL = 3;
        private int type = 0;

        private ActiveEditorSwitcher() {
        }

        private void initActiveEditor() {
            this.type = 1;
        }

        private void destroyActiveEditor() {
            this.type = 0;
        }

        private boolean startActiveEditor(int newType) {
            if (this.type == 1) {
                if (newType == 2 && VpeController.this.editPart.getVisualMode() == 1) {
                    return false;
                }
                this.type = newType;
                return true;
            }
            return false;
        }

        private void stopActiveEditor() {
            VpeController.this.onRefresh();
            this.type = 1;
        }
    }

    class VpeSelection
    implements ITextSelection {
        String text = "";
        int offset;
        int length;

        public VpeSelection(int position) {
            this.offset = position;
            this.length = 0;
        }

        public VpeSelection(int offset, int length) {
            this.offset = offset;
            this.length = length;
            if (length > 0) {
                try {
                    this.text = VpeController.this.sourceEditor.getTextViewer().getDocument().get(offset, length);
                }
                catch (BadLocationException e) {
                    VpePlugin.getPluginLog().logError((Throwable)e);
                }
            }
        }

        public VpeSelection(IndexedRegion region) {
            this.offset = region.getStartOffset();
            this.length = region.getEndOffset() - this.offset;
            try {
                this.text = VpeController.this.sourceEditor.getTextViewer().getDocument().get(this.offset, this.length);
            }
            catch (BadLocationException ex) {
                VpePlugin.reportProblem((Exception)((Object)ex));
            }
        }

        public int getEndLine() {
            return 0;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getStartLine() {
            return 0;
        }

        public String getText() {
            return this.text;
        }

        public boolean isEmpty() {
            return false;
        }
    }

    class VpeSelectionProvider
    implements ISelectionProvider {
        VpeSelection selection;

        public VpeSelectionProvider(IndexedRegion region) {
            this.selection = new VpeSelection(region);
        }

        public VpeSelectionProvider(int position) {
            this.selection = new VpeSelection(position);
        }

        public VpeSelectionProvider(int offset, int length) {
            this.selection = new VpeSelection(offset, length);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(ISelection selection) {
        }
    }
}

