/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.dnd;

import org.jboss.tools.vpe.dnd.ScrollingSupport;
import org.jboss.tools.vpe.editor.VpeController;
import org.jboss.tools.vpe.editor.VpeVisualCaretInfo;
import org.jboss.tools.vpe.editor.mozilla.EditorDomEventListener;
import org.jboss.tools.vpe.editor.mozilla.MozillaDropInfo;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDragService;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsISupportsArray;
import org.mozilla.interfaces.nsISupportsString;
import org.mozilla.interfaces.nsITransferable;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class VpeDnD {
    private static final String VPE_ELEMENT = "";
    private nsIServiceManager serviceManager;
    private nsIComponentManager componentManager;
    private nsIDragService dragService;

    public void startDragSession(nsIDOMEvent domEvent) {
        nsISupportsArray transArray = (nsISupportsArray)this.getComponentManager().createInstanceByContractID("@mozilla.org/supports-array;1", null, "{791eafa0-b9e6-11d1-8031-006008159b5a}");
        transArray.appendElement((nsISupports)this.createTransferable());
        this.getDragService().invokeDragSession((nsIDOMNode)domEvent.getTarget().queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}"), transArray, null, 7L);
        domEvent.stopPropagation();
        domEvent.preventDefault();
    }

    private nsITransferable createTransferable() {
        nsITransferable iTransferable = (nsITransferable)this.getComponentManager().createInstanceByContractID("@mozilla.org/widget/transferable;1", null, "{8b5314bc-db01-11d2-96ce-0060b0fb9956}");
        nsISupportsString transferData = (nsISupportsString)this.getComponentManager().createInstanceByContractID("@mozilla.org/supports-string;1", null, "{d79dc970-4a1c-11d3-9890-006008962422}");
        String data = VPE_ELEMENT;
        transferData.setData(data);
        iTransferable.setTransferData("vpe/model", (nsISupports)transferData, (long)data.length());
        iTransferable.setTransferData("text/plain", (nsISupports)transferData, (long)data.length());
        iTransferable.setTransferData("text/unicode", (nsISupports)transferData, (long)(data.length() * 2));
        iTransferable.setTransferData("text/html", (nsISupports)transferData, (long)(data.length() * 2));
        iTransferable.setTransferData("text/xml", (nsISupports)transferData, (long)(data.length() * 2));
        iTransferable.setTransferData("text/rtf", (nsISupports)transferData, (long)(data.length() * 2));
        iTransferable.setTransferData("text/enriched", (nsISupports)transferData, (long)(data.length() * 2));
        iTransferable.setTransferData("text/richtext", (nsISupports)transferData, (long)(data.length() * 2));
        iTransferable.setTransferData("text/t140", (nsISupports)transferData, (long)(data.length() * 2));
        return iTransferable;
    }

    public nsIComponentManager getComponentManager() {
        if (this.componentManager == null) {
            this.componentManager = Mozilla.getInstance().getComponentManager();
        }
        return this.componentManager;
    }

    public nsIServiceManager getServiceManager() {
        if (this.serviceManager == null) {
            this.serviceManager = Mozilla.getInstance().getServiceManager();
        }
        return this.serviceManager;
    }

    public nsIDragService getDragService() {
        if (this.dragService == null) {
            this.dragService = (nsIDragService)this.getServiceManager().getServiceByContractID("@mozilla.org/widget/dragservice;1", "{82b58ada-f490-4c3d-b737-1057c4f1d052}");
        }
        return this.dragService;
    }

    public void dragOver(nsIDOMEvent event, EditorDomEventListener editorDomEventListener) {
        nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)event.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
        XulRunnerEditor editor = ((VpeController)editorDomEventListener).getXulRunnerEditor();
        new ScrollingSupport(editor).scroll(mouseEvent);
        this.refreshCanDrop(event, editorDomEventListener);
    }

    private void refreshCanDrop(nsIDOMEvent event, EditorDomEventListener editorDomEventListener) {
        MozillaDropInfo info;
        boolean canDrop = true;
        nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)event.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}");
        if (editorDomEventListener != null && this.getDragService().getCurrentSession().isDataFlavorSupported("vpe/model") && (info = this.getDragService().getCurrentSession().getSourceNode() == null ? editorDomEventListener.canExternalDrop(mouseEvent, "vpe/model", VPE_ELEMENT) : editorDomEventListener.canInnerDrop(mouseEvent)) != null) {
            canDrop = info.canDrop();
        }
        VpeController controller = (VpeController)editorDomEventListener;
        VpeSelectionController selectionController = controller.getVisualSelectionController();
        VpeVisualCaretInfo visualCaretInfo = controller.getSelectionBuilder().getVisualCaretInfo(event);
        nsIDOMEventTarget target = event.getTarget();
        nsIDOMNode targetDomNode = (nsIDOMNode)target.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
        try {
            if (targetDomNode.getFirstChild() != null && targetDomNode.getFirstChild().getNodeType() == 3) {
                selectionController.getSelection((short)1).collapse(targetDomNode.getFirstChild(), visualCaretInfo.getRageOffset());
            } else if (targetDomNode.getNodeType() != 3) {
                selectionController.getSelection((short)1).collapse(targetDomNode, 0);
            }
        }
        catch (XPCOMException xPCOMException) {
            event.stopPropagation();
            event.preventDefault();
        }
        this.getDragService().getCurrentSession().setCanDrop(canDrop);
        mouseEvent.preventDefault();
        mouseEvent.stopPropagation();
    }

    public void dragDrop(nsIDOMEvent domEvent, EditorDomEventListener editorDomEventListener) {
        if (editorDomEventListener != null) {
            if (this.getDragService().getCurrentSession().getSourceDocument() == null) {
                editorDomEventListener.externalDrop((nsIDOMMouseEvent)domEvent.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}"), "vpe/model", VPE_ELEMENT);
            } else {
                editorDomEventListener.innerDrop((nsIDOMMouseEvent)domEvent.queryInterface("{ff751edc-8b02-aae7-0010-8301838a3123}"));
            }
        }
    }
}

