/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IStartup;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.jboss.tools.common.log.IPluginLog;
import org.jboss.tools.common.reporting.ProblemReportingHelper;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.editor.util.ProjectNaturesChecker;
import org.jboss.tools.vpe.xulrunner.browser.XulRunnerBrowser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class VpePlugin
extends BaseUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.jboss.tools.vpe";
    public static final String EXTESION_POINT_VPE_TEMPLATES = "org.jboss.tools.vpe.templates";
    public static final String EXTESION_POINT_LOCALE_PROVIDER = "org.jboss.tools.vpe.localeProvider";
    private static VpePlugin plugin;

    public VpePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        ProjectNaturesChecker naturesChecker = ProjectNaturesChecker.getInstance();
        naturesChecker.dispose();
        naturesChecker = null;
        super.stop(context);
    }

    public static VpePlugin getDefault() {
        return plugin;
    }

    public static void reportProblem(Exception throwable) {
        if (VpeDebug.USE_PRINT_STACK_TRACE) {
            throwable.printStackTrace();
        }
        ProblemReportingHelper.reportProblem((String)PLUGIN_ID, (Throwable)throwable);
    }

    public String getResourcePath(String resourceName) {
        URL url;
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        if (bundle != null && (url = bundle.getEntry(resourceName)) != null) {
            try {
                return FileLocator.resolve((URL)url).getPath();
            }
            catch (IOException ioe) {
                this.logError(ioe);
            }
        }
        return null;
    }

    public static IPluginLog getPluginLog() {
        return VpePlugin.getDefault();
    }

    public void earlyStartup() {
        try {
            String xulRunnerPath = XulRunnerBrowser.getXulRunnerPath();
            if ("true".equals(Platform.getDebugOption((String)"org.jboss.tools.vpe/debug/earlyStartup"))) {
                this.logInfo("earlyStartup: XULRunner path is: " + xulRunnerPath);
            }
        }
        catch (Throwable throwable) {}
    }

    public static String getPluginResourcePath() {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL url = null;
        try {
            url = bundle == null ? null : FileLocator.resolve((URL)bundle.getEntry("/ve"));
        }
        catch (IOException e) {
            VpePlugin.getPluginLog().logError((Throwable)e);
        }
        return url == null ? null : url.getPath();
    }
}

