/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.firstrun;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.IStartup;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.jboss.tools.jst.firstrun.JstFirstRunPlugin;
import org.jboss.tools.jst.firstrun.Messages;

public class JBossASAdapterInitializer
implements IStartup {
    public static final String JBOSS_AS_HOME = "../../../../jboss-eap/jboss-as";
    public static final String SERVERS_FILE = "../../../../studio/application_platforms.properties";
    public static final String[] JBOSS_AS_RUNTIME_TYPE_ID = new String[]{"org.jboss.ide.eclipse.as.runtime.32", "org.jboss.ide.eclipse.as.runtime.40", "org.jboss.ide.eclipse.as.runtime.42", "org.jboss.ide.eclipse.as.runtime.50"};
    public static final String[] JBOSS_AS_TYPE_ID = new String[]{"org.jboss.ide.eclipse.as.32", "org.jboss.ide.eclipse.as.40", "org.jboss.ide.eclipse.as.42", "org.jboss.ide.eclipse.as.50"};
    public static final String[] JBOSS_AS_NAME = new String[]{Messages.JBossASAdapterInitializer_AppServer32, Messages.JBossASAdapterInitializer_AppServer40, Messages.JBossASAdapterInitializer_AppServer42, Messages.JBossASAdapterInitializer_AppServer50};
    private static final int installedASIndex = 2;
    public static final String JBOSS_AS_HOST = "localhost";
    public static final String JBOSS_AS_DEFAULT_CONFIGURATION_NAME = "default";
    public static final String FIRST_START_PREFERENCE_NAME = "FIRST_START";
    public static final String HSQL_DRIVER_DEFINITION_ID = "DriverDefn.Hypersonic DB";
    public static final String HSQL_DRIVER_NAME = "Hypersonic DB";
    public static final String HSQL_DRIVER_TEMPLATE_ID = "org.eclipse.datatools.enablement.hsqldb.1_8.driver";
    public static final String DTP_DB_URL_PROPERTY_ID = "org.eclipse.datatools.connectivity.db.URL";
    private static boolean driverIsCreated = false;

    public void earlyStartup() {
        try {
            JstFirstRunPlugin.getDefault().getPreferenceStore().setDefault(FIRST_START_PREFERENCE_NAME, true);
            boolean firstStart = JstFirstRunPlugin.getDefault().getPreferenceStore().getBoolean(FIRST_START_PREFERENCE_NAME);
            if (!firstStart) {
                return;
            }
            JstFirstRunPlugin.getDefault().getPreferenceStore().setValue(FIRST_START_PREFERENCE_NAME, false);
            String pluginLocation = FileLocator.resolve((URL)JstFirstRunPlugin.getDefault().getBundle().getEntry("/")).getPath();
            File serversFile = new File(pluginLocation, SERVERS_FILE).getCanonicalFile();
            if (serversFile.exists()) {
                Properties servers = new Properties();
                servers.load(new BufferedInputStream(new FileInputStream(serversFile)));
                for (Object iterable_element : servers.keySet()) {
                    IRuntime runtime;
                    String str = servers.getProperty(iterable_element.toString());
                    String jbossASLocation = null;
                    String[] params = str.split(",");
                    String name = params[0];
                    String type = params[1];
                    String version = params[2];
                    jbossASLocation = params[3].trim();
                    int index = 0;
                    if (type.startsWith("AS")) {
                        if (version.startsWith("3.2")) {
                            index = 0;
                        } else if (version.startsWith("4.0")) {
                            index = 1;
                        } else if (version.startsWith("4.2") || version.startsWith("4.3")) {
                            index = 2;
                        } else if (version.startsWith("5.0")) {
                            index = 3;
                        }
                    } else {
                        index = 2;
                    }
                    if (!"AS".equals(type)) {
                        jbossASLocation = String.valueOf(jbossASLocation) + File.separatorChar + "jboss-as";
                    }
                    if ((runtime = JBossASAdapterInitializer.createRuntime(MessageFormat.format(Messages.JBossASAdapterInitializer_Runtime, name), jbossASLocation, (IProgressMonitor)new NullProgressMonitor(), index)) != null) {
                        JBossASAdapterInitializer.createServer((IProgressMonitor)new NullProgressMonitor(), runtime, index, name);
                    }
                    JBossASAdapterInitializer.createDriver(jbossASLocation);
                }
            }
            String jbossASLocation = null;
            File jbossASDir = new File(pluginLocation, JBOSS_AS_HOME).getCanonicalFile();
            if (!jbossASDir.isDirectory()) {
                return;
            }
            jbossASLocation = jbossASDir.getAbsolutePath();
            Path jbossAsLocationPath = new Path(jbossASLocation);
            IServer[] servers = ServerCore.getServers();
            int i = 0;
            while (i < servers.length) {
                IRuntime runtime = servers[i].getRuntime();
                if (runtime != null && runtime.getLocation().equals((Object)jbossAsLocationPath)) {
                    return;
                }
                ++i;
            }
            IRuntime runtime = null;
            IRuntime[] runtimes = ServerCore.getRuntimes();
            int i2 = 0;
            while (i2 < runtimes.length) {
                if (runtimes[0].getLocation().equals((Object)jbossASLocation)) {
                    runtime = runtimes[0].createWorkingCopy();
                    break;
                }
                ++i2;
            }
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            if (runtime == null) {
                runtime = JBossASAdapterInitializer.createRuntime(null, jbossASLocation, (IProgressMonitor)progressMonitor, 2);
            }
            if (runtime != null) {
                JBossASAdapterInitializer.createServer((IProgressMonitor)progressMonitor, runtime, 2, null);
            }
            JBossASAdapterInitializer.createDriver(jbossASLocation);
        }
        catch (CoreException e) {
            JstFirstRunPlugin.getPluginLog().log((IStatus)new Status(4, "org.jboss.tools.jst.firstrun", Messages.JBossASAdapterInitializer_CannotCreateServer, (Throwable)e));
        }
        catch (IOException e) {
            JstFirstRunPlugin.getPluginLog().log((IStatus)new Status(4, "org.jboss.tools.jst.firstrun", Messages.JBossASAdapterInitializer_CannotCreateServer, (Throwable)e));
        }
        catch (ConnectionProfileException e) {
            JstFirstRunPlugin.getPluginLog().log((IStatus)new Status(4, "org.jboss.tools.jst.firstrun", Messages.JBossASAdapterInitializer_CannotCreateProfile, (Throwable)e));
        }
    }

    public static IServerWorkingCopy initJBossAS(String jbossASLocation, IProgressMonitor progressMonitor) throws CoreException, ConnectionProfileException {
        IRuntime runtime = JBossASAdapterInitializer.createRuntime(null, jbossASLocation, progressMonitor, 2);
        IServerWorkingCopy server = null;
        if (runtime != null) {
            server = JBossASAdapterInitializer.createServer(progressMonitor, runtime, 2, null);
        }
        JBossASAdapterInitializer.createDriver(jbossASLocation);
        return server;
    }

    private static IRuntime createRuntime(String runtimeName, String jbossASLocation, IProgressMonitor progressMonitor, int index) throws CoreException {
        IRuntimeWorkingCopy runtime = null;
        String type = null;
        String version = null;
        String runtimeId = null;
        Path jbossAsLocationPath = new Path(jbossASLocation);
        IRuntimeType[] runtimeTypes = ServerUtil.getRuntimeTypes(type, version, (String)JBOSS_AS_RUNTIME_TYPE_ID[index]);
        if (runtimeTypes.length > 0) {
            runtime = runtimeTypes[0].createRuntime(runtimeId, progressMonitor);
            runtime.setLocation((IPath)jbossAsLocationPath);
            if (runtimeName != null) {
                runtime.setName(runtimeName);
            }
            IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
            ((RuntimeWorkingCopy)runtime).setAttribute("PROPERTY_VM_ID", defaultVM.getId());
            ((RuntimeWorkingCopy)runtime).setAttribute("PROPERTY_VM_TYPE_ID", defaultVM.getVMInstallType().getId());
            ((RuntimeWorkingCopy)runtime).setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", JBOSS_AS_DEFAULT_CONFIGURATION_NAME);
            return runtime.save(false, progressMonitor);
        }
        return runtime;
    }

    private static IServerWorkingCopy createServer(IProgressMonitor progressMonitor, IRuntime runtime, int index, String name) throws CoreException {
        IServerType serverType = ServerCore.findServerType((String)JBOSS_AS_TYPE_ID[index]);
        IServerWorkingCopy server = serverType.createServer(null, null, runtime, progressMonitor);
        server.setHost(JBOSS_AS_HOST);
        if (name != null) {
            server.setName(name);
        } else {
            server.setName(JBOSS_AS_NAME[2]);
        }
        String deployVal = runtime.getLocation().append("server").append(JBOSS_AS_DEFAULT_CONFIGURATION_NAME).append("deploy").toOSString();
        ((ServerWorkingCopy)server).setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", deployVal);
        String deployTmpFolderVal = runtime.getLocation().append("server").append(JBOSS_AS_DEFAULT_CONFIGURATION_NAME).append("tmp").append("jbosstoolsTemp").toOSString();
        ((ServerWorkingCopy)server).setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", deployTmpFolderVal);
        server.save(false, progressMonitor);
        return server;
    }

    private static void createDriver(String jbossASLocation) throws ConnectionProfileException {
        String driverPath;
        if (driverIsCreated) {
            return;
        }
        try {
            driverPath = new File(String.valueOf(jbossASLocation) + "/server/default/lib/hsqldb.jar").getCanonicalPath();
        }
        catch (IOException e) {
            JstFirstRunPlugin.getPluginLog().log((IStatus)new Status(4, "org.jboss.tools.jst.firstrun", Messages.JBossASAdapterInitializer_CannotCreateDriver, (Throwable)e));
            return;
        }
        DriverInstance driver = DriverManager.getInstance().getDriverInstanceByName(HSQL_DRIVER_NAME);
        if (driver == null) {
            TemplateDescriptor descr = TemplateDescriptor.getDriverTemplateDescriptor((String)HSQL_DRIVER_TEMPLATE_ID);
            PropertySetImpl instance = new PropertySetImpl(HSQL_DRIVER_NAME, HSQL_DRIVER_DEFINITION_ID);
            instance.setName(HSQL_DRIVER_NAME);
            instance.setID(HSQL_DRIVER_DEFINITION_ID);
            Properties props = new Properties();
            IConfigurationElement[] template = descr.getProperties();
            int i = 0;
            while (i < template.length) {
                IConfigurationElement prop = template[i];
                String id = prop.getAttribute("id");
                String value = prop.getAttribute("value");
                props.setProperty(id, value == null ? "" : value);
                ++i;
            }
            props.setProperty(DTP_DB_URL_PROPERTY_ID, "jdbc:hsqldb:.");
            props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", descr.getId());
            props.setProperty("jarList", driverPath);
            instance.setBaseProperties(props);
            DriverManager.getInstance().removeDriverInstance(instance.getID());
            System.gc();
            DriverManager.getInstance().addDriverInstance((IPropertySet)instance);
        }
        if ((driver = DriverManager.getInstance().getDriverInstanceByName(HSQL_DRIVER_NAME)) != null && ProfileManager.getInstance().getProfileByName("DefaultDS") == null) {
            Properties props = new Properties();
            props.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", HSQL_DRIVER_DEFINITION_ID);
            props.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", "");
            props.setProperty("org.eclipse.datatools.connectivity.db.driverClass", driver.getProperty("org.eclipse.datatools.connectivity.db.driverClass"));
            props.setProperty("org.eclipse.datatools.connectivity.db.vendor", driver.getProperty("org.eclipse.datatools.connectivity.db.vendor"));
            props.setProperty("org.eclipse.datatools.connectivity.db.version", driver.getProperty("org.eclipse.datatools.connectivity.db.version"));
            props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", "Default");
            props.setProperty("org.eclipse.datatools.connectivity.db.password", "");
            props.setProperty("org.eclipse.datatools.connectivity.db.savePWD", "false");
            props.setProperty("org.eclipse.datatools.connectivity.db.username", driver.getProperty("org.eclipse.datatools.connectivity.db.username"));
            props.setProperty(DTP_DB_URL_PROPERTY_ID, driver.getProperty(DTP_DB_URL_PROPERTY_ID));
            ProfileManager.getInstance().createProfile("DefaultDS", Messages.JBossASAdapterInitializer_JBossASHypersonicEmbeddedDB, "org.eclipse.datatools.connectivity.db.generic.connectionProfile", props, "", false);
        }
        if (driver != null) {
            driverIsCreated = true;
        }
    }
}

