/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.gef.outline.xpl;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.jboss.tools.common.gef.outline.xpl.GEFUIMessages;

public class DiagramContentOutlinePage
extends ContentOutlinePage
implements IAdaptable {
    private static String OUTLINE_ICON_PATH = "outline.gif";
    private static String OVERVIEW_ICON_PATH = "overview.gif";
    private org.eclipse.ui.views.contentoutline.ContentOutlinePage poutline;
    private GraphicalViewer graphicalViewer;
    private SelectionSynchronizer selectionSynchronizer;
    private PageBook pageBook;
    private Control outline;
    private Canvas overview;
    private IAction showOutlineAction;
    private IAction showOverviewAction;
    static final int ID_OUTLINE = 0;
    static final int ID_OVERVIEW = 1;
    private Thumbnail thumbnail;
    IPageSite pSite;

    public DiagramContentOutlinePage(EditPartViewer viewer) {
        super(viewer);
    }

    public void setTreeOutline(org.eclipse.ui.views.contentoutline.ContentOutlinePage poutline) {
        this.poutline = poutline;
    }

    public void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    public void setSelectionSynchronizer(SelectionSynchronizer selectionSynchronizer) {
        this.selectionSynchronizer = selectionSynchronizer;
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return this.selectionSynchronizer;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.pSite = pageSite;
    }

    protected void configureOutlineViewer() {
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        IMenuManager mm = this.getSite().getActionBars().getMenuManager();
        this.showOutlineAction = new Action(){

            public void run() {
                DiagramContentOutlinePage.this.showPage(0);
            }
        };
        this.showOutlineAction.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)OUTLINE_ICON_PATH));
        this.showOutlineAction.setToolTipText(GEFUIMessages.TREE);
        tbm.add(this.showOutlineAction);
        this.showOutlineAction.setText(GEFUIMessages.SHOW_TREE);
        mm.add(this.showOutlineAction);
        this.showOverviewAction = new Action(){

            public void run() {
                DiagramContentOutlinePage.this.showPage(1);
            }
        };
        this.showOverviewAction.setToolTipText(GEFUIMessages.DIAGRAM_NAVIGATOR);
        this.showOverviewAction.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)OVERVIEW_ICON_PATH));
        tbm.add(this.showOverviewAction);
        this.showOverviewAction.setText(GEFUIMessages.SHOW_DIAGRAM_NAVIGATOR);
        mm.add(this.showOverviewAction);
        this.showPage(0);
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.poutline.init(this.pSite);
        this.poutline.createControl((Composite)this.pageBook);
        this.outline = this.poutline.getControl();
        this.overview = new Canvas((Composite)this.pageBook, 0);
        this.pageBook.showPage(this.outline);
        this.configureOutlineViewer();
        this.hookOutlineViewer();
        this.initializeOutlineViewer();
    }

    public void dispose() {
        if (this.poutline != null) {
            this.poutline.dispose();
            this.poutline = null;
        }
        this.unhookOutlineViewer();
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
        }
        super.dispose();
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return null;
    }

    public Control getControl() {
        return this.pageBook;
    }

    protected void hookOutlineViewer() {
        this.getSelectionSynchronizer().addViewer(this.getViewer());
    }

    protected void initializeOutlineViewer() {
    }

    protected void initializeOverview() {
        LightweightSystem lws = new LightweightSystem(this.overview);
        RootEditPart rep = this.getGraphicalViewer().getRootEditPart();
        if (rep instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            this.thumbnail.setBorder((Border)new MarginBorder(3));
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
        }
    }

    protected void showPage(int id) {
        if (id == 0) {
            this.showOutlineAction.setChecked(true);
            this.showOverviewAction.setChecked(false);
            this.pageBook.showPage(this.outline);
            if (this.thumbnail != null) {
                this.thumbnail.setVisible(false);
            }
        } else if (id == 1) {
            if (this.thumbnail == null) {
                this.initializeOverview();
            }
            this.showOutlineAction.setChecked(false);
            this.showOverviewAction.setChecked(true);
            this.pageBook.showPage((Control)this.overview);
            this.thumbnail.setVisible(true);
        }
    }

    protected void unhookOutlineViewer() {
        this.getSelectionSynchronizer().removeViewer(this.getViewer());
    }
}

